<?php

/**
 * This file is part of the froxlor project.
 * Copyright (c) 2010 the froxlor Team (see authors).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can also view it online at
 * https://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  the authors
 * @author     froxlor team <team@froxlor.org>
 * @license    https://files.froxlor.org/misc/COPYING.txt GPLv2
 */

return [
	'languages' => [
		'cz' => 'Czech',
		'de' => 'German',
		'en' => 'English',
		'fr' => 'French',
		'hu' => 'Hungarian',
		'it' => 'Italian',
		'nl' => 'Dutch',
		'pt' => 'Portuguese',
		'se' => 'Swedish',
		'es' => 'Spanish',
		'ca' => 'Catalan',
	],
	'2fa' => [
		'2fa' => '2FA beállítások',
		'2fa_enabled' => 'Kétfaktoros hitelesítés (2FA) aktiválása',
		'2fa_removed' => '2FA sikeresen eltávolítva',
		'2fa_added' => '2FA sikeresen aktiválva<br><a class="alert-link" href="%s?page=2fa">2FA részletek megtekintése</a>',
		'2fa_add' => '2FA aktiválása',
		'2fa_delete' => '2FA deaktiválása',
		'2fa_verify' => 'Kód ellenőrzése',
		'2fa_overview_desc' => 'Itt aktiválhatja a kétfaktoros hitelesítést a fiókjához.<br><br>Használhat hitelesítő alkalmazást (időalapú egyszeri jelszó / TOTP), vagy hagyhatja, hogy a froxlor minden sikeres bejelentkezés után e-mailt küldjön a fiókjához tartozó címre egy egyszeri jelszóval.',
		'2fa_email_desc' => 'Fiókja be van állítva egyszeri jelszavak használatára e-mailen keresztül. A deaktiváláshoz kattintson a "2FA deaktiválása" gombra',
		'2fa_ga_desc' => 'Fiókja be van állítva időalapú egyszeri jelszavak használatára hitelesítő alkalmazáson keresztül. Kérjük, olvassa be az alábbi QR-kódot a kívánt hitelesítő alkalmazással a kódok generálásához. A deaktiváláshoz kattintson a "2FA deaktiválása" gombra',
		'2fa_not_activated' => 'A kétfaktoros hitelesítés nincs engedélyezve',
		'2fa_not_activated_for_user' => 'A kétfaktoros hitelesítés nincs engedélyezve a jelenlegi felhasználó számára',
		'type_2fa' => '2FA állapot',
	],
	'admin' => [
		'overview' => 'Áttekintés',
		'ressourcedetails' => 'Felhasznált erőforrások',
		'systemdetails' => 'Rendszer részletek',
		'froxlordetails' => 'froxlor részletek',
		'installedversion' => 'Telepített verzió',
		'latestversion' => 'Legújabb verzió',
		'lookfornewversion' => [
			'clickhere' => 'Keresés webszolgáltatáson keresztül',
			'error' => 'Hiba az olvasás közben',
		],
		'resources' => 'Erőforrások',
		'customer' => 'Ügyfél',
		'customers' => 'Ügyfelek',
		'customers_list_desc' => 'Ügyfelek kezelése',
		'customer_add' => 'Ügyfél létrehozása',
		'customer_edit' => 'Ügyfél szerkesztése',
		'username_default_msg' => 'Hagyja üresen az automatikusan generált értékhez',
		'password_default_msg' => 'Automatikusan generált, ha üres',
		'domains' => 'Domainek',
		'domain_add' => 'Domain létrehozása',
		'domain_edit' => 'Domain szerkesztése',
		'subdomainforemail' => 'Aldomainek e-mail domainként',
		'admin' => 'Admin',
		'admins' => 'Adminok',
		'admin_add' => 'Admin létrehozása',
		'admin_edit' => 'Admin szerkesztése',
		'customers_see_all' => 'Hozzáférhet más adminok/viszonteladók erőforrásaihoz?',
		'change_serversettings' => 'Módosíthatja a szerver beállításait?',
		'server' => 'Rendszer',
		'serversettings' => 'Beállítások',
		'serversettings_desc' => 'froxlor rendszer kezelése',
		'rebuildconf' => 'Konfigurációs fájlok újraépítése',
		'stdsubdomain' => 'Alapértelmezett aldomain',
		'stdsubdomain_add' => 'Alapértelmezett aldomain létrehozása',
		'phpenabled' => 'PHP engedélyezve',
		'deactivated' => 'Deaktivált',
		'deactivated_user' => 'Felhasználó deaktiválása',
		'sendpassword' => 'Jelszó küldése',
		'ownvhostsettings' => 'Saját vHost-beállítások',
		'configfiles' => [
			'serverconfiguration' => 'Konfiguráció',
			'overview' => 'Áttekintés',
			'wizard' => 'Varázsló',
			'distribution' => 'Disztribúció',
			'service' => 'Szolgáltatás',
			'daemon' => 'Démon',
			'http' => 'Webszerver (HTTP)',
			'dns' => 'Névszerver (DNS)',
			'mail' => 'Levelezőszerver (IMAP/POP3)',
			'smtp' => 'Levelezőszerver (SMTP)',
			'ftp' => 'FTP-szerver',
			'etc' => 'Egyebek (Rendszer)',
			'choosedistribution' => '-- Válasszon disztribúciót --',
			'chooseservice' => '-- Válasszon szolgáltatást --',
			'choosedaemon' => '-- Válasszon démont --',
			'statistics' => 'Statisztikák',
			'compactoverview' => 'Kompakt áttekintés',
			'legend' => '<h3>Ön egy szolgáltatás/démon konfigurálására készül</h3>',
			'commands' => '<span class="text-danger">Parancsok:</span> Ezeket a parancsokat soronként kell végrehajtani root felhasználóként a parancssorban. Biztonságosan másolhatja és beillesztheti az egész blokkot a parancssorba.',
			'files' => '<span class="text-danger">Konfigurációs fájlok:</span> A szövegmezők előtti parancsoknak meg kell nyitniuk egy szerkesztőt a célfájllal. Csak másolja és illessze be a tartalmakat a szerkesztőbe, majd mentse a fájlt.<br><span class="text-danger">Kérjük, vegye figyelembe:</span> A MySQL-jelszó biztonsági okokból nem lett lecserélve. Kérjük, cserélje le a "FROXLOR_MYSQL_PASSWORD"-öt saját maga, vagy használja az alábbi JavaScript űrlapot a helyszíni cseréhez. Ha elfelejtette a MySQL-jelszavát, megtalálja a "lib/userdata.inc.php" fájlban.',
			'importexport' => 'Importálás/Exportálás',
			'finishnote' => 'A paraméter fájl sikeresen létrehozva. Most futtassa a következő parancsot root-ként:',
			'description' => 'Rendszerszolgáltatások konfigurálása',
			'minihowto' => 'Ezen az oldalon megtekintheti a különböző konfigurációs sablonokat minden szolgáltatáshoz, szükség esetén (újra)konfigurálhat specifikus szolgáltatásokat, vagy exportálhatja az aktuális kiválasztást egy JSON fájlba, hogy a CLI szkriptekben vagy egy másik szerveren használhassa.<br><br><b>Megjegyzés:</b> a kiemelt szolgáltatások nem tükrözik az aktuális beállításait, hanem az aktuális beállítási értékek alapján mutatják a követelményeket/ajánlásokat.',
			'skipconfig' => 'Ne konfigurálja (újra)',
			'recommendednote' => 'Ajánlott/szükséges szolgáltatások az aktuális rendszerbeállítások alapján',
			'selectrecommended' => 'Ajánlottak kiválasztása',
			'downloadselected' => 'Kiválasztottak exportálása',
		],
		'templates' => [
			'templates' => 'E-mail sablonok',
			'template_add' => 'Sablon hozzáadása',
			'template_fileadd' => 'Fájl sablon hozzáadása',
			'template_edit' => 'Sablon szerkesztése',
			'action' => 'Művelet',
			'email' => 'E-mail és fájl sablonok',
			'subject' => 'Tárgy',
			'mailbody' => 'E-mail törzs',
			'createcustomer' => 'Üdvözlő e-mail új ügyfeleknek',
			'pop_success' => 'Üdvözlő e-mail új e-mail fiókokhoz',
			'template_replace_vars' => 'A sablonban helyettesítendő változók:',
			'SALUTATION' => 'Helyettesítve a megfelelő megszólítással (név vagy cég)',
			'FIRSTNAME' => 'Helyettesítve az ügyfél keresztnevével.',
			'NAME' => 'Helyettesítve az ügyfél nevével.',
			'COMPANY' => 'Helyettesítve az ügyfél cégnevével',
			'USERNAME' => 'Helyettesítve az ügyfél fiókjának felhasználónevével.',
			'PASSWORD' => 'Helyettesítve az ügyfél fiókjának jelszavával.',
			'EMAIL' => 'Helyettesítve a POP3/IMAP fiók címével.',
			'CUSTOMER_NO' => 'Helyettesítve az ügyfélszámmal',
			'TRAFFIC' => 'Helyettesítve a forgalommal, amely az ügyfélhez lett rendelve.',
			'TRAFFICUSED' => 'Helyettesítve a forgalommal, amelyet az ügyfél felhasznált.',
			'pop_success_alternative' => 'Üdvözlő e-mail új e-mail fiókokhoz, alternatív címre küldve',
			'EMAIL_PASSWORD' => 'Helyettesítve a POP3/IMAP fiók jelszavával.',
			'index_html' => 'Index fájl az újonnan létrehozott ügyfél könyvtárakhoz',
			'unconfigured_html' => 'Index fájl a nem konfigurált/ismeretlen domainekhez',
			'unconfigured_content_fallback' => 'Ez a domain konfigurálást igényel a froxlor szerver kezelőpanelen keresztül, mivel jelenleg nincs hozzárendelve egyetlen ügyfélhez sem.',
			'file_extension' => [
				'description' => 'Az index fájl kiterjesztésének 1-6 karakter hosszúnak kell lennie. A kiterjesztés csak a-z, A-Z és 0-9 karaktereket tartalmazhat<br><br>Alapértelmezett: html',
				'title' => 'Fájl kiterjesztés a fájl sablonhoz',
			],
			'SERVERNAME' => 'Helyettesítve a szerver nevével.',
			'CUSTOMER' => 'Helyettesítve az ügyfél bejelentkezési nevével. Csak az "index fájl az újonnan létrehozott ügyfél könyvtárakhoz" esetén',
			'ADMIN' => 'Helyettesítve az admin bejelentkezési nevével. Csak az "index fájl az újonnan létrehozott ügyfél könyvtárakhoz" esetén',
			'CUSTOMER_EMAIL' => 'Helyettesítve az ügyfél e-mail címével. Csak az "index fájl az újonnan létrehozott ügyfél könyvtárakhoz" esetén',
			'ADMIN_EMAIL' => 'Helyettesítve az admin e-mail címével. Csak az "index fájl az újonnan létrehozott ügyfél könyvtárakhoz" esetén',
			'filetemplates' => 'Fájl sablonok',
			'filecontent' => 'Fájl tartalom',
			'new_database_by_customer' => 'Ügyfél-értesítés adatbázis létrehozásakor',
			'new_ftpaccount_by_customer' => 'Ügyfél-értesítés FTP-felhasználó létrehozásakor',
			'newdatabase' => 'Értesítő e-mailek új adatbázisokhoz',
			'newftpuser' => 'Értesítő e-mailek új FTP-felhasználókhoz',
			'CUST_NAME' => 'Ügyfél neve',
			'DB_NAME' => 'Adatbázis neve',
			'DB_PASS' => 'Adatbázis jelszava',
			'DB_DESC' => 'Adatbázis leírása',
			'DB_SRV' => 'Adatbázis szerver',
			'PMA_URI' => 'URL a phpMyAdminhoz (ha meg van adva)',
			'USR_NAME' => 'FTP felhasználónév',
			'USR_PASS' => 'FTP jelszó',
			'USR_PATH' => 'FTP home könyvtár (relatív az ügyfél dokumentumgyökeréhez)',
			'forgotpwd' => 'Értesítő e-mailek jelszó-visszaállításhoz',
			'password_reset' => 'Ügyfél-értesítés jelszó-visszaállításhoz',
			'trafficmaxpercent' => 'Értesítő e-mail ügyfeleknek, amikor a forgalom adott maximális százalékát kimerítették',
			'MAX_PERCENT' => 'Helyettesítve a lemezhasználat/forgalom jelentésküldési határértékével százalékban.',
			'USAGE_PERCENT' => 'Helyettesítve a lemezhasználattal/forgalommal, amelyet az ügyfél kimerített, százalékban.',
			'diskmaxpercent' => 'Értesítő e-mail ügyfeleknek, amikor a lemezterület adott maximális százalékát kimerítették',
			'DISKAVAILABLE' => 'Helyettesítve a lemezhasználattal, amely az ügyfélhez lett rendelve.',
			'DISKUSED' => 'Helyettesítve a lemezhasználattal, amelyet az ügyfél kimerített.',
			'LINK' => 'Helyettesítve az ügyfél jelszó-visszaállítási linkjével.',
			'SERVER_HOSTNAME' => 'Helyettesíti a rendszer-hosztnevet (URL a froxlorhoz)',
			'SERVER_IP' => 'Helyettesíti az alapértelmezett szerver IP-címét',
			'SERVER_PORT' => 'Helyettesíti az alapértelmezett szerver portját',
			'DOMAINNAME' => 'Helyettesíti az ügyfél standard aldomainjét (üres lehet, ha nincs generálva)',
		],
		'webserver' => 'Webszerver',
		'createzonefile' => 'DNS zóna létrehozása a domainhez',
		'custombindzone' => 'Egyéni / nem kezelt zónafájl',
		'bindzonewarning' => 'üres az alapértelmezettekhez<br /><strong class="text-danger">FIGYELEM:</strong> Ha zónafájlt használ, manuálisan kell kezelnie az összes szükséges rekordot az összes alzónához is.',
		'ipsandports' => [
			'ipsandports' => 'IP-k és Portok',
			'add' => 'IP/Port hozzáadása',
			'edit' => 'IP/Port szerkesztése',
			'ipandport' => 'IP/Port',
			'ip' => 'IP',
			'ipnote' => '<div id="ipnote" class="invalid-feedback">Megjegyzés: Bár privát IP-címek megengedettek, néhány funkció, mint például a DNS, nem biztos, hogy helyesen működik.<br>Csak akkor használjon privát IP-címeket, ha biztos benne.</div>',
			'port' => 'Port',
			'create_listen_statement' => 'Listen utasítás létrehozása',
			'create_namevirtualhost_statement' => 'NameVirtualHost utasítás létrehozása',
			'create_vhostcontainer' => 'vHost-Container létrehozása',
			'create_vhostcontainer_servername_statement' => 'ServerName utasítás létrehozása a vHost-Containerben',
			'enable_ssl' => 'Ez egy SSL Port?',
			'ssl_cert_file' => 'Az SSL tanúsítvány elérési útja',
			'webserverdefaultconfig' => 'Webszerver alapértelmezett konfiguráció',
			'webserverdomainconfig' => 'Webszerver domain konfiguráció',
			'webserverssldomainconfig' => 'Webszerver SSL konfiguráció',
			'ssl_key_file' => 'Az SSL kulcsfájl elérési útja',
			'ssl_ca_file' => 'Az SSL CA tanúsítvány elérési útja',
			'default_vhostconf_domain' => 'Alapértelmezett vHost-beállítások minden domain containerhez',
			'ssl_cert_chainfile' => [
				'title' => 'Az SSL CertificateChainFile elérési útja',
				'description' => 'Többnyire CA_Bundle, vagy hasonló, valószínűleg be kell állítania, ha SSL tanúsítványt vásárolt.',
			],
			'docroot' => [
				'title' => 'Egyéni docroot (üres = froxlorra mutat)',
				'description' => 'Meghatározhat egy egyéni dokumentum-gyökeret (a kérés célállomása) ehhez az IP/port kombinációhoz.<br /><strong>FIGYELEM:</strong> Kérjük, legyen óvatos azzal, amit ide beír!',
			],
			'ssl_paste_description' => 'Illessze be a teljes tanúsítvány tartalmát a szövegdobozba',
			'ssl_cert_file_content' => 'Az SSL tanúsítvány tartalma',
			'ssl_key_file_content' => 'Az SSL (privát) kulcsfájl tartalma',
			'ssl_ca_file_content' => 'Az SSL CA fájl tartalma (opcionális)',
			'ssl_ca_file_content_desc' => '<br /><br />Ügyfél-hitelesítés, csak akkor állítsa be, ha tudja, mi az.',
			'ssl_cert_chainfile_content' => 'A tanúsítvány láncfájl tartalma (opcionális)',
			'ssl_cert_chainfile_content_desc' => '<br /><br />Többnyire CA_Bundle, vagy hasonló, valószínűleg be kell állítania, ha SSL tanúsítványt vásárolt.',
			'ssl_default_vhostconf_domain' => 'Alapértelmezett SSL vHost-beállítások minden domain containerhez',
		],
		'memorylimitdisabled' => 'Letiltva',
		'valuemandatory' => 'Ez az érték kötelező',
		'valuemandatorycompany' => 'Vagy a "név" és "keresztnév", vagy a "cég" mezőt ki kell tölteni',
		'serversoftware' => 'Szerver szoftver',
		'phpversion' => 'PHP-verzió',
		'mysqlserverversion' => 'MySQL szerver verzió',
		'webserverinterface' => 'Webszerver interfész',
		'accountsettings' => 'Fiók beállítások',
		'panelsettings' => 'Panel beállítások',
		'systemsettings' => 'Rendszer beállítások',
		'webserversettings' => 'Webszerver beállítások',
		'mailserversettings' => 'Mail szerver beállítások',
		'nameserversettings' => 'Névszerver beállítások',
		'updatecounters' => 'Erőforrás-használat újraszámítása',
		'subcanemaildomain' => [
			'never' => 'Soha',
			'choosableno' => 'Választható, alapértelmezett nem',
			'choosableyes' => 'Választható, alapértelmezett igen',
			'always' => 'Mindig',
		],
		'wipecleartextmailpwd' => 'Tiszta szöveges jelszavak törlése',
		'webalizersettings' => 'Webalizer beállítások',
		'webalizer' => [
			'normal' => 'Normál',
			'quiet' => 'Csendes',
			'veryquiet' => 'Nincs kimenet',
		],
		'domain_nocustomeraddingavailable' => 'Jelenleg nem lehet domaint hozzáadni. Először legalább egy ügyfelet kell hozzáadnia.',
		'loggersettings' => 'Naplózási beállítások',
		'logger' => [
			'normal' => 'normál',
			'paranoid' => 'paranoid',
		],
		'emaildomain' => 'Email domain',
		'email_only' => 'Csak email?',
		'wwwserveralias' => '"www." ServerAlias hozzáadása',
		'subject' => 'Tárgy',
		'recipient' => 'Címzett',
		'message' => 'Üzenet írása',
		'text' => 'Üzenet',
		'sslsettings' => 'SSL beállítások',
		'specialsettings_replacements' => 'A következő változókat használhatja:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (ha alkalmazható)<br/>',
		'antispam_settings' => 'Spam elleni beállítások',
		'caneditphpsettings' => 'Módosíthatja a PHP-hoz kapcsolódó domain beállításokat?',
		'allips' => 'Összes IP',
		'awstatssettings' => 'AWstats beállítások',
		'domain_dns_settings' => 'Domain DNS beállítások',
		'activated' => 'Aktiválva',
		'statisticsettings' => 'Statisztikai beállítások',
		'or' => 'vagy',
		'sysload' => 'Rendszer terhelés',
		'noloadavailable' => 'nem elérhető',
		'nouptimeavailable' => 'nem elérhető',
		'nosubject' => '(Nincs tárgy)',
		'security_settings' => 'Biztonsági beállítások',
		'know_what_youre_doing' => 'Csak akkor változtasson, ha tudja, mit csinál!',
		'show_version_login' => [
			'title' => 'froxlor verzió megjelenítése bejelentkezéskor',
			'description' => 'A froxlor verzió megjelenítése a láblécben a bejelentkezési oldalon',
		],
		'show_version_footer' => [
			'title' => 'froxlor verzió megjelenítése a láblécben',
			'description' => 'A froxlor verzió megjelenítése a láblécben az oldalak többi részén',
		],
		'froxlor_graphic' => [
			'title' => 'froxlor fejléc grafika',
			'description' => 'Milyen grafikát kell megjeleníteni a fejlécben',
		],
		'phpsettings' => [
			'title' => 'PHP konfiguráció',
			'description' => 'Rövid leírás',
			'actions' => 'Műveletek',
			'activedomains' => 'Használatban lévő domain(ek)',
			'notused' => 'Konfiguráció nincs használatban',
			'editsettings' => 'PHP beállítások módosítása',
			'addsettings' => 'Új PHP beállítások létrehozása',
			'viewsettings' => 'PHP beállítások megtekintése',
			'phpinisettings' => 'php.ini beállítások',
			'addnew' => 'Új PHP konfiguráció létrehozása',
			'binary' => 'PHP bináris',
			'fpmdesc' => 'PHP-FPM konfiguráció',
			'file_extensions' => 'Fájl kiterjesztések',
			'file_extensions_note' => '(pont nélkül, szóközzel elválasztva)',
			'enable_slowlog' => 'Slowlog engedélyezése (domainenként)',
			'request_terminate_timeout' => 'Kérés megszakítási időkorlát',
			'request_slowlog_timeout' => 'Slowlog kérés időkorlát',
			'activephpconfigs' => 'Használatban lévő PHP-konfiguráció(k)',
			'pass_authorizationheader' => 'HTTP AUTH BASIC/DIGEST fejléc továbbítása Apache-ból PHP-ba',
		],
		'misc' => 'Egyéb',
		'fpmsettings' => [
			'addnew' => 'Új PHP verzió létrehozása',
			'edit' => 'PHP verzió módosítása'
		],
		'phpconfig' => [
			'template_replace_vars' => 'A konfigurációkban lecserélendő változók',
			'pear_dir' => 'A globális beállításra lesz lecserélve a pear könyvtárhoz.',
			'open_basedir_c' => 'Beszúr egy ; (pontosvesszőt) az open_basedir kikommenteléséhez/letiltásához, ha be van állítva',
			'open_basedir' => 'A domain open_basedir beállítására lesz lecserélve.',
			'tmp_dir' => 'A domain ideiglenes könyvtárára lesz lecserélve.',
			'open_basedir_global' => 'A globális értékre lesz lecserélve, amely az open_basedir-hez lesz csatolva (lásd webszerver beállítások).',
			'customer_email' => 'A domain tulajdonosának e-mail címére lesz lecserélve.',
			'admin_email' => 'A domain adminisztrátorának e-mail címére lesz lecserélve.',
			'domain' => 'A domainre lesz lecserélve.',
			'customer' => 'A domain tulajdonosának bejelentkezési nevére lesz lecserélve.',
			'admin' => 'A domain adminisztrátorának bejelentkezési nevére lesz lecserélve.',
			'docroot' => 'A domain dokumentum-gyökerére lesz lecserélve.',
			'homedir' => 'Az ügyfél otthoni könyvtárára lesz lecserélve.',
		],
		'expert_settings' => 'Haladó beállítások!',
		'mod_fcgid_starter' => [
			'title' => 'PHP folyamatok ehhez a domainhez (üres az alapértelmezett értékhez)',
		],
		'phpserversettings' => 'PHP beállítások',
		'mod_fcgid_maxrequests' => [
			'title' => 'Maximális PHP kérések ehhez a domainhez (üres az alapértelmezett értékhez)',
		],
		'spfsettings' => 'Domain SPF beállítások',
		'specialsettingsforsubdomains' => 'Speciális beállítások alkalmazása minden aldomainre (*.example.com)',
		'accountdata' => 'Fiók adatok',
		'contactdata' => 'Kapcsolati adatok',
		'servicedata' => 'Szolgáltatási adatok',
		'newerversionavailable' => 'Újabb froxlor verzió érhető el.',
		'newerversiondetails' => 'Frissítés a <b>%s</b> verzióra most?<br/>(A jelenlegi verzió: %s)',
		'extractdownloadedzip' => 'Letöltött archívum kibontása "%s"?',
		'cron' => [
			'cronsettings' => 'Cronjob beállítások',
			'add' => 'Cronjob hozzáadása',
		],
		'cronjob_edit' => 'Cronjob szerkesztése',
		'warning' => 'FIGYELEM - Kérjük, vegye figyelembe!',
		'lastlogin_succ' => 'Utolsó bejelentkezés',
		'ftpserver' => 'FTP Szerver',
		'ftpserversettings' => 'FTP Szerver beállítások',
		'webserver_user' => 'Webszerver felhasználónév',
		'webserver_group' => 'Webszerver csoportnév',
		'perlenabled' => 'Perl engedélyezve',
		'fcgid_settings' => 'FCGID',
		'mod_fcgid_user' => 'Helyi felhasználó az FCGID-hez (froxlor vHost)',
		'mod_fcgid_group' => 'Helyi csoport az FCGID-hez (froxlor vHost)',
		'perl_settings' => 'Perl/CGI',
		'notgiven' => '[nincs megadva]',
		'store_defaultindex' => 'Alapértelmezett index-fájl tárolása az ügyfél dokumentumgyökerébe',
		'phpfpm_settings' => 'PHP-FPM',
		'traffic' => 'Forgalom',
		'traffic_sub' => 'Részletek a forgalom használatáról',
		'domaintraffic' => 'Domainek',
		'customertraffic' => 'Ügyfelek',
		'assignedmax' => 'Hozzárendelt / Max',
		'usedmax' => 'Használt / Max',
		'used' => 'Használt',
		'speciallogwarning' => '<div id="speciallogfilenote" class="invalid-feedback">FIGYELEM: E beállítás megváltoztatásával elveszíti az összes régi statisztikáját ehhez a domainhez.</div>',
		'speciallogfile' => [
			'title' => 'Külön naplófájl',
			'description' => 'Engedélyezze ezt, hogy külön hozzáférési naplófájlt kapjon ehhez a domainhez',
		],
		'domain_editable' => [
			'title' => 'Domain szerkesztésének engedélyezése',
			'desc' => 'Ha igenre van állítva, az ügyfél módosíthatja a domain beállításait.<br />Ha nemre van állítva, az ügyfél semmit sem módosíthat.',
		],
		'writeaccesslog' => [
			'title' => 'Hozzáférési napló írása',
			'description' => 'Engedélyezze ezt, hogy hozzáférési naplófájlt kapjon ehhez a domainhez',
		],
		'writeerrorlog' => [
			'title' => 'Hibanapló írása',
			'description' => 'Engedélyezze ezt, hogy hibanapló-fájlt kapjon ehhez a domainhez',
		],
		'phpfpm.ininote' => 'Nem minden érték, amelyet meg szeretne határozni, használható a php-fpm pool konfigurációban',
		'phpinfo' => 'PHPinfo()',
		'selectserveralias' => 'ServerAlias érték a domainhez',
		'selectserveralias_desc' => 'Válassza ki, hogy a froxlor hozzon létre egy wildcard-bejegyzést (*.domain.tld), egy WWW-alias-t (www.domain.tld) vagy egyáltalán ne hozzon létre alias-t',
		'show_news_feed' => [
			'title' => 'Hírcsatorna megjelenítése az admin irányítópulton',
			'description' => 'Engedélyezze ezt, hogy megjelenítse a hivatalos froxlor hírcsatornát (https://inside.froxlor.org/news/) az irányítópultján, és soha ne maradjon le fontos információkról vagy kiadási bejelentésekről.',
		],
		'cronsettings' => 'Cronjob beállítások',
		'integritycheck' => 'Adatbázis érvényesítés',
		'integrityname' => 'Név',
		'integrityresult' => 'Eredmény',
		'integrityfix' => 'Problémák automatikus javítása',
		'customer_show_news_feed' => 'Hírcsatorna megjelenítése az ügyfél irányítópultján',
		'customer_news_feed_url' => [
			'title' => 'Egyéni RSS-hírcsatorna használata',
			'description' => 'Adjon meg egy egyéni RSS-hírcsatornát, amelyet az ügyfelei irányítópultján jelenít meg.<br /><small>Hagyja üresen, hogy a hivatalos froxlor hírcsatornát használja (https://inside.froxlor.org/news/).</small>',
		],
		'movetoadmin' => 'Ügyfél áthelyezése',
		'movecustomertoadmin' => [
			'title' => 'Ügyfél áthelyezése a kiválasztott adminisztrátorhoz/viszonteladóhoz',
			'description' => 'Hagyja üresen, ha nem kíván változtatni.<br />Ha a kívánt adminisztrátor nem jelenik meg a listában, akkor az ügyfélkorlátja elérte a maximumot.',
		],
		'note' => 'Megjegyzés',
		'mod_fcgid_umask' => [
			'title' => 'Umask (alapértelmezett: 022)',
		],
		'apcuinfo' => 'APCu információ',
		'opcacheinfo' => 'OPcache információ',
		'letsencrypt' => [
			'title' => 'Let\'s Encrypt használata',
			'description' => 'Szerezzen ingyenes tanúsítványt a <a href="https://letsencrypt.org">Let\'s Encrypt</a> szolgáltatástól. A tanúsítvány automatikusan létrejön és megújul.<br><strong class="text-danger">FIGYELEM:</strong> Ha a wildcardok engedélyezve vannak, ez az opció automatikusan letiltásra kerül.',
		],
		'autoupdate' => 'Automatikus frissítés',
		'server_php' => 'PHP',
		'dnsenabled' => 'DNS szerkesztő engedélyezése',
		'froxlorvhost' => 'froxlor VirtualHost beállítások',
		'hostname' => 'Hosztnév',
		'memory' => 'Memória használat',
		'webserversettings_ssl' => 'Webszerver SSL beállítások',
		'domain_hsts_maxage' => [
			'title' => 'HTTP Strict Transport Security (HSTS)',
			'description' => 'Adja meg a Strict-Transport-Security fejléc max-age értékét<br>A <i>0</i> érték letiltja a HSTS-t a domainhez. A legtöbb felhasználó <i>31536000</i> (egy év) értéket állít be.',
		],
		'domain_hsts_incsub' => [
			'title' => 'HSTS alkalmazása minden aldomainre',
			'description' => 'Az opcionális "includeSubDomains" direktíva, ha jelen van, jelzi a felhasználói ügynöknek, hogy a HSTS politika érvényes erre a HSTS hosztra, valamint a hoszt domain nevének bármely aldomainjére.',
		],
		'domain_hsts_preload' => [
			'title' => 'Domain felvétele a HSTS előtöltési listába',
			'description' => 'Ha szeretné, hogy ez a domain szerepeljen a Chrome által karbantartott <a href="https://hstspreload.org/" target="_blank">HSTS előtöltési listában</a> (amit a Firefox és a Safari is használ), akkor aktiválja ezt.<br>A preload direktíva küldése az oldaláról ÁLLANDÓ KÖVETKEZMÉNYEKKEL járhat, és megakadályozhatja a felhasználókat abban, hogy hozzáférjenek az oldalához és annak bármely aldomainjéhez.<br>Kérjük, olvassa el a részleteket a <a href="https://hstspreload.org/#removal" target="_blank">https://hstspreload.org/#removal</a> oldalon, mielőtt a fejlécet "preload" értékkel küldené.',
		],
		'domain_ocsp_stapling' => [
			'title' => 'OCSP stapling',
			'description' => 'Lásd <a target="_blank" href="https://en.wikipedia.org/wiki/OCSP_stapling">Wikipedia</a> az OCSP stapling részletes magyarázatáért',
			'nginx_version_warning' => '<br /><strong class="text-danger">FIGYELEM:</strong> Az OCSP staplinghez legalább 1.3.7-es Nginx verzió szükséges. Ha a verziója régebbi, a webszerver NEM fog megfelelően elindulni, amíg az OCSP stapling engedélyezve van!',
		],
		'domain_http2' => [
			'title' => 'HTTP2 támogatás',
			'description' => 'Lásd <a target="_blank" href="https://en.wikipedia.org/wiki/HTTP/2">Wikipedia</a> a HTTP2 részletes magyarázatáért',
		],
		'testmail' => 'SMTP teszt',
		'phpsettingsforsubdomains' => 'PHP-konfiguráció alkalmazása minden aldomainre:',
		'plans' => [
			'name' => 'Csomag neve',
			'description' => 'Leírás',
			'last_update' => 'Utolsó frissítés',
			'plans' => 'Tárhely csomagok',
			'plan_details' => 'Csomag részletei',
			'add' => 'Új csomag hozzáadása',
			'edit' => 'Csomag szerkesztése',
			'use_plan' => 'Csomag alkalmazása',
		],
		'notryfiles' => [
			'title' => 'Nincs automatikusan generált try_files',
			'description' => 'Mondjon igent itt, ha egyedi try_files direktívát szeretne megadni a speciális beállításokban (szükséges néhány WordPress bővítményhez például).',
		],
		'logviewenabled' => 'Hozzáférés engedélyezése a hozzáférési/hiba-naplókhoz',
		'novhostcontainer' => '<br><br><small class="text-danger">Egyik IP és port sem rendelkezik a "vHost-Container létrehozása" opcióval, sok beállítás itt nem lesz elérhető</small>',
		'ownsslvhostsettings' => 'Saját SSL vHost-beállítások',
		'domain_override_tls' => 'Rendszer TLS beállítások felülírása',
		'domain_override_tls_addinfo' => '<br /><span class="text-danger">Csak akkor használatos, ha a "Rendszer TLS beállítások felülírása" "Igen"-re van állítva</span>',
		'domain_sslenabled' => 'SSL használatának engedélyezése',
		'domain_honorcipherorder' => 'A (szerver) titkosítási sorrend tiszteletben tartása, alapértelmezett <strong>nem</strong>',
		'domain_sessiontickets' => 'TLS sessiontickets engedélyezése (RFC 5077), alapértelmezett <strong>igen</strong>',
		'domain_sessionticketsenabled' => [
			'title' => 'TLS sessiontickets használatának globális engedélyezése',
			'description' => 'Alapértelmezett <strong>igen</strong><br>Apache-2.4.11+ vagy nginx-1.5.9+ szükséges',
		],
		'domaindefaultalias' => 'Alapértelmezett ServerAlias érték új domainekhez',
		'smtpsettings' => 'SMTP beállítások',
		'smtptestaddr' => 'Teszt e-mail küldése ide',
		'smtptestnote' => 'Vegye figyelembe, hogy az alábbi értékek a jelenlegi beállításait tükrözik, és csak ott módosíthatók (lásd a jobb felső sarokban található linket)',
		'smtptestsend' => 'Teszt e-mail küldése',
		'mysqlserver' => [
			'mysqlserver' => 'MySQL Szerver',
			'dbserver' => 'Szerver #',
			'caption' => 'Leírás',
			'host' => 'Hosztnév / IP',
			'port' => 'Port',
			'user' => 'Kiváltságos felhasználó',
			'add' => 'Új MySQL szerver hozzáadása',
			'edit' => 'MySQL szerver szerkesztése',
			'password' => 'Kiváltságos felhasználó jelszava',
			'password_emptynochange' => 'Új jelszó, hagyja üresen, ha nem kíván változtatni',
			'allowall' => [
				'title' => 'Engedélyezze ennek a szervernek a használatát minden jelenleg létező ügyfél számára',
				'description' => 'Állítsa "igaz"-ra, ha azt szeretné, hogy minden jelenleg létező ügyfél használhassa ezt az adatbázis-szervert, így adatbázisokat adhatnak hozzá. Ez a beállítás nem állandó, de többször is futtatható.',
			],
			'testconn' => 'Kapcsolat tesztelése mentéskor',
			'ssl' => 'SSL használata az adatbázis-szerverhez való kapcsolódáshoz',
			'ssl_cert_file' => 'Az SSL tanúsítvány hatóság fájl elérési útja',
			'verify_ca' => 'A szerver SSL tanúsítványának ellenőrzésének engedélyezése',
		],
		'settings_importfile' => 'Import fájl kiválasztása',
		'documentation' => 'Dokumentáció',
		'adminguide' => 'Adminisztrátori útmutató',
		'userguide' => 'Felhasználói útmutató',
		'apiguide' => 'API útmutató',
		'domain_duplicate' => 'Domain másolása',
		'domain_duplicate_named' => 'Másolat %s',
		'backups' => [
			'backups' => 'Biztonsági mentések',
		],
		'emaildomainwarning' => '<div id="emaildomainnote" class="invalid-feedback">FIGYELEM: E beállítás megváltoztatásával véglegesen törli az összes meglévő e-mail címet és fiókot.</div>',
	],
	'apcuinfo' => [
		'clearcache' => 'APCu gyorsítótár törlése',
		'generaltitle' => 'Általános gyorsítótár információ',
		'version' => 'APCu verzió',
		'phpversion' => 'PHP verzió',
		'host' => 'APCu hoszt',
		'sharedmem' => 'Megosztott memória',
		'sharedmemval' => '%d szegmens %s (%s memória)',
		'start' => 'Indítási idő',
		'uptime' => 'Üzemidő',
		'upload' => 'Fájl feltöltés támogatás',
		'cachetitle' => 'Gyorsítótár információ',
		'cvar' => 'Gyorsítótárazott változók',
		'hit' => 'Találatok',
		'miss' => 'Hiányzások',
		'reqrate' => 'Kérés arány (találatok, hiányzások)',
		'creqsec' => 'gyorsítótár kérések/másodperc',
		'hitrate' => 'Találati arány',
		'missrate' => 'Hiányzási arány',
		'insrate' => 'Beillesztési arány',
		'cachefull' => 'Gyorsítótár telítettség számláló',
		'runtime' => 'Futási beállítások',
		'memnote' => 'Memória használat',
		'total' => 'Összesen',
		'free' => 'Szabad',
		'used' => 'Használt',
		'hitmiss' => 'Találatok és hiányzások',
		'detailmem' => 'Részletes memória használat és töredezettség',
		'fragment' => 'Töredezettség',
		'nofragment' => 'Nincs töredezettség',
		'fragments' => 'Töredékek',
	],
	'apikeys' => [
		'no_api_keys' => 'Nincs API kulcs található',
		'key_add' => 'Új kulcs hozzáadása',
		'apikey_removed' => 'Az API kulcs #%s azonosítóval sikeresen eltávolítva',
		'apikey_added' => 'Egy új API kulcs sikeresen létrehozva',
		'clicktoview' => 'Kattintson a megtekintéshez',
		'allowed_from' => 'Engedélyezett innen',
		'allowed_from_help' => 'Vesszővel elválasztott IP címek / hálózatok listája.<br>Alapértelmezett üres (mindenhonnan engedélyezett).',
		'valid_until' => 'Érvényes eddig',
		'valid_until_help' => 'Dátum, ameddig érvényes, formátum: ÉÉÉÉ-HH-NNÓÓ:PP',
	],
	'changepassword' => [
		'old_password' => 'Régi jelszó',
		'new_password' => 'Új jelszó',
		'new_password_confirm' => 'Jelszó megerősítése',
		'new_password_ifnotempty' => 'Új jelszó (üres = nincs változás)',
		'also_change_ftp' => ' az FTP főfiók jelszavának megváltoztatása is',
		'also_change_stats' => ' a statisztikai oldal jelszavának megváltoztatása is',
		'also_change_global_mysql' => 'a globális MySQL fiók jelszavának megváltoztatása is',
	],
	'cron' => [
		'cronname' => 'cronjob-név',
		'lastrun' => 'utolsó futás',
		'interval' => 'időköz',
		'isactive' => 'engedélyezett',
		'description' => 'leírás',
		'changewarning' => 'Ezeknek az értékeknek a megváltoztatása negatív hatással lehet a froxlor és az automatizált feladatok működésére.<br />Kérjük, csak akkor változtasson itt értékeket, ha biztos benne, hogy tudja, mit csinál.',
	],
	'crondesc' => [
		'cron_unknown_desc' => 'nincs megadott leírás',
		'cron_tasks' => 'Konfigurációs fájlok generálása',
		'cron_legacy' => 'régi (legacy) cronjob',
		'cron_traffic' => 'Forgalom számítás',
		'cron_usage_report' => 'Web- és forgalmi jelentések',
		'cron_mailboxsize' => 'Postafiók méret számítás',
		'cron_letsencrypt' => 'Let\'s Encrypt tanúsítvány frissítések',
		'cron_export' => 'Adat-export feladatok feldolgozása',
		'cron_backup' => 'Rendszer- és ügyfél biztonsági mentési feladatok feldolgozása',
	],
	'cronjob' => [
		'cronjobsettings' => 'Cronjob beállítások',
		'cronjobintervalv' => 'Futási időköz érték',
		'cronjobinterval' => 'Futási időköz',
	],
	'cronjobs' => [
		'notyetrun' => 'Még nem futott',
	],
	'cronmgmt' => [
		'minutes' => 'percek',
		'hours' => 'órák',
		'days' => 'napok',
		'weeks' => 'hetek',
		'months' => 'hónapok',
	],
	'customer' => [
		'documentroot' => 'Kezdőkönyvtár',
		'name' => 'Név',
		'firstname' => 'Keresztnév',
		'lastname' => 'Vezetéknév',
		'company' => 'Cég',
		'nameorcompany_desc' => 'Vagy a keresztnév/vezetéknév vagy a cég megadása kötelező',
		'street' => 'Utca',
		'zipcode' => 'Irányítószám',
		'city' => 'Város',
		'phone' => 'Telefon',
		'fax' => 'Fax',
		'email' => 'Email',
		'customernumber' => 'Ügyfélazonosító',
		'diskspace' => 'Webtárhely',
		'traffic' => 'Forgalom',
		'mysqls' => 'MySQL-adatbázisok',
		'emails' => 'Email-címek',
		'accounts' => 'Email-fiókok',
		'forwarders' => 'Email-továbbítók',
		'ftps' => 'FTP-fiókok',
		'subdomains' => 'Aldomainek',
		'domains' => 'Domainek',
		'mib' => 'MiB',
		'gib' => 'GiB',
		'title' => 'Cím',
		'country' => 'Ország',
		'email_quota' => 'Email kvóta',
		'email_imap' => 'Email IMAP',
		'email_pop3' => 'Email POP3',
		'sendinfomail' => 'Adatok küldése emailben nekem',
		'generated_pwd' => 'Jelszó javaslat',
		'usedmax' => 'Használt / Max',
		'services' => 'Szolgáltatások',
		'letsencrypt' => [
			'title' => 'Let\'s Encrypt használata',
			'description' => 'Ingyenes tanúsítvány beszerzése a <a href="https://letsencrypt.org">Let\'s Encrypt</a>-től. A tanúsítvány automatikusan létrejön és megújul.',
		],
		'selectserveralias_addinfo' => 'Ez az opció a domain szerkesztésekor állítható be. Kezdeti értéke az anyadomaintől öröklődik.',
		'total_diskspace' => 'Teljes lemezterület',
		'mysqlserver' => 'Használható mysql-szerver',
	],
	'diskquota' => 'Kvóta',
	'antispam' => [
		'config_file' => [
			'title' => 'Antispam beállítások fájlja',
			'description' => 'Kérjük, adja meg az email-antispam szabályok fájlnevét',
		],
		'reload_command' => [
			'title' => 'Milter újraindítási parancs',
			'description' => 'Kérjük, adja meg az rspamd szolgáltatás újraindítási parancsát',
		],
		'activated' => [
			'title' => 'Antispam aktiválása?',
			'description' => 'Szeretné használni az rspamd-et antispam szolgáltatásként?',
		],
		'dkim_keylength' => [
			'title' => 'DKIM Kulcshossz',
			'description' => 'Figyelem: A változtatások csak az új kulcsokra lesznek érvényesek<br/><br/>Speciális dns bejegyzést igényel a domainhez. Ha nem használja a névszerver funkciót, manuálisan kell kezelnie ezeket a bejegyzéseket.',
		],
		'spam_tag_level' => [
			'title' => 'Spam címkézési szint',
			'description' => 'Az a pontszám, ami szükséges egy email spamként való megjelöléséhez<br/>Alapértelmezett: 7.0'
		],
		'rewrite_subject' => [
			'title' => 'Tárgy átírása',
			'description' => 'Hozzáadja-e a <strong>***SPAM***</strong> jelzést az email tárgyához, ha alkalmazható',
		],
		'spam_kill_level' => [
			'title' => 'Spam eldobási szint',
			'description' => 'Az a pontszám, ami szükséges egy email teljes eldobásához<br/>Alapértelmezett: 14.0'
		],
		'bypass_spam' => [
			'title' => 'Spamszűrő megkerülése',
			'description' => 'Aktiválja a spamszűrés megkerülését/kikapcsolását ennél a címnél.<br/>Alapértelmezett: nem'
		],
		'policy_greylist' => [
			'title' => 'Szürkelista használata',
			'description' => 'A bejövő emaileket védi a <a href="https://en.wikipedia.org/wiki/Greylisting_(email)" target="_blank">szürkelista</a>.<br/>Alapértelmezett: igen'
		],
		'required_spf_dns' => 'Szükséges SPF DNS bejegyzés',
		'required_dmarc_dns' => 'Szükséges DMARC DNS bejegyzés',
		'required_dkim_dns' => 'Szükséges DKIM DNS bejegyzés',
		'default_select' => [
			'on_changeable' => 'Aktiválva, módosítható',
			'off_changeable' => 'Deaktiválva, módosítható',
			'on_unchangeable' => 'Aktiválva, nem módosítható',
			'off_unchangeable' => 'Deaktiválva, nem módosítható',
		],
		'default_bypass_spam' => [
			'title' => 'Spamszűrő megkerülésének alapértelmezett értéke',
			'description' => 'Az új email fiókoknál alapértelmezetten aktiválva van-e a "Spamszűrő megkerülése", és módosítható-e ez a beállítás az ügyfél által.<br/>Alapértelmezett: Deaktiválva, módosítható'
		],
		'default_spam_rewrite_subject' => [
			'title' => 'Tárgy átírásának alapértelmezett értéke',
			'description' => 'Az új email fiókoknál alapértelmezetten aktiválva van-e a "Tárgy átírása", és módosítható-e ez a beállítás az ügyfél által.<br/>Alapértelmezett: Aktiválva, módosítható'
		],
		'default_policy_greylist' => [
			'title' => 'Szürkelista használatának alapértelmezett értéke',
			'description' => 'Az új email fiókoknál alapértelmezetten aktiválva van-e a "Szürkelista használata", és módosítható-e ez a beállítás az ügyfél által.<br/>Alapértelmezett: Aktiválva, módosítható'
		],
	],
	'dns' => [
		'destinationip' => 'Domain IP-cím(ek)',
		'standardip' => 'Szerver alapértelmezett IP-címe',
		'a_record' => 'A-rekord (IPv6 opcionális)',
		'cname_record' => 'CNAME-rekord',
		'mxrecords' => 'MX rekordok meghatározása',
		'standardmx' => 'Szerver alapértelmezett MX rekordja',
		'mxconfig' => 'Egyéni MX rekordok',
		'priority10' => '10-es prioritás',
		'priority20' => '20-as prioritás',
		'txtrecords' => 'TXT rekordok meghatározása',
		'txtexample' => 'Példa (SPF-bejegyzés):<br />v=spf1 ip4:xxx.xxx.xx.0/23 -all',
		'howitworks' => 'Itt kezelheti a domain DNS bejegyzéseit. Vegye figyelembe, hogy a froxlor automatikusan generálja az NS/MX/A/AAAA rekordokat. Az egyéni bejegyzések elsőbbséget élveznek, csak a hiányzó bejegyzések lesznek automatikusan generálva.',
	],
	'dnseditor' => [
		'edit' => 'DNS szerkesztése',
		'records' => 'rekordok',
		'notes' => [
			'A' => '32 bites IPv4 cím, a hosztnevek IP-címhez rendeléséhez használatos.',
			'AAAA' => '128 bites IPv6 cím, a hosztnevek IP-címhez rendeléséhez használatos.',
			'CAA' => 'A CAA erőforrásrekord lehetővé teszi a DNS domain név tulajdonosának, hogy meghatározzon egy vagy több hitelesítésszolgáltatót (CA), amely jogosult tanúsítványokat kiállítani az adott domainhez.<br>Szerkezet: <code>flag tag[issue|issuewild|iodef|contactmail|contactphone] érték</code><br>Példa: <code>0 issue "ca.example.net"<br>0 iodef "mailto:security@example.com"</code>',
			'CNAME' => 'A domain név aliasa, a DNS keresés folytatódik az új név újbóli keresésével. Csak aldomaineknél lehetséges!',
			'DNAME' => 'Aliast hoz létre a domain név fa teljes részfájához',
			'LOC' => 'Földrajzi helymeghatározási információ egy domain névhez.<br>Szerkezet: <code>( d1 [m1 [s1]] {"N"|"S"} d2 [m2 [s2]] {"E"|"W"} alt["m"] [siz["m"] [hp["m"] [vp["m"]]]] )</code><br>Leírás: <code>d1:     [0 .. 90]            (szélességi fok)
            d2:     [0 .. 180]           (hosszúsági fok)
            m1, m2: [0 .. 59]            (szélességi/hosszúsági perc)
            s1, s2: [0 .. 59.999]        (szélességi/hosszúsági másodperc)
            alt:    [-100000.00 .. 42849672.95] BY .01 (magasság méterben)
            siz, hp, vp: [0 .. 90000000.00] (méret/pontosság méterben)</code><br>Példa: <code>52 22 23.000 N 4 53 32.000 E -2.00m 0.00m 10000m 10m</code>',
			'MX' => 'Mail exchange rekord, egy domain nevet rendel egy levelezőszerverhez az adott domainhez.<br>Példa: <code>10 mail.example.com</code><br>Megjegyzés: A prioritáshoz használja a fenti mezőt',
			'NS' => 'Egy DNS zónát delegál a megadott hivatalos névszerverek használatára.',
			'RP' => 'Felelős személy rekord<br>Szerkezet: <code>postafiók[@ helyett pontot használjon] txt-rekord-név</code><br>Példa: <code>team.froxlor.org. froxlor.org.</code>',
			'SRV' => 'Szolgáltatás helymeghatározó rekord, újabb protokolloknál használatos protokoll-specifikus rekordok létrehozása helyett, mint például az MX.<br>Szerkezet: <code>prioritás súly port cél</code><br>Példa: <code>0 5 5060 sipserver.example.com.</code><br>Megjegyzés: A prioritáshoz használja a fenti mezőt',
			'SSHFP' => 'Az SSHFP erőforrásrekord a secure shell (SSH) kulcs ujjlenyomatainak DNS-ben való közzétételére szolgál.<br>Szerkezet: <code>algoritmus típus ujjlenyomat</code><br>Algoritmusok: <code>0: fenntartott, 1: RSA, 2: DSA, 3: ECDSA, 4: Ed25519, 6: Ed448</code><br>Típusok: <code>0: fenntartott, 1: SHA-1, 2: SHA-256</code><br>Példa: <code>2 1 123456789abcdef67890123456789abcdef67890</code>',
			'TLSA' => 'A TLSA (TLS Hitelesítés) rekord egy TLS/SSL tanúsítvány ujjlenyomatának közzétételére szolgál. Általában DANE-hez használják.<br>A TLSA rekordok csak akkor megbízhatóak, ha a DNSSEC engedélyezve van a domainjén.<br>Szerkezet: <code>használat kiválasztó típus ujjlenyomat</code><br>Tanúsítvány használat: <code>0: PKIX-T, 1: PKIX-EE, 2: DANE-TA, 3: DANE-EE</code><br>Kiválasztó: <code>0: Teljes tanúsítvány használata, 1: Alany nyilvános kulcsának használata</code><br>Egyezési típus: <code>0: Teljes: Nincs Hash, 1: SHA-256 Hash, 2:SHA-512 Hash</code><br>Példa: <code>3 1 1 123456789abcdef67890123456789abcdef123456789abcdef123456789abcde</code>',
			'TXT' => 'Szabadon meghatározható, leíró szöveg.'
		]
	],
	'domain' => [
		'openbasedirpath' => 'OpenBasedir-útvonal',
		'inherited' => 'Ugyanaz, mint a szülő-domainnél',
		'docroot' => 'A fenti mező útvonala',
		'homedir' => 'Kezdőkönyvtár',
		'docparent' => 'A fenti mező útvonalának szülőkönyvtára',
		'ssl_certificate_placeholder' => '---- BEGIN CERTIFICATE---' . PHP_EOL . '[...]' . PHP_EOL . '----END CERTIFICATE----',
		'ssl_key_placeholder' => '---- BEGIN RSA PRIVATE KEY-----' . PHP_EOL . '[...]' . PHP_EOL . '-----END RSA PRIVATE KEY-----',
	],
	'domains' => [
		'description' => 'Itt hozhat létre (al)domaineket és módosíthatja azok útvonalait.<br />A rendszernek minden változtatás után időre van szüksége az új beállítások alkalmazásához.',
		'domainsettings' => 'Domain beállítások',
		'domainname' => 'Domain név',
		'subdomain_add' => 'Aldomain létrehozása',
		'subdomain_edit' => '(Al)domain szerkesztése',
		'wildcarddomain' => 'Wildcard domainként hozza létre?',
		'aliasdomain' => 'Alias a következő domainhez',
		'noaliasdomain' => 'Nincs alias domain',
		'hasaliasdomains' => 'Van alias domain(ek)',
		'statstics' => 'Használati statisztikák',
		'isassigneddomain' => 'Hozzárendelt domain',
		'add_date' => 'Hozzáadva a froxlorhoz',
		'registration_date' => 'Hozzáadva a nyilvántartáshoz',
		'topleveldomain' => 'Felső szintű domain',
		'associated_with_domain' => 'Társítva',
		'aliasdomains' => 'Alias domainek',
		'redirectifpathisurl' => 'Átirányítási kód (alapértelmezett: üres)',
		'redirectifpathisurlinfo' => 'Csak akkor kell kiválasztania egyet ezek közül, ha URL-t adott meg útvonalként<br/><strong class="text-danger">MEGJEGYZÉS:</strong> A változtatások csak akkor lépnek életbe, ha a megadott útvonal egy URL.',
		'ipandport_multi' => [
			'title' => 'IP-cím(ek)',
			'description' => 'Adjon meg egy vagy több IP-címet a domainhez.<br /><br /><div class="text-danger">MEGJEGYZÉS: Az IP-címek nem változtathatók meg, ha a domain egy másik domain <strong>alias-domainje</strong>ként van beállítva.</div>',
		],
		'ipandport_ssl_multi' => [
			'title' => 'SSL IP-cím(ek)',
		],
		'ssl_redirect' => [
			'title' => 'SSL átirányítás',
			'description' => 'Ez az opció átirányításokat hoz létre a nem SSL virtuális hosztokhoz, így minden kérés az SSL virtuális hoszthoz lesz átirányítva.<br /><br />pl. egy kérés a <strong>http</strong>://domain.tld/ címre átirányít a <strong>https</strong>://domain.tld/ címre',
		],
		'serveraliasoption_wildcard' => 'Wildcard (*.domain.tld)',
		'serveraliasoption_www' => 'WWW (www.domain.tld)',
		'serveraliasoption_none' => 'Nincs alias',
		'domain_import' => 'Domainek importálása',
		'import_separator' => 'Elválasztó',
		'import_offset' => 'Eltolás',
		'import_file' => 'CSV-fájl',
		'import_description' => 'A részletes információkért az importfájl szerkezetéről és a sikeres importálás módjáról kérjük, látogasson el a <a href="https://docs.froxlor.org/latest/admin-guide/domain-import/" target="_blank" class="alert-link">https://docs.froxlor.org/latest/admin-guide/domain-import/</a> oldalra',
		'ssl_redirect_temporarilydisabled' => '<br>Az SSL átirányítás ideiglenesen ki van kapcsolva, amíg egy új Let\'s Encrypt tanúsítvány generálódik. A tanúsítvány létrehozása után újra aktiválódik.',
		'termination_date' => 'Megszűnés dátuma',
		'termination_date_overview' => 'megszűnik: ',
		'ssl_certificates' => 'SSL tanúsítványok',
		'ssl_certificate_removed' => 'A(z) #%s azonosítójú tanúsítvány sikeresen eltávolítva',
		'ssl_certificate_error' => 'Hiba a tanúsítvány olvasásakor a következő domainhez: %s',
		'no_ssl_certificates' => 'Nincsenek SSL tanúsítvánnyal rendelkező domainek',
		'isaliasdomainof' => '%s alias domainje',
		'isbinddomain' => 'DNS zóna létrehozása',
		'dkimenabled' => 'DKIM engedélyezve',
		'openbasedirenabled' => 'Openbasedir korlátozás',
		'hsts' => 'HSTS engedélyezve',
		'aliasdomainid' => 'Alias domain azonosítója',
		'nodomainsassignedbyadmin' => 'Az Ön fiókjához jelenleg nincs (aktív) domain hozzárendelve. Kérjük, lépjen kapcsolatba az adminisztrátorral, ha úgy gondolja, hogy ez hibás.',
		'email_only' => 'Csak e-mail',
	],
	'emails' => [
		'description' => 'Itt hozhatja létre és módosíthatja e-mail címeit.<br />Egy fiók olyan, mint a postaláda a háza előtt. Ha valaki e-mailt küld Önnek, az a fiókba kerül.<br /><br />Az e-mailek letöltéséhez használja a következő beállításokat a levelezőprogramjában: (A <i>dőlt betűs</i> adatokat a megfelelő értékekre kell cserélnie!)<br />Kiszolgáló neve: <b><i>domainnév</i></b><br />Felhasználónév: <b><i>fióknév / e-mail cím</i></b><br />jelszó: <b><i>az Ön által választott jelszó</i></b>',
		'emailaddress' => 'E-mail cím',
		'emails_add' => 'E-mail cím létrehozása',
		'emails_edit' => 'E-mail cím szerkesztése',
		'catchall' => 'Catchall',
		'iscatchall' => 'Catchall címként definiálva?',
		'account' => 'Fiók',
		'account_add' => 'Fiók létrehozása',
		'account_delete' => 'Fiók törlése',
		'from' => 'Forrás',
		'to' => 'Cél',
		'forwarders' => 'Továbbítók',
		'forwarder_add' => 'Továbbító létrehozása',
		'alternative_emailaddress' => 'Alternatív e-mail cím',
		'quota' => 'Kvóta',
		'noquota' => 'Nincs kvóta',
		'updatequota' => 'Kvóta frissítése',
		'quota_edit' => 'E-mail kvóta módosítása',
		'noemaildomainaddedyet' => 'Még nincs (e-mail) domain a fiókjában.',
		'back_to_overview' => 'Vissza a domain áttekintéshez',
		'accounts' => 'Fiókok',
		'emails' => 'Címek',
	],
	'error' => [
		'error' => 'Hiba',
		'directorymustexist' => 'A(z) %s könyvtárnak léteznie kell. Kérjük, hozza létre az FTP kliensével.',
		'filemustexist' => 'A(z) %s fájlnak léteznie kell.',
		'allresourcesused' => 'Már minden erőforrását felhasználta.',
		'domains_cantdeletemaindomain' => 'Nem törölhet hozzárendelt domaint.',
		'domains_canteditdomain' => 'Nem szerkesztheti ezt a domaint. Az admin letiltotta.',
		'domains_cantdeletedomainwithemail' => 'Nem törölhet olyan domaint, amely e-mail domainként van használatban. Először törölje az összes e-mail címet.',
		'firstdeleteallsubdomains' => 'Először törölnie kell az összes aldomaint, mielőtt létrehozhat egy wildcard domaint.',
		'youhavealreadyacatchallforthisdomain' => 'Már definiált egy catchall-t ehhez a domainhez.',
		'ftp_cantdeletemainaccount' => 'Nem törölheti a fő FTP fiókját',
		'login' => 'A megadott felhasználónév vagy jelszó helytelen. Kérjük, próbálja újra!',
		'login_blocked' => 'Ezt a fiókot felfüggesztettük a túl sok bejelentkezési hiba miatt. <br />Kérjük, próbálja újra %s másodperc múlva.',
		'notallreqfieldsorerrors' => 'Nem töltött ki minden mezőt, vagy néhány mezőt helytelenül töltött ki.',
		'oldpasswordnotcorrect' => 'A régi jelszó nem helyes.',
		'youcantallocatemorethanyouhave' => 'Nem oszthat ki több erőforrást, mint amennyivel rendelkezik.',
		'mustbeurl' => 'Nem adott meg érvényes vagy teljes URL-t (pl. http://valamilyendomain.com/error404.htm)',
		'invalidpath' => 'Nem választott érvényes URL-t (esetleg problémák a könyvtárlistázással?)',
		'stringisempty' => 'Hiányzó adat a mezőben',
		'stringiswrong' => 'Helytelen adat a mezőben',
		'newpasswordconfirmerror' => 'Az új jelszó és a megerősítés nem egyezik',
		'mydomain' => '\'Domain\'',
		'mydocumentroot' => '\'Dokumentumgyökér\'',
		'loginnameexists' => 'A(z) %s bejelentkezési név már létezik',
		'emailiswrong' => 'A(z) %s e-mail cím érvénytelen karaktereket tartalmaz vagy hiányos',
		'emailexists' => 'A(z) %s e-mail címet már használja egy másik admin',
		'emailexistsanon' => 'A(z) %s e-mail cím már használatban van.',
		'alternativeemailiswrong' => 'A megadott %s alternatív e-mail cím, ahova a hitelesítő adatokat küldenénk, érvénytelennek tűnik',
		'loginnameiswrong' => 'A(z) "%s" bejelentkezési név érvénytelen karaktereket tartalmaz.',
		'loginnameiswrong2' => 'A bejelentkezési név túl sok karaktert tartalmaz. Csak %s karakter engedélyezett.',
		'userpathcombinationdupe' => 'A felhasználónév és útvonal kombinációja már létezik',
		'patherror' => 'Általános hiba! Az útvonal nem lehet üres',
		'errordocpathdupe' => 'A(z) %s útvonalra vonatkozó opció már létezik',
		'adduserfirst' => 'Kérjük, először hozzon létre egy ügyfelet',
		'domainalreadyexists' => 'A(z) %s domain már hozzá van rendelve egy ügyfélhez',
		'nolanguageselect' => 'Nincs kiválasztott nyelv.',
		'nosubjectcreate' => 'Meg kell adnia egy témát ehhez az e-mail sablonhoz.',
		'nomailbodycreate' => 'Meg kell adnia egy e-mail szöveget ehhez az e-mail sablonhoz.',
		'templatenotfound' => 'A sablon nem található.',
		'alltemplatesdefined' => 'Nem definiálhat több sablont, már minden nyelv támogatott.',
		'wwwnotallowed' => 'A www nem engedélyezett aldomaineknél.',
		'subdomainiswrong' => 'A(z) %s aldomain érvénytelen karaktereket tartalmaz.',
		'domaincantbeempty' => 'A domain név nem lehet üres.',
		'domainexistalready' => 'A(z) %s domain már létezik.',
		'domainisaliasorothercustomer' => 'A kiválasztott alias domain vagy maga is egy alias domain, vagy más IP/port kombinációval rendelkezik, vagy egy másik ügyfélhez tartozik.',
		'emailexistalready' => 'A(z) %s e-mail cím már létezik.',
		'maindomainnonexist' => 'A(z) %s fő domain nem létezik.',
		'maindomaindeactivated' => 'A(z) %s fő domain deaktiválva van.',
		'destinationnonexist' => 'Kérjük, hozza létre a továbbítót a \'Cél\' mezőben.',
		'destinationalreadyexistasmail' => 'A(z) %s címre történő továbbítás már létezik aktív e-mail címként.',
		'destinationalreadyexist' => 'Már definiált egy továbbítót a(z) "%s" címre',
		'destinationiswrong' => 'A(z) %s továbbító érvénytelen karakter(eke)t tartalmaz vagy hiányos.',
		'dumpfoldercannotbedocroot' => 'Az adatmentések mappája nem lehet a saját könyvtára, kérjük, válasszon egy mappát a saját könyvtárán belül, pl. /dumps',
		'templatelanguagecombodefined' => 'A kiválasztott nyelv/sablon kombináció már definiálva van.',
		'templatelanguageinvalid' => 'A kiválasztott nyelv nem létezik',
		'ipstillhasdomains' => 'A törölni kívánt IP/Port kombinációhoz még tartoznak domainek, kérjük, rendelje át ezeket más IP/Port kombinációkhoz, mielőtt törölné ezt az IP/Port kombinációt.',
		'cantdeletedefaultip' => 'Nem törölheti az alapértelmezett IP/Port kombinációt, kérjük, állítson be egy másik IP/Port kombinációt alapértelmezettként, mielőtt törölné ezt az IP/Port kombinációt.',
		'cantdeletesystemip' => 'Nem törölheti az utolsó rendszer IP-t, vagy hozzon létre egy új IP/Port kombinációt a rendszer IP-hez, vagy változtassa meg a rendszer IP-t.',
		'myipaddress' => '\'IP\'',
		'myport' => '\'Port\'',
		'myipdefault' => 'Ki kell választania egy IP/Port kombinációt, amely alapértelmezett lesz.',
		'myipnotdouble' => 'Ez az IP/Port kombináció már létezik.',
		'admin_domain_emailsystemhostname' => 'A szerver-hosztnév nem használható ügyfél-domainként.',
		'cantchangesystemip' => 'Nem változtathatja meg az utolsó rendszer IP-t, vagy hozzon létre egy másik új IP/Port kombinációt a rendszer IP-hez, vagy változtassa meg a rendszer IP-t.',
		'sessiontimeoutiswrong' => 'Csak numerikus "munkamenet időtúllépés" engedélyezett.',
		'maxloginattemptsiswrong' => 'Csak numerikus "maximális bejelentkezési kísérletek" engedélyezettek.',
		'deactivatetimiswrong' => 'Csak numerikus "deaktiválási idő" engedélyezett.',
		'accountprefixiswrong' => 'Az "ügyfél-előtag" helytelen.',
		'mysqlprefixiswrong' => 'Az "SQL előtag" helytelen.',
		'ftpprefixiswrong' => 'Az "FTP előtag" helytelen.',
		'ipiswrong' => 'Az "IP-cím" helytelen. Csak érvényes IP-cím engedélyezett.',
		'vmailuidiswrong' => 'A "levelek-uid" helytelen. Csak numerikus UID engedélyezett.',
		'vmailgidiswrong' => 'A "levelek-gid" helytelen. Csak numerikus GID engedélyezett.',
		'adminmailiswrong' => 'A "feladó-cím" helytelen. Csak érvényes e-mail cím engedélyezett.',
		'pagingiswrong' => 'Az "bejegyzések oldalanként" érték helytelen. Csak numerikus karakterek engedélyezettek.',
		'phpmyadminiswrong' => 'A phpMyAdmin-link nem érvényes link.',
		'webmailiswrong' => 'A webmail-link nem érvényes link.',
		'webftpiswrong' => 'A WebFTP-link nem érvényes link.',
		'stringformaterror' => 'A(z) "%s" mező értéke nem a várt formátumban van.',
		'loginnameisusingprefix' => 'Nem hozhat létre olyan fiókokat, amelyek "%s"-vel kezdődnek, mivel ez az előtag az automatikus fióknévadáshoz van beállítva. Kérjük, adjon meg másik fióknevet.',
		'loginnameissystemaccount' => 'A(z) "%s" fiók már létezik a rendszeren, és nem használható. Kérjük, adjon meg másik fióknevet.',
		'loginnameisreservedname' => 'A(z) "%s" fióknév a rendszer belső használatára van fenntartva, és nem használható.',
		'youcantdeleteyourself' => 'Biztonsági okokból nem törölheti saját magát.',
		'youcanteditallfieldsofyourself' => 'Megjegyzés: Biztonsági okokból nem szerkesztheti saját fiókjának minden mezőjét.',
		'documentrootexists' => 'A(z) "%s" könyvtár már létezik ennél az ügyfélnél. Kérjük, távolítsa el ezt, mielőtt újra hozzáadná az ügyfelet.',
		'norepymailiswrong' => 'A "Noreply-cím" helytelen. Csak érvényes e-mail cím engedélyezett.',
		'logerror' => 'Naplózási hiba: %s',
		'nomessagetosend' => 'Nem adott meg üzenetet.',
		'norecipientsgiven' => 'Nem adott meg címzettet',
		'errorsendingmail' => 'Az üzenet küldése a következő címre sikertelen: "%s"',
		'errorsendingmailpub' => 'Az üzenet küldése a megadott e-mail címre sikertelen',
		'cannotreaddir' => 'Nem lehet olvasni a(z) "%s" könyvtárat',
		'invalidip' => 'Érvénytelen IP-cím: %s',
		'invalidmysqlhost' => 'Érvénytelen MySQL host cím: %s',
		'cannotuseawstatsandwebalizeratonetime' => 'Nem engedélyezheti egyszerre a Webalizer és az AWstats használatát, kérjük, válasszon egyet közülük',
		'cannotwritetologfile' => 'Nem lehet megnyitni a(z) %s naplófájlt írásra',
		'vmailquotawrong' => 'A kvótaméretnek pozitív számnak kell lennie.',
		'allocatetoomuchquota' => 'Megpróbált %s MB kvótát kiosztani, de nincs elég szabad helye.',
		'missingfields' => 'Nem minden kötelező mező lett kitöltve.',
		'requiredfield' => 'Ez a mező kötelező.',
		'accountnotexisting' => 'A megadott e-mail fiók nem létezik.',
		'nopermissionsorinvalidid' => 'Nincs elegendő jogosultsága ezeknek a beállításoknak a módosításához, vagy érvénytelen azonosítót adott meg.',
		'phpsettingidwrong' => 'Nem létezik PHP konfiguráció ezzel az azonosítóval',
		'descriptioninvalid' => 'A leírás túl rövid, túl hosszú vagy érvénytelen karaktereket tartalmaz.',
		'info' => 'Információ',
		'filecontentnotset' => 'A fájl nem lehet üres!',
		'customerdoesntexist' => 'A kiválasztott ügyfél nem létezik.',
		'admindoesntexist' => 'A kiválasztott admin nem létezik.',
		'ipportdoesntexist' => 'A kiválasztott ip/port kombináció nem létezik.',
		'usernamealreadyexists' => 'A(z) %s felhasználónév már létezik.',
		'plausibilitychecknotunderstood' => 'A hihetőségi ellenőrzés válasza nem érthető.',
		'errorwhensaving' => 'Hiba történt a(z) %s mező mentésekor',
		'hiddenfieldvaluechanged' => 'A(z) "%s" rejtett mező értéke megváltozott a beállítások szerkesztése közben.<br /><br />Ez általában nem nagy probléma, de a beállításokat nem lehetett elmenteni emiatt.',
		'notrequiredpasswordlength' => 'A megadott jelszó túl rövid. Kérjük, adjon meg legalább %s karaktert.',
		'overviewsettingoptionisnotavalidfield' => 'Hoppá, egy mező, amelynek opcióként kellene megjelennie a beállítások áttekintésében, nem elfogadott típusú. Ezért a fejlesztőket hibáztathatja. Ennek nem szabadna megtörténnie!',
		'pathmaynotcontaincolon' => 'Az Ön által megadott útvonal nem tartalmazhat kettőspontot (":"). Kérjük, adjon meg helyes útvonal értéket.',
		'exception' => '%s',
		'notrequiredpasswordcomplexity' => 'A megadott jelszó-komplexitás nem teljesült.<br />Kérjük, lépjen kapcsolatba az adminisztrátorával, ha kérdése van a komplexitási előírásokkal kapcsolatban',
		'invaliderrordocumentvalue' => 'Az ErrorDocument-ként megadott érték nem tűnik érvényes fájlnak, URL-nek vagy karakterláncnak.',
		'intvaluetoolow' => 'A megadott szám túl alacsony (%s mező)',
		'intvaluetoohigh' => 'A megadott szám túl magas (%s mező)',
		'phpfpmstillenabled' => 'A PHP-FPM jelenleg aktív. Kérjük, deaktiválja, mielőtt aktiválná az FCGID-t',
		'fcgidstillenabled' => 'Az FCGID jelenleg aktív. Kérjük, deaktiválja, mielőtt aktiválná a PHP-FPM-et',
		'domains_cantdeletedomainwithaliases' => 'Nem törölhet olyan domaint, amelyet alias-domainekhez használnak. Először törölnie kell az aliasokat.',
		'user_banned' => 'Az Ön fiókja zárolva lett. Kérjük, további információért lépjen kapcsolatba az adminisztrátorával.',
		'session_timeout' => 'Túl alacsony érték',
		'session_timeout_desc' => 'Nem ajánlott a munkamenet időtúllépését 1 percnél alacsonyabbra állítani.',
		'invalidhostname' => 'A hosztnévnek érvényes domainnek kell lennie. Nem lehet üres, és nem állhat csak szóközökből',
		'operationnotpermitted' => 'A művelet nem engedélyezett!',
		'featureisdisabled' => 'A(z) %s funkció le van tiltva. Kérjük, lépjen kapcsolatba a szolgáltatójával.',
		'usercurrentlydeactivated' => 'A(z) %s felhasználó jelenleg deaktiválva van',
		'setlessthanalreadyused' => 'Nem állíthat be kevesebb erőforrást a(z) \'%s\' számára, mint amennyit ez a felhasználó már használ<br />',
		'stringmustntbeempty' => 'A(z) %s mező értéke nem lehet üres',
		'sslcertificateismissingprivatekey' => 'Meg kell adnia egy privát kulcsot a tanúsítványához',
		'sslcertificatewrongdomain' => 'A megadott tanúsítvány nem ehhez a domainhez tartozik',
		'sslcertificateinvalidcert' => 'A megadott tanúsítvány tartalma nem tűnik érvényes tanúsítványnak',
		'sslcertificateinvalidcertkeypair' => 'A megadott privát kulcs nem tartozik a megadott tanúsítványhoz',
		'sslcertificateinvalidca' => 'A megadott CA tanúsítvány adatok nem tűnnek érvényes tanúsítványnak',
		'sslcertificateinvalidchain' => 'A megadott tanúsítványlánc adatok nem tűnnek érvényes tanúsítványnak',
		'givendirnotallowed' => 'A(z) %s mezőben megadott könyvtár nem engedélyezett.',
		'sslredirectonlypossiblewithsslipport' => 'A Let\'s Encrypt használata csak akkor lehetséges, ha a domainhez legalább egy SSL-engedélyezett IP/port kombináció van hozzárendelve.',
		'fcgidstillenableddeadlock' => 'Az FCGID jelenleg aktív.<br />Kérjük, deaktiválja, mielőtt az Apache2 helyett másik webszerverre váltana',
		'send_report_title' => 'Hibajelentés küldése',
		'send_report_desc' => 'Köszönjük, hogy jelenti ezt a hibát és segít a froxlor fejlesztésében.<br />Ez az e-mail, amely a froxlor fejlesztői csapatának lesz elküldve:',
		'send_report' => 'Jelentés küldése',
		'send_report_error' => 'Hiba történt a jelentés küldésekor: <br />%s',
		'notallowedtouseaccounts' => 'Az Ön fiókja nem teszi lehetővé az IMAP/POP3 használatát. Nem adhat hozzá e-mail fiókokat.',
		'cannotdeletehostnamephpconfig' => 'Ez a PHP-konfiguráció a froxlor-vhost által használt, és nem törölhető.',
		'cannotdeletedefaultphpconfig' => 'Ez a PHP-konfiguráció alapértelmezettként van beállítva, és nem törölhető.',
		'passwordshouldnotbeusername' => 'A jelszó nem lehet ugyanaz, mint a felhasználónév.',
		'no_phpinfo' => 'Sajnáljuk, nem sikerült beolvasni a phpinfo() adatait',
		'moveofcustomerfailed' => 'Az ügyfél áthelyezése a kiválasztott adminisztrátorhoz/viszonteladóhoz sikertelen. Vegye figyelembe, hogy az ügyfélre vonatkozó minden egyéb módosítás sikeresen megtörtént ezen a ponton.<br><br>Hibaüzenet: %s',
		'domain_import_error' => 'A következő hiba történt a domainek importálása során: %s',
		'fcgidandphpfpmnogoodtogether' => 'Az FCGID és a PHP-FPM nem aktiválható egyidejűleg',
		'no_apcuinfo' => 'Nincs elérhető gyorsítótár információ. Úgy tűnik, az APCu nem fut.',
		'no_opcacheinfo' => 'Nincs elérhető OPCache információ. Úgy tűnik, az OPCache nincs betöltve.',
		'inactive_opcacheinfo' => 'Úgy tűnik, az OPCache telepítve van, de nincs aktiválva.',
		'nowildcardwithletsencrypt' => 'A Let\'s Encrypt nem tud kezelni helyettesítő karakteres domaineket az ACME használatával a froxlorban (dns-kihívást igényel), sajnáljuk. Kérjük, állítsa a ServerAlias-t WWW-re, vagy teljesen tiltsa le',
		'customized_version' => 'Úgy tűnik, hogy a froxlor telepítése módosítva lett, sajnos nem tudunk támogatást nyújtani.',
		'autoupdate_0' => 'Ismeretlen hiba',
		'autoupdate_1' => 'A PHP allow_url_fopen beállítás le van tiltva. Az automatikus frissítéshez engedélyezni kell ezt a beállítást a php.ini fájlban',
		'autoupdate_2' => 'A PHP zip kiterjesztés nem található, kérjük, győződjön meg arról, hogy telepítve van és aktiválva van',
		'autoupdate_4' => 'A froxlor archívumot nem lehetett a lemezre menteni :(',
		'autoupdate_5' => 'A version.froxlor.org elfogadhatatlan értékeket adott vissza :(',
		'autoupdate_6' => 'Hoppá, nem volt megadva (érvényes) verzió a letöltéshez :(',
		'autoupdate_7' => 'A letöltött archívum nem található :(',
		'autoupdate_8' => 'Az archívumot nem lehetett kicsomagolni :(',
		'autoupdate_9' => 'A letöltött fájl nem felelt meg az integritás ellenőrzésnek. Kérjük, próbálja meg újra a frissítést.',
		'autoupdate_10' => 'A PHP minimálisan támogatott verziója 7.4.0',
		'autoupdate_11' => 'A webfrissítés le van tiltva',
		'mailaccistobedeleted' => 'Egy másik fiók ugyanezzel a névvel (%s) jelenleg törlés alatt áll, ezért most nem adható hozzá.',
		'customerhasongoingexportjob' => 'Már van egy adatexport feladat, amely feldolgozásra vár, kérjük, legyen türelemmel.',
		'exportfunctionnotenabled' => 'Az exportálási funkció nincs engedélyezve',
		'dns_domain_nodns' => 'A DNS nincs engedélyezve ehhez a domainhez',
		'dns_content_empty' => 'Nincs megadva tartalom',
		'dns_content_invalid' => 'Érvénytelen DNS tartalom',
		'dns_arec_noipv4' => 'Nem adtak meg érvényes IP-címet az A-rekordhoz',
		'dns_aaaarec_noipv6' => 'Nem adtak meg érvényes IP-címet az AAAA-rekordhoz',
		'dns_mx_prioempty' => 'Érvénytelen MX prioritás megadva',
		'dns_mx_needdom' => 'Az MX tartalom értékének érvényes domain névnek kell lennie',
		'dns_mx_noalias' => 'Az MX-tartalom értéke nem lehet CNAME bejegyzés.',
		'dns_cname_invaliddom' => 'Érvénytelen domain név a CNAME rekordhoz',
		'dns_cname_nomorerr' => 'Már létezik egy erőforrás-rekord ugyanazzal a rekordnévvel. Nem használható CNAME-ként.',
		'dns_other_nomorerr' => 'Már létezik egy CNAME rekord ugyanazzal a rekordnévvel. Nem használható más típushoz.',
		'dns_ns_invaliddom' => 'Érvénytelen domain név az NS rekordhoz',
		'dns_srv_prioempty' => 'Érvénytelen SRV prioritás megadva',
		'dns_srv_invalidcontent' => 'Érvénytelen SRV tartalom, a súly, port és cél mezőkből kell állnia, pl.: 5 5060 sipserver.example.com.',
		'dns_srv_needdom' => 'Az SRV cél értékének érvényes domain névnek kell lennie',
		'dns_srv_noalias' => 'Az SRV-cél értéke nem lehet CNAME bejegyzés.',
		'dns_duplicate_entry' => 'A rekord már létezik',
		'dns_notfoundorallowed' => 'A domain nem található vagy nincs jogosultsága',
		'domain_nopunycode' => 'Nem adhat meg punycode-ot (IDNA). A domain automatikusan konvertálva lesz',
		'domain_noipaddress' => 'Nem adható hozzá IP-cím domainként',
		'dns_record_toolong' => 'A rekordok/címkék legfeljebb 63 karakterből állhatnak',
		'noipportgiven' => 'Nincs megadva IP/port',
		'nosslippportgiven' => 'SSL engedélyezésekor ki kell választania egy SSL IP/port kombinációt',
		'jsonextensionnotfound' => 'Ez a funkció a php json-kiterjesztést igényli.',
		'cannotdeletesuperadmin' => 'Az első adminisztrátor nem törölhető.',
		'no_wwwcnamae_ifwwwalias' => 'Nem állítható be CNAME rekord a "www" számára, mivel a domain úgy van beállítva, hogy www-aliast generáljon. Kérjük, módosítsa a beállításokat "Nincs alias" vagy "Helyettesítő karakter alias" értékre',
		'local_group_exists' => 'A megadott csoport már létezik a rendszeren.',
		'local_group_invalid' => 'A megadott csoportnév érvénytelen',
		'invaliddnsforletsencrypt' => 'A domain DNS-e nem tartalmazza a kiválasztott IP-címek egyikét sem. A Let\'s Encrypt tanúsítvány generálása nem lehetséges.',
		'notallowedphpconfigused' => 'Olyan php-konfigurációt próbál használni, amely nincs hozzárendelve az ügyfélhez',
		'pathmustberelative' => 'A felhasználónak nincs jogosultsága a vásárló saját könyvtárán kívüli könyvtárak megadására. Kérjük, adjon meg relatív útvonalat (kezdő / nélkül).',
		'mysqlserverstillhasdbs' => 'Nem lehet eltávolítani az adatbázis-szervert a vásárlók engedélyezési listájáról, mert még vannak rajta adatbázisok.',
		'domaincannotbeedited' => 'Nincs jogosultsága a(z) %s domain szerkesztésére',
		'invalidcronjobintervalvalue' => 'A cron feladat intervallumának a következők egyikének kell lennie: %s',
		'phpgdextensionnotavailable' => 'A PHP GD kiterjesztés nem érhető el. Nem lehet ellenőrizni a képadatokat',
		'2fa_wrongcode' => 'A megadott kód érvénytelen',
		'gnupgextensionnotavailable' => 'A PHP GnuPG kiterjesztés nem érhető el. Nem lehet ellenőrizni a PGP nyilvános kulcsot',
		'invalidpgppublickey' => 'A PGP nyilvános kulcs érvénytelen',
		'invalid_validtime' => 'Az érvényességi idő másodpercben csak 10 és 120 között lehet',
		'customerphpenabledbutnoconfig' => 'A vásárlónál a PHP aktiválva van, de nincs kiválasztva PHP-konfiguráció.',
		'emaildomainstillhasaddresses' => 'Nem lehet deaktiválni a levelezési domain jelzőt, mert még vannak e-mail címek ehhez a domainhez.',
	],
	'extras' => [
		'description' => 'Itt hozzáadhat néhány extrát, például könyvtárvédelmet.<br />A rendszernek időre van szüksége az új beállítások alkalmazásához minden változtatás után.',
		'directoryprotection_add' => 'Könyvtárvédelem hozzáadása',
		'view_directory' => 'Könyvtár tartalmának megjelenítése',
		'pathoptions_add' => 'Útvonal opciók hozzáadása',
		'directory_browsing' => 'Könyvtár tartalmának böngészése',
		'pathoptions_edit' => 'Útvonal opciók szerkesztése',
		'error404path' => '404',
		'error403path' => '403',
		'error500path' => '500',
		'error401path' => '401',
		'errordocument404path' => 'ErrorDocument 404',
		'errordocument403path' => 'ErrorDocument 403',
		'errordocument500path' => 'ErrorDocument 500',
		'errordocument401path' => 'ErrorDocument 401',
		'execute_perl' => 'Perl/CGI végrehajtása',
		'htpasswdauthname' => 'Hitelesítés oka (AuthName)',
		'directoryprotection_edit' => 'Könyvtárvédelem szerkesztése',
		'export' => 'Adatmentés létrehozása',
		'dump_web' => 'Webadatok belefoglalása',
		'dump_mail' => 'Levelezési adatok belefoglalása',
		'dump_dbs' => 'Adatbázisok belefoglalása',
		'path_protection_label' => '<strong class="text-danger">Fontos</strong>',
		'path_protection_info' => 'Erősen javasoljuk a megadott útvonal védelmét, lásd "Extrák" -> "Könyvtárvédelem"',
	],
	'ftp' => [
		'description' => 'Itt hozhatja létre és módosíthatja FTP-fiókjait.<br />A változtatások azonnal életbe lépnek, és a fiókok azonnal használhatók.',
		'account_add' => 'Fiók létrehozása',
		'account_edit' => 'FTP-fiók szerkesztése',
		'editpassdescription' => 'Állítson be új jelszót, vagy hagyja üresen, ha nem kívánja megváltoztatni.',
	],
	'gender' => [
		'title' => 'Megszólítás',
		'male' => 'Úr',
		'female' => 'Hölgy',
		'undef' => '',
	],
	'imprint' => 'Jogi megjegyzések',
	'index' => [
		'customerdetails' => 'Vásárló adatai',
		'accountdetails' => 'Fiók adatai',
	],
	'integrity_check' => [
		'databaseCharset' => 'Adatbázis karakterkészlete (UTF-8 ajánlott)',
		'domainIpTable' => 'IP &lt;&dash;&gt; domain hivatkozások',
		'subdomainSslRedirect' => 'Hibás SSL-átirányítási jelző nem SSL-es domainekhez',
		'froxlorLocalGroupMemberForFcgidPhpFpm' => 'froxlor-felhasználó az ügyfélcsoportokban (FCGID/php-fpm esetén)',
		'webserverGroupMemberForFcgidPhpFpm' => 'Webszerver-felhasználó az ügyfélcsoportokban (FCGID/php-fpm esetén)',
		'subdomainLetsencrypt' => 'SSL-port nélküli fő domaineknek nincsenek aktív SSL átirányítású aldomainjeik',
	],
	'logger' => [
		'date' => 'Dátum',
		'type' => 'Típus',
		'action' => 'Művelet',
		'user' => 'Felhasználó',
		'truncate' => 'Napló ürítése',
		'reseller' => 'Viszonteladó',
		'admin' => 'Adminisztrátor',
		'cron' => 'Ütemezett feladat',
		'login' => 'Bejelentkezés',
		'intern' => 'Belső',
		'unknown' => 'Ismeretlen',
	],
	'login' => [
		'username' => 'Felhasználónév',
		'password' => 'Jelszó',
		'language' => 'Nyelv',
		'login' => 'Bejelentkezés',
		'logout' => 'Kijelentkezés',
		'profile_lng' => 'Profil nyelve',
		'welcomemsg' => 'Kérjük, jelentkezzen be a fiókjához.',
		'forgotpwd' => 'Elfelejtette jelszavát?',
		'presend' => 'Jelszó visszaállítása',
		'email' => 'E-mail cím',
		'remind' => 'Jelszavam visszaállítása',
		'usernotfound' => 'Felhasználó nem található!',
		'backtologin' => 'Vissza a bejelentkezéshez',
		'combination_not_found' => 'A felhasználó és e-mail cím kombinációja nem található.',
		'2fa' => 'Kétfaktoros hitelesítés (2FA)',
		'2facode' => 'Kérjük, adja meg a 2FA kódot',
		'2faremember' => 'Böngésző megjegyzése',
	],
	'mails' => [
		'pop_success' => [
			'mailbody' => 'Üdvözöljük,\\n\\ne-mail fiókja {EMAIL}\\nsikeresen beállításra került.\\n\\nEz egy automatikusan létrehozott\\ne-mail, kérjük, ne válaszoljon rá!\\n\\nÜdvözlettel, az adminisztrátor',
			'subject' => 'E-mail fiók sikeresen beállítva',
		],
		'createcustomer' => [
			'mailbody' => 'Tisztelt {SALUTATION},\\n\\níme a fiókja adatai:\\n\\nFelhasználónév: {USERNAME}\\nJelszó: {PASSWORD}\\n\\nKöszönjük,\\naz adminisztrátor',
			'subject' => 'Fiók információk',
		],
		'pop_success_alternative' => [
			'mailbody' => 'Tisztelt {SALUTATION},\\n\\ne-mail fiókja {EMAIL}\\nsikeresen beállításra került.\\nA jelszava: {PASSWORD}.\\n\\nEz egy automatikusan létrehozott\\ne-mail, kérjük, ne válaszoljon rá!\\n\\nÜdvözlettel, az adminisztrátor',
			'subject' => 'E-mail fiók sikeresen beállítva',
		],
		'password_reset' => [
			'subject' => 'Jelszó visszaállítása',
			'mailbody' => 'Tisztelt {SALUTATION},\\n\\níme a link az új jelszó beállításához. Ez a link a következő 24 órában érvényes.\\n\\n{LINK}\\n\\nKöszönjük,\\naz adminisztrátor',
		],
		'new_database_by_customer' => [
			'subject' => '[froxlor] Új adatbázis létrehozva',
			'mailbody' => 'Tisztelt {CUST_NAME},

Ön éppen most hozott létre egy új adatbázist. Íme a megadott információk:

Adatbázis neve: {DB_NAME}
Jelszó: {DB_PASS}
Leírás: {DB_DESC}
DB-Hoszt: {DB_SRV}
phpMyAdmin: {PMA_URI}
Üdvözlettel, az adminisztrátor',
		],
		'new_ftpaccount_by_customer' => [
			'subject' => 'Új ftp-felhasználó létrehozva',
			'mailbody' => 'Tisztelt {CUST_NAME},

Ön éppen most hozott létre egy új ftp-felhasználót. Íme a megadott információk:

Felhasználónév: {USR_NAME}
Jelszó: {USR_PASS}
Útvonal: {USR_PATH}

Üdvözlettel, az adminisztrátor',
		],
		'trafficmaxpercent' => [
			'mailbody' => 'Tisztelt {SALUTATION},\\n\\nÖn felhasználta a rendelkezésre álló {TRAFFIC} forgalomból {TRAFFICUSED} mennyiséget.\\nEz több mint {MAX_PERCENT}%%.\\n\\nÜdvözlettel, az adminisztrátor',
			'subject' => 'Forgalmi korlát elérése',
		],
		'diskmaxpercent' => [
			'mailbody' => 'Tisztelt {SALUTATION},\\n\\nÖn felhasználta a rendelkezésre álló {DISKAVAILABLE} tárhelyből {DISKUSED} mennyiséget.\\nEz több mint {MAX_PERCENT}%%.\\n\\nÜdvözlettel, az adminisztrátor',
			'subject' => 'Tárhely korlát elérése',
		],
		'2fa' => [
			'mailbody' => 'Üdvözöljük,\\n\\naz Ön 2FA bejelentkezési kódja: {CODE}.\\n\\nEz egy automatikusan létrehozott\\ne-mail, kérjük, ne válaszoljon rá!\\n\\nÜdvözlettel, az adminisztrátor',
			'subject' => 'froxlor - 2FA Kód',
		],
	],
	'menue' => [
		'main' => [
			'main' => 'Főoldal',
			'changepassword' => 'Jelszó módosítása',
			'changelanguage' => 'Nyelv módosítása',
			'username' => 'Bejelentkezve mint: ',
			'changetheme' => 'Téma módosítása',
			'apihelp' => 'API segítség',
			'apikeys' => 'API kulcsok',
		],
		'email' => [
			'email' => 'E-mail',
			'emails' => 'Címek',
			'webmail' => 'Webmail',
			'emailsoverview' => 'E-mail domainek áttekintése',
		],
		'mysql' => [
			'mysql' => 'MySQL',
			'databases' => 'Adatbázisok',
			'phpmyadmin' => 'phpMyAdmin',
		],
		'domains' => [
			'domains' => 'Domainek',
			'settings' => 'Domainek áttekintése',
		],
		'ftp' => [
			'ftp' => 'FTP',
			'accounts' => 'Fiókok',
			'webftp' => 'WebFTP',
		],
		'extras' => [
			'extras' => 'Extrák',
			'directoryprotection' => 'Könyvtárvédelem',
			'pathoptions' => 'Útvonal beállítások',
			'export' => 'Adatexport',
		],
		'traffic' => [
			'traffic' => 'Forgalom',
			'current' => 'Aktuális hónap',
			'overview' => 'Teljes forgalom',
		],
		'phpsettings' => [
			'maintitle' => 'PHP konfigurációk',
			'fpmdaemons' => 'PHP-FPM verziók',
		],
		'logger' => [
			'logger' => 'Rendszernapló',
		],
	],
	'message' => [
		'norecipients' => 'Nem került e-mail kiküldésre, mert nincsenek címzettek az adatbázisban',
		'success' => 'Sikeresen elküldve %s címzettnek',
	],
	'mysql' => [
		'databasename' => 'Felhasználó/Adatbázis név',
		'databasedescription' => 'Adatbázis leírása',
		'database_create' => 'Adatbázis létrehozása',
		'description' => 'Itt hozhatja létre és módosíthatja MySQL adatbázisait.<br />A változtatások azonnal életbe lépnek, és az adatbázis azonnal használható.<br />A bal oldali menüben találja a phpMyAdmin eszközt, amellyel könnyen kezelheti adatbázisát.<br /><br />Saját PHP szkriptjeiben az adatbázisok használatához a következő beállításokat használja: (A <i>dőlt betűs</i> adatokat cserélje ki a megfelelő értékekre!)<br />Kiszolgáló: <b><SQL_HOST></b><br />Felhasználónév: <b><i>adatbázisnév</i></b><br />Jelszó: <b><i>az Ön által választott jelszó</i></b><br />Adatbázis: <b><i>adatbázisnév</i></b>',
		'mysql_server' => 'MySQL-Szerver',
		'database_edit' => 'Adatbázis szerkesztése',
		'size' => 'Méret',
		'privileged_user' => 'Privilegizált adatbázis felhasználó',
		'privileged_passwd' => 'Jelszó a privilegizált felhasználóhoz',
		'unprivileged_passwd' => 'Jelszó a nem privilegizált felhasználóhoz',
		'mysql_ssl_ca_file' => 'SSL szerver tanúsítvány',
		'mysql_ssl_verify_server_certificate' => 'SSL szerver tanúsítvány ellenőrzése',
		'globaluserinfo' => 'Az adatbázisok eléréséhez használhatja a froxlor bejelentkezési adatait is (felhasználó: %s), amely automatikusan hozzáfér az összes adatbázisához.<br />Ajánlott <b>nem</b> használni ezt alkalmazásokhoz, csak adminisztrációhoz (pl. phpMyAdmin-on keresztül).',
		'edit_global_user' => 'Admin felhasználó szerkesztése',
	],
	'opcacheinfo' => [
		'generaltitle' => 'Általános információk',
		'resetcache' => 'OPcache visszaállítása',
		'version' => 'OPCache verzió',
		'phpversion' => 'PHP verzió',
		'runtimeconf' => 'Futásidejű konfiguráció',
		'start' => 'Indítás ideje',
		'lastreset' => 'Utolsó újraindítás',
		'oomrestarts' => 'OOM újraindítások száma',
		'hashrestarts' => 'Hash újraindítások száma',
		'manualrestarts' => 'Manuális újraindítások száma',
		'hitsc' => 'Találatok száma',
		'missc' => 'Hiányzások száma',
		'blmissc' => 'Feketelista hiányzások száma',
		'status' => 'Állapot',
		'never' => 'soha',
		'enabled' => 'OPcache engedélyezve',
		'cachefull' => 'Gyorsítótár tele',
		'restartpending' => 'Újraindítás függőben',
		'restartinprogress' => 'Újraindítás folyamatban',
		'cachedscripts' => 'Gyorsítótárazott szkriptek száma',
		'memusage' => 'Memóriahasználat',
		'totalmem' => 'Teljes memória',
		'usedmem' => 'Használt memória',
		'freemem' => 'Szabad memória',
		'wastedmem' => 'Elpazarolt memória',
		'maxkey' => 'Maximális kulcsok',
		'usedkey' => 'Használt kulcsok',
		'wastedkey' => 'Elpazarolt kulcsok',
		'strinterning' => 'String internálás',
		'strcount' => 'String szám',
		'keystat' => 'Gyorsítótárazott kulcsok statisztikája',
		'used' => 'Használt',
		'free' => 'Szabad',
		'blacklist' => 'Feketelista',
		'novalue' => '<i>nincs érték</i>',
		'true' => '<i>igaz</i>',
		'false' => '<i>hamis</i>',
		'funcsavail' => 'Elérhető funkciók',
	],
	'panel' => [
		'edit' => 'Szerkesztés',
		'delete' => 'Törlés',
		'create' => 'Létrehozás',
		'save' => 'Mentés',
		'yes' => 'Igen',
		'no' => 'Nem',
		'emptyfornochanges' => 'üresen hagyva nem változik',
		'emptyfordefault' => 'üresen hagyva alapértelmezett',
		'path' => 'Útvonal',
		'toggle' => 'Váltás',
		'next' => 'Következő',
		'dirsmissing' => 'Nem található vagy nem olvasható a könyvtár!',
		'unlimited' => '∞',
		'urloverridespath' => 'URL (felülírja az útvonalat)',
		'pathorurl' => 'Útvonal vagy URL',
		'ascending' => 'növekvő',
		'descending' => 'csökkenő',
		'search' => 'Keresés',
		'used' => 'használt',
		'translator' => 'Fordító',
		'reset' => 'Változtatások elvetése',
		'pathDescription' => 'Ha a könyvtár nem létezik, automatikusan létrehozásra kerül.',
		'pathDescriptionEx' => '<br /><br /><span class="text-danger">Kérjük, vegye figyelembe:</span> A <code>/</code> útvonal nem engedélyezett az adminisztratív beállítások miatt, automatikusan <code>/választott.aldomain.tld/</code> értékre lesz állítva, ha nem állítja be másik könyvtárra.',
		'pathDescriptionSubdomain' => 'Ha a könyvtár nem létezik, automatikusan létrehozásra kerül.<br /><br />Ha másik domainre szeretne átirányítani, akkor ennek a bejegyzésnek http:// vagy https:// előtaggal kell kezdődnie.<br /><br />Ha az URL /-rel végződik, akkor mappának tekintjük, ha nem, akkor fájlként kezeljük.',
		'back' => 'Vissza',
		'reseller' => 'viszonteladó',
		'admin' => 'admin',
		'customer' => 'ügyfél/ügyfelek',
		'send' => 'küldés',
		'nosslipsavailable' => 'Jelenleg nincsenek ssl ip/port kombinációk ehhez a szerverhez',
		'backtooverview' => 'Vissza az áttekintéshez',
		'dateformat' => 'ÉÉÉÉ-HH-NN',
		'dateformat_function' => 'Y-m-d',
		'timeformat_function' => 'H:i:s',
		'default' => 'Alapértelmezett',
		'never' => 'Soha',
		'active' => 'Aktív',
		'please_choose' => 'Kérjük, válasszon',
		'allow_modifications' => 'Módosítások engedélyezése',
		'megabyte' => 'MegaByte',
		'not_supported' => 'Nem támogatott: ',
		'view' => 'megtekintés',
		'toomanydirs' => 'Túl sok alkönyvtár. Visszatérés a manuális útvonal-kiválasztáshoz.',
		'abort' => 'Megszakítás',
		'not_activated' => 'nincs aktiválva',
		'off' => 'ki',
		'options' => 'Opciók',
		'neverloggedin' => 'Még nem jelentkezett be',
		'descriptionerrordocument' => 'Lehet URL, fájl útvonala vagy egyszerűen egy " " közé zárt szöveg.<br />Hagyja üresen a szerver alapértelmezett értékének használatához.',
		'unlock' => 'Feloldás',
		'theme' => 'Téma',
		'variable' => 'Változó',
		'description' => 'Leírás',
		'cancel' => 'Mégse',
		'ssleditor' => 'SSL beállítások ehhez a domainhez',
		'ssleditor_infoshared' => 'Jelenleg a szülődomain tanúsítványát használja',
		'ssleditor_infoglobal' => 'Jelenleg globális tanúsítványt használ',
		'dashboard' => 'Irányítópult',
		'assigned' => 'Hozzárendelt',
		'available' => 'Elérhető',
		'news' => 'Hírek',
		'newsfeed_disabled' => 'A hírcsatorna le van tiltva. Kattintson a szerkesztés ikonra a beállításokhoz való ugráshoz.',
		'ftpdesc' => 'FTP leírás',
		'letsencrypt' => 'Let\'s encrypt használata',
		'set' => 'Alkalmaz',
		'shell' => 'Shell',
		'exportpath' => [
			'title' => 'Az exportált adatok célútvonala',
			'description' => 'Ez az az útvonal, ahol az export-archívum tárolva lesz. Ha web-adatok is szerepelnek, az összes fájl a kezdőkönyvtárból tárolva lesz, kivéve az itt megadott mappát.',
		],
		'export_pgp_public_key' => [
			'title' => 'Nyilvános PGP kulcs a titkosításhoz',
			'description' => 'Ez a nyilvános PGP kulcs, amelyet az export titkosításához használnak. Ha ezt a mezőt üresen hagyja, az export nem lesz titkosítva.',
		],
		'pgp_public_key' => 'Nyilvános PGP kulcs',
		'none_value' => 'Nincs',
		'viewlogs' => 'Naplófájlok megtekintése',
		'not_configured' => 'A rendszer még nincs konfigurálva. Kattintson ide a konfigurációkhoz való ugráshoz.',
		'ihave_configured' => 'Konfiguráltam a szolgáltatásokat',
		'system_is_configured' => '<i class="fa-solid fa-circle-exclamation me-1"></i>A rendszer már konfigurálva van',
		'settings_before_configuration' => 'Kérjük, győződjön meg róla, hogy a beállításokat a szolgáltatások konfigurálása előtt módosította',
		'image_field_delete' => 'A meglévő kép törlése',
		'usage_statistics' => 'Erőforrás-használat',
		'security_question' => 'Biztonsági kérdés',
		'listing_empty' => 'Nincsenek bejegyzések',
		'unspecified' => 'nincs megadva',
		'settingsmode' => 'Mód',
		'settingsmodebasic' => 'Alap',
		'settingsmodeadvanced' => 'Haladó',
		'settingsmodetoggle' => 'Kattintson a mód váltásához',
		'modalclose' => 'Bezárás',
		'managetablecolumnsmodal' => [
			'title' => 'Táblázat oszlopainak kezelése',
			'description' => 'Itt testreszabhatja a látható oszlopokat',
		],
		'mandatoryfield' => 'A mező kötelező',
		'select_all' => 'Összes kiválasztása',
		'unselect_all' => 'Összes kiválasztásának megszüntetése',
		'searchtablecolumnsmodal' => [
			'title' => 'Keresés a mezőkben',
			'description' => 'Válassza ki a mezőt, amelyben keresni szeretne'
		],
		'upload_import' => 'Feltöltés és importálás',
		'profile' => 'Profilom',
		'use_checkbox_for_unlimited' => 'A "0" érték deaktiválja ezt az erőforrást. A jobb oldali jelölőnégyzet lehetővé teszi a "korlátlan" használatot.',
		'use_checkbox_to_disable' => 'A letiltáshoz aktiválja a jelölőnégyzetet a beviteli mező jobb oldalán',
	],
	'phpfpm' => [
		'vhost_httpuser' => 'Helyi felhasználó a PHP-FPM-hez (froxlor vHost)',
		'vhost_httpgroup' => 'Helyi csoport a PHP-FPM-hez (froxlor vHost)',
		'ownvhost' => [
			'title' => 'PHP-FPM engedélyezése a froxlor vHost számára',
			'description' => 'Ha engedélyezve van, a froxlor is egy helyi felhasználó alatt fog futni',
		],
		'use_mod_proxy' => [
			'title' => 'mod_proxy / mod_proxy_fcgi használata',
			'description' => '<strong class="text-danger">Engedélyezni kell, ha Debian 9.x (Stretch) vagy újabb verziót használ</strong>. Aktiválja a php-fpm mod_proxy_fcgi-n keresztüli használatához. Legalább apache-2.4.9 szükséges',
		],
		'ini_flags' => 'Adja meg a lehetséges <strong>php_flag</strong> értékeket a php.ini-hez. Egy bejegyzés soronként',
		'ini_values' => 'Adja meg a lehetséges <strong>php_value</strong> értékeket a php.ini-hez. Egy bejegyzés soronként',
		'ini_admin_flags' => 'Adja meg a lehetséges <strong>php_admin_flag</strong> értékeket a php.ini-hez. Egy bejegyzés soronként',
		'ini_admin_values' => 'Adja meg a lehetséges <strong>php_admin_value</strong> értékeket a php.ini-hez. Egy bejegyzés soronként',
	],
	'privacy' => 'Adatvédelmi irányelvek',
	'pwdreminder' => [
		'success' => 'A jelszó visszaállítása sikeresen kérve. Kérjük, kövesse az e-mailben kapott utasításokat.',
		'notallowed' => 'Ismeretlen felhasználó vagy a jelszó visszaállítása le van tiltva',
		'changed' => 'A jelszava sikeresen frissítve lett. Most már bejelentkezhet az új jelszavával.',
		'wrongcode' => 'Sajnáljuk, az aktiváló kód nem létezik vagy már lejárt.',
		'choosenew' => 'Új jelszó beállítása',
	],
	'question' => [
		'question' => 'Biztonsági kérdés',
		'admin_customer_reallydelete' => 'Valóban törölni szeretné a(z) %s ügyfelet? Ez nem vonható vissza!',
		'admin_domain_reallydelete' => 'Valóban törölni szeretné a(z) %s domaint?<br><span class="text-danger"><strong>MEGJEGYZÉS:</strong> Az összes aldomain, ftp-fiók és e-mail cím/fiók, amely ehhez a domainhez kapcsolódik, eltávolításra kerül!</span>',
		'admin_domain_reallydisablesecuritysetting' => 'Valóban le szeretné tiltani ezt a biztonsági beállítást, az OpenBasedir-t?',
		'admin_admin_reallydelete' => 'Valóban törölni szeretné a(z) %s adminisztrátort? Minden ügyfél és domain az Ön fiókjához lesz áthelyezve.',
		'admin_template_reallydelete' => 'Valóban törölni szeretné a(z) \'%s\' sablont?',
		'domains_reallydelete' => 'Valóban törölni szeretné a(z) %s domaint?',
		'email_reallydelete' => 'Valóban törölni szeretné a(z) %s e-mail címet?',
		'email_reallydelete_account' => 'Valóban törölni szeretné a(z) %s e-mail fiókot?',
		'email_reallydelete_forwarder' => 'Valóban törölni szeretné a(z) %s továbbítót?',
		'extras_reallydelete' => 'Valóban törölni szeretné a(z) %s könyvtárvédelmet?',
		'extras_reallydelete_pathoptions' => 'Valóban törölni szeretné a(z) %s útvonal opciókat?',
		'extras_reallydelete_export' => 'Valóban meg szeretné szakítani a tervezett exportálási feladatot?',
		'ftp_reallydelete' => 'Valóban törölni szeretné a(z) %s FTP-fiókot?',
		'mysql_reallydelete' => 'Valóban törölni szeretné a(z) %s adatbázist? Ez nem vonható vissza!',
		'admin_configs_reallyrebuild' => 'Valóban újra szeretné építeni az összes konfigurációs fájlt?',
		'admin_customer_alsoremovefiles' => 'Felhasználói fájlok is eltávolításra kerüljenek?',
		'admin_customer_alsoremovemail' => 'Teljesen eltávolítja az e-mail adatokat a fájlrendszerből?',
		'admin_customer_alsoremoveftphomedir' => 'Az FTP-felhasználó kezdőkönyvtára is eltávolításra kerüljön?',
		'admin_ip_reallydelete' => 'Valóban törölni szeretné a(z) %s IP címet?',
		'admin_domain_reallydocrootoutofcustomerroot' => 'Biztos benne, hogy a domain dokumentumgyökere nem az ügyfél gyökérkönyvtárában lesz?',
		'admin_counters_reallyupdate' => 'Valóban újra szeretné számolni az erőforrás-használatot?',
		'admin_cleartextmailpws_reallywipe' => 'Valóban törölni szeretné az összes titkosítatlan e-mail fiók jelszavát a mail_users táblából? Ez nem vonható vissza! Az e-mail jelszavak titkosítatlan tárolásának beállítása is KI lesz kapcsolva',
		'logger_reallytruncate' => 'Valóban törölni szeretné a(z) "%s" táblát?',
		'admin_quotas_reallywipe' => 'Valóban törölni szeretné az összes kvótát a mail_users táblából? Ez nem vonható vissza!',
		'admin_quotas_reallyenforce' => 'Valóban érvényesíteni szeretné az alapértelmezett kvótát minden felhasználóra? Ez nem vonható vissza!',
		'phpsetting_reallydelete' => 'Valóban törölni szeretné ezeket a beállításokat? Az összes domain, amely jelenleg ezeket a beállításokat használja, az alapértelmezett konfigurációra lesz változtatva.',
		'fpmsetting_reallydelete' => 'Valóban törölni szeretné ezeket a php-fpm beállításokat? Az összes php konfiguráció, amely jelenleg ezeket a beállításokat használja, az alapértelmezett konfigurációra lesz változtatva.',
		'customer_reallyunlock' => 'Valóban fel szeretné oldani a(z) %s ügyfelet?',
		'admin_integritycheck_reallyfix' => 'Valóban meg szeretné próbálni automatikusan javítani az összes adatbázis integritási problémát?',
		'plan_reallydelete' => 'Valóban törölni szeretné a(z) %s tárhelytervet?',
		'apikey_reallydelete' => 'Valóban törölni szeretné ezt az api-kulcsot?',
		'apikey_reallyadd' => 'Valóban létre szeretne hozni egy új api-kulcsot?',
		'dnsentry_reallydelete' => 'Valóban törölni szeretné ezt a zóna bejegyzést?',
		'certificate_reallydelete' => 'Valóban törölni szeretné ezt a tanúsítványt?',
		'cache_reallydelete' => 'Valóban törölni szeretné a gyorsítótárat?',
		'please_enter_otp' => 'Kérjük, adja meg a 2FA kódot',
		'admin_mysqlserver_reallydelete' => 'Valóban törölni szeretné ezt a MySQL-szervert?',
	],
	'redirect_desc' => [
		'rc_default' => 'alapértelmezett',
		'rc_movedperm' => 'véglegesen áthelyezve',
		'rc_found' => 'megtalálva',
		'rc_seeother' => 'lásd másik',
		'rc_tempred' => 'ideiglenes átirányítás',
	],
	'serversettings' => [
		'session_timeout' => [
			'title' => 'Munkamenet időtúllépés',
			'description' => 'Mennyi ideig kell egy felhasználónak inaktívnak lennie, mielőtt a munkamenet érvénytelenné válik (másodperc)?',
		],
		'accountprefix' => [
			'title' => 'Ügyfél előtag',
			'description' => 'Milyen előtagot kell az ügyfélfiókoknak kapniuk?',
		],
		'mysqlprefix' => [
			'title' => 'SQL előtag',
			'description' => 'Milyen előtagot kell a MySQL fiókoknak kapniuk?</br>Használja a "RANDOM" értéket, hogy 3 számjegyű véletlenszerű előtagot kapjon</br>Használja a "DBNAME" értéket, hogy az adatbázis név mezőt használja az ügyfél névvel együtt előtagként.',
		],
		'ftpprefix' => [
			'title' => 'FTP előtag',
			'description' => 'Milyen előtagot kell az ftp fiókoknak kapniuk?<br/><b>Ha ezt megváltoztatja, akkor meg kell változtatnia a kvóta SQL lekérdezést az FTP szerver konfigurációs fájljában, ha használja!</b> ',
		],
		'documentroot_prefix' => [
			'title' => 'Kezdőkönyvtár',
			'description' => 'Hol kell tárolni az összes kezdőkönyvtárat?',
		],
		'logfiles_directory' => [
			'title' => 'Naplófájlok könyvtára',
			'description' => 'Hol kell tárolni az összes naplófájlt?',
		],
		'logfiles_script' => [
			'title' => 'Egyéni szkript a naplófájlok csövezéséhez',
			'description' => 'Itt megadhat egy szkriptet, és szükség esetén használhatja a <strong>{LOGFILE}, {DOMAIN} és {CUSTOMER}</strong> helyőrzőket. Ha használni szeretné, akkor aktiválnia kell a <strong>Webszerver naplófájlok csövezése</strong> opciót is. Nincs szükség előtagolt cső karakterre.',
		],
		'logfiles_format' => [
			'title' => 'Hozzáférési napló formátum',
			'description' => 'Adjon meg egy egyéni naplóformátumot a webszerver specifikációinak megfelelően, hagyja üresen az alapértelmezettért. A formátumtól függően az idézőjelek közé kell tenni a karakterláncot.<br/>Ha nginx-szel használja, így fog kinézni: <i>log_format frx_custom {CONFIGURED_VALUE}</i>.<br/>Ha Apache-szal használja, így fog kinézni: <i>LogFormat {CONFIGURED_VALUE} frx_custom</i>.<br/><strong>Figyelem</strong>: A kód nem lesz ellenőrizve hibákra. Ha hibákat tartalmaz, a webszerver lehet, hogy nem indul újra!',
		],
		'logfiles_type' => [
			'title' => 'Hozzáférési napló típusa',
			'description' => 'Válasszon a <strong>kombinált</strong> vagy <strong>vhost_combined</strong> közül.',
		],
		'logfiles_piped' => [
			'title' => 'Webszerver naplófájlok csövezése a megadott szkripthez (lásd fent)',
			'description' => 'Ha egyéni szkriptet használ a naplófájlokhoz, akkor aktiválnia kell ezt, hogy végrehajtásra kerüljön',
		],
		'ipaddress' => [
			'title' => 'IP-cím',
			'description' => 'Mi a szerver fő IP-címe?',
		],
		'hostname' => [
			'title' => 'Hosztnév',
			'description' => 'Mi a szerver hosztneve?',
		],
		'apachereload_command' => [
			'title' => 'Webszerver újratöltési parancs',
			'description' => 'Mi a webszerver parancsa a konfigurációs fájlok újratöltéséhez?',
		],
		'bindenable' => [
			'title' => 'Névszerver engedélyezése',
			'description' => 'Itt a névszerver globálisan engedélyezhető és letiltható.',
		],
		'bindconf_directory' => [
			'title' => 'DNS szerver konfigurációs könyvtár',
			'description' => 'Hol kell menteni a dns-szerver konfigurációs fájlokat?',
		],
		'bindreload_command' => [
			'title' => 'DNS szerver újratöltési parancs',
			'description' => 'Mi a parancs a dns szerver démon újratöltéséhez?',
		],
		'vmail_uid' => [
			'title' => 'Levelek-UID',
			'description' => 'Milyen UserID-t kell a leveleknek kapniuk?',
		],
		'vmail_gid' => [
			'title' => 'Levelek-GID',
			'description' => 'Milyen GroupID-t kell a leveleknek kapniuk?',
		],
		'vmail_homedir' => [
			'title' => 'Levelek-kezdőkönyvtár',
			'description' => 'Hol kell tárolni az összes levelet?',
		],
		'adminmail' => [
			'title' => 'Feladó',
			'description' => 'Mi a feladó címe a Panelből küldött e-maileknek?',
		],
		'phpmyadmin_url' => [
			'title' => 'phpMyAdmin URL',
			'description' => 'Mi a phpMyAdmin URL-je? (http(s)://-vel kell kezdődnie)',
		],
		'webmail_url' => [
			'title' => 'Webmail URL',
			'description' => 'Mi a webmail URL-je? (http(s)://-vel kell kezdődnie)',
		],
		'webftp_url' => [
			'title' => 'WebFTP URL',
			'description' => 'Mi a WebFTP URL-je? (http(s)://-vel kell kezdődnie)',
		],
		'language' => [
			'description' => 'Mi a szerver alapértelmezett nyelve?',
		],
		'maxloginattempts' => [
			'title' => 'Maximális bejelentkezési kísérletek',
			'description' => 'Maximális bejelentkezési kísérletek száma, amely után a fiók letiltásra kerül.',
		],
		'deactivatetime' => [
			'title' => 'Letiltási idő',
			'description' => 'Idő (mp.), amíg egy fiók letiltásra kerül túl sok bejelentkezési próbálkozás után.',
		],
		'pathedit' => [
			'title' => 'Útvonal bevitel típusa',
			'description' => 'Útvonalat egy legördülő menüvel vagy egy beviteli mezővel kell kiválasztani?',
		],
		'nameservers' => [
			'title' => 'Névszerverek',
			'description' => 'Egy vesszővel elválasztott lista, amely az összes névszerver hosztnevét tartalmazza. Az első lesz az elsődleges.',
		],
		'mxservers' => [
			'title' => 'MX szerverek',
			'description' => 'Egy vesszővel elválasztott lista, amely egy számot és egy hosztnevet tartalmaz, szóközzel elválasztva (pl. \'10 mx.example.com\') az mx szervereket tartalmazza.',
		],
		'paging' => [
			'title' => 'Bejegyzések oldalanként',
			'description' => 'Hány bejegyzést kell megjeleníteni egy oldalon? (0 = lapozás letiltása)',
		],
		'defaultip' => [
			'title' => 'Alapértelmezett IP/Port',
			'description' => 'Válassza ki az összes IP-címet, amelyet alapértelmezettként szeretne használni új domain-ekhez',
		],
		'defaultsslip' => [
			'title' => 'Alapértelmezett SSL IP/Port',
			'description' => 'Válassza ki az összes SSL-kompatibilis IP-címet, amelyet alapértelmezettként szeretne használni új domain-ekhez',
		],
		'phpappendopenbasedir' => [
			'title' => 'Útvonalak hozzáadása az OpenBasedir-hez',
			'description' => 'Ezek az útvonalak (kettősponttal elválasztva) hozzáadódnak az OpenBasedir-nyilatkozathoz minden vHost-konténerben.',
		],
		'natsorting' => [
			'title' => 'Természetes emberi rendezés használata a listanézetben',
			'description' => 'A listákat web1 -> web2 -> web11 sorrendben rendezi, nem pedig web1 -> web11 -> web2.',
		],
		'deactivateddocroot' => [
			'title' => 'Dokumentumgyökér letiltott felhasználók számára',
			'description' => 'Amikor egy felhasználó letiltásra kerül, ez az útvonal lesz használva dokumentumgyökérként. Hagyja üresen, ha nem szeretne vHost-ot létrehozni.',
		],
		'mailpwcleartext' => [
			'title' => 'E-mail fiókok jelszavainak titkosítatlan mentése az adatbázisban',
			'description' => 'Ha ez be van állítva igenre, akkor az összes jelszó titkosítatlanul (olvashatóan mindenki számára, aki hozzáfér az adatbázishoz) lesz mentve a mail_users táblában. Csak akkor aktiválja ezt, ha SASL-t szeretne használni!',
		],
		'ftpdomain' => [
			'title' => 'FTP fiókok @domain',
			'description' => 'Az ügyfelek létrehozhatnak FTP fiókokat user@customerdomain?',
		],
		'mod_fcgid' => [
			'title' => 'FCGID engedélyezése',
			'description' => 'Használja ezt a PHP futtatásához a megfelelő felhasználói fiókkal.<br /><br /><b>Ehhez speciális webszerver konfiguráció szükséges Apache-hoz, lásd <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/fcgid/">FCGID - kézikönyv</a></b>',
			'configdir' => [
				'title' => 'Konfigurációs könyvtár',
				'description' => 'Hol kell tárolni az összes fcgid-konfigurációs fájlt? Ha nem használ saját fordítású suexec binárist, ami a normál helyzet, akkor ennek az útnak a /var/www alatt kell lennie.<br /><br /><div class="text-danger">MEGJEGYZÉS: Ennek a mappának a tartalma rendszeresen törlődik, ezért kerülje az adatok kézi tárolását benne.</div>',
			],
			'tmpdir' => [
				'title' => 'Ideiglenes könyvtár',
				'description' => 'Hol kell tárolni az ideiglenes könyvtárakat',
			],
			'starter' => [
				'title' => 'Folyamatok domainenként',
				'description' => 'Hány folyamatot kell indítani/engedélyezni domainenként? A 0 érték ajánlott, mert a PHP akkor nagyon hatékonyan kezeli a folyamatok számát.',
			],
			'wrapper' => [
				'title' => 'Wrapper a Vhostokban',
				'description' => 'Hogyan legyen a wrapper beillesztve a Vhostokba',
			],
			'peardir' => [
				'title' => 'Globális PEAR könyvtárak',
				'description' => 'Mely globális PEAR könyvtárakat kell kicserélni minden php.ini konfigurációban? Különböző könyvtárakat kettősponttal kell elválasztani.',
			],
			'maxrequests' => [
				'title' => 'Maximális kérések domainenként',
				'description' => 'Hány kérést engedélyezzen domainenként?',
			],
			'defaultini' => 'Alapértelmezett PHP konfiguráció új domainekhez',
			'defaultini_ownvhost' => 'Alapértelmezett PHP konfiguráció froxlor-vHosthoz',
			'idle_timeout' => [
				'title' => 'Tétlen időkorlát',
				'description' => 'Időkorlát beállítása Mod FastCGI-hez.',
			],
		],
		'sendalternativemail' => [
			'title' => 'Alternatív e-mail cím használata',
			'description' => 'A jelszó e-mailt egy másik címre küldje el az e-mail fiók létrehozása során',
		],
		'apacheconf_vhost' => [
			'title' => 'Webszerver vHost konfigurációs fájl/könyvtárnév',
			'description' => 'Hol legyen tárolva a vHost konfiguráció? Megadhat egy fájlt (minden vHost egy fájlban) vagy könyvtárat (minden vHost saját fájlban) itt.',
		],
		'apacheconf_diroptions' => [
			'title' => 'Webszerver diroptions konfigurációs fájl/könyvtárnév',
			'description' => 'Hol legyen tárolva a diroptions konfiguráció? Megadhat egy fájlt (minden diroptions egy fájlban) vagy könyvtárat (minden diroption saját fájlban) itt.',
		],
		'apacheconf_htpasswddir' => [
			'title' => 'Webszerver htpasswd könyvtárnév',
			'description' => 'Hol legyenek tárolva a htpasswd fájlok a könyvtárvédelemhez?',
		],
		'mysql_access_host' => [
			'title' => 'MySQL-Hozzáférési-Gazdák',
			'description' => 'Egy vesszővel elválasztott lista a gazdákról, ahonnan a felhasználók csatlakozhatnak a MySQL-szerverhez. Alhálózat engedélyezéséhez a hálózati maszk vagy cidr szintaxis érvényes.',
		],
		'webalizer_quiet' => [
			'title' => 'Webalizer kimenet',
			'description' => 'A webalizer-program részletessége',
		],
		'logger' => [
			'enable' => 'Naplózás engedélyezve/letiltva',
			'severity' => 'Naplózási szint',
			'types' => [
				'title' => 'Napló típus(ok)',
				'description' => 'Adja meg a naplótípusokat. Több típus kiválasztásához tartsa lenyomva a CTRL-t a kiválasztás közben.<br />Elérhető naplótípusok: syslog, fájl, mysql',
			],
			'logfile' => [
				'title' => 'Napló fájlnév',
				'description' => 'Csak akkor használatos, ha a napló típus tartalmazza a "fájl"-t. Ez a fájl a froxlor/logs/ könyvtárban lesz létrehozva. Ez a mappa védett a nyilvános hozzáférés ellen.',
			],
			'logcron' => 'Cron feladatok naplózása',
			'logcronoption' => [
				'never' => 'Soha',
				'once' => 'Egyszer',
				'always' => 'Mindig',
			],
		],
		'ssl' => [
			'use_ssl' => [
				'title' => 'SSL használat engedélyezése',
				'description' => 'Jelölje be, ha SSL-t szeretne használni a webszerveréhez',
			],
			'ssl_cert_file' => [
				'title' => 'Az SSL tanúsítvány elérési útja',
				'description' => 'Adja meg az elérési utat, beleértve a .crt vagy .pem fájl (fő tanúsítvány) nevét',
			],
			'openssl_cnf' => 'Alapértelmezések a tanúsítvány fájl létrehozásához',
			'ssl_key_file' => [
				'title' => 'Az SSL kulcsfájl elérési útja',
				'description' => 'Adja meg az elérési utat, beleértve a privát kulcs fájl (.key többnyire) nevét',
			],
			'ssl_ca_file' => [
				'title' => 'Az SSL CA tanúsítvány elérési útja (opcionális)',
				'description' => 'Ügyfél hitelesítés, csak akkor állítsa be, ha tudja, mi az.',
			],
			'ssl_cipher_list' => [
				'title' => 'Az engedélyezett SSL titkosítások konfigurálása',
				'description' => 'Ez egy lista a titkosításokról, amelyeket használni szeretne (vagy nem szeretne) SSL használatakor. A titkosítások listájához és azok beillesztéséhez/kizárásához lásd a "CIPHER LIST FORMAT" és "CIPHER STRINGS" szakaszokat a <a href="https://www.openssl.org/docs/manmaster/man1/openssl-ciphers.html">titkosítások kézikönyv oldalán</a>.<br /><br /><b>Alapértelmezett érték:</b><pre>ECDH+AESGCM:ECDH+AES256:!aNULL:!MD5:!DSS:!DH:!AES128</pre>',
			],
			'apache24_ocsp_cache_path' => [
				'title' => 'Apache 2.4: az OCSP tároló gyorsítótárának elérési útja',
				'description' => 'Az OCSP válaszok tárolására használt gyorsítótár konfigurálása, amelyeket a TLS kézfogásokba foglalnak.',
			],
			'ssl_protocols' => [
				'title' => 'A TLS protokoll verziójának konfigurálása',
				'description' => 'Ez egy lista az SSL protokollokról, amelyeket használni szeretne (vagy nem szeretne) SSL használatakor. <b>Megjegyzés:</b> Néhány régebbi böngésző nem támogatja a legújabb protokoll verziókat.<br /><br /><b>Alapértelmezett érték:</b><pre>TLSv1.2</pre>',
			],
			'tlsv13_cipher_list' => [
				'title' => 'Explicit TLSv1.3 titkosítások konfigurálása, ha használatban van',
				'description' => 'Ez egy lista a titkosításokról, amelyeket használni szeretne (vagy nem szeretne) TLSv1.3 használatakor. A titkosítások listájához és azok beillesztéséhez/kizárásához lásd a <a href="https://wiki.openssl.org/index.php/TLS1.3">TLSv1.3 dokumentációját</a>.<br /><br /><b>Alapértelmezett érték üres</b>',
			],
		],
		'default_vhostconf' => [
			'title' => 'Alapértelmezett vHost-beállítások',
			'description' => 'Ennek a mezőnek a tartalma közvetlenül beillesztésre kerül ebbe az ip/port vHost konténerbe. Az alábbi változókat használhatja:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (ha alkalmazható)<br/> Figyelem: A kód nem lesz ellenőrizve hibákra. Ha hibákat tartalmaz, a webszerver nem indulhat újra!',
		],
		'apache_globaldiropt' => [
			'title' => 'Könyvtár opciók az ügyfél előtaghoz',
			'description' => 'Ennek a mezőnek a tartalma beillesztésre kerül az 05_froxlor_dirfix_nofcgid.conf apache konfigurációba. Ha üres, az alapértelmezett érték kerül használatra:<br><br>apache >=2.4<br><code>Require all granted<br>AllowOverride All</code><br><br>apache <=2.2<br><code>Order allow,deny<br>allow from all</code>',
		],
		'default_vhostconf_domain' => [
			'description' => 'Ennek a mezőnek a tartalma közvetlenül beillesztésre kerül a domain vHost konténerbe. Az alábbi változókat használhatja:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (ha alkalmazható)<br/> Figyelem: A kód nem lesz ellenőrizve hibákra. Ha hibákat tartalmaz, a webszerver nem indulhat újra!',
		],
		'decimal_places' => 'Tizedesjegyek száma a forgalom/webtér kimenetben',
		'selfdns' => [
			'title' => 'Ügyfél domain dns beállítások',
		],
		'selfdnscustomer' => [
			'title' => 'Engedélyezze az ügyfeleknek a domain dns beállítások szerkesztését',
		],
		'unix_names' => [
			'title' => 'UNIX kompatibilis felhasználónevek használata',
			'description' => 'Lehetővé teszi a <strong>-</strong> és <strong>_</strong> használatát a felhasználónevekben, ha <strong>Nem</strong>',
		],
		'allow_password_reset' => [
			'title' => 'Jelszó visszaállítás engedélyezése az ügyfelek számára',
			'description' => 'Az ügyfelek visszaállíthatják jelszavukat, és egy aktiváló linket küldünk az e-mail címükre',
		],
		'allow_password_reset_admin' => [
			'title' => 'Jelszó visszaállítás engedélyezése az adminok számára',
			'description' => 'Az adminok/viszonteladók visszaállíthatják jelszavukat, és egy aktiváló linket küldünk az e-mail címükre',
		],
		'mail_quota' => [
			'title' => 'Postafiók-kvóta',
			'description' => 'Az újonnan létrehozott postafiókok alapértelmezett kvótája (MegaByte).',
		],
		'mail_quota_enabled' => [
			'title' => 'Postafiók-kvóta használata az ügyfelek számára',
			'description' => 'Aktiválja a kvóták használatát a postafiókokon. Az alapértelmezett <b>Nem</b>, mivel ez speciális beállítást igényel.',
			'removelink' => 'Kattintson ide az összes kvóta törléséhez a levelezési fiókoknál.',
			'enforcelink' => 'Kattintson ide az alapértelmezett kvóta érvényesítéséhez az összes felhasználói levelezési fióknál.',
		],
		'session_allow_multiple_login' => [
			'title' => 'Többszörös bejelentkezés engedélyezése',
			'description' => 'Ha aktiválva van, egy felhasználó többször is bejelentkezhet.',
		],
		'panel_allow_domain_change_admin' => [
			'title' => 'Domainek áthelyezésének engedélyezése adminok között',
			'description' => 'Ha aktiválva van, megváltoztathatja egy domain adminisztrátorát a domain beállításoknál.<br /><b>Figyelem:</b> Ha egy ügyfél nincs hozzárendelve ugyanahhoz az adminisztrátorhoz, mint a domain, az adminisztrátor láthatja az ügyfél összes többi domainjét!',
		],
		'panel_allow_domain_change_customer' => [
			'title' => 'Engedélyezze a domainek áthelyezését az ügyfelek között',
			'description' => 'Ha aktiválva van, megváltoztathatja egy domain ügyfelét a domain beállításoknál.<br /><b>Figyelem:</b> A froxlor megváltoztatja a documentroot-ot az új ügyfél alapértelmezett homedir-jére (+ domain-mappa, ha aktiválva van)',
		],
		'specialsettingsforsubdomains' => [
			'description' => 'Ha igen, ezek az egyedi vHost-beállítások hozzáadódnak az összes aldomainhez; ha nem, az aldomain-speciális beállítások eltávolításra kerülnek.',
		],
		'panel_password_min_length' => [
			'title' => 'Minimális jelszóhossz',
			'description' => 'Itt beállíthatja a jelszavak minimális hosszát. \'0\' azt jelenti: nincs minimális hosszúsági követelmény.',
		],
		'system_store_index_file_subs' => [
			'title' => 'Az alapértelmezett index fájl tárolása új almappákban is',
			'description' => 'Ha engedélyezve van, az alapértelmezett index-fájl minden újonnan létrehozott aldomain-útvonalra elmentésre kerül (nem, ha a mappa már létezik!)',
		],
		'adminmail_return' => [
			'title' => 'Válasz-cím',
			'description' => 'Adjon meg egy e-mail címet, mint válasz-cím a panel által küldött levelekhez.',
		],
		'adminmail_defname' => 'Panel e-mail küldő neve',
		'stdsubdomainhost' => [
			'title' => 'Ügyfél alapértelmezett aldomain',
			'description' => 'Milyen hosztnevet kell használni az ügyfél alapértelmezett aldomainjeinek létrehozásához. Ha üres, a rendszer-hosztnevet használja.',
		],
		'awstats_path' => 'AWStats \'awstats_buildstaticpages.pl\' elérési út',
		'awstats_conf' => 'AWStats konfigurációs útvonal',
		'defaultttl' => 'Domain TTL bind esetén másodpercben (alapértelmezett \'604800\' = 1 hét)',
		'defaultwebsrverrhandler_enabled' => 'Alapértelmezett hibadokumentumok engedélyezése minden ügyfél számára',
		'defaultwebsrverrhandler_err401' => [
			'title' => 'Fájl/URL a 401-es hibához',
			'description' => '',
		],
		'defaultwebsrverrhandler_err403' => [
			'title' => 'Fájl/URL a 403-as hibához',
			'description' => '',
		],
		'defaultwebsrverrhandler_err404' => 'Fájl/URL a 404-es hibához',
		'defaultwebsrverrhandler_err500' => [
			'title' => 'Fájl/URL az 500-as hibához',
			'description' => '',
		],
		'ftpserver' => [
			'desc' => 'Ha a pureftpd van kiválasztva, a .ftpquota fájlok a felhasználói kvótákhoz létrejönnek és naponta frissülnek',
		],
		'customredirect_enabled' => [
			'title' => 'Ügyfél átirányítások engedélyezése',
			'description' => 'Engedélyezze az ügyfelek számára, hogy kiválasszák az átirányításokhoz használt http-állapotkódot',
		],
		'customredirect_default' => [
			'title' => 'Alapértelmezett átirányítás',
			'description' => 'Állítsa be az alapértelmezett átirányítási kódot, amelyet akkor kell használni, ha az ügyfél nem állítja be magának',
		],
		'mail_also_with_mxservers' => 'Hozzon létre mail-, imap-, pop3- és smtp-"A rekordot" az MX-szerverekkel együtt',
		'froxlordirectlyviahostname' => 'froxlor közvetlen elérése a hosztnéven keresztül',
		'panel_password_regex' => [
			'title' => 'Jelszavak reguláris kifejezése',
			'description' => 'Itt beállíthat egy reguláris kifejezést a jelszavak összetettségére.<br />Üres = nincs külön követelmény',
		],
		'mod_fcgid_ownvhost' => [
			'title' => 'FCGID engedélyezése a froxlor vHosthoz',
			'description' => 'Ha engedélyezve van, a froxlor is egy helyi felhasználó alatt fog futni',
		],
		'perl' => [
			'suexecworkaround' => [
				'title' => 'SuExec megoldás engedélyezése',
				'description' => 'Csak akkor engedélyezze, ha az ügyfél docrootjai nincsenek az apache suexec útvonalán belül.<br />Ha engedélyezve van, a froxlor szimbolikus linket hoz létre az ügyfél perl-engedélyezett könyvtárából + /cgi-bin/ a megadott útvonalra.<br />Vegye figyelembe, hogy a perl csak a /cgi-bin/ alkönyvtárban fog működni, és nem magában a könyvtárban (ahogy ez a javítás nélkül történik!)',
			],
			'suexeccgipath' => [
				'title' => 'Útvonal az ügyfél perl-engedélyezett könyvtár szimbolikus linkjeihez',
				'description' => 'Csak akkor kell beállítania, ha a SuExec-megoldás engedélyezve van.<br />FIGYELEM: Győződjön meg róla, hogy ez az útvonal a suexec útvonalán belül van, különben ez a megoldás haszontalan',
			],
		],
		'awstats_awstatspath' => 'AWStats \'awstats.pl\' elérési út',
		'awstats_icons' => [
			'title' => 'AWstats ikonok mappájának elérési útja',
			'description' => 'pl. /usr/share/awstats/htdocs/icon/',
		],
		'login_domain_login' => 'Bejelentkezés engedélyezése domainekkel',
		'perl_server' => [
			'title' => 'Perl szerver socket helye',
			'description' => 'Egy egyszerű útmutató található itt: <a target="blank" href="https://www.nginx.com/resources/wiki/start/topics/examples/fcgiwrap/">nginx.com</a>',
		],
		'nginx_php_backend' => [
			'title' => 'Nginx PHP háttér',
			'description' => 'itt hallgat a PHP folyamat a nginx kéréseire, lehet egy unix socket vagy ip:port kombináció<br />*NEM használatos php-fpm-mel',
		],
		'phpreload_command' => [
			'title' => 'PHP újratöltési parancs',
			'description' => 'ezt használják a PHP háttér újratöltésére, ha bármelyik használatban van<br />Alapértelmezett: üres<br />*NEM használatos php-fpm-mel',
		],
		'phpfpm' => [
			'title' => 'php-fpm engedélyezése',
			'description' => '<b>Ez speciális webszerver konfigurációt igényel, lásd <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/php-fpm/">PHP-FPM kézikönyv</a></b>',
		],
		'phpfpm_settings' => [
			'configdir' => 'php-fpm konfigurációs könyvtár',
			'aliasconfigdir' => 'php-fpm konfigurációs alias-könyvtár',
			'reload' => 'php-fpm újraindítási parancs',
			'pm' => 'Folyamatkezelő vezérlés (pm)',
			'max_children' => [
				'title' => 'Gyermekfolyamatok száma',
				'description' => 'A gyermekfolyamatok száma, amelyeket létre kell hozni, amikor a pm \'static\'-ra van állítva, és a maximális gyermekfolyamatok száma, amelyeket létre kell hozni, amikor a pm \'dynamic/ondemand\'-ra van állítva<br />Egyenértékű a PHP_FCGI_CHILDREN-nel',
			],
			'start_servers' => [
				'title' => 'A létrehozott gyermekfolyamatok száma indításkor',
				'description' => 'Megjegyzés: Csak akkor használatos, ha a pm \'dynamic\'-ra van állítva',
			],
			'min_spare_servers' => [
				'title' => 'A kívánt minimális számú tétlen szerverfolyamat',
				'description' => 'Megjegyzés: Csak akkor használatos, ha a pm \'dynamic\'-ra van állítva<br />Megjegyzés: Kötelező, ha a pm \'dynamic\'-ra van állítva',
			],
			'max_spare_servers' => [
				'title' => 'A kívánt maximális számú tétlen szerverfolyamat',
				'description' => 'Megjegyzés: Csak akkor használatos, ha a pm \'dynamic\'-ra van állítva<br />Megjegyzés: Kötelező, ha a pm \'dynamic\'-ra van állítva',
			],
			'max_requests' => [
				'title' => 'Kérések száma gyermekenként újraindítás előtt',
				'description' => 'Végtelen kérésfeldolgozáshoz adja meg a \'0\' értéket. Egyenértékű a PHP_FCGI_MAX_REQUESTS-szel.',
			],
			'idle_timeout' => [
				'title' => 'Tétlen időkorlát',
				'description' => 'Időkorlát beállítása PHP FPM FastCGI-hez.',
			],
			'ipcdir' => [
				'title' => 'FastCGI IPC könyvtár',
				'description' => 'A könyvtár, ahol a php-fpm socketek tárolásra kerülnek a webszerver által.<br />Ennek a könyvtárnak olvashatónak kell lennie a webszerver számára',
			],
			'limit_extensions' => [
				'title' => 'Engedélyezett kiterjesztések',
				'description' => 'Korlátozza a fő szkript kiterjesztéseit, amelyeket az FPM engedélyez a feldolgozásra. Ez megakadályozhatja a konfigurációs hibákat a webszerver oldalán. Csak a .php kiterjesztésekre korlátozza az FPM-et, hogy megakadályozza a rosszindulatú felhasználókat más kiterjesztések használatában php kód végrehajtására. Alapértelmezett érték: .php',
			],
			'envpath' => 'Útvonalak hozzáadása a PATH környezeti változóhoz. Hagyja üresen, ha nincs PATH környezeti változó',
			'override_fpmconfig' => 'FPM-démon beállítások felülírása (pm, max_children, stb.)',
			'override_fpmconfig_addinfo' => '<br /><span class="text-danger">Csak akkor használatos, ha az "FPM-démon beállítások felülírása" "Igen"-re van állítva</span>',
			'restart_note' => 'Figyelem: A konfiguráció nem lesz ellenőrizve hibák szempontjából. Ha hibákat tartalmaz, előfordulhat, hogy a PHP-FPM nem indul újra!',
			'custom_config' => [
				'title' => 'Egyéni konfiguráció',
				'description' => 'Egyéni konfiguráció hozzáadása minden PHP-FPM verzió példányhoz, például <i>pm.status_path = /status</i> a monitorozáshoz. Az alábbi változók itt használhatók. <strong>Figyelem: A konfiguráció nem lesz ellenőrizve hibák szempontjából. Ha hibákat tartalmaz, előfordulhat, hogy a PHP-FPM nem indul újra!</strong>',
			],
			'allow_all_customers' => [
				'title' => 'Ezen konfiguráció hozzárendelése az összes jelenleg létező ügyfélhez',
				'description' => 'Állítsa "igaz"-ra, ha szeretné hozzárendelni ezt a konfigurációt az összes jelenleg létező ügyfélhez, hogy használhassák. Ez a beállítás nem állandó, de többször is futtatható.',
			],
		],
		'report' => [
			'report' => 'Web- és forgalomhasználatról szóló jelentések küldésének engedélyezése',
			'webmax' => [
				'title' => 'Figyelmeztetési szint százalékban a webtárhelyhez',
				'description' => 'Érvényes értékek 0-tól 150-ig. Ha 0-ra állítja, ez a jelentés kikapcsolódik.',
			],
			'trafficmax' => [
				'title' => 'Figyelmeztetési szint százalékban a forgalomhoz',
				'description' => 'Érvényes értékek 0-tól 150-ig. Ha 0-ra állítja, ez a jelentés kikapcsolódik.',
			],
		],
		'dropdown' => 'Legördülő lista',
		'manual' => 'Kézi',
		'default_theme' => 'Alapértelmezett téma',
		'validate_domain' => 'Doménnevek ellenőrzése',
		'diskquota_enabled' => 'Kvóta aktiválva?',
		'diskquota_repquota_path' => [
			'description' => 'Útvonal a repquota-hoz',
		],
		'diskquota_quotatool_path' => [
			'description' => 'Útvonal a quotatool-hoz',
		],
		'diskquota_customer_partition' => [
			'description' => 'Partíció, amelyen az ügyfelek fájljai tárolódnak',
		],
		'vmail_maildirname' => [
			'title' => 'Maildir név',
			'description' => 'Maildir könyvtár a felhasználó fiókjában. Általában \'Maildir\', néhány implementációban \'.maildir\', és közvetlenül a felhasználó könyvtárába, ha üresen hagyják.',
		],
		'catchall_enabled' => [
			'title' => 'Catchall használata',
			'description' => 'Szeretné biztosítani ügyfelei számára a catchall funkciót?',
		],
		'apache_24' => [
			'title' => 'Apache 2.4 módosítások használata',
			'description' => '<strong class="text-danger">FIGYELEM:</strong> csak akkor használja, ha ténylegesen apache 2.4 vagy magasabb verziót telepített<br />ellenkező esetben a webszerver nem fog tudni elindulni',
		],
		'nginx_fastcgiparams' => [
			'title' => 'Útvonal a fastcgi_params fájlhoz',
			'description' => 'Adja meg az nginx fastcgi_params fájljának útvonalát, beleértve a fájlnevet',
		],
		'documentroot_use_default_value' => [
			'title' => 'Doménnév használata alapértelmezett értékként a DocumentRoot útvonalhoz',
			'description' => 'Ha engedélyezve van és a DocumentRoot útvonal üres, az alapértelmezett érték a (al)doménnév lesz.<br /><br />Példák: <br />/var/customers/webs/customer_name/example.com/<br />/var/customers/webs/customer_name/subdomain.example.com/',
		],
		'panel_phpconfigs_hidesubdomains' => [
			'title' => 'Aldomének elrejtése a PHP-konfiguráció áttekintésben',
			'description' => 'Ha aktiválva van, az ügyfelek aldoménjei nem lesznek felsorolva a php-konfigurációk áttekintésében, csak az aldomének száma látható.<br /><br />Megjegyzés: Ez csak akkor látható, ha engedélyezte az FCGID-t vagy a PHP-FPM-et',
		],
		'panel_phpconfigs_hidestdsubdomain' => [
			'title' => 'Standard aldomének elrejtése a PHP-konfiguráció áttekintésben',
			'description' => 'Ha aktiválva van, az ügyfelek standard aldoménjei nem jelennek meg a php-konfigurációk áttekintésében<br /><br />Megjegyzés: Ez csak akkor látható, ha engedélyezte az FCGID-t vagy a PHP-FPM-et',
		],
		'passwordcryptfunc' => [
			'title' => 'Válassza ki, melyik jelszó-titkosítási módszert kell használni',
			'description' => 'Válassza ki, melyik jelszó-titkosítási módszert kell használni. Ha megváltoztatja ezt a beállítást, csak az új jelszavak lesznek titkosítva az új módszerrel. A meglévő jelszavak nem változnak.',
		],
		'systemdefault' => 'Rendszer alapértelmezett',
		'panel_allow_theme_change_admin' => 'Adminisztrátorok számára a téma változtatásának engedélyezése',
		'panel_allow_theme_change_customer' => 'Ügyfelek számára a téma változtatásának engedélyezése',
		'axfrservers' => [
			'title' => 'AXFR szerverek',
			'description' => 'IP-címek vesszővel elválasztott listája, amelyek számára engedélyezett a dns zónák átvitele (AXFR).',
		],
		'powerdns_mode' => [
			'title' => 'PowerDNS működési mód',
			'description' => 'Válassza ki a PowerDNS módot: Native a replikáció nélküli működéshez (Alapértelmezett) / Master, ha DNS replikációra van szükség.',
		],
		'customerssl_directory' => [
			'title' => 'Webszerver ügyfél-ssl tanúsítványok könyvtára',
			'description' => 'Hol kell létrehozni az ügyfél által megadott ssl-tanúsítványokat?<br /><br /><div class="text-danger">MEGJEGYZÉS: Ennek a mappának a tartalma rendszeresen törlődik, ezért kerülje az adatok manuális tárolását benne.</div>',
		],
		'allow_error_report_admin' => [
			'title' => 'Adminisztrátorok/viszonteladók számára az adatbázis-hibák jelentésének engedélyezése a froxlor felé',
			'description' => 'Kérjük, vegye figyelembe: Soha ne küldjön személyes (ügyfél)adatokat nekünk!',
		],
		'allow_error_report_customer' => [
			'title' => 'Ügyfelek számára az adatbázis-hibák jelentésének engedélyezése a froxlor felé',
			'description' => 'Kérjük, vegye figyelembe: Soha ne küldjön személyes (ügyfél)adatokat nekünk!',
		],
		'mailtraffic_enabled' => [
			'title' => 'E-mail forgalom elemzése',
			'description' => 'Levelezőszerver naplóinak elemzésének engedélyezése a forgalom kiszámításához',
		],
		'mdaserver' => [
			'title' => 'MDA típusa',
			'description' => 'A Mail Delivery Server típusa',
		],
		'mdalog' => [
			'title' => 'MDA napló',
			'description' => 'A Mail Delivery Server naplófájlja',
		],
		'mtaserver' => [
			'title' => 'MTA típusa',
			'description' => 'A Mail Transfer Agent típusa',
		],
		'mtalog' => [
			'title' => 'MTA napló',
			'description' => 'A Mail Transfer Agent naplófájlja',
		],
		'system_cronconfig' => [
			'title' => 'Cron konfigurációs fájl',
			'description' => 'Útvonal a cron-szolgáltatás konfigurációs fájljához. Ezt a fájlt a froxlor rendszeresen és automatikusan frissíti.<br />Megjegyzés: Kérjük, <b>győződjön meg róla</b>, hogy ugyanazt a fájlnevet használja, mint a fő froxlor cronjob esetében (alapértelmezett: /etc/cron.d/froxlor)!<br><br>Ha <b>FreeBSD</b>-t használ, kérjük, adja meg itt az <i>/etc/crontab</i> útvonalat!',
		],
		'system_crondreload' => [
			'title' => 'Cron-démon újratöltési parancs',
			'description' => 'Adja meg a parancsot, amelyet végre kell hajtani a rendszer cron-démonjának újratöltéséhez',
		],
		'system_croncmdline' => [
			'title' => 'Cron végrehajtási parancs (php-bináris)',
			'description' => 'Parancs a cronjobjaink végrehajtásához. Csak akkor változtassa meg, ha tudja, mit csinál (alapértelmezett: "/usr/bin/nice -n 5 /usr/bin/php -q")!',
		],
		'system_cron_allowautoupdate' => [
			'title' => 'Automatikus adatbázis-frissítések engedélyezése',
			'description' => '<div class="text-danger"><b>FIGYELEM:</b></div> Ez a beállítás lehetővé teszi a cronjob számára, hogy megkerülje a froxlor fájlok és az adatbázis verzióellenőrzését, és verzióeltérés esetén lefuttassa az adatbázis-frissítéseket.<br><br><div class="text-danger">Az automatikus frissítés mindig az alapértelmezett értékeket állítja be az új beállításokhoz vagy változtatásokhoz. Ez nem mindig felel meg az Ön rendszerének. Kérjük, gondolja át kétszer, mielőtt aktiválja ezt a beállítást.</div>',
		],
		'dns_createhostnameentry' => 'Bind-zone/config létrehozása a rendszer hosztnévhez',
		'panel_password_alpha_lower' => [
			'title' => 'Kisbetű',
			'description' => 'A jelszónak tartalmaznia kell legalább egy kisbetűt (a-z).',
		],
		'panel_password_alpha_upper' => [
			'title' => 'Nagybetű',
			'description' => 'A jelszónak tartalmaznia kell legalább egy nagybetűt (A-Z).',
		],
		'panel_password_numeric' => [
			'title' => 'Számok',
			'description' => 'A jelszónak tartalmaznia kell legalább egy számot (0-9).',
		],
		'panel_password_special_char_required' => [
			'title' => 'Speciális karakter',
			'description' => 'A jelszónak tartalmaznia kell legalább egyet az alább meghatározott karakterek közül.',
		],
		'panel_password_special_char' => [
			'title' => 'Speciális karakterek listája',
			'description' => 'Ezen karakterek egyike szükséges, ha a fenti opció be van állítva.',
		],
		'apache_itksupport' => [
			'title' => 'Apache ITK-MPM módosítások használata',
			'description' => '<strong class="text-danger">FIGYELEM:</strong> csak akkor használja, ha ténylegesen engedélyezve van az apache itk-mpm<br />ellenkező esetben a webszerver nem fog tudni elindulni',
		],
		'letsencryptca' => [
			'title' => 'ACME környezet',
			'description' => 'A Let\'s Encrypt / ZeroSSL tanúsítványokhoz használandó környezet.',
		],
		'letsencryptchallengepath' => [
			'title' => 'Let\'s Encrypt kihívások útvonala',
			'description' => 'Az a könyvtár, ahonnan a Let\'s Encrypt kihívásokat globális aliason keresztül kell kínálni.',
		],
		'letsencryptkeysize' => [
			'title' => 'Új Let\'s Encrypt tanúsítványok kulcsmérete',
			'description' => 'Az új Let\'s Encrypt tanúsítványok kulcsmérete bitben.',
		],
		'letsencryptreuseold' => [
			'title' => 'Let\'s Encrypt kulcs újrafelhasználása',
			'description' => 'Ha aktiválva van, minden megújításkor ugyanaz a kulcs lesz használva, ellenkező esetben minden alkalommal új kulcs generálódik.',
		],
		'leenabled' => [
			'title' => 'Let\'s Encrypt engedélyezése',
			'description' => 'Ha aktiválva van, az ügyfelek lehetővé teszik a froxlor számára, hogy automatikusan generáljon és megújítson Let\'s Encrypt ssl-tanúsítványokat ssl IP/port-tal rendelkező domainekhez.<br /><br />Kérjük, ne feledje, hogy engedélyezés esetén át kell néznie a webszerver konfigurációját, mert ez a funkció speciális beállítást igényel.',
		],
		'caa_entry' => [
			'title' => 'CAA DNS rekordok generálása',
			'description' => 'Automatikusan generál CAA rekordokat az SSL-engedélyezett domainekhez, amelyek Let\'s Encrypt-et használnak',
		],
		'caa_entry_custom' => [
			'title' => 'További CAA DNS rekordok',
			'description' => 'A DNS Tanúsítvány Kibocsátó Engedélyezés (CAA) egy internetes biztonsági mechanizmus, amely lehetővé teszi a domainnév tulajdonosok számára, hogy jelezzék a tanúsítvány-kibocsátóknak,<br>hogy jogosultak-e digitális tanúsítványokat kibocsátani egy adott domainnévhez. Ezt egy új "CAA" Domain Name System (DNS) erőforrásrekord segítségével teszi.<br><br>Ennek a mezőnek a tartalma közvetlenül bekerül a DNS zónába (minden sor egy CAA rekordot eredményez).<br>Ha a Let\'s Encrypt engedélyezve van ehhez a domainhez, ez a bejegyzés mindig automatikusan hozzáadódik, és nem kell manuálisan hozzáadni:<br><code>0 issue "letsencrypt.org"</code> (Ha a domain wildcard domain, akkor ehelyett issuewild lesz használva).<br>Az Incidens Jelentés engedélyezéséhez hozzáadhat egy <code>iodef</code> rekordot. Egy példa egy ilyen jelentés küldésére a <code>me@example.com</code> címre:<br><code>0 iodef "mailto:me@example.com"</code><br><br><strong>Figyelem:</strong> A kód nem lesz ellenőrizve hibák szempontjából. Ha hibákat tartalmaz',
		],
		'exportenabled' => [
			'title' => 'Adatexport engedélyezése ügyfelek számára',
			'description' => 'Ha aktiválva van, az ügyfél képes lesz adatexport feladatokat ütemezni (cron-export), amely archívumot generál a saját docroot-jában (az ügyfél által választható alkönyvtárban)',
		],
		'dnseditorenable' => [
			'title' => 'DNS szerkesztő engedélyezése',
			'description' => 'Lehetővé teszi az adminisztrátorok és ügyfelek számára a domain dns bejegyzések kezelését',
		],
		'dns_server' => [
			'title' => 'DNS szerver daemon',
			'description' => 'Ne feledje, hogy a daemonokat a froxlor konfigurációs sablonjai segítségével kell beállítani',
		],
		'panel_customer_hide_options' => [
			'title' => 'Menüelemek és forgalmi diagramok elrejtése az ügyfélpanelen',
			'description' => 'Válassza ki az ügyfélpanelen elrejtendő elemeket. Több opció kiválasztásához tartsa lenyomva a CTRL gombot kiválasztás közben.',
		],
		'allow_allow_customer_shell' => [
			'title' => 'Ügyfelek számára engedélyezze a shell hozzáférés engedélyezését ftp-felhasználók számára',
			'description' => '<strong class="text-danger">Kérjük, vegye figyelembe: A shell hozzáférés lehetővé teszi a felhasználó számára különböző binárisok végrehajtását a rendszeren. Rendkívül óvatosan használja. Kérjük, csak akkor aktiválja ezt, ha TÉNYLEG tudja, mit csinál!!!</strong>',
		],
		'available_shells' => [
			'title' => 'Elérhető shell-ek listája',
			'description' => 'Vesszővel elválasztott lista azokról a shell-ekről, amelyek elérhetők az ügyfél számára az ftp-felhasználóik számára való kiválasztásra.<br><br>Vegye figyelembe, hogy az alapértelmezett shell <strong>/bin/false</strong> mindig választható lesz (ha engedélyezve van), még akkor is, ha ez a beállítás üres. Ez az alapértelmezett érték az ftp-felhasználók számára minden esetben',
		],
		'le_froxlor_enabled' => [
			'title' => 'Let\'s Encrypt engedélyezése a froxlor vhost számára',
			'description' => 'Ha aktiválva van, a froxlor vhost automatikusan biztonságossá válik egy Let\'s Encrypt tanúsítvány használatával.',
		],
		'le_froxlor_redirect' => [
			'title' => 'SSL-átirányítás engedélyezése a froxlor vhost számára',
			'description' => 'Ha aktiválva van, minden http kérés a froxlor-hoz átirányításra kerül a megfelelő SSL oldalra.',
		],
		'option_unavailable_websrv' => '<br><em class="text-danger">Csak a következőkhöz érhető el: %s</em>',
		'option_unavailable' => '<br><em class="text-danger">Az opció nem érhető el más beállítások miatt.</em>',
		'letsencryptacmeconf' => [
			'title' => 'Az acme.conf snippet útvonala',
			'description' => 'A konfigurációs snippet fájlneve, amely lehetővé teszi a webszerver számára az acme kihívás kiszolgálását.',
		],
		'mail_use_smtp' => 'Levelező beállítása SMTP használatára',
		'mail_smtp_host' => 'SMTP szerver megadása',
		'mail_smtp_usetls' => 'TLS titkosítás engedélyezése',
		'mail_smtp_auth' => 'SMTP hitelesítés engedélyezése',
		'mail_smtp_port' => 'Csatlakozáshoz használt TCP port',
		'mail_smtp_user' => 'SMTP felhasználónév',
		'mail_smtp_passwd' => 'SMTP jelszó',
		'http2_support' => [
			'title' => 'HTTP2 támogatás',
			'description' => 'HTTP2 támogatás engedélyezése ssl-hez.<br><em class="text-danger">CSAK AKKOR ENGEDÉLYEZZE, HA A WEBSZERVERE TÁMOGATJA EZT A FUNKCIÓT (nginx verzió 1.9.5+, apache2 verzió 2.4.17+)</em>',
		],
		'nssextrausers' => [
			'title' => 'libnss-extrausers használata libnss-mysql helyett',
			'description' => 'Ne olvassa be a felhasználókat az adatbázisból, hanem fájlokból. Kérjük, csak akkor aktiválja, ha már elvégezte a szükséges konfigurációs lépéseket (rendszer -> libnss-extrausers).<br><strong class="text-danger">Csak Debian/Ubuntu esetén (vagy ha saját maga fordította a libnss-extrausers-t!)</strong>',
		],
		'le_domain_dnscheck' => [
			'title' => 'Domainek DNS-ének ellenőrzése Let\'s Encrypt használatakor',
			'description' => 'Ha aktiválva van, a froxlor ellenőrzi, hogy a domain, amely Let\'s Encrypt tanúsítványt kér, legalább egy rendszer IP címre feloldódik-e.',
		],
		'le_domain_dnscheck_resolver' => [
			'title' => 'Külső névszerver használata DNS ellenőrzéshez',
			'description' => 'Ha be van állítva, a froxlor ezt a DNS-t fogja használni a domainok DNS-ének ellenőrzéséhez a Let\'s Encrypt használatakor. Ha üres, a rendszer alapértelmezett DNS-feloldóját fogja használni.',
		],
		'phpsettingsforsubdomains' => [
			'description' => 'Ha igen, a kiválasztott php-konfiguráció frissítve lesz minden aldomainre',
		],
		'leapiversion' => [
			'title' => 'Válassza ki a Let\'s Encrypt ACME implementációt',
			'description' => 'Jelenleg csak az ACME v2 implementáció támogatott a Let\'s Encrypt-hez.',
		],
		'enable_api' => [
			'title' => 'Külső API használat engedélyezése',
			'description' => 'A froxlor API használatához aktiválnia kell ezt az opciót. Részletesebb információkért lásd <a href="https://docs.froxlor.org/latest/api-guide/" target="_new">https://docs.froxlor.org/</a>',
		],
		'api_customer_default' => '"API hozzáférés engedélyezése" alapértelmezett érték új ügyfeleknek',
		'dhparams_file' => [
			'title' => 'DHParams fájl (Diffie–Hellman kulcscsere)',
			'description' => 'Ha itt meg van adva egy dhparams.pem fájl, az bele lesz foglalva a webszerver konfigurációjába. Hagyja üresen a kikapcsoláshoz.<br>Példa: /etc/ssl/webserver/dhparams.pem<br><br>Ha a fájl nem létezik, automatikusan létrehozásra kerül a következő paranccsal: <code>openssl dhparam -out /etc/ssl/webserver/dhparams.pem 4096</code>. Ajánlott a fájlt előre létrehozni, mielőtt itt megadná, mivel a létrehozás elég sokáig tart és blokkolja a cronjob-ot.',
		],
		'errorlog_level' => [
			'title' => 'Hibanapló szintje',
			'description' => 'Adja meg a hibanapló szintjét. Az alapértelmezett "warn" apache-felhasználóknak és "error" nginx-felhasználóknak.',
		],
		'letsencryptecc' => [
			'title' => 'ECC / ECDSA tanúsítvány kiállítása',
			'description' => 'Ha érvényes kulcsméretnek van beállítva, a kiállított tanúsítvány ECC / ECDSA-t fog használni',
		],
		'froxloraliases' => [
			'title' => 'Domain aliasok a froxlor vhost-hoz',
			'description' => 'Vesszővel elválasztott lista a domainek hozzáadásához szerveraliasként a froxlor vhost-hoz',
		],
		'default_sslvhostconf' => [
			'title' => 'Alapértelmezett SSL vHost-beállítások',
			'description' => 'Ennek a mezőnek a tartalma közvetlenül bele lesz foglalva ebbe az ip/port vHost konténerbe. A következő változókat használhatja:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (ha alkalmazható)<br/> Figyelem: A kód nem lesz ellenőrizve hibákra. Ha hibákat tartalmaz, előfordulhat, hogy a webszerver nem indul újra!',
		],
		'includedefault_sslvhostconf' => 'Nem-SSL vHost-beállítások beillesztése az SSL-vHost-ba',
		'apply_specialsettings_default' => 'Alapértelmezett érték a "Speciális beállítások alkalmazása minden aldomainre (*.example.com)" beállításhoz domain szerkesztésekor',
		'apply_phpconfigs_default' => 'Alapértelmezett érték a "PHP-konfiguráció alkalmazása minden aldomainre" beállításhoz domain szerkesztésekor',
		'awstats' => [
			'logformat' => [
				'title' => 'LogFormat beállítás',
				'description' => 'Ha egyéni logformátumot használ a webszerverhez, módosítania kell az awstats LogFormat-ot is.<br/>Az alapértelmezett 1. További információkért nézze meg a dokumentációt <a target="_blank" href="https://awstats.sourceforge.io/docs/awstats_config.html#LogFormat">itt</a>.',
			],
		],
		'hide_incompatible_settings' => 'Inkompatibilis beállítások elrejtése',
		'soaemail' => 'SOA rekordokban használandó e-mail cím (ha üres, alapértelmezetten a panel beállításaiban megadott küldő címet használja)',
		'imprint_url' => [
			'title' => 'URL a jogi megjegyzésekhez / impresszumhoz',
			'description' => 'Adjon meg egy URL-t a jogi megjegyzések / impresszum oldalához. A link látható lesz a bejelentkezési képernyőn és a láblécben bejelentkezés után.',
		],
		'terms_url' => [
			'title' => 'URL a használati feltételekhez',
			'description' => 'Adjon meg egy URL-t a használati feltételek oldalához. A link látható lesz a bejelentkezési képernyőn és a láblécben bejelentkezés után.',
		],
		'privacy_url' => [
			'title' => 'URL az adatvédelmi irányelvekhez',
			'description' => 'Adjon meg egy URL-t az adatvédelmi irányelvek / impresszum oldalához. A link látható lesz a bejelentkezési képernyőn és a láblécben bejelentkezés után.',
		],
		'logo_image_header' => [
			'title' => 'Logó kép (Fejléc)',
			'description' => 'Töltse fel saját logó képét, amely a fejlécben jelenik meg bejelentkezés után (ajánlott magasság 30px)',
		],
		'logo_image_login' => [
			'title' => 'Logó kép (Bejelentkezés)',
			'description' => 'Töltse fel saját logó képét, amely bejelentkezéskor jelenik meg',
		],
		'logo_overridetheme' => [
			'title' => 'A témában meghatározott logó felülírása a "Logó kép" által (Fejléc és Bejelentkezés, lásd alább)',
			'description' => 'Ezt "true"-ra kell állítani, ha használni szeretné a feltöltött logót; alternatívaként még mindig használhatja a téma-alapú "logo_custom.png" és "logo_custom_login.png" lehetőséget.',
		],
		'logo_overridecustom' => [
			'title' => 'A témában meghatározott egyedi logó (logo_custom.png és logo_custom_login.png) felülírása a "Logó kép" által (Fejléc és Bejelentkezés, lásd alább)',
			'description' => 'Állítsa "true"-ra, ha figyelmen kívül szeretné hagyni a téma-specifikus egyedi logókat a fejléchez és bejelentkezéshez, és helyette a "Logó kép"-et szeretné használni',
		],
		'createstdsubdom_default' => [
			'title' => 'Előre kiválasztott érték az "Alapértelmezett aldomain létrehozása" opcióhoz ügyfél létrehozásakor',
			'description' => '',
		],
		'froxlorusergroup' => [
			'title' => 'Egyedi rendszercsoport minden ügyfél felhasználóhoz',
			'description' => 'A libnss-extrausers (rendszerbeállítások) használata szükséges ennek érvénybe lépéséhez. Az üres érték kihagyja a létrehozást vagy eltávolítja a meglévő csoportot.',
		],
		'acmeshpath' => [
			'title' => 'Az acme.sh útvonala',
			'description' => 'Állítsa be, hogy hova van telepítve az acme.sh, beleértve az acme.sh szkriptet<br>Az alapértelmezett <b>/root/.acme.sh/acme.sh</b>',
		],
		'update_channel' => [
			'title' => 'froxlor frissítési csatorna',
			'description' => 'Válassza ki a froxlor frissítési csatornáját. Az alapértelmezett "stable"',
		],
		'uc_stable' => 'stabil',
		'uc_testing' => 'tesztelés',
		'uc_nightly' => 'éjszakai',
		'traffictool' => [
			'toolselect' => 'Forgalomelemző',
			'webalizer' => 'Webalizer',
			'awstats' => 'AWStats',
			'goaccess' => 'goaccess'
		],
		'requires_reconfiguration' => 'Ezen beállítások módosítása szükségessé teheti a következő szolgáltatások újrakonfigurálását:<br><strong>%s</strong>',
		'req_limit_per_interval' => [
			'title' => 'HTTP kérések száma intervallumonként',
			'description' => 'Korlátozza a HTTP kérések számát intervallumonként (lásd alább) a froxlor-hoz, az alapértelmezett "60"',
		],
		'req_limit_interval' => [
			'title' => 'Sebességkorlátozási intervallum',
			'description' => 'Adja meg az időt másodpercben a HTTP kérések számához, az alapértelmezett "60"',
		],
		'option_requires_otp' => 'Ez a beállítás OTP validációt igényel',
		'panel_menu_collapsed' => [
			'title' => 'Menüszekciók összecsukása',
			'description' => 'Ha ki van kapcsolva, a bal oldali menüszekciók mindig ki lesznek nyitva.',
		],
		'le_renew_services' => [
			'title' => 'A froxlor Let\'s Encrypt tanúsítvány használata ezekhez a szolgáltatásokhoz',
			'description' => 'Ha "nincs"-re van állítva (vagy az alábbi megújítási hook parancs üres), nem történik SSL-lel kapcsolatos konfigurációs módosítás a kiválasztott szolgáltatásoknál.<br><br>A kiválasztott szolgáltatások újratöltési parancsát hozzá kell adni a megújítási hook parancshoz, különben a konfigurációs változtatások vagy a megújított tanúsítványok nem lesznek megfelelően alkalmazva.',
		],
		'le_renew_hook' => [
			'title' => 'Let\'s Encrypt megújítási hook parancs',
			'description' => 'Állítsa be erre a parancsra, amely újraindítja a fent kiválasztott szolgáltatásokat, hogy a megújított tanúsítványokat a szolgáltatás megfelelően használja.',
		],
	],
	'spf' => [
		'use_spf' => [
			'title' => 'SPF aktiválása a domainekhez?',
			'description' => 'Speciális DNS bejegyzést igényel a domainhez. Ha nem használja a névszerver funkciót, manuálisan kell kezelnie ezeket a bejegyzéseket.',
		],
		'spf_entry' => 'SPF bejegyzés minden domainhez',
	],
	'dmarc' => [
		'use_dmarc' => [
			'title' => 'DMARC aktiválása a domainekhez?',
			'description' => 'Speciális DNS bejegyzést igényel a domainhez. Ha nem használja a névszerver funkciót, manuálisan kell kezelnie ezeket a bejegyzéseket.',
		],
		'dmarc_entry' => 'DMARC bejegyzés minden domainhez',
	],
	'ssl_certificates' => [
		'certificate_for' => 'Tanúsítvány ehhez:',
		'valid_from' => 'Érvényes ettől:',
		'valid_until' => 'Érvényes eddig:',
		'issuer' => 'Kibocsátó',
	],
	'success' => [
		'success' => 'Információ',
		'clickheretocontinue' => 'Kattintson ide a folytatáshoz',
		'settingssaved' => 'A beállítások sikeresen mentve.',
		'rebuildingconfigs' => 'Sikeresen hozzáadva a konfigurációs fájlok újraépítési feladatai',
		'domain_import_successfully' => 'Sikeresen importálva %s domain.',
		'exportscheduled' => 'Az exportálási feladat ütemezve lett. Kérjük, várjon a feldolgozásra',
		'exportaborted' => 'Az ütemezett exportálás megszakítva',
		'dns_record_added' => 'Rekord sikeresen hozzáadva',
		'dns_record_deleted' => 'Rekord sikeresen törölve',
		'testmailsent' => 'Teszt e-mail sikeresen elküldve',
		'settingsimported' => 'Beállítások sikeresen importálva',
		'sent_error_report' => 'Hibajelentés sikeresen elküldve. Köszönjük a közreműködését.',
	],
	'tasks' => [
		'outstanding_tasks' => 'Függőben lévő cron-feladatok',
		'REBUILD_VHOST' => 'Webszerver-konfiguráció újraépítése',
		'CREATE_HOME' => 'Új ügyfél hozzáadása: %s',
		'REBUILD_DNS' => 'Bind-konfiguráció újraépítése',
		'CREATE_FTP' => 'Könyvtár létrehozása új ftp-felhasználónak',
		'DELETE_CUSTOMER_FILES' => 'Ügyfél fájljainak törlése: %s',
		'noneoutstanding' => 'Jelenleg nincsenek függőben lévő feladatok a froxlor számára',
		'DELETE_EMAIL_DATA' => 'Ügyfél e-mail adatainak törlése.',
		'DELETE_FTP_DATA' => 'Ügyfél ftp-fiók adatainak törlése.',
		'REBUILD_RSPAMD' => 'Antispam-konfiguráció újraépítése.',
		'CREATE_QUOTA' => 'Kvóta beállítása a fájlrendszeren',
		'REBUILD_CRON' => 'A cron.d fájl újraépítése',
		'CREATE_CUSTOMER_DATADUMP' => 'Adatexportálási feladat az ügyfél számára: %s',
		'DELETE_DOMAIN_PDNS' => '%s domain törlése a PowerDNS adatbázisból',
		'DELETE_DOMAIN_SSL' => '%s domain SSL fájljainak törlése',
		'UPDATE_LE_SERVICES' => 'Rendszerszolgáltatások frissítése a Let\'s Encrypt számára',
	],
	'terms' => 'Használati feltételek',
	'traffic' => [
		'month' => 'Hónap',
		'day' => 'Nap',
		'months' => [
			1 => 'Január',
			2 => 'Február',
			3 => 'Március',
			4 => 'Április',
			5 => 'Május',
			6 => 'Június',
			7 => 'Július',
			8 => 'Augusztus',
			9 => 'Szeptember',
			10 => 'Október',
			11 => 'November',
			12 => 'December',
			'jan' => 'Jan',
			'feb' => 'Feb',
			'mar' => 'Már',
			'apr' => 'Ápr',
			'may' => 'Máj',
			'jun' => 'Jún',
			'jul' => 'Júl',
			'aug' => 'Aug',
			'sep' => 'Szep',
			'oct' => 'Okt',
			'nov' => 'Nov',
			'dec' => 'Dec',
			'total' => 'Összesen',
		],
		'mb' => 'Forgalom',
		'sumtotal' => 'Teljes forgalom',
		'sumhttp' => 'HTTP forgalom',
		'sumftp' => 'FTP forgalom',
		'summail' => 'E-mail forgalom',
		'customer' => 'Ügyfél',
		'domain' => 'Domain',
		'trafficoverview' => 'Forgalom összesítés',
		'bycustomers' => 'Forgalom ügyfelenként',
		'details' => 'Részletek',
		'http' => 'HTTP',
		'ftp' => 'FTP',
		'mail' => 'E-mail',
		'nocustomers' => 'Legalább egy ügyfélre van szükség a forgalmi jelentések megtekintéséhez.',
		'top5customers' => 'Top 5 ügyfél',
		'nodata' => 'Nincs adat a megadott időszakra.',
		'ranges' => [
			'last24h' => 'utolsó 24 óra',
			'last7d' => 'utolsó 7 nap',
			'last30d' => 'utolsó 30 nap',
			'cm' => 'Aktuális hónap',
			'last3m' => 'utolsó 3 hónap',
			'last6m' => 'utolsó 6 hónap',
			'last12m' => 'utolsó 12 hónap',
			'cy' => 'Aktuális év',
		],
		'byrange' => 'Időszak szerint meghatározva',
	],
	'translator' => '',
	'update' => [
		'updateinprogress_onlyadmincanlogin' => 'A froxlor egy újabb verziója telepítve lett, de még nincs beállítva.<br />Csak az adminisztrátor jelentkezhet be és fejezheti be a frissítést.',
		'update' => 'froxlor frissítés',
		'proceed' => 'Folytatás',
		'update_information' => [
			'part_a' => 'A froxlor fájlok frissítve lettek a <strong>%s</strong> verzióra. A telepített verzió <strong>%s</strong>.',
			'part_b' => '<br /><br />Az ügyfelek nem tudnak bejelentkezni, amíg a frissítés be nem fejeződik.<br /><strong>Folytatja?</strong>',
		],
		'noupdatesavail' => 'Már a legújabb %s verziójú froxlor van telepítve.',
		'description' => 'Adatbázis frissítések futtatása a froxlor telepítéséhez',
		'uc_newinfo' => 'Egy újabb %s verzió érhető el: "%s" (Az Ön jelenlegi verziója: %s)',
		'notify_subject' => 'Új frissítés elérhető',
		'dbupdate_required' => 'A froxlor fájlok frissítve lettek, adatbázis frissítés szükséges',
	],
	'usersettings' => [
		'custom_notes' => [
			'title' => 'Egyéni jegyzetek',
			'description' => 'Szabadon írhat ide bármilyen jegyzetet, amire szüksége van. Ezek megjelennek az admin/ügyfél áttekintőben a megfelelő felhasználónál.<br>A Markdown támogatott, a HTML eltávolításra kerül.',
			'show' => 'Mutassa a jegyzeteket a felhasználó irányítópultján',
		],
		'api_allowed' => [
			'title' => 'API hozzáférés engedélyezése',
			'description' => 'Ha engedélyezve van a beállításokban, ez a felhasználó létrehozhat API kulcsokat és hozzáférhet a froxlor API-hoz',
			'notice' => 'Az API hozzáférés nem engedélyezett az Ön fiókjához.',
		],
		'gui_access' => [
			'title' => 'WebUI bejelentkezés engedélyezése',
			'description' => 'Ha le van tiltva, a felhasználó nem tud bejelentkezni a froxlor webes felületére, de minden szolgáltatás (web, ftp, e-mail, adatbázisok, api-hozzáférés, stb.) normálisan működik.',
		],
	],
	'install' => [
		'slogan' => 'froxlor Szerver Kezelőpanel',
		'preflight' => 'Rendszer ellenőrzés',
		'critical_error' => 'Kritikus hiba',
		'suggestions' => 'Nem kötelező, de ajánlott',
		'phpinfosuccess' => 'A rendszer PHP %s verzióval fut',
		'suggestionsnote' => 'Nincsenek kritikus hibák, amelyek megakadályoznák a telepítést, de kérjük, kövesse az alábbi ajánlásokat az optimális élmény érdekében.',
		'phpinfowarn' => 'A rendszer a PHP %s verziónál alacsonyabb verzióval fut',
		'phpinfoupdate' => 'Frissítse a jelenlegi PHP verzióját %s-ról %s-ra vagy magasabbra',
		'start_installation' => 'Telepítés indítása',
		'check_again' => 'Újratöltés az újbóli ellenőrzéshez',
		'switchmode_advanced' => 'Haladó opciók megjelenítése',
		'switchmode_basic' => 'Haladó opciók elrejtése',
		'dependency_check' => [
			'title' => 'Üdvözöljük a froxlorban',
			'description' => 'Ellenőrizzük a rendszert a függőségek szempontjából, hogy biztosítsuk, hogy minden szükséges PHP kiterjesztés és modul engedélyezve legyen, így a froxlor megfelelően működik.',
		],
		'database' => [
			'top' => 'Adatbázis',
			'title' => 'Adatbázis és felhasználó létrehozása',
			'description' => 'A froxlor adatbázist igényel, és ezenkívül <a href="https://docs.froxlor.org/latest/general/installation/tarball.html#_3-create-privileged-database-user" target="_blank">egy kiváltságos felhasználót</a> is, hogy képes legyen felhasználókat és adatbázisokat létrehozni (GRANT opció). A megadott adatbázis és a nem kiváltságos adatbázis-felhasználó létrejön ebben a folyamatban. A kiváltságos felhasználónak léteznie kell.',
			'user' => 'Nem kiváltságos adatbázis-felhasználó',
			'dbname' => 'Adatbázis neve',
			'force_create' => 'Adatbázis biztonsági mentése és felülírása, ha létezik?',
		],
		'admin' => [
			'top' => 'Adminisztrátor felhasználó',
			'title' => 'Hozzuk létre a fő adminisztrátor felhasználót.',
			'description' => 'Ez a felhasználó minden jogosultságot megkap a beállítások módosításához és az erőforrások, például ügyfelek, domainek stb. hozzáadásához/frissítéséhez/törléséhez.',
			'use_admin_email_as_sender' => 'Használja a fenti e-mail címet küldő címként. Ha nincs bejelölve, kérjük, adjon meg egy küldő címet alább.',
			'use_autogenerated_email_as_sender' => 'Hagyja üresen az alapértelmezettért: admin@servername',
		],
		'system' => [
			'top' => 'Rendszer beállítása',
			'title' => 'Részletek a szerveréről',
			'description' => 'Állítsa be a környezetét, valamint a szerverrel kapcsolatos adatokat és opciókat itt, hogy a froxlor tudjon a rendszeréről. Ezek az értékek kulcsfontosságúak a rendszer konfigurációjához és működéséhez.',
			'ipv4' => 'Elsődleges IPv4 cím (ha alkalmazható)',
			'ipv6' => 'Elsődleges IPv6 cím (ha alkalmazható)',
			'servername' => 'Szerver neve (FQDN, nem IP-cím)',
			'phpbackend' => 'PHP háttér',
			'activate_newsfeed' => 'Az hivatalos hírcsatorna engedélyezése<br><small>(külső forrás: https://inside.froxlor.org/news/)</small>',
		],
		'install' => [
			'top' => 'Beállítás befejezése',
			'title' => 'Egy utolsó lépés...',
			'description' => 'Az alábbi parancs letölti, telepíti és konfigurálja a szükséges szolgáltatásokat a rendszerén a telepítési folyamat során megadott adatok alapján.<br><br><span class="text-danger">Győződjön meg róla, hogy az alábbi parancsot <b>root</b> felhasználóként futtatja a szerver shelljében/termináljában, és <b>legyen tisztában</b> azzal, hogy ez a parancs <b>felülírja</b> a használt szolgáltatások bármely meglévő konfigurációját (biztonsági mentések készülnek)!.<br>Ha nem szeretné felülírni a konfigurációkat, válassza az <i>Én manuálisan konfigurálom a szolgáltatásokat</i> opciót az oldal alján!</span>',
			'runcmd' => 'Futtassa az alábbi parancsot a telepítés befejezéséhez:',
			'manual_config' => 'Én manuálisan konfigurálom a szolgáltatásokat, csak vigyen a bejelentkezéshez',
			'waitforconfig' => 'Várakozás a szolgáltatások konfigurálására...',
		],
		'errors' => [
			'wrong_ownership' => 'Győződjön meg róla, hogy a froxlor fájlok tulajdonosa %s:%s',
			'missing_extensions' => 'A következő PHP kiterjesztések szükségesek és nincsenek telepítve',
			'suggestedextensions' => 'A következő PHP kiterjesztések nem találhatók, de ajánlottak',
			'databaseexists' => 'Az adatbázis már létezik, kérjük, állítsa be a felülírási opciót az újjáépítéshez, vagy válasszon másik nevet',
			'unabletocreatedb' => 'A tesztadatbázis nem hozható létre',
			'unabletodropdb' => 'A tesztadatbázis nem törölhető',
			'mysqlusernameexists' => 'A megadott nem kiváltságos felhasználó már létezik. Kérjük, használjon másik felhasználónevet, vagy törölje először.',
			'unabletocreateuser' => 'A tesztfelhasználó nem hozható létre',
			'unabletodropuser' => 'A tesztfelhasználó nem törölhető',
			'unabletoflushprivs' => 'A megadott kiváltságos felhasználó nem tudja frissíteni a jogosultságokat',
			'nov4andnov6ip' => 'Meg kell adni egy IPv4- vagy IPv6-címet',
			'servernameneedstobevalid' => 'A megadott szervernév nem tűnik FQDN-nek vagy hosztnévnek',
			'websrvuserdoesnotexist' => 'A megadott webszerver-felhasználó nem létezik a rendszeren',
			'websrvgrpdoesnotexist' => 'A megadott webszerver-csoport nem létezik a rendszeren',
			'notyetconfigured' => 'Úgy tűnik, hogy a szolgáltatások még nem lettek konfigurálva (sikeresen). Kérjük, futtassa az alábbi parancsot, vagy jelölje be a négyzetet, hogy később megtegye.',
			'mandatory_field_not_set' => 'A kötelező mező "%s" nincs beállítva!',
			'unexpected_database_error' => 'Váratlan adatbázis-kivétel történt. %s',
			'sql_import_failed' => 'Az SQL adatok importálása nem sikerült!',
			'unprivileged_sql_connection_failed' => 'A nem kiváltságos SQL kapcsolat inicializálása nem sikerült!',
			'privileged_sql_connection_failed' => 'A kiváltságos SQL kapcsolat inicializálása nem sikerült!',
			'mysqldump_backup_failed' => 'Nem lehet adatbázis biztonsági mentést készíteni, a mysqldump hibát adott.',
			'sql_backup_file_missing' => 'Nem lehet adatbázis biztonsági mentést készíteni, a biztonsági mentés fájl nem létezik.',
			'backup_binary_missing' => 'Nem lehet adatbázis biztonsági mentést készíteni, győződjön meg róla, hogy telepítette a mysqldump-ot.',
			'creating_configfile_failed' => 'Nem lehet konfigurációs fájlokat létrehozni, nem lehet írni a fájlt.',
			'database_already_exiting' => 'Találtunk egy adatbázist, és nem engedtük felülírni!'
		]
	],
	'welcome' => [
		'title' => 'Üdvözöljük a froxlorban!',
		'config_note' => 'Annak érdekében, hogy a froxlor megfelelően tudjon kommunikálni a háttérrel, konfigurálnia kell.',
		'config_now' => 'Konfigurálás most'
	],
];
