<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can also view it online at
 * https://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  the authors
 * @author     Froxlor team <team@froxlor.org>
 * @license    https://files.froxlor.org/misc/COPYING.txt GPLv2
 */

return [
	'languages' => [
		'cz' => 'Tschechisch',
		'de' => 'Deutsch',
		'en' => 'Englisch',
		'fr' => 'Französisch',
		'it' => 'Italienisch',
		'nl' => 'Niederländisch',
		'pt' => 'Portugiesisch',
		'se' => 'Schwedisch',
		'es' => 'Spanisch',
	],
	'2fa' => [
		'2fa' => '2FA Optionen',
		'2fa_enabled' => 'Aktiviere Zwei-Faktor Authentifizierung (2FA)',
		'2fa_removed' => '2FA erfolgreich gelöscht',
		'2fa_added' => '2FA erfolgreich aktiviert<br><a class="alert-link" href="%s?page=2fa">2FA Details öffnen</a>',
		'2fa_add' => '2FA aktivieren',
		'2fa_delete' => '2FA deaktivieren',
		'2fa_verify' => 'Code verifizieren',
		'2fa_overview_desc' => 'Hier kann für das Konto eine Zwei-Faktor-Authentisierung aktiviert werden.<br><br>Es kann entweder eine Authenticator-App (time-based one-time password / TOTP) genutzt werden oder ein Einmalpasswort, welches nach erfolgreichem Login an die hinterlegte E-Mail Adresse gesendet wird.',
		'2fa_email_desc' => 'Das Konto ist eingerichtet, um Einmalpasswörter per E-Mail zu erhalten. Zum Deaktivieren, klicke auf "2FA deaktivieren"',
		'2fa_ga_desc' => 'Das Konto ist eingerichtet, um zeitbasierte Einmalpasswörter via Authenticator-App zu erhalten. Um die gewünschte Authenticator-App einzurichten, scanne bitte den untenstehenden QR-Code. Zum Deaktivieren, klicke auf "2FA deaktivieren"',
		'2fa_not_activated' => 'Zwei-Faktor Authentifizierung ist nicht aktiviert',
		'2fa_not_activated_for_user' => 'Zwei-Faktor Authentifizierung ist für den aktuellen Benutzer nicht aktiviert',
		'type_2fa' => '2FA Status',
	],
	'admin' => [
		'overview' => 'Übersicht',
		'ressourcedetails' => 'Verbrauchte Ressourcen',
		'systemdetails' => 'Systemdetails',
		'froxlordetails' => 'Froxlor-Details',
		'installedversion' => 'Installierte Version',
		'latestversion' => 'Neueste Version',
		'lookfornewversion' => [
			'clickhere' => 'per Webservice abfragen - Hier klicken',
			'error' => 'Fehler bei Abfrage',
		],
		'resources' => 'Ressourcen',
		'customer' => 'Kunde',
		'customers' => 'Kunden',
		'customers_list_desc' => 'Kundenverwaltung',
		'customer_add' => 'Kunden anlegen',
		'customer_edit' => 'Kunden bearbeiten',
		'username_default_msg' => 'Leer lassen für automatische Benutzername-Vergabe',
		'password_default_msg' => 'Leer lassen für Passwortgenerierung',
		'domains' => 'Domains',
		'domain_add' => 'Domain anlegen',
		'domain_edit' => 'Domain bearbeiten',
		'subdomainforemail' => 'Subdomains als E-Mail-Domains erlauben',
		'admin' => 'Admin',
		'admins' => 'Admins',
		'admin_add' => 'Admin anlegen',
		'admin_edit' => 'Admin bearbeiten',
		'customers_see_all' => 'Zugriff auf Resourcen anderer Admins/Reseller?',
		'change_serversettings' => 'Kann Servereinstellungen bearbeiten?',
		'serversettings' => 'Einstellungen',
		'serversettings_desc' => 'Verwalte dein froxlor System',
		'rebuildconf' => 'Configs neu schreiben',
		'stdsubdomain' => 'Standardsubdomain',
		'stdsubdomain_add' => 'Standardsubdomain anlegen',
		'phpenabled' => 'PHP verfügbar',
		'deactivated' => 'Gesperrt',
		'deactivated_user' => 'Benutzer sperren',
		'sendpassword' => 'Passwort zusenden',
		'ownvhostsettings' => 'Eigene vHost-Einstellungen',
		'configfiles' => [
			'serverconfiguration' => 'Konfiguration',
			'overview' => 'Übersicht',
			'wizard' => 'Assistent',
			'distribution' => 'Distribution',
			'service' => 'Service',
			'daemon' => 'Daemon',
			'http' => 'Webserver (HTTP)',
			'dns' => 'Nameserver (DNS)',
			'mail' => 'Mailserver (IMAP/POP3)',
			'smtp' => 'Mailserver (SMTP)',
			'ftp' => 'FTP-Server',
			'etc' => 'Sonstige (System)',
			'choosedistribution' => '-- Distribution wählen --',
			'chooseservice' => '-- Service wählen --',
			'choosedaemon' => '-- Daemon wählen --',
			'statistics' => 'Statistik',
			'compactoverview' => 'Kompakt-Übersicht',
			'legend' => '<h3>Sie konfigurieren nun einen Service/Daemon.</h3>',
			'commands' => '<span class="text-danger">Kommandos:</span> Die angezeigten Befehle müssen als Benutzer root in einer Shell ausgeführt werden. Es kann auch problemlos der ganze Block kopiert und in die Shell eingefügt werden.',
			'files' => '<span class="text-danger">Konfigurationsdateien:</span> Der Befehl direkt vor dem Textfeld sollte einen Editor mit der Zieldatei öffnen. Der Inhalt kann nun einfach kopiert und in den Editor eingefügt und die Datei gespeichert werden.<br><span class="text-danger">Bitte beachten:</span> Das MySQL-Passwort wurde aus Sicherheitsgründen nicht ersetzt. Bitte ersetzen Sie "FROXLOR_MYSQL_PASSWORD" manuell oder nutzen Sie das folgende Formular, um es temporär auf dieser Seite zu setzen. Falls das Passwort vergessen wurde, findet es sich in der Datei "lib/userdata.inc.php".',
			'finishnote' => 'Parameter Datei erfolgreich erstellt. Folgende Befehle müssen als root ausgeführt werden:',
			'description' => 'System-Dienste konfigurieren',
			'minihowto' => 'Auf dieser Seite können die verschiedenen Konfigurationsvorlagen für jeden Dienst angezeigt werden, bestimmte Dienste bei Bedarf (erneut) konfiguriert oder die aktuelle Auswahl in eine JSON-Datei exportiert werden, um sie in den CLI-Skripten oder auf einem anderen Server zu verwenden.<br><br><b>Beachte</b>, dass die hervorgehobenen Dienste nicht die auf dem Server genutzten Dienste widerspiegeln, sondern Anforderungen/Empfehlungen aus den aktuellen Einstellungswerten zeigen.',
			'skipconfig' => 'Nicht (erneut) konfigurieren',
			'recommendednote' => 'Empfohlene/benötigte Dienste anhand der aktuellen Systemeinstellungen',
			'selectrecommended' => 'Empfohlene wählen',
			'downloadselected' => 'Auswahl exportieren',
		],
		'templates' => [
			'templates' => 'E-Mail-Vorlagen',
			'template_add' => 'Vorlage hinzufügen',
			'template_fileadd' => 'Dateivorlage hinzufügen',
			'template_edit' => 'Vorlage bearbeiten',
			'action' => 'Aktion',
			'email' => 'E-Mail- & Dateivorlagen',
			'subject' => 'Betreff',
			'mailbody' => 'Mailtext',
			'createcustomer' => 'Willkommensmail für neue Kunden',
			'pop_success' => 'Willkommensmail für neue E-Mail-Konten',
			'template_replace_vars' => 'Variablen, die in den Vorlagen ersetzt werden:',
			'SALUTATION' => 'Wird mit einer korrekten Anrede des Kunden ersetzt.',
			'FIRSTNAME' => 'Wird mit dem Vornamen des Kunden ersetzt.',
			'NAME' => 'Wird mit dem Namen des Kunden ersetzt.',
			'COMPANY' => 'Wird mit dem Firmennamen des Kunden ersetzt.',
			'USERNAME' => 'Wird mit dem Benutzernamen des neuen Kundenkontos ersetzt.',
			'PASSWORD' => 'Wird mit dem Passwort des neuen Kundenkontos ersetzt.',
			'EMAIL' => 'Wird mit der Adresse des neuen E-Mail-Kontos ersetzt.',
			'CUSTOMER_NO' => 'Wir mit der Kunden-Nummer ersetzt',
			'TRAFFIC' => 'Wird mit Traffic, der dem Kunden zugewiesen wurde, ersetzt.',
			'TRAFFICUSED' => 'Wird mit Traffic, der vom Kunden bereits verbraucht wurde, ersetzt.',
			'pop_success_alternative' => 'Willkommensmail für neue E-Mail-Konten für die alternative E-Mail-Adresse',
			'EMAIL_PASSWORD' => 'Wird mit dem Passwort des neuen POP3/IMAP Kontos ersetzt.',
			'index_html' => 'index Datei für neu erzeugte Kundenverzeichnisse',
			'unconfigured_html' => 'index Datei für unkonfigurierte/unbekannte Domains',
			'unconfigured_content_fallback' => 'Diese Domain muss über das Froxlor-Serververwaltungspanel konfiguriert werden, da sie derzeit keinem Kunden zugewiesen ist.',
			'file_extension' => [
				'description' => 'Die Dateiendung für die index Datei muss zwischen 1 und 6 Zeichen lang sein und darf nur aus den Zeichen a-z, A-Z und 0-9 bestehen<br><br>Standard: html',
				'title' => 'Dateiendung für Datei Vorlage',
			],
			'SERVERNAME' => 'Wird mit dem Servernamen ersetzt.',
			'CUSTOMER' => 'Wird mit dem Loginnamen des Kunden ersetzt. Nur für "index Datei für neu erzeugte Kundenverzeichnisse".',
			'ADMIN' => 'Wird mit dem Loginnamen des Admins ersetzt. Nur für "index Datei für neu erzeugte Kundenverzeichnisse".',
			'CUSTOMER_EMAIL' => 'Wird mit der E-Mail-Adresse des Kunden ersetzt. Nur für "index Datei für neu erzeugte Kundenverzeichnisse".',
			'ADMIN_EMAIL' => 'Wird mit der E-Mail-Adresse des Admin ersetzt. Nur für "index Datei für neu erzeugte Kundenverzeichnisse".',
			'filetemplates' => 'Dateivorlagen',
			'filecontent' => 'Dateiinhalt',
			'new_database_by_customer' => 'Kunden-Benachrichtigungs nach Erstellung einer neuen Datenbank',
			'new_ftpaccount_by_customer' => 'Kunden-Benachrichtigung nach Erstellung eines neuen FTP-Benutzers',
			'newdatabase' => 'Benachrichtigungs-Mails für neue Datenbank',
			'newftpuser' => 'Benachrichtigungs-Mails für neuen FTP-Benutzer',
			'CUST_NAME' => 'Kundenname',
			'DB_NAME' => 'Datenbankname',
			'DB_PASS' => 'Datenbankpasswort',
			'DB_DESC' => 'Datenbankbeschreibung',
			'DB_SRV' => 'Datenbankserver',
			'PMA_URI' => 'URL zu phpMyAdmin (wenn angegeben)',
			'USR_NAME' => 'FTP-Benutzername',
			'USR_PASS' => 'FTP-Passwort',
			'USR_PATH' => 'FTP-Heimatverzeichnis (relativ zum Kunden-Heimatverzeichnis)',
			'forgotpwd' => 'Benachrichtigungs-Mails bei Zurücksetzen des Passworts',
			'password_reset' => 'Kunden-Benachrichtigung nach Zurücksetzen des Passworts',
			'trafficmaxpercent' => 'Hinweismail für Kunden, wenn sie die angegebenen Prozent des Traffics verbraucht haben',
			'MAX_PERCENT' => 'Wird mit dem Webspace/Traffic-Limit, welches dem Kunden zugewiesen wurde, ersetzt.',
			'USAGE_PERCENT' => 'Wird mit dem Webspace/Traffic, welcher vom Kunden bereits verbraucht wurde, ersetzt.',
			'diskmaxpercent' => 'Hinweismail für Kunden, wenn sie die angegebenen Prozent des Webspaces verbraucht haben',
			'DISKAVAILABLE' => 'Wird mit dem Webspace, der dem Kunden zugewiesen wurde, ersetzt.',
			'DISKUSED' => 'Wird mit dem Webspace, welcher vom Kunden bereits verbraucht wurde, ersetzt.',
			'LINK' => 'Wird mit dem Link zum Zurücksetzen des Passworts ersetzt.',
			'SERVER_HOSTNAME' => 'Wird mit dem System-Hostname (URL zu froxlor) ersetzt',
			'SERVER_IP' => 'Wird mit der Standard-System-IP-Adresse ersetzt',
			'SERVER_PORT' => 'Wird mit dem Standard-Port ersetzt',
			'DOMAINNAME' => 'Wird mit der Standardsubdomain des Kunden ersetzt (kann leer sein, wenn keine erstellt werden soll)',
		],
		'createzonefile' => 'DNS Zone für Domain erstellen',
		'custombindzone' => 'Eigene / manuelle Zone',
		'bindzonewarning' => 'Leer für Standardeinstellung.<br /><strong class="text-danger">WARNUNG:</strong> Bei der Verwendung einer Zonendatei müssen alle benötigten Records aller Subdomains ebenfalls manuell verwaltet werden.',
		'ipsandports' => [
			'ipsandports' => 'IPs und Ports',
			'add' => 'IP-Adresse/Port hinzufügen',
			'edit' => 'IP-Adresse/Port bearbeiten',
			'ipandport' => 'IP-Adresse/Port',
			'ip' => 'IP-Adresse',
			'ipnote' => '<div id="ipnote" class="invalid-feedback">Hinweis: Obwohl private IP Adressen erlaubt sind, kann es bei manchen Features wie DNS zu ungewolltem Verhalten kommen.<br>Verwende private Adressen nur wenn du sicher bist.</div>',
			'port' => 'Port',
			'create_listen_statement' => 'Erstelle Listen-Eintrag',
			'create_namevirtualhost_statement' => 'Erstelle NameVirtualHost-Eintrag',
			'create_vhostcontainer' => 'Erstelle vHost-Container',
			'create_vhostcontainer_servername_statement' => 'Erstelle ServerName-Eintrag im vHost-Container',
			'enable_ssl' => 'Ist dies ein SSL-Port?',
			'ssl_cert_file' => 'Pfad zum Zertifikat',
			'webserverdefaultconfig' => 'Webserver-Standard-Konfiguration',
			'webserverdomainconfig' => 'Webserver-Domain-Konfiguration',
			'webserverssldomainconfig' => 'Webserver-SSL-Konfiguration',
			'ssl_key_file' => 'Pfad zum SSL-Private-Key',
			'ssl_ca_file' => 'Pfad zum SSL-CA-Zertifikat (optional)',
			'default_vhostconf_domain' => 'Standard vHost-Einstellungen für jeden Domain-Container',
			'ssl_cert_chainfile' => [
				'title' => 'Pfad zu dem SSL-CertificateChainFile (optional)',
				'description' => 'Meist CA_Bundle, o. Ä. Dies ist das Feld, das gesetzt werden sollte, wenn ein gekauftes SSL-Zertifikat vorliegt.',
			],
			'docroot' => [
				'title' => 'Benutzerdefinierter Docroot (wenn leer, zeige auf Froxlor)',
				'description' => 'Hier kann ein benutzerdefinierter Document-Root (der Zielordner für einen Zugriff) für diese IP/Port Kombination gesetzt werden.<br /><strong>ACHTUNG:</strong> Bitte überlege vorher, welchen Pfad du hier angibst!',
			],
			'ssl_paste_description' => 'Bitte den Inhalt der Zertifikatsdatei in das Textfeld kopieren.',
			'ssl_cert_file_content' => 'Inhalt des SSL-Zertifikats (Certificate)',
			'ssl_key_file_content' => 'Inhalt der Key-Datei (Private-Key)',
			'ssl_ca_file_content' => 'Inhalt der SSL-CA-Datei (optional)',
			'ssl_ca_file_content_desc' => '<br /><br />Client Authentifizierung, dieses Feld sollte nur gesetzt werden, wenn es wirklich gebraucht wird.',
			'ssl_cert_chainfile_content' => 'Inhalt des SSL-CertificateChainFile (optional)',
			'ssl_cert_chainfile_content_desc' => '<br /><br />Meist CA_Bundle, o. Ä. Dies ist das Feld, das gesetzt werden sollte, wenn ein gekauftes SSL-Zertifikat vorliegt.',
			'ssl_default_vhostconf_domain' => 'Standard SSL vHost-Einstellungen für jeden Domain-Container',
		],
		'memorylimitdisabled' => 'Deaktiviert',
		'valuemandatory' => 'Dieses Feld muss ausgefüllt werden.',
		'valuemandatorycompany' => 'Entweder "Name" und "Vorname" oder "Firma" muss ausgefüllt werden.',
		'serversoftware' => 'Webserver',
		'phpversion' => 'PHP-Version',
		'mysqlserverversion' => 'MySQL-Server-Version',
		'webserverinterface' => 'Webserver-Interface',
		'accountsettings' => 'Konteneinstellungen',
		'panelsettings' => 'Panel-Einstellungen',
		'systemsettings' => 'Systemeinstellungen',
		'webserversettings' => 'Webserver-Einstellungen',
		'mailserversettings' => 'Mailserver-Einstellungen',
		'nameserversettings' => 'Nameserver-Einstellungen',
		'updatecounters' => 'Ressourcenverbrauch',
		'subcanemaildomain' => [
			'never' => 'Nie',
			'choosableno' => 'Wählbar, Standardwert: Nein',
			'choosableyes' => 'Wählbar, Standardwert: Ja',
			'always' => 'Immer',
		],
		'wipecleartextmailpwd' => 'Klartext-Passwörter leeren',
		'webalizersettings' => 'Webalizereinstellungen',
		'webalizer' => [
			'normal' => 'Normal',
			'quiet' => 'Leise',
			'veryquiet' => 'Keine Ausgaben',
		],
		'domain_nocustomeraddingavailable' => 'Es können derzeit keine Domains angelegt werden. Sie müssen zuerst einen Kunden anlegen',
		'loggersettings' => 'Log-Einstellungen',
		'logger' => [
			'normal' => 'Normal',
			'paranoid' => 'Paranoid',
		],
		'emaildomain' => 'E-Mail-Domain',
		'email_only' => 'Nur als E-Mail-Domain verwenden?',
		'wwwserveralias' => 'Einen "www." ServerAlias hinzufügen',
		'subject' => 'Betreff',
		'recipient' => 'Empfänger',
		'message' => 'Rundmail senden',
		'text' => 'Nachricht',
		'sslsettings' => 'SSL-Einstellungen',
		'specialsettings_replacements' => 'Die folgenden Variablen können verwendet werden:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (wenn zutreffend)<br/>',
		'antispam_settings' => 'Antispam-Einstellungen',
		'caneditphpsettings' => 'Kann PHP-bezogene Domaineinstellungen vornehmen?',
		'allips' => 'Alle IP-Adressen',
		'awstatssettings' => 'AWstats-Einstellungen',
		'domain_dns_settings' => 'Domain-DNS-Einstellungen',
		'activated' => 'Aktiviert',
		'statisticsettings' => 'Statistik-Einstellungen',
		'or' => 'oder',
		'sysload' => 'System-Auslastung',
		'noloadavailable' => 'nicht verfügbar',
		'nouptimeavailable' => 'nicht verfügbar',
		'nosubject' => '(Kein Betreff)',
		'show_version_login' => [
			'title' => 'Zeige Froxlor Version beim Login',
			'description' => 'Zeige Froxlor Version in der Fußzeile der Loginseite',
		],
		'show_version_footer' => [
			'title' => 'Zeige Froxlor Version in Fußzeile',
			'description' => 'Zeige Froxlor Version in der Fußzeile aller anderen Seiten',
		],
		'froxlor_graphic' => [
			'title' => 'Grafik im Kopfbereich des Panels',
			'description' => 'Welche Grafik soll im Kopfbereich des Panels anstatt des Froxlor Logos angezeigt werden?',
		],
		'phpsettings' => [
			'title' => 'PHP-Konfiguration',
			'description' => 'Kurzbeschreibung',
			'actions' => 'Aktionen',
			'activedomains' => 'In Verwendung für Domain(s)',
			'notused' => 'Konfiguration wird nicht verwendet',
			'editsettings' => 'PHP-Konfiguration bearbeiten',
			'addsettings' => 'PHP-Konfiguration erstellen',
			'viewsettings' => 'PHP-Konfiguration ansehen',
			'phpinisettings' => 'php.ini-Einstellungen',
			'addnew' => 'Neue PHP Konfiguration erstellen',
			'binary' => 'PHP-Binary',
			'fpmdesc' => 'PHP-FPM Config',
			'file_extensions' => 'Dateiendungen',
			'file_extensions_note' => '(ohne Punkt, durch Leerzeichen getrennt)',
			'enable_slowlog' => 'FPM-slowlog pro Domain aktivieren',
			'request_terminate_timeout' => 'request_terminate_timeout',
			'request_slowlog_timeout' => 'request_slowlog_timeout',
			'activephpconfigs' => 'In Verwendung für PHP-Konfiguration(en)',
			'pass_authorizationheader' => 'Übergeben von HTTP AUTH BASIC/DIGEST-Headern von Apache an PHP',
		],
		'misc' => 'Sonstiges',
		'fpmsettings' => [
			'addnew' => 'Neue PHP Version erstellen',
			'edit' => 'PHP version bearbeiten',
		],
		'phpconfig' => [
			'template_replace_vars' => 'Variablen, die in den Konfigurationen ersetzt werden',
			'pear_dir' => 'Wird mit dem globalen Wert für das Include Verzeichnis ersetzt.',
			'open_basedir_c' => 'Wird mit einem ; (Semikolon) ersetzt, um open_basedir auszukommentieren/deaktivieren, wenn eingestellt.',
			'open_basedir' => 'Wird mit der open_basedir-Einstellung der Domain ersetzt.',
			'tmp_dir' => 'Wird mit der Einstellung für das temporäre Verzeichnis der Domain ersetzt.',
			'open_basedir_global' => 'Wird mit der globalen Einstellung des Pfades ersetzt, der dem open_basedir hinzugefügt wird (siehe Webserver Einstellungen).',
			'customer_email' => 'Wird mit der E-Mail-Adresse des Kunden ersetzt, dem die Domain gehört.',
			'admin_email' => 'Wird mit der E-Mail-Adresse des Admins ersetzt, dem die Domain gehört.',
			'domain' => 'Wird mit der Domain ersetzt.',
			'customer' => 'Wird mit dem Loginnamen des Kunden ersetzt, dem die Domain gehört.',
			'admin' => 'Wird mit dem Loginnamen des Admins ersetzt, dem die Domain gehört.',
			'docroot' => 'Wird mit dem Heimatverzeichnis der Domain ersetzt.',
			'homedir' => 'Wird mit dem Heimatverzeichnis des Kunden ersetzt.',
		],
		'know_what_youre_doing' => 'Ändern Sie diese Einstellungen nur, wenn Sie wissen was Sie tun!',
		'security_settings' => 'Sicherheitseinstellungen',
		'expert_settings' => 'Experteneinstellungen!',
		'mod_fcgid_starter' => [
			'title' => 'PHP-Prozesse für diese Domain (leer für Standardwert)',
		],
		'phpserversettings' => 'PHP-Einstellungen',
		'mod_fcgid_maxrequests' => [
			'title' => 'Maximale PHP-Requests für diese Domain (leer für Standardwert)',
		],
		'webserver' => 'Webserver',
		'spfsettings' => 'Domain-SPF-Einstellungen',
		'specialsettingsforsubdomains' => 'Übernehme Einstellungen für alle Subdomains (*.beispiel.de)',
		'accountdata' => 'Benutzerdaten',
		'contactdata' => 'Kontaktdaten',
		'servicedata' => 'Dienstleistungsdaten',
		'newerversionavailable' => 'Eine neuere Version von Froxlor wurde veröffentlicht.',
		'newerversiondetails' => 'Jetzt auf Version <b>%s</b> aktualisieren?<br/>(Aktuelle Version ist: %s)',
		'extractdownloadedzip' => 'Heruntergeladenes Archiv "%s" entpacken?',
		'cron' => [
			'cronsettings' => 'Cronjob-Einstellungen',
			'add' => 'Cronjob hinzufügen',
		],
		'cronjob_edit' => 'Cronjob bearbeiten',
		'warning' => 'ACHTUNG - Wichtiger Hinweis!',
		'lastlogin_succ' => 'Letzte Anmeldung',
		'ftpserver' => 'FTP-Server',
		'ftpserversettings' => 'FTP-Server-Einstellungen',
		'webserver_user' => 'Benutzername Webserver',
		'webserver_group' => 'Gruppenname Webserver',
		'perlenabled' => 'Perl verfügbar',
		'fcgid_settings' => 'FCGID',
		'mod_fcgid_user' => 'Lokaler Benutzer für FCGID (Froxlor Vhost)',
		'mod_fcgid_group' => 'Lokale Gruppe für FCGID (Froxlor Vhost)',
		'perl_settings' => 'Perl/CGI',
		'notgiven' => '[nicht angegeben]',
		'store_defaultindex' => 'Standard-Index-Datei im Kundenordner erstellen',
		'phpfpm_settings' => 'PHP-FPM',
		'traffic' => 'Traffic',
		'traffic_sub' => 'Details der Traffic-Nutzung',
		'customertraffic' => 'Kunden',
		'assignedmax' => 'Zugewiesen / Max.',
		'usedmax' => 'Benutzt / Max.',
		'used' => 'Benutzt',
		'speciallogwarning' => '<div id="speciallogfilenote" class="invalid-feedback">ACHTUNG: Durch diese Einstellungen werden Sie alle bisherige Statistiken dieser Domain verlieren.</div>',
		'speciallogfile' => [
			'title' => 'Eigene Log-Datei',
			'description' => 'Aktivieren Sie diese Option, um für diese Domain eine eigene Access-Log Datei zu erhalten',
		],
		'domain_editable' => [
			'title' => 'Erlaube Bearbeiten der Domain',
			'desc' => 'Wenn ja, darf der Kunde verschiedene Einstellungen anpassen.<br />Wenn nein, darf nichts durch den Kunden geändert werden.',
		],
		'writeaccesslog' => [
			'title' => 'Zugriffslog schreiben',
			'description' => 'Aktiviere diese Option, um für diese Domain eine Access-Log Datei zu erhalten',
		],
		'writeerrorlog' => [
			'title' => 'Fehlerlog schreiben',
			'description' => 'Aktiviere diese Option, um für diese Domain eine Error-Log Datei zu erhalten',
		],
		'phpfpm.ininote' => 'Nicht alle gewünschten Werte können in der php-fpm-pool-Konfiguration verwendet werden.',
		'selectserveralias' => 'ServerAlias-Angabe für Domain',
		'selectserveralias_desc' => 'Wählen Sie hier, ob für diese Domain ein Wildcard-Eintrag (*.domain.tld), ein www-Alias (www.domain.tld) oder gar kein Alias angelegt werden soll.',
		'show_news_feed' => [
			'title' => 'Zeige Newsfeed im Admin-Dashboard',
			'description' => 'Aktivieren Sie diese Option, um das offizielle Froxlor newsfeed (https://inside.froxlor.org/news/) auf deinem Dashboard anzuzeigen und verpasse keine wichtigen Informationen oder Release-Announcements.',
		],
		'cronsettings' => 'Cronjob-Einstellungen',
		'integritycheck' => 'Datenbankprüfung',
		'integrityname' => 'Name',
		'integrityresult' => 'Ergebnis',
		'integrityfix' => 'Probleme automatisch beheben',
		'customer_show_news_feed' => 'Zeige Newsfeed im Kunden-Dashboard',
		'customer_news_feed_url' => [
			'title' => 'Benutzerdefiniertes RSS-Feed',
			'description' => 'Hier kann ein eigenes RSS-Feed angegeben werden, welches den Kunden auf dem Dashboard angezeigt wird.<br /><small>Leerlassen um das offizielle Froxlor Newsfeed (https://inside.froxlor.org/news/) zu verwenden.</small>',
		],
		'movetoadmin' => 'Kunde verschieben',
		'movecustomertoadmin' => [
			'title' => 'Verschiebe den Kunden zum angegebenen Admin/Reseller',
			'description' => 'Leerlassen für keine Änderung.<br />Wird der gewünschte Admin/Reseller hier nicht aufgelistet, hat er sein Kunden-Kontigent erreicht.',
		],
		'note' => 'Hinweis',
		'mod_fcgid_umask' => [
			'title' => 'Umask (Standard: 022)',
		],
		'letsencrypt' => [
			'title' => 'SSL Zertifikat erstellen (Let\'s Encrypt)',
			'description' => 'Holt ein kostenloses Zertifikat von <a href="https://letsencrypt.org">Let\'s Encrypt</a>. Das Zertifikat wird automatisch erstellt und verlängert.<br><strong class="text-danger">ACHTUNG:</strong> Wenn Wildcards aktiviert sind, wird diese Option automatisch deaktiviert.',
		],
		'autoupdate' => 'Auto-Update',
		'dnsenabled' => 'Zugriff auf DNS Editor',
		'froxlorvhost' => 'Froxlor VirtualHost Einstellungen',
		'hostname' => 'Hostname',
		'memory' => 'Speicherauslastung',
		'webserversettings_ssl' => 'Webserver SSL-Einstellungen',
		'domain_hsts_maxage' => [
			'title' => 'HTTP Strict Transport Security (HSTS)',
			'description' => '"max-age" Wert für den Strict-Transport-Security Header<br>Der Wert <i>0</i> deaktiviert HSTS für diese Domain. Meist wird der Wert <i>31536000</i> gerne genutzt (ein Jahr).',
		],
		'domain_hsts_incsub' => [
			'title' => 'Inkludiere HSTS für jede Subdomain',
			'description' => 'Die optionale "includeSubDomains" Direktive, wenn vorhanden, signalisiert dem UA, dass die HSTS Regel für diese Domain und auch jede Subdomain dieser gilt.',
		],
		'domain_hsts_preload' => [
			'title' => 'Füge Domain in die HSTS preload Liste hinzu',
			'description' => 'Wenn die Domain in die <a href="https://hstspreload.org/" target="_blank">HSTS preload Liste</a>, verwaltet von Chrome (und genutzt von Firefox und Safari), hinzugefügt werden soll, dann aktivieren Sie diese Einstellung.<br>Die preload-Direktive zu senden kann PERMANTENTE KONSEQUENZEN haben und dazu führen, dass Benutzer auf diese Domain und auch Subdomains nicht zugreifen können.<br>Beachten Sie die Details unter <a href="https://hstspreload.org/#removal" target="_blank">https://hstspreload.org/#removal</a> bevor ein Header mit "preload" gesendet wird.',
		],
		'domain_ocsp_stapling' => [
			'title' => 'OCSP stapling',
			'description' => 'Siehe <a target="_blank" href="https://de.wikipedia.org/wiki/Online_Certificate_Status_Protocol_stapling">Wikipedia</a> für eine ausführliche Beschreibung von OCSP-Stapling',
			'nginx_version_warning' => '<br /><strong class="text-danger">WARNUNG:</strong> Nginx unterstützt OCSP-Stapling erst ab Version 1.3.7. Wenn Ihre Version älter ist, wird der Webserver bei aktiviertem OCSP-Stapling NICHT korrekt starten.',
		],
		'domain_http2' => [
			'title' => 'HTTP2 Unterstützung',
			'description' => 'Siehe <a target="_blank" href="https://de.wikipedia.org/wiki/Hypertext_Transfer_Protocol#HTTP.2F2">Wikipedia</a> für eine ausführliche Beschreibung von HTTP2',
		],
		'testmail' => 'SMTP Test',
		'phpsettingsforsubdomains' => 'PHP-Config für alle Subdomains übernehmen:',
		'plans' => [
			'name' => 'Plan Name',
			'description' => 'Beschreibung',
			'last_update' => 'Zuletzt aktualisiert',
			'plans' => 'Hosting Pläne',
			'plan_details' => 'Plan Details',
			'add' => 'Neuen Plan anlegen',
			'edit' => 'Plan editieren',
			'use_plan' => 'Plan übernehmen',
		],
		'notryfiles' => [
			'title' => 'Keine generierte try_files Anweisung',
			'description' => 'Wählen Sie "Ja", wenn eine eigene try_files Direktive in den "eigenen Vhost Einstellungen" angegeben werden soll (z.B. nötig für manche Wordpress Plugins).',
		],
		'logviewenabled' => 'Zugriff auf access/error-Logdateien',
		'novhostcontainer' => '<br><br><small class="text-danger">Keine der IPs und Ports hat die Option "Erstelle vHost-Container" aktiviert, einige Einstellungen sind daher nicht verfügbar.</small>',
		'ownsslvhostsettings' => 'Eigene SSL vHost-Einstellungen',
		'domain_override_tls' => 'Überschreibe System TLS Einstellungen',
		'domain_override_tls_addinfo' => '<br /><span class="text-danger">Nur verwendet wenn "Überschreibe System TLS Einstellungen" auf "Ja" gestellt ist</span>',
		'domain_sslenabled' => 'Aktiviere Nutzung von SSL',
		'domain_honorcipherorder' => 'Bevorzuge die serverseitige Cipher Reihenfolge, Standardwert <strong>nein</strong>',
		'domain_sessiontickets' => 'Aktiviere TLS Sessiontickets (RFC 5077), Standardwert <strong>ja</strong>',
		'domain_sessionticketsenabled' => [
			'title' => 'Aktiviere Nutzung von TLS Sessiontickets systemweit',
			'description' => 'Standardwert <strong>yes</strong><br>Erfordert apache-2.4.11+ oder nginx-1.5.9+',
		],
		'domaindefaultalias' => 'Standard ServerAlias-Angabe für neue Domains',
		'smtpsettings' => 'SMTP Einstellungen',
		'smtptestaddr' => 'Test-Email senden an',
		'smtptestnote' => 'Bitte beachten: Die untenstehenden Werte reflektieren die aktuellen Einstellungen und können auch nur dort angepasst werden (siehe Link in der oberen rechten Ecke)',
		'smtptestsend' => 'Test-Email senden',
		'mysqlserver' => [
			'caption' => 'Beschreibung',
			'user' => 'Privilegierter Benutzer',
			'add' => 'MySQL Server hinzufügen',
			'edit' => 'MySQL Server bearbeiten',
			'password' => 'Passwort privilegierter Benutzer',
			'password_emptynochange' => 'Neues Passwort, leer für keine Änderung',
			'allowall' => [
				'title' => 'Nutzung für aktuelle Kunden automatisch erlauben',
				'description' => 'Ist diese Einstellung aktiv, wird die Verwendung dieses Datenbank-Servers automatisch allen aktuell existierenden Kunden-Accounts erlaubt. Diese Einstellung ist nicht permanent, kann aber mehrfach / nach Bedarf ausgeführt werden.',
			],
			'testconn' => 'Teste Verbindung beim Speichern',
			'ssl' => 'Verwende SSL für die Verbindung zum Datenbank-Server',
			'ssl_cert_file' => 'Dateipfad zur SSL certificate authority',
			'verify_ca' => 'Aktiviere SSL Zertifikats-Verifikation',
		],
		'settings_importfile' => 'Wähle Import-Datei',
		'documentation' => 'Dokumentation',
		'adminguide' => 'Admin Guide',
		'userguide' => 'User Guide',
		'apiguide' => 'API Guide',
		'domain_duplicate' => 'Domain duplizieren',
		'domain_duplicate_named' => '%s duplizieren',
		'emaildomainwarning' => '<div id="emaildomainnote" class="invalid-feedback">ACHTUNG: Durch die Änderung dieser Einstellung löschen Sie alle bestehenden E-Mail-Adressen und -Konten unwiderruflich.</div>',
	],
	'apikeys' => [
		'no_api_keys' => 'Keine API Keys gefunden',
		'key_add' => 'API Key hinzufügen',
		'apikey_removed' => 'Der API Key mit der ID #%s wurde erfolgreich gelöscht.',
		'apikey_added' => 'Der neue API Key wurde erfolgreich angelegt.',
		'clicktoview' => 'Details anzeigen',
		'allowed_from' => 'Erlaube Zugriff von',
		'allowed_from_help' => 'Komma getrennte Liste von IPs oder Netzen.<br>Standard ist leer (von überall erlaubt).',
		'valid_until' => 'Gültig bis',
		'valid_until_help' => 'Datum Gültigkeitsende, Format YYYY-MM-DDThh:mm',
	],
	'changepassword' => [
		'old_password' => 'Altes Passwort',
		'new_password' => 'Neues Passwort',
		'new_password_confirm' => 'Neues Passwort bestätigen',
		'new_password_ifnotempty' => 'Neues Passwort (leer für keine Änderung)',
		'also_change_ftp' => 'Auch Passwort des Haupt-FTP-Zugangs ändern',
		'also_change_stats' => ' Auch Passwort der Statistikseite ändern',
		'also_change_global_mysql' => 'Auch Passwort des globalen MySQL-Zugangs ändern',
	],
	'cron' => [
		'cronname' => 'Cronjob-Name',
		'lastrun' => 'Zuletzt gestartet',
		'interval' => 'Intervall',
		'isactive' => 'Aktiv',
		'description' => 'Beschreibung',
		'changewarning' => 'Änderungen an diesen Werten können einen negativen Effekt auf das Verhalten von Froxlor und seinen automatisierten Aufgaben haben.<br />Ändern Sie hier bitte nur etwas, wenn Sie sich über die Folgen im Klaren sind.',
	],
	'crondesc' => [
		'cron_unknown_desc' => 'Keine Beschreibung angegeben',
		'cron_tasks' => 'Erstellen von Konfigurationsdateien',
		'cron_legacy' => 'Legacy (alter) Cronjob',
		'cron_traffic' => 'Traffic-Berechnung',
		'cron_usage_report' => 'Webspace- und Trafficreport',
		'cron_mailboxsize' => 'Berechnung der Mailbox-Größen',
		'cron_letsencrypt' => 'Aktualisierung der Let\'s Encrypt Zertifikate',
		'cron_export' => 'Ausstehende Datenexporte erstellen',
		'cron_backup' => 'System- und Kunden-Sicherungen erstellen',
	],
	'cronjob' => [
		'cronjobsettings' => 'Cronjob-Einstellungen',
		'cronjobintervalv' => 'Laufzeit-Intervall Wert',
		'cronjobinterval' => 'Laufzeit-Intervall',
	],
	'cronjobs' => [
		'notyetrun' => 'Bisher nicht gestartet',
	],
	'cronmgmt' => [
		'minutes' => 'Minuten',
		'hours' => 'Stunden',
		'days' => 'Tage',
		'weeks' => 'Wochen',
		'months' => 'Monate',
	],
	'customer' => [
		'documentroot' => 'Heimatverzeichnis',
		'name' => 'Name',
		'firstname' => 'Vorname',
		'lastname' => 'Nachname',
		'company' => 'Firma',
		'nameorcompany_desc' => 'Entweder Vorname/Name oder Firma ist erforderlich',
		'street' => 'Straße',
		'zipcode' => 'PLZ',
		'city' => 'Ort',
		'phone' => 'Telefon',
		'fax' => 'Fax',
		'email' => 'E-Mail-Adresse',
		'customernumber' => 'Kundennummer',
		'diskspace' => 'Webspace',
		'traffic' => 'Traffic',
		'mysqls' => 'MySQL-Datenbanken',
		'emails' => 'E-Mail-Adressen',
		'accounts' => 'E-Mail-Konten',
		'forwarders' => 'E-Mail-Weiterleitungen',
		'ftps' => 'FTP-Konten',
		'subdomains' => 'Subdomain(s)',
		'domains' => 'Domain(s)',
		'title' => 'Titel',
		'country' => 'Land',
		'email_quota' => 'E-Mail-Kontingent',
		'email_imap' => 'IMAP',
		'email_pop3' => 'POP3',
		'sendinfomail' => 'Daten per E-Mail an mich senden',
		'generated_pwd' => 'Passwortvorschlag',
		'usedmax' => 'Benutzt / Max.',
		'services' => 'Dienste',
		'letsencrypt' => [
			'title' => 'SSL Zertifikat erstellen (Let\'s Encrypt)',
			'description' => 'Holt ein kostenloses Zertifikat von <a href="https://letsencrypt.org">Let\'s Encrypt</a>. Das Zertifikat wird automatisch erstellt und verlängert.',
		],
		'selectserveralias_addinfo' => 'Diese Option steht beim Bearbeiten der Domain zur Verfügung. Als Initial-Wert wird die Einstellung der Hauptdomain vererbt.',
		'total_diskspace' => 'Gesamtspeicherplatz',
		'mysqlserver' => 'Erlaubte MySQL-Server',
	],
	'diskquota' => 'Quota',
	'antispam' => [
		'config_file' => [
			'title' => 'Antispam Konfigurationsdatei',
			'description' => 'Pfad + Dateiname der Antispam-Regel Konfigurationsdatei',
		],
		'reload_command' => [
			'title' => 'Milter-Restart-Befehl',
			'description' => 'Wie lautet der Befehl zum Neustarten des rspamd-Dienstes?',
		],
		'activated' => [
			'title' => 'Antispam aktivieren?',
			'description' => 'Aktivieren, um rspamd als Antispam Dienst zu verwenden.',
		],
		'dkim_keylength' => [
			'title' => 'DKIM Schlüssel-Länge',
			'description' => 'Achtung: Änderungen sind nur für neue Schlüssel gültig.<br/><br/>Erfordert einen speziellen DNS Eintrag für die Domain. Wenn das Nameserver-Feature nicht genutzt wird, muss dieser Eintrag manuell verwaltet werden.',
		],
		'spam_tag_level' => [
			'title' => 'Spam Level',
			'description' => 'Erforderliche Punktzahl zum Markieren einer E-Mail als Spam<br/>Standard: 7.0'
		],
		'rewrite_subject' => [
			'title' => 'Betreff ändern',
			'description' => 'Dem E-Mail Betreff <strong>***SPAM***</strong> hinzufügen, sofern zutreffend',
		],
		'spam_kill_level' => [
			'title' => 'Ablehnungs Level',
			'description' => 'Erforderliche Punktzahl für das Ablehnen einer E-Mail<br/>Standard: 14.0'
		],
		'bypass_spam' => [
			'title' => 'Spamfilter umgehen',
			'description' => 'Aktivieren, um den Spamfilter für diese Adresse zu umgehen/deaktivieren.<br/>Standard: Nein'
		],
		'policy_greylist' => [
			'title' => 'Verwende greylisting',
			'description' => 'Eingehende E-Mails mittels <a href="https://de.wikipedia.org/wiki/Greylisting" target="_blank">Greylisting</a> schützen.<br/>Standard: Ja'
		],
		'required_spf_dns' => 'Erforderlicher SPF DNS Eintrag',
		'required_dmarc_dns' => 'Erforderlicher DMARC DNS Eintrag',
		'required_dkim_dns' => 'Erforderlicher DKIM DNS Eintrag',
		'default_select' => [
			'on_changeable' => 'Aktiviert, einstellbar',
			'off_changeable' => 'Deaktiviert, einstellbar',
			'on_unchangeable' => 'Aktiviert, nicht einstellbar',
			'off_unchangeable' => 'Deaktiviert, nicht einstellbar',
		],
		'default_bypass_spam' => [
			'title' => 'Standardwert: Spamfilter umgehen',
			'description' => 'Wählen, ob bei neuen E-Mail-Konten "Spamfilter umgehen" standardmäßig aktiviert ist und ob diese Einstellung vom Kunden angepasst werden kann.<br/>Standard: Deaktiviert, einstellbar'
		],
		'default_spam_rewrite_subject' => [
			'title' => 'Standardwert: Betreff ändern',
			'description' => 'Wählen, ob bei neuen E-Mail-Konten "Betreff ändern" standardmäßig aktiviert ist und ob diese Einstellung vom Kunden angepasst werden kann.<br/>Standard: Aktiviert, einstellbar'
		],
		'default_policy_greylist' => [
			'title' => 'Standardwert: Verwende greylisting',
			'description' => 'Wählen, ob bei neuen E-Mail-Konten "Verwende greylisting" standardmäßig aktiviert ist und ob diese Einstellung vom Kunden angepasst werden kann.<br/>Standard: Aktiviert, einstellbar'
		],
	],
	'dns' => [
		'destinationip' => 'Domain-IP-Adresse(n)',
		'standardip' => 'Server-Standard-IP-Adresse',
		'a_record' => 'A-Eintrag (IPv6 optional)',
		'cname_record' => 'CNAME-Eintrag',
		'mxrecords' => 'MX Einträge definieren',
		'standardmx' => 'Server Standard MX Eintrag',
		'mxconfig' => 'Eigene MX Einträge',
		'priority10' => 'Priorität 10',
		'priority20' => 'Priorität 20',
		'txtrecords' => 'TXT-Einträge definieren',
		'txtexample' => 'Beispiel (SPF-Eintrag):<br />v=spf1 ip4:xxx.xxx.xx.0/23 -all',
		'howitworks' => 'Hier können DNS Einträge für die Domain verwaltet werden. Beachten Sie, dass Froxlor automatisch NS/MX/A/AAAA Einträge generiert. Die benutzerdefinierten Einträge werden bevorzugt, nur fehlende Einträge werden automatisch generiert.',
	],
	'dnseditor' => [
		'edit' => 'DNS editieren',
		'records' => 'Einträge',
	],
	'domain' => [
		'openbasedirpath' => 'OpenBasedir-Pfad',
		'inherited' => 'Gleich wie Elterndomain',
		'docroot' => 'Oben angegebener Pfad',
		'homedir' => 'Heimverzeichnis',
		'docparent' => 'Elternverzeichnis des oben angegebenen Pfads',
	],
	'domains' => [
		'description' => 'Hier können Sie (Sub-)Domains erstellen und deren Pfade ändern.<br />Nach jeder Änderung braucht das System etwas Zeit, um die Konfiguration neu einzulesen.',
		'domainsettings' => 'Domaineinstellungen',
		'domainname' => 'Domainname',
		'subdomain_add' => 'Subdomain anlegen',
		'subdomain_edit' => '(Sub-)Domain bearbeiten',
		'wildcarddomain' => 'Als Wildcarddomain eintragen?',
		'aliasdomain' => 'Alias für Domain',
		'noaliasdomain' => 'Keine Aliasdomain',
		'hasaliasdomains' => 'Hat Aliasdomain(s)',
		'statstics' => 'Statistiken',
		'isassigneddomain' => 'zugewiesene Domain',
		'add_date' => 'Zu Froxlor hinzugefügt',
		'registration_date' => 'Registriert am',
		'topleveldomain' => 'Top-Level-Domain',
		'associated_with_domain' => 'Verbunden mit',
		'aliasdomains' => 'Aliasdomains',
		'redirectifpathisurl' => 'Redirect-Code (Standard: leer)',
		'redirectifpathisurlinfo' => 'Der Redirect-Code kann gewählt werden, wenn der eingegebene Pfad eine URL ist.<br/><strong class="text-danger">HINWEIS:</strong> Änderungen werden nur wirksam wenn der Pfad eine URL ist.',
		'ipandport_multi' => [
			'title' => 'IP-Adresse(n)',
			'description' => 'Definieren Sie eine oder mehrere IP-Adresse(n) für diese Domain.<br /><br /><div class="text-danger">Hinweis: Die IP-Adressen können nicht geändert werden, sollte die Domain als <strong>Alias-Domain</strong> für eine andere Domain konfiguriert worden sein.</div>',
		],
		'ipandport_ssl_multi' => [
			'title' => 'SSL-IP-Adresse(n)',
		],
		'ssl_redirect' => [
			'title' => 'SSL-Weiterleitung',
			'description' => 'Diese Option erstellt für alle Nicht-SSL-vHosts eine Weiterleitung (Redirect), so dass alle Anfragen an den SSL-vHost übermittelt werden (z. B. würde eine Anfrage an <strong>http</strong>://domain.tld/ weitergeleitet werden zu <strong>https</strong>://domain.tld/).',
		],
		'serveraliasoption_wildcard' => 'Wildcard (*.domain.tld)',
		'serveraliasoption_www' => 'www (www.domain.tld)',
		'serveraliasoption_none' => 'Kein Alias',
		'domain_import' => 'Domains importieren',
		'import_separator' => 'Trennzeichen',
		'import_offset' => 'Versatz (offset)',
		'import_file' => 'CSV-Datei',
		'import_description' => 'Detaillierte Informationen über den Aufbau der Importdatei und einen erfolgreichen Import gibt es hier: <a href="https://docs.froxlor.org/latest/admin-guide/domain-import/" target="_blank" class="alert-link">https://docs.froxlor.org/latest/admin-guide/domain-import/</a> (englisch)',
		'ssl_redirect_temporarilydisabled' => '<br>Die SSL-Umleitung ist, während ein neues Let\'s Encrypt - Zertifikat erstellt wird, temporär deaktiviert. Die Umleitung wird nach der Zertifikatserstellung wieder aktiviert.',
		'termination_date' => 'Kündigungsdatum',
		'termination_date_overview' => 'gekündigt zum ',
		'ssl_certificates' => 'SSL Zertifikate',
		'ssl_certificate_removed' => 'Das Zertifikat mit der ID #%s wurde erfolgreich gelöscht.',
		'ssl_certificate_error' => 'Fehler beim Lesen des Zertifikats für die Domain: %s',
		'no_ssl_certificates' => 'Es wurden keine SSL-Zertifikate gefunden',
		'isaliasdomainof' => 'Ist Aliasdomain für %s',
		'isbinddomain' => 'Erstelle DNS-Zone',
		'dkimenabled' => 'DKIM aktiviert',
		'openbasedirenabled' => 'Openbasedir Einschränkung',
		'hsts' => 'HSTS aktiviert',
		'aliasdomainid' => 'ID der Alias-Domain',
		'nodomainsassignedbyadmin' => 'Diesem Account wurde noch keine (aktive) Domain zugewiesen. Bitte kontaktiere deinen Administrator, wenn du der Meinung bist, das ist nicht korrekt.',
		'email_only' => 'Nur E-Mail',
	],
	'emails' => [
		'description' => 'Hier können Sie Ihre E-Mail-Adressen einrichten.<br />Ein Konto ist wie Ihr Briefkasten vor der Haustür. Wenn jemand eine E-Mail an Sie schreibt, wird diese in dieses Konto gelegt.<br /><br />Die Zugangsdaten lauten wie folgt: (Die Angaben in <i>kursiver</i> Schrift sind durch die jeweiligen Einträge zu ersetzen)<br /><br />Hostname: <b><i>Domainname</i></b><br />Benutzername: <b><i>Kontoname / E-Mail-Adresse</i></b><br />Passwort: <b><i>das gewählte Passwort</i></b>',
		'emailaddress' => 'E-Mail-Adresse',
		'emails_add' => 'E-Mail-Adresse anlegen',
		'emails_edit' => 'E-Mail-Adresse ändern',
		'catchall' => 'Catchall',
		'iscatchall' => 'Als Catchall-Adresse definieren?',
		'account' => 'Konto',
		'account_add' => 'Konto anlegen',
		'account_delete' => 'Konto löschen',
		'from' => 'Von',
		'to' => 'Nach',
		'forwarders' => 'Weiterleitungen',
		'forwarder_add' => 'Weiterleitung hinzufügen',
		'alternative_emailaddress' => 'Alternative E-Mail-Adresse',
		'quota' => 'Kontingent',
		'noquota' => 'Kein Kontingent',
		'updatequota' => 'Update Kontingent',
		'quota_edit' => 'E-Mail-Kontingent ändern',
		'noemaildomainaddedyet' => 'Sie haben bisher noch keine (E-Mail-)Domain in Ihrem Konto.',
		'back_to_overview' => 'Zurück zur Domain-Übersicht',
		'accounts' => 'Konten',
		'emails' => 'Adressen',
	],
	'error' => [
		'error' => 'Fehlermeldung',
		'directorymustexist' => 'Das Verzeichnis "%s" muss existieren. Legen Sie es bitte mit Ihrem FTP-Programm an.',
		'filemustexist' => 'Die Datei "%s" muss existieren.',
		'allresourcesused' => 'Sie haben bereits alle Ihnen zur Verfügung stehenden Ressourcen verbraucht.',
		'domains_cantdeletemaindomain' => 'Sie können keine zugewiesene Domain löschen. ',
		'domains_canteditdomain' => 'Sie können diese Domain nicht bearbeiten. Dies wurde durch den Admin verweigert.',
		'domains_cantdeletedomainwithemail' => 'Sie können keine Domain löschen, die noch als E-Mail-Domain verwendet wird. Löschen Sie zuerst alle E-Mail-Adressen dieser Domain.',
		'firstdeleteallsubdomains' => 'Sie müssen zuerst alle Subdomains löschen, bevor Sie eine Wildcarddomain anlegen können.',
		'youhavealreadyacatchallforthisdomain' => 'Sie haben bereits eine E-Mail-Adresse als Catchall für diese Domain definiert.',
		'ftp_cantdeletemainaccount' => 'Sie können Ihren Hauptaccount nicht löschen.',
		'login' => 'Die Kombination aus Benutzername und Passwort ist ungültig.',
		'login_blocked' => 'Dieser Account wurde aufgrund zu vieler Fehlversuche vorübergehend geschlossen.<br />Bitte versuchen Sie es in "%s" Sekunden erneut.',
		'notallreqfieldsorerrors' => 'Sie haben nicht alle Felder bzw. ein Feld mit fehlerhaften Angaben ausgefüllt.',
		'oldpasswordnotcorrect' => 'Das alte Passwort ist nicht korrekt.',
		'youcantallocatemorethanyouhave' => 'Sie können nicht mehr Ressourcen verteilen als Ihnen noch zur Verfügung stehen.',
		'mustbeurl' => 'Sie müssen eine vollständige URL angeben (z. B. http://domain.de/error404.htm).',
		'invalidpath' => 'Sie haben keine gültige URL angegeben (evtl. Probleme beim Verzeichnislisting?).',
		'stringisempty' => 'Fehlende Eingabe im Feld',
		'stringiswrong' => 'Falsche Eingabe im Feld',
		'newpasswordconfirmerror' => 'Das neue Passwort und dessen Bestätigung sind nicht identisch.',
		'mydomain' => '\'Domain\'',
		'mydocumentroot' => '\'Documentroot\'',
		'loginnameexists' => 'Der Login-Name "%s" existiert bereits.',
		'emailiswrong' => 'Die E-Mail-Adresse "%s" enthält ungültige Zeichen oder ist nicht vollständig.',
		'emailexists' => 'Die E-Mail-Adresse "%s" wird bereits von einem anderen Admin verwendet',
		'emailexistsanon' => 'Die E-Mail-Adresse "%s" wird bereits verwendet',
		'alternativeemailiswrong' => 'Die angegebene alternative E-Mail Adresse "%s", an welche die Zugangsdaten geschickt werden soll, scheint ungültig zu sein.',
		'loginnameiswrong' => 'Der Login-Name "%s" enthält ungültige Zeichen.',
		'loginnameiswrong2' => 'Der Login-Name enthält zu viele Zeichen, es sind maximal %s Zeichen erlaubt.',
		'userpathcombinationdupe' => 'Die Kombination aus Benutzername und Pfad existiert bereits.',
		'patherror' => 'Allgemeiner Fehler! Pfad darf nicht leer sein.',
		'errordocpathdupe' => 'Option für Pfad "%s" existiert bereits.',
		'adduserfirst' => 'Sie müssen zuerst einen Kunden anlegen.',
		'domainalreadyexists' => 'Die Domain "%s" wurde bereits einem Kunden zugeordnet.',
		'nolanguageselect' => 'Es wurde keine Sprache ausgewählt.',
		'nosubjectcreate' => 'Sie müssen einen Betreff angeben.',
		'nomailbodycreate' => 'Sie müssen einen E-Mail-Text eingeben.',
		'templatenotfound' => 'Vorlage wurde nicht gefunden.',
		'alltemplatesdefined' => 'Sie können keine weiteren Vorlagen anlegen, da bereits für alle Sprachen eine Vorlage existiert.',
		'wwwnotallowed' => 'Ihre Subdomain darf nicht \'www\' heißen.',
		'subdomainiswrong' => 'Die Subdomain "%s" enthält ungültige Zeichen.',
		'domaincantbeempty' => 'Der Domainname darf nicht leer sein.',
		'domainexistalready' => 'Die Domain "%s" existiert bereits.',
		'domainisaliasorothercustomer' => 'Die ausgewählte Aliasdomain ist entweder selbst eine Aliasdomain, hat nicht die gleiche IP/Port-Kombination oder gehört einem anderen Kunden.',
		'emailexistalready' => 'Die E-Mail-Adresse "%s" existiert bereits.',
		'maindomainnonexist' => 'Die Hauptdomain "%s" existiert nicht.',
		'maindomaindeactivated' => 'Die Hauptdomain "%s" ist deaktiviert.',
		'destinationnonexist' => 'Bitte geben Sie Ihre Weiterleitungsadresse im Feld \'Nach\' ein.',
		'destinationalreadyexistasmail' => 'Die Weiterleitung zu "%s" existiert bereits als aktive E-Mail-Adresse.',
		'destinationalreadyexist' => 'Es existiert bereits eine Weiterleitung nach "%s".',
		'destinationiswrong' => 'Die Weiterleitungsadresse "%s" enthält ungültige Zeichen oder ist nicht vollständig.',
		'dumpfoldercannotbedocroot' => 'Der Ordner für Daten-Export darf nicht das Heimatverzeichnis sein, wählen Sie einen Ordner unterhalb des Heimatverzeichnisses, z.B. /dumps',
		'templatelanguagecombodefined' => 'Die gewählte Kombination aus Sprache und Vorlage ist bereits definiert.',
		'templatelanguageinvalid' => 'Die gewählte Sprache existiert nicht',
		'ipstillhasdomains' => 'Die IP/Port-Kombination, die Sie löschen wollen, ist noch bei einer oder mehreren Domains eingetragen. Bitte ändern Sie die Domains vorher auf eine andere IP/Port-Kombination, um diese löschen zu können.',
		'cantdeletedefaultip' => 'Sie können die Standard-IP/Port-Kombination für Reseller nicht löschen. Bitte setzen Sie eine andere IP/Port-Kombination als Standard, um diese löschen zu können.',
		'cantdeletesystemip' => 'Sie können die letzte System-IP-Adresse nicht löschen. Entweder legen Sie eine neue IP/Port-Kombination an oder Sie ändern die System-IP-Adresse.',
		'myipaddress' => '\'IP-Adresse\'',
		'myport' => '\'Port\'',
		'myipdefault' => 'Sie müssen eine IP/Port-Kombination auswählen, die den Standard definieren soll.',
		'myipnotdouble' => 'Diese Kombination aus IP-Adresse und Port existiert bereits.',
		'cantchangesystemip' => 'Sie können die letzte System-IP-Adresse nicht löschen. Entweder legen Sie eine neue IP/Port-Kombination an oder Sie ändern die System-IP-Adresse.',
		'sessiontimeoutiswrong' => '"Session-Timeout" muss ein numerischer Wert sein.',
		'maxloginattemptsiswrong' => '"Maximale Loginversuche" muss ein numerischer Wert sein.',
		'deactivatetimiswrong' => '"Länge der Deaktivierung" muss numerisch sein.',
		'accountprefixiswrong' => 'Das "Kundenpräfix" ist falsch.',
		'mysqlprefixiswrong' => 'Das "MySQL-Präfix" ist falsch.',
		'ftpprefixiswrong' => 'Das "FTP-Präfix" ist falsch.',
		'ipiswrong' => 'Die "IP-Adresse" ist falsch. Bitte geben Sie eine gültige IP-Adresse an.',
		'vmailuidiswrong' => 'Die "Mail-UID" ist falsch. Es ist nur eine numerische UID erlaubt.',
		'vmailgidiswrong' => 'Die "Mail-GID" ist falsch. Es ist nur eine numerische GID erlaubt.',
		'adminmailiswrong' => 'Die "Absenderadresse" ist fehlerhaft. Bitte geben Sie eine gültige E-Mail-Adresse an.',
		'pagingiswrong' => 'Die "Einträge pro Seite"-Einstellung ist falsch. Es sind nur numerische Zeichen erlaubt.',
		'phpmyadminiswrong' => 'Die "phpMyAdmin-URL" ist keine gültige URL.',
		'webmailiswrong' => 'Die "Webmail-URL" ist keine gültige URL.',
		'webftpiswrong' => 'Die "WebFTP-URL" ist keine gültige URL.',
		'stringformaterror' => 'Der Wert des Feldes "%s" hat nicht das erwartete Format.',
		'loginnameisusingprefix' => 'Sie können keinen Account anlegen, der mit "%s" beginnt, da dieser Prefix für die automatische Namensvergabe eingestellt ist. Bitte wählen Sie einen anderen Accountnamen.',
		'loginnameissystemaccount' => 'Der Account "%s" existiert bereits auf dem System und kann daher nicht verwendet werden. Bitte wählen Sie einen anderen Accountnamen.',
		'loginnameisreservedname' => 'Der Account-Name "%s" ist systemseitig reserviert und kann nicht verwenden werden.',
		'youcantdeleteyourself' => 'Aus Sicherheitsgründen können Sie sich nicht selbst löschen.',
		'youcanteditallfieldsofyourself' => 'Hinweis: Aus Sicherheitsgründen können Sie nicht alle Felder Ihres eigenen Accounts bearbeiten.',
		'documentrootexists' => 'Es existiert noch ein Verzeichnis "%s" für diesen Kunden. Bitte löschen Sie dieses vorher.',
		'norepymailiswrong' => 'Die "Noreply-Adresse" ist ungültig. Nur eine valide E-Mail Adresse kann akzeptiert werden.',
		'logerror' => 'Log-Fehler: "%s"',
		'nomessagetosend' => 'Keine Nachricht angegeben',
		'norecipientsgiven' => 'Keine Empfänger angegeben',
		'errorsendingmail' => 'Das Versenden der Nachricht an "%s" schlug fehl.',
		'errorsendingmailpub' => 'Das Versenden der Nachricht an die angegebene E-Mail Adresse schlug fehl.',
		'cannotreaddir' => 'Der Ordner "%s" kann nicht gelesen werden',
		'invalidip' => 'Ungültige IP-Adresse: "%s"',
		'invalidmysqlhost' => 'Ungültige MySQL-Host-Adresse: "%s"',
		'cannotuseawstatsandwebalizeratonetime' => 'Webalizer und AWstats können nicht zur gleichen Zeit aktiviert werden, bitte wählen Sie eines aus.',
		'cannotwritetologfile' => 'Logdatei "%s" konnte nicht für Schreiboperationen geöffnet werden.',
		'vmailquotawrong' => 'Die Kontingent-Größe muss positiv sein.',
		'allocatetoomuchquota' => 'Sie versuchen "%s" MB Kontingent zu zuweisen, haben aber nicht genug übrig.',
		'missingfields' => 'Es wurden nicht alle Felder augefüllt.',
		'requiredfield' => 'Dieses Feld ist ein Pflichtfeld.',
		'accountnotexisting' => 'Der angegebene E-Mail-Account existiert nicht.',
		'nopermissionsorinvalidid' => 'Entweder fehlen Ihnen die nötigen Rechte diese Einstellung zu ändern oder es wurde eine ungültige ID übergeben',
		'phpsettingidwrong' => 'Eine PHP-Konfiguration mit dieser ID existiert nicht',
		'descriptioninvalid' => 'Der Beschreibungstext ist zu kurz, zu lang oder enthält ungültige Zeichen',
		'info' => 'Info',
		'filecontentnotset' => 'Diese Datei darf nicht leer sein!',
		'customerdoesntexist' => 'Der ausgewählte Kunde existiert nicht.',
		'admindoesntexist' => 'Der ausgewählte Admin existiert nicht.',
		'ipportdoesntexist' => 'Die gewählte IP/Port-Kombination existiert nicht.',
		'hiddenfieldvaluechanged' => 'Der Wert des verborgenen Feldes "%s" hat sich während dem Ändern der Einstellungen geändert.<br /><br />Dies ist im Grunde kein schwerwiegendes Problem, allerdings konnten so die Einstellungen nicht gespeichert werden.',
		'notrequiredpasswordlength' => 'Das Passwort ist zu kurz. Bitte geben Sie mindestens "%s" Zeichen an.',
		'overviewsettingoptionisnotavalidfield' => 'Hoppla, ein Feld, das als Option in der Konfigurationsübersicht angezeigt werden soll, hat nicht den erwarteten Wert. Sie können den Entwicklern die Schuld geben. Dies sollte nicht passieren!',
		'usernamealreadyexists' => 'Der Benutzername "%s" existiert bereits.',
		'plausibilitychecknotunderstood' => 'Die Antwort des Plausibilitätschecks wurde nicht verstanden',
		'errorwhensaving' => 'Bei dem Speichern des Feldes "%s" trat ein Fehler auf',
		'pathmaynotcontaincolon' => 'Der eingegebene Pfad sollte keinen Doppelpunkt (":") enthalten. Bitte geben Sie einen korrekten Wert für den Pfad ein.',
		'invaliddocumentrooturl' => 'Die URL, die Sie für den Pfad eingegeben haben, ist ungültig. Bitte geben Sie eine korrekte URL oder einen Unix-Pfad ein.',
		'notrequiredpasswordcomplexity' => 'Die vorgegebene Passwort-Komplexität wurde nicht erfüllt.<br />Bitte kontaktieren Sie Ihren Administrator, wenn Sie Fragen zur Komplexitäts-Vorgabe haben.',
		'stringerrordocumentnotvalidforlighty' => 'Ein Text als Fehlerdokument funktioniert leider in LigHTTPd nicht, bitte geben Sie einen Pfad zu einer Datei an',
		'urlerrordocumentnotvalidforlighty' => 'Eine URL als Fehlerdokument funktioniert leider in LigHTTPd nicht, bitte geben Sie einen Pfad zu einer Datei an',
		'invaliderrordocumentvalue' => 'Der angegebene Wert für das Fehlederdokument ist keine gültige Datei, URL oder Text-Zeile.',
		'intvaluetoolow' => 'Die angegebene Zahl ist zu klein (Feld "%s")',
		'intvaluetoohigh' => 'Die angegebene Zahl ist zu groß (Feld "%s")',
		'phpfpmstillenabled' => 'PHP-FPM ist derzeit aktiviert. Bitte deaktivieren Sie es, um FCGID zu aktivieren',
		'fcgidstillenabled' => 'FCGID ist derzeit aktiviert. Bitte deaktivieren Sie es, um PHP-FPM zu aktivieren',
		'domains_cantdeletedomainwithaliases' => 'Sie können keine Domain löschen, die noch von Alias-Domains verwendet wird. Löschen Sie zuerst alle Alias-Domains dieser Domain.',
		'user_banned' => 'Ihr Benutzerkonto wurde gesperrt. Bitte kontaktieren Sie Ihren Administrator für weitere Informationen.',
		'admin_domain_emailsystemhostname' => 'Der System-Hostname kann nicht als Kundendomain verwendet werden.',
		'session_timeout' => 'Wert zu niedrig',
		'session_timeout_desc' => 'Der Wert der Session-Timeout sollte nicht unter einer Minute liegen.',
		'invalidhostname' => 'Hostname muss eine gültige Domain sein. Er darf weder leer sein noch nur aus Leerzeichen bestehen',
		'operationnotpermitted' => 'Diese Aktion ist nicht erlaubt!',
		'featureisdisabled' => 'Die Funktion "%s" wurde deaktiviert. Kontaktieren Sie bitte Ihren Dienstleister.',
		'usercurrentlydeactivated' => 'Der Benutzer "%s" ist derzeit deaktiviert',
		'setlessthanalreadyused' => 'Es können nicht weniger Resourcen von "%s" gesetzt werden, als der Benutzer bereits vergeben hat<br />',
		'stringmustntbeempty' => 'Der Wert für das Feld "%s" darf nicht leer sein',
		'sslcertificateismissingprivatekey' => 'Für das Zertifikat muss eine Key-Datei (Private-Key) angegeben werden.',
		'sslcertificatewrongdomain' => 'Das angegebene Zertifikat gilt nicht für die gewählte Domain.',
		'sslcertificateinvalidcert' => 'Der angegebene Zertifikatsinhalt scheint kein gültiges Zertifikat zu sein.',
		'sslcertificateinvalidcertkeypair' => 'Der angegebene Key (Private-Key) gehört nicht zum angegebenen Zertifikat.',
		'sslcertificateinvalidca' => 'Das angegebene CA-Zertifikat scheint nicht gültig zu sein.',
		'sslcertificateinvalidchain' => 'Das angegebene CertificateChainFile scheint nicht gültig zu sein.',
		'givendirnotallowed' => 'Das angegebene Verzeichnis im Feld %s ist nicht erlaubt.',
		'sslredirectonlypossiblewithsslipport' => 'Die Nutzung von Let\'s Encrypt ist nur möglich, wenn die Domain mindestens eine IP/Port - Kombination mit aktiviertem SSL zugewiesen hat.',
		'fcgidstillenableddeadlock' => 'FCGID ist derzeit aktiviert.<br />Bitte deaktiviere es, um einen anderen Webserver als Apache2 oder lighttpd auswählen zu können.',
		'send_report_title' => 'Fehler melden',
		'send_report_desc' => 'Danke, dass Sie uns diesen Fehler melden und damit helfen Froxlor zu verbessern.<br />Folgender Bericht wird per Mail an das Froxlor Entwickler Team gesendet.',
		'send_report' => 'Fehlerbericht senden',
		'send_report_error' => 'Fehler beim Senden des Berichts: <br />%s',
		'notallowedtouseaccounts' => 'Ihrem Konto ist die Nutzung von IMAP/POP3 nicht erlaubt, daher können keine E-Mail-Konten angelegt werden',
		'cannotdeletehostnamephpconfig' => 'Diese PHP-Konfiguration ist dem Froxlor-Vhost zugewiesen und kann daher nicht gelöscht werden.',
		'cannotdeletedefaultphpconfig' => 'Diese PHP-Konfiguration ist als Standard hinterlegt und kann daher nicht gelöscht werden.',
		'passwordshouldnotbeusername' => 'Das Passwort sollte nicht mit dem Benutzernamen übereinstimmen.',
		'no_phpinfo' => 'Entschuldigung, es ist nicht möglich die phpinfo() auszulesen.',
		'moveofcustomerfailed' => 'Das Verschieben des Kunden ist fehlgeschlagen. Alle übrigen Änderungen wurden durchgeführt und gespeichert.<br><br>Fehlermeldung: %s',
		'domain_import_error' => 'Der folgende Fehler trat beim Importieren der Domains auf: %s',
		'fcgidandphpfpmnogoodtogether' => 'FCGID und PHP-FPM können nicht gleichzeitig aktiviert werden.',
		'no_apcuinfo' => 'Keine APCu Cache Informationen verfügbar. APCu scheint nicht installiert zu sein.',
		'no_opcacheinfo' => 'Keine OPCache Informationen verfügbar. OPCache scheint nicht installiert zu sein.',
		'inactive_opcacheinfo' => 'OPCache ist installiert, aber nicht aktiviert.',
		'nowildcardwithletsencrypt' => 'Let\'s Encrypt kann mittels ACME Wildcard-Domains nur via DNS validieren, sorry. Bitte den ServerAlias auf WWW setzen oder deaktivieren',
		'customized_version' => 'Es scheint als wäre die Froxlor Installation angepasst worden. Kein Support, sorry.',
		'autoupdate_0' => 'Unbekannter Fehler',
		'autoupdate_1' => 'PHP Einstellung allow_url_fopen ist deaktiviert. Autoupdate benötigt diese Option, bitte in der php.ini aktivieren.',
		'autoupdate_2' => 'PHP zip Erweiterung nicht gefunden, bitte prüfen, ob diese installiert und aktiviert ist.',
		'autoupdate_4' => 'Das froxlor Archiv konnte nicht auf der Festplatte gespeichert werden :(',
		'autoupdate_5' => 'version.froxlor.org gab ungültige Werte zurück :(',
		'autoupdate_6' => 'Woops, keine (gültige) Version angegeben für den Download :(',
		'autoupdate_7' => 'Das heruntergeladene Archiv konnte nicht gefunden werden :(',
		'autoupdate_8' => 'Das Archiv konnte nicht entpackt werden :(',
		'autoupdate_9' => 'Die heruntergeladene Datei konnte nicht verifiziert werden. Bitte erneut versuchen zu aktualisieren.',
		'autoupdate_10' => 'Minimum unterstützte Version von PHP ist 7.4.0',
		'autoupdate_11' => 'Webupdate ist deaktiviert',
		'mailaccistobedeleted' => 'Ein vorheriges Konto mit dem gleichen Namen (%s) wird aktuell noch gelöscht und kann daher derzeit nicht angelegt werden',
		'customerhasongoingexportjob' => 'Es gibt noch einen austehenden Daten-Export. Bitte haben Sie etwas Geduld.',
		'exportfunctionnotenabled' => 'Die Datenexport-Funktion is nicht aktiviert',
		'dns_domain_nodns' => 'DNS ist für diese Domain nicht aktiviert',
		'dns_content_empty' => 'Keinen Inhalt angegeben',
		'dns_content_invalid' => 'DNS Eintrag ungültig',
		'dns_arec_noipv4' => 'Keine gültige IP-Adresse für A-Eintrag angegeben',
		'dns_aaaarec_noipv6' => 'Keine gültige IP-Adresse für AAAA-Eintrag angegeben',
		'dns_mx_prioempty' => 'Ungültige MX Priorität angegeben',
		'dns_mx_needdom' => 'Der Wert des MX Eintrags muss ein gültiger Domainname sein',
		'dns_mx_noalias' => 'Der MX Eintrag darf kein CNAME Eintrag sein.',
		'dns_cname_invaliddom' => 'Ungültiger Domain-Name für CNAME Eintrag',
		'dns_cname_nomorerr' => 'Es existiert bereits ein Eintrag mit dem gleichen Namen. Dieser Eintrag kann daher nicht für CNAME genutzt werden.',
		'dns_other_nomorerr' => 'Es existiert bereits ein CNAME Eintrag mit dem gleichen Namen. Dieser Eintrag kann daher nicht für einen anderen genutzt werden.',
		'dns_ns_invaliddom' => 'Ungültiger Domain-Name für NS Eintrag',
		'dns_srv_prioempty' => 'Ungültige SRV Priorität angegeben',
		'dns_srv_invalidcontent' => 'Ungültiger Wert des SRV Eintrags, dieser muss aus den Feldern weight, port und target, bestehen. Bsp.: 5 5060 sipserver.example.com.',
		'dns_srv_needdom' => 'Der Wert des SRV Eintrags muss ein gültiger Domainname sein',
		'dns_srv_noalias' => 'Der SRV Eintrag darf kein CNAME Eintrag sein.',
		'dns_duplicate_entry' => 'Eintrag existiert bereits',
		'dns_notfoundorallowed' => 'Domain nicht gefunden oder keine Berechtigung',
		'domain_nopunycode' => 'Die Eingabe von Punycode (IDNA) ist nicht notwendig. Die Domain wird automatisch konvertiert.',
		'domain_noipaddress' => 'Eine IP-Adresse kann nicht als Domain angelegt werden',
		'dns_record_toolong' => 'Records/Labels können maximal 63 Zeichen lang sein',
		'noipportgiven' => 'Keine IP/Port angegeben',
		'nosslippportgiven' => 'Wenn SSL aktiviert ist, muss eine SSL IP/Port angegeben werden',
		'jsonextensionnotfound' => 'Diese Funktion benötigt die PHP json-Erweiterung.',
		'cannotdeletesuperadmin' => 'Der erste Administrator kann nicht gelöscht werden.',
		'no_wwwcnamae_ifwwwalias' => 'Es kann kein CNAME Eintrag für "www" angelegt werden, da die Domain einen www-Alias aktiviert hat. Ändere diese Einstellung auf "Kein Alias" oder "Wildcard Alias"',
		'local_group_exists' => 'Die angegebene Gruppe existiert bereits auf dem System',
		'local_group_invalid' => 'Der angegebene Gruppen-Name ist nicht gültig',
		'local_user_invalid' => 'Der angegebene Benutzer-Name ist nicht gültig oder existiert nicht',
		'local_user_isfroxloruser' => 'Der angegebene Benutzer-Name ist ein von froxlor verwalteter Benutzer und kann in diesem Kontext nicht verwendet werden.',
		'invaliddnsforletsencrypt' => 'Die DNS-Einträge der Domain enthalten keine der gewählten IP Adressen. Let\'s Encrypt Zertifikats-Erstellung ist nicht möglich.',
		'notallowedphpconfigused' => 'Nutzung einer PHP-Konfiguration welche nicht dem Kunden zugeordnet ist',
		'pathmustberelative' => 'Der Benutzer hat nicht die benötigten Berechtigungen, um Pfade außerhalb des Kunden-Heimatverzeichnisses anzugeben. Bitte einen relativen Pfad angeben (kein führendes /).',
		'mysqlserverstillhasdbs' => 'Datenbank-Server kann für den Kunden nicht entfernt werden, da sich dort noch Datenbanken befinden.',
		'domaincannotbeedited' => 'Keine Berechtigung, um die Domain %s zu bearbeiten',
		'invalidcronjobintervalvalue' => 'Cronjob Intervall muss einer der folgenden Werte sein: %s',
		'phpgdextensionnotavailable' => 'Die PHP GD Extension ist nicht verfügbar. Bild-Daten können nicht validiert werden.',
		'2fa_wrongcode' => 'Der angegebene Code ist nicht korrekt',
		'gnupgextensionnotavailable' => 'Die PHP GnuPG Extension ist nicht verfügbar. PGP Schlüssel können nicht validiert werden.',
		'invalidpgppublickey' => 'Der angegebene PGP Public Key ist ungültig',
		'invalid_validtime' => 'Wert der valid_time in Sekunden muss zwischen 10 und 120 liegen.',
		'customerphpenabledbutnoconfig' => 'Kunde hat PHP aktiviert aber keine PHP-Konfiguration wurde gewählt.',
		'emaildomainstillhasaddresses' => 'Maildomain-Flag kann nicht deaktiviert werden, da für diese Domain noch E-Mail-Adressen vorhanden sind.',
	],
	'extras' => [
		'description' => 'Hier können Sie zusätzliche Extras einrichten, wie zum Beispiel einen Verzeichnisschutz.<br />Die Änderungen sind erst nach einer kurzen Zeit wirksam.',
		'directoryprotection_add' => 'Verzeichnisschutz anlegen',
		'view_directory' => 'Verzeichnis anzeigen',
		'pathoptions_add' => 'Pfadoptionen hinzufügen',
		'directory_browsing' => 'Verzeichnisinhalt anzeigen',
		'pathoptions_edit' => 'Pfadoptionen bearbeiten',
		'error404path' => '404',
		'error403path' => '403',
		'error500path' => '500',
		'error401path' => '401',
		'errordocument404path' => 'Fehlerdokument 404',
		'errordocument403path' => 'Fehlerdokument 403',
		'errordocument500path' => 'Fehlerdokument 500',
		'errordocument401path' => 'Fehlerdokument 401',
		'execute_perl' => 'Perl/CGI ausführen',
		'htpasswdauthname' => 'Grund der Authentifizierung (AuthName)',
		'directoryprotection_edit' => 'Verzeichnisschutz bearbeiten',
		'export' => 'Datenexport erstellen',
		'dump_web' => 'Web-Daten hinzufügen',
		'dump_mail' => 'E-Mail Daten hinzufügen',
		'dump_dbs' => 'Datenbanken hinzufügen',
		'path_protection_label' => '<strong class="text-danger">Wichtig</strong>',
		'path_protection_info' => 'Wir raten dringend dazu den angegebenen Pfad zu schützen, siehe "Extras" -> "Verzeichnisschutz"',
	],
	'ftp' => [
		'description' => 'Hier können Sie zusätzliche FTP-Konten einrichten.<br />Die Änderungen sind sofort wirksam und die FTP-Konten sofort benutzbar.',
		'account_add' => 'Benutzerkonto anlegen',
		'account_edit' => 'FTP-Konto bearbeiten',
		'editpassdescription' => 'Neues Passwort setzen oder leer für keine Änderung.',
	],
	'gender' => [
		'title' => 'Anrede',
		'male' => 'Herr',
		'female' => 'Frau',
		'undef' => '',
	],
	'imprint' => 'Impressum',
	'index' => [
		'customerdetails' => 'Kundendaten',
		'accountdetails' => 'Kontodaten',
	],
	'integrity_check' => [
		'databaseCharset' => 'Characterset der Datenbank (sollte UTF-8 sein)',
		'domainIpTable' => 'IP &lt;&dash;&gt; Domain Verkn&uuml;pfung',
		'subdomainSslRedirect' => 'Falsches SSL-redirect Flag bei nicht-SSL Domains',
		'froxlorLocalGroupMemberForFcgidPhpFpm' => 'froxlor-Benutzer in Kunden-Gruppen (f&uuml;r FCGID/php-fpm)',
		'webserverGroupMemberForFcgidPhpFpm' => 'Webserver-Benutzer in Kunden-Gruppen (f&uuml;r FCGID/php-fpm)',
		'subdomainLetsencrypt' => 'Hauptdomains ohne zugewiesenen SSL-Port haben keine Subdomain mit aktiviertem SSL-Redirect',
	],
	'logger' => [
		'date' => 'Datum',
		'type' => 'Typ',
		'action' => 'Aktion',
		'user' => 'Benutzer',
		'truncate' => 'Log leeren',
		'reseller' => 'Reseller',
		'admin' => 'Administrator',
		'cron' => 'Cronjob',
		'login' => 'Login',
		'intern' => 'Intern',
		'unknown' => 'Unbekannt',
	],
	'login' => [
		'username' => 'Benutzername',
		'password' => 'Passwort',
		'language' => 'Sprache',
		'login' => 'Anmelden',
		'logout' => 'Abmelden',
		'profile_lng' => 'Profilsprache',
		'welcomemsg' => 'Bitte melden Sie sich an, um auf Ihr Konto zuzugreifen.',
		'forgotpwd' => 'Passwort vergessen?',
		'presend' => 'Passwort zurücksetzen',
		'email' => 'E-Mail-Adresse',
		'remind' => 'Passwort zurücksetzen',
		'usernotfound' => 'Fehler: Unbekannter Benutzer!',
		'backtologin' => 'Zurück zum Login',
		'combination_not_found' => 'Kombination aus Benutzername und E-Mail Adresse stimmen nicht überein.',
		'2fa' => 'Zwei-Faktor Authentifizierung (2FA)',
		'2facode' => 'Bitte 2FA Code angeben',
		'2faremember' => 'Browser vertrauen',
	],
	'mails' => [
		'pop_success' => [
			'mailbody' => 'Hallo,\\n\\nIhr E-Mail-Konto {USERNAME}\\nwurde erfolgreich eingerichtet.\\n\\nDies ist eine automatisch generierte\\nE-Mail, bitte antworten Sie nicht auf\\ndiese Mitteilung.\\n\\nIhr Administrator',
			'subject' => 'E-Mail-Konto erfolgreich eingerichtet',
		],
		'createcustomer' => [
			'mailbody' => 'Hallo {SALUTATION},\\n\\nhier Ihre Accountinformationen:\\n\\nBenutzername: {USERNAME}\\nPasswort: {PASSWORD}\\n\\nVielen Dank,\\nIhr Administrator',
			'subject' => 'Kontoinformationen',
		],
		'pop_success_alternative' => [
			'mailbody' => 'Hallo {SALUTATION},\\n\\nihr E-Mail-Konto {USERNAME}\\nwurde erfolgreich eingerichtet.\\nIhr Passwort lautet {PASSWORD}.\\n\\nDies ist eine automatisch generierte\\neMail, bitte antworten Sie nicht auf\\ndiese Mitteilung.\\n\\nIhr Administrator',
			'subject' => 'E-Mail-Konto erfolgreich eingerichtet',
		],
		'password_reset' => [
			'subject' => 'Passwort zurückgesetzt',
			'mailbody' => 'Hallo {SALUTATION},\\n\\nhiermit erhalten Sie den Link, um ein neues Passwort zu setzen. Dieser Link ist für die nächsten 24 Stunden gültig.\\n\\n{LINK}\\n\\nVielen Dank,\\nIhr Administrator',
		],
		'new_database_by_customer' => [
			'subject' => '[Froxlor] Neue Datenbank erstellt',
			'mailbody' => 'Hallo {CUST_NAME},

du hast gerade eine neue Datenbank angelegt. Hier die angegebenen Informationen:

Datenbankname: {DB_NAME}
Passwort: {DB_PASS}
Beschreibung: {DB_DESC}
Datenbank-Server: {DB_SRV}
phpMyAdmin: {PMA_URI}
Vielen Dank, Ihr Administrator',
		],
		'new_ftpaccount_by_customer' => [
			'subject' => 'Neuer FTP-Benutzer erstellt',
			'mailbody' => 'Hallo {CUST_NAME},

du hast gerade einen neuen FTP-Benutzer angelegt. Hier die angegebenen Informationen:

Benutzername: {USR_NAME}
Passwort: {USR_PASS}
Pfad: {USR_PATH}

Vielen Dank, Ihr Administrator',
		],
		'trafficmaxpercent' => [
			'mailbody' => 'Hallo {SALUTATION},\\n\\nSie haben bereits {TRAFFICUSED} von Ihren insgesamt {TRAFFIC} Traffic verbraucht.\\nDies sind mehr als {MAX_PERCENT}%%.\\n\\nVielen Dank,\\nIhr Administrator',
			'subject' => 'Sie erreichen bald Ihr Traffic-Limit',
		],
		'diskmaxpercent' => [
			'mailbody' => 'Hallo {SALUTATION},\\n\\nSie haben bereits {DISKUSED} von Ihren insgesamt {DISKAVAILABLE} Speicherplatz verbraucht.\\nDies sind mehr als {MAX_PERCENT}%%.\\n\\nVielen Dank,\\nIhr Administrator',
			'subject' => 'Sie erreichen bald Ihr Speicherplatz-Limit',
		],
		'2fa' => [
			'mailbody' => 'Hallo,\\n\\nihr 2FA-Login Code lautet: {CODE}\\n\\nDies ist eine automatisch generierte\\neMail, bitte antworten Sie nicht auf\\ndiese Mitteilung.\\n\\nIhr Administrator',
			'subject' => 'Froxlor - 2FA Code',
		],
	],
	'menue' => [
		'main' => [
			'main' => 'Allgemein',
			'changepassword' => 'Passwort ändern',
			'changelanguage' => 'Sprache ändern',
			'username' => 'Angemeldet als ',
			'changetheme' => 'Theme wechseln',
			'apihelp' => 'API Hilfe',
			'apikeys' => 'API Keys',
		],
		'email' => [
			'email' => 'E-Mail',
			'emails' => 'Adressen',
			'webmail' => 'Webmail',
			'emailsoverview' => 'E-Mail Domain Übersicht',
		],
		'mysql' => [
			'mysql' => 'MySQL',
			'databases' => 'Datenbanken',
			'phpmyadmin' => 'phpMyAdmin',
		],
		'domains' => [
			'domains' => 'Domains',
			'settings' => 'Übersicht Domains',
		],
		'ftp' => [
			'ftp' => 'FTP',
			'accounts' => 'Benutzerkonten',
			'webftp' => 'WebFTP',
		],
		'extras' => [
			'extras' => 'Extras',
			'directoryprotection' => 'Verzeichnisschutz',
			'pathoptions' => 'Pfadoptionen',
			'export' => 'Datenexport',
		],
		'traffic' => [
			'traffic' => 'Traffic',
			'current' => 'Aktueller Monat',
			'overview' => 'Übersicht',
		],
		'phpsettings' => [
			'maintitle' => 'PHP-Konfigurationen',
			'fpmdaemons' => 'PHP-FPM Versionen',
		],
		'logger' => [
			'logger' => 'System-Log',
		],
	],
	'message' => [
		'norecipients' => 'Es wurde keine E-Mail versendet, da sich keine Empfänger in der Datenbank befinden',
		'success' => 'Nachricht erfolgreich an "%s" Empfänger gesendet',
	],
	'mysql' => [
		'databasename' => 'Benutzer-/Datenbankname',
		'databasedescription' => 'Datenbankbeschreibung',
		'database_create' => 'Datenbank anlegen',
		'description' => 'Hier können Sie MySQL-Datenbanken anlegen und löschen.<br />Die Änderungen werden sofort wirksam und die Datenbanken sind sofort benutzbar.<br />Im Menü finden Sie einen Link zu phpMyAdmin, mit dem Sie Ihre Datenbankinhalte komfortabel bearbeiten können.<br /><br />Die Zugangsdaten sind wie folgt: (Die Angaben in <i>kursiver</i> Schrift sind durch die jeweiligen Einträge zu ersetzen)<br />Hostname: <b><SQL_HOST></b><br />Benutzername: <b><i>Datenbankname</i></b><br />Passwort: <b><i>das gewählte Passwort</i></b><br />Datenbank: <b><i>Datenbankname</i></b>',
		'mysql_server' => 'MySQL-Server',
		'database_edit' => 'Datenbank bearbeiten',
		'size' => 'Datenbankgröße',
		'privileged_user' => 'Privilegierter Datenbankbenutzer',
		'privileged_passwd' => 'Passwort für privilegierten Benutzer',
		'unprivileged_passwd' => 'Passwort für nicht privilegierten Benutzer',
		'mysql_ssl_ca_file' => 'SSL-Serverzertifikat',
		'mysql_ssl_verify_server_certificate' => 'Verifizieren des SSL-Serverzertifikats',
		'globaluserinfo' => 'Um auf Datenbanken zuzugreifen, kann zusätzlich der Froxlor-Login (Benutzer: %s) verwendet werden, dieser hat automatisch Zugriff auf alle Datenbanken.<br />Es wird empfohlen diesen <b>nicht</b> für Applikationen zu nutzen, lediglich zur Administration (z.B. via phpMyAdmin).',
		'edit_global_user' => 'Admin Benutzer bearbeiten',
	],
	'panel' => [
		'edit' => 'bearbeiten',
		'delete' => 'löschen',
		'create' => 'anlegen',
		'save' => 'Speichern',
		'yes' => 'Ja',
		'no' => 'Nein',
		'emptyfornochanges' => 'leer für keine Änderung',
		'emptyfordefault' => 'Leer für Standardeinstellung.',
		'path' => 'Pfad',
		'toggle' => 'Umschalten',
		'next' => 'Weiter',
		'dirsmissing' => 'Das angegebene Verzeichnis konnte nicht gefunden werden.',
		'urloverridespath' => 'URL (überschreibt Pfad)',
		'pathorurl' => 'Pfad oder URL',
		'ascending' => 'aufsteigend',
		'descending' => 'absteigend',
		'search' => 'Suche',
		'used' => 'genutzt',
		'translator' => 'Übersetzung',
		'reset' => 'Änderungen verwerfen',
		'pathDescription' => 'Sollte das Verzeichnis nicht existieren, wird es automatisch erstellt.',
		'pathDescriptionEx' => '<br /><br /><span class="text-danger">Bitte beachten:</span> Der Pfad <code>/</code> ist nicht erlaubt aufgrund administrativer Einstellungen, er wird automatisch auf <code>/gewaehlte.subdomain.tld/</code> gesetzt, sofern nicht ein anderer Ordner angegeben wird.',
		'pathDescriptionSubdomain' => 'Sollte das Verzeichnis nicht existieren, wird es automatisch erstellt.<br />Sollte eine Weiterleitung auf eine andere Domain gewünscht sein, muss der Eintrag mit http:// oder https:// beginnen.<br />Endet die URL mit einem / (Slash) geht Froxlor von einem Ordner aus, wenn nicht, wird es wie eine Datei behandelt.',
		'back' => 'Zurück',
		'reseller' => 'Reseller',
		'admin' => 'Administrator',
		'customer' => 'Kunde/n',
		'send' => 'Versenden',
		'nosslipsavailable' => 'Für diesen Server wurden noch keine SSL IP/Port Kombinationen eingetragen',
		'backtooverview' => 'Zurück zur Übersicht',
		'dateformat' => 'TT.MM.JJJJ',
		'dateformat_function' => 'd.m.Y',
		'timeformat_function' => 'H:i:s',
		'default' => 'Standard',
		'never' => 'Nie',
		'active' => 'Aktiv',
		'please_choose' => 'Bitte auswählen',
		'allow_modifications' => 'Änderungen zulassen',
		'megabyte' => 'Megabyte',
		'not_supported' => 'Nicht unterstützt in: ',
		'view' => 'ansehen',
		'toomanydirs' => 'Zu viele Unterverzeichnisse. Weiche auf manuelle Verzeichniseingabe aus.',
		'abort' => 'Abbrechen',
		'not_activated' => 'Nicht aktiviert',
		'off' => 'aus',
		'options' => 'Optionen',
		'neverloggedin' => 'Keine Anmeldung bisher',
		'descriptionerrordocument' => 'Mögliche Werte sind: URL, Pfad zu einer Datei oder ein Text, umgeben von Anführungszeichen (" ").<br />Leer für Server-Standardwert.',
		'unlock' => 'entsperren',
		'theme' => 'Theme',
		'variable' => 'Variable',
		'description' => 'Beschreibung',
		'ssleditor' => 'SSL-Einstellungen für diese Domain',
		'ssleditor_infoshared' => 'Aktuell Zertifikat der Elterndomain genutzt',
		'ssleditor_infoglobal' => 'Aktuell globales Zertifikat genutzt',
		'dashboard' => 'Dashboard',
		'assigned' => 'zugewiesen',
		'available' => 'verfügbar',
		'news' => 'Neuigkeiten',
		'newsfeed_disabled' => 'Das Newsfeed ist deaktiviert. Klicken Sie auf das Editier-Icon, um zu den Einstellungen zu gelangen.',
		'ftpdesc' => 'FTP-Beschreibung',
		'letsencrypt' => 'Benutzt Let\'s encrypt',
		'set' => 'Setzen',
		'exportpath' => [
			'title' => 'Pfad zur Ablage des Exports',
			'description' => 'In diesem Ordner werden die Export-Archive abgelegt. Wenn Web-Daten exportiert werden, werden alle Dateien aus dem Heimatverzeichnis gesichert, exklusive des hier angegebenen Ordners.',
		],
		'export_pgp_public_key' => [
			'title' => 'Öffentlicher PGP-Schlüssel',
			'description' => 'Der öffentliche PGP-Schlüssel, mit dem die Exporte verschlüsselt werden sollen. Wenn kein Schlüssel angegeben ist, werden die Exporte nicht verschlüsselt.',
		],
		'pgp_public_key' => 'Öffentlicher PGP-Schlüssel',
		'none_value' => 'Keine',
		'viewlogs' => 'Logdateien einsehen',
		'not_configured' => 'Das System wurde noch nicht konfiguriert. Klicke auf den Button um die Installation zu starten.',
		'ihave_configured' => 'Ich habe die Dienste konfiguriert',
		'system_is_configured' => '<i class="fa-solid fa-circle-exclamation me-1"></i>Das System ist bereits konfiguriert',
		'settings_before_configuration' => 'Stelle sicher, dass die Einstellungen angepasst wurden bevor die Dienste konfiguriert werden.',
		'image_field_delete' => 'Das momentan vorhandene Bild löschen',
		'usage_statistics' => 'Resourcen-Verbrauch',
		'security_question' => 'Sicherheitsabfrage',
		'listing_empty' => 'Keine Einträge gefunden',
		'unspecified' => 'keine Angabe',
		'settingsmode' => 'Modus',
		'settingsmodebasic' => 'Einfach',
		'settingsmodeadvanced' => 'Erweitert',
		'settingsmodetoggle' => 'Modus umschalten',
		'modalclose' => 'Schließen',
		'managetablecolumnsmodal' => [
			'title' => 'Tabellenspalten verwalten',
			'description' => 'Hier können die angezeigten Tabellenspalten angepasst werden',
		],
		'mandatoryfield' => 'Pflichtfeld',
		'select_all' => 'Alle auswählen',
		'unselect_all' => 'Alle abwählen',
		'searchtablecolumnsmodal' => [
			'title' => 'Feld-Suche',
			'description' => 'Wähle das zu durchsuchende Feld aus'
		],
		'upload_import' => 'Hochladen und importieren',
		'profile' => 'Mein Profil',
		'use_checkbox_for_unlimited' => 'Der Wert "0" deaktiviert die Resource. Die Checkbox rechts erlaubt "unlimitierte" Nutzung.',
		'use_checkbox_to_disable' => 'Zum Deaktivieren, klicke die Checkbox auf der rechten Seite des Eingabefeldes',
	],
	'phpfpm' => [
		'vhost_httpuser' => 'Lokaler Benutzer für PHP-FPM (Froxlor-Vhost)',
		'vhost_httpgroup' => 'Lokale Gruppe für PHP-FPM (Froxlor-Vhost)',
		'ownvhost' => [
			'title' => 'Verwende PHP-FPM im Froxlor-Vhost',
			'description' => 'Wenn verwendet, wird Froxlor selbst unter einem lokalen Benutzer ausgeführt',
		],
		'use_mod_proxy' => [
			'title' => 'Verwende mod_proxy / mod_proxy_fcgi',
			'description' => '<strong class="text-danger">Muss gesetzt sein bei Debian 9.x (Stretch) oder neuer</strong>. Diese Option kann aktiviert werden, um php-fpm via mod_proxy_fcgi einzubinden. Dies setzt mindestens apache-2.4.9 voraus',
		],
		'ini_flags' => 'Mögliche <strong>php_flag</strong>s für die php.ini. Pro Zeile eine Direktive',
		'ini_values' => 'Mögliche <strong>php_value</strong>s für die php.ini. Pro Zeile eine Direktive',
		'ini_admin_flags' => 'Mögliche <strong>php_admin_flag</strong>s für die php.ini. Pro Zeile eine Direktive',
		'ini_admin_values' => 'Mögliche <strong>php_admin_value</strong>s für die php.ini. Pro Zeile eine Direktive',
	],
	'privacy' => 'Datenschutzerklärung',
	'pwdreminder' => [
		'success' => 'Das Zurücksetzen des Passworts wurde erfolgreich angefordert. Sie sollten nun eine E-Mail mit weiteren Anweisungen erhalten.',
		'notallowed' => 'Unbekannter Benutzer oder Zurücksetzen des Passworts ist deaktiviert.',
		'changed' => 'Ihr Passwort wurde erfolgreich geändert. Sie können sich nun damit anmelden.',
		'wrongcode' => 'Der verwendete Aktivierungscode ist entweder nicht gültig oder bereits abgelaufen.',
		'choosenew' => 'Neues Passwort auswählen',
	],
	'question' => [
		'question' => 'Sicherheitsabfrage',
		'admin_customer_reallydelete' => 'Wollen Sie den Kunden "%s" wirklich löschen?<br />ACHTUNG! Alle Daten gehen unwiderruflich verloren! Nach dem Vorgang müssen die Daten manuell aus dem Dateisystem entfernt werden.',
		'admin_domain_reallydelete' => 'Wollen Sie die Domain "%s" wirklich löschen?<br><span class="text-danger"><strong>ACHTUNG:</strong> Alle Subdomains, FTP-Konten und E-Mail Adressen/Konten, welche mit dieser Domain verbunden sind, werden gelöscht!</span>',
		'admin_domain_reallydisablesecuritysetting' => 'Wollen Sie die wichtige Sicherheitseinstellung \'OpenBasedir\' wirklich deaktivieren?',
		'admin_admin_reallydelete' => 'Wollen Sie den Admin "%s" wirklich löschen?<br />Alle Kunden und Domains dieses Admins werden Ihnen zugeteilt.',
		'admin_template_reallydelete' => 'Wollen Sie die Vorlage "%s" wirklich löschen?',
		'domains_reallydelete' => 'Wollen Sie die Domain "%s" wirklich löschen?',
		'email_reallydelete' => 'Wollen Sie die E-Mail-Adresse "%s" wirklich löschen?',
		'email_reallydelete_account' => 'Wollen Sie das Konto von "%s" wirklich löschen?',
		'email_reallydelete_forwarder' => 'Wollen Sie die Weiterleitung "%s" wirklich löschen?',
		'extras_reallydelete' => 'Wollen Sie den Verzeichnisschutz für "%s" wirklich löschen?',
		'extras_reallydelete_pathoptions' => 'Wollen Sie die Optionen für den Pfad "%s" wirklich löschen?',
		'extras_reallydelete_export' => 'Wollen Sie den geplanten Daten-Export wirklich löschen?',
		'ftp_reallydelete' => 'Wollen Sie das FTP-Benutzerkonto "%s" wirklich löschen?',
		'mysql_reallydelete' => 'Wollen Sie die Datenbank "%s" wirklich löschen?<br />ACHTUNG! Alle Daten gehen unwiderruflich verloren!',
		'admin_configs_reallyrebuild' => 'Wollen Sie wirklich alle Konfigurationsdateien neu erstellen lassen?',
		'admin_customer_alsoremovefiles' => 'Kundendaten löschen?',
		'admin_customer_alsoremovemail' => 'E-Mail-Daten auf dem Dateisystem löschen?',
		'admin_customer_alsoremoveftphomedir' => 'Heimatverzeichnis des FTP-Benutzers löschen?',
		'admin_ip_reallydelete' => 'Wollen Sie wirklich die IP-Adresse "%s" löschen?',
		'admin_domain_reallydocrootoutofcustomerroot' => 'Sind Sie sicher, dass der DocumentRoot dieser Domain außerhalb des Heimatverzeichnisses des Kunden liegen soll?',
		'admin_counters_reallyupdate' => 'Wollen Sie den Ressourcenverbrauch neu berechnen?',
		'admin_cleartextmailpws_reallywipe' => 'Wollen Sie wirklich alle unverschlüsselten Passwörter aus der Tabelle mail_users entfernen? Dieser Schritt kann nicht rückgängig gemacht werden! Die Einstellung für das Speichern der E-Mail-Konten-Passwörter in Klartext wird hierbei ebenfalls deaktiviert.',
		'logger_reallytruncate' => 'Wollen Sie die Tabelle "%s" wirklich leeren?',
		'admin_quotas_reallywipe' => 'Sind Sie sicher, dass alle E-Mail-Kontingente aus der Tabelle mail_users entfernt werden sollen? Dieser Schritt kann nicht rückgängig gemacht werden!',
		'admin_quotas_reallyenforce' => 'Sind Sie sicher, dass Sie allen Benutzern das Default-Quota zuweisen wollen? Dies kann nicht rückgängig gemacht werden!',
		'phpsetting_reallydelete' => 'Wollen Sie diese PHP-Einstellungen wirklich löschen? Alle Domains die diese Einstellungen bis jetzt verwendet haben, werden dann auf die Standardeinstellungen umgestellt.',
		'fpmsetting_reallydelete' => 'Wollen Sie diese PHP-FPM Einstellungen wirklich löschen? Alle PHP Konfigurationen die diese Einstellungen bis jetzt verwendet haben, werden dann auf die Standardeinstellungen umgestellt.',
		'customer_reallyunlock' => 'Wollen Sie den Kunden "%s" wirklich entsperren?',
		'admin_integritycheck_reallyfix' => 'M&ouml;chten Sie wirklich versuchen s&auml;mtliche Datenbank-Integrit&auml;tsprobleme automatisch zu beheben?',
		'plan_reallydelete' => 'Wollen Sie den Hostingplan %s wirklich löschen?',
		'apikey_reallydelete' => 'Wollen Sie den Api-Key wirklich löschen?',
		'apikey_reallyadd' => 'Einen neuen Api-Key erstellen?',
		'dnsentry_reallydelete' => 'Wollen Sie den DNS-Eintrag wirklich löschen?',
		'certificate_reallydelete' => 'Wollen Sie diese Zertifikat wirklich löschen?',
		'cache_reallydelete' => 'Wollen Sie den Cache wirklich leeren?',
		'please_enter_otp' => 'Bitte 2FA Code eingeben',
		'admin_mysqlserver_reallydelete' => 'Wollen Sie wirklich diesen MySQL-Server löschen?',
	],
	'serversettings' => [
		'session_timeout' => [
			'title' => 'Session-Timeout',
			'description' => 'Wie lange muss ein Benutzer inaktiv sein, damit die Session ungültig wird? (in Sekunden)',
		],
		'accountprefix' => [
			'title' => 'Kundenpräfix',
			'description' => 'Welchen Präfix sollen die Kundenaccounts haben?',
		],
		'mysqlprefix' => [
			'title' => 'MySQL-Präfix',
			'description' => 'Welchen Präfix sollen die MySQL-Benutzerkonten haben?</br>Mit "RANDOM" als Wert wird ein 3-stelliger Zufallswert als Präfix verwendet.</br>Mit "DBNAME" als Wert wird ein Feld Databankname zusammen mit dem Kundennamen als Präfix genutzt.',
		],
		'ftpprefix' => [
			'title' => 'FTP-Präfix',
			'description' => 'Welchen Präfix sollen die FTP-Benutzerkonten haben?<br/><b>Falls FTP-Quoatas verwendet werden, ist es notwendig das Quota-SQL-Query in der FTP-Server-Config ebenfalls zu ändern!</b>',
		],
		'documentroot_prefix' => [
			'title' => 'Heimatverzeichnis',
			'description' => 'Wo sollen die Heimatverzeichnisse der Kunden liegen?',
		],
		'logfiles_directory' => [
			'title' => 'Webserver-Logdateien-Verzeichnis',
			'description' => 'Wo sollen die Logdateien des Webservers liegen?',
		],
		'logfiles_script' => [
			'title' => 'Eigenes Script zu dem Log-Files übergeben werden',
			'description' => 'Hier kann ein Script an das die Loginhalte übergeben werden hinterlegt und die Platzhalter <strong>{LOGFILE}, {DOMAIN} und {CUSTOMER}</strong> genutzt werden, sofern nötig. Falls ein Script angegeben wird, muss die Option <strong>Webserver Logdateien umleiten</strong> gesetzt werden',
		],
		'logfiles_format' => [
			'title' => 'Access-Log Format',
			'description' => 'Hier kann ein angepasstes Log-format entsprechend der Webserver-Dokumentation angegeben werden, leer lassen für Standard. Abhängig vom LogFormat muss die Angabe unter Anführungszeichen stehen.<br/>Wenn verwendet mit nginx, so kann es wie folgt aussehen: <i>log_format frx_custom {EINGESTELLTES_FORMAT}</i>.<br/>Wenn verwendet mit Apache, so kann es wie folgt aussehen: <i>LogFormat {EINGESTELLTES_FORMAT} frx_custom</i>.<br /><strong>ACHTUNG:</strong> Der Code wird nicht auf Fehler geprüft. Etwaige Fehler werden auch übernommen und der Webserver könnte nicht mehr starten!',
		],
		'logfiles_type' => [
			'title' => 'Access-Log Typ',
			'description' => 'Wähle zwischen <strong>combined</strong> oder <strong>vhost_combined</strong>.',
		],
		'logfiles_piped' => [
			'title' => 'Webserver Logdateien zu eigenem Script umleiten (siehe oben)',
			'description' => 'Wenn ein Script für die Logdateien verwendet wird, muss diese Option aktiviert werden, damit der Webserver die Ausgabe an das Script weitergibt.',
		],
		'ipaddress' => [
			'title' => 'IP-Adresse',
			'description' => 'Welche Haupt-IP-Adresse hat der Server?',
		],
		'hostname' => [
			'title' => 'Hostname',
			'description' => 'Welchen Hostnamen hat der Server?',
		],
		'apachereload_command' => [
			'title' => 'Webserver-Reload-Befehl',
			'description' => 'Wie heißt das Skript zum Neuladen der Webserver-Konfigurationsdateien?',
		],
		'bindenable' => [
			'title' => 'Nameserver aktivieren',
			'description' => 'Hier können Sie den Nameserver global aktivieren bzw. deaktivieren.',
		],
		'bindconf_directory' => [
			'title' => 'DNS-Server Konfigurationsordner',
			'description' => 'Wo liegen die DNS-Server Konfigurationsdateien?',
		],
		'bindreload_command' => [
			'title' => 'DNS-Server Reload-Befehl',
			'description' => 'Wie heißt das Skript zum Neuladen der DNS-Server Konfigurationsdateien?',
		],
		'vmail_uid' => [
			'title' => 'Mail-UID',
			'description' => 'Welche UID sollen die E-Mails haben?',
		],
		'vmail_gid' => [
			'title' => 'Mail-GID',
			'description' => 'Welche GID sollen die E-Mails haben?',
		],
		'vmail_homedir' => [
			'title' => 'Mail-Homedir',
			'description' => 'Wo sollen die E-Mails liegen?',
		],
		'adminmail' => [
			'title' => 'Absenderadresse',
			'description' => 'Wie lautet die Absenderadresse für E-Mails aus dem Panel?',
		],
		'phpmyadmin_url' => [
			'title' => 'phpMyAdmin-URL',
			'description' => 'Wo liegt phpMyAdmin? (muss mit http(s):// beginnen)',
		],
		'webmail_url' => [
			'title' => 'Webmail-URL',
			'description' => 'Wo liegt der Webmail-Client? (muss mit http(s):// beginnen)',
		],
		'webftp_url' => [
			'title' => 'WebFTP-URL',
			'description' => 'Wo liegt der WebFTP-Client? (muss mit http(s):// beginnen)',
		],
		'language' => [
			'description' => 'Welche Sprache ist Ihre Standardsprache?',
		],
		'maxloginattempts' => [
			'title' => 'Maximale Loginversuche',
			'description' => 'Maximale Anzahl an Loginversuchen bis der Account deaktiviert wird.',
		],
		'deactivatetime' => [
			'title' => 'Länge der Deaktivierung',
			'description' => 'Zeitraum (in Sekunden) für den der Account deaktiviert ist.',
		],
		'pathedit' => [
			'title' => 'Pfad-Eingabemethode',
			'description' => 'Soll ein Pfad via Auswahlliste ausgewählt oder manuell eingegeben werden können?',
		],
		'nameservers' => [
			'title' => 'Nameserver',
			'description' => 'Eine durch Komma getrennte Liste mit den Hostnamen aller Nameserver. Der Erste ist der Primäre.',
		],
		'mxservers' => [
			'title' => 'MX-Server',
			'description' => 'Eine durch Komma getrenne Liste, die ein Paar mit einer Nummer und den Hostnamen einen MX-Servers, getrennt durch ein Leerzeichen, enthält (z. B. \'10 mx.example.tld\').',
		],
		'paging' => [
			'title' => 'Einträge pro Seite',
			'description' => 'Wie viele Einträge sollen auf einer Seite angezeigt werden? (0 = Paging deaktivieren)',
		],
		'defaultip' => [
			'title' => 'Standard-IP/Port-Kombination',
			'description' => 'Welche IP/Port-Kombination sollen standardmäßig verwendet werden?',
		],
		'defaultsslip' => [
			'title' => 'Standard SSL IP/Port-Kombination',
			'description' => 'Welche ssl-fähigen IP/Port-Kombination sollen standardmäßig verwendet werden?',
		],
		'phpappendopenbasedir' => [
			'title' => 'Anzuhängende Pfade bei OpenBasedir',
			'description' => 'Diese (durch Doppelpunkte getrennten) Pfade werden dem OpenBasedir-Statement in jedem vHost-Container angehängt.',
		],
		'natsorting' => [
			'title' => 'Natürliche Sortierung in der Listenansicht nutzen',
			'description' => 'Sortiert die Liste in der Reihenfolge web1 -> web2 -> web11 statt web1 -> web11 -> web2.',
		],
		'deactivateddocroot' => [
			'title' => 'Docroot für deaktivierte Benutzer',
			'description' => 'Dieser Pfad wird als Docroot für deaktivierte Benutzer verwendet. Ist das Feld leer, wird kein vHost erstellt.',
		],
		'mailpwcleartext' => [
			'title' => 'Passwörter der Mail-Konten auch im Klartext in der Datenbank speichern',
			'description' => 'Wenn diese Einstellung auf Ja gesetzt wird, werden alle Passwörter auch unverschlüsselt (also im Klartext, für jeden mit Zugriff auf die Froxlor-Datenbank sofort lesbar) in der mail_users-Tabelle gespeichert. Aktivieren Sie diese Option nur dann, wenn Sie SASL nutzen!',
		],
		'ftpdomain' => [
			'title' => 'FTP-Benutzerkonten @domain',
			'description' => 'Können Kunden FTP-Benutzerkonten user@domain anlegen?',
		],
		'mod_fcgid' => [
			'title' => 'PHP über mod_fcgid/suexec einbinden',
			'description' => 'PHP wird unter dem Benutzer des Kunden ausgeführt.<br /><br /><b>Dies benötigt eine spezielle Webserver-Konfiguration für Apache, siehe <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/fcgid/">FCGID-Handbuch</a>.</b>',
			'configdir' => [
				'title' => 'Konfigurations-Verzeichnis',
				'description' => 'Wo sollen alle Konfigurationsdateien von fcgid liegen? Wenn Sie keine selbst kompilierte suexec Binary benutzen, was in der Regel der Fall ist, muss dieser Pfad unter /var/www/ liegen.<br /><br /><div class="text-danger">ACHTUNG: Der Inhalt dieses Ordners wird regelmäßig geleert, daher sollten dort keinerlei Daten manuell abgelegt werden.</div>',
			],
			'tmpdir' => [
				'title' => 'Temporäres Verzeichnis',
				'description' => 'Wo sollen die temporären Verzeichnisse erstellt werden',
			],
			'starter' => [
				'title' => 'Prozesse je Domain',
				'description' => 'Wieviele PHP-Prozesse pro Domain sollen gestartet/erlaubt werden. Der Wert 0 wird empfohlen, da PHP die Anzahl dann selbst effizient verwaltet.',
			],
			'wrapper' => [
				'title' => 'Wrappereinbindung in Vhosts',
				'description' => 'Wie sollen die Wrapper in den Vhosts eingebunden werden',
			],
			'peardir' => [
				'title' => 'Globale PEAR Verzeichnisse',
				'description' => 'Welche globalen PEAR Verzeichnisse sollen in den php.ini-Einstellungen ersetzt werden? Einzelne Verzeichnisse sind mit einem Doppelpunkt zu trennen.',
			],
			'maxrequests' => [
				'title' => 'Maximale Requests pro Domain',
				'description' => 'Wieviele PHP-Requests pro Domain sollen erlaubt werden?',
			],
			'defaultini' => 'Voreingestellte PHP-Konfiguration für neue Domains',
			'defaultini_ownvhost' => 'Voreingestellte PHP-Konfiguration für den Froxlor-Vhost',
			'idle_timeout' => [
				'title' => 'Idle-Timeout',
				'description' => 'Timeout-Einstellung für mod_FastCGI.',
			],
		],
		'sendalternativemail' => [
			'title' => 'Alternative E-Mail-Adresse benutzen',
			'description' => 'Während des Erstellens eines Accounts das Passwort an eine andere E-Mail-Adresse senden',
		],
		'apacheconf_vhost' => [
			'title' => 'Webserver vHost-Konfigurations-Datei/Verzeichnis-Name',
			'description' => 'Wo sollen die vHost-Konfigurationen abgelegt werden? Sie können entweder eine Datei (also mit allen vHosts) oder einen Ordner (mit einer Datei pro vHost) angeben.',
		],
		'apacheconf_diroptions' => [
			'title' => 'Webserver Verzeichnisoption-Konfigurations-Datei/Verzeichnis-Name',
			'description' => 'Wo sollen die Verzeichnisoption-Konfigurationen abgelegt werden? Sie können entweder eine Datei (also mit allen vHosts) oder einen Ordner (mit einer Datei pro vHost) angeben.',
		],
		'apacheconf_htpasswddir' => [
			'title' => 'Webserver htpasswd Verzeichnisname',
			'description' => 'Wo sollen die htpasswd-Dateien für den Verzeichnisschutz abgelegt werden?',
		],
		'mysql_access_host' => [
			'title' => 'MySQL-Access-Hosts',
			'description' => 'Eine durch Komma getrennte Liste mit den Hostnamen aller Hostnames/IP-Adressen, von denen sich die Benutzer einloggen dürfen. Um ein Subnetz zu erlauben ist die Netzmaske oder CIDR Syntax erlaubt.',
		],
		'webalizer_quiet' => [
			'title' => 'Webalizerausgabe',
			'description' => 'Ausgabefreudigkeit des Webalizer-Programms',
		],
		'logger' => [
			'enable' => 'Logging ja/nein',
			'severity' => 'Logging Level',
			'types' => [
				'title' => 'Log-Art(en)',
				'description' => 'Wählen Sie hier die gewünschten Logtypen. Für Mehrfachauswahl, halten Sie während der Auswahl STRG gedrückt<br />Mögliche Logtypen sind: syslog, file, mysql',
			],
			'logfile' => [
				'title' => 'Dateiname der Logdatei',
				'description' => 'Wird nur verwendet, wenn die Log-Art "file" ausgewählt ist. Diese Datei wird unter froxlor/logs/ geschrieben. Dieser Ordner ist vor Webzugriff geschützt.',
			],
			'logcron' => 'Logge Cronjobs',
			'logcronoption' => [
				'never' => 'Nie',
				'once' => 'Einmalig',
				'always' => 'Immer',
			],
		],
		'ssl' => [
			'use_ssl' => [
				'title' => 'Aktiviere SSL',
				'description' => 'Erlaubt die Nutzung von SSL für den Webserver',
			],
			'ssl_cert_file' => [
				'title' => 'Pfad zum SSL-Zertifikat',
				'description' => 'Geben Sie den Pfad inklusive Dateinamen des Zertifikats an (meist .crt or .pem).',
			],
			'openssl_cnf' => 'Standardwerte zum Erstellen eines Zertifikats',
			'ssl_key_file' => [
				'title' => 'Pfad zum SSL Private-Key',
				'description' => 'Geben Sie den Pfad inklusive Dateinamen der Schlüssel-Datei an (der private-key, meist .key).',
			],
			'ssl_ca_file' => [
				'title' => 'Pfad zum SSL-CA-Zertifikat (optional)',
				'description' => 'Client Authentifizierung, dieses Feld sollte nur gesetzt werden, wenn es wirklich gebraucht wird.',
			],
			'ssl_cipher_list' => [
				'title' => 'Erlaubte SSL Ciphers festlegen',
				'description' => 'Dies ist eine Liste von Ciphers, die genutzt werden sollen (oder auch nicht genutzt werden sollen), wenn eine SSL Verbindung besteht. Eine Liste aller Ciphers und wie diese hinzugefügt/ausgeschlossen werden ist in den Abschnitten "CIPHER LIST FORMAT" und "CIPHER STRINGS" in <a href="https://www.openssl.org/docs/manmaster/man1/openssl-ciphers.html">der man-page für Ciphers</a> zu finden.<br /><br /><b>Standard-Wert ist:</b><pre>ECDH+AESGCM:ECDH+AES256:!aNULL:!MD5:!DSS:!DH:!AES128</pre>',
			],
			'apache24_ocsp_cache_path' => [
				'title' => 'Apache 2.4: Pfad zum OCSP-Stapling-Cache',
				'description' => 'Konfiguriert den Cache-Pfad zum Zwischenspeichern der OCSP-Antworten,<br />die an TLS-Handshakes angehängt werden.',
			],
			'ssl_protocols' => [
				'title' => 'SSL Protokollversion festlegen',
				'description' => 'Dies ist eine Liste von SSL/TLS Protokollversionen die genutzt werden sollen (oder auch nicht genutzt werden sollen), wenn SSL verwendet wird. <b>Hinweis:</b> Ältere Browser sind möglicherweise nicht vollständig zum neusten Protokoll kompatibel.<br /><br /><b>Standard-Wert ist:</b><pre>TLSv1.2</pre>',
			],
			'tlsv13_cipher_list' => [
				'title' => 'Explizite TLSv1.3 Ciphers, wenn genutzt',
				'description' => 'Dies ist eine Liste von Ciphers, die genutzt werden sollen (oder auch nicht genutzt werden sollen), wenn eine TLSv1.3 Verbindung hergestellt werden soll. Eine Liste aller Ciphers und wie diese hinzugefügt/ausgeschlossen werden ist <a href="https://wiki.openssl.org/index.php/TLS1.3">der Dokumentation für TLSv1.3</a> zu entnehmen.<br /><br /><b>Standard-Wert ist leer</b>',
			],
		],
		'default_vhostconf' => [
			'title' => 'Standard vHost-Einstellungen',
			'description' => 'Der Inhalt dieses Feldes wird direkt in den IP/Port-vHost-Container übernommen. Die folgenden Variablen können verwendet werden:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (wenn zutreffend)<br/><br /><strong>ACHTUNG:</strong> Der Code wird nicht auf Fehler geprüft. Etwaige Fehler werden also auch übernommen. Der Webserver könnte nicht mehr starten!',
		],
		'default_vhostconf_domain' => [
			'description' => 'Der Inhalt dieses Feldes wird direkt in jeden Domain-vHost-Container übernommen. Die folgenden Variablen können verwendet werden:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (wenn zutreffend)<br/><strong>ACHTUNG:</strong> Der Code wird nicht auf Fehler geprüft. Etwaige Fehler werden also auch übernommen. Der Webserver könnte nicht mehr starten!',
		],
		'apache_globaldiropt' => [
			'title' => 'Kunden-Prefix Ordner-Optionen',
			'description' => 'Der Inhalt dieses Feldes wird in die 05_froxlor_dirfix_nofcgid.conf Apache Konfigurationsdatei eingefügt. Wenn leer werden folgende Standardwerte verwendet:<br><br>apache >=2.4<br><code>Require all granted<br>AllowOverride All</code><br><br>apache <=2.2<br><code>Order allow,deny<br>allow from all</code>',
		],
		'decimal_places' => 'Nachkommastellen bei der Ausgabe von Traffic/Webspace',
		'selfdns' => [
			'title' => 'Manuelle DNS-Einstellungen für Domains',
		],
		'selfdnscustomer' => [
			'title' => 'Erlaube Kunden eigene DNS-Einstellungen vorzunehmen.',
		],
		'unix_names' => [
			'title' => 'Benutze UNIX-kompatible Benutzernamen.',
			'description' => 'Erlaubt die Nutzung von <strong>-</strong> und <strong>_</strong> in Benutzernamen wenn <strong>Nein</strong>.',
		],
		'allow_password_reset' => [
			'title' => 'Erlaube das Zurücksetzen des Kundenpassworts.',
			'description' => 'Kunden können ihr Passwort zurücksetzen und bekommen einen Aktivierungs-Link per E-Mail zugesandt',
		],
		'allow_password_reset_admin' => [
			'title' => 'Erlaube das Zurücksetzen von Admin-/Reseller-Passwörtern.',
			'description' => 'Admins/Reseller können ihr Passwort zurücksetzen und bekommen einen Aktivierungs-Link per E-Mail zugesandt',
		],
		'mail_quota' => [
			'title' => 'Mailbox-Kontingent',
			'description' => 'Standard-Kontingent für neu erstellte E-Mail-Benutzerkonten (Megabyte).',
		],
		'mail_quota_enabled' => [
			'title' => 'Nutze E-Mail-Kontingent für Kunden',
			'description' => 'Aktiviere Kontingent für E-Mail-Konten. Standard ist <b>Nein</b>, da dies eine spezielle Konfiguration voraussetzt.',
			'removelink' => 'Hier klicken, um alle E-Mail-Kontingente zu entfernen',
			'enforcelink' => 'Hier klicken, um allen Benutzern das Standard-Kontingent zu zuweisen.',
		],
		'session_allow_multiple_login' => [
			'title' => 'Erlaube gleichzeitigen Login',
			'description' => 'Wenn diese Option aktiviert ist, können sich Nutzer mehrmals gleichzeitig anmelden.',
		],
		'panel_allow_domain_change_admin' => [
			'title' => 'Erlaube Verschieben von Domains unter Admins',
			'description' => 'Wenn diese Option aktiviert ist, kann unter Domaineinstellungen die Domain einem anderen Admin zugewiesen werden.<br /><b>Achtung:</b> Wenn der Kunde einer Domain nicht dem gleichen Admin zugeordnet ist wie die Domain selbst, kann dieser Admin alle anderen Domains des Kunden sehen!',
		],
		'panel_allow_domain_change_customer' => [
			'title' => 'Erlaube Verschieben von Domains unter Kunden',
			'description' => 'Wenn diese Option aktiviert ist, kann unter Domaineinstellungen die Domain einem anderen Kunden zugewiesen werden.<br /><b>Achtung:</b> Der Dokumenten-Pfad der Domain wird auf den Heimatpfad (+ Domain-Ordner, sofern aktiviert) des neuen Kunden gesetzt.',
		],
		'specialsettingsforsubdomains' => [
			'description' => 'Wenn ja, werden die individuellen Einstellungen für alle Subdomains übernommen.<br />Wenn nein, werden Subdomain-Specialsettings entfernt.',
		],
		'panel_password_min_length' => [
			'title' => 'Mindestlänge von Passwörtern',
			'description' => 'Hier können Sie die Mindestlänge für Passwörter festlegen. \'0\' bedeutet: Keine Mindestlänge',
		],
		'system_store_index_file_subs' => [
			'title' => 'Erstelle Index-Datei auch in neuen Unterordnern',
			'description' => 'Wenn aktiviert, wird für jede Subdomain mit neuem Unterordner die Standard-Index Datei angelegt.',
		],
		'adminmail_return' => [
			'title' => 'Antwort-Adresse',
			'description' => 'Standard-Antwort-Adresse für E-Mails aus dem Panel.',
		],
		'adminmail_defname' => 'Panel-Absender-Name',
		'stdsubdomainhost' => [
			'title' => 'Kunden Standard-Subdomain',
			'description' => 'Welcher Hostname soll für das Erstellen der Kunden-Standard-Subdomain verwendet werden? Falls leer wird der System-Hostname verwendet.',
		],
		'awstats_path' => 'Pfad zu AWStats \'awstats_buildstaticpages.pl\'',
		'awstats_conf' => 'AWStats Konfigurations-Pfad',
		'defaultttl' => 'Domain TTL für Bind in Sekunden (default \'604800\' = 1 Woche)',
		'defaultwebsrverrhandler_enabled' => 'Verwende Standard-Fehlerdokumente für alle Kunden',
		'defaultwebsrverrhandler_err401' => [
			'title' => 'Datei/URL für Fehler 401',
			'description' => '<div class="text-danger">Nicht unterstützt in: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err403' => [
			'title' => 'Datei/URL für Fehler 403',
			'description' => '<div class="text-danger">Nicht unterstützt in: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err404' => 'Datei/URL für Fehler 404',
		'defaultwebsrverrhandler_err500' => [
			'title' => 'Datei/URL für Fehler 500',
			'description' => '<div class="text-danger">Nicht unterstützt in: lighttpd</div>',
		],
		'ftpserver' => [
			'desc' => 'Wenn pureftpd ausgewählt ist, werden die .ftpquota Dateien für das Quota erstellt und täglich aktualisiert.',
		],
		'customredirect_enabled' => [
			'title' => 'Erlaube Kunden-Redirect',
			'description' => 'Erlaubt es Kunden den HTTP-Status Code für einen Redirect zu wählen',
		],
		'customredirect_default' => [
			'title' => 'Standard-Redirect',
			'description' => 'Dieser Redirect wird immer genutzt, sofern der Kunde keinen anderen auswählt.',
		],
		'mail_also_with_mxservers' => 'Erstelle mail-, imap-, pop3- and smtp-"A Record" auch wenn MX-Server angegeben sind',
		'froxlordirectlyviahostname' => 'Froxlor direkt über den Hostnamen erreichbar machen',
		'panel_password_regex' => [
			'title' => 'Regulärer Ausdruck für Passwörter',
			'description' => 'Hier können Sie einen regulären Ausdruck für Passwort-Komplexität festlegen.<br />Leer = keine bestimmten Anforderungen',
		],
		'perl_path' => [
			'title' => 'Pfad zu Perl',
			'description' => 'Standard ist /usr/bin/perl',
		],
		'mod_fcgid_ownvhost' => [
			'title' => 'Verwende FCGID im Froxlor-Vhost',
			'description' => 'Wenn verwendet, wird Froxlor selbst unter einem lokalen Benutzer ausgeführt',
		],
		'perl' => [
			'suexecworkaround' => [
				'title' => 'Aktiviere SuExec-Workaround',
				'description' => 'Aktivieren Sie den Workaround nur, wenn die Kunden-Heimatverzeichnisse sich nicht unterhalb des suexec-Pfades liegen.<br />Wenn aktiviert erstellt Froxlor eine Verknüpfung des vom Kunden für Perl aktiviertem Pfad + /cgi-bin/ im angegebenen suexec-Pfad.<br />Bitte beachten Sie, dass Perl dann nur im Unterordner /cgi-bin/ des Kunden-Ordners funktioniert und nicht direkt in diesem Ordner (wie es ohne den Workaround wäre!)',
			],
			'suexeccgipath' => [
				'title' => 'Pfad für Verknüpfungen zu Kunden-Perl-Verzeichnis',
				'description' => 'Diese Einstellung wird nur benötigt, wenn der SuExec-Workaround aktiviert ist.<br />ACHTUNG: Stellen Sie sicher, dass sich der angegebene Pfad innerhalb des Suexec-Pfades befindet ansonsten ist der Workaround nutzlos',
			],
		],
		'awstats_awstatspath' => 'Pfad zu AWStats \'awstats.pl\'',
		'awstats_icons' => [
			'title' => 'Pfad zum AWstats-Icon-Ordner',
			'description' => 'z. B. /usr/share/awstats/htdocs/icon/',
		],
		'login_domain_login' => 'Erlaube Anmeldung mit Domains',
		'perl_server' => [
			'title' => 'Perl Server-Socket',
			'description' => 'Eine einfache Anleitung hier zu findet man unter <a target="blank" href="http://wiki.nginx.org/SimpleCGIhttps://www.nginx.com/resources/wiki/start/topics/examples/fcgiwrap/">nginx.com</a>',
		],
		'nginx_php_backend' => [
			'title' => 'Nginx-PHP-Backend',
			'description' => 'Dies ist das Backend, auf dem PHP auf Anfragen von Nginx hört. Kann ein UNIX Socket oder eine IP:Port Kombination sein<br />*NICHT relevant bei php-fpm',
		],
		'phpreload_command' => [
			'title' => 'PHP-Reload-Befehl',
			'description' => 'Dieser wird benötigt, um das PHP-Backend bei Bedarf durch den Cronjob neu zu laden. (Standard: leer)<br />*NICHT relevant bei php-fpm',
		],
		'phpfpm' => [
			'title' => 'Aktiviere PHP-FPM',
			'description' => '<b>Dies benötigt eine spezielle Webserver-Konfiguration, siehe <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/php-fpm/">PHP-FPM Handbuch</a></b>',
		],
		'phpfpm_settings' => [
			'configdir' => 'Pfad zu php-fpm-Konfigurationen',
			'aliasconfigdir' => 'Alias-Ordner der php-fpm Konfiguration',
			'reload' => 'Kommando zum Neustarten von php-fpm',
			'pm' => 'Prozess Manager Control (PM)',
			'max_children' => [
				'title' => 'Anzahl der Kind-Prozesse',
				'description' => 'Die Anzahl der zu startenden Kind-Prozesse wenn PM auf \'static\' steht und die maximale Anzahl der Prozesse wenn PM auf \'dynamic/ondemand\' steht.<br />Equivalent zu PHP_FCGI_CHILDREN',
			],
			'start_servers' => [
				'title' => 'Anzahl der beim Starten zu erstellenden Kind-Prozesse',
				'description' => 'Hinweis: Nur wenn PM auf \'dynamic\' steht',
			],
			'min_spare_servers' => [
				'title' => 'Mindestanzahl der Idle-Prozesse',
				'description' => 'Hinweis: Nur wenn PM auf \'dynamic\' steht<br />Wichtig: Pflichtangabe wenn PM auf \'dynamic\' steht',
			],
			'max_spare_servers' => [
				'title' => 'Maximale Anzahl der Idle-Prozesse',
				'description' => 'Hinweis: Nur wenn PM auf \'dynamic\' steht<br />Wichtig: Pflichtangabe wenn PM auf \'dynamic\' steht',
			],
			'max_requests' => [
				'title' => 'Requests pro Kindprozess bevor Neuerstellung (respawning)',
				'description' => 'Für keine Begrenzung \'0\' angeben. Equivalent zu PHP_FCGI_MAX_REQUESTS.',
			],
			'idle_timeout' => [
				'title' => 'Idle-Timeout',
				'description' => 'Timeout-Einstellung für PHP-FPM FastCGI.',
			],
			'ipcdir' => [
				'title' => 'FastCGI IPC Verzeichnis',
				'description' => 'In dieses Verzeichnis werden die php-fpm Sockets vom Webserver abgelegt.<br />Das Verzeichnis muss für den Webserver lesbar sein.',
			],
			'limit_extensions' => [
				'title' => 'Erlaubte Dateiendungen',
				'description' => 'Beschränkt die Dateierweiterungen des Haupt-Skripts, das FPM zu parsen erlaubt. Dies kann Konfigurationsfehler auf der Webserverseite verhindern. Sie sollten FPM nur auf .php Erweiterungen beschränken, um zu verhindern, dass bösartige Nutzter andere Erweiterungen verwenden, um PHP Code auszuführen. Standardwert: .php',
			],
			'envpath' => 'Pfade für die PATH Umgebungsvariable. Leerlassen, um keine PATH Umgebungsvariable zu setzen.',
			'override_fpmconfig' => 'Überschreibe FPM-Daemon Einstellungen (pm, max_children, etc.)',
			'override_fpmconfig_addinfo' => '<br /><span class="text-danger">Nur verwendet wenn "Überschreibe FPM-Daemon Einstellungen" auf "Ja" gestellt ist</span>',
			'restart_note' => 'Achtung: Der Code wird nicht auf Fehler geprüft. Bei etwaigen Fehlern könnte der PHP-FPM-Prozess nicht mehr starten!',
			'custom_config' => [
				'title' => 'Benutzerdefinierte Konfiguration',
				'description' => 'Füge eine benutzerdefinierte Einstellungen zur PHP-FPM Instanz hinzu, beispielsweise <i>pm.status_path = /status</i> für Monitoring. Unten ersichtliche Variablen können verwendet werden. <strong>Achtung: Der Code wird nicht auf Fehler geprüft. Bei etwaigen Fehlern könnte der PHP-FPM-Prozess nicht mehr starten!</strong>',
			],
			'allow_all_customers' => [
				'title' => 'Für aktuelle Kunden automatisch hinzufügen',
				'description' => 'Ist diese Einstellung aktiv, wird die Konfiguration automatisch allen aktuell existierenden Kunden-Accounts zugewiesen. Diese Einstellung ist nicht permanent, kann aber mehrfach / nach Bedarf ausgeführt werden.',
			],
		],
		'report' => [
			'report' => 'Aktiviere das Senden von Reports über Webspace- und Trafficverbrauch',
			'webmax' => [
				'title' => 'Warn-Level in Prozent für Webspace',
				'description' => 'Gültige Werte sind von 0 bis 150. Der Wert 0 deaktiviert diesen Report.',
			],
			'trafficmax' => [
				'title' => 'Warn-Level in Prozent für Traffic',
				'description' => 'Gültige Werte sind von 0 bis 150. Der Wert 0 deaktiviert diesen Report.',
			],
		],
		'dropdown' => 'Auswahlliste',
		'manual' => 'Manuelle Eingabe',
		'default_theme' => 'Standard-Theme',
		'validate_domain' => 'Validiere Domainnamen',
		'diskquota_enabled' => 'Quota aktiviert?',
		'diskquota_repquota_path' => [
			'description' => 'Pfad zu repquota',
		],
		'diskquota_quotatool_path' => [
			'description' => 'Pfad zu quotatool',
		],
		'diskquota_customer_partition' => [
			'description' => 'Partition, auf welcher die Kundendaten liegen',
		],
		'vmail_maildirname' => [
			'title' => 'Maildir-(Unter-)Ordner',
			'description' => 'Der Maildir-Ordner innerhalb des Kontos des Benutzers (normalerweise \'Maildir\', in manchen Fällen auch \'.maildir\'). Sollen die E-Mails direkt in das Verzeichnis, diese Option leer lassen.',
		],
		'catchall_enabled' => [
			'title' => 'Catchall verwenden',
			'description' => 'Möchten Sie Ihren Kunden die Funktion Catchall zur Verfügung stellen?',
		],
		'apache_24' => [
			'title' => 'Anpassungen für Apache 2.4 verwenden',
			'description' => '<div class="text-danger">Achtung: Bitte nur verwenden, wenn wirklich Apache mit Version 2.4 oder höher installiert ist, ansonsten wird der Webserver nicht starten.</div>',
		],
		'nginx_fastcgiparams' => [
			'title' => 'Pfad zur fastcgi_params Datei',
			'description' => 'Geben Sie den Pfad zu nginx\'s fastcgi_params Datei an. Inklusive Dateiname!',
		],
		'documentroot_use_default_value' => [
			'title' => 'Verwende Domainnamen im Documentroot',
			'description' => 'Wenn aktiviert wird dem standard Documentroot zusätzlich der Domain-Name angehängt.<br /><br />Beispiel:<br />/var/customers/webs/customer_name/example.tld/<br />/var/customers/webs/customer_name/subdomain.example.tld/',
		],
		'panel_phpconfigs_hidesubdomains' => [
			'title' => 'Verstecke Subdomains in PHP-Konfigurations-Übersicht',
			'description' => 'Wenn aktiviert, werden die Subdomains der Kunden nicht in der PHP-Konfigurations-Übersicht angezeigt, lediglich die Anzahl.<br /><br />Hinweis: Nur relevant, wenn FCGID oder PHP-FPM aktiviert ist.',
		],
		'panel_phpconfigs_hidestdsubdomain' => [
			'title' => 'Verstecke Standard-Subdomains in PHP-Konfigurations-Übersicht',
			'description' => 'Wenn aktiviert, werden die Standard-Subdomains der Kunden nicht mehr in der PHP-Konfigurations-Übersicht angezeigt.<br /><br />Hinweis: Nur relevant, wenn FCGID oder PHP-FPM aktiviert ist.',
		],
		'passwordcryptfunc' => [
			'title' => 'Wählen Sie die zu verwendende Passwort-Verschlüsselungsmethode',
			'description' => 'Wählen Sie, welche Methode zur Verschlüsselung von Kennwörtern verwendet werden soll. Wenn Sie diese Einstellung ändern, werden nur neue Kennwörter mit der neuen Methode verschlüsselt. Bestehende Passwörter werden nicht geändert.'
		],
		'systemdefault' => 'Systemstandard',
		'panel_allow_theme_change_admin' => 'Erlaube Admins das Theme zu wechseln',
		'panel_allow_theme_change_customer' => 'Erlaube Kunden das Theme zu wechseln',
		'axfrservers' => [
			'title' => 'AXFR Server',
			'description' => 'Eine durch Kommas getrennte Liste von IP Adressen, die DNS-Zonen transferieren dürfen (AXFR).',
		],
		'powerdns_mode' => [
			'title' => 'PowerDNS Operation Mode',
			'description' => 'Wählen Sie den PowerDNS-Modus: Native für keine DNS-Replikation (Standard) / Master wenn eine DNS-Replikation benötigt wird.',
		],
		'customerssl_directory' => [
			'title' => 'Webserver-Kunden-SSL-Zertifikatsverzeichnis',
			'description' => 'Wo sollen kundenspezifizierte SSL-Zertifikate erstellt werden?<br /><br /><div class="text-danger">ACHTUNG: Der Inhalt dieses Ordners wird regelmäßig geleert, daher sollten dort keinerlei Daten manuell abgelegt werden.</div>',
		],
		'allow_error_report_admin' => [
			'title' => 'Erlaube Administrator/Reseller das Melden von Datenbankfehlern an Froxlor',
			'description' => 'Bitte beachten: Senden Sie zu keiner Zeit irgendwelche datenschutzrelevanten/persönlichen (Kunden-)Daten an uns!',
		],
		'allow_error_report_customer' => [
			'title' => 'Erlaube Kunden das Melden von Datenbankfehlern an Froxlor',
			'description' => 'Bitte beachten: Senden Sie zu keiner Zeit irgendwelche datenschutzrelevanten/persönlichen (Kunden-)Daten an uns!',
		],
		'mailtraffic_enabled' => [
			'title' => 'Analysiere Mailtraffic',
			'description' => 'Aktiviere das Analysieren der Logdateien des Mailsystems, um den verbrauchten Traffic zu berechnen.',
		],
		'mdaserver' => [
			'title' => 'Typ des MDA',
			'description' => 'Der eingesetzte Mail Delivery Server',
		],
		'mdalog' => [
			'title' => 'Logdatei des MDA',
			'description' => 'Die Logdatei des Mail Delivery Server',
		],
		'mtaserver' => [
			'title' => 'Typ des MTA',
			'description' => 'Der eingesetzte Mail Transfer Agent',
		],
		'mtalog' => [
			'title' => 'Logdatei des MTA',
			'description' => 'Die Logdatei des Mail Transfer Agent',
		],
		'system_cronconfig' => [
			'title' => 'Cron-Konfigurationsdatei',
			'description' => 'Pfad zur Konfigurationsdatei des Cron-Dienstes. Diese Datei wird von Froxlor automatisch aktualisiert.<br />Hinweis: Bitte verwenden Sie <strong>exakt</strong> die gleiche Datei wie für den Froxlor-Haupt-Cronjob (Standard: /etc/cron.d/froxlor)!<br><br>Wird <b>FreeBSD</b> verwendet, sollte hier <i>/etc/crontab</i> angegeben werden!',
		],
		'system_crondreload' => [
			'title' => 'Cron-Daemon reload Befehl',
			'description' => 'Geben Sie hier den Befehl zum Neuladen des Cron-Daemons an',
		],
		'system_croncmdline' => [
			'title' => 'Cron Startbefehl (php Programm)',
			'description' => 'Befehl zum Ausführen des Cronjobs. Ändern dieser Einstellung nur wenn nötig (Standard: "/usr/bin/nice -n 5 /usr/bin/php -q")!',
		],
		'system_cron_allowautoupdate' => [
			'title' => 'Erlaube automatische Datenbank-Aktualisierungen',
			'description' => '<strong class="text-danger">WARNUNG:</strong> Diese Einstellung erlaubt es dem Cronjob die Prüfung der Dateien- und Datenbank-Version zu umgehen und bei einem Versions-Unterschied die Datenbank-Aktualisierungen automatisiert auszuführen.<br /><br/><div class="text-danger">Das automatische Update setzt für neue Einstellungen und Änderungen immer die default-Werte. Diese müssen nicht zwingend zu dem genutzten System passen. Bitte zwei mal nachdenken, bevor diese Option aktiviert wird.</div>',
		],
		'dns_createhostnameentry' => 'Erstelle bind-Zone/Konfiguration für den System-Hostnamen',
		'panel_password_alpha_lower' => [
			'title' => 'Kleinbuchstaben',
			'description' => 'Das Passwort muss mindestens einen Kleinbuchstaben (a-z) enthalten.',
		],
		'panel_password_alpha_upper' => [
			'title' => 'Großbuchstaben',
			'description' => 'Das Passwort muss mindestens einen Großbuchstaben (A-Z) enthalten.',
		],
		'panel_password_numeric' => [
			'title' => 'Zahlen',
			'description' => 'Das Passwort muss mindestens eine Zahl (0-9) enthalten.',
		],
		'panel_password_special_char_required' => [
			'title' => 'Sonderzeichen',
			'description' => 'Das Passwort muss mindestens eines der untenstehenden Sonderzeichen enthalten',
		],
		'panel_password_special_char' => [
			'title' => 'Sonderzeichen-Liste',
			'description' => 'Mindestens eines dieser Sonderzeichen muss in dem Passwort vorkommen, sofern die Sonderzeichen-Option aktiviert ist.',
		],
		'apache_itksupport' => [
			'title' => 'Anpassungen für Apache ITK-MPM verwenden',
			'description' => '<div class="text-danger">Achtung: Bitte nur verwenden, wenn wirklich Apache itk-mpm verwendet wird, ansonsten wird der Webserver nicht starten.</div>',
		],
		'letsencryptca' => [
			'title' => 'ACME Umgebung',
			'description' => 'Umgebung, welche genutzt wird um Zertifikate zu bestellen.',
		],
		'letsencryptchallengepath' => [
			'title' => 'Verzeichnis für Let\'s Encrypt challenges',
			'description' => 'Let\'s Encrypt challenges werden aus diesem Verzeichnis über einen globalen Alias ausgeliefert.',
		],
		'letsencryptkeysize' => [
			'title' => 'Schlüsselgröße für neue Let\'s Encrypt Zertifikate',
			'description' => 'Größe des Schlüssels in Bit für neue Let\'s Encrypt Zertifikate.',
		],
		'letsencryptreuseold' => [
			'title' => 'Let\'s Encrypt Schlüssel wiederverwenden',
			'description' => 'Wenn dies aktiviert ist, wird der alte Schlüssel bei jeder Verlängerung verwendet, andernfalls wird ein neues Paar generiert.',
		],
		'leenabled' => [
			'title' => 'Let\'s Encrypt verwenden',
			'description' => 'Wenn dies aktiviert ist, können Kunden durch Froxlor automatisch generierte und verlängerbare Let\'s Encrypt SSL-Zertifikate für Domains mit SSL IP/Port nutzen.<br /><br />Bitte die Webserver-Konfiguration beachten wenn aktiviert, da dieses Feature eine spezielle Konfiguration benötigt.',
		],
		'caa_entry' => [
			'title' => 'CAA DNS Einträge generieren',
			'description' => 'Generiert CAA Einträge automatisch für alle Domains mit aktiviertem SSL und Let\'s Encrypt',
		],
		'caa_entry_custom' => [
			'title' => 'Zusätzliche CAA DNS Einträge',
			'description' => 'DNS Certification Authority Authorization (CAA) verwendet das Domain Name System, um dem Besitzer einer Domain die Möglichkeit zu bieten, gewisse Zertifizierungsstellen (CAs) dazu zu berechtigen,<br>ein Zertifikat für die betroffene Domain auszustellen. CAA Records sollen verhindern, dass Zertifikate fälschlicherweise für eine Domain ausgestellt werden.<br><br>Der Inhalt dieses Feldes wird direkt in die DNS Zone übernommen (eine Zeile pro CAA Record). Wenn Let\'s Encrypt für eine Domain aktiviert wurde und die obige Option aktiviert wurde, wird immer automatisch dieser Eintrag angefügt und muss nicht selber angegeben werden:<br><code>0 issue "letsencrypt.org"</code> (Wenn wildcard aktiviert ist, wird statdessen issuewild benutzt).<br>Um Incident Reporting per Mail zu aktivieren, muss eine <code>iodef</code> Zeile angefügt werden. Ein Beispiel für einen Report an <code>me@example.com</code> wäre:<br><code>0 iodef "mailto:me@example.com"</code><br><br><strong>ACHTUNG:</strong> Der Code wird nicht auf Fehler geprüft. Etwaige Fehler werden also auch übernommen. Die CAA finalen Einträge könnten daher falsch sein!',
		],
		'exportenabled' => [
			'title' => 'Daten-Export für Kunden aktivieren',
			'description' => 'Wenn dies aktiviert ist, kann der Kunde Daten-Exporte planen (cron-export) welche ein Archiv in sein Heimatverzeichnis ablegen (Unterordner vom Kunden wählbar)',
		],
		'dnseditorenable' => [
			'title' => 'DNS Editor aktivieren',
			'description' => 'Erlaubt es Admins und Kunden die DNS Einträge ihrer Domains zu verwalten.',
		],
		'dns_server' => [
			'title' => 'DNS Server Dienst',
			'description' => 'Dienste müssen mit den froxlor Konfigurationstemplates konfiguriert werden',
		],
		'panel_customer_hide_options' => [
			'title' => 'Menüpunkte und Traffic-Charts im Kundenbereich ausblenden',
			'description' => 'Wählen Sie hier die gewünschten Menüpunkte und Traffic-Charts aus, welche im Kundenbereich ausgeblendet werden sollen. Für Mehrfachauswahl, halten Sie während der Auswahl STRG gedrückt.',
		],
		'allow_allow_customer_shell' => [
			'title' => 'Erlaube Kunden für FTP Benutzer eine Shell auszuwählen',
			'description' => '<strong class="text-danger">Bitte beachten: Shell Zugriff gestattet dem Benutzer verschiedene Programme auf Ihrem System auszuführen. Mit großer Vorsicht verwenden. Bitte aktiviere dies nur wenn WIRKLICH bekannt ist, was das bedeutet!!!</strong>',
		],
		'available_shells' => [
			'title' => 'Liste der verfügbaren Shells',
			'description' => 'Komma-getrennte Liste von Shells, die der Kunde für seine FTP-Konten wählen kann.<br><br>Hinweis: Die Standard-Shell <strong>/bin/false</strong> wird immer eine Auswahlmöglichkeit sein (wenn aktiviert), auch wenn diese Einstellung leer ist. Sie ist in jedem Fall der Standardwert für alle FTP-Konten',
		],
		'le_froxlor_enabled' => [
			'title' => 'Let\'s Encrypt für den froxlor Vhost verwenden',
			'description' => 'Wenn dies aktiviert ist, erstellt froxlor für seinen vhost automatisch ein Let\'s Encrypt Zertifikat.',
		],
		'le_froxlor_redirect' => [
			'title' => 'SSL-Weiterleitung für den froxlor Vhost aktivieren',
			'description' => 'Wenn dies aktiviert ist, werden alle HTTP Anfragen an die entsprechende SSL Seite weitergeleitet.',
		],
		'option_unavailable_websrv' => '<br><em class="text-danger">Nur verfügbar für: %s</em>',
		'option_unavailable' => '<br><em class="text-danger">Option aufgrund anderer Einstellungen nicht verfügbar.</em>',
		'letsencryptacmeconf' => [
			'title' => 'Pfad zu acme.conf',
			'description' => 'Dateiname der Konfiguration, die dem Webserver erlaubt, die ACME-Challenges zu bedienen.',
		],
		'mail_use_smtp' => 'Nutze SMTP für das Senden von E-Mails',
		'mail_smtp_host' => 'SMTP Server',
		'mail_smtp_usetls' => 'Aktiviere TLS Verschlüsselung',
		'mail_smtp_auth' => 'Nutze SMTP Authentifizierung',
		'mail_smtp_port' => 'TCP Port für SMTP',
		'mail_smtp_user' => 'SMTP Benutzer',
		'mail_smtp_passwd' => 'SMTP Passwort',
		'http2_support' => [
			'title' => 'HTTP2 Unterstützung',
			'description' => 'Aktiviere HTTP2 Unterstützung für SSL.<br><em class="text-danger">NUR AKTIVIEREN, WENN DER WEBSERVER DIESE FUNKTION UNTERSTÜTZT (nginx version 1.9.5+, apache2 version 2.4.17+)</em>',
		],
		'nssextrausers' => [
			'title' => 'Verwende libnss-extrausers anstatt libnss-mysql',
			'description' => 'Lese Benutzer nicht direkt aus der Datenbank sondern über Dateien. Bitte nur aktivieren, wenn die entsprechende Konfiguration vorgenommen wurde (System -> libnss-extrausers).<br><strong class="text-danger">Nur für Debian/Ubuntu (oder wenn libnss-extrausers manuell kompiliert wurde!)</strong>',
		],
		'le_domain_dnscheck' => [
			'title' => 'Validiere DNS der Domains wenn Let\'s Encrypt genutzt wird',
			'description' => 'Wenn aktiviert wird froxlor überprüfen ob die DNS Einträge der Domains, welche ein Let\'s Encrypt Zertifikat beantragt, mindestens auf eine der System IP Adressen auflöst.',
		],
		'le_domain_dnscheck_resolver' => [
			'title' => 'DNS Resolver für die DNS Überprüfung',
			'description' => 'IP Adresse des DNS Servers, welcher für die DNS Überprüfung genutzt werden soll. Wenn leer, wird der Standard DNS Resolver des Systems genutzt.',
		],
		'phpsettingsforsubdomains' => [
			'description' => 'Wenn ja, wird die gewählte PHP-Config für alle Subdomains übernommen',
		],
		'leapiversion' => [
			'title' => 'Wählen Sie die Let\'s Encrypt ACME Implementierung',
			'description' => 'Aktuell unterstützt froxlor lediglich die ACME v2 Implementierung von Let\'s Encrypt.',
		],
		'enable_api' => [
			'title' => 'Aktiviere externe API Nutzung',
			'description' => 'Um die froxlor API nutzen zu können, muss diese Option aktiviert sein. Für detaillierte Informationen siehe <a href="https://docs.froxlor.org/latest/api-guide/" target="_new">https://docs.froxlor.org/</a>',
		],
		'api_customer_default' => '"Erlaube API Nutzung" Vorbelegung für neue Kunden',
		'dhparams_file' => [
			'title' => 'DHParams Datei (Diffie–Hellman key exchange)',
			'description' => 'Wird eine dhparams.pem Datei hier angegeben, wir sie in die Webserver Konfiguration mit eingefügt.<br>Beispiel: /etc/ssl/webserver/dhparams.pem<br><br>Existiert die Datei nicht, wird sie wie folgt erstellt: <code>openssl dhparam -out /etc/ssl/webserver/dhparams.pem 4096</code>. Es wird empfohlen die Datei zu erstellen, bevor sie hier angegeben wird, da die Erstellung längere Zeit in Anspruch nimmt und den Cronjob blockiert.',
		],
		'errorlog_level' => [
			'title' => 'Ausführlichkeit des Fehlerprotokolls',
			'description' => 'Steuert die Ausführlichkeit des Fehlerprotokolls. Voreinstellung ist "warn" bei Apache und "error" bei Nginx.',
		],
		'letsencryptecc' => [
			'title' => 'ECC / ECDSA Zertifikate ausstellen',
			'description' => 'Wenn eine Schlüsselgröße ausgewählt wird, werden ECC / ECDSA Zertifikate erstellt',
		],
		'froxloraliases' => [
			'title' => 'Domain Aliase für Froxlor Vhost',
			'description' => 'Komma getrennte Liste von Domains, welche als Server Alias zum Froxlor Vhost hinzugefügt werden',
		],
		'default_sslvhostconf' => [
			'title' => 'Standard SSL vHost-Einstellungen',
			'description' => 'Der Inhalt dieses Feldes wird direkt in den IP/Port-vHost-Container übernommen. Die folgenden Variablen können verwendet werden:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (wenn zutreffend)<br/><br /><strong>ACHTUNG:</strong> Der Code wird nicht auf Fehler geprüft. Etwaige Fehler werden also auch übernommen. Der Webserver könnte nicht mehr starten!',
		],
		'includedefault_sslvhostconf' => 'Nicht-SSL vHost-Einstellungen in SSL-vHost inkludieren',
		'apply_specialsettings_default' => 'Standardwert für "Übernehme Einstellungen für alle Subdomains (*.beispiel.de)" Einstellung beim Bearbeiten einer Domain',
		'apply_phpconfigs_default' => 'Standardwert für "PHP-Config für alle Subdomains übernehmen:" Einstellung beim Bearbeiten einer Domain',
		'awstats' => [
			'logformat' => [
				'title' => 'LogFormat Einstellung',
				'description' => 'Wenn ein benutzerdefiniertes LogFormat beim Webserver verwendet wird, muss LogFormat von awstats ebenso angepasst werden.<br/>Standard ist 1. Für weitere Informationen siehe Dokumentation unter <a target="_blank" href="https://awstats.sourceforge.io/docs/awstats_config.html#LogFormat">hier</a>.',
			],
		],
		'hide_incompatible_settings' => 'Inkompatible Einstellungen ausblenden',
		'soaemail' => 'Mail-Adresse für SOA-Einträge (verwendet Panel-Absender-Name der Panel-Einstellungen falls leer)',
		'imprint_url' => [
			'title' => 'URL zum Impressum',
			'description' => 'Die URL zur Impressums-Seite. Der Link ist auf der Login-Seite und wenn eingeloggt, in der Fußzeile sichtbar.',
		],
		'terms_url' => [
			'title' => 'URL zu den AGB',
			'description' => 'Die URL zur AGB-Seite. Der Link ist auf der Login-Seite und wenn eingeloggt, in der Fußzeile sichtbar.',
		],
		'privacy_url' => [
			'title' => 'URL zur Datenschutzerklärung',
			'description' => 'Die URL zur Datenschutzerklärungs-Seite. Der Link ist auf der Login-Seite und wenn eingeloggt, in der Fußzeile sichtbar.',
		],
		'logo_image_header' => [
			'title' => 'Logo Bild (Header)',
			'description' => 'Das hochgeladene Bild wird als Logo oben links nach dem Login angezeigt (empfohlene Höhe sind 30px)',
		],
		'logo_image_login' => [
			'title' => 'Logo Bild (Login)',
			'description' => 'Das hochgeladene Bild wird als Logo während des Logins angezeigt',
		],
		'logo_overridetheme' => [
			'title' => 'Überschreibe Theme-Logo mit "Logo Bild" (Header und Login, siehe unten)',
			'description' => 'Ist die Nutzung eines hochgeladenen Logos gewünscht, muss diese Einstellung auf "Ja" gesetzt werden. Alternativ kann weiterhin das Theme-basierte Überschreiben via "logo_custom.png" und "logo_custom_login.png" genutzt werden.',
		],
		'logo_overridecustom' => [
			'title' => 'Überschreibe benutzerdefinierte Theme-Logos (logo_custom.png und logo_custom_login.png) mit "Logo Bild" (Header und Login, siehe unten)',
			'description' => 'Ist diese Einstellung aktiv, werden benutzerdefinierte Logos im Theme-Ordner mit dem "Logo Bild" ersetzt',
		],
		'createstdsubdom_default' => [
			'title' => 'Standardwert für "Standardsubdomain anlegen" bei Erstellung eines Kunden',
			'description' => '',
		],
		'froxlorusergroup' => [
			'title' => 'Benutzerdefinierte Gruppe für alle Kunden-Benutzer',
			'description' => 'Voraussetzung hierfür ist die Nutzung von libnss-extrausers (System-Einstellungen). Ein leerer Wert bedeutet, es wird keine Gruppe erstellt, bzw. vorhandene Gruppe wird entfernt.',
		],
		'acmeshpath' => [
			'title' => 'Pfad zu acme.sh',
			'description' => 'Installationspfad zu acme.sh, inklusive acme.sh Script<br>Standard ist <b>/root/.acme.sh/acme.sh</b>',
		],
		'update_channel' => [
			'title' => 'froxlor Update Kanal',
			'description' => 'Wähle den bevorzugten Update Kanal. Standard ist "stable"',
		],
		'traffictool' => [
			'toolselect' => 'Traffic Analyzer',
		],
		'requires_reconfiguration' => 'Änderungen an dieser Einstellungen benötigen unter Umständen eine erneute Konfiguration der folgenden Dienste:<br><strong>%s</strong>',
		'req_limit_per_interval' => [
			'title' => 'Anzahl der HTTP-Anfragen pro Intervall',
			'description' => 'Erlaubte Anzahl von HTTP-Anfragen pro Intervall (siehe unten) auf froxlor, Standard ist "60"',
		],
		'req_limit_interval' => [
			'title' => 'Rate-Limit-Intervall',
			'description' => 'Zeit in Sekunden für die maximale Anzahl von HTTP-Anfragen, Standard ist "60".',
		],
		'option_requires_otp' => 'Das Ändern dieser Einstellung erfordert OTP Validierung',
		'panel_menu_collapsed' => [
			'title' => 'Menüabschnitte einklappen',
			'description' => 'Bei Deaktivierung werden die Menübereiche auf der linken Seite immer aufgeklappt angezeigt.',
		],
		'le_renew_services' => [
			'title' => 'Verwende das froxlor Let\'s Encrypt Zertifikat für folgende Dienste',
			'description' => 'Wenn auf "Keine" gesetzt (oder der Renew-Hook-Befehl unten leer ist), werden keine Konfigurationsanpassungen bezüglich SSL an den ausgewählten Diensten vorgenommen.<br><br>Der Reload-Befehl für die ausgewählten Dienste sollte im Renew-Hook-Befehl hinzugefügt werden, da sonst die Konfigurationsänderungen oder erneuerten Zertifikate möglicherweise nicht korrekt angewendet werden.',
		],
		'le_renew_hook' => [
			'title' => 'Let\'s Encrypt Renew-Hook Befehl',
			'description' => 'Lege den Befehl fest, der die oben ausgewählten Dienste neu startet, damit erneuerte Zertifikate vom Dienst ordnungsgemäß verwendet werden.',
		],
	],
	'spf' => [
		'use_spf' => [
			'title' => 'Aktiviere SPF für Domains?',
			'description' => 'Erfordert einen speziellen DNS Eintrag für die Domain. Wenn das Nameserver-Feature nicht genutzt wird, muss dieser Eintrag manuell verwaltet werden.',
		],
		'spf_entry' => 'SPF-Eintrag für alle Domains',
	],
	'dmarc' => [
		'use_dmarc' => [
			'title' => 'Aktiviere DMARC für Domains?',
			'description' => 'Erfordert einen speziellen DNS Eintrag für die Domain. Wenn das Nameserver-Feature nicht genutzt wird, muss dieser Eintrag manuell verwaltet werden.',
		],
		'dmarc_entry' => 'DMARC-Eintrag für alle Domains',
	],
	'success' => [
		'success' => 'Information',
		'clickheretocontinue' => 'Hier klicken, um fortzufahren',
		'settingssaved' => 'Die Einstellungen wurden erfolgreich gespeichert.',
		'rebuildingconfigs' => 'Task für Neuerstellung der Konfigurationen wurde erfolgreich eingetragen',
		'domain_import_successfully' => 'Erfolgreich %s Domains importiert.',
		'exportscheduled' => 'Ihr Daten-Export wurde erfolgreich geplant. Bitte warten Sie nun, bis dieser bearbeitet wurde.',
		'exportaborted' => 'Der geplante Daten-Export wurde abgebrochen',
		'dns_record_added' => 'Eintrag erfolgreich hinzugefügt',
		'dns_record_deleted' => 'Eintrag erfolgreich entfernt',
		'testmailsent' => 'Test E-Mail erfolgreich gesendet',
		'settingsimported' => 'Einstellungnen erfolgreich importiert',
		'sent_error_report' => 'Fehlerbericht erfolgreich gesendet. Danke für die Unterstützung.',
	],
	'tasks' => [
		'outstanding_tasks' => 'Ausstehende Cron-Aufgaben',
		'REBUILD_VHOST' => 'Neuerstellung der Webserver-Konfiguration',
		'CREATE_HOME' => 'Erstelle neuen Kunden %s',
		'REBUILD_DNS' => 'Neuerstellung der Bind-Konfiguration',
		'CREATE_FTP' => 'Erstelle Verzeichnis für neuen FTP-Benutzer',
		'DELETE_CUSTOMER_FILES' => 'Löschen von Kunden-Dateien %s',
		'noneoutstanding' => 'Zur Zeit gibt es keine ausstehenden Aufgaben für Froxlor',
		'DELETE_EMAIL_DATA' => 'E-Mail-Dateien des Kunden löschen',
		'DELETE_FTP_DATA' => 'Kunden FTP-Konto Dateien löschen',
		'REBUILD_RSPAMD' => 'Neuerstellung der Antispam-Konfiguration',
		'CREATE_QUOTA' => 'Quota auf dem Dateisystem setzen',
		'REBUILD_CRON' => 'Neuerstellung der cron.d-Datei',
		'CREATE_CUSTOMER_DATADUMP' => 'Daten-Export für Kunde %s',
		'DELETE_DOMAIN_PDNS' => 'Lösche Domain %s von PowerDNS Datenbank',
		'DELETE_DOMAIN_SSL' => 'Lösche SSL Dateien von Domain %s',
		'UPDATE_LE_SERVICES' => 'Aktualisiere Systemdienste für Let\'s Encrypt',
	],
	'terms' => 'AGB',
	'traffic' => [
		'month' => 'Monat',
		'months' => [
			1 => 'Januar',
			2 => 'Februar',
			3 => 'März',
			4 => 'April',
			5 => 'Mai',
			6 => 'Juni',
			7 => 'Juli',
			8 => 'August',
			9 => 'September',
			10 => 'Oktober',
			11 => 'November',
			12 => 'Dezember',
			'jan' => 'Jan',
			'feb' => 'Feb',
			'mar' => 'Mär',
			'apr' => 'Apr',
			'may' => 'Mai',
			'jun' => 'Jun',
			'jul' => 'Jul',
			'aug' => 'Aug',
			'sep' => 'Sep',
			'oct' => 'Okt',
			'nov' => 'Nov',
			'dec' => 'Dez',
			'total' => 'Gesamt',
		],
		'mb' => 'Traffic',
		'day' => 'Tag',
		'sumtotal' => 'Gesamt Traffic',
		'sumhttp' => 'HTTP-Traffic',
		'sumftp' => 'FTP-Traffic',
		'summail' => 'Mail-Traffic',
		'customer' => 'Kunde',
		'trafficoverview' => 'Übersicht Traffic',
		'bycustomers' => 'Traffic nach Kunden',
		'details' => 'Details',
		'http' => 'HTTP',
		'ftp' => 'FTP',
		'mail' => 'Mail',
		'nocustomers' => 'Es wird mindestens ein Kunde benötigt um die Traffic Statistiken anzuzeigen.',
		'top5customers' => 'Top 5 Kunden',
		'nodata' => 'Keine Daten im angegebenen Zeitraum.',
		'ranges' => [
			'last24h' => 'die letzten 24 Std',
			'last7d' => 'die letzten 7 Tage',
			'last30d' => 'die letzten  30 Tage',
			'cm' => 'Aktueller Monat',
			'last3m' => 'die letzten 3 Monate',
			'last6m' => 'die letzten 6 Monate',
			'last12m' => 'die letzten 12 Monate',
			'cy' => 'Aktuelles Jahr',
		],
		'byrange' => 'Nach angegebenem Zeitraum',
	],
	'translator' => '',
	'update' => [
		'updateinprogress_onlyadmincanlogin' => 'Eine neuere Version von Froxlor wurde installiert, aber noch nicht eingerichtet.<br />Nur der Administrator kann sich anmelden und die Aktualisierung abschließen.',
		'update' => 'Froxlor Aktualisierung',
		'proceed' => 'Ausführen',
		'update_information' => [
			'part_a' => 'Die Froxlor-Dateien wurden aktualisiert. Neue Version ist <strong>%s</strong>. Die bisher installierte Version ist <strong>%s</strong>',
			'part_b' => '<br /><br />Ein Kunden-Login ist vor Abschluss des Aktualisierungsvorganges nicht möglich.<br /><strong>Aktualisierung ausführen?</strong>',
		],
		'noupdatesavail' => 'Die genutzte %sVersion von Froxlor ist aktuell.',
		'description' => 'Aktualisierung der froxlor Datenbank',
		'uc_newinfo' => 'Eine neuere %sVersion ist verfügbar: "%s" (Aktuell installierte Version: %s)',
		'notify_subject' => 'Neues Update verfügbar',
		'dbupdate_required' => 'Froxlor-Dateien wurden aktualisiert, Datenbank-Aktualisierung notwendig',
	],
	'usersettings' => [
		'custom_notes' => [
			'title' => 'Eigene Notizen',
			'description' => 'Hier können Notizen je nach Lust und Laune eingetragen werden. Diese werden in der Administrator/Kunden-Übersicht bei dem jeweiligen Benutzer angezeigt.<br>Markdown ist unterstützt, HTML wird entfernt.',
			'show' => 'Zeige die Notizen auf dem Dashboard des Benutzers',
		],
		'api_allowed' => [
			'title' => 'Erlaube API Zugriff',
			'description' => 'Wenn in den Einstellungen aktiviert, kann der Benutzer API Schlüssel erstellen und auf die froxlor API Zugreifen',
			'notice' => 'API Zugriff ist für dieses Konto deaktiviert.',
		],
		'gui_access' => [
			'title' => 'WebUI-Anmeldung zulassen',
			'description' => 'Wenn diese Option deaktiviert ist, kann sich der Benutzer nicht bei der Froxlor-Weboberfläche anmelden, aber alle Dienste (Web, FTP, E-Mail, Datenbanken, API-Zugriff, usw.) funktionieren normal.',
		],
	],
	'install' => [
		'preflight' => 'System-Prüfung',
		'critical_error' => 'Kritischer Fehler',
		'suggestions' => 'Nicht notwendig, aber emfohlen',
		'phpinfosuccess' => 'Auf dem System ist PHP %s installiert',
		'suggestionsnote' => 'Es liegen keine kritische Fehler vor, die eine Installation verhindern, allerdings beachten Sie bitte die Empfehlungen weiter unten für ein optimales Erlebnis.',
		'phpinfowarn' => 'Die genutzte PHP Version ist kleiner als die geforderte Version %s',
		'phpinfoupdate' => 'Aktualisierung von PHP Version %s auf %s oder höher notwendig',
		'start_installation' => 'Installation starten',
		'check_again' => 'Erneut prüfen...',
		'switchmode_advanced' => 'Erweiterte Optionen anzeigen',
		'switchmode_basic' => 'Erweiterte Optionen ausblenden',
		'dependency_check' => [
			'title' => 'Willkommen bei froxlor',
			'description' => 'Das System wird auf Abhängigkeiten überprüft, um sicher zu stellen das alle erforderlichen PHP Erweiterungen vorhanden und aktiviert sind, so dass froxlor einwandfrei funktioniert.',
		],
		'database' => [
			'top' => 'Datenbank',
			'title' => 'Datenbank und Benutzer erstellen',
			'description' => 'Froxlor benötigt eine Datenbank und zusätzlich <a href="https://docs.froxlor.org/latest/general/installation/tarball.html#_3-create-privileged-database-user" target="_blank">einen Benutzer mit privilegierten Rechten</a>, welcher Benutzer und Datenbanken erstellen darf (GRANT Option). Die angegebene Datenbank und der unprivilegierte Benutzer werden automatisch in diesem Prozess erstellt. Der privilegierte Benutzer muss existieren.',
			'user' => 'Unprivilegierter Datenbank Benutzer',
			'dbname' => 'Datenbank Name',
			'force_create' => 'Sichern und überschreiben, sofern Datenbank existiert?',
		],
		'admin' => [
			'top' => 'Admin Konto',
			'title' => 'Erstellen des Haupt-Administrators.',
			'description' => 'Dieser Benutzer erhält alle Berechtigungen zur Anpassungen von Einstellungen und Erstellen/Bearbeiten/Löschen von Resourcen wie Kunden, Domains, etc.',
			'use_admin_email_as_sender' => 'Verwende die oben angegebene E-Mail-Adresse als Absenderadresse. Wenn die Option deaktiviert ist, geben Sie unten bitte eine Absenderadresse an.',
			'use_autogenerated_email_as_sender' => 'Leer lassen für Standard: admin@servername',
		],
		'system' => [
			'top' => 'System Setup',
			'title' => 'Detailangaben zum Server',
			'description' => 'Gebe hier Informationen und relevante Daten zu dem Server an damit froxlor dein System kennt. Diese Angaben sind entscheidend für die Konfiguration und den Betrieb der Dienste.',
			'ipv4' => 'Primäre IPv4 Adresse (sofern zutreffend)',
			'ipv6' => 'Primäre IPv6 Adresse (sofern zutreffend)',
			'servername' => 'Server Name (FQDN, keine IP Adresse)',
			'phpbackend' => 'PHP Backend',
			'activate_newsfeed' => 'Offizielles Newsfeed aktivieren<br><small>(externe Quelle: https://inside.froxlor.org/news/)</small>',
		],
		'install' => [
			'top' => 'Abschluss',
			'title' => 'Ein letzter Schritt...',
			'description' => 'Der untenstehende Befehl lädt, installiert und konfiguriert die benötigten Dienste auf dem System aufgrund der Angaben die während des Installationsprozessen gesammelt wurden.<br><br><span class="text-danger">Führe die gezeigten Befehle als <b>root</b> in der Shell/Konsole des Servers aus. <b>Beachte bitte</b> das dieser Befehl vorhandene Konfigurationen <b>überschreibt</b> (Sicherungsdateien werden erstellt)!<br>Sollte dies nicht gewünscht sein, wähle <i>Ich werden die Dienste manuell konfigurieren</i> am Ende dieser Seite.</span>',
			'runcmd' => 'Folgende Befehle ausführen, um die Installation abzuschließen:',
			'manual_config' => 'Ich werden die Dienste manuell konfigurieren, direkt zum Login umleiten',
			'waitforconfig' => 'Warte auf Abschluss der Dienstkonfiguration...',
		],
		'errors' => [
			'wrong_ownership' => 'Die froxlor Dateien gehören nicht vollständig dem Benutzer %s:%s',
			'missing_extensions' => 'Folgende PHP Erweiterungen werden zusätzlich benötigt',
			'suggestedextensions' => 'Folgende PHP Erweiterungen werden empfohlen',
			'databaseexists' => 'Datenbank existiert bereits, Uberschreiben-Option oder anderen Namen wählen.',
			'unabletocreatedb' => 'Test-Datenbank konnte nicht erstellt werden',
			'unabletodropdb' => 'Test-Datenbank konnte nicht gelöscht werden',
			'mysqlusernameexists' => 'Der unprivilegierte Datenbank-Benutzer existiert bereits. Anderen Benutzername angeben oder vorhandenen Benutzer löschen.',
			'unabletocreateuser' => 'Test-Benutzer konnte nicht erstellt werden',
			'unabletodropuser' => 'Test-Benutzer konnte nicht gelöscht werden',
			'unabletoflushprivs' => 'Der privilegierte Benutzer kann Berechtigungen nicht übernehmen (FLUSH PRIVILEGES)',
			'nov4andnov6ip' => 'Es muss mindestens eine IPv4- oder IPv6-Adresse angegeben werden',
			'servernameneedstobevalid' => 'Der angegebene Server-Name scheint kein gültiger FQDN oder Hostname zu sein',
			'websrvuserdoesnotexist' => 'Der angegebene Webserver-Benutzer scheint auf dem System nicht zu existieren',
			'websrvgrpdoesnotexist' => 'Die angegebene Webserver-Gruppe scheint auf dem System nicht zu existieren',
			'notyetconfigured' => 'Es scheint als wären die Dienste (noch) nicht erfolgreich konfiguriert worden. Bitte den angezeigten Befehl ausführen oder überspringen (direkt zum Login)',
			'mandatory_field_not_set' => 'Pflichtfeld "%s" ist nicht gesetzt!',
			'unexpected_database_error' => 'Eine unerwarteter Datenbankfehler ist aufgetreten. %s',
			'sql_import_failed' => 'Der Import von SQL-Daten ist fehlgeschlagen!',
			'unprivileged_sql_connection_failed' => 'Unprivilegierte SQL-Verbindung konnte nicht initialisiert werden!',
			'privileged_sql_connection_failed' => 'Initialisierung der privilegierten SQL-Verbindung fehlgeschlagen!',
			'mysqldump_backup_failed' => 'Es kann keine Datenbanksicherung erstellt werden, wir haben einen Fehler von mysqldump erhalten.',
			'sql_backup_file_missing' => 'Es kann keine Datenbanksicherung erstellt werden, die Sicherungsdatei ist nicht vorhanden.',
			'backup_binary_missing' => 'Es kann keine Datenbanksicherung erstellen werden, stelle sicher, dass mysqldump installiert wurde.',
			'creating_configfile_failed' => 'Konfigurationsdateien können nicht erstellt werden, Datei kann nicht geschrieben werden.',
			'database_already_exiting' => 'Es existiert bereits eine Datenbank, diese darf aber nicht überschreiben werden!'
		]
	],
	'welcome' => [
		'title' => 'Willkommen bei froxlor!',
		'config_note' => 'Damit froxlor mit dem Backend vernünftig kommunizieren kann, musst du dieses noch konfigurieren.',
		'config_now' => 'Jetzt konfigurieren'
	],
];
