<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can also view it online at
 * https://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  the authors
 * @author     Froxlor team <team@froxlor.org>
 * @author     Luca Piona <info@havanastudio.ch>
 * @author     Luca Longinotti <chtekk@gentoo.org>
 * @author     Emilien
 * @license    https://files.froxlor.org/misc/COPYING.txt GPLv2
 */

return [
	'admin' => [
		'overview' => 'Generale',
		'ressourcedetails' => 'Risorse utilizzate',
		'systemdetails' => 'Dettagli sistema',
		'froxlordetails' => 'Dettagli Froxlor',
		'installedversion' => 'Versione installata',
		'latestversion' => 'Ultima versione disponibile',
		'lookfornewversion' => [
			'clickhere' => 'Cerca sul web',
			'error' => 'Errore durante la lettura',
		],
		'resources' => 'Risorse',
		'customer' => 'Cliente',
		'customers' => 'Clienti',
		'customer_add' => 'Crea cliente',
		'customer_edit' => 'Modifica cliente',
		'domains' => 'Domini',
		'domain_add' => 'Crea dominio',
		'domain_edit' => 'Modifica dominio',
		'subdomainforemail' => 'Sottodominio utilizzabile come dominio Email',
		'admin' => 'Admin',
		'admins' => 'Admin',
		'admin_add' => 'Crea admin',
		'admin_edit' => 'Modifica admin',
		'customers_see_all' => 'Può vedere tutti i clienti?',
		'change_serversettings' => 'Può cambiare le impostazioni del server?',
		'server' => 'Sistema',
		'serversettings' => 'Opzioni',
		'rebuildconf' => 'Rigenera configurazione',
		'stdsubdomain' => 'Sottodominio standard',
		'stdsubdomain_add' => 'Crea sottodominio standard',
		'phpenabled' => 'PHP abilitato',
		'deactivated' => 'Disattiva',
		'deactivated_user' => 'Disattiva utente',
		'sendpassword' => 'Invia password',
		'ownvhostsettings' => 'Impostazioni vHost speciali',
		'configfiles' => [
			'serverconfiguration' => 'Configurazione servizi',
			'overview' => 'Panoramica',
			'distribution' => 'Distribuzione',
			'service' => 'Servizio',
			'daemon' => 'Demone',
			'etc' => 'Altro (Sistema)',
			'choosedistribution' => '-- Scegli una distribuzione --',
			'chooseservice' => '-- Scegli un servizio --',
			'choosedaemon' => '-- Scegli un demone --',
			'statistics' => 'Statistiche',
			'compactoverview' => 'Visualizzazione-Compatta',
			'wizard' => 'Wizard (assistente)',
			'http' => 'Server WEB (HTTP)',
			'dns' => 'Nameserver (DNS)',
			'mail' => 'Server di posta elettronica (IMAP/POP3)',
			'smtp' => 'Server di posta elettronica (SMTP)',
			'ftp' => 'Server FTP',
		],
		'templates' => [
			'templates' => 'Template',
			'template_add' => 'Aggiungi template',
			'template_edit' => 'Modifica template',
			'action' => 'Azione',
			'email' => 'Email',
			'subject' => 'Soggetto:',
			'mailbody' => 'Testo dell\'Email',
			'createcustomer' => 'Email di benvenuto per i nuovi clienti',
			'pop_success' => 'Benvenuto per ogni nuovo account Email',
			'template_replace_vars' => 'Variabili da cambiare nel template:',
			'FIRSTNAME' => 'Rimpiazzato con il nome del cliente.',
			'NAME' => 'Rimpiazzato con il cognome del cliente.',
			'USERNAME' => 'Rimpiazzato con il nome utente dell\'account.',
			'PASSWORD' => 'Rimpiazzato con la password dell\'account.',
			'EMAIL' => 'Rimapiazzato con l\'indirizzo dell\'account.',
			'TRAFFIC' => 'Sostituito con il traffico che è stato assegnato al cliente.',
			'TRAFFICUSED' => 'Sostituito con il traffico che è stato usato dal cliente.',
			'pop_success_alternative' => 'Email di Benvenuto spedita all\'indirizzo alternativo per i nuovi account email',
			'EMAIL_PASSWORD' => 'Sostituito con la password dell\'account POP3/IMAP.',
			'index_html' => 'file index per le nuove cartelle create dai clienti',
			'SERVERNAME' => 'Sostituito con il nomeserver.',
			'CUSTOMER' => 'Sostituito con il nome utente del cliente.',
			'ADMIN' => 'Sostituito con il nome utente dell\'amministratore.',
			'CUSTOMER_EMAIL' => 'Sostituito con l\'indirizzo e-mail del cliente.',
			'ADMIN_EMAIL' => 'Sostituito con l\'indirizzo e-mail dell\'amministratore.',
			'filetemplates' => 'File Modelli',
			'filecontent' => 'Contenuto File',
			'new_database_by_customer' => 'Notifica al cliente quando un database è stato creato',
			'new_ftpaccount_by_customer' => 'Notifica al cliente quando un utente FTP è stato creato',
			'newdatabase' => 'Mail di notifica per i nuovi database',
			'newftpuser' => 'Mail di notifica per i nuovi utenti ftp',
			'CUST_NAME' => 'Nome del Cliente',
			'DB_NAME' => 'Nome del Database',
			'DB_PASS' => 'Password del Database',
			'DB_DESC' => 'Descrizione del Database',
			'DB_SRV' => 'Server del Database',
			'PMA_URI' => 'URL a phpMyAdmin (se presente)',
			'USR_NAME' => 'Nome utente FTP',
			'USR_PASS' => 'Password FTP',
			'USR_PATH' => 'Cartella utente FTP (rispetto alla cartella docroot del cliente)',
			'forgotpwd' => 'Mail di notifica per il reset della password',
			'password_reset' => 'Notifica al cliente per il reset della password',
			'trafficmaxpercent' => 'Mail di notifica per i clienti che hanno raggiunto il limite di traffico',
			'MAX_PERCENT' => 'Sostituito con spazio/limite di traffico per l\'invio dei report in precentuale.',
			'USAGE_PERCENT' => 'Sostituito con l\'utilizzo del disco/limite di traffico, che è stato esaurito da parte del cliente in percentuale.',
			'diskmaxpercent' => 'Mail di notifica per i clienti che hanno raggiunto il limite di spazio su disco',
			'DISKAVAILABLE' => 'Sostituito con il spazio utilizzato in MB, che è stato assegnato al cliente.',
			'DISKUSED' => 'Sostituito con il spazio utilizzato in MB, che è stato esaurito da parte del cliente.',
			'SALUTATION' => 'Sostituito con un saluto corretto (nome o azienda)',
			'COMPANY' => 'Sostituisce con il nome dell \'azienda del cliente',
			'LINK' => 'Sostituito con il link di azzeramento password cliente.',
			'SERVER_HOSTNAME' => 'Sostituisce il nome host del sistema (URL a froxlor)',
			'SERVER_IP' => 'Sostituisce l\'indrizzo IP predefinito del server',
			'SERVER_PORT' => 'Sostituisce la porta predefinita del server',
			'DOMAINNAME' => 'Sostituisce il sottodominio predefinito dei clienti (può essere vuoto se non viene generato)',
		],
		'webserver' => 'Webserver',
		'ipsandports' => [
			'ipsandports' => 'IP e Porte',
			'add' => 'Aggiungi IP/Porta',
			'edit' => 'Modifica IP/Porta',
			'ipandport' => 'IP/Porta',
			'ip' => 'IP',
			'port' => 'Porta',
			'create_listen_statement' => 'Crea la direttiva Listen',
			'create_namevirtualhost_statement' => 'Crea la direttiva NameVirtualHost',
			'create_vhostcontainer' => 'Crea vHost-Container',
			'create_vhostcontainer_servername_statement' => 'Crea la direttiva ServerName in vHost-Container',
			'enable_ssl' => 'Questa è una porta SSL?',
			'ssl_cert_file' => 'Percorso del certificato SSL (SSL certificate)',
			'webserverdefaultconfig' => 'Configurazione predefinita Webserver',
			'webserverdomainconfig' => 'Configurazione Dominio Webserver',
			'webserverssldomainconfig' => 'COnfigura SSL Webserver',
			'ssl_key_file' => 'Percorso al Keyfile SSL',
			'ssl_ca_file' => 'Percorso al CA certificate SSL',
			'default_vhostconf_domain' => 'Impostazioni predefinite vhost per ogni contenitore di dominio',
			'docroot' => [
				'title' => 'Imposta Cartella principale (vuoto = va in Froxlor)',
				'description' => 'Qui puoi definire una tua cartella principale (la destinazione di una richiesta) per questa combinazione IP/Porta.<br /><strong>ATTENZIONE:</strong> Fai molta attenzione a quello che scrivi qui!',
			],
			'ssl_cert_chainfile' => [
				'title' => 'Percorso al file catena dei certificati SSL',
				'description' => 'Principalmente Bundle CA, o similare, presubilmente vuoi impostare questo se hai acquistato un certificato SSL.',
			],
			'ssl_paste_description' => 'Incolla il contenuto completo del tuo certificato nella casella di testo',
			'ssl_cert_file_content' => 'Contenuto del certificato ssl',
			'ssl_key_file_content' => 'Contenuto del file di chiave (privata) ssl',
			'ssl_ca_file_content' => 'Contenuto del file ssl CA di autorità di certificazione (opzionale)',
			'ssl_ca_file_content_desc' => '<br /><br />Autenticazione client, imposta questo settaggio soltanto se sai di cosa si tratta.',
			'ssl_cert_chainfile_content' => 'Contenuto del file di catena di certificato (opzionale)',
			'ssl_cert_chainfile_content_desc' => '<br /><br />Abitualmente Bundle CA o similare, probabilmente vuoi impostare questo settaggio se hai acquistato un certificato SSL.',
		],
		'memorylimitdisabled' => 'Disabilitato',
		'valuemandatory' => 'Questo valore è obbligatorio',
		'valuemandatorycompany' => 'O i campi "nome" e "cognome" O il capo "compagnia" devono essere riempiti',
		'phpversion' => 'Versione PHP',
		'mysqlserverversion' => 'Versione MySQL Server',
		'webserverinterface' => 'Interfaccia Webserver',
		'accountsettings' => 'Impostazioni Account',
		'panelsettings' => 'Impostazioni Pannello',
		'systemsettings' => 'Impostazioni di Sistema',
		'webserversettings' => 'Impostazioni Server Web',
		'mailserversettings' => 'Impostazioni Server di Posta',
		'nameserversettings' => 'Impostazioni Nameserver',
		'updatecounters' => 'Ricalcolo risorse',
		'subcanemaildomain' => [
			'never' => 'Mai',
			'choosableno' => 'Selezionabile, predefinito no',
			'choosableyes' => 'Selezionabile, predefinito si',
			'always' => 'Sempre',
		],
		'webalizersettings' => 'Impostazioni Webalizer',
		'webalizer' => [
			'normal' => 'Normale',
			'quiet' => 'Modesto',
			'veryquiet' => 'Niente',
		],
		'domain_nocustomeraddingavailable' => 'Adesso non è possibile aggiungere un dominio. Prima è necessario aggiungere almeno un cliente.',
		'loggersettings' => 'Impostazioni Log',
		'logger' => [
			'normal' => 'normale',
			'paranoid' => 'paranoico',
		],
		'emaildomain' => 'Email dominio',
		'email_only' => 'Solo email?',
		'wwwserveralias' => 'Aggiungi a "www." ServerAlias',
		'subject' => 'Oggetto',
		'recipient' => 'Destinatario',
		'message' => 'Scrivi un messaggio',
		'text' => 'Messaggio',
		'sslsettings' => 'Impostazioni SSL',
		'dkimsettings' => 'Impostazioni DomainKey',
		'caneditphpsettings' => 'È possibile modificare le impostazioni di dominio relative a php?',
		'allips' => 'Tutti gli IP',
		'awstatssettings' => 'Impostazioni Awstats',
		'domain_dns_settings' => 'Impostazioni dominio dns',
		'activated' => 'Attivato',
		'statisticsettings' => 'Impostazioni Statistiche',
		'or' => 'o',
		'sysload' => 'Carico del sistema',
		'noloadavailable' => 'non disponibile',
		'nouptimeavailable' => 'non disponibile',
		'nosubject' => '(Nessun Oggetto)',
		'security_settings' => 'Opzioni di Sicurezza',
		'know_what_youre_doing' => 'Modifica solo, se sai quello che stai facendo!',
		'show_version_login' => [
			'title' => 'Mostra la versione di Froxlor quando si effettua l\'accesso',
			'description' => 'Mostra la versione di Froxlor in fondo-pagina di accesso',
		],
		'show_version_footer' => [
			'title' => 'Mostra la versione di Froxlor in fondo-pagina',
			'description' => 'Mostra la versione di Froxlor in fondo ad ogni pagina',
		],
		'froxlor_graphic' => [
			'title' => 'Intestazione grafica per Froxlor',
			'description' => 'Quale grafica vuoi mostrare nell\'intestazione?',
		],
		'phpsettings' => [
			'title' => 'Configurazione PHP',
			'description' => 'Descrizione breve',
			'actions' => 'Azioni',
			'activedomains' => 'In uso per dominio/i',
			'notused' => 'Configurazione non utilizzata',
			'editsettings' => 'Modific impostazioni PHP',
			'addsettings' => 'Crea una nuova impostazione PHP',
			'viewsettings' => 'Mostra impostazioni PHP',
			'phpinisettings' => 'Impostazioni php.ini',
			'addnew' => 'Crea nuove impostazioni',
			'binary' => 'PHP Binary',
			'file_extensions' => 'Estensioni File',
			'file_extensions_note' => '(senza punto, separate da spazi)',
			'enable_slowlog' => 'Abilita slowlog (per dominio)',
			'request_terminate_timeout' => 'Richiedi terminate-timeout',
			'request_slowlog_timeout' => 'Richiedi slowlog-timeout',
		],
		'misc' => 'Varie',
		'phpconfig' => [
			'template_replace_vars' => 'Variabili che saranno sostituite nei file di configurazione',
			'pear_dir' => 'Verrà sostituito con le impostazioni globali per la cartella pear.',
			'open_basedir_c' => 'Inserirà un ; (punto e virgola) per commentare/disabilitare open_basedir se impostato',
			'open_basedir' => 'Verrà sostituito con l\'impostazione open_basedir del dominio.',
			'tmp_dir' => 'Verrà sostituito con la cartella temporanea del dominio.',
			'open_basedir_global' => 'Verrà sostituito con il valore globale del percorso che sarà allegato al open_basedir',
			'customer_email' => 'Verrà sostituito con l\'indirizzo email del cliente che possiede questo dominio.',
			'admin_email' => 'Verrà sostituito con l\'indirizzo email dell\'amministratore di questo dominio.',
			'domain' => 'Verrà sostituito con il dominio.',
			'customer' => 'Verrà sostituito con il nome utente del cliente che possiede questo dominio.',
			'admin' => 'Verrà sostituito con il nome utente dell\'amministratore che possiede questo dominio.',
		],
		'expert_settings' => 'Impostazioni Avanzate!',
		'mod_fcgid_starter' => [
			'title' => 'Processi PHP per questo dominio (vuoto per lasciare il valore predefinito)',
		],
		'phpserversettings' => 'Impostazioni PHP',
		'mod_fcgid_maxrequests' => [
			'title' => 'Richieste PHP massime per questo dominio (vuoto per lasciare il valore predefinito)',
		],
		'spfsettings' => 'Impostazioni Dominio SPF',
		'specialsettingsforsubdomains' => 'Applica le impostazioni speciali a tutti i sottodomini (*.esempio.com)',
		'accountdata' => 'Dati conto',
		'contactdata' => 'Dati contatto',
		'servicedata' => 'Dati di servizio',
		'newerversionavailable' => 'È disponibile una nuova versione di Floxlor',
		'cron' => [
			'cronsettings' => 'Impostazioni Cronjob',
			'add' => 'Aggiungi cronjob',
		],
		'cronjob_edit' => 'Modifica cronjob',
		'warning' => 'ATTENZIONE - Leggi attentamente!',
		'lastlogin_succ' => 'Ultimo accesso',
		'ftpserver' => 'Server FTP',
		'ftpserversettings' => 'Impostazioni del Server FTP',
		'webserver_user' => 'Utente Webserver',
		'webserver_group' => 'Gruppo Webserver',
		'perlenabled' => 'Perl abilitato',
		'fcgid_settings' => 'FCGID',
		'mod_fcgid_user' => 'Utente locale per FCGID (Froxlor vhost)',
		'mod_fcgid_group' => 'Gruppo locale per FCGID (Froxlor vhost)',
		'perl_settings' => 'Perl/CGI',
		'notgiven' => '[se presente]',
		'phpfpm_settings' => 'PHP-FPM',
		'traffic' => 'Traffico',
		'domaintraffic' => 'Domimi',
		'customertraffic' => 'Clienti',
		'serversoftware' => 'Software per Server',
		'store_defaultindex' => 'Archivio del file indice predefinito al percorso radice clienti',
		'assignedmax' => 'Assegnato / Max',
		'usedmax' => 'Usato / Max',
		'used' => 'Usato',
		'speciallogwarning' => '<div id="speciallogfilenote" class="invalid-feedback">AVVISO: Cambiando questa impostazione perderai tutte le vecchie statistiche per questo dominio.</div>',
		'speciallogfile' => [
			'title' => 'File file log seperato',
			'description' => 'Spunta qui per un log di accesso separato per questo dominio',
		],
		'domain_editable' => [
			'title' => 'Permetti la modifica del dominio',
			'desc' => 'Se settato a si, il cliente è abilitato a modificare varie impostazioni del dominio.<br />Se settato su no, il cliente non può modificare nulla.',
		],
		'phpfpm.ininote' => 'Non tutti i valori che potresti volere settare possono essere usati nella configurazione del pool php-fpm.',
		'phpinfo' => 'PHPinfo()',
		'selectserveralias' => 'valore ServerAlias per il dominio',
		'selectserveralias_desc' => 'Scegli se froxlor deve creare un settaggio wildcard (*.dominio.tld), o un alias WWW (www.dominio.tld) o nessun alias',
		'show_news_feed' => 'Mostra il feed notizie sul cruscotto dell \'amministratore',
		'cronsettings' => 'Impostazioni Cronjob',
		'integritycheck' => 'Validazione Database',
		'integrityid' => '#',
		'integrityname' => 'Nome',
		'integrityresult' => 'Risultato',
		'integrityfix' => 'Risolvi problemi automaticamente',
		'customer_show_news_feed' => 'Mostra feed di notizie personalizzati sul cruscotto dei clienti',
		'customer_news_feed_url' => 'Feed RSS- per il feed di notizie personalizzato',
		'movetoadmin' => 'Trasferisci cliente',
		'movecustomertoadmin' => 'Trasferisci cliente all\'amministratore/rivenditore selezionato<br /><small>Lascia questo vuoto per nessuna modifica.<br />Se l\'amministratore desiderato non appare nella lista, il suo massimale di clienti e stato ragggiunto.</small>',
		'note' => 'Nota',
	],
	'changepassword' => [
		'old_password' => 'Vecchia password',
		'new_password' => 'Nuova password',
		'new_password_confirm' => 'Nuova password (verifica)',
		'new_password_ifnotempty' => 'Nuova password (vuota = non cambia)',
		'also_change_ftp' => ' cambia la password dell\'account FTP principale?',
		'also_change_stats' => ' modificare anche la password di statistic',
	],
	'country' => [
		'AF' => 'Afganistan',
		'AX' => 'Isole Aland',
		'AL' => 'Albania',
		'DZ' => 'Algeria',
		'AS' => 'American Samoa',
		'AD' => 'Andorra',
		'AO' => 'Angola',
		'AI' => 'Anguilla',
		'AQ' => 'Antarctica',
		'AG' => 'Antigua and Barbuda',
		'AR' => 'Argentina',
		'AM' => 'Armenia',
		'AW' => 'Aruba',
		'AU' => 'Australia',
		'AT' => 'Austria',
		'AZ' => 'Azerbaijan',
		'BS' => 'Bahamas',
		'BH' => 'Bahrain',
		'BD' => 'Bangladesh',
		'BB' => 'Barbados',
		'BY' => 'Belarus',
		'BE' => 'Belgium',
		'BZ' => 'Belize',
		'BJ' => 'Benin',
		'BM' => 'Bermuda',
		'BT' => 'Bhutan',
		'BO' => 'Bolivia, Stato Plurinazionale della',
		'BQ' => 'Bonaire, Saint Eustatius e Saba',
		'BA' => 'Bosnia e Herzegovina',
		'BW' => 'Botswana',
		'BV' => 'Bouvet Island',
		'BR' => 'Brasile',
		'IO' => 'Territorio Britannico del oceano indiano',
		'BN' => 'Brunei Darussalam',
		'BG' => 'Bulgaria',
		'BF' => 'Burkina Faso',
		'BI' => 'Burundi',
		'KH' => 'Cambogia',
		'CM' => 'Camerun',
		'CA' => 'Canada',
		'CV' => 'Capo Verde',
		'KY' => 'Isole Cayman',
		'CF' => 'Repubblica dell\'Africa Centrale',
		'TD' => 'Chad',
		'CL' => 'Chile',
		'CN' => 'Cina',
		'CX' => 'Isola di Natale',
		'CC' => 'Isole Cocos (Keeling)',
		'CO' => 'Colombia',
		'KM' => 'Comoros',
		'CG' => 'Congo',
		'CD' => 'Congo, Repubblica democratica del',
		'CK' => 'Isole Cook',
		'CR' => 'Costa Rica',
		'CI' => 'Costa D\'avorio',
		'HR' => 'Croazia',
		'CU' => 'Cuba',
		'CW' => 'Curacao',
		'CY' => 'Cipro',
		'CZ' => 'Repubblica Ceca',
		'DK' => 'Danimarca',
		'DJ' => 'Djibouti',
		'DM' => 'Dominica',
		'DO' => 'Repubblica Dominicana',
		'EC' => 'Ecuador',
		'EG' => 'Egitto',
		'SV' => 'El Salvador',
		'GQ' => 'Guinea Equatoriale',
		'ER' => 'Eritrea',
		'EE' => 'Estonia',
		'ET' => 'Etiopia',
		'FK' => 'Isole Falkland (Malvinas)',
		'FO' => 'Isole Faroe',
		'FJ' => 'Fiji',
		'FI' => 'Finlandia',
		'FR' => 'Francia',
		'GF' => 'Guiana Francese',
		'PF' => 'Polinesia Francese',
		'TF' => 'Territori Francesi del Sud',
		'GA' => 'Gabon',
		'GM' => 'Gambia',
		'GE' => 'Georgia',
		'DE' => 'Germania',
		'GH' => 'Ghana',
		'GI' => 'Gibilterra',
		'GR' => 'Grecia',
		'GL' => 'Groenlandia',
		'GD' => 'Grenada',
		'GP' => 'Guadeloupe',
		'GU' => 'Guam',
		'GT' => 'Guatemala',
		'GG' => 'Guernsey',
		'GN' => 'Guinea',
		'GW' => 'Guinea-Bissau',
		'GY' => 'Guyana',
		'HT' => 'Haiti',
		'HM' => 'Isola Heard e Isola McDonald',
		'VA' => 'Stato del Vaticano',
		'HN' => 'Honduras',
		'HK' => 'Hong Kong',
		'HU' => 'Ungheria',
		'IS' => 'Islanda',
		'IN' => 'India',
		'ID' => 'Indonesia',
		'IR' => 'Iran, Repubblica Islamica del',
		'IQ' => 'Iraq',
		'IE' => 'Irlanda',
		'IM' => 'Isola Man',
		'IL' => 'Israele',
		'IT' => 'ITALIA',
		'JM' => 'Giamaica',
		'JP' => 'Giappone',
		'JE' => 'Jersey',
		'JO' => 'Giordania',
		'KZ' => 'Kazakistan',
		'KE' => 'Kenya',
		'KI' => 'Kiribati',
		'KP' => 'Corea, Repubblica popolare della',
		'KR' => 'Corea, Repubblica della',
		'KW' => 'Kuwait',
		'KG' => 'Kyrgyzstan',
		'LA' => 'Lao, Repubblica popolare del',
		'LV' => 'Lettonia',
		'LB' => 'Libano',
		'LS' => 'Lesotho',
		'LR' => 'Liberia',
		'LY' => 'Libia',
		'LI' => 'Liechtenstein',
		'LT' => 'Lituania',
		'LU' => 'Lussemburgo',
		'MO' => 'Macao',
		'MK' => 'Macedonia',
		'MG' => 'Madagascar',
		'MW' => 'Malawi',
		'MY' => 'Malesia',
		'MV' => 'Maldive',
		'ML' => 'Mali',
		'MT' => 'Malta',
		'MH' => 'Isole Marshall',
		'MQ' => 'Martinique',
		'MR' => 'Mauritania',
		'MU' => 'Mauritius',
		'YT' => 'Mayotte',
		'MX' => 'Messico',
		'FM' => 'Micronesia, Stati Federali del',
		'MD' => 'Moldavia',
		'MC' => 'Monaco',
		'MN' => 'Mongolia',
		'ME' => 'Montenegro',
		'MS' => 'Montserrat',
		'MA' => 'Marocco',
		'MZ' => 'Mozambico',
		'MM' => 'Myanmar',
		'NA' => 'Namibia',
		'NR' => 'Nauru',
		'NP' => 'Nepal',
		'NL' => 'Olanda',
		'NC' => 'Nuova Caledonia',
		'NZ' => 'Nuova Zelanda',
		'NI' => 'Nicaragua',
		'NE' => 'Niger',
		'NG' => 'Nigeria',
		'NU' => 'Niue',
		'NF' => 'Isole Norfolk',
		'MP' => 'Isole Mariana Settentrionali',
		'NO' => 'Norvegia',
		'OM' => 'Oman',
		'PK' => 'Pakistan',
		'PW' => 'Palau',
		'PS' => 'Territorio Occupato della Palestina',
		'PA' => 'Panama',
		'PG' => 'Papua Nuova Guinea',
		'PY' => 'Paraguay',
		'PE' => 'Peru',
		'PH' => 'Filippine',
		'PN' => 'Pitcairn',
		'PL' => 'Polonia',
		'PT' => 'Portogallo',
		'PR' => 'Porto Rico',
		'QA' => 'Qatar',
		'RE' => 'Reunion',
		'RO' => 'Romania',
		'RU' => 'Russia',
		'RW' => 'Ruanda',
		'BL' => 'Saint Barthelemy',
		'SH' => 'Saint Helena, Ascension and Tristan Da Cunha',
		'KN' => 'Saint Kitts and Nevis',
		'LC' => 'Saint Lucia',
		'MF' => 'Saint Martin (French Part)',
		'PM' => 'Saint Pierre and Miquelon',
		'VC' => 'Saint Vincent and the Grenadines',
		'WS' => 'Samoa',
		'SM' => 'San Marino',
		'ST' => 'Sao Tome and Principe',
		'SA' => 'Arabia Saudita',
		'SN' => 'Senegal',
		'RS' => 'Serbia',
		'SC' => 'Seychelles',
		'SL' => 'Sierra Leone',
		'SG' => 'Singapore',
		'SX' => 'Sint Maarten (Dutch Part)',
		'SK' => 'Slovacchia',
		'SI' => 'Slovenia',
		'SB' => 'Isole Solomon',
		'SO' => 'Somalia',
		'ZA' => 'Africa del Sud',
		'GS' => 'South Georgia and the South Sandwich Islands',
		'ES' => 'Spagna',
		'LK' => 'Sri Lanka',
		'SD' => 'Sudan',
		'SR' => 'Suriname',
		'SJ' => 'Svalbard and Jan Mayen',
		'SZ' => 'Swaziland',
		'SE' => 'Svezia',
		'CH' => 'Svizzera',
		'SY' => 'Siria',
		'TW' => 'Taiwan, Provincia della Cina',
		'TJ' => 'Tajikistan',
		'TZ' => 'Tanzania',
		'TH' => 'Tailandia',
		'TL' => 'Timor-Leste',
		'TG' => 'Togo',
		'TK' => 'Tokelau',
		'TO' => 'Tonga',
		'TT' => 'Trinidad and Tobago',
		'TN' => 'Tunisia',
		'TR' => 'Turchia',
		'TM' => 'Turkmenistan',
		'TC' => 'Turks and Caicos Islands',
		'TV' => 'Tuvalu',
		'UG' => 'Uganda',
		'UA' => 'Ucraina',
		'AE' => 'Emirati Arabi Uniti',
		'GB' => 'Gran Bretagna',
		'US' => 'Stati Uniti d\'America',
		'UM' => 'Stati Uniti, Isole Minori',
		'UY' => 'Uruguay',
		'UZ' => 'Uzbekistan',
		'VU' => 'Vanuatu',
		'VE' => 'Venezuela',
		'VN' => 'Vietnam',
		'VG' => 'Isole Vergini Brittaniche',
		'VI' => 'Isole Vergini, U.S.',
		'WF' => 'Wallis and Futuna',
		'EH' => 'Sahara Occidentale',
		'YE' => 'Yemen',
		'ZM' => 'Zambia',
		'ZW' => 'Zimbabue',
	],
	'cron' => [
		'cronname' => 'Nome cronjob',
		'lastrun' => 'ultima esecuzione',
		'interval' => 'intervallo',
		'isactive' => 'abilitato',
		'description' => 'descrizione',
		'changewarning' => 'La modifica di questi valori può avere conseguenze negative nel comportamento di Froxlor e dei suoi processi automatizzati<br />Per favore modifica questi valori solo se sei sicuro di quello che stai facendo!',
	],
	'crondesc' => [
		'cron_unknown_desc' => 'nessuna descrizione fornita',
		'cron_tasks' => 'generazione del file di configurazione',
		'cron_legacy' => 'legacy (vecchi) cronjob',
		'cron_traffic' => 'calcolo del traffico',
		'cron_usage_report' => 'Invia i report di utilizzo web e del traffico',
		'cron_mailboxsize' => 'Calcolo dimensioni caselle di posta',
	],
	'cronjob' => [
		'cronjobsettings' => 'impostazioni Cronjob',
		'cronjobinterval' => 'Durata intervallo',
		'cronjobintervalv' => 'valore di intervallo Runtime',
	],
	'cronjobs' => [
		'notyetrun' => 'Non ancora avviato',
	],
	'cronmgmt' => [
		'minutes' => 'minuti',
		'hours' => 'ore',
		'days' => 'giorni',
		'weeks' => 'settimane',
		'months' => 'mesi',
	],
	'customer' => [
		'documentroot' => 'Cartella Principale',
		'name' => 'Cognome',
		'firstname' => 'Nome',
		'company' => 'Ditta',
		'street' => 'Via',
		'zipcode' => 'CAP',
		'city' => 'Città',
		'phone' => 'Telefono',
		'fax' => 'Fax',
		'email' => 'Email',
		'customernumber' => 'ID Cliente',
		'diskspace' => 'Spazio Web (MB)',
		'traffic' => 'Traffico (GB)',
		'mysqls' => 'Database MySQL',
		'emails' => 'Indirizzi Email',
		'accounts' => 'Account Email',
		'forwarders' => 'Reindirizzamenti Email',
		'ftps' => 'Account FTP',
		'subdomains' => 'Sottodomini',
		'domains' => 'Domini',
		'title' => 'Titolo',
		'country' => 'Paese',
		'email_quota' => 'Limite E-mail',
		'email_imap' => 'E-mail IMAP',
		'email_pop3' => 'E-mail POP3',
		'mail_quota' => 'Limite Mail',
		'sendinfomail' => 'Inviami i dati via email',
		'generated_pwd' => 'Password suggerita',
		'usedmax' => 'Usato / Massimo',
		'services' => 'Servizi',
	],
	'diskquota' => 'Quota',
	'dns' => [
		'destinationip' => 'Dominio IP',
		'a_record' => 'A-Record (IPv6 optionale)',
		'mxrecords' => 'Definisci MX records',
		'txtrecords' => 'Definisci TXT records',
		'txtexample' => 'Esempio (SPF-entry):<br />v=spf1 ip4:xxx.xxx.xx.0/23 -all',
		'standardip' => 'IP predefinito del server',
		'cname_record' => 'Record CNAME',
		'standardmx' => 'Record MX predefinito del server',
		'mxconfig' => 'Record MX personalizzati',
		'priority10' => 'Priorità 10',
		'priority20' => 'Priorità 20',
	],
	'domain' => [
		'openbasedirpath' => 'Percorso OpenBasedir',
		'docroot' => 'Percorso del campo sopra',
		'homedir' => 'Cartella Home',
	],
	'domains' => [
		'description' => 'Qui puoi creare (sotto)domini e cambiare il loro percorso.<br />Il sistema, dopo ogni cambiamento, necessita di un po\' di tempo per applicare le nuove impostazioni.',
		'domainsettings' => 'Opzioni del dominio',
		'domainname' => 'Nome del dominio',
		'subdomain_add' => 'Crea sottodominio',
		'subdomain_edit' => 'Modifica il (sotto)dominio',
		'wildcarddomain' => 'Crea una wildcarddomain?',
		'aliasdomain' => 'Alias per questo dominio',
		'noaliasdomain' => 'Nessun alias per il dominio',
		'hasaliasdomains' => 'Ha domini alias',
		'statstics' => 'Statistiche d\'utilizzo',
		'isassigneddomain' => 'È dominio assegnato',
		'add_date' => 'Aggiunto a Froxlor',
		'registration_date' => 'Aggiunto al registro',
		'topleveldomain' => 'Dominio di primo livello (TLD)',
		'associated_with_domain' => 'Associato',
		'aliasdomains' => 'Alias domini',
		'redirectifpathisurl' => 'Codice di redirezione (Predefinito: vuoto)',
		'redirectifpathisurlinfo' => 'È necessario selezionare uno di questi se hai inserito un URL come percorso',
		'ipandport_multi' => [
			'title' => 'Indirizzi IP',
			'description' => 'Specifica uno o più indirizzi IP per il dominio.<br /><br /><div class="text-danger">NOTA: L\'indirizzo IP non può essere modificato quando il dominio è configurato come <strong>alias-domain</strong> di un altro dominio.</div>',
		],
		'ipandport_ssl_multi' => [
			'title' => 'Indirizzi IP SSL',
		],
		'ssl_redirect' => [
			'title' => 'Reindirizzamento SSL',
			'description' => 'Questa opzione crea un reindirizzamento per vhosts non-sll in modo che tutte le richieste vengono reindirizzate ai SSL-vhost.<br /><br />praticamente una richiesta a <strong>http</strong>://dominio.tld/ ti reindirizzera a <strong>https</strong>://dominio.tld/',
		],
		'serveraliasoption_wildcard' => 'Wildcard (*.dominio.tld)',
		'serveraliasoption_www' => 'WWW (www.dominio.tld)',
		'serveraliasoption_none' => 'Nessun alias',
		'domain_import' => 'Importa Dominii',
		'import_separator' => 'Separatore',
		'import_offset' => 'Offset',
		'import_file' => 'File CSV',
		'import_description' => 'Per ottenere informazioni dettagliate sulla struttura del file di importazione e  su come importare con successo, visita <a href="https://docs.froxlor.org/latest/admin-guide/domain-import/" target="_blank">https://docs.froxlor.org/latest/admin-guide/domain-import/</a>',
	],
	'emails' => [
		'description' => 'Qui puoi creare e cambiare i tuoi indirizzi Email.<br />Un account è come la bucalettere davanti a casa tua. Se qualcuno ti manda un\'Email, essa sarà recapitata all\'interno del tuo account.<br /><br />Per scaricare le tue Email usa le seguenti impostazioni nel tuo programma di posta elettronica: (I dati scritti in <i>corsivo</i> vanno cambiati con i tuoi!)<br />Hostname: <b><i>Nome del dominio</i></b><br />Username: <b><i>Nome dell\'account / Indirizzo Email</i></b><br />Password: <b><i>La password scelta</i></b>',
		'emailaddress' => 'Indirizzo Email',
		'emails_add' => 'Crea indirizzo Email',
		'emails_edit' => 'Modifica indirizzo Email',
		'catchall' => 'Catch-all',
		'iscatchall' => 'Definisci come indirizzo catch-all?',
		'account' => 'Account',
		'account_add' => 'Crea account',
		'account_delete' => 'Cancella account',
		'from' => 'Da',
		'to' => 'Per',
		'forwarders' => 'Reindirizzamenti',
		'forwarder_add' => 'Crea reindirizzamento',
		'alternative_emailaddress' => 'Indirizzo email alternativo',
		'quota' => 'Limite',
		'noquota' => 'Nessun limite',
		'updatequota' => 'Aggiorna Limite',
		'quota_edit' => 'Cambia limite E-Mail',
		'noemaildomainaddedyet' => 'Non hai ancora un (email-)dominio nel tuo account.',
		'back_to_overview' => 'Torna indietro nel riepilogo',
	],
	'error' => [
		'error' => 'Errore',
		'directorymustexist' => 'La cartella %s deve esistere. Per favore creala tramite il tuo client FTP.',
		'filemustexist' => 'Il file %s deve esistere.',
		'allresourcesused' => 'Hai già usato tutte le tue risorse.',
		'domains_cantdeletemaindomain' => 'Non puoi cancellare un dominio usato come dominio Email.',
		'domains_canteditdomain' => 'Non puoi modificare questo dominio. La funzione è stata disabilitata dall\'admin.',
		'domains_cantdeletedomainwithemail' => 'Non puoi cancellare un dominio usato come dominio Email. Cancella prima tutti gli indirizzi Email che lo utilizzano.',
		'firstdeleteallsubdomains' => 'Prima di creare un dominio wildcard, cancella tutti i sottodomini presenti per quel dominio.',
		'youhavealreadyacatchallforthisdomain' => 'Hai già definito un catchall per questo dominio.',
		'ftp_cantdeletemainaccount' => 'Non puoi cancellare il tuo account FTP principale.',
		'login' => 'Il nome utente o la password da te immessi sono incorretti. Per favore riprova!',
		'login_blocked' => 'Questo account è stato sospeso per i troppi tentativi di login falliti. <br />Riprovi tra %s secondi.',
		'notallreqfieldsorerrors' => 'Alcuni campi sono stati lasciati vuoti o sono stati riempiti incorrettamente.',
		'oldpasswordnotcorrect' => 'La vecchia password non è corretta.',
		'youcantallocatemorethanyouhave' => 'Non puoi assegnare più risorse di quante ne possieda tu stesso.',
		'mustbeurl' => 'Non hai inserito un\'indirizzo valido o completo (per es. http://qualchedominio.com/errore404.htm).',
		'invalidpath' => 'Non hai scelto un\'indirizzo valido.',
		'stringisempty' => 'Manca il dato nel campo.',
		'stringiswrong' => 'Dato incorretto.',
		'newpasswordconfirmerror' => 'La nuova password non corrisponde a quella vecchia.',
		'mydomain' => '\'Dominio\'',
		'mydocumentroot' => '\'Documentroot\'',
		'loginnameexists' => 'Il login %s esiste già.',
		'emailiswrong' => 'L\'indirizzo Email %s contiene caratteri invalidi o è incompleto.',
		'loginnameiswrong' => 'Il login %s contiene caratteri invalidi.',
		'userpathcombinationdupe' => 'La combinazione tra nome utente e percorso esiste già.',
		'patherror' => 'Errore! Il percorso non può essere vuoto.',
		'errordocpathdupe' => 'Le opzioni per la cartella %s esistono già.',
		'adduserfirst' => 'Per favore crea prima un utente ...',
		'domainalreadyexists' => 'Il dominio %s è già assegnato ad un cliente.',
		'nolanguageselect' => 'Nessuna lingua selezionata.',
		'nosubjectcreate' => 'Devi definire un titolo per questo template Email.',
		'nomailbodycreate' => 'Devi definiro un testo per questo template Email.',
		'templatenotfound' => 'Il template non è stato trovato.',
		'alltemplatesdefined' => 'Non puoi definire altri template, tutte le lingue sono già definite.',
		'wwwnotallowed' => 'www non è ammesso come sottodominio.',
		'subdomainiswrong' => 'Il sottodominio %s contiene caratteri invalidi.',
		'domaincantbeempty' => 'Il nome dominio non può essere vuoto.',
		'domainexistalready' => 'Il dominio %s esiste già.',
		'domainisaliasorothercustomer' => 'Il dominio alias selezionato è a sua volta un dominio alias o appartiene ad un altro cliente.',
		'emailexistalready' => 'L\'indirizzo Email %s esiste già.',
		'maindomainnonexist' => 'Il dominio principale %s non esiste.',
		'destinationnonexist' => 'Per favore crea il tuo reindirizzamento nel campo \'Destinazione\'.',
		'destinationalreadyexistasmail' => 'Il reindirizzamento a %s esiste già come indirizzo Email attivo.',
		'destinationalreadyexist' => 'Hai già definito un reindirizzamento per %s .',
		'destinationiswrong' => 'Il reindirizzamento %s contiene caratteri invalidi o è incompleto.',
		'ipstillhasdomains' => 'La combinazione IP/Porta che vuoi eliminare ha ancora dei domini assegnati, per favore riassegna questi domini ad altre combinazioni IP/Porta prima di eliminare questa.',
		'cantdeletedefaultip' => 'Non puoi eliminare la combinazione IP/Porta default dei rivenditori, per favore imposta un\'altra combinazione IP/Porta come default dei rivenditori prima di eliminare questa.',
		'cantdeletesystemip' => 'Non puoi eliminare l\'ultima IP di sistema, crea un\'altra combinazione IP/Porta per l\'IP di sistema o cambia l\'IP di sistema.',
		'myipaddress' => '\'IP\'',
		'myport' => '\'Porta\'',
		'myipdefault' => 'Devi selezionare una combinazione IP/Porta che diventerà default.',
		'myipnotdouble' => 'Questa combinazione IP/Porta esiste già.',
		'admin_domain_emailsystemhostname' => 'Spiacente, l\'hostname di sistema non può essere usato come dominio di un cliente',
		'cantchangesystemip' => 'Non puoi cambiare l\'ultima IP di sistema, crea un\'altra combinazione IP/Porta per l\'IP di sistema o cambia l\'IP di sistema.',
		'loginnameissystemaccount' => 'Non puoi creare account che siano analoghi a quelli di sistema (per esempio quelli che iniziano con "%s"). Digita un\'altro nome account.',
		'sessiontimeoutiswrong' => '"Timeout Sessione" deve essere un numero.',
		'maxloginattemptsiswrong' => '"Numero Massimo Tentativi Login" deve essere un numero.',
		'deactivatetimiswrong' => '"Durata Disattivamento" deve essere un numero.',
		'accountprefixiswrong' => '&quopt;Prefisso Utente" incorretto.',
		'mysqlprefixiswrong' => '&quopt;Prefisso SQL" incorretto.',
		'ftpprefixiswrong' => '&quopt;Prefisso FTP" incorretto.',
		'ipiswrong' => '"Indirizzo IP" incorretto. È permesso solo un indirizzo IP valido.',
		'vmailuidiswrong' => '"UID Email" incorretto. È permessa solo una UID numerica.',
		'vmailgidiswrong' => '"GID Email" incorretto. È permessa solo una GID numerica.',
		'adminmailiswrong' => '"Mittente" incorretto. È permesso solo un indirizzo Email valido.',
		'pagingiswrong' => 'Valore degli "Elementi da visualizzare per pagina" incorretto. Sono permessi solo numeri.',
		'phpmyadminiswrong' => 'Il link a phpMyAdmin è invalido.',
		'webmailiswrong' => 'Il link alla WebMail è invalido.',
		'webftpiswrong' => 'Il link al WebFTP è invalido.',
		'stringformaterror' => 'Il valore per il campo "%s" non è nel formato atteso.',
		'youcantdeleteyourself' => 'Non puoi cancellare te stesso per motivi di sicurezza.',
		'youcanteditallfieldsofyourself' => 'Nota: non puoi modificare tutti i campi del tuo account per motivi di sicurezza.',
		'documentrootexists' => 'La cartella "%s" è già presente per questo cliente. Cancella la cartella prima di aggiungere nuovamente il cliente.',
		'formtokencompromised' => 'La richiesta sembra essere compromessa. Per motivi di sicurezza sei stato disconnesso.',
		'logerror' => 'Errore Log: %s',
		'nomessagetosend' => 'Non hai inserito un messaggio.',
		'norecipientsgiven' => 'Non hai specificato alcun destinatario',
		'errorsendingmail' => 'Il messaggio a "%s" fallito',
		'cannotreaddir' => 'Impossibile leggere la cartella "%s"',
		'invalidip' => 'Indirizzo IP non valido: %s',
		'invalidmysqlhost' => 'Indirizzo MySQL non valido: %s',
		'cannotuseawstatsandwebalizeratonetime' => 'Non è possibile abilitare Webalizer e Awstats allo stesso tempo, si prega di sceglierne uno solo',
		'cannotwritetologfile' => 'Impossibile aprire il file di log %s in scrittura',
		'vmailquotawrong' => 'Il limite deve essere un numero positivo.',
		'allocatetoomuchquota' => 'Si è tentato di allocare %s MB Limite, ma non c\'è abbastanza spazio disponibile.',
		'missingfields' => 'Non tutti i campi obbligatori sono stati compilati.',
		'accountnotexisting' => 'L\'account di posta elettronica dato non esiste.',
		'nopermissionsorinvalidid' => 'Non hai i permessi necessari per modificare le impostazioni o è stato fornito un ID non valido.',
		'phpsettingidwrong' => 'Una configurazione PHP con questo ID non esiste',
		'descriptioninvalid' => 'La descrizione è troppo corta, La descrizione è troppo corta o troppo lunga o contiene caratteri non validi.',
		'info' => 'Info',
		'filecontentnotset' => 'Il file non può essere vuoto!',
		'index_file_extension' => 'L\'estensione file del file index deve essere compresa tra 1 e 6 caratteri. L\'estensione può contenere solo i caratteri a-z, A-Z and 0-9',
		'customerdoesntexist' => 'Il cliente che si è selezionato non esiste.',
		'admindoesntexist' => 'L\'amministratore che si è selezionato non esiste.',
		'ipportdoesntexist' => 'La combinazione IP/Porta selezionata non esiste.',
		'usernamealreadyexists' => 'Esiste già il nome utente: %s',
		'plausibilitychecknotunderstood' => 'Il controllo non ha capito la risposta di plausibilità',
		'errorwhensaving' => 'Verificato un errore durante il salvataggio del campo %s',
		'hiddenfieldvaluechanged' => 'Il valore per il campo nascosto "%s" è cambiato durante la modifica delle impostazioni.<br /><br />Questo non è solitamente un grosso problema, ma le impostazioni potrebbe non essere salvate a causa di questo.',
		'notrequiredpasswordlength' => 'La password scritta è troppo corta. Si prega di scrivere una password lunga almeno %s caratteri.',
		'overviewsettingoptionisnotavalidfield' => 'Woops, un campo che dovrebbe essere mostrato come opzione in Impostazioni-Principale non è un tipo esclusivo. Si possono rimproverare gli sviluppatori per questo. Questo non deve accadere!',
		'pathmaynotcontaincolon' => 'Il percorso che hai inserito non dovrebbe contenere i due punti (:). Inserisci un percorso valido.',
		'exception' => '%s',
		'notrequiredpasswordcomplexity' => 'La complessita della password specificata non è soddisfacente.<br />Si prega di contattare l\'amministratore se avete domande sulla complessità della password',
		'stringerrordocumentnotvalidforlighty' => 'Una stringa come ErrorDocument non funziona in lighttpd, si prega di specificare un percorso di un file',
		'urlerrordocumentnotvalidforlighty' => 'Un URL come ErrorDocument non funziona in lighttpd, si prega di specificare un percorso di un file',
		'intvaluetoolow' => 'Il numero dato è troppo basso (campo %s)',
		'intvaluetoohigh' => 'Il numero dato è troppo alto (campo %s)',
		'phpfpmstillenabled' => 'PHP-FPM è attivo. Si prega di disattivarlo prima di attivare FCGID',
		'fcgidstillenabled' => 'FCGID è attivo. Si prega di disattivarlo prima di attivare PHP-FPM',
		'domains_cantdeletedomainwithaliases' => 'Non è possibile cancellare un dominio che viene utilizzato per alias-domains. È necessario eliminare prima gli alias.',
		'user_banned' => 'Il tuo account è stato bannato. Contatta l\'amministratore per maggiori informazioni.',
		'loginnameiswrong2' => 'Il nome utente contiente troppi caratteri. Sono permessi soltanto %s caratteri.',
		'session_timeout' => 'Valore troppo basso',
		'session_timeout_desc' => 'Non dovresti settare il timeout della sessione ad un valore minore di 1 minuto.',
		'invalidhostname' => 'Il nome del Host non può essere vuoto o contenere spazi',
		'operationnotpermitted' => 'Operazione non permessa!',
		'featureisdisabled' => 'Funzionalità %s è disabilitata. Perfavore contatta il tuo fornitore di servizi.',
		'usercurrentlydeactivated' => 'L\'utente %s è attualmente disabilitato',
		'setlessthanalreadyused' => 'Non puoi impostare dei limiti minori per \'%s\', di quanto questo utente abbia già utilizzato<br />',
		'stringmustntbeempty' => 'Il valore per il campo %s non può essere vuoto',
		'sslcertificateismissingprivatekey' => 'Devi specificare una chiave privata per il tuo certificato',
		'sslcertificatewrongdomain' => 'Il certificato fornito non appartiene a questo dominio',
		'sslcertificateinvalidcert' => 'Il contenuto del certificato fornito non sembra essere un certificato valido',
		'sslcertificateinvalidcertkeypair' => 'La chiave privata fornita non sembra appartenere al certificato fornito',
		'sslcertificateinvalidca' => 'Il certificato CA fornito non sembra essere un certificato valido',
		'sslcertificateinvalidchain' => 'I dati della catena di certificato non sembrano essere un certificato valido',
		'givendirnotallowed' => 'La cartella fornita nel campo %s non è permessa.',
		'sslredirectonlypossiblewithsslipport' => 'L\'utilizzo del reindirizzamento SSL è possibile soltanto quando il dominio ha almeno una combinazione IP/porta assegnata ed abilitata SSL.',
		'fcgidstillenableddeadlock' => 'FCGID è attualmente attivo.<br />Perfavore disattivalo prima di cambiare ad un server web diverso da Apache2',
		'send_report_title' => 'Invia rapporto errori',
		'send_report_desc' => 'Grazie per aver communicato questo errore, aiutandoci a migliorare froxlor.<br />Questa è la mail che verrà inviata agli svillupatori di froxlor:',
		'send_report' => 'Invia rapporto',
		'send_report_error' => 'Errore nell invio del rapporto: <br />%s',
		'notallowedtouseaccounts' => 'Il tuo account non permette l\'utilizzo di IMAP/POP3. Non puoi aggiungere account di posta elettronica.',
		'cannotdeletehostnamephpconfig' => 'Questa configurazione PHP è utilizzata dal vhost Froxlor e non può essere eliminata.',
		'cannotdeletedefaultphpconfig' => 'Questa configurazione PHP è impostata come predefinita e non può essere eliminata.',
		'passwordshouldnotbeusername' => 'La password deve essere diversa dal nome utente.',
		'no_phpinfo' => 'Ci dispiace, impossibile leggere phpinfo()',
		'moveofcustomerfailed' => 'Trasferimento del cliente all\'amministratore/rivenditore selezionato fallito. Considera che tutte le altre modfiche al cliente sono state applicate con successo a questa fase.<br><br>Messaggio d\'errore: %s',
		'domain_import_error' => 'Il seguente errore è occorsonell \'importazione di dominii: %s',
	],
	'extras' => [
		'description' => 'Qui puoi aggiungere alcune opzioni extra, per esempio impostare delle cartelle protette.<br />Il sistema, dopo ogni cambiamento, necessita di un po\' di tempo per applicare le nuove impostazioni.',
		'directoryprotection_add' => 'Aggiungi protezione cartella',
		'view_directory' => 'Mostra protezione cartella',
		'pathoptions_add' => 'Aggiungi opzioni cartella',
		'directory_browsing' => 'Visualizza file e cartelle',
		'pathoptions_edit' => 'Modifica opzioni cartella',
		'errordocument404path' => 'URL to ErrorDocument 404',
		'errordocument403path' => 'URL to ErrorDocument 403',
		'errordocument500path' => 'URL to ErrorDocument 500',
		'errordocument401path' => 'URL to ErrorDocument 401',
		'execute_perl' => 'Esegui perl/CGI',
		'htpasswdauthname' => 'Argomento di Autenticazione (AuthName)',
		'directoryprotection_edit' => 'modifica la protezione della directory',
	],
	'ftp' => [
		'description' => 'Qui puoi creare e modificare i tuoi account FTP.<br />I cambiamenti sono effettuati in tempo reale e gli account si possono usare immediatamente.',
		'account_add' => 'Crea account',
		'account_edit' => 'Modifica acocunt FTP',
		'editpassdescription' => 'Imposta una nuova password o lascia vuoto per non cambiarla.',
	],
	'gender' => [
		'title' => 'Titolo',
		'male' => 'Sig.',
		'female' => 'Sig.ra',
		'undef' => '',
	],
	'index' => [
		'customerdetails' => 'Dettagli Cliente',
		'accountdetails' => 'Dettagli Account',
	],
	'logger' => [
		'date' => 'Data',
		'type' => 'Tipo',
		'action' => 'Azione',
		'user' => 'Utente',
		'truncate' => 'Log vuoto',
		'reseller' => 'Rivenditore',
		'admin' => 'Amministratore',
		'cron' => 'Cronjob',
		'login' => 'Login',
		'intern' => 'Interno',
		'unknown' => 'Sconosciuto',
	],
	'login' => [
		'username' => 'Nome Utente',
		'password' => 'Password',
		'language' => 'Lingua',
		'login' => 'Login',
		'logout' => 'Logout',
		'profile_lng' => 'Scegli la lingua',
		'forgotpwd' => 'Dimenticato la password?',
		'presend' => 'Reimposta la password',
		'email' => 'Indirizzo E-mail',
		'remind' => 'Reimposta la mia password',
		'usernotfound' => 'Utente non trovata!',
		'backtologin' => 'Torna al login',
		'combination_not_found' => 'Combinazione utente-indirizzo email non trovata.',
	],
	'mails' => [
		'pop_success' => [
			'mailbody' => 'Salve,\\n\\nil tuo indirizzo Email {EMAIL}\\nè stato configurato con successo.\\n\\nQuesta è un\'Email creata automaticamente,\\n per favore non rispondere!\\n\\nCordiali saluti, Amministratore.',
			'subject' => 'Indirizzo Email configurato con successo',
		],
		'createcustomer' => [
			'mailbody' => 'Salve {FIRSTNAME} {NAME},\\n\\nqueste sono le informazioni per il tuo account:\\n\\nNome Utente: {USERNAME}\\nPassword: {PASSWORD}\\n\\nGrazie,\\nAmministratore.',
			'subject' => 'Informazioni account',
		],
		'pop_success_alternative' => [
			'mailbody' => 'Salve,\\n\\nil tuo account email {EMAIL}\\nè stato creato correttamente.\\nLa tua password è {PASSWORD}.\\n\\nQuesta è un\'email creata automaticamente,\\n si prega di non rispondere a questa email!\\n\\nCordiali Saluti, Amministratore.',
			'subject' => 'Account email creato correttamente',
		],
		'password_reset' => [
			'subject' => 'Reimposta password',
			'mailbody' => 'Salve {USERNAME},\\n\\nla tua password froxlor è stata reimpostata!\\nLa nuova password è: {LINK}\\n\\nGrazie,\\n Team Froxlor',
		],
		'new_database_by_customer' => [
			'subject' => '[Froxlor] Nuovo database creato',
			'mailbody' => 'Hello {CUST_NAME},

hai appena aggiunto un nuovo database. Ecco le informazioni inserite:

Nome database: {DB_NAME}
Password: {DB_PASS}
Descrizione: {DB_DESC}
DB-Hostname: {DB_SRV}
{PMA_URI}
Cordiali Saluti, Team Froxlor',
		],
		'new_ftpaccount_by_customer' => [
			'subject' => 'Nuovo utente ftp creato',
			'mailbody' => 'Salve {CUST_NAME},

hai appena aggiunto un nuovo utente ftp. Ecco le informazioni inserite:

Nome utente: {USR_NAME}
Password: {USR_PASS}
Percorso: {USR_PATH}

Cordiali Saluti, Team Froxlor',
		],
		'trafficmaxpercent' => [
			'mailbody' => 'Salve {NAME},\\n\\nhai utilizzato {TRAFFICUSED} MB di {TRAFFIC} MB traffico disponibile.\\nQuesto è più del {MAX_PERCENT}%%.\\n\\nCordiali Saluti, il Team Froxlor',
			'subject' => 'Raggiunto il limite di traffico',
		],
		'diskmaxpercent' => [
			'mailbody' => 'Salve {NAME},\\n\\nhai utilizzato {DISKUSED} MB di {DISKAVAILABLE} MB di spazio disponibile.\\nQuesto è più del {MAX_PERCENT}%%.\\n\\nCordiali Saluti, il Team Froxlor',
			'subject' => 'Raggiungere il limite di spazio su disco',
		],
	],
	'menu' => [
		'message' => 'Messaggi',
	],
	'menue' => [
		'main' => [
			'main' => 'Principale',
			'changepassword' => 'Cambia la password',
			'changelanguage' => 'Cambia la lingua',
			'username' => 'Utente: ',
			'changetheme' => 'Cambia tema',
		],
		'email' => [
			'email' => 'Email',
			'emails' => 'Indirizzi',
			'webmail' => 'WebMail',
		],
		'mysql' => [
			'mysql' => 'MySQL',
			'databases' => 'Database',
			'phpmyadmin' => 'phpMyAdmin',
		],
		'domains' => [
			'domains' => 'Domini',
			'settings' => 'Opzioni',
		],
		'ftp' => [
			'ftp' => 'FTP',
			'accounts' => 'Account',
			'webftp' => 'WebFTP',
		],
		'extras' => [
			'extras' => 'Extra',
			'directoryprotection' => 'Cartelle Protette',
			'pathoptions' => 'Opzioni Cartelle',
		],
		'traffic' => [
			'traffic' => 'Traffico',
			'current' => 'Mese corrente',
			'table' => 'Traffico',
		],
		'phpsettings' => [
			'maintitle' => 'Configurazioni PHP',
		],
		'logger' => [
			'logger' => 'Log di Sistema',
		],
	],
	'message' => [
		'norecipients' => 'Nessuna e-mail è stata inviata perch¸ non ci sono i destinatari nel database',
		'success' => 'Inviato correttamente il messaggio a %s recipients',
	],
	'mysql' => [
		'description' => 'Qui puoi creare e modificare il tuo database MySQL<br />Le modifiche sono istantanee e puoi usare subito il database.<br />Nel menù a sinistra trovi phpMyAdmin con cui puoi amministrare il tuo database.<br /><br />Per usare i database nei tuoi script php usa le seguenti impostazioni: (Le parole in <i>corsivo</i> devono essere modificate con quello che hai scritto!)<br />Hostname: <b><SQL_HOST></b><br />Utente: <b><i>Nome database</i></b><br />Password: <b><i>La password che hai scelto</i></b><br />Database: <b><i>Nome database</i></b>',
		'databasename' => 'Nome database',
		'databasedescription' => 'Descrizione database',
		'database_create' => 'Crea database',
		'mysql_server' => 'Server MySQL',
		'database_edit' => 'Modifica database',
		'size' => 'Dimensione',
	],
	'panel' => [
		'edit' => 'Modifica',
		'delete' => 'Cancella',
		'create' => 'Crea',
		'save' => 'Salva',
		'yes' => 'Si',
		'no' => 'No',
		'emptyfornochanges' => 'lasciare vuoto se non si vuole cambiare',
		'emptyfordefault' => 'lasciare vuoto per l\'impostazione di default',
		'path' => 'Percorso',
		'toggle' => 'Cambia',
		'next' => 'Prossimo',
		'dirsmissing' => 'La cartella fornita non è stata trovata.',
		'urloverridespath' => 'URL (sovrascrive il percorso)',
		'pathorurl' => 'Percorso o URL',
		'ascending' => 'ascendente',
		'descending' => 'discendente',
		'search' => 'Cerca',
		'used' => 'utilizzato',
		'translator' => 'Traduttore',
		'reset' => 'Annulla le modifiche',
		'pathDescription' => 'Se la cartella non esiste, viene creata automaticamente.',
		'back' => 'Indietro',
		'reseller' => 'rivenditore',
		'admin' => 'amministratore',
		'customer' => 'cliente/i',
		'send' => 'invia',
		'nosslipsavailable' => 'Attualmente non ci sono combinazioni ssl ip/porta per questo server',
		'backtooverview' => 'Ritorna alla pagina precedente',
		'dateformat' => 'DD-MM-YYYY',
		'dateformat_function' => 'd-m-Y',
		'timeformat_function' => 'H:i:s',
		'default' => 'Predefinito',
		'never' => 'Mai',
		'active' => 'Attivo',
		'please_choose' => 'Scegli',
		'allow_modifications' => 'Permetti modifiche',
		'megabyte' => 'MegaByte',
		'not_supported' => 'Non supportato in: ',
		'view' => 'view',
		'toomanydirs' => 'Troppe sottocartelle. Rifare tornando indietro nella selezione manuale della cartella.',
		'abort' => 'Termina',
		'not_activated' => 'non attivato',
		'off' => 'off',
		'options' => 'opzioni',
		'neverloggedin' => 'Nessun login effettuato',
		'descriptionerrordocument' => 'Può essere un URL, un percorso ad un file o solo una stringa con un " "<br />Lasciare vuoto per usare il valore di default del server.',
		'unlock' => 'unlock',
		'theme' => 'Tema',
		'variable' => 'Variabile',
		'description' => 'Descrizione',
		'pathDescriptionEx' => '<br /><br />Se vuoi redirezionare ad un altro dominio, questo valore deve iniziare con http:// or https://.',
		'pathDescriptionSubdomain' => 'Se la cartella non esiste, viene creata automaticamente.<br /><br />Se vuoi redirezionare ad un altro dominio, questo valore deve iniziare con http:// or https://.<br /><br />Se la URL termina con / è considerata una cartella, altrimenti verrà trattata come un file.',
		'cancel' => 'Annulla',
		'ssleditor' => 'Impostazioni SSL per questo dominio',
		'dashboard' => 'Cruscotto',
		'assigned' => 'Assegnato',
		'available' => 'Disponibile',
		'news' => 'Notizie',
		'ftpdesc' => 'Descrizione FTP',
	],
	'phpfpm' => [
		'vhost_httpuser' => 'Utente locale per PHP-FPM (Froxlor vHost)',
		'vhost_httpgroup' => 'Gruppo locale per PHP-FPM (Froxlor vHost)',
		'ownvhost' => [
			'title' => 'Abilita PHP-FPM per i vHost Froxlor',
			'description' => 'Se abilitato, Froxlor potrà essere avviato attraverso un utente locale',
		],
		'use_mod_proxy' => [
			'title' => 'Usa mod_proxy / mod_proxy_fcgi',
			'description' => 'Attiva l\'utilizzo di php-fpm attraverso mod_proxy_fcgi. Richiede almeno apache-2.4.9',
		],
	],
	'pwdreminder' => [
		'success' => 'La password è stata reimpostata con successo.<br />A questo punto riceverai una email con la nuova password.',
		'notallowed' => 'Il reimposta password è disabilitato',
		'changed' => 'La tua password è stata aggiornata con successo. Puoi accedere con le tue nuove credenziali.',
		'wrongcode' => 'Ci dispiace, il tuo codice di attivazione non esiste o è già scaduto.',
		'choosenew' => 'Setta la nuova password',
	],
	'question' => [
		'question' => 'Domanda di sicurezza',
		'admin_customer_reallydelete' => 'Sei sicuro di voler cancellare il cliente %s? Quest\'azione non potrà essere annullata!',
		'admin_domain_reallydelete' => 'Sei sicuro di voler cancellare il dominio %s?',
		'admin_domain_reallydisablesecuritysetting' => 'Sei sicuro di voler disattivare queste opzioni di sicurezza (OpenBasedir)?',
		'admin_admin_reallydelete' => 'Sei sicuro di voler cancellare l\'admin %s? Tutti i clienti e i domini saranno affidati all\'amministratore principale.',
		'admin_template_reallydelete' => 'Sei sicuro di voler cancellare il template \'%s\'?',
		'domains_reallydelete' => 'Sei sicuro di voler cancellare il dominio %s?',
		'email_reallydelete' => 'Sei sicuro di voler cancellare l\'indirizzo Email %s?',
		'email_reallydelete_account' => 'Sei sicuro di voler cancellare l\'account Email di %s?',
		'email_reallydelete_forwarder' => 'Sei sicuro di voler cancellare il reindirizzamento a %s?',
		'extras_reallydelete' => 'Sei sicuro di voler cancellare la protezione per la cartella %s?',
		'extras_reallydelete_pathoptions' => 'Sei sicuro di voler cancellare le opzioni cartella per %s?',
		'ftp_reallydelete' => 'Sei sicuro di voler cancellare l\'account FTP %s?',
		'mysql_reallydelete' => 'Sei sicuro di voler cancellare il database %s? Quest\'azione non potrà essere annullata!',
		'admin_configs_reallyrebuild' => 'Sei sicuro di voler rigenerare i file di configurazione per Apache e Bind?',
		'admin_customer_alsoremovefiles' => 'Cancellare anche i file dell\'utente?',
		'admin_ip_reallydelete' => 'Vuoi veramente eliminare l\'indirizzo IP %s?',
		'admin_domain_reallydocrootoutofcustomerroot' => 'Sei sicuro di volere la cartella base dei dati web di questo dominio al di fuori  della cartella base del cliente?',
		'admin_counters_reallyupdate' => 'Sei sicuro di voler ricacolare il consumo delle risorse?',
		'admin_cleartextmailpws_reallywipe' => 'Sei sicuro di voler cancellare tutte le password in chiaro degli account email dalla tabella mail_users? Attenzione non si può tornare indietro!',
		'logger_reallytruncate' => 'Sei sicuro di voler troncare la tabella "%s"?',
		'admin_quotas_reallywipe' => 'Sei sicuro di voler cancellare tutti i limiti dalla tabella mail_users? Questa operazione non può essere annullata!',
		'admin_quotas_reallyenforce' => 'Sei sicuro di voler impostare il limite predefinito a tutti gli utenti? Questa operazione non può essere annullata!',
		'phpsetting_reallydelete' => 'Do you really want to delete these settings? All domains which use these settings currently will be changed to the default config.',
		'customer_reallyunlock' => 'Sei sicuro di voler sbloccare il cliente %s?',
		'admin_customer_alsoremovemail' => 'Eliminare completamente i dati della posta elettronica dal filesystem??',
		'admin_customer_alsoremoveftphomedir' => 'Rimuovere anche la cartella homedir dell\'utente FTP?',
		'admin_integritycheck_reallyfix' => 'Vuoi veramente provare a risolvere i problemi di integrità del database automaticamente?',
	],
	'redirect_desc' => [
		'rc_default' => 'Predefinito',
		'rc_movedperm' => 'spostato in modo permanente',
		'rc_found' => 'trovato',
		'rc_seeother' => 'vedi gli altri',
		'rc_tempred' => 'reindirizzamento temporaneo',
	],
	'serversettings' => [
		'session_timeout' => [
			'title' => 'Timeout della sessione',
			'description' => 'Quanto tempo un utente deve rimanere inattivo prima che la sessione diventi invalida (secondi)?',
		],
		'accountprefix' => [
			'title' => 'Prefisso Cliente',
			'description' => 'Che prefisso dovrebbero avere gli account dei clienti?',
		],
		'mysqlprefix' => [
			'title' => 'Prefisso SQL',
			'description' => 'Che prefisso dovrebbero avere i database SQL?',
		],
		'ftpprefix' => [
			'title' => 'Prefisso FTP',
			'description' => 'Che prefisso vuoi che per gli account ftp?<br/><b>Se si modifica questo devi anche modificare il limite (Quota) della query SQL nel file di configurazione del server FTP nel caso in cui venga usata!</b> ',
		],
		'documentroot_prefix' => [
			'title' => 'Cartella dati web',
			'description' => 'Dove devono essere immagazzinati tutti i dati web?',
		],
		'logfiles_directory' => [
			'title' => 'Cartella logfiles',
			'description' => 'Dove devono essere immagazzinati tutti i log?',
		],
		'ipaddress' => [
			'title' => 'Indirizzo IP',
			'description' => 'Qual\'è l\'indirizzo IP di questo server?',
		],
		'hostname' => [
			'title' => 'Hostname',
			'description' => 'QUal\'è l\'hostname di questo server?',
		],
		'apachereload_command' => [
			'title' => 'Comando riavvio Apache',
			'description' => 'Qual\'è il comando per riavviare Apache?',
		],
		'bindconf_directory' => [
			'title' => 'Cartella configurazione Bind',
			'description' => 'Dove sono i file di configurazione per Bind?',
		],
		'bindreload_command' => [
			'title' => 'Comando riavvio Bind',
			'description' => 'Qual\'è il comando per riavviare Bind?',
		],
		'vmail_uid' => [
			'title' => 'UID Email',
			'description' => 'Che UserID dovrebbe avere l\'utente che gestisce le Email?',
		],
		'vmail_gid' => [
			'title' => 'GID Email',
			'description' => 'Che GroupID dovrebbe avere l\'utente che gestisce le Email?',
		],
		'vmail_homedir' => [
			'title' => 'Cartella Email',
			'description' => 'Dove devono essere immagazzinate tutte le Email?',
		],
		'adminmail' => [
			'title' => 'Mittente',
			'description' => 'Qual\'è l\'indirizzo del mittente delle Email provenienti dal pannello?',
		],
		'phpmyadmin_url' => [
			'title' => 'URL phpMyAdmin',
			'description' => 'Qual\'è l\'URL di phpMyAdmin? (deve cominciare per http://)',
		],
		'webmail_url' => [
			'title' => 'URL WebMail',
			'description' => 'Qual\'è l\'URL della WebMail? (deve cominciare per http://)',
		],
		'webftp_url' => [
			'title' => 'URL WebFTP',
			'description' => 'Qual\'è l\'URL del WebFTP? (deve cominciare per http://)',
		],
		'language' => [
			'description' => 'Qual\'è la lingua standard del tuo server?',
		],
		'maxloginattempts' => [
			'title' => 'Numero massimo tentativi login',
			'description' => 'Numero massimo di tentativi di login prima che l\'account sia disattivato.',
		],
		'deactivatetime' => [
			'title' => 'Durata disattivamento',
			'description' => 'Tempo (sec.) di disattivazione dell\'account dopo troppi tentativi di login.',
		],
		'pathedit' => [
			'title' => 'Modalità di scelta percorsi/cartelle',
			'description' => 'Un percorso/cartella andrà scelto attraverso un menu a tendina o inserendolo a mano?',
		],
		'nameservers' => [
			'title' => 'Nameservers',
			'description' => 'Lista degli hostname (separati dalla virgola) di tutti i nameserver. Il primo della lista sarà il impostato come primario.',
		],
		'mxservers' => [
			'title' => 'MX servers',
			'description' => 'Lista dei server mx (separati dalla virgola) numero spazio hostname (es. \'10 mx.example.com\').',
		],
		'paging' => [
			'title' => 'Elementi da visualizzare per pagina',
			'description' => 'Quanti elementi dovrebbero essere visualizzati su una pagina? (0 = disattiva impaginazione)',
		],
		'defaultip' => [
			'title' => 'IP/Porta default',
			'description' => 'Qual\'è la combinazione IP/Porta default?',
		],
		'phpappendopenbasedir' => [
			'title' => 'Percoso da aggiungere a OpenBasedir',
			'description' => 'Questi percorsi (separati da colonne) verranno aggiunti allo statement OpenBasedir in ognuno vhost-container.',
		],
		'natsorting' => [
			'title' => 'Usa l\'ordinamento naturale in vista elenco',
			'description' => 'Disponi la lista come web1 -> web2 -> web11 al posto di web1 -> web11 -> web2.',
		],
		'deactivateddocroot' => [
			'title' => 'Docroot per gli utenti disattivati',
			'description' => 'Quando un utente viene disattivato questo percorso viene usato come suo docroot. Lascia vuoto per non creare un vhost a tutti.',
		],
		'mailpwcleartext' => [
			'title' => 'Salva le password in chiaro degli account email nel database',
			'description' => 'Se impostato a Si, tutte le password saranno salvate in chiaro (saranno leggibili a chiunque abbia accesso al database) nella tabella mail_users. Attiva questa opzione solo se necessaria!',
			'removelink' => 'Clicca qui per cancellare tutte le password in chiaro dalla tabella.',
		],
		'ftpdomain' => [
			'title' => 'Account FTP @domain',
			'description' => 'I Clienti possono creare account ftp utente@dominiocliente?',
		],
		'mod_fcgid' => [
			'title' => 'Includi PHP via mod_fcgid/suexec',
			'description' => 'Usa mod_fcgid/suexec/libnss_mysql per avviare PHP con il corrispondente account-utente.<br/><b>Questo richiede una speciale configurazione del Webserver. Tutte le opzioni seguenti sono validi solo se il modulo è abilitato.</b>',
			'configdir' => [
				'title' => 'Cartella della configurazione',
				'description' => 'Dove vuoi che venga salvata la configurazione di fcgid? Se non ti sei compilato suexec da solo, di solito questo percorso è /var/www',
			],
			'tmpdir' => [
				'title' => 'Cartella Temp',
				'description' => 'Dove va salvata la cartella temp',
			],
			'starter' => [
				'title' => 'Processi per Dominio',
				'description' => 'Quanti processi dovrebbero essere avviati/permessi per ogni dominio? Il valore 0 è raccomandato poichè PHP si autogestisce i processi in modo molto efficiente.',
			],
			'wrapper' => [
				'title' => 'Wrapper in Vhosts',
				'description' => 'Come dovrebbe essere il wrapper incluso nel Vhosts',
			],
			'peardir' => [
				'title' => 'Cartella globale di PEAR',
				'description' => 'Quali sono le cartelle globali di PEAR che dovrebbero essere sostituite in ogni configurazione php.ini? Più cartelle devono essere separate da : (due punti).',
			],
			'maxrequests' => [
				'title' => 'Richieste massime per dominio',
				'description' => 'Quante richieste dovrebbero essere permesse per dominio?',
			],
			'defaultini' => 'Configurazione di default di PHP per i nuovi domini',
			'defaultini_ownvhost' => 'Configurazione di Default di PHP per Froxlor-vhost',
			'idle_timeout' => [
				'title' => 'Timeout Inattività',
				'description' => 'Impostazione Timeout per il Mod FastCGI.',
			],
		],
		'sendalternativemail' => [
			'title' => 'Usa un\'indirizzo email alternativo',
			'description' => 'Invia la password dell\'email a un\'indirizzo diverso da quello creato',
		],
		'apacheconf_vhost' => [
			'title' => 'File/cartella della configurazione vhost del Webserver',
			'description' => 'Dove vuoi che venga salvata la configurazione vhost? Qui puoi scegliere un file (tutti i vhosts in un file) o una cartella (ogni vhost avrà il suo file).',
		],
		'apacheconf_diroptions' => [
			'title' => 'Webserver diroptions configuration file/dirname',
			'description' => 'Dove vuoi che venga salvata la configurazione dir-options? Qui puoi scegliere un file (tutti i vhosts in un file) o una cartella (ogni vhost avrà il suo file).',
		],
		'apacheconf_htpasswddir' => [
			'title' => 'Cartella htpasswd del Webserver',
			'description' => 'Dove vuoi che vengano salvati i file htpasswd per la protezione delle cartelle?',
		],
		'mysql_access_host' => [
			'description' => 'Lista degli host (separati da una virgola) a cui gli utenti possono collegarsi al server MySQL.',
			'title' => 'Hosts Accesso MySQL',
		],
		'webalizer_quiet' => [
			'description' => 'Verbosità del programma webalizer',
			'title' => 'Webalizer output',
		],
		'logger' => [
			'enable' => 'Abilita/Disabilita Log',
			'severity' => 'Livello Log',
			'types' => [
				'title' => 'Tipo di Log',
				'description' => 'Specificare tipo di Log. Per selezionare più tipi, tenere premuto CTRL durante la selezione.<br />Tipi di log disponibili: syslog, file, mysql',
			],
			'logfile' => 'Percorso completo e nome del file del Log',
			'logcron' => 'Log cronjobs (one run)',
		],
		'ssl' => [
			'openssl_cnf' => 'Defaults per la creazione del file Cert',
			'use_ssl' => [
				'title' => 'Abilita utilizzo SSL',
				'description' => 'Spunta questo se vuoi usare SSL per il tuo server web',
			],
			'ssl_cert_file' => [
				'title' => 'Percorso al certificato SSL',
				'description' => 'Specifica il percorso includendo il nome del file .crt o .pem (certificato principale)',
			],
			'ssl_key_file' => [
				'title' => 'Percorso al file di chiave SSL',
				'description' => 'Specifica il percorso includendo il nome del file per la chiave privata (abitualmente.key)',
			],
			'ssl_ca_file' => [
				'title' => 'Percorso al certificato della CA (autoritá certificatrice) SSL (opzionale)',
				'description' => 'Autenticazione client, da settare soltanto se desiderato.',
			],
			'ssl_cipher_list' => [
				'title' => 'Configura le cifrature SSL permesse',
				'description' => 'Questa è una lista di cifrature che vuoi (o non vuoi) usare nelle communicazioni SSL. Per una lista delle cifrature e come includerle od escluderle, vedi le sezioni "CIPHER LIST FORMAT" e "CIPHER STRINGS" sulla <a href="https://www.openssl.org/docs/manmaster/man1/openssl-ciphers.html">man-page per le cifrature</a>.<br /><br /><b>Il valore predefinito è:</b><pre>ECDHE-RSA-AES128-SHA256:AES128-GCM-SHA256:RC4:HIGH:!MD5:!aNULL:!EDH</pre>',
			],
		],
		'default_vhostconf' => [
			'title' => 'Impostazioni default vhost',
			'description' => 'Il contenuto di questo campo sarà incluso direttamente nel contenitore di dominio vhost. Attenzione: Il codice non sarà controllato per eventuali errori. Se contiene errori, il webserver non riavviarsi correttamente!',
		],
		'decimal_places' => 'Numero di cifre decimali del traffico/spazio web in uscita',
		'webalizer_enabled' => 'Abilita le statistiche webalizer',
		'awstats_enabled' => 'Abilita le statistiche awstats',
		'selfdns' => [
			'title' => 'Impostazioni dominio dns del cliente',
		],
		'selfdnscustomer' => [
			'title' => 'Consenti ai clienti di modificare le impostazioni DNS del dominio',
		],
		'unix_names' => [
			'title' => 'Usa nomi utente UNIX compatibile',
			'description' => 'Consente di utilizzare <strong>-</strong> e <strong>_</strong> nei nomi utente se <strong>No</strong>',
		],
		'allow_password_reset' => [
			'title' => 'Consenti ai clienti di reimpostare la password',
			'description' => 'I clienti possono reimpostare la propria password e una nuova password verrà inviata al loro indirizzo e-mail',
		],
		'allow_password_reset_admin' => [
			'title' => 'Consenti di reimpostare la password agli ammministratori',
			'description' => 'Amministratori/rivenditori possono reimpostare la propria password e una nuova password verrà inviata al loro indirizzo e-mail',
		],
		'mail_quota' => [
			'title' => 'Limite casella email',
			'description' => 'Limite predefinito per una nuova casella email creata (MegaByte).',
		],
		'mail_quota_enabled' => [
			'title' => 'Usa limiti per le caselle email dei clienti',
			'description' => 'Attiva per utilizzare i limiti nelle caselle email. Predefinito <b>No</b> poich¸ questo richiede una configurazione speciale.',
			'removelink' => 'Clicca qui per togliere tutti i limiti dalle caselle email.',
			'enforcelink' => 'Clicca qui per applicare il limite predefinito a tutte le caselle email degli utenti.',
		],
		'index_file_extension' => [
			'description' => 'Quale estensione di file deve essere usata per il file index nelle cartelle del cliente appena creato? Questa estensione di file sarà utilizzata se Lei o uno dei vostri amministratori ha creato il proprio file modello di index.',
			'title' => 'Estensione file per il file index delle cartelle dei clienti appena creati',
		],
		'session_allow_multiple_login' => [
			'title' => 'Permettere login multipli',
			'description' => 'Se attivato un utente può accedere più volte.',
		],
		'panel_allow_domain_change_admin' => [
			'title' => 'Permettere di spostare domini tra gli amministratori',
			'description' => 'Se attivato si può cambiare l\'amministratore di un dominio dalle impostazioni del dominio<br /><b>Attenzione:</b> Se un cliente non viene assegnato allo stesso amministratore e dominio, l\'amministratore può vedere tutti gli altri domini di questo cliente!',
		],
		'panel_allow_domain_change_customer' => [
			'title' => 'Permetti di spostare domini tra i clienti',
			'description' => 'Se attivato si può cambiare il cliente di un dominio dalle impostazioni del dominio.<br /><b>Attenzione:</b> Froxlor non cambierà alcun percorso. Ciò potrebbe rendere inutilizzabile un dominio!',
		],
		'cron' => [
			'debug' => [
				'title' => 'Debug Cronscript',
				'description' => 'Attiva per mantenere il file lock dopo l\'avvio di cron, solo per debug<br /><b>Attenzione:</b>Mantenendo il file di lock al successivo avvio cron potrebbe non funzionare correttamente',
			],
		],
		'specialsettingsforsubdomains' => [
			'description' => 'Se si queste impostazioni personalizzate dei vhost saranno aggiunte a tutti sottodomini; se no le impostazioni speciali dei sottodomini verranno rimosse.',
		],
		'panel_password_min_length' => [
			'title' => 'Lunghezza minima della password',
			'description' => 'Qui è possibile impostare una lunghezza minima per le password.\'0\' significa: nessuna lunghezza minima richiesta.',
		],
		'system_store_index_file_subs' => [
			'title' => 'Salva il file index predefinito anche nelle nuove sottocartelle',
			'description' => 'Se abilitato, il file index predefinito viene memorizzato per ogni cartella sottodominio appena creata (non se la cartella esiste già!)',
		],
		'adminmail_return' => [
			'title' => 'Indirizzo di Risposta',
			'description' => 'Definire un indirizzo email come \'Indirizzo di Risposta\' per le email inviate dal Pannello',
		],
		'adminmail_defname' => 'Nome del mittente del Pannello nell\'email',
		'stdsubdomainhost' => [
			'title' => 'Sottodominio standard cliente',
			'description' => 'Quale hostname dovrebbe essere usato per creare sottodomini standard per i clienti. Se vuoto, viene utilizzato l\'hostname del sistema.',
		],
		'awstats_path' => 'Percorso a AWStats \'awstats_buildstaticpages.pl\'',
		'awstats_conf' => 'Cartella della configurazione di AWStats',
		'defaultttl' => 'Dominio TTL per impegnare in secondi (predefinito \'604800\' = 1 settimana)',
		'defaultwebsrverrhandler_enabled' => 'Abilita errordocuments in automatico per tutti i clienti',
		'defaultwebsrverrhandler_err401' => [
			'title' => 'File/URL per l\'errore 401',
			'description' => '<div class="text-danger">Non supportato in: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err403' => [
			'title' => 'File/URL per l\'errore 403',
			'description' => '<div class="text-danger">Non supportato in: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err404' => 'File/URL per l\'errore 404',
		'defaultwebsrverrhandler_err500' => [
			'title' => 'File/URL per l\'errore 500',
			'description' => '<div class="text-danger">Non supportato in: lighttpd</div>',
		],
		'ftpserver' => [
			'desc' => 'Se pureftpd è selezionato i file .ftpquota per i limiti dell\'utente sono creati e aggiornati giornalmente',
		],
		'customredirect_enabled' => [
			'title' => 'Permetti ai clienti le redirezioni',
			'description' => 'Consente ai clienti di scegliere il codice di stato http per le redirezioni che verranno utilizzate',
		],
		'customredirect_default' => [
			'title' => 'Redirezione Predefinita',
			'description' => 'Imposta il codice della redirezione predefinito che dovrebbe essere usato se il cliente non lo imposta',
		],
		'mail_also_with_mxservers' => 'Crea mail-, imap-, pop3- and smtp-"A record" anche con MX-Servers impostato',
		'froxlordirectlyviahostname' => 'Accedi direttamente a Froxlor via hostname',
		'panel_password_regex' => [
			'title' => 'Espressione per le password',
			'description' => 'Qui è possibile impostare una espressione regolare per la complessità delle password.<br />Vuoto = nessun requisito specificato',
		],
		'perl_path' => [
			'title' => 'Percorso perl',
			'description' => 'Rilevante solo se si utilizza lighttpd. Predefinito /usr/bin/perl',
		],
		'mod_fcgid_ownvhost' => [
			'title' => 'Abilita FCGID per i vhost Froxlor',
			'description' => 'Se attivato, Froxlor verrà eseguito con un utente locale<br /><strong>ATTENZIONE:</strong>Questo richiede una configurazione manuale, vedi <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/fcgid/">FCGID - handbook</a>',
		],
		'perl' => [
			'suexecworkaround' => [
				'title' => 'Abilita SuExec workaround (solo con Apache)',
				'description' => 'Abilita solo se la docroots del cliente non sono all\'interno del percorso suexec di Apache<br />Se attivato, Froxlor genererà un link simbolico dalla cartella perl abilitata dei clienti + /cgi-bin/ al percorso specificato.<br />Nota: Perl funziona solo nelle sottocartelle /cgi-bin/ e non nella cartella stessa (come farebbe normalmente senza questa correzione!)',
			],
			'suexeccgipath' => [
				'title' => 'Percorso dei link simbolici della cartella abilitata perl del cliente',
				'description' => 'Imposta questo solo se la soluzione SuExec è abilitata.<br />ATTENZIONE: Assicurati che questo percorso sia all\'interno del percorso suexec oppure questa soluzione è inutile',
			],
		],
		'awstats_awstatspath' => 'Percorso AWStats \'awstats.pl\'',
		'awstats_icons' => [
			'title' => 'Percorso della cartella delle icone di AWstats',
			'description' => 'es. /usr/share/awstats/htdocs/icon/',
		],
		'login_domain_login' => 'Permetti il login con i domini',
		'nginx_php_backend' => [
			'title' => 'Nginx PHP backend',
			'description' => 'questo è dove in ascolto il processo PHP per le richieste da nginx, può essere un socket unix combinazione IP:Porta',
		],
		'phpreload_command' => [
			'title' => 'Comando riavvio PHP',
			'description' => 'questo viene utilizzato per ricaricare il backend PHP se è in uso<br />Predefinito: vuoto',
		],
		'phpfpm_settings' => [
			'configdir' => 'Cartella di configurazione php-fpm',
			'reload' => 'comando di riavvio php-fpm',
			'pm' => 'Gestore processi (pm)',
			'max_children' => [
				'title' => 'Il numero di processi figli',
				'description' => 'Il numero di processi figli che vengono creati quando il pm è impostato a  \'static\' e il numero massimo di processi figli che vengono creati quando il pm è impostato a \'dynamic\'<br />Equivalente a PHP_FCGI_CHILDREN',
			],
			'start_servers' => [
				'title' => 'Il numero di processi figli creati all\'avvio',
				'description' => 'Nota: Usato solo quando il pm è impostato a \'dynamic\'',
			],
			'min_spare_servers' => [
				'title' => 'Il numero minimo di processi inattivi nel server',
				'description' => 'Nota: Usato solo quando il pm è impostato a \'dynamic\'<br />Nota: Obbligatorio quando il pm è impostato a \'dynamic\'',
			],
			'max_spare_servers' => [
				'title' => 'Il numero massimo di processi inattivi nel server',
				'description' => 'Nota: Usato solo quando il pm è impostato a \'dynamic\'<br />Nota: Obbligatorio quando il pm è impostato a \'dynamic\'',
			],
			'max_requests' => [
				'title' => 'Richieste per figli prima di rigenerare',
				'description' => 'Per le richieste senza fine specificare \'0\'. Equivalente a PHP_FCGI_MAX_REQUESTS.',
			],
			'aliasconfigdir' => 'Configurazione cartella Alias per php-fpm',
			'idle_timeout' => [
				'title' => 'Timeout Inattività',
				'description' => 'Impostazione Timeout per PHP5 FPM FastCGI.',
			],
			'ipcdir' => [
				'title' => 'Cartella FastCGI IPC',
				'description' => 'La cartella nella quale verrano salvati i socket php-fpm dal server web.<br />Questa cartella deve essere leggibile dal server Web',
			],
		],
		'report' => [
			'report' => 'Abilita l\'invio dei report di utilizzo web e del traffico',
			'webmax' => 'Percentuale di avviso per lo spazio web',
			'trafficmax' => 'Percentuale di avviso per il traffico',
		],
		'dropdown' => 'Dropdown',
		'manual' => 'Manuale',
		'default_theme' => 'Tema predefinito',
		'validate_domain' => 'Convalida dei domini',
		'bindenable' => [
			'title' => 'Abilita Nameserver',
			'description' => 'Qui il Nameserver può essere abilitato e disabilitato globalmente.',
		],
		'default_vhostconf_domain' => [
			'description' => 'Il contenuto di questo campo verrà incluso direttamente nella configurazione del contenitore del dominio vHost. ATTENZIONE: Non verrano verificati eventuali errori del codice contenuto. Se conterrà degli errori, vi è il rischio che il server WEB non si avvii più!',
		],
		'phpfpm' => [
			'title' => 'Abilita php-fpm',
			'description' => '<b>Questa impostazione richiede una configurazione speciale del server web. Vedi il <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/php-fpm/">manuale PHP-FPM</a></b>',
		],
		'diskquota_enabled' => 'Quota attivita?',
		'diskquota_repquota_path' => [
			'description' => 'Percorso a repquota',
		],
		'diskquota_quotatool_path' => [
			'description' => 'Percorso al quotatool',
		],
		'diskquota_customer_partition' => [
			'description' => 'Partizione, sulla quale sono salvati i dati dei clienti',
		],
		'vmail_maildirname' => [
			'title' => 'nome Maildir',
			'description' => 'cartella Maildir nell account utente. Normalmente \'Maildir\', in alcune implementazioni \'.maildir\', e direttamente nella cartella utente se lasciato vuoto.',
		],
		'catchall_enabled' => [
			'title' => 'Usa Catchall',
			'description' => 'Vuoi offrire ai tuoi clienti la funzionalità di catchall?',
		],
		'apache_24' => [
			'title' => 'Usa impostazioni per Apache 2.4',
			'description' => '<strong class="text-danger">ATTENZIONE:</strong> spunta soltanto se hai installato la versione 2.4 o superiore di Apache<br />altrimenti il tuo server Web non si avvierà',
		],
		'nginx_fastcgiparams' => [
			'title' => 'Percorso al file fastcgi_params',
			'description' => 'Specifica il percorso al file fastcgi_params di nginx includendo il nome del file',
		],
		'documentroot_use_default_value' => [
			'title' => 'Usa il nome del dominio come valore predefinito per il percorso DocumentRoot (radice dei documenti)',
			'description' => 'Se abilitato ed il percorso radice DocumentRoot è vuoto, il valore predefinito sarà il nome del (sotto)dominio.<br /><br />Esempio: <br />/var/customers/nome_cliente/example.com/<br />/var/customers/nome_cliente/sottodominio.example.com/',
		],
		'panel_phpconfigs_hidestdsubdomain' => [
			'title' => 'Nascondi i sottodominii predefiniti nel riepilogo di configurazione PHP',
			'description' => 'Se attivato i sottodomini predefiniti dei clienti non saranno visualizzati nel riepilogo della configurazione php<br /><br />Nota: Questo è solo visibile se avete abilitato FCGID o PHP-FPM',
		],
		'passwordcryptfunc' => [
			'title' => 'Scegli quale metodo crittografico deve essere usato per le password',
		],
		'systemdefault' => 'Predefinito di sistema',
		'panel_allow_theme_change_admin' => 'Permetti agli amministratori di cambiare il tema',
		'panel_allow_theme_change_customer' => 'Permetti ai clienti di cambiare il tema',
		'axfrservers' => [
			'title' => 'Server AXFR',
			'description' => 'Un elenco separato da virgole di indirizzi IP autorizzati a trasferire zone dns (AXFR).',
		],
		'customerssl_directory' => [
			'title' => 'Cartella dei certificati ssl clienti del Webserver',
			'description' => 'Dove devono esssere creati i certificati ssl cliente?<br /><br /><div class="text-danger">NOTA: Il contenuto di questa cartella viene cancellato regolarmente, onde evitare il salvataggio manuale di dati in essa.</div>',
		],
		'allow_error_report_admin' => [
			'title' => 'Permetti agli amministratori/rivenditori di inviare errori di database a Froxlor',
			'description' => 'Attenzione: Non inviarci MAI dati personali (dei clienti)!',
		],
		'allow_error_report_customer' => [
			'title' => 'Permetti ai clienti di inviare errori di database a Froxlor',
			'description' => 'Attenzione: Non inviarci MAI dati personali (dei clienti)!',
		],
		'mailtraffic_enabled' => [
			'title' => 'Analizza traffico posta',
			'description' => 'Abilita l\\\'analisi dei log del server di posta per calcolare il traffico',
		],
		'mdaserver' => [
			'title' => 'tipo MDA',
			'description' => 'Tipo del Server di consegna di posta',
		],
		'mdalog' => [
			'title' => 'log MDA',
			'description' => 'File log del Server di consegna di posta',
		],
		'mtaserver' => [
			'title' => 'tipo MTA',
			'description' => 'Tipo agente di trasferimento di posta',
		],
		'mtalog' => [
			'title' => 'log MTA',
			'description' => 'File log dell\\\'agente di trasferimento di posta',
		],
		'system_cronconfig' => [
			'title' => 'File di configurazione Cron',
			'description' => 'Percorso al file di configurazione del servizio cron. Questo file verrà aggiornato regolarmente ed automaticamente da froxlor.<br />
Nota: Perfavore <b>sii sicuro</b> di usare lo stesso nome di file come per il cronjob principale di froxlor (predefinito: /etc/cron.d/froxlor)!<br><br>Se usi <b>FreeBSD</b>, qui specifica: <i>/etc/crontab</i>!',
		],
		'system_crondreload' => [
			'title' => 'Commando per riavviare il servizio Cron',
			'description' => 'Specifica il commando da eseguire per riavviare il servizio cron del tuo sistema',
		],
		'system_croncmdline' => [
			'title' => 'Commando di esecuzione Cron (binario php)',
			'description' => 'Commando per eseguire i nostri cronjob. Modificalo soltanto se sai cosa stai facendo (predefinito: "/usr/bin/nice -n 5 /usr/bin/php -q")!',
		],
		'system_cron_allowautoupdate' => [
			'title' => 'Permetti aggiornamenti automatici del database',
			'description' => '<div class="text-danger"><b>ATTENZIONE:</b></div> Questa impostazione permette al cronjob di bypassare la verifica di versione dei file e database di froxlors ed esegue gli aggiornamenti di database in caso si verificasse un disallineamento di versione.<br><br><div class="text-danger">l\'aggiornamento automatico imposterà sempre i valori predefiniti per nuove impostazioni o modifiche. Questo, non sempre potrebbe essere congruo ed adeguato per il vostro sistema. Pensaci due volte prima di attivare questa opzione</div>',
		],
		'dns_createhostnameentry' => 'Crea la zone/config di bind per il nome host del sistema',
		'panel_password_alpha_lower' => [
			'title' => 'Caratteri minuscoli',
			'description' => 'La Password deve contenere almeno una lettera minuscola (a-z).',
		],
		'panel_password_alpha_upper' => [
			'title' => 'Caratteri maiuscoli',
			'description' => 'La Password deve contenere almeno una lettere maiuscola (A-Z).',
		],
		'panel_password_numeric' => [
			'title' => 'Numeri',
			'description' => 'La Password deve contenere almeno un numero (0-9).',
		],
		'panel_password_special_char_required' => [
			'title' => 'Caratteri speciali',
			'description' => 'La Password deve contenere almeno uno dei caratteri speciali definiti nel campo sottostante.',
		],
		'panel_password_special_char' => [
			'title' => 'Lista dei caratteri speciali',
			'description' => 'Uno di questi caratteri è richiesto se è attivata l\'opzione soprastante.',
		],
	],
	'spf' => [
		'use_spf' => 'Attiva SPF per i domini?',
		'spf_entry' => 'Impostazioni SPF per tutti i domini',
	],
	'success' => [
		'success' => 'Informazioni',
		'clickheretocontinue' => 'Clicca qui per continuare',
		'settingssaved' => 'Le impostazioni sono state salvate con successo.',
		'rebuildingconfigs' => 'Inseriti con successo i lavori per la ricostruzione del file di configurazione',
		'domain_import_successfully' => 'Importato %s dominii con successo.',
	],
	'tasks' => [
		'outstanding_tasks' => 'Processi Cron in sospeso',
		'REBUILD_VHOST' => 'Ricostruzione della configurazione del webserver',
		'CREATE_HOME' => 'Aggiunto il nuovo cliente %s',
		'REBUILD_DNS' => 'Ricostruzione della configurazione di bind',
		'CREATE_FTP' => 'Creazione delle cartelle per i nuovi utenti ftp',
		'DELETE_CUSTOMER_FILES' => 'Eliminazione dei file del cliente %s',
		'noneoutstanding' => 'Attualmente non ci sono processi in sospeso per Froxlor',
		'CREATE_QUOTA' => 'Setta quota al filesystem',
		'DELETE_EMAIL_DATA' => 'Elimina i dati di posta elettronica del cliente.',
		'DELETE_FTP_DATA' => 'Elimina i dati account-ftp del cliente.',
		'REBUILD_CRON' => 'Ricostruisci il file cron.d',
	],
	'traffic' => [
		'month' => 'Mese',
		'day' => 'Giorno',
		'months' => [
			1 => 'Gennaio',
			2 => 'Febbraio',
			3 => 'Marzo',
			4 => 'Aprile',
			5 => 'Maggio',
			6 => 'Giugno',
			7 => 'Luglio',
			8 => 'Agosto',
			9 => 'Settembre',
			10 => 'Ottobre',
			11 => 'Novembre',
			12 => 'Dicembre',
			'jan' => 'Gen',
			'feb' => 'Feb',
			'mar' => 'Mar',
			'apr' => 'Apr',
			'may' => 'Mag',
			'jun' => 'Giu',
			'jul' => 'Lug',
			'aug' => 'Ago',
			'sep' => 'Set',
			'oct' => 'Ott',
			'nov' => 'Nov',
			'dec' => 'Dic',
			'total' => 'Totale',
		],
		'mb' => 'Traffico (MB)',
		'distribution' => '<font color="#019522">FTP</font> | <font color="#0000FF">HTTP</font> | <font color="#800000">Mail</font>',
		'sumhttp' => 'Sommatoria Traffico in ingresso HTTP',
		'sumftp' => 'Sommatoria Traffico in ingresso FTP',
		'summail' => 'Sommatoria Traffico in ingresso Mail',
		'customer' => 'Cliente',
		'domain' => 'Domini',
		'trafficoverview' => 'Riepilogo del traffico di',
		'details' => 'Dettagli',
		'http' => 'HTTP (MiB)',
		'ftp' => 'FTP (MiB)',
		'mail' => 'Mail (MiB)',
	],
	'translator' => 'Luca Longinotti, Luca Piona, Emilien, Christian Munari',
	'update' => [
		'updateinprogress_onlyadmincanlogin' => 'Una nuova versione di Froxlor è stata installata ma non ancora impostata.<br />Solo l\'amministratore può accedere e completare l\'aggiornamento.',
		'update' => 'Aggiorna Froxlor',
		'proceed' => 'Procedi',
		'update_information' => [
			'part_a' => 'I file di Froxlor sono stati aggiornati alla versione <strong>%s</strong>. La versione installata è <strong>%s</strong>.',
			'part_b' => '<br /><br />I clienti non potranno accedere fino a quando l\'aggiornamento non sarà completato.<br /><strong>Procedere?</strong>',
		],
		'noupdatesavail' => '<strong>È già presente l\'ultima versione di Froxlor.</strong>',
	],
	'usersettings' => [
		'custom_notes' => [
			'title' => 'Note personali',
			'description' => 'Sentiti libero di inserire qualsi nota vuoi o necessiti qui. Apparirano nel riepilogo dell\'amministratore/cliente perl \'utente corrispondente.',
			'show' => 'Mostra le tue note nel cruscotto dell\'utente',
		],
	],
];
