<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can also view it online at
 * https://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  the authors
 * @author     Froxlor team <team@froxlor.org>
 * @license    https://files.froxlor.org/misc/COPYING.txt GPLv2
 */

return [
	'languages' => [
		'cz' => 'Čeština',
		'de' => 'Němčina',
		'en' => 'Angličtina',
		'fr' => 'Francouzština',
		'it' => 'Italština',
		'nl' => 'Holandština',
		'pt' => 'Portugalština',
		'se' => 'Švědština',
		'es' => 'Španělština',
		'ca' => 'Katalánština',
	],
	'2fa' => [
		'2fa' => 'Možnosti 2FA',
		'2fa_enabled' => 'Aktivovat dvoufázové ověření (2FA)',
		'2fa_removed' => '2FA úspěšně odebráno',
		'2fa_added' => '2FA aktivováno úspěšně<br><a class="alert-link" href="%s?page=2fa">Zobrazit 2FA podrobnosti</a>',
		'2fa_add' => 'Aktivovat 2FA',
		'2fa_delete' => 'Deaktivovat 2FA',
		'2fa_verify' => 'Ověřit kód',
		'2fa_overview_desc' => 'Zde můžete aktivovat dvoufaktorové ověřování vašeho účtu.<br><br>Můžete buď použít autentifikátor-aplikaci (jednorázové heslo / TOTP) nebo vám nechat froxlor po každém úspěšném přihlášení pomocí jednorázového hesla poslat e-mail na vaši e-mailovou adresu.',
		'2fa_email_desc' => 'Váš účet je nastaven pro použití jednorázových hesel e-mailem. Chcete-li deaktivovat, klikněte na "Deaktivovat 2FA"',
		'2fa_ga_desc' => 'Váš účet je nastaven tak, aby používal jednorázová hesla založená na čase prostřednictvím autentizační aplikace. Naskenujte níže uvedený QR kód pomocí požadované autentizační aplikace pro vygenerování kódů. Chcete-li deaktivovat, klikněte na "Deaktivovat 2FA"',
		'2fa_not_activated' => 'Dvoufázové ověřování není povoleno',
		'2fa_not_activated_for_user' => 'Dvoufaktorové ověření není pro aktuálního uživatele povoleno',
	],
	'admin' => [
		'overview' => 'Přehled',
		'ressourcedetails' => 'Využijte zdroje',
		'systemdetails' => 'Podrobnosti o systému',
		'froxlordetails' => 'Podrobnosti o Froxloru',
		'installedversion' => 'Nainstalovaná verze',
		'latestversion' => 'Nejnovější verze',
		'lookfornewversion' => [
			'clickhere' => 'Hledat prostřednictvím webové služby',
			'error' => 'Při čtení došlo k chybě',
		],
		'resources' => 'Zdroje',
		'customer' => 'Zákazník',
		'customers' => 'Zákazníci',
		'customers_list_desc' => 'Spravovat své zákazníky',
		'customer_add' => 'Vytvořit zákazníka',
		'customer_edit' => 'Upravit zákazníka',
		'username_default_msg' => 'Ponechte prázdné pro automaticky generovanou hodnotu',
		'password_default_msg' => 'Automaticky vygenerováno, pokud je prázdné',
		'domains' => 'Domény',
		'domain_add' => 'Vytvořit doménu',
		'domain_edit' => 'Upravit doménu',
		'subdomainforemail' => 'Subdomény jako e-mailové domény',
		'admin' => 'Admin',
		'admins' => 'Administrátoři',
		'admin_add' => 'Vytvořit administrátora',
		'admin_edit' => 'Upravit administrátora',
		'customers_see_all' => 'Můžete přistupovat k dalším správcům/prodejcům?',
		'change_serversettings' => 'Může změnit nastavení serveru?',
		'server' => 'Systém',
		'serversettings' => 'Nastavení',
		'serversettings_desc' => 'Spravujte svůj systém froxlor',
		'rebuildconf' => 'Znovu vytvořit konfigurační soubory',
		'stdsubdomain' => 'Standardní subdoména',
		'stdsubdomain_add' => 'Vytvořit standardní subdoménu',
		'phpenabled' => 'PHP povoleno',
		'deactivated' => 'Deaktivováno',
		'deactivated_user' => 'Deaktivovat uživatele',
		'sendpassword' => 'Poslat heslo',
		'ownvhostsettings' => 'Vlastní nastavení vHost-serveru',
		'configfiles' => [
			'serverconfiguration' => 'Konfigurace',
			'overview' => 'Přehled',
			'wizard' => 'Průvodce',
			'distribution' => 'Distribuce',
			'service' => 'Služba',
			'daemon' => 'Daemon',
			'http' => 'Webový server (HTTP)',
			'dns' => 'Nameserver (DNS)',
			'mail' => 'Poštovní server (IMAP/POP3)',
			'smtp' => 'Mailový server (SMTP)',
			'ftp' => 'FTP-server',
			'etc' => 'Ostatní (Systém)',
			'choosedistribution' => '-- Vyberte distribuci --',
			'chooseservice' => '-- Vyberte službu --',
			'choosedaemon' => '-- Zvolte daemon --',
			'statistics' => 'Statistiky',
			'compactoverview' => 'Kompaktní přehled',
			'legend' => '<h3>Chystáte se nakonfigurovat službu/daemon</h3>',
			'commands' => '<span class="text-danger">Příkazy:</span> Tyto příkazy mají být spuštěny po řádku jako uživatel rootu v shellu. Je bezpečné zkopírovat celý blok a vložit ho do konzole.',
			'files' => '<span class="text-danger">Konfigurační soubory:</span> Příkazy před textovými poli by měly otevřít editor s cílovým souborem. Stačí jen zkopírovat a vložit obsah do editoru a uložit soubor.<br><span class="text-danger">Upozornění:</span> MySQL heslo nebylo z bezpečnostních důvodů nahrazeno. Prosím nahraďte "FROXLOR_MYSQL_PASSWORD" samostatně nebo použijte formulář javascript níže k nahrazení na webu. Pokud jste zapomněli heslo k MySQL, najdete ho v "lib/userdata.inc.php"',
			'importexport' => 'Importovat/Exportovat',
			'finishnote' => 'Soubor parametru byl úspěšně vygenerován. Nyní spusťte následující příkaz jako root:',
			'description' => 'Konfigurace systémových služeb',
			'minihowto' => 'Na této stránce můžete zobrazit různé konfigurační šablony pro každou službu, (opětovně)konfigurovat specifické služby v případě potřeby nebo exportovat aktuální výběr do JSON souboru pro použití ve skriptech CLI nebo na jiném serveru.<br><br><b>Poznámka</b>, že zvýrazněné služby neodrážejí aktuální nastavení, ale ukazují požadavky/doporučení z vašich aktuálních hodnot nastavení.',
			'skipconfig' => 'Ne(re)konfigurovat',
			'recommendednote' => 'Doporučené/požadované služby založené na aktuálním nastavení systému',
			'selectrecommended' => 'Vybrat doporučené',
			'downloadselected' => 'Exportovat vybrané',
		],
		'templates' => [
			'templates' => 'Šablony e-mailů',
			'template_add' => 'Přidat šablonu',
			'template_fileadd' => 'Přidat šablonu souboru',
			'template_edit' => 'Upravit šablonu',
			'action' => 'Akce',
			'email' => 'E-mailové a souborové šablony',
			'subject' => 'Předmět',
			'mailbody' => 'Text e-mailu',
			'createcustomer' => 'Uvítací e-mail pro nové zákazníky',
			'pop_success' => 'Uvítací e-mail pro nové e-mailové účty',
			'template_replace_vars' => 'Proměnné, které mají být nahrazeny v šabloně:',
			'SALUTATION' => 'Nahrazeno správným oslovením (jméno nebo název společnosti)',
			'FIRSTNAME' => 'Nahrazeno křestním jménem zákazníka.',
			'NAME' => 'Nahrazeno jménem zákazníka.',
			'COMPANY' => 'Nahrazuje název firmy zákazníka',
			'USERNAME' => 'Nahradí uživatelským jménem zákazníka.',
			'PASSWORD' => 'Nahradí heslem zákazníka.',
			'EMAIL' => 'Nahrazeno adresou účtu POP3/IMAP.',
			'CUSTOMER_NO' => 'Nahradí číslo zákazníka',
			'TRAFFIC' => 'Nahrazeno provozem, který byl přiřazen zákazníkovi.',
			'TRAFFICUSED' => 'Nahrazeno provozem, který byl zákazníkem vyčerpán.',
			'pop_success_alternative' => 'Uvítací e-mail pro nové e-mailové účty odeslaný na alternativní adresu',
			'EMAIL_PASSWORD' => 'Nahradí heslem účtu POP3/IMAP.',
			'index_html' => 'indexový soubor pro nově vytvořené adresáře zákazníků',
			'unconfigured_html' => 'soubor indexu pro nenastavené/neznámé domény',
			'unconfigured_content_fallback' => 'Tato doména vyžaduje konfiguraci prostřednictvím panelu pro správu serveru froxlor, protože v současné době není přiřazena žádnému zákazníkovi.',
			'file_extension' => [
				'description' => 'Přípona souboru pro index musí být v rozmezí 1 až 6 znaků. Rozšíření může obsahovat pouze znaky jako a-z, A-Z a 0-9<br><br>Výchozí: html',
				'title' => 'Přípona souboru pro šablonu souboru',
			],
			'SERVERNAME' => 'Nahrazeno jménem serveru.',
			'CUSTOMER' => 'Nahrazeno přihlašovacím jménem zákazníka. Pouze pro "indexový soubor pro nově vytvořené adresáře zákazníků"',
			'ADMIN' => 'Nahrazeno přihlašovacím jménem správce. Pouze pro "indexový soubor pro nově vytvořené adresáře zákazníků"',
			'CUSTOMER_EMAIL' => 'Nahrazeno e-mailovou adresou zákazníka. Pouze pro "indexový soubor pro nově vytvořené adresáře zákazníků"',
			'ADMIN_EMAIL' => 'Nahrazeno e-mailovou adresou správce. Pouze pro "indexový soubor pro nově vytvořené adresáře zákazníků"',
			'filetemplates' => 'Šablony souborů',
			'filecontent' => 'Obsah souboru',
			'new_database_by_customer' => 'Upozornění zákazníka na vytvoření databáze',
			'new_ftpaccount_by_customer' => 'Upozornění zákazníka na vytvoření ftp uživatele',
			'newdatabase' => 'Notifikační-maily o nových databázích',
			'newftpuser' => 'Notifikační-maily o nových ftp uživatelích',
			'CUST_NAME' => 'Jméno zákazníka',
			'DB_NAME' => 'Jméno databáze',
			'DB_PASS' => 'Heslo databáze',
			'DB_DESC' => 'Popis databáze',
			'DB_SRV' => 'Databázový server',
			'PMA_URI' => 'URL na phpMyAdmin (pokud byl poskytnut)',
			'USR_NAME' => 'FTP uživatelské jméno',
			'USR_PASS' => 'FTP heslo',
			'USR_PATH' => 'Domovský adresář FTP (relativní k adresáři customer-docroot)',
			'forgotpwd' => 'Notifikační-maily o resetu hesla',
			'password_reset' => 'Upozornění pro zákazníka na resetování hesla',
			'trafficmaxpercent' => 'Upozornění pro zákazníky při vyčerpání daného maximálního procenta provozu',
			'MAX_PERCENT' => 'Nahrazeno limitem využití disku/limitu provozu pro odesílání zpráv v procentech.',
			'USAGE_PERCENT' => 'Nahrazeno využitím disku / provozem, který byl zákazníkem vyčerpán v procentech.',
			'diskmaxpercent' => 'Oznamovací e-mail pro zákazníky, pokud je vyčerpáno maximum procent z disku',
			'DISKAVAILABLE' => 'Nahrazeno využitím disku, který byl přiřazen zákazníkovi.',
			'DISKUSED' => 'Nahrazeno využitím disku, který byl zákazníkem vyčerpán.',
			'LINK' => 'Nahrazeno odkazem na obnovení hesla zákazníka.',
			'SERVER_HOSTNAME' => 'Nahradí název systémového hostitele (URL do froxlor)',
			'SERVER_IP' => 'Nahradí výchozí Ip adresu serveru',
			'SERVER_PORT' => 'Nahradí výchozí port serveru',
			'DOMAINNAME' => 'Nahrazuje standardní subdoménu zákazníka (může být prázdná, pokud není vygenerována žádná)',
		],
		'webserver' => 'Webový server',
		'createzonefile' => 'Vytvořit zónu dns pro doménu',
		'custombindzone' => 'Vlastní / nespravovaný soubor zóny',
		'bindzonewarning' => 'pro výchozí nastavení<br /><strong class="text-danger">POZOR:</strong> Pokud používáte zonefile, budete muset ručně spravovat všechny požadované záznamy i pro všechny podzóny.',
		'ipsandports' => [
			'ipsandports' => 'IP aresy a porty',
			'add' => 'Přidat IP/port',
			'edit' => 'Upravit IP/port',
			'ipandport' => 'IP/Port',
			'ip' => 'IP',
			'ipnote' => '<div id="ipnote" class="invalid-feedback">Poznámka: Ačkoli jsou soukromé IP adresy povoleny, některé funkce jako DNS se nemusí chovat správně.<br>Používejte pouze soukromé IP adresy, pokud jste si jisti.</div>',
			'port' => 'Port',
			'create_listen_statement' => 'Vytvořit Listen statement',
			'create_namevirtualhost_statement' => 'Vytvořit výpis VirtualHost',
			'create_vhostcontainer' => 'Vytvořit vHost-Container',
			'create_vhostcontainer_servername_statement' => 'Vytvořit výpis ServerName v kontejneru vHost-Container',
			'enable_ssl' => 'Je tohle SSL port?',
			'ssl_cert_file' => 'Cesta k certifikátu SSL',
			'webserverdefaultconfig' => 'Výchozí nastavení webserveru',
			'webserverdomainconfig' => 'Konfigurace domény Webserveru',
			'webserverssldomainconfig' => 'Konfigurace Webserveru SSL',
			'ssl_key_file' => 'Cesta k souboru klíče SSL',
			'ssl_ca_file' => 'Cesta k SSL CA certifikátu',
			'default_vhostconf_domain' => 'Výchozí nastavení vHost pro každý kontejner domény',
			'ssl_cert_chainfile' => [
				'title' => 'Cesta k souboru SSL CertificateChainFile',
				'description' => 'Většinou CA_Bundle, nebo podobně, to pravděpodobně chcete nastavit, pokud jste si koupili SSL certifikát.',
			],
			'docroot' => [
				'title' => 'Vlastní docroot (prázdný = ukazuje na Froxlor)',
				'description' => 'Zde můžete definovat vlastní kořenový adresář dokumentu (cíl požadavku) pro tuto kombinaci IP/port.<br /><strong>POZOR:</strong> Dávejte pozor, co zde zadáváte!',
			],
			'ssl_paste_description' => 'Vložte svůj úplný obsah certifikátu do textového pole',
			'ssl_cert_file_content' => 'Obsah certifikátu ssl',
			'ssl_key_file_content' => 'Obsah souboru ssl (soukromého) klíče',
			'ssl_ca_file_content' => 'Obsah souboru ssl CA (nepovinné)',
			'ssl_ca_file_content_desc' => '<br /><br />Ověřování klienta, nastavte to pouze pokud víte, co je.',
			'ssl_cert_chainfile_content' => 'Obsah souboru certifikačního řetězce (nepovinné)',
			'ssl_cert_chainfile_content_desc' => '<br /><br />Nejčastěji CA_Bundle nebo podobný, pravděpodobně jej budete chtít nastavit, pokud jste si zakoupili SSL certifikát.',
			'ssl_default_vhostconf_domain' => 'Výchozí nastavení SSL vHost pro každý kontejner domény',
		],
		'memorylimitdisabled' => 'Zakázáno',
		'valuemandatory' => 'Tato hodnota je povinná',
		'valuemandatorycompany' => 'Musí být vyplněno buď "jméno" a "křestní jméno" nebo "název společnosti"',
		'serversoftware' => 'Software serveru',
		'phpversion' => 'Verze PHP',
		'mysqlserverversion' => 'Verze MySQL serveru',
		'webserverinterface' => 'Rozhraní Webserveru',
		'accountsettings' => 'Nastavení účtu',
		'panelsettings' => 'Nastavení panelu',
		'systemsettings' => 'Systemová nastavení',
		'webserversettings' => 'Nastavení webserveru',
		'mailserversettings' => 'Nastavení webserveru',
		'nameserversettings' => 'Nastavení nameserveru',
		'updatecounters' => 'Přepočítat využití zdrojů',
		'subcanemaildomain' => [
			'never' => 'Nikdy',
			'choosableno' => 'Volitelný, výchozí ne',
			'choosableyes' => 'Volitelné, výchozí ano',
			'always' => 'Vždy',
		],
		'wipecleartextmailpwd' => 'Vymazat prostý text hesla',
		'webalizersettings' => 'Nastavení Webalizéru',
		'webalizer' => [
			'normal' => 'Normální',
			'quiet' => 'Tiché',
			'veryquiet' => 'Žádný výstup',
		],
		'domain_nocustomeraddingavailable' => 'V současné době není možné přidat doménu. Nejprve musíte přidat alespoň jednoho zákazníka.',
		'loggersettings' => 'Nastavení logování',
		'logger' => [
			'normal' => 'normální',
			'paranoid' => 'paranoid',
		],
		'emaildomain' => 'E-mailová doména',
		'email_only' => 'Pouze e-mail?',
		'wwwserveralias' => 'Přidat "www." ServerAlias',
		'subject' => 'Předmět',
		'recipient' => 'Příjemce',
		'message' => 'Napsat zprávu',
		'text' => 'Zpráva',
		'sslsettings' => 'Nastavení SSL',
		'specialsettings_replacements' => 'Můžete použít následující proměnné:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code> <code>{IP}</code>, <code>{PORT}</code> <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (připadá-li v úvahu)<br/>',
		'antispam_settings' => 'Nastavení Antispamu',
		'caneditphpsettings' => 'Může změnit php nastavení domény?',
		'allips' => 'Všechny IP adresy',
		'awstatssettings' => 'Nastavení AWstatu',
		'domain_dns_settings' => 'Nastavení doménové dns',
		'activated' => 'Aktivováno',
		'statisticsettings' => 'Nastavení statistik',
		'or' => 'nebo',
		'sysload' => 'Systémové zatížení',
		'noloadavailable' => 'neni k dispozici',
		'nouptimeavailable' => 'neni k dispozici',
		'nosubject' => '(Bez předmětu)',
		'security_settings' => 'Možnosti zabezpečení',
		'know_what_youre_doing' => 'Změňte pouze, pokud víte, co děláte!',
		'show_version_login' => [
			'title' => 'Zobrazit Froxlor verzi při přihlášení',
			'description' => 'Zobrazit Froxlor verzi v zápatí na přihlašovací stránce',
		],
		'show_version_footer' => [
			'title' => 'Zobrazit Froxlor verzi v zápatí',
			'description' => 'Zobrazit Froxlor verzi v zápatí na ostatních stránkách',
		],
		'froxlor_graphic' => [
			'title' => 'Grafické záhlaví pro Froxlor',
			'description' => 'Jaká grafika by měla být zobrazena v záhlaví',
		],
		'phpsettings' => [
			'title' => 'PHP konfigurace',
			'description' => 'Stručný popis',
			'actions' => 'Akce',
			'activedomains' => 'Používá se pro doménu/y',
			'notused' => 'Konfigurace se nepoužívá',
			'editsettings' => 'Změnit nastavení PHP',
			'addsettings' => 'Vytvořit nové nastavení PHP',
			'viewsettings' => 'Zobrazit nastavení PHP',
			'phpinisettings' => 'php.ini nastavení',
			'addnew' => 'Vytvořit novou konfiguraci PHP',
			'binary' => 'PHP Binary',
			'fpmdesc' => 'PHP-FPM konfigurace',
			'file_extensions' => 'Přípony souborů',
			'file_extensions_note' => '(bez tečky, oddělených mezerami)',
			'enable_slowlog' => 'Povolit slowlog (pro každou doménu)',
			'request_terminate_timeout' => 'Časový limit ukončení požadavku',
			'request_slowlog_timeout' => 'Časový limit ukončení požadavku slowlogu',
			'activephpconfigs' => 'Používá se pro php-config(y)',
			'pass_authorizationheader' => 'Předávání hlaviček HTTP AUTH BASIC/DIGEST z Apache do PHP',
		],
		'misc' => 'Ostatní',
		'fpmsettings' => [
			'addnew' => 'Vytvořit novou verzi PHP',
			'edit' => 'Změnit verzi PHP'
		],
		'phpconfig' => [
			'template_replace_vars' => 'Proměnné, které budou nahrazeny v konfiguraci',
			'pear_dir' => 'Bude nahrazeno globálním nastavením pro pearl adresář.',
			'open_basedir_c' => 'Vloží ; (středník) do komentáře/vypne open_basedir po nastavení',
			'open_basedir' => 'Bude nahrazeno nastavením domény open_basedir.',
			'tmp_dir' => 'Bude nahrazeno dočasným adresářem domény.',
			'open_basedir_global' => 'Bude nahrazena globální hodnotou cesty, která bude připojena k open_basedir (viz nastavení webserveru).',
			'customer_email' => 'Bude nahrazeno e-mailovou adresou zákazníka, který tuto doménu vlastní.',
			'admin_email' => 'Bude nahrazeno e-mailovou adresou správce, který tuto doménu vlastní.',
			'domain' => 'Bude nahrazeno doménou.',
			'customer' => 'Bude nahrazeno přihlašovacím jménem zákazníka, který vlastní tuto doménu.',
			'admin' => 'Bude nahrazeno přihlašovacím jménem správce, který tuto doménu vlastní.',
			'docroot' => 'Bude nahrazeno kořenovým textem domény.',
			'homedir' => 'Bude nahrazeno domovským adresářem zákazníka.',
		],
		'expert_settings' => 'Pokročilá nastavení!',
		'mod_fcgid_starter' => [
			'title' => 'PHP procesy pro tuto doménu (prázdné pro výchozí hodnotu)',
		],
		'phpserversettings' => 'Nastavení PHP',
		'mod_fcgid_maxrequests' => [
			'title' => 'Maximální počet php požadavků pro tuto doménu (ponechte prázdné pro výchozí hodnotu)',
		],
		'spfsettings' => 'Nastavení SPF domén',
		'specialsettingsforsubdomains' => 'Použít speciální nastavení pro všechny subdomény (*.example.com)',
		'accountdata' => 'Údaje o účtu',
		'contactdata' => 'Kontaktní údaje',
		'servicedata' => 'Údaje o službě',
		'newerversionavailable' => 'K dispozici je novější verze Froxloru.',
		'newerversiondetails' => 'Aktualizovat na verzi <b>%s</b> nyní?<br/>(Vaše aktuální verze je: %s)',
		'extractdownloadedzip' => 'Extrahovat stažený archiv "%s"?',
		'cron' => [
			'cronsettings' => 'Nastavení Cronjobu',
			'add' => 'Přidat cronjob',
		],
		'cronjob_edit' => 'Upravit cronjob',
		'warning' => 'VAROVÁNÍ - Vezměte prosím na vědomí!',
		'lastlogin_succ' => 'Poslední přihlášení',
		'ftpserver' => 'FTP Server',
		'ftpserversettings' => 'Nastavení FTP serveru',
		'webserver_user' => 'Uživatelské jméno webserveru',
		'webserver_group' => 'Název skupiny webserveru',
		'perlenabled' => 'Perl povolen',
		'fcgid_settings' => 'FCGID',
		'mod_fcgid_user' => 'Místní uživatel pro FCGID (Froxlor vHost)',
		'mod_fcgid_group' => 'Místní skupina k použití pro FCGID (Froxlor vHost)',
		'perl_settings' => 'Perl/CGI',
		'notgiven' => '[neposkytnuto]',
		'store_defaultindex' => 'Uložit výchozí indexový soubor zákazníkům docroot',
		'phpfpm_settings' => 'PHP-FPM',
		'traffic' => 'Provoz',
		'traffic_sub' => 'Podrobnosti o využití provozu',
		'domaintraffic' => 'Domény',
		'customertraffic' => 'Zákazníci',
		'assignedmax' => 'Přiřazeno / Max',
		'usedmax' => 'Použito / Max',
		'used' => 'Využito',
		'speciallogwarning' => '<div id=„speciallogfilenote“ class=„invalid-feedback“>Pozor: Změnou tohoto nastavení ztratíte všechny staré statistiky pro tuto doménu.</div>',
		'speciallogfile' => [
			'title' => 'Oddělit soubor logu',
			'description' => 'Povolením této možnosti získáte pro tuto doménu samostatný soubor přístupového protokolu',
		],
		'domain_editable' => [
			'title' => 'Povolit úpravy domény',
			'desc' => 'Pokud je nastaveno ano, může zákazník změnit několik nastavení domény.<br />Pokud je nastaveno ne, nemůže zákazník nic měnit.',
		],
		'writeaccesslog' => [
			'title' => 'Zapisovat přístupový protokol',
			'description' => 'Povolením této možnosti získáte soubor protokolu přístupu pro tuto doménu',
		],
		'writeerrorlog' => [
			'title' => 'Zapsat protokol chyb',
			'description' => 'Povolením této funkce získáte soubor s chybovým protokolem pro tuto doménu',
		],
		'phpfpm.ininote' => 'Ne všechny hodnoty, které chcete definovat, mohou být použity v konfiguraci php-fpm poolu',
		'phpinfo' => 'PHPinfo()',
		'selectserveralias' => 'Hodnota ServerAlias pro doménu',
		'selectserveralias_desc' => 'Vyberte, zda by froxlor měl vytvořit wildcard-entry (*.domain.tld), WWW-alias (www.domain.tld) nebo vůbec žádný alias',
		'show_news_feed' => [
			'title' => 'Zobrazit novinky na admin nástěnce',
			'description' => 'Povolením zobrazíte oficiální novinky Froxlor (https://inside.froxlor.org/news/) na vaší nástěnce a nikdy nezmeškejte důležité informace nebo oznámení o vydání.',
		],
		'cronsettings' => 'Nastavení Cronjobu',
		'integritycheck' => 'Ověření databáze',
		'integrityname' => 'Název',
		'integrityresult' => 'Výsledek',
		'integrityfix' => 'Automaticky opravit problémy',
		'customer_show_news_feed' => 'Zobrazit novinky na řídicím panelu zákazníka',
		'customer_news_feed_url' => [
			'title' => 'Použít vlastní RSS-feed',
			'description' => 'Zadejte vlastní RSS kanál, který bude zobrazen vašim zákazníkům na jejich nástěnce.<br /><small>Ponechte prázdné pro použití oficiálního froxlor newsfeed (https://inside.froxlor.org/news/).</small>',
		],
		'movetoadmin' => 'Přesunout zákazníka',
		'movecustomertoadmin' => [
			'title' => 'Přesunout zákazníka na vybraného administrátora/prodejce',
			'description' => 'Ponechte prázdné pro žádnou změnu.<br />Pokud se požadovaný administrátor nezobrazí v seznamu, jeho zákaznický limit byl dosažen.',
		],
		'note' => 'Poznámka',
		'mod_fcgid_umask' => [
			'title' => 'Umask (výchozí: 022)',
		],
		'apcuinfo' => 'APCu info',
		'opcacheinfo' => 'OPcache Info',
		'letsencrypt' => [
			'title' => 'Použít Let\'s Encrypt',
			'description' => 'Získejte zdarma certifikát od <a href="https://letsencrypt.org">Let\'s Encrypt</a>. Certifikát bude vytvořen a obnoven automaticky.<br><strong class="text-danger">POZNÁMKA:</strong> Pokud jsou povoleny wildcards, tato možnost bude automaticky zakázána.',
		],
		'autoupdate' => 'Automatická aktualizace',
		'server_php' => 'PHP',
		'dnsenabled' => 'Povolit DNS editor',
		'froxlorvhost' => 'Froxlor VirtualHost nastavení',
		'hostname' => 'Název serveru',
		'memory' => 'Využití paměti',
		'webserversettings_ssl' => 'Nastavení SSL Webserveru',
		'domain_hsts_maxage' => [
			'title' => 'HTTP Strict Transport Security (HSTS)',
			'description' => 'Zadejte hodnotu maximálního věku pro záhlaví Strict-Transport-Security<br>Hodnota <i>0</i> zakáže HSTS pro doménu. Většina uživatelů nastavila hodnotu <i>31536000</i> (jeden rok).',
		],
		'domain_hsts_incsub' => [
			'title' => 'Zahrnout HSTS pro jakoukoliv subdoménu',
			'description' => 'Volitelná direktiva „includeSubDomains“, pokud je přítomna, signalizuje UA, že zásady HSTS se vztahují na tohoto hostitele HSTS i na všechny subdomény názvu domény hostitele.',
		],
		'domain_hsts_preload' => [
			'title' => 'Zahrnout doménu do seznamu přednačtených HSTS',
			'description' => 'Pokud chcete, aby byla tato doména zahrnuta do <a href="https://hstspreload.org/" target="_blank">HSTS preload listu</a> spravovaného Chrome (a používaného Firefoxem a Safari), poté použijte tuto aktivaci.<br>Odeslání preload direktivy z vašich stránek může mít TRVALÉ NÁSLEDKY a zabránit uživatelům v přístupu na vaše stránky a všechny jejich poddomény.<br>Před odesláním hlavičky s "preload" si prosím přečtěte podrobnosti na <a href="https://hstspreload.org/#removal" target="_blank">https://hstspreload.org/#removal</a>.',
		],
		'domain_ocsp_stapling' => [
			'title' => 'Stapling OCSP',
			'description' => 'Podrobné vysvětlení stapling OCSP viz <a target="_blank" href="https://en.wikipedia.org/wiki/OCSP_stapling">Wikipedia</a>',
			'nginx_version_warning' => '<br /><strong class="text-danger">VAROVÁNÍ:</strong> Nginx verze 1.3.7 nebo vyšší je vyžadována pro OCSP stapling. Pokud je vaše verze starší, webový server NEBUDE správně spuštěn, dokud je povoleno OCSP stapling!',
		],
		'domain_http2' => [
			'title' => 'HTTP2 podpora',
			'description' => 'Podrobné vysvětlení HTTP2 viz <a target="_blank" href="https://en.wikipedia.org/wiki/HTTP/2">Wikipedia</a>',
		],
		'testmail' => 'Test SMTP',
		'phpsettingsforsubdomains' => 'Použít php konfiguraci na všechny subdomény:',
		'plans' => [
			'name' => 'Název plánu',
			'description' => 'Popis',
			'last_update' => 'Naposledy aktualizováno',
			'plans' => 'Plány hostingu',
			'plan_details' => 'Detaily plánu',
			'add' => 'Přidat nový plán',
			'edit' => 'Upravit plán',
			'use_plan' => 'Použít plán',
		],
		'notryfiles' => [
			'title' => 'Žádné automatické generování try_souborů',
			'description' => 'Zde zvolte ano, pokud chcete ve sepciálním nastavcení zadat vlastní direktivu try_files (potřebnou například pro některé pluginy WordPressu).',
		],
		'logviewenabled' => 'Povolit přístup k logům přístupu/chyb',
		'novhostcontainer' => '<br><br><small class="text-danger">Žádná z IP a portů nemá povolenou možnost "Vytvořit vHost-Container", mnoho nastavení zde nebude k dispozici</small>',
		'ownsslvhostsettings' => 'Vlastní SSL vHost-nastavení',
		'domain_override_tls' => 'Přepsat nastavení systémového TLS',
		'domain_override_tls_addinfo' => '<br /><span class="text-danger">Používá se pouze v případě, že "Přepsat nastavení TLS systému" je nastaveno na "Ano"</span>',
		'domain_sslenabled' => 'Povolit použití SSL',
		'domain_honorcipherorder' => 'Dodržovat pořadí šifry (serveru), výchozí <strong>ne</strong>',
		'domain_sessiontickets' => 'Povolit TLS sessiontickety (RFC 5077), výchozí <strong>ano</strong>',
		'domain_sessionticketsenabled' => [
			'title' => 'Povolit použití tiketů TLS globálně',
			'description' => 'Výchozí <strong>ano</strong><br>Vyžaduje apache-2.4.11+ nebo nginx-1.5.9+',
		],
		'domaindefaultalias' => 'Výchozí hodnota serverAlias pro nové domény',
		'smtpsettings' => 'Nastavení SMTP',
		'smtptestaddr' => 'Odeslat testovací email na',
		'smtptestnote' => 'Níže uvedené hodnoty odrážejí vaše aktuální nastavení a lze je upravit pouze zde (viz odkaz v pravém horním rohu)',
		'smtptestsend' => 'Odeslat testovací e-mail',
		'mysqlserver' => [
			'mysqlserver' => 'MySQL Server',
			'dbserver' => 'Server #',
			'caption' => 'Popis',
			'host' => 'Název serveru / IP',
			'port' => 'Port',
			'user' => 'Oprávněný uživatel',
			'add' => 'Přidat nový MySQL server',
			'edit' => 'Upravit MySQL server',
			'password' => 'Heslo oprávněného uživatele',
			'password_emptynochange' => 'Nové heslo, ponechte prázdné pro ponechání aktuálního',
			'allowall' => [
				'title' => 'Povolit použití tohoto serveru všem aktuálně existujícím zákazníkům',
				'description' => 'Nastavte tuto hodnotu na „true“, pokud chcete povolit používání tohoto databázového serveru všem stávajícím zákazníkům, aby na něj mohli přidávat databáze. Toto nastavení není trvalé, ale lze jej spustit vícekrát.',
			],
			'testconn' => 'Otestovat připojení při ukládání',
			'ssl' => 'Použít SSL pro připojení k databázovému serveru',
			'ssl_cert_file' => 'Cesta k souboru k SSL Certifikační autoritě',
			'verify_ca' => 'Povolit ověření serverového SSL certifikátu',
		],
		'settings_importfile' => 'Zvolit importovaný soubor',
		'documentation' => 'Dokumentace',
		'adminguide' => 'Admin průvodce',
		'userguide' => 'Uživatelský manuál',
		'apiguide' => 'Průvodce API',
		'domain_duplicate' => 'Duplikovat doménu',
		'domain_duplicate_named' => 'Duplikovat %s',
		'backups' => [
			'backups' => 'Zálohy',
		],
	],
	'apcuinfo' => [
		'clearcache' => 'Vymazat APCu mezipaměť',
		'generaltitle' => 'Obecné informace o cache',
		'version' => 'APCu verze',
		'phpversion' => 'Verze PHP',
		'host' => 'APCu hostitel',
		'sharedmem' => 'Sdílená paměť',
		'sharedmemval' => '%d Segment(y) s %s (%s paměti)',
		'start' => 'Čas spuštění',
		'uptime' => 'Doba provozu',
		'upload' => 'Podpora nahrávání souborů',
		'cachetitle' => 'Informace o cache',
		'cvar' => 'Proměnné v mezipaměti',
		'hit' => 'Zásahy',
		'miss' => 'Nevyužito',
		'reqrate' => 'Míra požadavku (zásahy, nevyužité)',
		'creqsec' => 'požadavky mezipaměti za sekundu',
		'hitrate' => 'Rychlost zásahu',
		'missrate' => 'Nevyužitá míra',
		'insrate' => 'Insert Rate',
		'cachefull' => 'Plný počet vyrovnávací paměti',
		'runtime' => 'Nastavení spuštění',
		'memnote' => 'Využití paměti',
		'total' => 'Celkem',
		'free' => 'Volné',
		'used' => 'Využito',
		'hitmiss' => 'Zásahy & Nevyužití',
		'detailmem' => 'Podrobné využití paměti a fragmentace',
		'fragment' => 'Fragmentace',
		'nofragment' => 'Bez fragmentace',
		'fragments' => 'Fragmentace',
	],
	'apikeys' => [
		'no_api_keys' => 'Nebyly nalezeny žádné API klíče',
		'key_add' => 'Přidat nový klíč',
		'apikey_removed' => 'Api klíč s Id #%s byl úspěšně odstraněn',
		'apikey_added' => 'Byl úspěšně vygenerován nový api klíč',
		'clicktoview' => 'Klikněte pro zobrazení',
		'allowed_from' => 'Povoleno od',
		'allowed_from_help' => 'Čárkami oddělený seznam Ip adres / sítí.<br>Výchozí nastavení je prázdné (povolit od všech).',
		'valid_until' => 'Platné do',
		'valid_until_help' => 'Datum do platnosti, formát RRRR-MM-DDTh:mm',
	],
	'changepassword' => [
		'old_password' => 'Staré heslo',
		'new_password' => 'Nové heslo',
		'new_password_confirm' => 'Potvrdit heslo',
		'new_password_ifnotempty' => 'Nové heslo (prázdné = žádná změna)',
		'also_change_ftp' => ' také změnit heslo hlavního FTP účtu',
		'also_change_stats' => ' také změnit heslo pro stránku se statistikou',
		'also_change_global_mysql' => 'také změnit heslo pro globální MySQL účet',
	],
	'cron' => [
		'cronname' => 'název cronjobu',
		'lastrun' => 'poslední spuštění',
		'interval' => 'interval',
		'isactive' => 'povoleno',
		'description' => 'popis',
		'changewarning' => 'Změna těchto hodnot může mít negativní příčinu chování Froxlor a jeho automatických úloh.<br />Změňte hodnoty zde pouze pokud jste si jisti, že víte, co děláte.',
	],
	'crondesc' => [
		'cron_unknown_desc' => 'nebyl zadán žádný popis',
		'cron_tasks' => 'Generování konfiguračních souborů',
		'cron_legacy' => 'starší (starý) cronjob',
		'cron_traffic' => 'Výpočet datového provozu',
		'cron_usage_report' => 'Hlášení o provozu a webu',
		'cron_mailboxsize' => 'Výpočet velikosti schránky',
		'cron_letsencrypt' => 'Aktualizace certifikátu Let\'s Encrypt',
		'cron_export' => 'Zpracování úloh exportu dat',
		'cron_backup' => 'Zpracování úloh zálohování systému a zákazníků',
	],
	'cronjob' => [
		'cronjobsettings' => 'Nastavení Cronjobu',
		'cronjobintervalv' => 'Hodnota intervalu běhu',
		'cronjobinterval' => 'Interval běhu',
	],
	'cronjobs' => [
		'notyetrun' => 'Ještě nespuštěno',
	],
	'cronmgmt' => [
		'minutes' => 'minut',
		'hours' => 'hodin',
		'days' => 'dní',
		'weeks' => 'týdnů',
		'months' => 'měsíců',
	],
	'customer' => [
		'documentroot' => 'Domovský adresář',
		'name' => 'Název',
		'firstname' => 'Křestní jméno',
		'lastname' => 'Příjmení',
		'company' => 'Firma',
		'nameorcompany_desc' => 'Křestní jméno/příjmení nebo firma je povinná',
		'street' => 'Ulice',
		'zipcode' => 'Psč',
		'city' => 'Město',
		'phone' => 'Mobil',
		'fax' => 'Fax',
		'email' => 'Email',
		'customernumber' => 'ID zákazníka',
		'diskspace' => 'Webový prostor',
		'traffic' => 'Provoz',
		'mysqls' => 'Databáze MySQL',
		'emails' => 'E-mailové adresy',
		'accounts' => 'E-mailové účty',
		'forwarders' => 'E-mailoví přeposílači',
		'ftps' => 'FTP účty',
		'subdomains' => 'Subdomény',
		'domains' => 'Domény',
		'mib' => 'MiB',
		'gib' => 'GiB',
		'title' => 'Název',
		'country' => 'Země',
		'email_quota' => 'Kvóta e-mailu',
		'email_imap' => 'E-mail IMAP',
		'email_pop3' => 'E-mail POP3',
		'sendinfomail' => 'Poslat mi data e-mailem',
		'generated_pwd' => 'Návrh hesla',
		'usedmax' => 'Použito / Max',
		'services' => 'Služby',
		'letsencrypt' => [
			'title' => 'Použít Let\'s Encrypt',
			'description' => 'Získejte zdarma certifikát od <a href="https://letsencrypt.org">Let\'s Encrypt</a>. Certifikát bude vytvořen a obnoven automaticky.',
		],
		'selectserveralias_addinfo' => 'Tuto možnost lze nastavit při úpravě domény. Její počáteční hodnota je zděděna z rodičovské domény.',
		'total_diskspace' => 'Celkový prostor na disku',
		'mysqlserver' => 'Použitelný mysql-server',
	],
	'diskquota' => 'Kvóta',
	'antispam' => [
		'config_file' => [
			'title' => 'Soubor s nastavením Antispamu',
			'description' => 'Zadejte název souboru pro pravidla e-mail-antispamu',
		],
		'reload_command' => [
			'title' => 'Příkaz k restartu systému Milter',
			'description' => 'Zadejte příkaz restartu pro službu rspamd',
		],
		'activated' => [
			'title' => 'Aktivovat antispam?',
			'description' => 'Chcete použít rspamd jako antispam službu?',
		],
		'dkim_keylength' => [
			'title' => 'DKIM délka klíče',
			'description' => 'Upozornění: Změny se budou vztahovat pouze na nové klíče<br/><br/>Vyžaduje určitou položku dns pro doménu. Pokud nepoužíváte funkci nameserver, budete muset tyto položky ručně spravovat.',
		],
		'spam_tag_level' => [
			'title' => 'Úroveň Spam tagu',
			'description' => 'Počet bodů, který je nutný k označení e-mailu jako spam<br/>Výchozí: 7.0'
		],
		'spam_kill_level' => [
			'title' => 'Úroveň likvidace spamu',
			'description' => 'Počet bodů, který je nutný k úplnému vyřazení e-mailu<br/>Výchozí: 14.0'
		],
		'bypass_spam' => [
			'title' => 'Obejít spamfiltr',
			'description' => 'Aktivací obejdete/zakážete filtrování spamu pro tuto adresu.<br/>Výchozí: ne'
		],
		'policy_greylist' => [
			'title' => 'Použít greylisting',
			'description' => 'Příchozí e-maily budou chráněny <a href="https://en.wikipedia.org/wiki/Greylisting_(email)" target="_blank">greylisting</a>.<br/>Výchozí: ano'
		],
		'required_dkim_dns' => 'Požadovaný DKIM DNS záznam',
	],
	'dns' => [
		'destinationip' => 'IP domény(y)',
		'standardip' => 'Standardní IP adresa serveru',
		'a_record' => 'A-záznam (volitelně IPv6)',
		'cname_record' => 'Záznam CNAME',
		'mxrecords' => 'Definovat MX záznamy',
		'standardmx' => 'Standardní MX záznam serveru',
		'mxconfig' => 'Vlastní MX záznamy',
		'priority10' => 'Priorita 10',
		'priority20' => 'Priorita 20',
		'txtrecords' => 'Definovat TXT záznamy',
		'txtexample' => 'Příklad (SPF-entry):<br />v=spf1 ip4:xxx.xxx.xx.0/23 -all',
		'howitworks' => 'Zde můžete spravovat DNS položky pro vaši doménu. Pamatujte, že froxlor automaticky vygeneruje NS/MX/A/AAAA záznamy pro vás. Vlastní položky jsou upřednostňovány, budou automaticky vygenerovány pouze chybějící položky.',
	],
	'dnseditor' => [
		'edit' => 'upravit DNS',
		'records' => 'záznamy',
		'notes' => [
			'A' => '32bitová adresa IPv4 používaná k mapování názvů hostitelů na IP adresu hostitele.',
			'AAAA' => '128-bitová IPv6 adresa, používaná k mapování jmen na IP adresu hostitele.',
			'CAA' => 'Záznam zdroje CAA umožňuje držiteli jména domény DNS zadat jednu nebo více certifikačních autorit (CA), které jsou oprávněny vydávat certifikáty pro tuto doménu.<br>Struktura: <code>značka tag[issue|issuewild|iodef|contactmail|contactphone] hodnota</code><br>Příklad: <code>0 issue "ca.example.net"<br>0 iodef "mailto:security@example.com"</code>',
			'CNAME' => 'Alias názvu domény, hledání DNS bude pokračovat opakováním hledání s novým názvem. Možné pouze pro subdomény!',
			'DNAME' => 'Vytvoří alias pro celý podstrom stromu domény',
			'LOC' => 'Informace o geografickém umístění pro název domény.<br>Struktura: <code>( d1 [m1 [s1]] {"N"|"S"} d2 [m2 [s2]] {"E"|"W"} alt["m"] [siz["m"] [hp["] [vp["m"]]]] )</code><br> <code>d1: [0 . 90] (stupně zeměpisné šířky)
			d2: [0 .. 180] (stupnice zeměpisné délky)
			m1, m2: [0 .. 59] (minuty zeměpisné šířky/délky)
			s1, s2: [0 .. 59. 99] (sekundy zeměpisné šířky/délky)
			t [-100000.00 .. 42849672.95] BY . 1 (výška v metrech)
			velikost, hp, vp: [0 .. 90000000. 0] (velikost/přesnost v metrech)</code><br>Příklad: <code>52 22 23.000 N 4 53 32.000 E -2,00m 000m 10000m</code>',
			'MX' => 'Záznam o výměně e-mailů, namapuje doménu na mailserver pro tuto doménu.<br>Příklad: <code>10 mail.example.com</code><br>Poznámka: Pro prioritu použijte pole výše',
			'NS' => 'Deleguje zónu DNS, aby použil dané autoritativní jmenné servery.',
			'RP' => 'Záznam odpovědné osoby<br>Struktura: <code>mailbox[nahraďte @ tečkou] txt-record-name</code><br>Příklad: <code>team.froxlor.org. froxlor.org.</code>',
			'SRV' => 'Záznam polohy služby, použitý pro novější protokoly namísto vytváření záznamů specifických pro protokol, jako je MX.<br>Struktura: <code>prioritní váhový port cíl</code><br>Příklad: <code>0 5 5060 sipserver. xample.com.</code><br>Poznámka: Pro prioritu použijte pole výše',
			'SSHFP' => 'Záznam zdroje SSHFP se používá ke zveřejnění otisků prstů klíče bezpečného shell (SSH) v DNS.<br>Struktura: <code>typ algoritmu</code><br>Algoritmy: <code>0: vyhrazeno, 1: RSA, 2: DSA, 3: ECDSA, 4: Ed25519, 6: Typy Ed448</code><br> <code>0: vyhrazené, 1: SHA-1, 2: SHA-256</code><br>Příklad: <code>2 1 123456789abcdef67890123456789abcdef67890</code>',
			'TLSA' => 'TLSA (TLS Authentication) záznam slouží ke zveřejnění otisku prstu certifikátu TLS/SSL. Běžně se používá pro DANE.<br>TLSA záznamy mohou být důvěryhodné, pouze pokud je DNSSEC povolena na vaší doméně.<br>Struktura: <code>typ otisku prstu</code><br>využití certifikátu: <code>0: PKIX-T, 1: PKIX-EE, 2: DANE-TA, 3: DANE-EE</code><br>selektor: <code>0: Použijte celý certifikát 1: Používejte podřízený veřejný klíč</code><br>Odpovídající typ: <code>0: Bez Hash, 1: SHA-256 Hash, 2:SHA-512 Hash</code><br>Příklad: <code>3 1 123456789abcdef67890123456789abcdef123456789abcdef123456789abcde</code>',
			'TXT' => 'Volně definovaný, popisný text.'
		]
	],
	'domain' => [
		'openbasedirpath' => 'OpenBasedir-cesta',
		'inherited' => 'Stejné jako rodičovská doména',
		'docroot' => 'Cesta z pole výše',
		'homedir' => 'Domovský adresář',
		'docparent' => 'Nadřazený adresář cesty z výše uvedeného pole',
		'ssl_certificate_placeholder' => '---- BEGIN CERTIFICATE---' . PHP_EOL . '[...]' . PHP_EOL . '----END CERTIFICATE----',
		'ssl_key_placeholder' => '---- BEGIN RSA PRIVATE KEY-----' . PHP_EOL . '[...]' . PHP_EOL . '-----END RSA PRIVATE KEY-----',
	],
	'domains' => [
		'description' => 'Zde můžete vytvořit (sub)domény a změnit jejich cesty.<br />Systém bude potřebovat nějaký čas, aby mohl po každé změně použít nové nastavení.',
		'domainsettings' => 'Nastavení domény',
		'domainname' => 'Název domény',
		'subdomain_add' => 'Vytvořit subdoménu',
		'subdomain_edit' => 'Upravit (sub)doménu',
		'wildcarddomain' => 'Vytvořit jako wildcarddomain?',
		'aliasdomain' => 'Alias pro doménu',
		'noaliasdomain' => 'Žádný alias domény',
		'hasaliasdomains' => 'Má alias doménu(y)',
		'statstics' => 'Statistiky využití',
		'isassigneddomain' => 'Je přiřazena doména',
		'add_date' => 'Přidáno do Froxloru',
		'registration_date' => 'Přidáno do registru',
		'topleveldomain' => 'Top-Level-Doména',
		'associated_with_domain' => 'Přidružené',
		'aliasdomains' => 'Alias domén',
		'redirectifpathisurl' => 'Přesměrovací kód (výchozí: prázdný)',
		'redirectifpathisurlinfo' => 'Musíte vybrat pouze jednu z těchto položek, pokud jste zadali adresu URL jako cestu<br/><strong class="text-danger">POZNÁMKA:</strong> Změny jsou aplikovány pouze v případě, že daná cesta je URL adresa.',
		'ipandport_multi' => [
			'title' => 'IP adresa (adresy)',
			'description' => 'Zadejte jednu nebo více IP adres domény.<br /><br /><div class="text-danger">POZNÁMKA: IP adresy nelze změnit, pokud je doména nakonfigurována jako <strong>alias-doména</strong> jiné domény.</div>',
		],
		'ipandport_ssl_multi' => [
			'title' => 'SSL IP adresa/y',
		],
		'ssl_redirect' => [
			'title' => 'Přesměrování SSL',
			'description' => 'Tato volba vytvoří přesměrování pro ne ssl vhosty, takže všechny požadavky jsou přesměrovány na SSL-vhost.<br /><br />e.. požadavek na <strong>http</strong>://domain.tld/ přesměruje vás na <strong>https</strong>://domain.tld/',
		],
		'serveraliasoption_wildcard' => 'Wildcard (*.domain.tld)',
		'serveraliasoption_www' => 'WWW (www.domain.tld)',
		'serveraliasoption_none' => 'Bez aliasu',
		'domain_import' => 'Importovat domény',
		'import_separator' => 'Oddělovač',
		'import_offset' => 'Odsazení',
		'import_file' => 'Soubor CSV',
		'import_description' => 'Podrobné informace o struktuře importního souboru a o úspěšném importu, navštivte prosím <a href="https://docs.froxlor.org/latest/admin-guide/domain-import/" target="_blank" class="alert-link">https://docs.froxlor.org/latest/admin-guide/domain-import/</a>',
		'ssl_redirect_temporarilydisabled' => '<br>Přesměrování protokolu SSL je dočasně deaktivováno, zatímco je generován nový Let\'s Encrypt certifikát. Bude znovu aktivováno po vygenerování certifikátu.',
		'termination_date' => 'Datum ukončení',
		'termination_date_overview' => 'ukončeno dne ',
		'ssl_certificates' => 'SSL certifikáty',
		'ssl_certificate_removed' => 'Certifikát s Id #%s byl úspěšně odstraněn',
		'ssl_certificate_error' => 'Chyba při čtení certifikátu pro doménu: %s',
		'no_ssl_certificates' => 'Neexistují žádné domény s SSL certifikátem',
		'isaliasdomainof' => 'Je aliasdoména pro %s',
		'isbinddomain' => 'Vytvořit zónu DNS',
		'dkimenabled' => 'DKIM povoleno',
		'openbasedirenabled' => 'Openbasedir restrikce',
		'hsts' => 'HSTS povoleno',
		'aliasdomainid' => 'ID aliasové domény',
		'nodomainsassignedbyadmin' => 'Váš účet nemá v současné době přiřazeny žádné (aktivní) domény. Pokud si myslíte, že je to špatné, kontaktujte svého správce.',
	],
	'emails' => [
		'description' => 'Zde můžete vytvářet a měnit své e-mailové adresy.<br />Účet je jako poštovní schránka před vaším domem. Pokud vám někdo pošle e-mail, bude vypuštěn na účet.<br /><br />Chcete-li stáhnout své e-maily, použijte následující nastavení ve vašem poštovním programu: (Data v <i>kurzívě</i> musí být změněna na ekvivalenty, které jste zadali!<br />Hostitelské jméno: <b><i>doménové jméno</i></b><br />Uživatelské jméno: <b><i>jméno účtu / e-mailová adresa</i></b><br />heslo: <b><i>heslo, které jste zvolili</i></b>',
		'emailaddress' => 'E-mailová adresa',
		'emails_add' => 'Vytvořit e-mailovou adresu',
		'emails_edit' => 'Upravit e-mailovou adresu',
		'catchall' => 'Catchall',
		'iscatchall' => 'Definovat jako catchall-adresu?',
		'account' => 'Účet',
		'account_add' => 'Vytvořit účet',
		'account_delete' => 'Odstranit účet',
		'from' => 'Zdroj',
		'to' => 'Destinace',
		'forwarders' => 'Přesměrování',
		'forwarder_add' => 'Vytvořit přeposílatele',
		'alternative_emailaddress' => 'Alternativní e-mailová adresa',
		'quota' => 'Kvóta',
		'noquota' => 'Bez kvóty',
		'updatequota' => 'Aktualizovat kvótu',
		'quota_edit' => 'Změnit E-Mail kvótu',
		'noemaildomainaddedyet' => 'Ve svém účtu ještě nemáte (e-mailovou) doménu.',
		'back_to_overview' => 'Zpět na přehled domény',
		'accounts' => 'Účty',
		'emails' => 'Adresy',
	],
	'error' => [
		'error' => 'Chyba',
		'directorymustexist' => 'Adresář %s musí existovat. Vytvořte jej prosím pomocí Vašeho FTP klienta.',
		'filemustexist' => 'Soubor %s musí existovat.',
		'allresourcesused' => 'Všechny své zdroje jste již využili.',
		'domains_cantdeletemaindomain' => 'Nemůžete odstranit přiřazenou doménu.',
		'domains_canteditdomain' => 'Tuto doménu nelze upravovat. Byla zakázána administrátorem.',
		'domains_cantdeletedomainwithemail' => 'Nemůžete odstranit doménu, která se používá jako e-mailová doména. Nejprve odstraňte všechny e-mailové adresy.',
		'firstdeleteallsubdomains' => 'Nejdříve musíte odstranit všechny subdomény, než budete moci vytvořit wildcard doménu.',
		'youhavealreadyacatchallforthisdomain' => 'Pro tuto doménu jste již definovali catchall.',
		'ftp_cantdeletemainaccount' => 'Nemůžete odstranit svůj hlavní FTP účet',
		'login' => 'Zadané uživatelské jméno nebo heslo je špatné. Zkuste to prosím znovu!',
		'login_blocked' => 'Tento účet byl pozastaven kvůli příliš mnoha chybám přihlášení. <br />Zkuste to prosím znovu za %s sekund.',
		'notallreqfieldsorerrors' => 'Nevyplnili jste všechna nebo jste nesprávně vyplnili některá pole.',
		'oldpasswordnotcorrect' => 'Staré heslo není správné.',
		'youcantallocatemorethanyouhave' => 'Nemůžete přidělit více zdrojů než pro sebe.',
		'mustbeurl' => 'Nezadal jsi platnou nebo úplnou Url (např. http://somedomain.com/error404.htm)',
		'invalidpath' => 'Nezvolili jste platnou adresu URL (možná problémy se seznamem adres?)',
		'stringisempty' => 'Chybějící vstup v poli',
		'stringiswrong' => 'Nesprávný vstup v poli',
		'newpasswordconfirmerror' => 'Nové heslo a potvrzení hesla se neshodují',
		'mydomain' => '\'Doména\'',
		'mydocumentroot' => '\'Documentroot\'',
		'loginnameexists' => 'Přihlašovací jméno %s již existuje',
		'emailiswrong' => 'Emailová adresa %s obsahuje neplatné znaky nebo je nekompletní',
		'alternativeemailiswrong' => 'Zadaná alternativní e-mailová adresa %s pro odeslání přihlašovacích údajů se zdá být neplatná',
		'loginnameiswrong' => 'Přihlašovací jméno "%s" obsahuje nepovolené znaky.',
		'loginnameiswrong2' => 'Přihlašovací jméno obsahuje příliš mnoho znaků. Pouze %s znaky jsou povoleny.',
		'userpathcombinationdupe' => 'Kombinace uživatelského jména a cesty již existuje',
		'patherror' => 'Obecná chyba! Cesta nemůže být prázdná',
		'errordocpathdupe' => 'Možnost pro cestu %s již existují',
		'adduserfirst' => 'Nejprve prosím vytvořte zákazníka',
		'domainalreadyexists' => 'Doména %s je již přiřazena zákazníkovi',
		'nolanguageselect' => 'Nebyl vybrán žádný jazyk.',
		'nosubjectcreate' => 'Musíte definovat téma pro tuto šablonu e-mailu.',
		'nomailbodycreate' => 'Musíte definovat text e-mailu pro tuto šablonu e-mailu.',
		'templatenotfound' => 'Šablona nebyla nalezena.',
		'alltemplatesdefined' => 'Nemůžete definovat více šablon, všechny jazyky jsou již podporovány.',
		'wwwnotallowed' => 'www není povoleno pro subdomény.',
		'subdomainiswrong' => 'Subdoména %s obsahuje neplatné znaky.',
		'domaincantbeempty' => 'Název domény nemůže být prázdný.',
		'domainexistalready' => 'Doména %s již existuje.',
		'domainisaliasorothercustomer' => 'Vybraná doména aliasu je sama o sobě doménou, má jinou kombinaci ip/port nebo patří jinému zákazníkovi.',
		'emailexistalready' => 'E-mailová adresa %s již existuje.',
		'maindomainnonexist' => 'Hlavní doména %s neexistuje.',
		'maindomaindeactivated' => 'Hlavní doména %s je deaktivována.',
		'destinationnonexist' => 'Prosím vytvořte předavatele v poli "Destination".',
		'destinationalreadyexistasmail' => 'Přeposílatel do %s již existuje jako aktivní e-mailová adresa.',
		'destinationalreadyexist' => 'Již jste definovali přesměrování na "%s"',
		'destinationiswrong' => 'Přeposílatel(é) %s obsahuje neplatné znaky nebo je neúplný.',
		'dumpfoldercannotbedocroot' => 'Složka pro datové výpisy nemůže být váš domovský adresář, zvolte prosím složku ve svém domovském adresáři, např. /dumps',
		'templatelanguagecombodefined' => 'Kombinace vybraného jazyka/šablony již byla definována.',
		'templatelanguageinvalid' => 'Vybraný jazyk neexistuje',
		'ipstillhasdomains' => 'Kombinace IP/portu, kterou chcete odstranit, stále obsahuje přiřazené domény, před smazáním této kombinace IP/portu je prosím přiřaďte k jiným kombinacím IP/portu.',
		'cantdeletedefaultip' => 'Nelze odstranit výchozí kombinaci IP/portu, před smazáním této kombinace IP/portu prosím nastavte výchozí nastavení jiné kombinace IP/portu.',
		'cantdeletesystemip' => 'Nelze odstranit poslední systémovou IP adresu ani vytvořit novou kombinaci IP/Port pro systémovou IP adresu nebo změnit systémovou IP adresu.',
		'myipaddress' => '\'IP\'',
		'myport' => '\'Port\'',
		'myipdefault' => 'Musíte vybrat kombinaci IP/port, která by měla být výchozí.',
		'myipnotdouble' => 'Tato kombinace IP/portu již existuje.',
		'admin_domain_emailsystemhostname' => 'Jméno serveru nelze použít jako doménu zákazníka.',
		'cantchangesystemip' => 'Nelze změnit poslední systémovou IP adresu ani vytvořit novou kombinaci IP/Port pro systémovou IP adresu nebo změnit systémovou IP adresu.',
		'sessiontimeoutiswrong' => 'Je povolen pouze číselný "časový limit relace".',
		'maxloginattemptsiswrong' => 'Jsou povoleny pouze číselné "maximální pokusy o přihlášení".',
		'deactivatetimiswrong' => 'Jsou povoleny pouze číselné "doby deaktivace".',
		'accountprefixiswrong' => '"Zákaznický prefix" je nesprávný.',
		'mysqlprefixiswrong' => '"SQL prefix" je nesprávný.',
		'ftpprefixiswrong' => 'Prefix FTP je špatný.',
		'ipiswrong' => '"IP-adresa" je špatně. Je povoleno pouze platná IP adresa.',
		'vmailuidiswrong' => '"UID-Mailů" je nesprávné. Je povoleno pouze číselné UID.',
		'vmailgidiswrong' => 'Položka „mails-gid“ je chybná. Povoleno je pouze číselné GID.',
		'adminmailiswrong' => '"Odesílatelská adresa" je chybná. Povolena je pouze platná e-mailová adresa.',
		'pagingiswrong' => 'Hodnota "Položky na stránku" je špatná. Povoleny jsou pouze číselné znaky.',
		'phpmyadminiswrong' => 'PhpMyAdmin-link není platný odkaz.',
		'webmailiswrong' => 'Odkaz na webmail není platný odkaz.',
		'webftpiswrong' => 'WebFTP odkaz není platným odkazem.',
		'stringformaterror' => 'Hodnota pro pole "%s" není v očekávaném formátu.',
		'loginnameisusingprefix' => 'Nemůžete vytvořit účty, které začínají znakem „%s“, protože tento prefix je nastaven na automatické pojmenování účtu. Zadejte prosím jiný název účtu.',
		'loginnameissystemaccount' => 'Účet "%s" již v systému existuje a nelze jej použít. Zadejte jiný název účtu.',
		'loginnameisreservedname' => 'Název účtu „%s“ je vyhrazen pro vnitřní systém a nelze jej použít.',
		'youcantdeleteyourself' => 'Z bezpečnostních důvodů nelze odstranit sám sebe.',
		'youcanteditallfieldsofyourself' => 'Poznámka: Z bezpečnostních důvodů nelze upravovat všechna pole vlastního účtu.',
		'documentrootexists' => 'Adresář "%s" již pro tohoto zákazníka existuje. Před přidáním zákazníka jej odstraňte.',
		'norepymailiswrong' => 'Položka „Noreply-address“ je chybná. Povolena je pouze platná e-mailová adresa.',
		'logerror' => 'Chyba logu: %s',
		'nomessagetosend' => 'Nezadali jste zprávu.',
		'norecipientsgiven' => 'Nezadali jste žádného příjemce',
		'errorsendingmail' => 'Zpráva pro "%s" se nezdařila',
		'errorsendingmailpub' => 'Zpráva na danou e-mailovou adresu se nezdařila',
		'cannotreaddir' => 'Nelze přečíst adresář "%s"',
		'invalidip' => 'Neplatná IP adresa: %s',
		'invalidmysqlhost' => 'Neplatná adresa MySQL hostitele: %s',
		'cannotuseawstatsandwebalizeratonetime' => 'Nemůžete povolit Webalizer a AWstats zároveň, zvolte si jeden z nich',
		'cannotwritetologfile' => 'Nelze otevřít soubor protokolu %s pro zápis',
		'vmailquotawrong' => 'Kvóta musí být kladné číslo.',
		'allocatetoomuchquota' => 'Pokusili jste se přidělit %s MB kvótu, ale již vám nezbývá dostatek.',
		'missingfields' => 'Ne všechna povinná pole byla vyplněna.',
		'requiredfield' => 'Toto pole je povinné.',
		'accountnotexisting' => 'Zadaný e-mailový účet neexistuje.',
		'nopermissionsorinvalidid' => 'Nemáte dostatečná oprávnění ke změně tohoto nastavení nebo bylo uděleno neplatné Id.',
		'phpsettingidwrong' => 'PHP konfigurace s tímto ID neexistuje',
		'descriptioninvalid' => 'Popis je příliš krátký/příliš dlouhý nebo obsahuje nepovolené znaky.',
		'info' => 'Info',
		'filecontentnotset' => 'Soubor nemůže být prázdný!',
		'customerdoesntexist' => 'Zvolený zákazník neexistuje.',
		'admindoesntexist' => 'Zvolený administrátor neexistuje.',
		'ipportdoesntexist' => 'Kombinace ip/portu, kterou jste zvolili, neexistuje.',
		'usernamealreadyexists' => 'Uživatelské jméno %s již existuje.',
		'plausibilitychecknotunderstood' => 'Odpověď kontroly věrohodnosti není srozumitelná.',
		'errorwhensaving' => 'Došlo k chybě při ukládání pole %s',
		'hiddenfieldvaluechanged' => 'Hodnota skrytého pole "%s" se změnila při úpravách nastavení.<br /><br />Toto obvykle není velký problém, ale z toho důvodu nelze uložit nastavení.',
		'notrequiredpasswordlength' => 'Zadané heslo je příliš krátké. Zadejte prosím alespoň %s znaky.',
		'overviewsettingoptionisnotavalidfield' => 'Jejda, pole, které by mělo být zobrazeno jako volba v přehledu nastavení, není výjimečně povolený typ. Z toho můžete vinit vývojáře. Nemělo by se to stát!',
		'pathmaynotcontaincolon' => 'Cesta, kterou jste zadali, by neměla obsahovat dvojtečku (":"). Zadejte správnou hodnotu cesty.',
		'exception' => '%s',
		'notrequiredpasswordcomplexity' => 'Složitost zadaného hesla nebyla dostatečná.<br />Pokud máte nějaké dotazy ohledně složitosti',
		'stringerrordocumentnotvalidforlighty' => 'Řetězec jako ErrorDocument v lighttpd nefunguje, zadejte prosím cestu k souboru',
		'urlerrordocumentnotvalidforlighty' => 'URL adresa jako chybový dokument nefunguje v lighttp, zadejte prosím cestu k souboru',
		'invaliderrordocumentvalue' => 'Hodnota udaná jako chybový dokument se nezdá být platným souborem, URL nebo řetězcem.',
		'intvaluetoolow' => 'Zadané číslo je příliš nízké (pole %s)',
		'intvaluetoohigh' => 'Zadané číslo je příliš vysoké (pole %s)',
		'phpfpmstillenabled' => 'PHP-FPM je aktuálně aktivní. Před aktivací FCGID jej deaktivujte',
		'fcgidstillenabled' => 'FCGID je aktuálně aktivní. Prosím deaktivujte jej před aktivací PHP-FPM',
		'domains_cantdeletedomainwithaliases' => 'Nemůžete odstranit doménu, která se používá pro alias-domény. Nejdříve musíte aliasy odstranit.',
		'user_banned' => 'Váš účet byl uzamčen. Pro další informace kontaktujte svého správce.',
		'session_timeout' => 'Hodnota je příliš nízká',
		'session_timeout_desc' => 'Časový limit relace by neměl být nižší než 1 minuta.',
		'invalidhostname' => 'Název hostitele musí být platná doména. Nemůže být prázdný ani nesmí obsahovat pouze mezery',
		'operationnotpermitted' => 'Operace není povolena!',
		'featureisdisabled' => 'Funkce %s je zakázána. Obraťte se na svého poskytovatele služeb.',
		'usercurrentlydeactivated' => 'Uživatel %s je momentálně deaktivován',
		'setlessthanalreadyused' => 'Nelze nastavit méně prostředků \'%s\', než tento uživatel již použil<br />',
		'stringmustntbeempty' => 'Hodnota pole %s nesmí být prázdná',
		'sslcertificateismissingprivatekey' => 'Musíte zadat soukromý klíč k vašemu certifikátu',
		'sslcertificatewrongdomain' => 'Daný certifikát nepatří k této doméně',
		'sslcertificateinvalidcert' => 'Daný obsah certifikátu se nezdá být platným certifikátem',
		'sslcertificateinvalidcertkeypair' => 'Zadaný soukromý klíč nepatří k danému certifikátu',
		'sslcertificateinvalidca' => 'Dané údaje certifikátů CA se nezdají být platným certifikátem',
		'sslcertificateinvalidchain' => 'Údaje daného řetězce certifikátů se nezdají být platným certifikátem',
		'givendirnotallowed' => 'Zadaný adresář v poli %s není povolen.',
		'sslredirectonlypossiblewithsslipport' => 'Použití Let\'s Encryptí je možné pouze v případě, že doména má přiřazenou alespoň jednu ssl-povolenou kombinaci IP/port.',
		'fcgidstillenableddeadlock' => 'FCGID je aktuálně aktivní.<br />Prosím deaktivujte ho před přepnutím na jiný webový server než Apache2 nebo lighttpd',
		'send_report_title' => 'Odeslat zprávu o chybě',
		'send_report_desc' => 'Děkujeme, že jste nahlásili tuto chybu a pomohli nám vylepšit Froxlor.<br />Toto je e-mail, který bude odeslán Froxlor vývojáři:',
		'send_report' => 'Odeslat hlášení',
		'send_report_error' => 'Chyba při odesílání hlášení: <br />%s',
		'notallowedtouseaccounts' => 'Váš účet neumožňuje používat IMAP/POP3. E-mailové účty nelze přidat.',
		'cannotdeletehostnamephpconfig' => 'Tato konfigurace PHP je používána ve Froxlor-vhost a nelze ji odstranit.',
		'cannotdeletedefaultphpconfig' => 'Tato konfigurace PHP je nastavena jako výchozí a nelze ji odstranit.',
		'passwordshouldnotbeusername' => 'Heslo by nemělo být stejné jako uživatelské jméno.',
		'no_phpinfo' => 'Je nám líto, phpinfo() nelze přečíst',
		'moveofcustomerfailed' => 'Přesun zákazníka do vybraného administrátora/prodejce selhal. Mějte na paměti, že všechny ostatní změny zákazníka byly úspěšně aplikovány v této fázi.<br><br>Zpráva o chybě: %s',
		'domain_import_error' => 'Při importu domén došlo k chybě: %s',
		'fcgidandphpfpmnogoodtogether' => 'FCGID a PHP-FPM nelze současně aktivovat',
		'no_apcuinfo' => 'Žádné informace o cache nejsou k dispozici. APCu se nezdá být spuštěna.',
		'no_opcacheinfo' => 'Žádné informace o OPCache nejsou k dispozici. OPCache se nezdá být načtena.',
		'inactive_opcacheinfo' => 'OPCache se zdá být nainstalována, ale není aktivováno.',
		'nowildcardwithletsencrypt' => 'Let\'s Encrypt neumí zpracovávat wildcard domény pomocí ACME ve froxlor (vyžaduje dns-challenge), omlouváme se. Nastavte prosím ServerAlias na WWW nebo jej zcela zakažte',
		'customized_version' => 'Vypadá to, že vaše instalace Froxlor byla upravena, na úpravy neposkytuijeme podporu, je nám líto.',
		'autoupdate_0' => 'Neznámá chyba',
		'autoupdate_1' => 'Nastavení PHP allow_url_fopen je zakázáno. Autoupdate musí být povolen v php.ini',
		'autoupdate_2' => 'PHP zip rozšíření nebylo nalezeno, ujistěte se, že je nainstalováno a aktivováno',
		'autoupdate_4' => 'Archiv froxlor nemohl být uložen na disk :(',
		'autoupdate_5' => 'version.froxlor.org vrátil nepřijatelné hodnoty :(',
		'autoupdate_6' => 'Jejda, ke stažení nebyla zadána žádná (platná) verze :(',
		'autoupdate_7' => 'Stažený archiv nebyl nalezen :(',
		'autoupdate_8' => 'Archiv nelze extrahovat :(',
		'autoupdate_9' => 'Stažený soubor neprošel kontrolou integrity. Zkuste prosím aktualizovat znovu.',
		'autoupdate_10' => 'Minimální podporovaná verze PHP je 7.4.0',
		'autoupdate_11' => 'Webupdate je zakázán',
		'mailaccistobedeleted' => 'Jiný účet se stejným názvem (%s) je v současné době smazán, a proto jej nelze v tuto chvíli přidat.',
		'customerhasongoingexportjob' => 'Na zpracování již čeká úloha exportu dat, buďte prosím trpěliví.',
		'exportfunctionnotenabled' => 'Funkce exportu není povolena',
		'dns_domain_nodns' => 'DNS není pro tuto doménu povoleno',
		'dns_content_empty' => 'Nebyl zadán žádný obsah',
		'dns_content_invalid' => 'Neplatný obsah DNS',
		'dns_arec_noipv4' => 'Neplatná IP adresa pro A-záznam',
		'dns_aaaarec_noipv6' => 'Neplatná IP adresa pro zadaný záznam AAAA',
		'dns_mx_prioempty' => 'Byla zadána neplatná MX priorita',
		'dns_mx_needdom' => 'Hodnota MX obsahu musí být platný název domény',
		'dns_mx_noalias' => 'Hodnota MX nemůže být položka CNAME.',
		'dns_cname_invaliddom' => 'Neplatný název domény pro záznam CNAME',
		'dns_cname_nomorerr' => 'Záznam zdroje se stejným názvem záznamu již existuje. Nelze jej použít jako CNAME.',
		'dns_other_nomorerr' => 'Záznam CNAME se stejným názvem záznamu již existuje. Nelze jej použít pro jiný typ.',
		'dns_ns_invaliddom' => 'Neplatný název domény pro NS záznam',
		'dns_srv_prioempty' => 'Byla zadána neplatná SRV priorita',
		'dns_srv_invalidcontent' => 'Neplatný obsah SRV musí obsahovat váhu, port a cíl, např.: 5 5060 sipserver.example.com.',
		'dns_srv_needdom' => 'Hodnota SRV cíle musí být platný název domény',
		'dns_srv_noalias' => 'Hodnota SRV cíle nemůže být položka CNAME.',
		'dns_duplicate_entry' => 'Záznam již existuje',
		'dns_notfoundorallowed' => 'Doména nebyla nalezena nebo nemáte oprávnění',
		'domain_nopunycode' => 'Nesmíte specifikovat punycode (IDNA). Doména bude automaticky převedena',
		'domain_noipaddress' => 'Nelze přidat IP adresu jako doménu',
		'dns_record_toolong' => 'Záznamy/popisky mohou mít pouze 63 znaků',
		'noipportgiven' => 'Není zadán žádný IP/port',
		'nosslippportgiven' => 'Při povolení SSL je třeba zvolit SSL IP/port',
		'jsonextensionnotfound' => 'Tato funkce vyžaduje rozšíření php-json.',
		'cannotdeletesuperadmin' => 'Prvního správce nelze odstranit.',
		'no_wwwcnamae_ifwwwalias' => 'Nelze nastavit CNAME záznam pro "www" jako doménu pro generování www-alias. Změňte prosím nastavení buď na "No alias" nebo "Wildcard alias"',
		'local_group_exists' => 'Tato skupina již v systému existuje.',
		'local_group_invalid' => 'Zadaný název skupiny je neplatný',
		'invaliddnsforletsencrypt' => 'DNS domén neobsahuje žádnou z vybraných IP adres. Vytvoření Let\'s Encryp certifikátu není možné.',
		'notallowedphpconfigused' => 'Pokus o použití php konfigurace, která není přiřazena zákazníkovi',
		'pathmustberelative' => 'Uživatel nemá oprávnění specifikovat adresáře mimo domovský adresář zákazníka. Zadejte relativní cestu (bez úvodního /).',
		'mysqlserverstillhasdbs' => 'Databázový server nelze odstranit ze seznamu povolených zákazníků, protože na něm stále existují databáze.',
		'domaincannotbeedited' => 'Nemáte oprávnění upravovat doménu %s',
		'invalidcronjobintervalvalue' => 'Interval Cronjobu musí být jeden z: %s',
		'phpgdextensionnotavailable' => 'Rozšíření PHP GD není dostupné. Nelze ověřit data obrázků',
		'2fa_wrongcode' => 'Zadaný kód není platný',
		'gnupgextensionnotavailable' => 'Rozšíření PHP GnuPG není dostupné. Nelze ověřit PGP veřejný klíč',
		'invalidpgppublickey' => 'PGP veřejný klíč není platný',
		'invalid_validtime' => 'Platný čas v sekundách může být pouze mezi 10 a 120',
		'customerphpenabledbutnoconfig' => 'Zákazník má PHP aktivován, ale nebyla vybrána žádná konfigurace PHP.',
	],
	'extras' => [
		'description' => 'Zde můžete přidat některé doplňky, například ochranu adresářů.<br />Po každé změně bude systém potřebovat určitý čas, aby aplikoval nová nastavení.',
		'directoryprotection_add' => 'Přidat ochranu adresáře',
		'view_directory' => 'Zobrazit obsah adresáře',
		'pathoptions_add' => 'Přidat možnosti cesty',
		'directory_browsing' => 'Prohlížení obsahu adresáře',
		'pathoptions_edit' => 'Upravit možnosti cesty',
		'error404path' => '404',
		'error403path' => '403',
		'error500path' => '500',
		'error401path' => '401',
		'errordocument404path' => 'ErrorDocument 404',
		'errordocument403path' => 'ErrorDocument 403',
		'errordocument500path' => 'ErrorDocument 500',
		'errordocument401path' => 'ErrorDocument 401',
		'execute_perl' => 'Spustit perl/CGI',
		'htpasswdauthname' => 'Důvod ověření (AuthName)',
		'directoryprotection_edit' => 'Upravit ochranu adresáře',
		'export' => 'Vytvořit výpis dat',
		'dump_web' => 'Zahrnout webová data',
		'dump_mail' => 'Zahrnout e-mailová data',
		'dump_dbs' => 'Zahrnout databáze',
		'path_protection_label' => '<strong class="text-danger">Důležité</strong>',
		'path_protection_info' => 'Důrazně doporučujeme chránit danou cestu, viz "Extra" -> "Ochrana adresářů"',
	],
	'ftp' => [
		'description' => 'Zde můžete vytvořit a změnit své FTP účty.<br />Změny jsou provedeny okamžitě a účty mohou být použity okamžitě.',
		'account_add' => 'Vytvořit účet',
		'account_edit' => 'Upravit ftp účet',
		'editpassdescription' => 'Nastavte nové heslo nebo ponechte prázdné pro zanechání stávajícího.',
	],
	'gender' => [
		'title' => 'Název',
		'male' => 'Pan',
		'female' => 'Paní',
		'undef' => '',
	],
	'imprint' => 'Právní ustanovení',
	'index' => [
		'customerdetails' => 'Podrobnosti o zákazníkovi',
		'accountdetails' => 'Nastavení účtu',
	],
	'integrity_check' => [
		'databaseCharset' => 'Sada znaků databáze (měla by být UTF-8)',
		'domainIpTable' => 'IP &lt;&dash;&gt; reference domén',
		'subdomainSslRedirect' => 'Falešný příznak přesměrování SSL pro non-ssl domény',
		'froxlorLocalGroupMemberForFcgidPhpFpm' => 'froxlor-uživatelve skupinách zákazníků (pro FCGID/php-fpm)',
		'webserverGroupMemberForFcgidPhpFpm' => 'Webový uživatel ve skupině zákazníků (pro FCGID/php-fpm)',
		'subdomainLetsencrypt' => 'Hlavní domény bez SSL portu nemají žádné subdomény s aktivním přesměrováním SSL',
	],
	'logger' => [
		'date' => 'Datum',
		'type' => 'Typ',
		'action' => 'Akce',
		'user' => 'Uživatel',
		'truncate' => 'Vyprázdnit protokol',
		'reseller' => 'Překupník',
		'admin' => 'Administrátor',
		'cron' => 'Cronjob',
		'login' => 'Přihlášení',
		'intern' => 'Interní',
		'unknown' => 'Neznámý',
	],
	'login' => [
		'username' => 'Uživatelské jméno',
		'password' => 'Heslo',
		'language' => 'Jazyk',
		'login' => 'Přihlásit se',
		'logout' => 'Odhlásit se',
		'profile_lng' => 'Jazyk profilu',
		'welcomemsg' => 'Pro přístup k vašemu účtu se přihlaste.',
		'forgotpwd' => 'Zapomněli jste heslo?',
		'presend' => 'Obnovit heslo',
		'email' => 'E-mailová adresa',
		'remind' => 'Obnovit heslo',
		'usernotfound' => 'Uživatel nebyl nalezen!',
		'backtologin' => 'Zpět na přihlášení',
		'combination_not_found' => 'Kombinace uživatele a e-mailové adresy nenalezena.',
		'2fa' => 'Dvoufázové ověření (2FA)',
		'2facode' => 'Zadejte prosím 2FA kód',
	],
	'mails' => [
		'pop_success' => [
			'mailbody' => 'Dobrý den,\\n\\nváš e-mailový účet {EMAIL}\\nbyl úspěšně vytvořen.\\n\\nToto je automaticky vytvořený\\ne-mail, prosím neodpovídejte na něj!\\n\\nVáš správce',
			'subject' => 'E-mailový účet byl úspěšně nastaven',
		],
		'createcustomer' => [
			'mailbody' => 'Dobrýž den {SALUTATION},\\n\\nzde je váš účet:\\n\\nUživatelské jméno: {USERNAME}\\nHeslo: {PASSWORD}\\n\\nDěkujeme,\\nváš správce',
			'subject' => 'Informace o účtu',
		],
		'pop_success_alternative' => [
			'mailbody' => 'Dobrý den {SALUTATION},\\n\\nVáš e-mailový účet {EMAIL}\\nbyl úspěšně vytvořen.\\nVaše heslo je {PASSWORD}.\\n\\nToto je automaticky vytvořený e-mail\\n, prosím neodpovídejte na to!\\n\\nYours upřímně, váš správce',
			'subject' => 'E-mailový účet byl úspěšně nastaven',
		],
		'password_reset' => [
			'subject' => 'Obnovení hesla',
			'mailbody' => 'Dobrý den, {SALUTATION},\\n\\nje zde váš odkaz pro nastavení nového hesla. Tento odkaz je platný po dobu následujících 24 hodin.\\n\\n{LINK}\\n\\nDěkujeme,\\nváš správce',
		],
		'new_database_by_customer' => [
			'subject' => '[Froxlor] Byla vytvořena nová databáze',
			'mailbody' => 'Dobrý den {CUST_NAME},

jste právě přidali novou databázi. Zde jsou zadané informace:

Název databáze: {DB_NAME}
Heslo: {DB_PASS}
Popis: {DB_DESC}
Hostitel databáze: {DB_SRV}
phpMyAdmin: {PMA_URI}
S pozdravem Váš správce',
		],
		'new_ftpaccount_by_customer' => [
			'subject' => 'Nový ftp uživatel vytvořen',
			'mailbody' => 'Dobrý den {CUST_NAME},

jste právě přidali nového ftp uživatele. Zde jsou zadané informace:

Uživatelské jméno: {USR_NAME}
Heslo: {USR_PASS}
Cesta: {USR_PATH}

Ach upřímně, váš správce',
		],
		'trafficmaxpercent' => [
			'mailbody' => 'Vážený/á {SALUTATION},\\n\\njste použili {TRAFFICUSED} z dostupného provozu {TRAFFIC}.\\nToto je více než {MAX_PERCENT}%%.\\n\\nVaše upřímně správce',
			'subject' => 'Dosažení limitu provozu',
		],
		'diskmaxpercent' => [
			'mailbody' => 'Vážený/á {SALUTATION},\\n\\njste použili {DISKUSED} ze svého dostupného {DISKAVAILABLE} disku.\\nToto je více než {MAX_PERCENT}%%.\\n\\nVaše upřímně správce',
			'subject' => 'Dosažení limitu na disku',
		],
		'2fa' => [
			'mailbody' => 'Dobrý den,\\n\\nváš 2FA přihlašovací kód je: {CODE}.\\n\\nToto je automaticky vytvořený\\ne-mail, prosím neodpovídejte na to!\\n\\nVáš správce',
			'subject' => 'Froxlor - 2FA kód',
		],
	],
	'menue' => [
		'main' => [
			'main' => 'Hlavní',
			'changepassword' => 'Změnit heslo',
			'changelanguage' => 'Změnit jazyk',
			'username' => 'Přihlášen jako: ',
			'changetheme' => 'Změnit motiv',
			'apihelp' => 'Nápověda API',
			'apikeys' => 'API klíče',
		],
		'email' => [
			'email' => 'Email',
			'emails' => 'Adresy',
			'webmail' => 'Webmail',
			'emailsoverview' => 'Přehled e-mailových domén',
		],
		'mysql' => [
			'mysql' => 'MySQL',
			'databases' => 'Databáze',
			'phpmyadmin' => 'phpMyAdmin',
		],
		'domains' => [
			'domains' => 'Domény',
			'settings' => 'Přehled domén',
		],
		'ftp' => [
			'ftp' => 'FTP',
			'accounts' => 'Účty',
			'webftp' => 'WebFTP',
		],
		'extras' => [
			'extras' => 'Extra',
			'directoryprotection' => 'Ochrana adresáře',
			'pathoptions' => 'Možnosti cesty',
			'export' => 'Export dat',
		],
		'traffic' => [
			'traffic' => 'Provoz',
			'current' => 'Aktuální měsíc',
			'overview' => 'Celkový provoz',
		],
		'phpsettings' => [
			'maintitle' => 'PHP konfigurace',
			'fpmdaemons' => 'Verze PHP-FPM',
		],
		'logger' => [
			'logger' => 'Systémový protokol',
		],
	],
	'message' => [
		'norecipients' => 'Nebyl odeslán žádný e-mail, protože v databázi nejsou žádní příjemci',
	],
	'mysql' => [
		'databasename' => 'Uživatel/Jméno databáze',
		'databasedescription' => 'Popis databáze',
		'database_create' => 'Vytvořit databázi',
		'description' => 'Zde můžete vytvořit a změnit databáze MySQL.<br />Změny jsou provedeny okamžitě a databáze může být použita okamžitě.<br />V menu na levé straně najdete nástroj phpMyAdmin, pomocí kterého můžete snadno spravovat svou databázi.<br /><br />Pro použití Vašich databází ve svých vlastních php-skriptech použijte následující nastavení: (Data <i>kurzívou</i> je třeba změnit na ekvivalenty, které jste zadali!<br />Název hostitele: <b><SQL_HOST></b><br />Uživatelské jméno: <b><i>název databáze</i></b><br />Heslo: <b><i>heslo, které jste si vybrali</i></b><br />databáze: <b><i>databázový název</i></b>',
		'mysql_server' => 'Server MySQL',
		'database_edit' => 'Upravit databázi',
		'size' => 'Velikost',
		'privileged_user' => 'Oprávněný databázový uživatel',
		'privileged_passwd' => 'Heslo pro oprávněného uživatele',
		'unprivileged_passwd' => 'Heslo pro neoprávněného uživatele',
		'mysql_ssl_ca_file' => 'Certifikát SSL serveru',
		'mysql_ssl_verify_server_certificate' => 'Ověřit certifikát SSL serveru',
		'globaluserinfo' => 'Pro přístup k databázím můžete navíc použít vaše froxlor přihlášení (uživatel: %s), které má automaticky přístup ke všem databázím.<br />Doporučujeme <b>ne</b> použít pro aplikace, pouze pro správu (např. přes phpMyAdmin).',
		'edit_global_user' => 'Upravit administrátora',
	],
	'opcacheinfo' => [
		'generaltitle' => 'Obecné informace',
		'resetcache' => 'Resetövat OPcache',
		'version' => 'Verze OPCache',
		'phpversion' => 'Verze PHP',
		'runtimeconf' => 'Spustitelná konfigurace',
		'start' => 'Čas spuštění',
		'lastreset' => 'Poslední restart',
		'oomrestarts' => 'Počet restartů OOM',
		'hashrestarts' => 'Počet restartů hash',
		'manualrestarts' => 'Manuální počet restartů',
		'hitsc' => 'Počet zásahů',
		'missc' => 'Nevyužitý počet',
		'blmissc' => 'Počet zmeškaných záznamů na černé listině',
		'status' => 'Stav',
		'never' => 'nikdy',
		'enabled' => 'OPcache povoleno',
		'cachefull' => 'Mezipaměť je plná',
		'restartpending' => 'Čeká na restart',
		'restartinprogress' => 'Probíhá restart',
		'cachedscripts' => 'Počet skriptů v mezipaměti',
		'memusage' => 'Využití paměti',
		'totalmem' => 'Celková paměť',
		'usedmem' => 'Využitá paměť',
		'freemem' => 'Volná paměť',
		'wastedmem' => 'Promarněná paměť',
		'maxkey' => 'Maximální počet klíčů',
		'usedkey' => 'Použité klíče',
		'wastedkey' => 'Promarněné klíče',
		'strinterning' => 'String interning',
		'strcount' => 'Počet řetězců',
		'keystat' => 'Statistika klíčů v mezipaměti',
		'used' => 'Využito',
		'free' => 'Volné',
		'blacklist' => 'Černá listina',
		'novalue' => '<i>žádná hodnota</i>',
		'true' => '<i>true</i>',
		'false' => '<i>false</i>',
		'funcsavail' => 'Dostupné funkce',
	],
	'panel' => [
		'edit' => 'Upravit',
		'delete' => 'Smazat',
		'create' => 'Vytvořit',
		'save' => 'Uložit',
		'yes' => 'Ano',
		'no' => 'Ne',
		'emptyfornochanges' => 'prázdné pro žádné změny',
		'emptyfordefault' => 'prázdné pro výchozí nastavení',
		'path' => 'Cesta',
		'toggle' => 'Přepínač',
		'next' => 'Další',
		'dirsmissing' => 'Nelze najít nebo přečíst adresář!',
		'unlimited' => '∞',
		'urloverridespath' => 'URL (přepsání cesty)',
		'pathorurl' => 'Cesta nebo URL',
		'ascending' => 'vzestupně',
		'descending' => 'sestupně',
		'search' => 'Vyhledat',
		'used' => 'využito',
		'translator' => 'Překladač',
		'reset' => 'Zahodit změny',
		'pathDescription' => 'Pokud složka neexistuje, bude vytvořena automaticky.',
		'pathDescriptionEx' => '<br /><br /><span class="text-danger">Upozornění:</span> Cesta <code>/</code> není povolena z důvodu administrativního nastavení, bude automaticky nastaveno na <code>/chosen.subdomain.tld/</code> pokud není nastaveno na jiný adresář.',
		'pathDescriptionSubdomain' => 'Pokud složka neexistuje, bude vytvořena automaticky.<br /><br />Pokud chcete přesměrovat na jinou doménu, musí tento záznam začít http:// nebo https://.<br /><br />Pokud URL končí / je považována za složku, pokud ne, je považována za soubor.',
		'back' => 'Zpět',
		'reseller' => 'překupník',
		'admin' => 'admin',
		'customer' => 'zákazník/zákazníci',
		'send' => 'odeslat',
		'nosslipsavailable' => 'V současné době neexistují žádné kombinace ssl ip/port pro tento server',
		'backtooverview' => 'Zpět na přehled',
		'dateformat' => 'RRRR-MM-DD',
		'dateformat_function' => 'R-m-d',
		'timeformat_function' => 'H:i:s',
		'default' => 'Výchozí',
		'never' => 'Nikdy',
		'active' => 'Aktivní',
		'please_choose' => 'Vyberte prosím',
		'allow_modifications' => 'Povolit změny',
		'megabyte' => 'MegaByte',
		'not_supported' => 'Nepodporováno v: ',
		'view' => 'zobrazení',
		'toomanydirs' => 'Příliš mnoho podadresářů. Vraťte se zpět na manuální výběr cesty.',
		'abort' => 'Přerušit',
		'not_activated' => 'není aktivováno',
		'off' => 'vyp.',
		'options' => 'Možnosti',
		'neverloggedin' => 'Dosud žádné přihlášení',
		'descriptionerrordocument' => 'Může být adresa URL, cesta k souboru nebo jen řetězec zabalený kolem " "<br />Ponechte prázdné pro použití výchozí hodnoty serveru.',
		'unlock' => 'Odemknout',
		'theme' => 'Motiv',
		'variable' => 'Proměnná',
		'description' => 'Popis',
		'cancel' => 'Zrušit',
		'ssleditor' => 'Nastavení SSL pro tuto doménu',
		'ssleditor_infoshared' => 'V současné době používá certifikát rodičovské domény',
		'ssleditor_infoglobal' => 'V současné době používá globální certifikát',
		'dashboard' => 'Nástěnka',
		'assigned' => 'Přiřazeno',
		'available' => 'K dispozici',
		'news' => 'Novinky',
		'newsfeed_disabled' => 'Novinky jsou zakázány. Klepnutím na ikonu úpravy přejdete do nastavení.',
		'ftpdesc' => 'Popis FTP',
		'letsencrypt' => 'Používá Let\'s Encrypt',
		'set' => 'Aplikovat',
		'shell' => 'Konzole',
		'exportpath' => [
			'title' => 'Cílová cesta pro exportovaná data',
			'description' => 'Toto je cesta, kde bude exporotovaný archiv uložen. Pokud jsou webová data zahrnuta, všechny soubory z domovského adresáře jsou uloženy mimo složku zadanou zde.',
		],
		'export_pgp_public_key' => [
			'title' => 'Veřejný PGP klíč pro šifrování',
			'description' => 'Toto je veřejný PGP klíč, který bude použit k zašifrování exportu. Pokud necháte toto pole prázdné, export nebude zašifrován.',
		],
		'pgp_public_key' => 'Veřejný PGP klíč',
		'none_value' => 'Žádná',
		'viewlogs' => 'Zobrazit protokoly',
		'not_configured' => 'Systém ještě není nakonfigurován. Klikněte zde pro přechod do konfigurace.',
		'ihave_configured' => 'Konfiguroval jsem služby',
		'system_is_configured' => '<i class="fa-solid fa-circle-exclamation me-1"></i>Systém je již nastaven jako konfigurovaný',
		'settings_before_configuration' => 'Ujistěte se, že jste upravili nastavení před konfigurací služeb zde',
		'image_field_delete' => 'Odstranit stávající obrázek',
		'usage_statistics' => 'Využití zdrojů',
		'security_question' => 'Bezpečnostní otázka',
		'listing_empty' => 'Nebyly nalezeny žádné záznamy',
		'unspecified' => 'nespecifikováno',
		'settingsmode' => 'Režim',
		'settingsmodebasic' => 'Základní',
		'settingsmodeadvanced' => 'Rozšířený',
		'settingsmodetoggle' => 'Režim přepínání',
		'modalclose' => 'Zavřít',
		'managetablecolumnsmodal' => [
			'title' => 'Správa sloupců tabulky',
			'description' => 'Zde si můžete přizpůsobit viditelné sloupce',
		],
		'mandatoryfield' => 'Pole je povinné',
		'select_all' => 'Vybrat vše',
		'unselect_all' => 'Odznačit vše',
		'searchtablecolumnsmodal' => [
			'title' => 'Hledat v polích',
			'description' => 'Vyberte pole, ve kterém chcete vyhledat'
		],
		'upload_import' => 'Nahrát a importovat',
		'profile' => 'Můj profil',
		'use_checkbox_for_unlimited' => 'Hodnota „0“ deaktivuje tento prostředek. Zaškrtávací políčko vpravo umožňuje „neomezené“ použití.',
	],
	'phpfpm' => [
		'vhost_httpuser' => 'Místní uživatel pro PHP-FPM (Froxlor vHost)',
		'vhost_httpgroup' => 'Místní skupina pro PHP-FPM (Froxlor vHost)',
		'ownvhost' => [
			'title' => 'Povolit PHP-FPM pro Froxlor vHost',
			'description' => 'Pokud je povoleno, bude Froxlor spuštěn také pod místním uživatelem',
		],
		'use_mod_proxy' => [
			'title' => 'Použít mod_proxy / mod_proxy_fcgi',
			'description' => '<strong class="text-danger">Při používání Debianu 9.x (Stretch) nebo novějšího</strong>musí být povoleno použití php-fpm přes mod_proxy_fcgi. Vyžaduje alespoň apache-2.4.9',
		],
		'ini_flags' => 'Zadejte možný <strong>php_flag</strong> pro php.ini. Jeden záznam na řádek',
		'ini_values' => 'Zadejte možnou <strong>php_value</strong> pro php.ini. Jeden záznam na řádek',
		'ini_admin_flags' => 'Zadejte možný <strong>php_admin_flag</strong> pro php.ini. Jeden záznam na řádek',
		'ini_admin_values' => 'Zadejte možnou <strong>php_value</strong> pro php.ini. Jeden záznam na řádek',
	],
	'privacy' => 'Zásady ochrany soukromí',
	'pwdreminder' => [
		'success' => 'Obnovení hesla bylo úspěšně požadováno. Postupujte podle pokynů v e-mailu, který jste obdrželi.',
		'notallowed' => 'Neznámý uživatel nebo obnovení hesla je zakázáno',
		'changed' => 'Vaše heslo bylo úspěšně aktualizováno. Nyní se můžete přihlásit pomocí nového hesla.',
		'wrongcode' => 'Je nám líto, váš aktivační kód neexistuje nebo již vypršel.',
		'choosenew' => 'Nastavit nové heslo',
	],
	'question' => [
		'question' => 'Bezpečnostní otázka',
		'admin_customer_reallydelete' => 'Opravdu chcete odstranit zákazníka %s? Tuto akci nelze vrátit zpět!',
		'admin_domain_reallydelete' => 'Opravdu chcete odstranit doménu %s?<br><span class="text-danger"><strong>POZNÁMKA:</strong> Všechny subdomény, ftp-účty a e-mailové adresy/účty spojené s touto doménou budou odstraněny!</span>',
		'admin_domain_reallydisablesecuritysetting' => 'Opravdu chcete zakázat toto nastavení zabezpečení OpenBasedir?',
		'admin_admin_reallydelete' => 'Opravdu chcete odstranit správce %s? Každý zákazník a doména budou znovu přiřazeny k vašemu účtu.',
		'admin_template_reallydelete' => 'Opravdu chcete odstranit šablonu\'%s\'?',
		'domains_reallydelete' => 'Opravdu chcete odstranit doménu %s?',
		'email_reallydelete' => 'Opravdu chcete odstranit e-mailovou adresu %s?',
		'email_reallydelete_account' => 'Opravdu chcete smazat e-mailový účet %s?',
		'email_reallydelete_forwarder' => 'Opravdu chcete odstranit přeposílatele %s?',
		'extras_reallydelete' => 'Opravdu chcete odstranit ochranu adresáře pro %s?',
		'extras_reallydelete_pathoptions' => 'Opravdu chcete odstranit možnosti cesty pro %s?',
		'extras_reallydelete_export' => 'Opravdu chcete přerušit plánovanou práci na exportu?',
		'ftp_reallydelete' => 'Opravdu chcete odstranit FTP účet %s?',
		'mysql_reallydelete' => 'Opravdu chcete odstranit databázi %s? Tuto akci nelze vrátit zpět!',
		'admin_configs_reallyrebuild' => 'Opravdu chcete znovu sestavit všechny konfigurační soubory?',
		'admin_customer_alsoremovefiles' => 'Odstranit také uživatelské soubory?',
		'admin_customer_alsoremovemail' => 'Zcela odstranit e-mailová data ze souborového systému?',
		'admin_customer_alsoremoveftphomedir' => 'Odebrat také domovský adresář FTP uživatele?',
		'admin_ip_reallydelete' => 'Opravdu chcete odstranit IP adresu %s?',
		'admin_domain_reallydocrootoutofcustomerroot' => 'Jste si jisti, že chcete, aby kořen dokumentu pro tuto doménu nebyl v rámci kořene zákazníka?',
		'admin_counters_reallyupdate' => 'Opravdu chcete přepočítat využití prostředků?',
		'admin_cleartextmailpws_reallywipe' => 'Opravdu chcete vymazat všechna nešifrovaná hesla e-mailového účtu z tabulky mail_users? Tuto akci nelze vrátit zpět! Nastavení nešifrovaných e-mailových hesel bude také nastaveno na vypnutí',
		'logger_reallytruncate' => 'Opravdu chcete zredukovat tabulku "%s"?',
		'admin_quotas_reallywipe' => 'Opravdu chcete vymazat všechny kvóty v tabulce mail_users? Toto nelze vrátit zpět!',
		'admin_quotas_reallyenforce' => 'Opravdu chcete vynutit výchozí kvótu pro všechny uživatele? Toto nelze vrátit zpět!',
		'phpsetting_reallydelete' => 'Opravdu chcete odstranit tato nastavení? Všechny domény, které v současné době používají tato nastavení, budou změněny na výchozí nastavení.',
		'fpmsetting_reallydelete' => 'Opravdu chcete smazat tato nastavení php-fpm? Všechny php konfigurace, které v současné době používají tato nastavení, budou změněny na výchozí nastavení.',
		'customer_reallyunlock' => 'Opravdu chcete odemknout zákazníka %s?',
		'admin_integritycheck_reallyfix' => 'Opravdu chcete zkusit automaticky opravit všechny problémy s integritou databáze?',
		'plan_reallydelete' => 'Opravdu chcete odstranit plán hostování %s?',
		'apikey_reallydelete' => 'Opravdu chcete odstranit tento api klíč?',
		'apikey_reallyadd' => 'Opravdu chcete vytvořit nový api klíč?',
		'dnsentry_reallydelete' => 'Opravdu chcete odstranit tento záznam zóny?',
		'certificate_reallydelete' => 'Opravdu chcete odstranit tento certifikát?',
		'cache_reallydelete' => 'Opravdu chcete vymazat mezipaměť?',
		'please_enter_otp' => 'Zadejte prosím 2FA kód',
		'admin_mysqlserver_reallydelete' => 'Opravdu chcete smazat tento MySQL-server?',
	],
	'redirect_desc' => [
		'rc_default' => 'výchozí',
		'rc_movedperm' => 'trvale přesunuto',
		'rc_found' => 'nalezeno',
		'rc_seeother' => 'viz ostatní',
		'rc_tempred' => 'dočasné přesměrování',
	],
	'serversettings' => [
		'session_timeout' => [
			'title' => 'Vypršení platnosti relace',
			'description' => 'Jak dlouho musí být uživatel neaktivní, než bude relace neplatná (sekundy)?',
		],
		'accountprefix' => [
			'title' => 'Prefix zákazníka',
			'description' => 'Jaký prefix by měly mít zákaznické účty?',
		],
		'mysqlprefix' => [
			'title' => 'SQL Prefix',
			'description' => 'Jaký prefix by měl mít MySQL účty?</br>Použijte "RANDOM" jako hodnotu k získání trojmístného náhodného prefixu</br>Použijte "DBNAME" jako hodnotu, pole názvu databáze je použito spolu s názvem zákazníka jako prefix.',
		],
		'ftpprefix' => [
			'title' => 'FTP Prefix',
			'description' => 'Jaký prefix by měly mít ftp účty?<br/><b>Pokud toto změníte, musíte také změnit Quota SQL Query v konfiguračním souboru FTP serveru, pokud jej používáte!</b> ',
		],
		'documentroot_prefix' => [
			'title' => 'Domovský adresář',
			'description' => 'Kde by měly být uloženy všechny domovské adresáře?',
		],
		'logfiles_directory' => [
			'title' => 'Adresář souborů protokolu',
			'description' => 'Kde mají být uloženy všechny soubory protokolů?',
		],
		'logfiles_script' => [
			'title' => 'Vlastní skript pro odesílání souborů protokolu do',
			'description' => 'Zde můžete zadat skript a použít zástupné symboly <strong>{LOGFILE}, {DOMAIN} a {CUSTOMER}</strong> v případě potřeby. Pokud jej chcete použít, budete muset aktivovat také <strong>nastavení logů webserveru</strong>. Není zapotřebí žádný předem stanovený pipe-znak.',
		],
		'logfiles_format' => [
			'title' => 'Formát přístupového protokolu',
			'description' => 'Zde zadejte vlastní formát logu podle specifikací webových serverů, ponechte prázdný pro výchozí. V závislosti na vašem formátu musí být řetězec uveden.<br/>Pokud je použito s nginx, bude vypadat jako <i>log_format frx_custom {CONFIGURED_VALUE}</i>.<br/>Pokud je použito s Apache, bude vypadat jako <i>LogFormat {CONFIGURED_VALUE} frx_custom</i>.<br/><strong>Pozornost</strong>: Kód nebude zkontrolován pro žádné chyby. Pokud obsahuje chyby, webový server nemusí znovu spustit!',
		],
		'logfiles_type' => [
			'title' => 'Typ přístupového protokolu',
			'description' => 'Zde si vyberte mezi <strong>combined</strong> nebo <strong>vhost_combined</strong>.',
		],
		'logfiles_piped' => [
			'title' => 'Přesměrování souborů protokolu webového serveru do zadaného skriptu (viz výše)',
			'description' => 'Používáte-li vlastní skript pro logy, musíte jej aktivovat, aby mohl být spuštěn',
		],
		'ipaddress' => [
			'title' => 'IP adresa',
			'description' => 'Jaká je hlavní IP adresa tohoto serveru?',
		],
		'hostname' => [
			'title' => 'Název serveru',
			'description' => 'Jaký je název hostitele tohoto serveru?',
		],
		'apachereload_command' => [
			'title' => 'Příkaz pro opětovné načtení webového serveru',
			'description' => 'Jaký je příkaz webového serveru pro opětovné načtení konfiguračních souborů?',
		],
		'bindenable' => [
			'title' => 'Povolit nameserver',
			'description' => 'Zde lze globálně povolit a zakázat nameserver.',
		],
		'bindconf_directory' => [
			'title' => 'Konfigurační adresář serveru Dns',
			'description' => 'Kde by měly být uloženy konfigurační soubory dns-serveru?',
		],
		'bindreload_command' => [
			'title' => 'Příkaz pro opětovné načtení serveru DNS',
			'description' => 'Jaký je příkaz pro znovunačtení dns serveru daemon?',
		],
		'vmail_uid' => [
			'title' => 'UID-Mailů',
			'description' => 'Které uživatelské Id by měly mít e-maily?',
		],
		'vmail_gid' => [
			'title' => 'Mails-GID',
			'description' => 'Jaké GroupID by měly mít e-maily?',
		],
		'vmail_homedir' => [
			'title' => 'Domovský adresář pro emaily',
			'description' => 'Kde by měly být uloženy všechny emaily?',
		],
		'adminmail' => [
			'title' => 'Odesílatel',
			'description' => 'Jaká je adresa odesílatele pro e-maily odeslané z panelu?',
		],
		'phpmyadmin_url' => [
			'title' => 'phpMyAdmin URL',
			'description' => 'Jaká je adresa URL na phpMyAdmin? (musí začít s http(s)://)',
		],
		'webmail_url' => [
			'title' => 'Webmail URL',
			'description' => 'Jaká je URL adresa webové pošty? (musí začít http(s)://)',
		],
		'webftp_url' => [
			'title' => 'WebFTP URL',
			'description' => 'Jaká je URL adresa na WebFTP? (musí začít http(s)://)',
		],
		'language' => [
			'description' => 'Jaký je váš standardní jazyk serveru?',
		],
		'maxloginattempts' => [
			'title' => 'Maximální počet pokusů o přihlášení',
			'description' => 'Maximální počet pokusů o přihlášení, po kterých je účet zakázán.',
		],
		'deactivatetime' => [
			'title' => 'Čas deaktivace',
			'description' => 'Čas (sek.) je po příliš mnoha pokusech o přihlášení deaktivován účet.',
		],
		'pathedit' => [
			'title' => 'Typ vstupu cesty',
			'description' => 'Měla by být cesta vybrána v rozbalovacím menu nebo ve vstupním poli?',
		],
		'nameservers' => [
			'title' => 'Nameservery',
			'description' => 'Čárkou oddělený seznam obsahující jména všech nameserverů. První bude primární.',
		],
		'mxservers' => [
			'title' => 'MX servery',
			'description' => 'Čárkou oddělený seznam obsahující dvojici čísel a názvu hostitele oddělených mezerou (např. \'10 mx.example.com\') obsahující mx servery.',
		],
		'paging' => [
			'title' => 'Počet položek na stránku',
			'description' => 'Kolik záznamů se zobrazí na jedné stránce? (0 = zakázat stránkování)',
		],
		'defaultip' => [
			'title' => 'Výchozí IP/port',
			'description' => 'Vyberte všechny IP adresy, které chcete použít jako výchozí pro nové domény',
		],
		'defaultsslip' => [
			'title' => 'Výchozí SSL IP/port',
			'description' => 'Vyberte všechny ssl IP adresy, které chcete použít jako výchozí pro nové domény',
		],
		'phpappendopenbasedir' => [
			'title' => 'Cesty, které se připojí do souboru OpenBasedir',
			'description' => 'Tyto cesty (oddělené dvojtečkami) budou přidány do příkazu OpenBasedir v každém kontejneru vHost.',
		],
		'natsorting' => [
			'title' => 'Použít přirozené lidské třídění v zobrazení seznamu',
			'description' => 'Seřadí seznamy jako web1 -> web2 -> web11 místo web1 -> web11 -> web2.',
		],
		'deactivateddocroot' => [
			'title' => 'Docroot pro deaktivované uživatele',
			'description' => 'Pokud je uživatel deaktivován, použije se tato cesta jako docroot. Ponechte prázdné, pokud vůbec nechcete vytvářet vHost hostitele.',
		],
		'mailpwcleartext' => [
			'title' => 'Také ukládat nešifrované hesla e-mailových účtů do databáze',
			'description' => 'Pokud je toto nastaveno na Ano, všechna hesla budou také uložena v tabulce mail_users-table (nešifrovaný text, jednoduše čitelný pro všechny s přístupem k databázi). Aktivujte pouze pokud chcete použít SASL!',
		],
		'ftpdomain' => [
			'title' => 'FTP účty @doména',
			'description' => 'Zákazníci mohou vytvořit FTP účty uživatel@doménauživatele?',
		],
		'mod_fcgid' => [
			'title' => 'Povolit FCGID',
			'description' => 'Použijte pro spuštění PHP s odpovídajícím uživatelským účtem.<br /><br /><b>Toto vyžaduje speciální konfiguraci webového serveru pro Apache, viz <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/fcgid/">FCGID - příručka</a></b>',
			'configdir' => [
				'title' => 'Adresář konfigurace',
				'description' => 'Kde by měly být uloženy všechny fcgid konfigurační soubory? Pokud nepoužíváte vlastní kompilovaný suexec binární, což je normální situace, tato cesta musí být pod /var/www/<br /><br /><div class="text-danger">POZNÁMKA: Obsah této složky je pravidelně smazán, aby se zabránilo ukládání dat v ní manuálně.</div>',
			],
			'tmpdir' => [
				'title' => 'Dočasný adresář',
				'description' => 'Kde by měly být uloženy dočasné adresáře',
			],
			'starter' => [
				'title' => 'Procesy na doménu',
				'description' => 'Kolik procesů by mělo být spuštěno/povoleno v dané doméně? Hodnota 0 je doporučená příčinou PHP pak bude velmi efektivně spravovat samotný počet procesů.',
			],
			'wrapper' => [
				'title' => 'Wrapper v hostitelích Vhosts',
				'description' => 'Jak by měl být wrapper zahrnut do Vhosts',
			],
			'peardir' => [
				'title' => 'Globální adresáře PEAR',
				'description' => 'Které globální adresáře PEAR by měly být nahrazeny v každém konfiguračním souboru php.ini? Různé adresáře musí být odděleny dvojtečkou.',
			],
			'maxrequests' => [
				'title' => 'Maximální počet požadavků na doménu',
				'description' => 'Kolik požadavků by mělo být povoleno na doménu?',
			],
			'defaultini' => 'Výchozí konfigurace PHP pro nové domény',
			'defaultini_ownvhost' => 'Výchozí konfigurace PHP pro Froxlor-vHost',
			'idle_timeout' => [
				'title' => 'Časový limit nečinnosti',
				'description' => 'Časový limit nastavení Mod FastCGI.',
			],
		],
		'sendalternativemail' => [
			'title' => 'Použít alternativní e-mailovou adresu',
			'description' => 'Poslat heslo na jinou adresu při vytváření e-mailu',
		],
		'apacheconf_vhost' => [
			'title' => 'Konfigurační soubor/adresář webserveru',
			'description' => 'Kde má být uložena konfigurace vHost? Zde můžete zadat buď soubor (všechny vHosty v jednom souboru), nebo adresář (každý vHost ve vlastním souboru).',
		],
		'apacheconf_diroptions' => [
			'title' => 'Konfigurační soubor/název adresáře webového serveru diroptions',
			'description' => 'Kde má být uložena konfigurace diroptions? Zde můžete zadat buď soubor (všechny dioptrie v jednom souboru), nebo adresář (každá dioptrie ve vlastním souboru).',
		],
		'apacheconf_htpasswddir' => [
			'title' => 'Webserver htpasswd dirname',
			'description' => 'Kde mají být soubory htpasswd pro ochranu adresáře uloženy?',
		],
		'mysql_access_host' => [
			'title' => 'MySQL-Access-Hosts',
			'description' => 'Čárkami oddělený seznam hostitelů, od kterých by měli mít uživatelé možnost se připojit k serveru MySQL-Server. Pro povolení podsítě je platná síťová maska nebo cidr.',
		],
		'webalizer_quiet' => [
			'title' => 'Výstup Webalizátoru',
			'description' => 'Verbosita webalizéru',
		],
		'logger' => [
			'enable' => 'Logování povoleno/zakázáno',
			'severity' => 'Úroveň protokolování',
			'types' => [
				'title' => 'Typ (typy) logů',
				'description' => 'Zadejte typy logů. Chcete-li vybrat více typů, podržte CTRL při výběru.<br />Dostupné typy logů jsou: syslog, soubor, mysql',
			],
			'logfile' => [
				'title' => 'Název souboru pro log',
				'description' => 'Používá se pouze v případě, že typ logu obsahuje "soubor". Tento soubor bude vytvořen v froxlor/logs/. Tato složka je chráněna před veřejným přístupem.',
			],
			'logcron' => 'Zaznamenávat cronjoby',
			'logcronoption' => [
				'never' => 'Nikdy',
				'once' => 'Jednou',
				'always' => 'Vždy',
			],
		],
		'ssl' => [
			'use_ssl' => [
				'title' => 'Povolit využití SSL',
				'description' => 'Zaškrtněte, pokud chcete použít SSL pro váš webový server',
			],
			'ssl_cert_file' => [
				'title' => 'Cesta k SSL certifikátu',
				'description' => 'Zadejte cestu včetně názvu souboru .crt nebo .pem (hlavní certifikát)',
			],
			'openssl_cnf' => 'Výchozí nastavení pro vytvoření Cert souboru',
			'ssl_key_file' => [
				'title' => 'Cesta k souboru klíče SSL',
				'description' => 'Zadejte cestu včetně názvu souboru pro soukromý klíč (z většiny.key)',
			],
			'ssl_ca_file' => [
				'title' => 'Cesta k SSL CA certifikátu (volitelné)',
				'description' => 'Ověřování klienta, nastavte to pouze pokud víte, co je.',
			],
			'ssl_cipher_list' => [
				'title' => 'Konfigurovat povolené SSL šifry',
				'description' => 'Toto je seznam šifer, které chcete (nebo nechcete) použít při komunikaci SSL. Pro seznam šifer a způsob, jak je zahrnout/vyloučit viz oddíly "CIPHER LIST FORMAT" a "CIPHER STRINGS" na <a href="https://www.openssl.org/docs/manmaster/man1/openssl-ciphers.html">man-stránce pro šifry</a>.<br /><br /><b>Výchozí hodnota je:</b><pre>ECDH+AESGCM:ECDH+AES256:!aNULL:!MD5:!DSS:!DH:!AES128</pre>',
			],
			'apache24_ocsp_cache_path' => [
				'title' => 'Apache 2.4: cesta k OCSP stapling cache',
				'description' => 'Konfiguruje mezipaměť použitou k ukládání odpovědí OCSP, které jsou zahrnuty do TLS handshakes.',
			],
			'ssl_protocols' => [
				'title' => 'Konfigurace verze protokolu TLS',
				'description' => 'Toto je seznam ssl protokolů, které chcete (nebo nechcete) použít při použití SSL. <b>Upozornění:</b> Některé starší prohlížeče nemusí podporovat nejnovější verze protokolu.<br /><br /><b>Výchozí hodnota je:</b><pre>TLSv1.2</pre>',
			],
			'tlsv13_cipher_list' => [
				'title' => 'Nakonfigurujte explicitní TLSv1.3 šifry, pokud jsou použity',
				'description' => 'Toto je seznam šifrů, které chcete (nebo nechcete) použít při komunikaci TLSv1.3. Seznam šifr a jak je zahrnovat/vyloučit, viz <a href="https://wiki.openssl.org/index.php/TLS1.3">dokumentace pro TLSv1.</a>.<br /><br /><b>Výchozí hodnota je prázdná</b>',
			],
		],
		'default_vhostconf' => [
			'title' => 'Výchozí nastavení vHost-serveru',
			'description' => 'Obsah tohoto pole bude přímo zahrnut do tohoto kontejneru s ip/portem. Můžete použít následující proměnné:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code> <code>{FPMSOCKET}</code> (pokud existuje)<br/> Upozornění: Kód nebude zkontrolován na výskyt chyb. Pokud obsahuje chyby, webový server nemusí znovu spustit!',
		],
		'apache_globaldiropt' => [
			'title' => 'Možnosti adresáře pro prefix zákazníka',
			'description' => 'Obsah tohoto pole bude zahrnut do 05_froxlor_dirfix_nofcgid.conf apache config. Je-li prázdné, použije se výchozí hodnota:<br><br>apache >=2.<br><code>Require all granted<br>AllowOverride All</code><br><br>apache <=2.<br><code>Order allow,deny<br>allow from all</code>',
		],
		'default_vhostconf_domain' => [
			'description' => 'Obsah tohoto pole bude přímo zahrnut do vHhost kontejneru. Můžete použít následující proměnné:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code> <code>{FPMSOCKET}</code> (pokud existuje)<br/> Upozornění: Kód nebude zkontrolován na obsah chyb. Pokud obsahuje chyby, webový server nemusí znovu spustit!',
		],
		'decimal_places' => 'Počet desetinných míst ve výstupu provozu/webového prostoru',
		'selfdns' => [
			'title' => 'Nastavení dns domény zákazníka',
		],
		'selfdnscustomer' => [
			'title' => 'Umožnit zákazníkům upravit nastavení dns domény',
		],
		'unix_names' => [
			'title' => 'Použít uživatelská jména kompatibilní s UNIX',
			'description' => 'Umožňuje používat <strong>-</strong> a <strong>_</strong> v uživatelských jménech, pokud <strong>Ne</strong>',
		],
		'allow_password_reset' => [
			'title' => 'Povolit obnovení hesla zákazníkem',
			'description' => 'Zákazníci mohou obnovit své heslo a aktivační odkaz bude odeslán na jejich e-mailovou adresu',
		],
		'allow_password_reset_admin' => [
			'title' => 'Povolit obnovení hesla administrátorem',
			'description' => 'Správci/prodejci mohou obnovit své heslo a na jejich e-mailovou adresu bude zaslán aktivační odkaz',
		],
		'mail_quota' => [
			'title' => 'Kvóta pro poštovní schránku',
			'description' => 'Výchozí kvóta pro nové vytvořené poštovní schránky (MegaByte).',
		],
		'mail_quota_enabled' => [
			'title' => 'Použít kvóty pro poštovní schránku pro zákazníky',
			'description' => 'Aktivujte pro použití kvót na mailboxech. Výchozí hodnota je <b>Ne</b>, protože to vyžaduje speciální nastavení.',
			'removelink' => 'Klikněte zde pro vymazání všech kvót pro e-mailové účty.',
			'enforcelink' => 'Klikněte zde pro vynucení výchozí kvóty na všechny uživatelské e-mailové účty.',
		],
		'session_allow_multiple_login' => [
			'title' => 'Povolit vícenásobné přihlášení',
			'description' => 'Pokud je uživatel aktivován, může se přihlásit vícekrát.',
		],
		'panel_allow_domain_change_admin' => [
			'title' => 'Povolit přesouvání domén mezi správci',
			'description' => 'Pokud je aktivováno, můžete změnit administrátora domény v nastavení domény.<br /><b>Upozornění:</b> Pokud zákazník není přiřazen stejnému správci jako doména, administrátor může vidět všechny ostatní domény tohoto zákazníka!',
		],
		'panel_allow_domain_change_customer' => [
			'title' => 'Povolit přesouvání domén mezi zákazníky',
			'description' => 'Pokud je aktivováno, můžete změnit zákazníka domény v nastavení domény.<br /><b>Upozornění:</b> Froxlor změní kořenový adresář dokumentu na výchozí domovský adresář nového zákazníka (+ doménová složka, pokud je aktivována)',
		],
		'specialsettingsforsubdomains' => [
			'description' => 'Pokud je zvoleno ano, budou tato vlastní nastavení vHost přidána ke všem subdoménám; pokud ne, budou zvláštní nastavení subdomény odstraněna.',
		],
		'panel_password_min_length' => [
			'title' => 'Minimální délka hesla',
			'description' => 'Zde můžete nastavit minimální délku hesla. "0" znamená, že není vyžadována žádná minimální délka.',
		],
		'system_store_index_file_subs' => [
			'title' => 'Uložit výchozí soubor indexu také do nových podsložek',
			'description' => 'Pokud je povoleno, výchozí indexový soubor se ukládá do každé nově vytvořené subdoménové cesty (ne pokud složka již existuje!)',
		],
		'adminmail_return' => [
			'title' => 'Odpovědět na adresu',
			'description' => 'Definujte e-mailovou adresu jako odpověď na adresu pro emaily odeslané panelem.',
		],
		'adminmail_defname' => 'Jméno odesílatele e-mailu v panelu',
		'stdsubdomainhost' => [
			'title' => 'Zákaznická standardní subdoména',
			'description' => 'Jaký název hostitele by měl být použit pro vytvoření standardních subdomén pro zákazníka. Pokud je prázdný, použije se systémový název hostitele.',
		],
		'awstats_path' => 'Cesta k AWStats \'awstats_buildstaticpages.pl\'',
		'awstats_conf' => 'Cesta k konfiguraci AWStats',
		'defaultttl' => 'TTL domény pro navázání v sekundách (výchozí \'604800\' = 1 týden)',
		'defaultwebsrverrhandler_enabled' => 'Povolit výchozí chybové dokumenty pro všechny zákazníky',
		'defaultwebsrverrhandler_err401' => [
			'title' => 'Soubor/URL pro chybu 401',
			'description' => '<div class="text-danger">Není podporováno v: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err403' => [
			'title' => 'Soubor/URL pro chybu 403',
			'description' => '<div class="text-danger">Není podporováno v: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err404' => 'Soubor/URL pro chybu 404',
		'defaultwebsrverrhandler_err500' => [
			'title' => 'Soubor/URL pro chybu 500',
			'description' => '<div class="text-danger">Není podporováno v: lighttpd</div>',
		],
		'ftpserver' => [
			'desc' => 'Pokud je zvolen pureftpd, soubory .ftpquota pro uživatelské kvóty jsou vytvářeny a denně aktualizovány',
		],
		'customredirect_enabled' => [
			'title' => 'Povolit přesměrování zákazníků',
			'description' => 'Umožnit zákazníkům vybrat kód pro http-status přesměrování, které budou použity',
		],
		'customredirect_default' => [
			'title' => 'Výchozí přesměrování',
			'description' => 'Nastavte výchozí kód přesměrování, který by se měl použít, pokud jej zákazník nenastaví sám',
		],
		'mail_also_with_mxservers' => 'Vytvořit mail-, imap-, pop3- a smtp-"A record" také s nastavením MX-serverů',
		'froxlordirectlyviahostname' => 'Přístup k Froxlor přímo prostřednictvím názvu hostitele',
		'panel_password_regex' => [
			'title' => 'Regulární výraz pro hesla',
			'description' => 'Zde můžete nastavit regulární výraz pro složitost hesel.<br />Prázdné = žádné specifické požadavky',
		],
		'perl_path' => [
			'title' => 'Cesta k perl',
			'description' => 'Výchozí je /usr/bin/perl',
		],
		'mod_fcgid_ownvhost' => [
			'title' => 'Povolit FCGID pro Froxlor vHost',
			'description' => 'Pokud je povoleno, bude Froxlor spuštěn také pod místním uživatelem',
		],
		'perl' => [
			'suexecworkaround' => [
				'title' => 'Povolit SuExec workaround',
				'description' => 'Povolit pouze v případě, že zákaznické docrooty nejsou v apache suexec cestě.<br />Pokud je povoleno, Froxlor vygeneruje symbolický odkaz od zákazníků perl-enabled adresáře + /cgi-bin/ k dané cestě.<br />Všimněte si, že perl bude fungovat pouze v podadresáři složek /cgi-bin/ a ne ve složce samotné (jako to dělá bez této opravy!)',
			],
			'suexeccgipath' => [
				'title' => 'Cesta pro symlinky adresářů zákazníka s povoleným perlem',
				'description' => 'Toto je třeba nastavit pouze pokud je povolena SuExec-workaround.<br />POZOR: Ujistěte se, že tato cesta je v rámci hlavní cesty, nebo jinak je toto řešení zbytečné',
			],
		],
		'awstats_awstatspath' => 'Cesta k AWStats \'awstats.pl\'',
		'awstats_icons' => [
			'title' => 'Cesta ke složce ikon AWstats',
			'description' => 'např. /usr/share/awstats/htdocs/icon/',
		],
		'login_domain_login' => 'Povolit přihlášení pomocí domén',
		'perl_server' => [
			'title' => 'Umístění soketu perl serveru',
			'description' => 'Jednoduchý návod najdete na: <a target="blank" href="https://www.nginx.com/resources/wiki/start/topics/examples/fcgiwrap/">nginx.com</a>',
		],
		'nginx_php_backend' => [
			'title' => 'Nginx PHP backend',
			'description' => 'zde proces PHP naslouchá požadavkům z nginxu, může to být unixový soket s kombinací ip:port<br />*Nepoužívá se s php-fpm',
		],
		'phpreload_command' => [
			'title' => 'Příkaz pro opětovné načtení PHP',
			'description' => 'toto se používá k obnovení PHP backendu, pokud je použit<br />Výchozí: prázdný<br />*NENÍ použito s php-fpm',
		],
		'phpfpm' => [
			'title' => 'Povolit php-fpm',
			'description' => '<b>To vyžaduje speciální konfiguraci webserveru viz <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/php-fpm/">PHP-FPM příručka</a></b>',
		],
		'phpfpm_settings' => [
			'configdir' => 'Adresář konfigurace php-fpm',
			'aliasconfigdir' => 'Konfigurace adresáře aliasu php-fpm',
			'reload' => 'php-fpm restart příkaz',
			'pm' => 'Řízení správce procesu (pm)',
			'max_children' => [
				'title' => 'Počet podřízených procesů',
				'description' => 'Počet podřízených procesů, které mají být vytvořeny, když je hodnota pm nastavena na \'static\' a maximální počet podřízených procesů, které mají být vytvořeny, když je hodnota pm nastavena na \'dynamic/ondemand\'<br />ekvivalent hodnoty PHP_FCGI_CHILDREN',
			],
			'start_servers' => [
				'title' => 'Počet podřízených procesů vytvořených při spuštění',
				'description' => 'Poznámka: Používá se pouze v případě, že je pm nastaven na \'dynamické\'',
			],
			'min_spare_servers' => [
				'title' => 'Požadovaný minimální počet procesů serveru v nečinnosti',
				'description' => 'Poznámka: Používá se pouze při nastavení pm na \'dynamic\'<br />Poznámka: Povinné při nastavení pm na \'dynamic\'',
			],
			'max_spare_servers' => [
				'title' => 'Požadovaný maximální počet procesů serveru v nečinnosti',
				'description' => 'Poznámka: Používá se pouze v případě, že je pm nastaven na \'dynamické\'<br />Poznámka: Povinné, když je pm nastaven na \'dynamické\'',
			],
			'max_requests' => [
				'title' => 'Požadavky na proces před znovu objevením',
				'description' => 'Pro nekonečné zpracování požadavků zadejte \'0\'. Ekvivalentní do PHP_FCGI_MAX_REQUESTS.',
			],
			'idle_timeout' => [
				'title' => 'Časový limit nečinnosti',
				'description' => 'Nastavení časového limitu pro PHP FastCGI.',
			],
			'ipcdir' => [
				'title' => 'FastCGI adresář IPC',
				'description' => 'Adresář, kam bude webový server ukládat sockety php-fpm.<br />Tento adresář musí být pro webový server čitelný',
			],
			'limit_extensions' => [
				'title' => 'Povolené přípony',
				'description' => 'Omezuje rozšíření hlavního skriptu, které FPM dovolí analyzovat. To může zabránit chybám v konfiguraci na straně webového serveru. Měli byste omezit FPM pouze na přípony .php, abyste zabránili škodlivým uživatelům používat jiné přípony ke spuštění kódu php. Výchozí hodnota: .php',
			],
			'envpath' => 'Cesty, které se přidají do prostředí PATH. Nechte prázdné, pokud proměnná prostředí PATH neexistuje',
			'override_fpmconfig' => 'Přepsat nastavení FPM-daemon (pm, max_children atd.)',
			'override_fpmconfig_addinfo' => '<br /><span class="text-danger">Používá se pouze v případě, že "Přepsat nastavení FPM-daemon" je nastaveno na "Ano"</span>',
			'restart_note' => 'Upozornění: Konfigurace nebude zkontrolována na výskyt chyb. Pokud obsahuje chyby, PHP-FPM nemusí znovu spustit!',
			'custom_config' => [
				'title' => 'Vlastní konfigurace',
				'description' => 'Přidejte vlastní konfiguraci pro každou instanci PHP-FPM verze, například <i>pm.status_path = /status</i> pro monitorování. Proměnné níže lze použít zde.  <strong>Upozornění: Konfigurace nebude zkontrolována pro žádné chyby. Pokud obsahuje chyby, PHP-FPM nemusí znovu spustit!</strong>',
			],
			'allow_all_customers' => [
				'title' => 'Přiřadit tuto konfiguraci všem aktuálně existujícím zákazníkům',
				'description' => 'Nastavte tuto hodnotu na „true“, pokud chcete tuto konfiguraci přiřadit všem aktuálně existujícím zákazníkům, aby ji mohli používat. Toto nastavení není trvalé, ale lze jej spustit vícekrát.',
			],
		],
		'report' => [
			'report' => 'Povolit odesílání hlášení o používání webu a provozu',
			'webmax' => [
				'title' => 'Úroveň varování v procentech pro webový prostor',
				'description' => 'Platné hodnoty jsou 0 až 150. Nastavením této hodnoty na 0 zakáže tuto zprávu.',
			],
			'trafficmax' => [
				'title' => 'Úroveň varování v procentech pro provoz',
				'description' => 'Platné hodnoty jsou 0 až 150. Nastavením této hodnoty na 0 zakáže tuto zprávu.',
			],
		],
		'dropdown' => 'Rozevírací nabídka',
		'manual' => 'Manuální',
		'default_theme' => 'Výchozí šablona',
		'validate_domain' => 'Ověřit názvy domén',
		'diskquota_enabled' => 'Kvóta aktivována?',
		'diskquota_repquota_path' => [
			'description' => 'Cesta k repquota',
		],
		'diskquota_quotatool_path' => [
			'description' => 'Cesta k quotatool',
		],
		'diskquota_customer_partition' => [
			'description' => 'Oddíl, na kterém jsou uloženy zákaznické soubory',
		],
		'vmail_maildirname' => [
			'title' => 'Název maildir',
			'description' => 'Maildir adresář do uživatelského účtu. Obvykle \'Maildir\', v některých implementacích \'.maildir\' a přímo do adresáře uživatele, pokud zůstane prázdný.',
		],
		'catchall_enabled' => [
			'title' => 'Použít Catchall',
			'description' => 'Chcete svým zákazníkům poskytnout funkci catchall?',
		],
		'apache_24' => [
			'title' => 'Použít úpravy pro Apache 2.4',
			'description' => '<strong class="text-danger">POZOR:</strong> použijte, pouze pokud máte nainstalovanou apache verzi 2.4 nebo vyšší<br />jinak nebude váš webserver moci spustit',
		],
		'nginx_fastcgiparams' => [
			'title' => 'Cesta k souboru fastcgi_params',
			'description' => 'Zadejte cestu k souboru fastcgi_params nginx včetně názvu souboru',
		],
		'documentroot_use_default_value' => [
			'title' => 'Použít název domény jako výchozí hodnotu pro cestu kořenového adresáře dokumentu',
			'description' => 'Pokud je povoleno a cesta DocumentRoot je prázdná, výchozí hodnotou bude název (sub)domény.<br /><br />Příklady: <br />/var/customers/customer_name/example.com/<br />/var /customers/customer_name/subdomain.example.com/',
		],
		'panel_phpconfigs_hidesubdomains' => [
			'title' => 'Skrýt subdomény v PHP-konfiguračním přehledu',
			'description' => 'Pokud je aktivováno, subdomény zákazníků nebudou zobrazeny v přehledu php-konfigurací, zobrazí se pouze počet subdomén.<br /><br />Poznámka: Toto je viditelné pouze v případě, že jste povolili FCGID nebo PHP-FPM',
		],
		'panel_phpconfigs_hidestdsubdomain' => [
			'title' => 'Skrýt standardní subdomény v přehledu konfigurace PHP-',
			'description' => 'Pokud je aktivováno, standardní subdomény pro zákazníky se nebudou zobrazovat v přehledu php-konfigurací<br /><br />Poznámka: Toto je viditelné pouze v případě, že jste povolili FCGID nebo PHP-FPM',
		],
		'passwordcryptfunc' => [
			'title' => 'Vyberte, která metoda šifrování hesla má být použita',
			'description' => 'Vyberte, která metoda šifrování heslem má být použita. Pokud toto nastavení změníte, budou šifrována pouze nová hesla s novou metodou. Stávající hesla se nezmění.',
		],
		'systemdefault' => 'Výchozí systémové nastavení',
		'panel_allow_theme_change_admin' => 'Povolit administrátorům změnit motiv',
		'panel_allow_theme_change_customer' => 'Umožnit zákazníkům změnu motivu',
		'axfrservers' => [
			'title' => 'Servery AXFR',
			'description' => 'Čárkami oddělený seznam IP adres, které mohou přenášet (AXFR) zóny.',
		],
		'powerdns_mode' => [
			'title' => 'Operační režim PowerDNS',
			'description' => 'Vyberte režim PoweDNS: Nativní pro žádnou replikaci (výchozí) / Master, pokud je potřeba DNS replikace.',
		],
		'customerssl_directory' => [
			'title' => 'Adresář zákaznických certifikátů webových serverů',
			'description' => 'Kde by měly být vytvořeny ssl-certifikáty zadané zákazníkem?<br /><br /><div class="text-danger">POZNÁMKA: Obsah této složky je pravidelně smazán, aby se zabránilo ukládání dat do této složky ručně.</div>',
		],
		'allow_error_report_admin' => [
			'title' => 'Povolit správcům/prodejcům nahlásit chyby databáze Froxlor',
			'description' => 'Upozornění: Nikdy nám neposílejte žádné osobní (zákaznické)údaje!',
		],
		'allow_error_report_customer' => [
			'title' => 'Umožnit zákazníkům nahlásit chyby databáze Froxlor',
			'description' => 'Upozornění: Nikdy nám neposílejte žádné osobní (zákaznické)údaje!',
		],
		'mailtraffic_enabled' => [
			'title' => 'Analyzovat přenos pošty',
			'description' => 'Povolit analýzu protokolů mailserveru pro výpočet provozu',
		],
		'mdaserver' => [
			'title' => 'MDA typ',
			'description' => 'Typ poštovního serveru',
		],
		'mdalog' => [
			'title' => 'Protokol MDA',
			'description' => 'Soubor protokolu serveru pro doručování pošty',
		],
		'mtaserver' => [
			'title' => 'MTA typ',
			'description' => 'Typ zprostředkovatele pro přenos pošty',
		],
		'mtalog' => [
			'title' => 'Protokol MTA',
			'description' => 'Soubor protokolu agenta pro přenos pošty',
		],
		'system_cronconfig' => [
			'title' => 'Konfigurační soubor cronu',
			'description' => 'Cesta ke konfiguračnímu souboru cron-service. Tento soubor bude pravidelně a automaticky aktualizován froxlorem.<br />Poznámka: <b>Ujistěte se</b>, že používáte stejný název souboru jako pro hlavní froxlor cronjob (výchozí: /etc/cron.d/froxlor)!<br><br>Pokud používáte <b>FreeBSD</b>, zadejte zde <i>/etc/crontab</i>!',
		],
		'system_crondreload' => [
			'title' => 'Příkaz pro opětovné načtení Cron-daemona',
			'description' => 'Určete příkaz, který má být proveden, aby bylo možné znovu načíst systémy cron-daemon',
		],
		'system_croncmdline' => [
			'title' => 'Příkaz pro provedení cronu (php-binary)',
			'description' => 'Příkaz k provedení našich cronjobů. Změňte to pouze pokud víte, co děláte (výchozí: "/usr/bin/nice -n 5 /usr/bin/php -q")!',
		],
		'system_cron_allowautoupdate' => [
			'title' => 'Povolit automatické aktualizace databáze',
			'description' => '<div class="text-danger"><b>POZOR:</b></div> Toto nastavení umožňuje cronjob obejít kontrolu verzí froxlor souborů a databáze a spustit aktualizace databáze v případě, že dojde k nesouladu verzí.<br><br><div class="text-danger">Automatická aktualizace vždy nastaví výchozí hodnoty pro nová nastavení nebo změny. Toto nemusí vždy vyhovovat vašemu systému. Před aktivací této možnosti</div> prosím dvakrát rozmyslete',
		],
		'dns_createhostnameentry' => 'Vytvořte bind-zone/config pro název hostitele systému',
		'panel_password_alpha_lower' => [
			'title' => 'Malé písmo',
			'description' => 'Heslo musí obsahovat alespoň jedno malé písmeno (a-z).',
		],
		'panel_password_alpha_upper' => [
			'title' => 'Velké písmeno',
			'description' => 'Heslo musí obsahovat alespoň jedno velké písmeno (A-Z).',
		],
		'panel_password_numeric' => [
			'title' => 'Čísla',
			'description' => 'Heslo musí obsahovat alespoň jedno číslo (0-9).',
		],
		'panel_password_special_char_required' => [
			'title' => 'Speciální znak',
			'description' => 'Heslo musí obsahovat alespoň jeden z níže uvedených znaků.',
		],
		'panel_password_special_char' => [
			'title' => 'Seznam speciálních znaků',
			'description' => 'Jeden z těchto znaků je vyžadován, pokud je nastavena výše uvedená volba.',
		],
		'apache_itksupport' => [
			'title' => 'Použít úpravy ITK-MPM Apache',
			'description' => '<strong class="text-danger">POZOR:</strong> použijte, pouze pokud máte opravdu povoleno apache itk-mpm<br />jinak váš webserver nebude moci spustit',
		],
		'letsencryptca' => [
			'title' => 'ACME prostředí',
			'description' => 'Prostředí, které se má použít pro certifikáty Let\'s Encrypt / ZeroSSL.',
		],
		'letsencryptchallengepath' => [
			'title' => 'Cesta k výzvám Let\'s Encrypt',
			'description' => 'Adresář, ze kterého by měly být nabízeny výzvy Let\'s Encrypt prostřednictvím globálního aliasu.',
		],
		'letsencryptkeysize' => [
			'title' => 'Velikost klíče pro nové Let\'s Encrypt certifikáty',
			'description' => 'Velikost klíče v Bitech pro nové Let\'s Encrypt certifikáty.',
		],
		'letsencryptreuseold' => [
			'title' => 'Znovu použít Let\'s Encrypt klíč',
			'description' => 'Pokud je aktivován, bude při každém obnovení použit stejný klíč, jinak bude pokaždé vygenerován nový klíč.',
		],
		'leenabled' => [
			'title' => 'Použít Let\'s Encrypt',
			'description' => 'Pokud je aktivováno, zákazníci mohou nechat froxlor automaticky generovat a obnovit šifrovací certifikáty domén s ssl IP/portem.<br /><br />Nezapomeňte, že musíte procházet konfigurací webserveru, pokud je povoleno, protože tato funkce vyžaduje speciální konfiguraci.',
		],
		'caa_entry' => [
			'title' => 'Generovat CAA DNS záznamy',
			'description' => 'Automaticky generuje CAA záznamy pro domény s podporou SSL, které používají Let\'s Encrypt',
		],
		'caa_entry_custom' => [
			'title' => 'Další záznamy CAA DNS',
			'description' => 'DNS Certification Authority autorizace (CAA) je mechanismus politiky bezpečnosti internetu, který držitelům doménových jmen umožňuje certifikovat autoritě<br>, zda jsou oprávněni vydávat digitální certifikáty pro určitý název domény. To dělá pomocí nového zdrojového záznamu doménového systému "CAA" (DNS).<br><br>Obsah tohoto pole bude zahrnut do DNS zóny přímo (každý řádek vyústí v CAA záznam).<br>Pokud je pro tuto doménu povoleno šifrování, tato položka bude vždy přidána automaticky a nemusí být přidána ručně:<br><code>0 problém "letsencrypt". rg"</code> (Pokud doména je doména zástupných znaků, bude místo toho použita vydání).<br>Chcete-li povolit hlášení incidentů, můžete přidat záznam <code>iodef</code>. Příklad pro odeslání zprávy na <code>me@example. om</code> bude:<br><code>0 iodef "mailto:me@example. om"</code><br><br><strong>Upozornění:</strong> Kód nebude zkontrolován z důvodu chyb. Pokud obsahuje chyby, vaše CAA záznamy nemusí fungovat!',
		],
		'exportenabled' => [
			'title' => 'Povolit export dat pro zákazníky',
			'description' => 'Pokud je aktivováno, zákazník bude moci naplánovat úlohy pro export dat (cron-export), které generují archiv ve svém docrootu (podadresář vybraný zákazníkem)',
		],
		'dnseditorenable' => [
			'title' => 'Povolit DNS editor',
			'description' => 'Umožňuje administrátorům a zákazníkovi spravovat dns záznamy domén',
		],
		'dns_server' => [
			'title' => 'Daemon DNS serveru',
			'description' => 'Nezapomeňte, že "daemons" je třeba konfigurovat pomocí konfiguračních šablon froxloru',
		],
		'panel_customer_hide_options' => [
			'title' => 'Skrytí položek nabídek a grafů návštěvnosti v zákaznickém panelu',
			'description' => 'Vyberte položky, které chcete skrýt v panelu zákazníka. Chcete-li vybrat více možností, podržte CTRL při výběru.',
		],
		'allow_allow_customer_shell' => [
			'title' => 'Umožnit zákazníkům povolit přístup přes shell pro uživatele ftp',
			'description' => '<strong class="text-danger">Upozornění: Přístup k Shell umožňuje uživateli spustit různé binární soubory ve vašem systému. Používejte s extrémní opatrností. Aktivujte prosím pouze pokud víte, co děláte!!!</strong>',
		],
		'available_shells' => [
			'title' => 'Seznam dostupných příkazů',
			'description' => 'Čárkami oddělený seznam shellů, z nichž si může zákazník vybrat pro své ftp uživatele.<br><br>Všimněte si, že výchozí shell <strong>/bin/false</strong> bude vždy na výběr (pokud je povolen), i když je toto nastavení prázdné. V každém případě je to výchozí hodnota proftp uživatele',
		],
		'le_froxlor_enabled' => [
			'title' => 'Povolit Let\'s Encrypt pro hostitele froxlor',
			'description' => 'Pokud je aktivováno, bude vhost froxloru automaticky zabezpečen pomocí Let\'s Encrypt certifikátu.',
		],
		'le_froxlor_redirect' => [
			'title' => 'Povolit přesměrování SSL pro vhost froxloru',
			'description' => 'Pokud je aktivováno, všechny požadavky http na váš froxlor budou přesměrovány na příslušný server SSL.',
		],
		'option_unavailable_websrv' => '<br><em class="text-danger">K dispozici pouze pro: %s</em>',
		'option_unavailable' => '<br><em class="text-danger">Možnost není dostupná kvůli jiným nastavením.</em>',
		'letsencryptacmeconf' => [
			'title' => 'Cesta k snippetu acme.conf',
			'description' => 'Název souboru v konfiguračním textovém bloku, který umožňuje webovému serveru obsluhovat výzvu acme.',
		],
		'mail_use_smtp' => 'Nastavte e-mail pro použití SMTP',
		'mail_smtp_host' => 'Zadejte SMTP server',
		'mail_smtp_usetls' => 'Povolit šifrování TLS',
		'mail_smtp_auth' => 'Povolit ověřování SMTP',
		'mail_smtp_port' => 'TCP port pro připojení k',
		'mail_smtp_user' => 'SMTP uživatelské jméno',
		'mail_smtp_passwd' => 'SMTP heslo',
		'http2_support' => [
			'title' => 'HTTP2 podpora',
			'description' => 'povolit podporu HTTP2 pro ssl.<br><em class="text-danger">POVOLTE POUZE POKUD VÁŠ SERVER TUTO FUNKCI PODPORUJE (nginx verze 1.9.5+, apache2 verze 2.4.17+)</em>',
		],
		'nssextrausers' => [
			'title' => 'Použít libnss-extrauser místo libnss-mysql',
			'description' => 'Nečíst uživatele z databáze, ale ze souborů. Aktivujte se, prosím, pouze pokud jste již prošli požadovanými kroky konfigurace (system -> libnss-extrausers).<br><strong class="text-danger">Pouze pro Debian/Ubuntu (nebo pokud jste sami zkompilovali libnss-extrauser!)</strong>',
		],
		'le_domain_dnscheck' => [
			'title' => 'Ověřit DNS domén při použití Let\'s Encrypt',
			'description' => 'Pokud je aktivováno, froxlor ověří, zda se doména, která žádá o certifikát, směřuje alespoň na jednu ze Ip adres systému.',
		],
		'le_domain_dnscheck_resolver' => [
			'title' => 'Použít externí nameserver pro ověření DNS',
			'description' => 'Je-li nastaveno, froxlor použije tuto DNS k ověření DNS domén při použití Let\'s Encrypt. Pokud je prázdné, bude použit výchozí překladač DNS systému.',
		],
		'phpsettingsforsubdomains' => [
			'description' => 'Pokud ano, zvolený php-config bude aktualizován na všechny subdomény',
		],
		'leapiversion' => [
			'title' => 'Zvolte si implementaci ACME pro Let\'s Encrypt',
			'description' => 'V současné době je podporována pouze implementace ACME v2 pro Let\'s Encrypt.',
		],
		'enable_api' => [
			'title' => 'Povolit externí použití API',
			'description' => 'Chcete-li používat froxlor API, musíte aktivovat tuto možnost. Podrobnější informace naleznete v <a href="https://docs.froxlor.org/latest/api-guide/" target="_new">https://docs.froxlor.org/</a>',
		],
		'api_customer_default' => '"Povolit přístup k API" pro nové zákazníky',
		'dhparams_file' => [
			'title' => 'Soubor DHParams (výměna klíčů Diffie-Hellman)',
			'description' => 'Pokud je zde zadán soubor dhparams.pem, bude zahrnut do konfigurace webserveru. Ponechte prázdné pro vypnutí.<br>Příklad: /etc/ssl/webserver/dhparams.<br><br>Pokud soubor neexistuje, bude vytvořen automaticky s následujícím příkazem: <code>openssl dhparam -out /etc/ssl/webserver/dhparams. em 4096</code>. Před zadáním souboru je doporučeno vytvořit soubor, protože vytvoření trvá docela dlouho a blokuje cronjob.',
		],
		'errorlog_level' => [
			'title' => 'Úroveň protokolů chyb',
			'description' => 'Zadejte úroveň protokolu chyb. Výchozí hodnota je "warn" pro apache-user a "error" pro nginx-usery.',
		],
		'letsencryptecc' => [
			'title' => 'Vystavit certifikát ESC / certifikát ECDSA',
			'description' => 'Je-li nastaveno na platnou velikost klíče, vystavený certifikát bude používat ECC / ECDSA',
		],
		'froxloraliases' => [
			'title' => 'Aliasy domén pro froxlor vhost',
			'description' => 'Čárkami oddělený seznam domén, které mají být přidány jako serverový alias do froxlor vhost',
		],
		'default_sslvhostconf' => [
			'title' => 'Výchozí nastavení SSL vHost-serveru',
			'description' => 'Obsah tohoto pole bude přímo zahrnut do tohoto kontejneru s ip/portem. Můžete použít následující proměnné:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code> <code>{FPMSOCKET}</code> (pokud existuje)<br/> Upozornění: Kód nebude zkontrolován na výskyt chyb. Pokud obsahuje chyby, webový server nemusí znovu spustit!',
		],
		'includedefault_sslvhostconf' => 'Zahrnout ne-SSL vHost-nastavení v SSL-vHost',
		'apply_specialsettings_default' => 'Výchozí hodnota pro "Použít speciální nastavení pro všechny subdomény (*.example.com)" při úpravě domény',
		'apply_phpconfigs_default' => 'Výchozí hodnota pro nastavení "Použít php konfiguraci na všechny subdomény" při úpravě domény',
		'awstats' => [
			'logformat' => [
				'title' => 'Nastavení LogFormat',
				'description' => 'Pokud používáte vlastní logformat pro svůj webový server, musíte také změnit awstats LogFormat.<br/>Výchozí je 1. Pro více informací zkontrolujte dokumentaci <a target="_blank" href="https://awstats.sourceforge.io/docs/awstats_config.html#LogFormat">zde</a>.',
			],
		],
		'hide_incompatible_settings' => 'Skrýt nekompatibilní nastavení',
		'soaemail' => 'E-mailová adresa pro použití v SOA záznamech (výchozí adresa odesílatele z nastavení panelu, pokud je prázdná)',
		'imprint_url' => [
			'title' => 'Adresa URL k právním poznámkám / otisku',
			'description' => 'Zadejte adresu URL svých právních poznámek / stránek s otisky. Odkaz bude viditelný na přihlašovací obrazovce a v zápatí po přihlášení.',
		],
		'terms_url' => [
			'title' => 'URL k podmínkám použití',
			'description' => 'Zadejte adresu URL k podmínkám používání. Odkaz bude viditelný na přihlašovací obrazovce a v zápatí při přihlášení.',
		],
		'privacy_url' => [
			'title' => 'URL k zásadám ochrany osobních údajů',
			'description' => 'Zadejte adresu URL své stránky se zásadami ochrany osobních údajů / stránky s otisky. Odkaz bude viditelný na přihlašovací obrazovce a v zápatí po přihlášení.',
		],
		'logo_image_header' => [
			'title' => 'Obrázek loga (záhlaví)',
			'description' => 'Nahrajte vlastní obrázek loga, který se zobrazí v záhlaví po přihlášení (doporučená výška 30px)',
		],
		'logo_image_login' => [
			'title' => 'Obrázek loga (Přihlašovací obrazovka)',
			'description' => 'Nahrajte vlastní obrázek loga, který se zobrazí během přihlášení',
		],
		'logo_overridetheme' => [
			'title' => 'Přepíše logo definované v motivu pomocí "Logo Image" (hlavička a přihlašovací stránka, viz níže)',
			'description' => 'Toto musí být nastaveno na "true", pokud máte v úmyslu použít nahrané logo_custom. Alternativně můžete stále používat "Logo custom. ng" a "logo_custom_login.png".',
		],
		'logo_overridecustom' => [
			'title' => 'Přepsat vlastní logo (logo_custom.png a logo_custom_login.png) definované v šabloně "Obrázek loga" (hlavička a přihlášení, viz níže)',
			'description' => 'Nastavte na "true" pokud chcete ignorovat vlastní loga pro záhlaví a přihlášení a použít "Logo Image"',
		],
		'createstdsubdom_default' => [
			'title' => 'Předvolená hodnota pro "Vytvořit standardní subdoménu" při vytváření zákazníka',
			'description' => '',
		],
		'froxlorusergroup' => [
			'title' => 'Vlastní systémová skupina pro všechny zákazníky',
			'description' => 'Použití libnss-extrauser (systémového nastavení) je vyžadováno. Vytváření prázdných hodnot přeskočí nebo odstraní existující skupinu.',
		],
		'acmeshpath' => [
			'title' => 'Cesta k acme.sh',
			'description' => 'Nastavte na místo, kde je acme.sh nainstalován, včetně skriptu acme.sh<br>Výchozí je <b>/root/.acme.sh/acme.sh</b>',
		],
		'update_channel' => [
			'title' => 'froxlor aktualizační-kanál',
			'description' => 'Vyberte aktualizační kanál froxlor. Výchozí hodnota je "stabilní"',
		],
		'uc_stable' => 'stabilní',
		'uc_testing' => 'testovací',
		'uc_nightly' => 'nightly',
		'traffictool' => [
			'toolselect' => 'Analyzátor provozu',
			'webalizer' => 'Webalizer',
			'awstats' => 'AWStats',
			'goaccess' => 'goaccess'
		],
		'requires_reconfiguration' => 'Změna tohoto nastavení může vyžadovat změnu konfigurace následujících služeb:<br><strong>%s</strong>',
		'req_limit_per_interval' => [
			'title' => 'Počet HTTP požadavků na interval',
			'description' => 'Omezit počet HTTP požadavků na interval (viz níže) pro froxlor, výchozí hodnota je "60"',
		],
		'req_limit_interval' => [
			'title' => 'Interval omezení rychlosti',
			'description' => 'Zadejte čas v sekundách pro počet HTTP požadavků. Výchozí hodnota je "60"',
		],
		'option_requires_otp' => 'Toto nastavení vyžaduje ověření přes OTP',
		'panel_menu_collapsed' => [
			'title' => 'Sbalit sekce menu',
			'description' => 'Pokud dojde k deaktivaci, levé části menu budou vždy rozšířeny.',
		],
		'le_renew_services' => [
			'title' => 'Pro tyto služby použijte certifikát froxloru Let\'s Encrypt',
			'description' => 'Pokud je nastavena hodnota none (nebo je níže uvedený příkaz renew-hook prázdný), nebudou u vybraných služeb provedeny žádné úpravy konfigurace týkající se ssl.<br><br>Příkaz reload-command pro vybrané služby by měl být přidán do příkazu renew-hook, jinak se změny konfigurace nebo obnovené certifikáty nemusí správně použít.',
		],
		'le_renew_hook' => [
			'title' => 'Příkaz renew-hook programu Let\'s Encrypt',
			'description' => 'Nastavte příkaz, který restartuje výše vybrané služby, aby služba mohla obnovené certifikáty správně používat.',
		],
	],
	'spf' => [
		'use_spf' => [
			'title' => 'Aktivovat SPF pro domény?',
			'description' => 'Vyžaduje pro doménu určitou položku dns. Pokud nepoužíváte funkci nameserver, budete muset tyto položky ručně spravovat.',
		],
		'spf_entry' => 'SPF položka pro všechny domény',
	],
	'dmarc' => [
		'use_dmarc' => [
			'title' => 'Aktivovat DMARC pro domény?',
			'description' => 'Vyžaduje pro doménu určitou položku dns. Pokud nepoužíváte funkci nameserver, budete muset tyto položky ručně spravovat.',
		],
		'dmarc_entry' => 'DMARC záznam pro všechny domény',
	],
	'ssl_certificates' => [
		'certificate_for' => 'Certifikát pro',
		'valid_from' => 'Platné od',
		'valid_until' => 'Platné do',
		'issuer' => 'Vydavatel',
	],
	'success' => [
		'messages_success' => 'Zpráva byla úspěšně odeslána příjemcům %s',
		'success' => 'Informace',
		'clickheretocontinue' => 'Klikněte zde pro pokračování',
		'settingssaved' => 'Nastavení bylo úspěšně uloženo.',
		'rebuildingconfigs' => 'Úspěšně vložené úkoly pro obnovení konfiguračních souborů',
		'domain_import_successfully' => 'Úspěšně importováno %s domén.',
		'exportscheduled' => 'Vaše exportní úloha byla naplánována. Počkejte prosím na její zpracování',
		'exportaborted' => 'Váš plánovaný export byl zrušen',
		'dns_record_added' => 'Záznam byl úspěšně přidán',
		'dns_record_deleted' => 'Záznam byl úspěšně odstraněn',
		'testmailsent' => 'Testovací e-mail byl úspěšně odeslán',
		'settingsimported' => 'Nastavení bylo úspěšně importováno',
		'sent_error_report' => 'Hlášení o chybách bylo úspěšně odesláno. Děkujeme za váš příspěvek.',
	],
	'tasks' => [
		'outstanding_tasks' => 'Nevyřízené úlohy',
		'REBUILD_VHOST' => 'Obnovení konfigurace webserveru',
		'CREATE_HOME' => 'Přidávání nového zákazníka %s',
		'REBUILD_DNS' => 'Obnovení bind konfigurace',
		'CREATE_FTP' => 'Vytváření adresáře pro nového uživatele ftp-user',
		'DELETE_CUSTOMER_FILES' => 'Mazání zákaznických souborů %s',
		'noneoutstanding' => 'V současné době nejsou žádné nevyřízené úkoly pro Froxlor',
		'DELETE_EMAIL_DATA' => 'Odstranit e-mailová data zákazníka.',
		'DELETE_FTP_DATA' => 'Odstranit data ftp účtu.',
		'REBUILD_RSPAMD' => 'Obnovení konfigurace antispamu.',
		'CREATE_QUOTA' => 'Nastavit kvótu na souborovém systému',
		'REBUILD_CRON' => 'Obnovení cron.d-souboru',
		'CREATE_CUSTOMER_DATADUMP' => 'Úloha pro export dat pro zákazníka %s',
		'DELETE_DOMAIN_PDNS' => 'Odstranit doménu %s z databáze PowerDNS',
		'DELETE_DOMAIN_SSL' => 'Odstranit ssl soubory domény %s',
	],
	'terms' => 'Podmínky použití',
	'traffic' => [
		'month' => 'Měsíc',
		'day' => 'Den',
		'months' => [
			1 => 'Leden',
			2 => 'Únor',
			3 => 'Březen',
			4 => 'Duben',
			5 => 'Květen',
			6 => 'Červen',
			7 => 'Červenec',
			8 => 'Srpen',
			9 => 'Září',
			10 => 'Říjen',
			11 => 'Listopad',
			12 => 'Prosinec',
			'jan' => 'Led',
			'feb' => 'Ún',
			'mar' => 'Bře',
			'apr' => 'Dub',
			'may' => 'Kvě',
			'jun' => 'Čvn',
			'jul' => 'Čvc',
			'aug' => 'Srp',
			'sep' => 'Zář',
			'oct' => 'Říj',
			'nov' => 'Lis',
			'dec' => 'Pro',
			'total' => 'Celkem',
		],
		'mb' => 'Provoz',
		'sumtotal' => 'Celkový provoz',
		'sumhttp' => 'HTTP provoz',
		'sumftp' => 'FTP provoz',
		'summail' => 'Přenos e-mailů',
		'customer' => 'Zákazník',
		'domain' => 'Doména',
		'trafficoverview' => 'Shrnutí provozu',
		'bycustomers' => 'Provoz podle zákazníků',
		'details' => 'Podrobnosti',
		'http' => 'HTTP',
		'ftp' => 'FTP',
		'mail' => 'Mail',
		'nocustomers' => 'Potřebujete alespoň jednoho zákazníka pro zobrazení statistik provozu.',
		'top5customers' => 'Top 5 zákazníků',
		'nodata' => 'Pro daný rozsah nebyla nalezena žádná data.',
		'ranges' => [
			'last24h' => 'posledních 24 hodin',
			'last7d' => 'posledních 7 dní',
			'last30d' => 'posledních 30 dní',
			'cm' => 'Aktuální měsíc',
			'last3m' => 'poslední 3 měsíce',
			'last6m' => 'posledních 6 měsíců',
			'last12m' => 'posledních 12 měsíců',
			'cy' => 'Aktuální rok',
		],
		'byrange' => 'Určeno podle rozsahu',
	],
	'translator' => '',
	'update' => [
		'updateinprogress_onlyadmincanlogin' => 'Byla nainstalována novější verze Froxloru, ale ještě nebyla nastavena.<br />Pouze správce se může přihlásit a dokončit aktualizaci.',
		'update' => 'Aktualizace Froxloru',
		'proceed' => 'Pokračovat',
		'update_information' => [
			'part_a' => 'Froxlor soubory byly aktualizovány na verzi <strong>%s</strong>. Nainstalovaná verze je <strong>%s</strong>.',
			'part_b' => '<br /><br />Zákazníci se nebudou moci přihlásit, dokud nebude aktualizace dokončena.<br /><strong>Pokračovat?</strong>',
		],
		'noupdatesavail' => 'Již máte nejnovější verzi %sFroxlor nainstalovanou.',
		'description' => 'Probíhá aktualizace databáze pro vaši instalaci froxlor',
		'uc_newinfo' => 'K dispozici je novější verze %s: "%s" (Vaše aktuální verze je: %s)',
		'notify_subject' => 'K dispozici je nová aktualizace',
		'dbupdate_required' => 'Froxlor soubory byly aktualizovány, je vyžadována aktualizace databáze',
	],
	'usersettings' => [
		'custom_notes' => [
			'title' => 'Vlastní poznámky',
			'description' => 'Nebojte se zde vložit jakékoliv poznámky, které chcete/potřebujete. Zobrazí se v přehledu správce/zákazníka pro příslušného uživatele.<br>Markdown je podporován, HTML bude odstraněno.',
			'show' => 'Zobrazit své poznámky na nástěnce uživatele',
		],
		'api_allowed' => [
			'title' => 'Povolit přístup k API',
			'description' => 'Pokud je povoleno v nastavení, může tento uživatel vytvořit API klíče a přistupovat k froxlor API',
			'notice' => 'Přístup k API není povolen pro váš účet.',
		],
		'gui_access' => [
			'title' => 'Povolit přihlášení do WebUI',
			'description' => 'Pokud je zakázáno, uživatel se nemůže přihlásit do froxlor web-ui, ale všechny služby (web, ftp, mail, databáze, api-přístup atd.) budou fungovat normálně.',
		],
	],
	'install' => [
		'slogan' => 'panel pro správu serveru froxlor',
		'preflight' => 'Kontrola systému',
		'critical_error' => 'Kritická chyba',
		'suggestions' => 'Není vyžadováno, ale doporučuje se',
		'phpinfosuccess' => 'Váš systém běží s PHP %s',
		'phpinfowarn' => 'Váš systém běží na nižší verzi než PHP %s',
		'phpinfoupdate' => 'Aktualizujte vaši aktuální verzi PHP z %s na %s nebo vyšší',
		'start_installation' => 'Spustit instalaci',
		'check_again' => 'Znovu načtěte a zkontrolujte',
		'switchmode_advanced' => 'Zobrazit rozšířené možnosti',
		'switchmode_basic' => 'Skrýt rozšířené možnosti',
		'dependency_check' => [
			'title' => 'Vítejte ve froxloru',
			'description' => 'Zkontrolujeme závislost systému, abychom zajistili, že budou povolena všechna požadovaná php rozšíření a moduly, aby froxlor běžel správně.',
		],
		'database' => [
			'top' => 'Databáze',
			'title' => 'Vytvořit databázi a uživatele',
			'description' => 'Froxlor vyžaduje databázi a navíc <a href="https://docs.froxlor.org/latest/general/installation/tarball.html#_3-create-privileged-database-user" target="_blank">privilegovaného uživatele</a>, aby mohl vytvářet uživatele a databáze (volba GRANT). Daná databáze a neprivilegovaný databázový uživatel bude vytvořen v tomto procesu. Oprávněný uživatel musí existovat.',
			'user' => 'Neoprávněný databázový uživatel',
			'dbname' => 'Název databáze',
			'force_create' => 'Zálohovat a přepsat databázi, pokud existuje?',
		],
		'admin' => [
			'top' => 'Admin uživatel',
			'title' => 'Pojďme vytvořit hlavního administrátora.',
			'description' => 'Tomuto uživateli budou udělena všechna oprávnění pro úpravu nastavení a přidávání/aktualizace/mazání zdrojů, jako jsou zákazníci, domény, atd.',
			'use_admin_email_as_sender' => 'Použijte výše uvedenou e-mailovou adresu jako adresu odesílatele. Pokud není zaškrtnuto, zadejte prosím níže uvedenou adresu odesílatele.',
			'use_autogenerated_email_as_sender' => 'Ponechte prázdné pro výchozí: admin@názevserveru',
		],
		'system' => [
			'top' => 'Systémové nastavení',
			'title' => 'Podrobnosti o Vašem serveru',
			'description' => 'Nastavte si své prostředí stejně jako data a možnosti související se serverem, aby se froxlor mohl dozvědět o vašem systému. Tyto hodnoty jsou klíčové pro konfiguraci a fungování systému.',
			'ipv4' => 'Primární IPv4 adresa (použije-li se)',
			'ipv6' => 'Primární IPv6 adresa (použije-li se)',
			'servername' => 'Název serveru (FQDN, žádná ip-adresa)',
			'phpbackend' => 'PHP backend',
			'activate_newsfeed' => 'Povolit oficiální novinky<br><small>(externí zdroj: https://inside.froxlor.org/news/)</small>',
		],
		'install' => [
			'top' => 'Dokončit nastavení',
			'title' => 'Poslední krok...',
			'description' => 'Níže uvedený příkaz stáhne, nainstaluje a nakonfiguruje požadované služby ve vašem systému podle údajů, které jste zadali v tomto instalačním procesu.<br><br><span class="text-danger">Nezapomeňte spustit následující příkaz jako <b>root</b> na shell/terminál serveru a <b>uvědomte si</b>, že tento příkaz <b>přepíše</b> jakoukoli existující konfiguraci pro použité služby (budou vytvořeny zálohy)!.<br>Pokud nechcete přepsat žádné konfigurace, vyberte možnost <i>Nakonfiguruji služby ručně</i> v dolní části této stránky!</span>',
			'runcmd' => 'Spusťte následující příkaz pro dokončení instalace:',
			'manual_config' => 'Služby nakonfiguruji ručně, stačí mě přesměrovat k přihlášení',
			'waitforconfig' => 'Čekání na konfiguraci služeb...',
		],
		'errors' => [
			'wrong_ownership' => 'Ujistěte se, že soubory froxlor jsou vlastněny %s:%s',
			'missing_extensions' => 'Následující php rozšíření jsou vyžadována a nejsou nainstalována',
			'suggestedextensions' => 'Následující php rozšíření se nepodařilo najít, ale jsou doporučeny',
			'databaseexists' => 'Databáze již existuje, prosím nastavte možnost přepsání pro obnovu nebo zvolte jiný název',
			'unabletocreatedb' => 'Nelze vytvořit testovací databázi',
			'unabletodropdb' => 'Nelze zrušit zkušební databázi',
			'mysqlusernameexists' => 'Uživatel určený pro uživatele bez oprávnění již existuje. Použijte prosím jiné uživatelské jméno, nebo jej odstraňte.',
			'unabletocreateuser' => 'Nelze vytvořit testovacího uživatele',
			'unabletodropuser' => 'Nelze zrušit testovací uživatele',
			'unabletoflushprivs' => 'Zadaný privilegovaný uživatel nemůže vymazat oprávnění',
			'nov4andnov6ip' => 'Musí být zadána adresa IPv4 nebo IPv6',
			'servernameneedstobevalid' => 'Zadaný název serveru se nezdá být FQDN nebo hostname',
			'websrvuserdoesnotexist' => 'Zdá se, že uživatel webového serveru v systému neexistuje',
			'websrvgrpdoesnotexist' => 'Zdá se, že daná webserverová skupina v systému neexistuje',
			'notyetconfigured' => 'Zdá se, že služby ještě nebyly nakonfigurovány (úspěšně). Proveďte prosím příkaz níže nebo zaškrtněte políčko pro pozdější zpracování.',
			'mandatory_field_not_set' => 'Povinné pole "%s" není nastaveno!',
			'unexpected_database_error' => 'Došlo k neočekávané výjimce databáze. %s',
			'sql_import_failed' => 'Nepodařilo se importovat SQL data!',
			'unprivileged_sql_connection_failed' => 'Nepodařilo se inicializovat neprivilegované SQL připojení!',
			'privileged_sql_connection_failed' => 'Nepodařilo se inicializovat privilegované SQL připojení!',
			'mysqldump_backup_failed' => 'Nelze vytvořit zálohu databáze, došlo k chybě mysqldump.',
			'sql_backup_file_missing' => 'Nelze vytvořit zálohu databáze, záložní soubor neexistuje.',
			'backup_binary_missing' => 'Nelze vytvořit zálohu databáze, ujistěte se, že jste nainstalovali mysqldump.',
			'creating_configfile_failed' => 'Nelze vytvořit konfigurační soubory, nelze zapisovat do souboru.',
			'database_already_exiting' => 'Našli jsme databázi a nebylo možné ji přepsat!'
		]
	],
	'welcome' => [
		'title' => 'Vítejte ve froxloru!',
		'config_note' => 'Aby mohl froxlor správně komunikovat se zálohou, musíte ji nakonfigurovat.',
		'config_now' => 'Nastavit nyní'
	],
];
