<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can also view it online at
 * https://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  the authors
 * @author     Froxlor team <team@froxlor.org>
 * @author     Sander Klein <roedie@roedie.nl>
 * @author     Frits Letteboer <f.letteboer@radiotwenterand.nl>
 * @license    https://files.froxlor.org/misc/COPYING.txt GPLv2
 */

return [
	'admin' => [
		'overview' => 'Overzicht',
		'ressourcedetails' => 'Gebruikte resources',
		'systemdetails' => 'Systeem Details',
		'installedversion' => 'Geïnstalleerde Versie',
		'latestversion' => 'Laatste Versie',
		'lookfornewversion' => [
			'clickhere' => 'zoeken via webservice',
			'error' => 'Fout tijdens lezen',
		],
		'customer' => 'Klant',
		'customers' => 'Klanten',
		'customer_add' => 'Maak klant',
		'customer_edit' => 'Bewerk klant',
		'domains' => 'Domeinen',
		'domain_add' => 'Maak domein',
		'domain_edit' => 'Bewerk domein',
		'subdomainforemail' => 'Subdomein als emaildomein',
		'admin' => 'Beheerder',
		'admins' => 'Beheerders',
		'admin_add' => 'Maak beheerder',
		'admin_edit' => 'Bewerk beheerder',
		'customers_see_all' => 'Kan alle klanten zien?',
		'change_serversettings' => 'Kan server instellingen aanpassen?',
		'serversettings' => 'Instellingen',
		'rebuildconf' => 'Configuratie bestanden opnieuw aanmaken',
		'stdsubdomain' => 'Standaard subdomein',
		'stdsubdomain_add' => 'Maak standard subdomein',
		'deactivated' => 'Gedeactiveerd',
		'deactivated_user' => 'Gebruiker deactiveren',
		'sendpassword' => 'Verstuur wachtwoord',
		'ownvhostsettings' => 'Eigen vHost-Instellingen',
		'configfiles' => [
			'serverconfiguration' => 'Configuratie',
			'overview' => 'Overzicht',
			'wizard' => 'Wizard',
			'distribution' => 'Distributie',
			'service' => 'Dienst',
			'etc' => 'Overigen (Systeem)',
			'choosedistribution' => '-- Kies een distributie --',
			'chooseservice' => '-- Kies een dienst --',
			'choosedaemon' => '-- Kies een daemon --',
			'statistics' => 'Statistieken',
			'compactoverview' => 'Compacte weergave',
		],
		'templates' => [
			'templates' => 'Sjablonen',
			'template_add' => 'Maak sjabloon',
			'template_edit' => 'Bewerk sjabloon',
			'action' => 'Actie',
			'email' => 'E-Mail',
			'subject' => 'Onderwerp',
			'mailbody' => 'Mail inhoud',
			'createcustomer' => 'Welkomst bericht voor nieuwe klanten',
			'pop_success' => 'Welkomst bericht voor e-mail nieuw account',
			'template_replace_vars' => 'Variabelen die aangepast worden in het sjabloon:',
			'FIRSTNAME' => 'Vervangen door de voornaam van de klant.',
			'NAME' => 'Vervangen door de naam van de klant.',
			'USERNAME' => 'Vervangen door de gebruikersnaam van de klant.',
			'PASSWORD' => 'Vervangen door het wachtwoord van de klant.',
			'EMAIL' => 'Vervangen door het adres van het POP3/IMAP account.',
			'TRAFFIC' => 'Wordt vervangen door aan klant toegewezen dataverkeer.',
			'TRAFFICUSED' => 'Wordt vervangen door het verbruikte dataverkeer.',
			'pop_success_alternative' => 'Welkomstmail voor nieuwe emailaccounts, gestuurd naar een alternatief emailadres',
			'EMAIL_PASSWORD' => 'Vervangen door het POP3/IMAP-wachtwoord.',
			'index_html' => 'Standaardpagina voor nieuwe mappen/domeinen',
			'SERVERNAME' => 'Wordt vervangen door de naam van de server.',
			'CUSTOMER' => 'Wordt vervangen door de inlognaam van de klant.',
			'ADMIN' => 'Wordt vervangen door de inlognaam van de beheerder.',
			'CUSTOMER_EMAIL' => 'Wordt vervangen door het e-mailadres van de klant.',
			'ADMIN_EMAIL' => 'Wordt vervangen door het e-mailadres van de beheerder.',
			'filetemplates' => 'Bestandssjablonen',
			'filecontent' => 'Bestandsinhoud',
			'new_database_by_customer' => 'Klantnotificatie wanneer een database is aangemaakt',
			'new_ftpaccount_by_customer' => 'Klantnotificatie wanneer een FTP-gebruiker is aangemaakt',
			'newdatabase' => 'Notificatie mails voor nieuwe databases',
			'newftpuser' => 'Notificatie mails voor nieuwe FTP-gebruikers',
			'CUST_NAME' => 'Naam klant',
			'DB_NAME' => 'Naam database',
			'DB_PASS' => 'Wachtwoord database',
			'DB_DESC' => 'Beschrijving database',
			'DB_SRV' => 'Database server',
			'PMA_URI' => 'URL naar phpMyAdmin (indien opgegeven)',
			'USR_NAME' => 'Gebruikersnaam FTP',
			'USR_PASS' => 'Wachtwoord FTP',
			'USR_PATH' => 'Map FTP (relatief aan docroot van klant)',
			'forgotpwd' => 'Notificatie mails voor opnieuw instellen wachtwoord',
			'password_reset' => 'Klantnotificatie voor opnieuw instellen wachtwoord',
		],
		'ipsandports' => [
			'ipsandports' => 'IP-adressen en Poorten',
			'add' => 'Maak IP/Poort',
			'edit' => 'Bewerk IP/Poort',
			'ipandport' => 'IP/Poort',
			'ip' => 'IP',
			'port' => 'Poort',
			'create_listen_statement' => '\'Listen\'-regel genereren',
			'create_namevirtualhost_statement' => '\'NameVirtualHost\'-regel genereren',
			'create_vhostcontainer' => 'vHost-Container genereren',
			'create_vhostcontainer_servername_statement' => '\'ServerName\'-regel vHost-Container genereren',
			'enable_ssl' => 'Is dit een SSL-poort?',
			'ssl_cert_file' => 'Pad naar SSL-certificaat',
			'webserverdefaultconfig' => 'Standaarconfiguratie webserver',
			'webserverdomainconfig' => 'Domeinconfiguratie webserver',
			'webserverssldomainconfig' => 'SSL-configuratie webserver',
			'ssl_key_file' => 'Pad naar SSL keyfile',
			'ssl_ca_file' => 'Pad naar SSL CA certificaat',
			'default_vhostconf_domain' => 'Standaard VHost-instellingen voor iedere domeincontainer',
			'docroot' => [
				'title' => 'Aangepaste docroot (leeg = verwijzing naar Froxlor)',
				'description' => 'U kunt voor deze IP/poortcombinatie een aangepaste document-root opgeven.<br /><strong>LET OP:</strong> Pas op wat u hier neerzet!',
			],
		],
		'memorylimitdisabled' => 'Gedeactiveerd',
		'valuemandatory' => 'Deze waarde is verplicht',
		'valuemandatorycompany' => 'De waarde "naam" en "voornaam" of "bedrijf" moet ingevoerd worden',
		'phpversion' => 'PHP-Versie',
		'phpmemorylimit' => 'PHP-Geheugen-Limiet',
		'mysqlserverversion' => 'MySQL Server Versie',
		'mysqlclientversion' => 'MySQL Client Versie',
		'accountsettings' => 'Account-instellingen',
		'panelsettings' => 'Paneel-instellingen',
		'systemsettings' => 'Systeem-instellingen',
		'webserversettings' => 'Webserver-instellingen',
		'mailserversettings' => 'Mailserver-instellingen',
		'nameserversettings' => 'Nameserver-instellingen',
		'updatecounters' => 'Gebruikte bronnen herberekenen',
		'subcanemaildomain' => [
			'never' => 'Nooit',
			'choosableno' => 'Kiesbaar, standaard nee',
			'choosableyes' => 'Kiesbaar, standaard ja',
			'always' => 'Altijd',
		],
		'webalizersettings' => 'Instellingen voor Webalizer',
		'webalizer' => [
			'normal' => 'Normaal',
			'quiet' => 'Stil',
			'veryquiet' => 'Geen uitvoer',
		],
		'domain_nocustomeraddingavailable' => 'Het is niet mogelijk een domein toe te voegen. U dient tenminste een klant aan te maken.',
		'loggersettings' => 'Instellingen voor logs',
		'logger' => [
			'normal' => 'normaal',
			'paranoid' => 'paranoide',
		],
		'emaildomain' => 'Emaildomein',
		'email_only' => 'Alleen email?',
		'wwwserveralias' => 'Voeg een "www." ServerAlias toe',
		'subject' => 'Onderwerp',
		'recipient' => 'Ontvanger',
		'message' => 'Bericht schrijven',
		'text' => 'Bericht',
		'sslsettings' => 'Instellingen voor SSL',
		'dkimsettings' => 'Instellingen voor DomainKeys',
		'allips' => 'Alle IP\'s',
		'awstatssettings' => 'Instellingen voor AWstats',
		'domain_dns_settings' => 'DNS-instellingen voor domein',
		'activated' => 'Geactiveerd',
		'statisticsettings' => 'Instellingen voor statistieken',
		'or' => 'of',
		'sysload' => 'Systeembelasting',
		'noloadavailable' => 'niet beschikbaar',
		'nouptimeavailable' => 'niet beschikbaar',
		'nosubject' => '(Geen onderwerp)',
		'security_settings' => 'Beveiliging',
		'know_what_youre_doing' => 'Verander dit alleen wanneer u zeker weet wat u doet!',
		'show_version_login' => [
			'title' => 'Toon versie van Froxlor bij het inloggen',
			'description' => 'Toont de versie van Froxlor in de voettekst van de inlogpagina',
		],
		'show_version_footer' => [
			'title' => 'Toon versie van Froxlor in de voettekst',
			'description' => 'Toont de versie van Froxlor in de voettekst op de rest van de pagina\'s',
		],
		'froxlor_graphic' => [
			'title' => 'Kopgrafiek voor Froxlor',
			'description' => 'Afbeelding die getoond wordt in de kop',
		],
		'phpsettings' => [
			'title' => 'PHP Configuratie',
			'description' => 'Korte omschrijven',
			'actions' => 'Actie\'s',
			'activedomains' => 'Wordt gebruikt door domein(en)',
			'notused' => 'Configuratie niet in gebruik',
			'editsettings' => 'Instellingen voor PHP aanpassen',
			'addsettings' => 'Nieuwe instellingen voor PHP aanmaken',
			'viewsettings' => 'Instellingen voor PHP weergeven',
			'phpinisettings' => 'Instellingen in php.ini',
			'addnew' => 'Nieuwe instellingen aanmaken',
			'binary' => 'PHP Uitvoerbaar bestand',
			'file_extensions' => 'Bestandsextensies',
			'file_extensions_note' => '(zonder punt, gescheiden door spaties)',
		],
		'misc' => 'Diversen',
		'phpconfig' => [
			'template_replace_vars' => 'Variabelen die worden vervangen in de instellingen',
			'pear_dir' => 'Wordt vervangen door de globale pear-map.',
			'open_basedir_c' => 'Voegt een ; (puntkomma) toe om open_basedir in- of uit te schakelen',
			'open_basedir' => 'Wordt vervangen door de open_basedir-instellingen voor het domein.',
			'tmp_dir' => 'Wordt vervangen door de tijdelijke map voor dit domein',
			'open_basedir_global' => 'Wordt vervangen door de globale waarde van het pad dat wordt toegevoegd aan de open_basedir.',
			'customer_email' => 'Wordt vervangen door het e-mailadres van de klant van het domein.',
			'admin_email' => 'Wordt vervangen door het e-mailadres van de beheerder van het domein.',
			'domain' => 'Wordt vervangen door het domein.',
			'customer' => 'Wordt vervangen door de loginnaam van de eigenaar van het domein.',
			'admin' => 'Wordt vervangen door de loginnaam van de beheerder van het domein.',
		],
		'expert_settings' => 'Instellingen voor experts!',
		'mod_fcgid_starter' => [
			'title' => 'Aantal PHP-processen voor dit domein. (Leeg betekent standaardinstellingen.)',
		],
		'phpserversettings' => 'PHP Instellingen',
		'mod_fcgid_maxrequests' => [
			'title' => 'Maximaal aantal PHP verzoeken voor dit domein (leeg geldt als standaardwaarde)',
		],
		'spfsettings' => 'SPF-instellingen domein',
		'specialsettingsforsubdomains' => 'Speciale instellingen toepassen op alle subdomeinen (*.example.com)',
		'accountdata' => 'Accountgegevens',
		'contactdata' => 'Contactgegevens',
		'servicedata' => 'Ondersteuningsgegevens',
		'newerversionavailable' => 'Er is een nieuwe versie van Froxlor beschikbaar',
		'cron' => [
			'cronsettings' => 'Instellingen cron-taken',
			'add' => 'Cron-taak toevoegen',
		],
		'cronjob_edit' => 'Cron-taak aanpassen',
		'warning' => 'WAARSCHUWING - Let op!',
		'lastlogin_succ' => 'Laatste login',
		'ftpserver' => 'FTP Server',
		'ftpserversettings' => 'Instellingen FTP-server',
		'webserver_user' => 'Gebruikersnaam webserver',
		'webserver_group' => 'Groepnaam webserver',
		'perlenabled' => 'Perl ingeschakeld',
		'fcgid_settings' => 'FCGID',
		'mod_fcgid_user' => 'Lokale gebruiker voor FCGID (Froxlor vhost)',
		'mod_fcgid_group' => 'Lokale groep voor FCGID (Froxlor vhost)',
		'perl_settings' => 'Perl/CGI',
		'notgiven' => '[niet opgegeven]',
		'store_defaultindex' => 'Standaard indexbestand opslaan in map klant',
		'phpfpm_settings' => 'PHP-FPM',
	],
	'changepassword' => [
		'old_password' => 'Oud wachtwoord',
		'new_password' => 'Nieuw wachtwoord',
		'new_password_confirm' => 'Nieuw wachtwoord (bevestigen)',
		'new_password_ifnotempty' => 'Nieuw wachtwoord (leeg = niet veranderen)',
		'also_change_ftp' => ' wijzig ook het wachtwoord van het hoofd FTP account',
		'also_change_stats' => ' wijzig ook het wachtwoord van de statistieken',
	],
	'cron' => [
		'cronname' => 'naam cron-taak',
		'lastrun' => 'laatst uitgevoerd',
		'interval' => 'interval',
		'isactive' => 'actief',
		'description' => 'beschrijving',
		'changewarning' => 'Het aanpassen van de ze waarden kunnen van negatieve invloed zijn op het gedrag van Froxlor en haar geautomatiseerde taken.<br />Pas deze waarden alleen aan wanneer u *zeer zeker* bent van wat u doet.',
	],
	'crondesc' => [
		'cron_unknown_desc' => 'geen beschrijving opgegeven',
		'cron_tasks' => 'aanmaken configuratiebestanden',
		'cron_legacy' => 'oude cron-taak',
		'cron_traffic' => 'berekenen verkeersgegevens',
	],
	'cronjob' => [
		'cronjobsettings' => 'Instellingen cron-taak',
		'cronjobinterval' => 'Interval uitvoeren',
	],
	'cronjobs' => [
		'notyetrun' => 'Nog niet uitgevoerd',
	],
	'cronmgmt' => [
		'seconds' => 'seconden',
		'minutes' => 'minuten',
		'hours' => 'uren',
		'days' => 'days',
		'weeks' => 'weken',
		'months' => 'maanden',
	],
	'customer' => [
		'name' => 'Naam',
		'firstname' => 'Voornaam',
		'company' => 'Bedrijfsnaam',
		'street' => 'Straat',
		'zipcode' => 'Postcode',
		'city' => 'Plaats',
		'phone' => 'Telefoonnummer',
		'fax' => 'Faxnummer',
		'email' => 'Email',
		'customernumber' => 'Klant ID',
		'diskspace' => 'Webruimte (MB)',
		'traffic' => 'Verkeer (GB)',
		'emails' => 'E-mail-Adressen',
		'subdomains' => 'Sub-Domein(en)',
		'domains' => 'Domein(en)',
		'title' => 'Titel',
		'country' => 'Land',
		'email_quota' => 'quotem voor e-mail',
		'email_imap' => 'E-mail IMAP',
		'email_pop3' => 'E-mail POP3',
		'mail_quota' => 'Mailquotum',
		'sendinfomail' => 'Stuur gegevens naar mij via e-mail',
	],
	'dns' => [
		'destinationip' => 'IP domein',
		'standardip' => 'Standaard server IP',
		'a_record' => 'A-record (IPv6 optioneel)',
		'cname_record' => 'CNAME-record',
		'mxrecords' => 'MX-records',
		'standardmx' => 'Standaard server MX-record',
		'mxconfig' => 'Aangepaste MX-records',
		'priority10' => 'Prioriteit 10',
		'priority20' => 'Prioriteit 20',
		'txtrecords' => 'TXT-records',
		'txtexample' => 'Voorbeeld (SPF-regel):<br />v=spf1 ip4:xxx.xxx.xx.0/23 -all',
	],
	'domain' => [
		'openbasedirpath' => 'OpenBasedir-pad',
		'docroot' => 'Pad van bovenstaand veld',
		'homedir' => 'Home directory',
	],
	'domains' => [
		'description' => 'Hier kunt u nieuwe (sub-) domeinen maken en de paden aanpassen.<br />Het systeem heeft een paar minuten nodig om de wijzigingen door te voeren na iedere varandering.',
		'domainsettings' => 'Domein instellingen',
		'domainname' => 'Domeinnaam',
		'subdomain_add' => 'Maak subdomein',
		'subdomain_edit' => 'Bewerk (sub)domein',
		'wildcarddomain' => 'Maak als wildcarddomein?',
		'aliasdomain' => 'Alias voor domein',
		'noaliasdomain' => 'Geen alias domein',
		'hasaliasdomains' => 'Heeft alias domein(en)',
		'statstics' => 'Gebruiksstatistieken',
		'isassigneddomain' => 'Is toegewezen domein',
		'add_date' => 'Toegevoegd aan Froxlor',
		'registration_date' => 'Toegevoegd aan register',
		'topleveldomain' => 'Top-Level-Domein',
		'associated_with_domain' => 'Toegekend',
		'aliasdomains' => 'Alternatieve domeinnamen',
		'redirectifpathisurl' => 'Doorverwijzingscode (standaard: leegt)',
		'redirectifpathisurlinfo' => 'U dient deze alleen op te geven indien u een URL als pad hebt opgegeven',
	],
	'emails' => [
		'description' => 'Hier kunt u e-mail adressen maken en wijzigen.<br />Een account is net als een brievenbus voor uw huis. Als iemand u mail stuurt wordt dit op uw account bezorgd.<br /><br />Om uw emails te downloaden moet u het volgende instellen in uw mailprogramma: (De <i>schuingedrukte</i> gegevens moeten gewijzigd worden in wat u ingegeven heeft!)<br />Servernaam: <b><i>Domeinnaam</i></b><br />Gebruikersnaam: <b><i>Account naam / E-mailadres</i></b><br />Wachtwoord: <b><i>het door u ingegeven wachtwoord</i></b>',
		'emailaddress' => 'E-mailadres',
		'emails_add' => 'Maak nieuw e-mailadres',
		'emails_edit' => 'Bewerk e-mailadres',
		'catchall' => 'Catchall',
		'iscatchall' => 'Definieer als catchall-adres?',
		'account_add' => 'Maak nieuw account',
		'account_delete' => 'Verwijder account',
		'from' => 'Van',
		'to' => 'Aan',
		'forwarder_add' => 'Maak forwarder',
		'alternative_emailaddress' => 'Alternatief emailadres',
		'quota' => 'Quotum',
		'noquota' => 'Geen quotum',
		'updatequota' => 'Quotum aanpassen',
		'quota_edit' => 'E-mailquotum aanpassen',
		'noemaildomainaddedyet' => 'U hebt nog geen (email-)domein gekoppeld aan uw account.',
	],
	'error' => [
		'error' => 'Fout',
		'directorymustexist' => 'De map %s bestaat niet. Maak hem eerst aan met uw FTP client.',
		'filemustexist' => 'Het bestand %s bestaat niet.',
		'allresourcesused' => 'U heeft al uw resources al gebruikt.',
		'domains_cantdeletemaindomain' => 'U kunt een domein dat gebruikt wordt als email-domein niet verwijderen.',
		'domains_canteditdomain' => 'U kunt dit domein niet aanpassen. Dit is door de admin onbruikbaar gemaakt.',
		'domains_cantdeletedomainwithemail' => 'U kunt een domein dat gebruikt wordt als email-domein niet verwijderen. Verwijder eerst alle e-mail adressen.',
		'firstdeleteallsubdomains' => 'U moet eerst alle subdomeinen verwijderen voor u een wildcard domein kunt maken.',
		'youhavealreadyacatchallforthisdomain' => 'U heeft al een catchall voor dit domein aangemaakt.',
		'ftp_cantdeletemainaccount' => 'U kunt uw hoofd FTP account niet verwijderen',
		'login' => 'De door u ingegeven gebruikersnaam en wachtwoord zijn verkeerd. Probeer opnieuw!',
		'login_blocked' => 'Dit account is inactief vanwege teveel login fouten. <br />Probeer het nog eens over %s seconden.',
		'notallreqfieldsorerrors' => 'U heeft niet alle velden goed, of helemaal niet ingevuld.',
		'oldpasswordnotcorrect' => 'Het oude wachtwoord is niet correct.',
		'youcantallocatemorethanyouhave' => 'U kunt niet meer resources gebruiken dan die u bezit.',
		'mustbeurl' => 'U heeft geen goed of compleet URL ingegeven (bijv. http://eenserver.com/error404.htm)',
		'invalidpath' => 'U heeft geen goed URL ingegeven (misschien een probleem met dirlisting?)',
		'stringisempty' => 'Geen waarde in invoerveld',
		'stringiswrong' => 'Verkeerde waarde in invoerveld',
		'newpasswordconfirmerror' => 'Het nieuwe wachtwoord en de bevestiging zijn niet gelijk',
		'loginnameexists' => 'Loginnaam %s bestaat al',
		'emailiswrong' => 'E-mailadres %s bevat illegale karakters of is niet compleet',
		'loginnameiswrong' => 'Loginnaam %s bevat illegale karakters',
		'userpathcombinationdupe' => 'Combinatie van Gebruikersnaam en Pad bestaat reeds',
		'patherror' => 'Generale Fou! Pad kan niet leeg zijn',
		'errordocpathdupe' => 'Optie voor pad %s bestaat reeds',
		'adduserfirst' => 'Maak klant eerst aan, aub',
		'domainalreadyexists' => 'Het domein %s is al aan een klant toegewezen',
		'nolanguageselect' => 'Geen taal geselecteerd.',
		'nosubjectcreate' => 'U moet een onderwerp ingeven voor dit e-mail sjabloon.',
		'nomailbodycreate' => 'U moet een tekst ingeven voor dit e-mail sjabloon.',
		'templatenotfound' => 'Sjabloon niet gevonden.',
		'alltemplatesdefined' => 'U kunt niet meer sjablonen definiëren, alle talen worden al ondersteund.',
		'wwwnotallowed' => 'www is niet toegestaan voor subdomeinen.',
		'subdomainiswrong' => 'Het subdomein %s bevat illegale karakters.',
		'domaincantbeempty' => 'De domeinnaam kan niet leeg zijn.',
		'domainexistalready' => 'Het domein %s bestaat reeds.',
		'domainisaliasorothercustomer' => 'Het geselecteerde alias domein verwijst naar zichzelf of is van een andere gebruiker.',
		'emailexistalready' => 'Het e-mail adres %s bestaat reeds.',
		'maindomainnonexist' => 'Het hoofd-domein %s bestaat niet.',
		'destinationnonexist' => 'Maak uw forwarder in het veld \'Destination\' alstublieft.',
		'destinationalreadyexistasmail' => 'De forwarder naar %s bestaat reeds als actief e-mail adres.',
		'destinationalreadyexist' => 'U heeft al een forwarder die verwijst naar %s .',
		'destinationiswrong' => 'De forwarder naar %s bevat illegale karakter(s) of is niet compleet.',
		'ipstillhasdomains' => 'De IP/Port combinatie die u verwijderen wilt heeft nog domeinen toegewezen, wijs deze opnieuw to aan andere IP/Poort combinaties voordat u deze IP/Poort combinatie verwijderd.',
		'cantdeletedefaultip' => 'U kunt de standaard reseller IP/Poort combinatie niet verwijderen, maak eerst een andere IP/Port combinatie standaard voor reseller voor dat u deze IP/Port combinatie verwijderd.',
		'cantdeletesystemip' => 'U kunt het laatste IP/Poort combinatie van het systeem niet verwijderen, maak eerste een andere IP/Port combinatie aan voor het systeem of wijzig het IP-adres van het systeem.',
		'myipaddress' => '\'IP\'',
		'myport' => '\'Poort\'',
		'myipdefault' => 'U moet een IP/Poort combinatie selecteren die standaard moet worden.',
		'myipnotdouble' => 'Deze IP/Poort combinatie bestaat reeds.',
		'cantchangesystemip' => 'U kunt het laatste system IP niet wijzigen, maak eerst een nieuwe IP/Poort combinatie aan of wijzig het ip-adres van het systeem.',
		'sessiontimeoutiswrong' => 'Alleen numerieke "Session Timeout" zijn toegestaan.',
		'maxloginattemptsiswrong' => 'Alleen numerieke "Maximaal aantal inlogpogingen" zijn toegestaan.',
		'deactivatetimiswrong' => 'Alleen numerieke "Deactiveringstijd" zijn toegestaan.',
		'accountprefixiswrong' => 'Het "Klant voorvoegsel" is verkeerd.',
		'mysqlprefixiswrong' => 'Het "SQL voorvoegsel" is verkeerd.',
		'ftpprefixiswrong' => 'Het "FTP voorvoegsel" is verkeerd.',
		'ipiswrong' => 'Het "IP-Adres" is verkeerd. Alleen een geldig ip-adres is toegestaan.',
		'vmailuidiswrong' => 'Het "Mails-uid" is verkeerd. Alleen een numeriek UID is toegestaan.',
		'vmailgidiswrong' => 'Het "Mails-gid" is verkeerd. Alleen een numeriek GID is toegestaan.',
		'adminmailiswrong' => 'Het "Afzender-adres" is verkeerd. Alleen geldige e-mail adressen zijn toegestaan.',
		'pagingiswrong' => 'Het aantal "Vermeldingen per pagina" is verkeerd. Alleen numerieke karakters zijn toegestaan.',
		'phpmyadminiswrong' => 'De phpMyAdmin-link is niet een geldige link.',
		'webmailiswrong' => 'De WebMail-link is niet een geldige link.',
		'webftpiswrong' => 'De WebFTP-link is niet een geldige link.',
		'stringformaterror' => 'De waarde voor het veld "%s" is niet in het verwachte formaat.',
		'loginnameissystemaccount' => 'U kunt geen accounts aanmaken die gelijk zijn aan systeem accounts (bijvoorbeeld beginnend met "%s"). Kies een andere accountnaam aub.',
		'youcantdeleteyourself' => 'U kunt uw eigen account, omwille van veiligheidsredenen, niet verwijderen.',
		'youcanteditallfieldsofyourself' => 'Opmerking: U kunt, om veiligheidsredenen, niet alle velden van uw account aanpassen.',
		'documentrootexists' => 'De map "%s" voor deze klant bestaat reeds. Verwijder deze map alvorens het account aan te maken.',
		'formtokencompromised' => 'Het verzoek lijkt te zijn gecompromitteerd. U bent veiligheidshalve uitgelogd.',
		'logerror' => 'Log-Fout: %s',
		'nomessagetosend' => 'U hebt geen bericht opgegeven.',
		'norecipientsgiven' => 'U hebt geen ontvanger opgegeven',
		'errorsendingmail' => 'Het versturen van het bericht naar "%s" is mislukt',
		'cannotreaddir' => 'De map "%s" kan niet gelezen worden',
		'invalidip' => '%s is een ongeldig IP-adres',
		'invalidmysqlhost' => 'Ongeldig adres voor MySQL-host: %s',
		'cannotuseawstatsandwebalizeratonetime' => 'U kunt Webalizer en AWstats niet tegelijkertijd gebruiken. Kies een van de twee.',
		'cannotwritetologfile' => 'Kan logbestand %s niet openen om naartoe te schrijven',
		'vmailquotawrong' => 'Het quotum dient een positief getal te zijn.',
		'allocatetoomuchquota' => 'U probeerde %s MB Quotum toe te kennen, maar u heeft niet voldoende over.',
		'missingfields' => 'Niet alle vereiste velden zijn ingevuld.',
		'accountnotexisting' => 'Het opgegeven e-mailaccount bestaat niet.',
		'nopermissionsorinvalidid' => 'U hebt geen toestemming om deze instellingen te wijzigen, of u hebt een ongeldig ID opgegeven.',
		'phpsettingidwrong' => 'Een configuratie voor PHP met dit ID bestaat niet',
		'descriptioninvalid' => 'De omschrijving is te kort, te lang of bevat ongeldige karakters.',
		'info' => 'Informatie',
		'filecontentnotset' => 'Het bestand mag niet leeg zijn!',
		'index_file_extension' => 'Het achtervoegsel dient tussen de 1 en 6 tekens lang te zijn. Het mag alleen tekens zal a-z, A-Z en 0-9 bevatten.',
		'customerdoesntexist' => 'De gekozen klant bestaat niet.',
		'admindoesntexist' => 'De gekozen beheerder bestaat niet.',
		'ipportdoesntexist' => 'De kozen combinatie poort/IP-adres bestaat niet.',
		'admin_domain_emailsystemhostname' => 'De naam van de server kan niet gebruikt worden als domein voor e-mail.',
		'usernamealreadyexists' => 'De gebruikersnaam %s is reeds in gebruik.',
		'errorwhensaving' => 'Fout tijdens opslaan veld %s',
		'hiddenfieldvaluechanged' => 'De waarde van het verborgen veld "%s" is gewijzigd tijdens het aanpassen van de instellingen.<br /><br />Dit is normaliter geen groot probleem maar heeft wel verhinderd dat de instellingen niet zijn opgeslagen.',
		'notrequiredpasswordlength' => 'Het opgegeven wachtwoord is te kort. Geef tenminste %s tekens op.',
		'overviewsettingoptionisnotavalidfield' => 'Woops, a field that should be displayed as an option in the settings-overview is not an excepted type. You can blame the developers for this. This should not happen!',
		'pathmaynotcontaincolon' => 'Het opgegeven pad mag geen dubbele punt (":") bevatten. Geef een correct pad op.',
		'exception' => '%s',
		'notrequiredpasswordcomplexity' => 'Er is niet voldaan aan de complexiteit voor het wachtwoord (regex: %s)',
		'stringerrordocumentnotvalidforlighty' => 'Een tekenreeks als ErrorDocument werkt niet in lighttpd. Geef een pad naar een bestand',
		'urlerrordocumentnotvalidforlighty' => 'Een tekenreeks als ErrorDocument werkt niet in lighttpd. Geef een pad naar een bestand',
		'intvaluetoolow' => 'Het opgegeven nummer is te laag (veld %s)',
		'intvaluetoohigh' => 'Het opgegeven nummer is te hoog (veld %s)',
		'phpfpmstillenabled' => 'PHP-FPM is op dit moment actief. Schakel dit eerst uit voordat u FCGID inschakelt',
		'fcgidstillenabled' => 'FCGID is op dit moment actief. Schakel dit eerst uit voordat u PHP-FPM inschakelt',
	],
	'extras' => [
		'description' => 'Hier kunt u wat extra instellingen doen zoals map beveiliging.<br />Het systeem heeft enkele minuten nodig om elke wijziging door te voeren.',
		'directoryprotection_add' => 'Map beveiliging toevoegen',
		'view_directory' => 'map inhoud laten zien',
		'pathoptions_add' => 'Pad opties toevoegen',
		'directory_browsing' => 'map inhoud browsen',
		'pathoptions_edit' => 'Pad opties bewerken',
		'errordocument404path' => 'URL naar Foutdocument 404',
		'errordocument403path' => 'URL naar Foutdocument 403',
		'errordocument500path' => 'URL naar Foutdocument 500',
		'errordocument401path' => 'URL naar Foutducument 401',
		'execute_perl' => 'perl/CGI uitvoeren',
		'htpasswdauthname' => 'Reden voor authenticatie (AuthName)',
		'directoryprotection_edit' => 'mapbeveiliging aanpassen',
	],
	'ftp' => [
		'description' => 'Hier kunt u nieuwe FTP accounts maken of bestaande accounts wijzigen.<br />De wijzigingen worden direct doorgevoerd en het account kan direct gebruikt worden.',
		'account_add' => 'Maak nieuw account',
		'account_edit' => 'FTP account aanpassen',
		'editpassdescription' => 'Nieuw wachtwoord of leeg voor het oude wachtwoord.',
	],
	'index' => [
		'customerdetails' => 'Klant Details',
		'accountdetails' => 'Account Details',
	],
	'logger' => [
		'date' => 'Datum',
		'type' => 'Type',
		'action' => 'Actie',
		'user' => 'Gebruiker',
		'truncate' => 'Log legen',
	],
	'login' => [
		'username' => 'Gebruikersnaam',
		'password' => 'Wachtwoord',
		'language' => 'Taal',
		'login' => 'Inloggen',
		'logout' => 'Uitloggen',
		'profile_lng' => 'Profiel taal',
		'forgotpwd' => 'Wachtwoord vergeten?',
		'presend' => 'Wachtwoord opnieuw instellen',
		'email' => 'E-mailadres',
		'remind' => 'Mijn wachtwoord opnieuw instellen',
		'usernotfound' => 'Gebruiker niet gevonden!',
		'backtologin' => 'Terug naar inlogpagina',
	],
	'mails' => [
		'pop_success' => [
			'mailbody' => 'Hallo,\\n\\nUw mail account {EMAIL}\\nis succesvol aangemaakt.\\n\\nDit is een automatisch verstuurde\\ne-mail, beantwoord deze niet AUB!\\n\\nMet vriendelijke groet, uw beheerder',
			'subject' => 'Mail account succesvol aangemaakt',
		],
		'createcustomer' => [
			'mailbody' => 'Hallo {FIRSTNAME} {NAME},\\n\\nhierbij uw account informatie:\\n\\nGebruikersnaam: {USERNAME}\\nWachtwoord: {PASSWORD}\\n\\nMet vriendelijke groet,\\nuw beheerder',
			'subject' => 'Account informatie',
		],
		'pop_success_alternative' => [
			'mailbody' => 'Hallo,\\n\\nuw mailaccount {EMAIL}\\nis met succes opgezet.\\nUw wachtwoord is {PASSWORD}.\\n\\nDit is een automatisch gegenereerde\\ne-mail, u kunt hierop niet antwoorden!\\n\\nMet vriendelijk groet, uw beheerder',
			'subject' => 'Mailaccount actief gemaakt',
		],
		'password_reset' => [
			'subject' => 'Wachtwoord opnieuw instellen',
			'mailbody' => 'Hallo {USERNAME},\\n\\nuw wachtwoord voor Froxlor is opnieuw ingesteld!\\nHet nieuwe wachtwoord is: {LINK}\\n\\nMet vriendelijke groet,\\nuw beheerder',
		],
		'new_database_by_customer' => [
			'subject' => '[Froxlor] Nieuwe database aangemaakt',
			'mailbody' => 'Geachte {CUST_NAME},

u hebt zojuist een nieuwe database aangemaakt. Hier zijn nogmaals de ingevoerde gegevens:

Naam database: {DB_NAME}
Wachtwoord: {DB_PASS}
Beschrijving: {DB_DESC}
Hostnaam database: {DB_SRV}
phpMyAdmin: {PMA_URI}
Met vriendelijke groet, uw beheerder',
		],
		'new_ftpaccount_by_customer' => [
			'subject' => 'Nieuwe FTP-gebruiker aangemaakt',
			'mailbody' => 'Geachte {CUST_NAME},

u hebt zojuist een nieuwe FTP-gebruiker aangemaakt. Hier is de opgegeven informatie:

Gebruikersnaam: {USR_NAME}
Wachtwoord: {USR_PASS}
Pad: {USR_PATH}

Met vriendelijke groet, uw beheerder',
		],
	],
	'menu' => [
		'message' => 'Berichten',
	],
	'menue' => [
		'main' => [
			'main' => 'Main',
			'changepassword' => 'Wijzig wachtwoord',
			'changelanguage' => 'Wijzig taal',
			'username' => 'Ingelogd als: ',
		],
		'email' => [
			'emails' => 'Adressen',
		],
		'domains' => [
			'domains' => 'Domeinen',
			'settings' => 'Instellingen',
		],
		'extras' => [
			'directoryprotection' => 'Map beveiliging',
			'pathoptions' => 'pad opties',
		],
		'traffic' => [
			'traffic' => 'Dataverkeer',
			'current' => 'Deze maand',
		],
		'phpsettings' => [
			'maintitle' => 'PHP Configuratie\'s',
		],
		'logger' => [
			'logger' => 'Systeemlog',
		],
	],
	'message' => [
		'norecipients' => 'Er is geen email verstuurd omdat er geen ontvangers in de database zijn',
	],
	'mysql' => [
		'databasename' => 'gebruiker/database naam',
		'databasedescription' => 'database omschrijving',
		'database_create' => 'Maak database',
		'description' => 'Hier kunt u MySQL-Databases maken en wijzigen.<br />De wijzigingen worden direct gemaakt en de database kan direkt gebruikt worden.<br />In het menu dat links staat vind u de tool phpMyAdmin welke u kunt gebruiken om uw database makkelijk te beheren.<br /><br />Om gebruikt te maken van uw database in uw eigen php programmas kunt u de volgende instellingen gebruiken: (De gegeven in <i>italics</i> moeten aangepast worden in wat u ingevoerd heeft!)<br />Hostnaam: <b><SQL_HOST></b><br />Gebruikersnaam: <b><i>Databasenaam</i></b><br />Wachtwoord: <b><i>het wachtwoord dat u gekozen heeft</i></b><br />Database: <b><i>Databasenaam</i></b>',
	],
	'panel' => [
		'edit' => 'bewerken',
		'delete' => 'verwijderen',
		'create' => 'nieuw',
		'save' => 'opslaan',
		'yes' => 'ja',
		'no' => 'nee',
		'emptyfornochanges' => 'leeg laten voor huidige instelling',
		'emptyfordefault' => 'leeg laten voor de standaard instellingen',
		'path' => 'Pad',
		'toggle' => 'In- of uitschalen',
		'next' => 'volgende',
		'dirsmissing' => 'De opgegeven map bestaat niet.',
		'urloverridespath' => 'URL (Vervangt path)',
		'pathorurl' => 'Pad of URL',
		'ascending' => 'oplopend',
		'descending' => 'aflopend',
		'search' => 'Zoeken',
		'used' => 'gebruikt',
		'translator' => 'Vertaler',
		'reset' => 'wijzigingen verwerpen',
		'pathDescription' => 'Indien de map niet bestaat wordt deze automatisch aangemaakt.<br /><br />Indien u wilt doorverwijzen naar een ander domein dient deze te beginnen met http:// of https://',
		'back' => 'Back',
		'reseller' => 'wederverkoper',
		'admin' => 'beheerder',
		'customer' => 'klant(en)',
		'send' => 'verzenden',
		'nosslipsavailable' => 'Er zijn op dit moment geen SSL IP/poorten beschikbaar',
		'backtooverview' => 'Terug naar overzicht',
		'dateformat' => 'YYYY-MM-DD',
		'dateformat_function' => 'Y-m-d',
		'timeformat_function' => 'H:i:s',
		'default' => 'Standaard',
		'never' => 'Nooit',
		'active' => 'Actief',
		'please_choose' => 'Maak een keuze',
		'allow_modifications' => 'Aanpassingen toestaan',
		'megabyte' => 'MegaByte',
		'not_supported' => 'Wordt niet ondersteund in: ',
		'view' => 'weergeven',
		'toomanydirs' => 'Teveel submappen. Er wordt teruggevallen op handmatige invoer.',
		'abort' => 'Afbreken',
		'not_activated' => 'niet actief',
		'off' => 'uit',
		'options' => 'opties',
		'neverloggedin' => 'Nog niet ingelogd',
		'descriptionerrordocument' => 'Kan een URL, pad naar een bestand of een tekenreeks zijn die is omsloten door " "<br />Laat leeg voor de standaardwaarde.',
		'unlock' => 'ontgrendelen',
	],
	'pwdreminder' => [
		'success' => 'Wachtwoord opnieuw ingesteld.<br />U ontvangt spoedig een e-mail met uw nieuwe wachtwoord.',
		'notallowed' => 'Het opnieuw instellen van wachtwoorden is uitgeschakeld',
	],
	'question' => [
		'question' => 'Beveiligingsvraag',
		'admin_customer_reallydelete' => 'Weet u zeker dat u de klant %s wilt verwijderen? Dit kan niet ongedaan worden gemaakt!',
		'admin_domain_reallydelete' => 'Weet u zeker dat u het domein %s wilt verwijderen?',
		'admin_domain_reallydisablesecuritysetting' => 'Weet u echt heel zeker dat deze beveiligingsinstellingen wilt deactiveren (OpenBasedir)?',
		'admin_admin_reallydelete' => 'Weet u zeker dat u de admin %s verwijderen wilt? Iedere klant en domein zal worden toegewezen aan de hoofd administrator.',
		'admin_template_reallydelete' => 'Weet u zeker dat u het sjabloon \'%s\' verwijderen wilt?',
		'domains_reallydelete' => 'Weet u zeker dat u het domein %s verwijderen wilt?',
		'email_reallydelete' => 'Weet u zeker dat u het e-mail adres %s verwijderen wilt?',
		'email_reallydelete_account' => 'Weet u zeker dat het e-mail account van %s verwijderen wilt?',
		'email_reallydelete_forwarder' => 'Weet u zeker dat u de forwarder %s verwijderen wilt?',
		'extras_reallydelete' => 'Weet u zeker dat u de map beveiliging voor de map %s verwijderen wilt?',
		'extras_reallydelete_pathoptions' => 'Weet u zeker dat u de pad-opties voor %s verwijderen wilt?',
		'ftp_reallydelete' => 'Weet u zeker dat u het FTP account %s verwijderen wilt?',
		'mysql_reallydelete' => 'Weet u zeker dat u de database %s verwijderen wilt? Dit kan niet ongedaan gemaakt worden!',
		'admin_configs_reallyrebuild' => 'Weet u zeker dat u de configuratie bestanden voor Apache en Bind opnieuw wilt opbouwen?',
		'admin_ip_reallydelete' => 'Weet u zeker dat u het IP adres %s verwijderen wilt?',
		'admin_domain_reallydocrootoutofcustomerroot' => 'Weet u zeker dat u de document root voor dit domein niet in de klant-root van de klant wil hebben?',
		'admin_counters_reallyupdate' => 'Weet u zeker dat u gebruikte bronnen wilt herberekenen?',
		'admin_cleartextmailpws_reallywipe' => 'Weet u zeker dat u alle onversleutelde wachtwoorden wilt verwijderen? Deze opdracht is niet terug te draaien!',
		'logger_reallytruncate' => 'Weet u zeker dat u de tabel "%s" wilt legen?',
		'admin_quotas_reallywipe' => 'Weet u zeker dat u alle quota wilt verwijderen? Dit is niet terug te draaien!',
		'admin_quotas_reallyenforce' => 'Weet u zeker dat u quota wilt afdwingen? Dit is niet terug te draaien!',
		'phpsetting_reallydelete' => 'Weet u zeker dat u deze instellingen wilt verwijderen? Alle domeinen die deze configuratie gebruiken zullen terugvallen op de standaardinstellingen.',
		'customer_reallyunlock' => 'Weet u zeker dat u klant %s? wilt ontgrendelen',
	],
	'serversettings' => [
		'session_timeout' => [
			'title' => 'Sessie Timeout',
			'description' => 'Hoe lang moet een gebruiker inactief zijn voor dat de sessie ongeldig wordt (seconden)?',
		],
		'accountprefix' => [
			'title' => 'Klant Voorvoegsel',
			'description' => 'Welk voorvoegsel moet een klant account hebben?',
		],
		'mysqlprefix' => [
			'title' => 'SQL Voorvoegsel',
			'description' => 'Welk voorvoegsel moet een mysql account hebben?',
		],
		'ftpprefix' => [
			'title' => 'FTP Voorvoegsel',
			'description' => 'Welk voorvoegsel dienen nieuwe FTP-accounts te krijgen?<br/><b>Indien u dit wijzigt, dient ook de query voor Quota in het configuratiebestand van de FTP-server aan te passen!</b> ',
		],
		'documentroot_prefix' => [
			'title' => 'Document map',
			'description' => 'Waar zullen alle gegeven opgeslagen worden?',
		],
		'logfiles_directory' => [
			'title' => 'Logfiles map',
			'description' => 'Waar zullen alle log-file opgeslagen worden?',
		],
		'ipaddress' => [
			'title' => 'IP-Adres',
			'description' => 'Wat is het IP-adres van deze server?',
		],
		'hostname' => [
			'title' => 'Hostnaam',
			'description' => 'Wat is de hostnaam van deze server?',
		],
		'apachereload_command' => [
			'title' => 'Apache reload commando',
			'description' => 'Wat is het commando op apache te herladen?',
		],
		'bindconf_directory' => [
			'title' => 'Bind configuratie map',
			'description' => 'Waar staan de bind configuratie bestanden?',
		],
		'bindreload_command' => [
			'title' => 'Bind reload commando',
			'description' => 'Wat is het command om bind te herladen?',
		],
		'vmail_uid' => [
			'title' => 'Mails-Uid',
			'description' => 'Welk UserID moeten de e-mails hebben?',
		],
		'vmail_gid' => [
			'title' => 'Mails-Gid',
			'description' => 'Welke GroupID moeten e-mails hebben?',
		],
		'vmail_homedir' => [
			'title' => 'Mails-Homedir',
			'description' => 'Waar moeten alle e-mail opgeslagen worden?',
		],
		'adminmail' => [
			'title' => 'Afzender',
			'description' => 'Wat is de afzender voor e-mail verstuurd vanuit het Panel?',
		],
		'phpmyadmin_url' => [
			'title' => 'phpMyAdmin URL',
			'description' => 'Wat is de URL die verwijst naar phpMyAdmin? (moet beginnen met http://)',
		],
		'webmail_url' => [
			'title' => 'WebMail URL',
			'description' => 'Wat is de URL die verwijst naar WebMail? (moet beginnen met http://)',
		],
		'webftp_url' => [
			'title' => 'WebFTP URL',
			'description' => 'Wat is de URL die verwijst naar WebFTP? (moet beginnen met http://)',
		],
		'language' => [
			'description' => 'Wat is uw standaard server taal?',
		],
		'maxloginattempts' => [
			'title' => 'Maximaal aantal inlog pogingen',
			'description' => 'Maximaal aantal inlog pogingen voor het account gedeactiveerd wordt.',
		],
		'deactivatetime' => [
			'title' => 'Deactiveringstijd',
			'description' => 'Tijd (in seconden) dat een account gedeactiveerd wordt na te veel inlogpogingen.',
		],
		'pathedit' => [
			'title' => 'Manier van Pad ingeven',
			'description' => 'Moet het pad geselecteerd worden met een \'dropdown\' menu of met een invoerveld?',
		],
		'paging' => [
			'title' => 'Vermeldingen per pagina',
			'description' => 'Hoeveel vermeldingen er getoond moeten worden per pagina? (0 = alles laten zien)',
		],
		'defaultip' => [
			'title' => 'Standaard IP/Poort',
			'description' => 'Wat is de standaard IP/Poort combinatie?',
		],
		'phpappendopenbasedir' => [
			'title' => 'Pad dat toegevoegd wordt aan OpenBasedir',
			'description' => 'Deze paden (gescheiden door dubbele punten) zullen worden toegevoegd aan het OpenBasedir-statement in iedere vhost-container.',
		],
		'natsorting' => [
			'title' => 'Gebruik een natuurlijke manier van sorteren',
			'description' => 'Lijsten worden gesorteerd zoals web1 -> web2 -> web11 in plaats van web1 -> web11 -> web2.',
		],
		'deactivateddocroot' => [
			'title' => 'Pad naar webinhoud voor gedeactiveerde gebruikers',
			'description' => 'Wanneer een gebruiker geactiveerd is, wordt dit pad gebruikt voor zijn/haar webinhoud.',
		],
		'mailpwcleartext' => [
			'title' => 'Sla het wachtwoord ook onversleuteld op in de database',
			'description' => 'Indien ingesteld op JA worden wachtwoorden in klare tekst opgeslagen in de database (zichtbaar voor iedereen die toegang heeft tot de tabel mail_users). Activeer dit alleen wanneer u gebruik gaat maken van SASL!',
			'removelink' => 'Klik hier om alle onversleutelde wachtwoorden uit de database te verwijderen',
		],
		'ftpdomain' => [
			'title' => 'FTP accounts @domein',
			'description' => 'Kunnen klanten FTP-accounts in de vorm gebruiker@domein aanmaken?',
		],
		'mod_fcgid' => [
			'title' => 'PHP insluiten via mod_fcgid/suexec',
			'description' => 'Gebruik mod_fcgid/suexec/libnss_mysql om PHP uit te voeren onder het gebruikersaccount.<br/><b>Dit vereist een aangepaste configuratie van de webserver. Alle volgende optie\'s zijn alleen geldig wanneer deze module actief is.</b>',
			'configdir' => [
				'title' => 'Configuratiemap',
				'description' => 'Waar dienen alle configuratiebestanden voor FCGID te worden opgeslagen? Indien u geen aangepaste versie van SuExec gebruikt, zoals gebruikelijk is, dient dit pad onder /var/www/ te liggen',
			],
			'tmpdir' => [
				'title' => 'Map voor tijdelijke bestanden',
				'description' => 'Waar dienen de tijdelijke mappen te worden opgeslagen?',
			],
			'starter' => [
				'title' => 'Processen per domein',
				'description' => 'Hoeveel processen moeten gestart/toegestaan worden per domein? De waarde 0 wordt aangeraden, aangezien PHP zelf het aantal processen goed kan inschatten.',
			],
			'wrapper' => [
				'title' => 'Wrapper in vhosts',
				'description' => 'Hoe moet de wrapper ingesloten worden in vhosts?',
			],
			'peardir' => [
				'title' => 'Globale PEAR-mappen',
				'description' => 'Welke PEAR-mappen dienen te worden ingesloten in elke php.ini? Bij meerdere mappen dienen deze te worden gescheiden door dubbele punten.',
			],
			'maxrequests' => [
				'title' => 'Maximaal aantal verzoeken per domein',
				'description' => 'Toegestane aantal verzoeken per domein',
			],
			'defaultini' => 'Standaard PHP-configuratie voor nieuwe domeinen',
			'defaultini_ownvhost' => 'Standaard configuratie voor Froxlor-vHost',
		],
		'sendalternativemail' => [
			'title' => 'Gebruik alternatief emailadres',
			'description' => 'Stuur het wachtwoord naar een ander adres dan het adres dat opgegeven werd tijdens het aanmaken van het emailadres.',
		],
		'apacheconf_vhost' => [
			'title' => 'Bestands-/mapnaam voor vhost-configuratie webserver',
			'description' => 'Waar dient het vhost-configuratiebestand opgeslagen te worden? U kunt hier zowel een bestand (alle configuratie\'s in 1 bestand) of een map (apart bestand voor iedere configuratie) opgeven.',
		],
		'apacheconf_diroptions' => [
			'title' => 'Bestands-/mapnaam voor diroptions-configuratie webserver',
			'description' => 'Waar dient het diroptions-configuratiebestand opgeslagen te worden? U kunt hier zowel een bestand (alle configuratie\'s in 1 bestand) of een map (apart bestand voor iedere configuratie) opgeven.',
		],
		'apacheconf_htpasswddir' => [
			'title' => 'Mapnaam htpasswd-bestanden webserver',
			'description' => 'Waar dienen de htpasswd-bestanden, voor beveiligde toegang, opgeslagen te worden?',
		],
		'mysql_access_host' => [
			'title' => 'Toegangshosts voor MySQL',
			'description' => 'Een door komma\'s gescheiden lijst met hosts waarvandaan gebruikers verbinding mogen maken met de MySQL-server.',
		],
		'webalizer_quiet' => [
			'title' => 'Uitvoer Webalizer',
			'description' => 'Informatieniveau van Webalizer',
		],
		'logger' => [
			'enable' => 'Logs in-/uitgeschakeld',
			'severity' => 'Logniveau',
			'types' => [
				'title' => 'Log-type(s)',
				'description' => 'Om meerdere types te selecteren, houd u CTRL ingedrukt terwijl u selecteert.<br />Beschikbare types zijn: syslog, bestand, mysql',
			],
			'logfile' => 'Pad naar logfile, inclusief bestandsnaam',
			'logcron' => 'Cronjobs loggen',
			'logcronoption' => [
				'never' => 'Nooit',
				'once' => 'Eenmalig',
				'always' => 'Altijd',
			],
		],
		'ssl' => [
			'openssl_cnf' => 'Standaardinstellingen certificaat',
		],
		'default_vhostconf' => [
			'title' => 'Standaard vhost-instellingen',
			'description' => 'De inhoud van dit veld wordt rechtstreeks in de vhost-container geplaatst. N.B.: Deze code wordt niet op fouten gecontroleerd. In geval van fouten kan het zijn dat de webserver niet meer start!',
		],
		'decimal_places' => 'Aantal getallen achter de komma in uitvoer dataverkeer',
		'webalizer_enabled' => 'Webalizer activeren',
		'awstats_enabled' => 'AWstats activeren',
		'selfdns' => [
			'title' => 'Instellingen voor klantdomein',
		],
		'selfdnscustomer' => [
			'title' => 'Klanten toestaan de DNS-instellingen van het domein te wijzigen',
		],
		'unix_names' => [
			'title' => 'Gebruik gebruikersnamen die compatible zijn met UNIX',
			'description' => 'Staat het gebruik van <strong>-</strong> en <strong>_</strong> in gebruikersnaam toe, indien ingesteld op <strong>Nee</strong>',
		],
		'allow_password_reset' => [
			'title' => 'Klanten toestaan hun wachtwoord opnieuw in te stellen',
			'description' => 'Klanten kunnen hun wachtwoorden opnieuw instellen. Het nieuwe wachtwoord wordt hen per e-mail toegestuurd.',
		],
		'allow_password_reset_admin' => [
			'title' => 'Beheerders/wederverkopers toestaan hun wachtwoorden opnieuw in te stellen.',
			'description' => 'Beheerders/wederverkopers kunnen hun wachtwoorden opnieuw instellen. Het nieuwe wachtwoord wordt hen per e-mail toegestuurd.',
		],
		'mail_quota' => [
			'title' => 'Quotum voor mailbox',
			'description' => 'Het standaard quotum voor nieuwe mailboxen (MegaByte).',
		],
		'mail_quota_enabled' => [
			'title' => 'Gebruik mailbox-quota voor mailboxen',
			'description' => 'Activeert het gebruik van quota voor mailboxen. Standaard is <b>Nee</b>, aangezien dit verdere configuratie vereist.',
			'removelink' => 'Klik hier om alle quota van mailbox te verwijderen.',
			'enforcelink' => 'Klik hier om het standaard quotum af te dwingen voor alle accounts.',
		],
		'index_file_extension' => [
			'description' => 'Welk achtervoegsel moet gebruikt worden voor het indexbestand? Dit achtervoegsel wordt gebruikt wanneer een van de beheerders een eigen indexsjabloon heeft gemaakt.',
			'title' => 'Achtervoegsel van het indexbestand in nieuwe mappen voor klanten.',
		],
		'session_allow_multiple_login' => [
			'title' => 'Meerdere logins toestaan',
			'description' => 'Indien dit is ingeschakeld kan een klant meerdere malen tegelijkertijd inloggen.',
		],
		'panel_allow_domain_change_admin' => [
			'title' => 'Het verplaatsen van domeinen tussen beheerders toestaan',
			'description' => 'Indien actief, kunt u een domein toewijzen aan een andere beheerder.<br /><b>Let op:</b> Indien een klant niet is toegewezen aan de beheerder van het domein, kan de betreffende beheerde alle domeinen van deze klant zien!',
		],
		'panel_allow_domain_change_customer' => [
			'title' => 'Het verplaatsen van domeinen tussen klanten toestaan',
			'description' => 'Indien actief, kunt u de klant van een domein veranderen.<br /><b>Let op:</b> Froxlor zal niet het pad aanpassen. Dit kan ervoor zorgen dat het domein onbruikbaar wordt!',
		],
		'cron' => [
			'debug' => [
				'title' => 'Foutopsporing cronscript',
				'description' => 'Activeer dit om het lockbestand te bewaren nadat de cron-taak is afgehandeld, zodat het gerbuikt kan worden voor het opsporen van fouten.<br /><b>Let op:</b>Het vastzetten van het lockbestand kan ervoor zorgen dat de volgende cron-taak niet naar behoren functioneert.',
			],
		],
		'specialsettingsforsubdomains' => [
			'description' => 'Indien "Ja" zullen deze aangepaste VHost-instellingen worden toegepast op alle subdomeinen.',
		],
		'panel_password_min_length' => [
			'title' => 'Minimumlengte wachtwoord',
			'description' => 'Hier kunt u een minimumlengte voor wachtwoorden opgeven. \'0\' betekent geen minimumlengte.',
		],
		'system_store_index_file_subs' => [
			'title' => 'Standaard indexbestand ook plaatsen in nieuwe submappen',
			'description' => 'Indien actief wordt dit bestand automatisch geplaatst in nieuw aangemaakte submappen (indien deze nog niet bestaat).',
		],
		'adminmail_return' => [
			'title' => 'Reply-To adres',
			'description' => 'Geef een e-mailadres dat gebruikt wordt als antwoord-aan adres voor mails die verzonden worden door het paneel.',
		],
		'adminmail_defname' => 'Panel e-mail sender name',
		'stdsubdomainhost' => [
			'title' => 'Standaarddomein voor klanten',
			'description' => 'Welke hostnaam dient gebruikt te worden voor standaard subdomeinen voor klanten. Indien leeg zal de naam van het systeem gebruikt worden.',
		],
		'awstats_path' => 'Pad naar \'awstats_buildstaticpages.pl\' van AWStats',
		'awstats_conf' => 'AWStats configuratiepad',
		'defaultttl' => 'Standaard TTL voor domeinen in seconden (standaard \'604800\' = 1 week)',
		'defaultwebsrverrhandler_enabled' => 'Standaard foutdocumenten voor alle klanten activeren',
		'defaultwebsrverrhandler_err401' => [
			'title' => 'Bestand/URL voor foutcode 401',
			'description' => '<div class="text-danger">Wordt niet ondersteund in: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err403' => [
			'title' => 'Bestand/URL voor foutcode 403',
			'description' => '<div class="text-danger">Wordt niet ondersteund in: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err404' => 'Bestand/URL voor foutcode 404',
		'defaultwebsrverrhandler_err500' => [
			'title' => 'Bestand/URL voor foutcode 500',
			'description' => '<div class="text-danger">Wordt niet ondersteund in: lighttpd</div>',
		],
		'ftpserver' => [
			'desc' => 'Indien PureFTPD geselecteerd is, worden .ftpquota bestanden dagelijks aangemaakt en/of bijgewerkt',
		],
		'customredirect_enabled' => [
			'title' => 'Klanten toestaan doorverwijzingen te maken',
			'description' => 'Klanten toestaan de HTTP-statuscode aan te passen die voor doorverwijzingen gebruikt worden',
		],
		'customredirect_default' => [
			'title' => 'Standaard doorverwijzing',
			'description' => 'Kies de standaard doorverwijzingscode indien de klant dit zelf niet gedaan heeft',
		],
		'mail_also_with_mxservers' => 'Maak mail-, imap-, pop3- en smtp-"A record" ook wanneer MX-Servers zijn ingesteld',
		'froxlordirectlyviahostname' => 'Froxlor is direct toegankelijk via hostnaam',
		'panel_password_regex' => [
			'title' => 'Reguliere expressie voor wachtwoorden',
			'description' => 'Hier kunt u een reguliere expressie opgeven voor de complexiteit van wachtwoorden.<br />Leeg betekent geen speciale complexiteit',
		],
		'perl_path' => [
			'title' => 'Pad naar Perl',
			'description' => 'Alleen relevant voor lighttpd. Standaard is /usr/bin/perl',
		],
		'mod_fcgid_ownvhost' => [
			'title' => 'FCGID inschakelen voor de VHost voor Froxlor',
			'description' => 'Indien ingeschakeld wordt Froxlor ook uitgevoerd onder een lokale gebruiker<br /><strong>Let op:</strong>Dit vereist handmatige configuratie, zie <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/fcgid/">FCGID - handbook</a>',
		],
		'perl' => [
			'suexecworkaround' => [
				'title' => 'Om SuExec heenwerken (Geldt alleen voor Apache)',
				'description' => 'Schakel dit alleen in indien de documentmappen van klanten niet in het pad van Apache SuExec vallen.<br />Indien ingeschakeld zal Froxlor een symbolische link maken voor het pad waarvoor Perl actief is + /cgi-bin/.<br />Merk op dat Perl dan alleen werkt in de submap /cgi-bin/ en niet in de map zelf (zoals het werkt zonder deze oplossing!)',
			],
			'suexeccgipath' => [
				'title' => 'Pad naar symbolische links naar Perl-mappen van klanten',
				'description' => 'U dient dit alleen op te geven indien "Om SuExec heenwerken" actief is.<br />LET OP: Zorg ervoor dat deze map onder het pad van SuExec valt, anders is deze oplossing waardeloos',
			],
		],
		'awstats_awstatspath' => 'Pad naar AWStats \'awstats.pl\'',
		'awstats_icons' => [
			'title' => 'Pad naar iconen AWstats icons',
			'description' => 'bijvoorbeeld /usr/share/awstats/htdocs/icon/',
		],
		'login_domain_login' => 'Login met domeinen toestaan',
		'nginx_php_backend' => [
			'title' => 'Nginx PHP backend',
			'description' => 'dit is waar het PHP-proces luistert naar verzoeken van nginx, kan een unix socket van ip:poort combinatie zijn',
		],
		'phpreload_command' => [
			'title' => 'Commando voor het herladen van PHP',
			'description' => 'wordt gebruikt om de PHP backend opnieuw te laden, indien actief<br />Standaard: leeg',
		],
		'phpfpm' => 'php-fpm inschakelen',
		'phpfpm_settings' => [
			'configdir' => 'Configuratiemap van php-fpm',
			'reload' => 'Commando voor het herstarten van php-fpm',
			'pm' => 'Process manager control (pm)',
			'max_children' => [
				'title' => 'Het aantal subprocessen',
				'description' => 'Het aantal subprocessen dat gestart wordt indien PM is ingesteld op \'statisch\' en het maximum aantal subprocessen wanneer PM is ingesteld op \'dynamisch\'<br />Gelijk aan PHP_FCGI_CHILDREN',
			],
			'start_servers' => [
				'title' => 'Het aantal subprocessen bij het starten',
				'description' => 'Noot: Wordt alleen gebruikt indien PM is ingesteld op \'dynamisch\'',
			],
			'min_spare_servers' => [
				'title' => 'Het gewenste minimum aantal vrije subprocessen',
				'description' => 'Noot: Wordt alleen gebruikt indien PM is ingesteld op \'dynamisch\'<br />Noot: Verplicht wanneer PM ingesteld is op \'dynamisch\'',
			],
			'max_spare_servers' => [
				'title' => 'THet gewenste minimum aantal vrije subprocessen',
				'description' => 'Noot: Wordt alleen gebruikt indien PM is ingesteld op \'dynamisch\'<br />Noot: Verplicht wanneer PM ingesteld is op \'dynamisch\'',
			],
			'max_requests' => [
				'title' => 'Verzoeken voor subproces voordat het opnieuw gestart wordt',
				'description' => 'Voor het eindeloos verwerken kunt u deze waarde instellen op \'0\'. Gelijk aan PHP_FCGI_MAX_REQUESTS.',
			],
		],
	],
	'spf' => [
		'use_spf' => 'SPF voor domeinen activeren?',
		'spf_entry' => 'SPF regel voor alle domeinen',
	],
	'success' => [
		'messages_success' => 'Bericht verzonden naar ontvangers %s',
		'success' => 'Informatie',
		'clickheretocontinue' => 'Klik hier om verder te gaan',
		'settingssaved' => 'De instellingen zijn opgeslagen.',
	],
	'tasks' => [
		'outstanding_tasks' => 'Uitstaande cron-taken',
		'REBUILD_VHOST' => 'Bezig met opnieuw opbouwen van de configuratie van de webserver',
		'CREATE_HOME' => 'Klant met naam %s wordt toegevoegd',
		'REBUILD_DNS' => 'Opnieuw opbouwen bind-configuratie',
		'CREATE_FTP' => 'Map aanmaken voor nieuwe FTP-gebruiker',
		'DELETE_CUSTOMER_FILES' => 'Verwijderen klantbestanden van %s',
		'noneoutstanding' => 'Er zijn op dit moment geen uitstaande taken voor Froxlor',
	],
	'traffic' => [
		'month' => 'Maand',
		'day' => 'Dag',
		'months' => [
			1 => 'Januari',
			2 => 'Februari',
			3 => 'Maart',
			4 => 'April',
			5 => 'Mei',
			6 => 'Juni',
			7 => 'Juli',
			8 => 'Augustus',
			9 => 'September',
			10 => 'Oktober',
			11 => 'November',
			12 => 'December',
		],
		'mb' => 'Datavekeer (MB)',
		'distribution' => '<font color="#019522">FTP</font> | <font color="#0000FF">HTTP</font> | <font color="#800000">Mail</font>',
		'sumhttp' => 'Samenvatting HTTP-verkeer in',
		'sumftp' => 'Samenvatting FTP-verkeer in',
		'summail' => 'Samenvatting Mail-verkeer in',
	],
	'translator' => 'Sander Klein/Frits Letteboer',
	'update' => [
		'updateinprogress_onlyadmincanlogin' => 'Een nieuwere versie van Froxlor is geinstalleerd maar is nog niet geconfigureerd.<br />Alleen de beheerder kan inloggen en de update voltooien.',
		'update' => 'Froxlor Update',
		'proceed' => 'Verdergaan',
		'update_information' => [
			'part_a' => 'De bestanden van Froxlor zijn bijgewerkt naar versie <strong>%s</strong>. De geinstalleerde versie is <strong>%s</strong>.',
			'part_b' => '<br /><br />Klanten kunnen niet inloggen totdat de update voltooid is.<br /><strong>Verdergaan?</strong>',
		],
		'noupdatesavail' => '<strong>U gebruikt reeds de meest recente versie van Froxlor.</strong>',
	],
];
