<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can also view it online at
 * https://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  the authors
 * @author     Froxlor team <team@froxlor.org>
 * @license    https://files.froxlor.org/misc/COPYING.txt GPLv2
 */

return [
	'languages' => [
		'cz' => 'Czech',
		'de' => 'German',
		'en' => 'English',
		'fr' => 'French',
		'it' => 'Italia',
		'nl' => 'Dutch',
		'pt' => 'Portuguese',
		'se' => 'Swedish',
	],
	'2fa' => [
		'2fa' => '2FA options',
		'2fa_enabled' => 'Activate Two-factor authentication (2FA)',
		'2fa_removed' => '2FA removed successfully',
		'2fa_added' => '2FA activated successfully<br><a class="alert-link" href="%s?page=2fa">View 2FA details</a>',
		'2fa_add' => 'Activate 2FA',
		'2fa_delete' => 'Deactivate 2FA',
		'2fa_verify' => 'Verify code',
		'2fa_overview_desc' => 'Here you can activate a two-factor authentication for your account.<br><br>You can either use an authenticator-app (time-based one-time password / TOTP) or let froxlor send you an email to your account-address after each successful login with a one-time password.',
		'2fa_email_desc' => 'Your account is set up to use one-time passwords via e-mail. To deactivate, click on "Deactivate 2FA"',
		'2fa_ga_desc' => 'Your account is set up to use time-based one-time passwords via authenticator-app. Please scan the QR code below with your desired authenticator app to generate the codes. To deactivate, click on "Deactivate 2FA"',
	],
	'admin' => [
		'overview' => 'Overview',
		'ressourcedetails' => 'Used resources',
		'systemdetails' => 'System details',
		'froxlordetails' => 'Froxlor details',
		'installedversion' => 'Installed version',
		'latestversion' => 'Latest version',
		'lookfornewversion' => [
			'clickhere' => 'Search via webservice',
			'error' => 'Error while reading',
		],
		'resources' => 'Resources',
		'customer' => 'Customer',
		'customers' => 'Customers',
		'customers_list_desc' => 'Manage your customers',
		'customer_add' => 'Create customer',
		'customer_edit' => 'Edit customer',
		'username_default_msg' => 'Leave empty for autogenerated value',
		'domains' => 'Domains',
		'domain_add' => 'Create domain',
		'domain_edit' => 'Edit domain',
		'subdomainforemail' => 'Subdomains as email-domains',
		'admin' => 'Admin',
		'admins' => 'Admins',
		'admin_add' => 'Create admin',
		'admin_edit' => 'Edit admin',
		'customers_see_all' => 'Can access other admins/resellers resources?',
		'change_serversettings' => 'Can change server settings?',
		'server' => 'System',
		'serversettings' => 'Settings',
		'serversettings_desc' => 'Manage your froxlor system',
		'rebuildconf' => 'Rebuild config files',
		'stdsubdomain' => 'Standard subdomain',
		'stdsubdomain_add' => 'Create standard subdomain',
		'phpenabled' => 'PHP enabled',
		'deactivated' => 'Deactivated',
		'deactivated_user' => 'Deactivate user',
		'sendpassword' => 'Send password',
		'ownvhostsettings' => 'Own vHost-settings',
		'configfiles' => [
			'serverconfiguration' => 'Configuration',
			'overview' => 'Overview',
			'wizard' => 'Wizard',
			'distribution' => 'Distribution',
			'service' => 'Service',
			'daemon' => 'Daemon',
			'http' => 'Webserver (HTTP)',
			'dns' => 'Nameserver (DNS)',
			'mail' => 'Mailserver (IMAP/POP3)',
			'smtp' => 'Mailserver (SMTP)',
			'ftp' => 'FTP-server',
			'etc' => 'Others (System)',
			'choosedistribution' => '-- Choose a distribution --',
			'chooseservice' => '-- Choose a service --',
			'choosedaemon' => '-- Choose a daemon --',
			'statistics' => 'Statistics',
			'compactoverview' => 'Compact-overview',
			'legend' => '<h3>You are about to configure a service/daemon</h3>',
			'commands' => '<span class="text-danger">Commands:</span> These commands are to be executed line by line as root-user in a shell. It is safe to copy the whole block and paste it into the shell.',
			'files' => '<span class="text-danger">Config files:</span> The commands before the textfields should open an editor with the target file. Just copy and paste the contents into the editor and save the file.<br><span class="text-danger">Please note:</span> The MySQL-password has not been replaced for security reasons. Please replace "FROXLOR_MYSQL_PASSWORD" on your own or use the javascript form below to replace it on-site. If you forgot your MySQL-password you\'ll find it in "lib/userdata.inc.php"',
			'importexport' => 'Import/Export',
			'finishnote' => 'Parameter file generated successfully. Now run the following command as root:',
			'description' => 'Configure the system services',
			'minihowto' => 'On this page you can view the different configuration templates for each service, (re-)configure specific services if needed or export the current selection to a JSON file to use in the CLI scripts or on another server.<br><br><b>Note</b> that the services highlighted do not reflect your current setup but show requirements/recommendations from your current setting values.',
			'skipconfig' => 'Don\'t (re)configure',
			'recommendednote' => 'Recommended/required services based on current system settings',
			'selectrecommended' => 'Select recommended',
			'downloadselected' => 'Export selected',
		],
		'templates' => [
			'templates' => 'Email-templates',
			'template_add' => 'Add template',
			'template_fileadd' => 'Add file template',
			'template_edit' => 'Edit template',
			'action' => 'Action',
			'email' => 'Email & file templates',
			'subject' => 'Subject',
			'mailbody' => 'Mail body',
			'createcustomer' => 'Welcome mail for new customers',
			'pop_success' => 'Welcome mail for new email accounts',
			'template_replace_vars' => 'Variables to be replaced in the template:',
			'SALUTATION' => 'Replaced with a correct salutation (name or company)',
			'FIRSTNAME' => 'Replaced with the customer\'s first name.',
			'NAME' => 'Replaced with the customers name.',
			'COMPANY' => 'Replaces with the customer\'s company name',
			'USERNAME' => 'Replaced with the customer\'s account username.',
			'PASSWORD' => 'Replaced with the customer\'s account password.',
			'EMAIL' => 'Replaced with the address of the POP3/IMAP account.',
			'CUSTOMER_NO' => 'Replaces with the customer number',
			'TRAFFIC' => 'Replaced with the traffic, which was assigned to the customer.',
			'TRAFFICUSED' => 'Replaced with the traffic, which was exhausted by the customer.',
			'pop_success_alternative' => 'Welcome mail for new email accounts sent to alternative address',
			'EMAIL_PASSWORD' => 'Replaced with the POP3/IMAP account password.',
			'index_html' => 'index file for newly created customer directories',
			'SERVERNAME' => 'Replaced with the servername.',
			'CUSTOMER' => 'Replaced with the loginname of the customer.',
			'ADMIN' => 'Replaced with the loginname of the admin.',
			'CUSTOMER_EMAIL' => 'Replaced with the e-mail address of the customer.',
			'ADMIN_EMAIL' => 'Replaced with the e-mail address of the admin.',
			'filetemplates' => 'File templates',
			'filecontent' => 'File content',
			'new_database_by_customer' => 'Customer-notification when a database has been created',
			'new_ftpaccount_by_customer' => 'Customer-notification when a ftp-user has been created',
			'newdatabase' => 'Notification-mails for new databases',
			'newftpuser' => 'Notification-mails for new ftp-user',
			'CUST_NAME' => 'Customer name',
			'DB_NAME' => 'Database name',
			'DB_PASS' => 'Database password',
			'DB_DESC' => 'Database description',
			'DB_SRV' => 'Database server',
			'PMA_URI' => 'URL to phpMyAdmin (if given)',
			'USR_NAME' => 'FTP username',
			'USR_PASS' => 'FTP password',
			'USR_PATH' => 'FTP homedir (relative to customer-docroot)',
			'forgotpwd' => 'Notification-mails for password-reset',
			'password_reset' => 'Customer-notification for passwort-reset',
			'trafficmaxpercent' => 'Notification mail for customers when given maximum of percent of traffic is exhausted',
			'MAX_PERCENT' => 'Replaced with the diskusage/traffic limit for sending reports in percent.',
			'USAGE_PERCENT' => 'Replaced with the diskusage/traffic, which was exhausted by the customer in percent.',
			'diskmaxpercent' => 'Notification mail for customers when given maximum of percent of diskspace is exhausted',
			'DISKAVAILABLE' => 'Replaced with the diskusage, which was assigned to the customer.',
			'DISKUSED' => 'Replaced with the diskusage, which was exhausted by the customer.',
			'LINK' => 'Replaced with the customers password reset link.',
			'SERVER_HOSTNAME' => 'Replaces the system-hostname (URL to froxlor)',
			'SERVER_IP' => 'Replaces the default server ip-address',
			'SERVER_PORT' => 'Replaces the default server port',
			'DOMAINNAME' => 'Replaces the customers standard-subdomain (can be empty if none is generated)',
		],
		'webserver' => 'Webserver',
		'createzonefile' => 'Create dns zone for domain',
		'custombindzone' => 'Custom / unmanaged zone file',
		'bindzonewarning' => 'empty for defaults<br /><strong class="text-danger">ATTENTION:</strong> If you use a zonefile you will have to manage all required records for all sub-zones manually as well.',
		'ipsandports' => [
			'ipsandports' => 'IPs and Ports',
			'add' => 'Add IP/Port',
			'edit' => 'Edit IP/Port',
			'ipandport' => 'IP/Port',
			'ip' => 'IP',
			'ipnote' => '<div id="ipnote" class="invalid-feedback">Note: Although private ip addresses are allowed, some features like DNS might not behave correctly.<br>Only use private ip addresses if you are sure.</div>',
			'port' => 'Port',
			'create_listen_statement' => 'Create Listen statement',
			'create_namevirtualhost_statement' => 'Create NameVirtualHost statement',
			'create_vhostcontainer' => 'Create vHost-Container',
			'create_vhostcontainer_servername_statement' => 'Create ServerName statement in vHost-Container',
			'enable_ssl' => 'Is this an SSL Port?',
			'ssl_cert_file' => 'Path to the SSL Certificate',
			'webserverdefaultconfig' => 'Webserver default config',
			'webserverdomainconfig' => 'Webserver domain config',
			'webserverssldomainconfig' => 'Webserver SSL config',
			'ssl_key_file' => 'Path to the SSL Keyfile',
			'ssl_ca_file' => 'Path to the SSL CA certificate',
			'default_vhostconf_domain' => 'Default vHost-settings for every domain container',
			'ssl_cert_chainfile' => [
				'title' => 'Path to the SSL CertificateChainFile',
				'description' => 'Mostly CA_Bundle, or similar, you probably want to set this if you bought a SSL certificate.',
			],
			'docroot' => [
				'title' => 'Custom docroot (empty = point to Froxlor)',
				'description' => 'You can define a custom document-root (the destination for a request) for this ip/port combination here.<br /><strong>ATTENTION:</strong> Please be careful with what you enter here!',
			],
			'ssl_paste_description' => 'Paste your complete certificate content in the textbox',
			'ssl_cert_file_content' => 'Content of the ssl certificate',
			'ssl_key_file_content' => 'Content of the ssl (private-) key file',
			'ssl_ca_file_content' => 'Content of the ssl CA file (optional)',
			'ssl_ca_file_content_desc' => '<br /><br />Client authentication, set this only if you know what it is.',
			'ssl_cert_chainfile_content' => 'Content of the certificate chain file (optional)',
			'ssl_cert_chainfile_content_desc' => '<br /><br />Mostly CA_Bundle, or similar, you probably want to set this if you bought a SSL certificate.',
			'ssl_default_vhostconf_domain' => 'Default SSL vHost-settings for every domain container',
		],
		'memorylimitdisabled' => 'Disabled',
		'valuemandatory' => 'This value is mandatory',
		'valuemandatorycompany' => 'Either "name" and "firstname" or "company" must be filled',
		'serversoftware' => 'Serversoftware',
		'phpversion' => 'PHP-Version',
		'mysqlserverversion' => 'MySQL server version',
		'webserverinterface' => 'Webserver interface',
		'accountsettings' => 'Account settings',
		'panelsettings' => 'Panel settings',
		'systemsettings' => 'System settings',
		'webserversettings' => 'Webserver settings',
		'mailserversettings' => 'Mailserver settings',
		'nameserversettings' => 'Nameserver settings',
		'updatecounters' => 'Recalculate resource usage',
		'subcanemaildomain' => [
			'never' => 'Never',
			'choosableno' => 'Choosable, default no',
			'choosableyes' => 'Choosable, default yes',
			'always' => 'Always',
		],
		'wipecleartextmailpwd' => 'Clear plaintext passwords',
		'webalizersettings' => 'Webalizer settings',
		'webalizer' => [
			'normal' => 'Normal',
			'quiet' => 'Quiet',
			'veryquiet' => 'No output',
		],
		'domain_nocustomeraddingavailable' => 'It\'s not possible to add a domain currently. You first need to add at least one customer.',
		'loggersettings' => 'Log settings',
		'logger' => [
			'normal' => 'normal',
			'paranoid' => 'paranoid',
		],
		'emaildomain' => 'Emaildomain',
		'email_only' => 'Only email?',
		'wwwserveralias' => 'Add a "www." ServerAlias',
		'subject' => 'Subject',
		'recipient' => 'Recipient',
		'message' => 'Write a Message',
		'text' => 'Message',
		'sslsettings' => 'SSL settings',
		'specialsettings_replacements' => 'You can use the following variables:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (if applicable)<br/>',
		'dkimsettings' => 'DomainKey settings',
		'caneditphpsettings' => 'Can change php-related domain settings?',
		'allips' => 'All IP\'s',
		'awstatssettings' => 'AWstats settings',
		'domain_dns_settings' => 'Domain dns settings',
		'activated' => 'Activated',
		'statisticsettings' => 'Statistic settings',
		'or' => 'or',
		'sysload' => 'System load',
		'noloadavailable' => 'not available',
		'nouptimeavailable' => 'not available',
		'nosubject' => '(No Subject)',
		'security_settings' => 'Security Options',
		'know_what_youre_doing' => 'Change only, if you know what you\'re doing!',
		'show_version_login' => [
			'title' => 'Show Froxlor version on login',
			'description' => 'Show the Froxlor version in the footer on the login page',
		],
		'show_version_footer' => [
			'title' => 'Show Froxlor version in footer',
			'description' => 'Show the Froxlor version in the footer on the rest of the pages',
		],
		'froxlor_graphic' => [
			'title' => 'Header graphic for Froxlor',
			'description' => 'What graphic should be shown in the header',
		],
		'phpsettings' => [
			'title' => 'PHP Configuration',
			'description' => 'Short description',
			'actions' => 'Actions',
			'activedomains' => 'In use for domain(s)',
			'notused' => 'Configuration not in use',
			'editsettings' => 'Change PHP settings',
			'addsettings' => 'Create new PHP settings',
			'viewsettings' => 'View PHP settings',
			'phpinisettings' => 'php.ini settings',
			'addnew' => 'Create new PHP configuration',
			'binary' => 'PHP Binary',
			'fpmdesc' => 'PHP-FPM config',
			'file_extensions' => 'File extensions',
			'file_extensions_note' => '(without dot, separated by spaces)',
			'enable_slowlog' => 'Enable slowlog (per domain)',
			'request_terminate_timeout' => 'Request terminate-timeout',
			'request_slowlog_timeout' => 'Request slowlog-timeout',
			'activephpconfigs' => 'In use for php-config(s)',
			'pass_authorizationheader' => 'Add "-pass-header Authorization" / "CGIPassAuth On" to vhosts',
		],
		'misc' => 'Miscellaneous',
		'fpmsettings' => [
			'addnew' => 'Create new PHP version',
			'edit' => 'Change PHP version'
		],
		'phpconfig' => [
			'template_replace_vars' => 'Variables that will be replaced in the configs',
			'pear_dir' => 'Will be replaced with the global setting for the pear directory.',
			'open_basedir_c' => 'Will insert a ; (semicolon) to comment-out/disable open_basedir when set',
			'open_basedir' => 'Will be replaced with the open_basedir setting of the domain.',
			'tmp_dir' => 'Will be replaced with the temporary directory of the domain.',
			'open_basedir_global' => 'Will be replaced with the global value of the path which will be attached to the open_basedir (see webserver settings).',
			'customer_email' => 'Will be replaced with the e-mail address of the customer who owns this domain.',
			'admin_email' => 'Will be replaced with e-mail address of the admin who owns this domain.',
			'domain' => 'Will be replaced with the domain.',
			'customer' => 'Will be replaced with the loginname of the customer who owns this domain.',
			'admin' => 'Will be replaced with the loginname of the admin who owns this domain.',
			'docroot' => 'Will be replaced with the domain\'s document-root.',
			'homedir' => 'Will be replaced with the customer\'s home-directory.',
		],
		'expert_settings' => 'Expert settings!',
		'mod_fcgid_starter' => [
			'title' => 'PHP Processes for this domain (empty for default value)',
		],
		'phpserversettings' => 'PHP Settings',
		'mod_fcgid_maxrequests' => [
			'title' => 'Maximum php requests for this domain (empty for default value)',
		],
		'spfsettings' => 'Domain SPF settings',
		'specialsettingsforsubdomains' => 'Apply specialsettings to all subdomains (*.example.com)',
		'accountdata' => 'Account Data',
		'contactdata' => 'Contact Data',
		'servicedata' => 'Service Data',
		'newerversionavailable' => 'There is a newer version of Froxlor available.',
		'newerversiondetails' => 'Update to version <b>%s</b> now?<br/>(Your current version is: %s)',
		'extractdownloadedzip' => 'Extract downloaded archive "%s"?',
		'cron' => [
			'cronsettings' => 'Cronjob settings',
			'add' => 'Add cronjob',
		],
		'cronjob_edit' => 'Edit cronjob',
		'warning' => 'WARNING - Please note!',
		'lastlogin_succ' => 'Last login',
		'ftpserver' => 'FTP Server',
		'ftpserversettings' => 'FTP Server settings',
		'webserver_user' => 'Webserver user-name',
		'webserver_group' => 'Webserver group-name',
		'perlenabled' => 'Perl enabled',
		'fcgid_settings' => 'FCGID',
		'mod_fcgid_user' => 'Local user to use for FCGID (Froxlor vHost)',
		'mod_fcgid_group' => 'Local group to use for FCGID (Froxlor vHost)',
		'perl_settings' => 'Perl/CGI',
		'notgiven' => '[not given]',
		'store_defaultindex' => 'Store default index-file to customers docroot',
		'phpfpm_settings' => 'PHP-FPM',
		'traffic' => 'Traffic',
		'traffic_sub' => 'Details on traffic usage',
		'domaintraffic' => 'Domains',
		'customertraffic' => 'Customers',
		'assignedmax' => 'Assigned / Max',
		'usedmax' => 'Used / Max',
		'used' => 'Used',
		'speciallogwarning' => '<div id="speciallogfilenote" class="invalid-feedback">WARNING: By changing this setting you will lose all your old statistics for this domain.</div>',
		'speciallogfile' => [
			'title' => 'Separate logfile',
			'description' => 'Enable this to get a separate access-log file for this domain',
		],
		'domain_editable' => [
			'title' => 'Allow editing of domain',
			'desc' => 'If set to yes, the customer is allowed to change several domain-settings.<br />If set to no, nothing can be changed by the customer.',
		],
		'writeaccesslog' => [
			'title' => 'Write an access log',
			'description' => 'Enable this to get an access-log file for this domain',
		],
		'writeerrorlog' => [
			'title' => 'Write an error log',
			'description' => 'Enable this to get an error-log file for this domain',
		],
		'phpfpm.ininote' => 'Not all values you may want to define can be used in the php-fpm pool configuration',
		'phpinfo' => 'PHPinfo()',
		'selectserveralias' => 'ServerAlias value for the domain',
		'selectserveralias_desc' => 'Choose whether froxlor should create a wildcard-entry (*.domain.tld), a WWW-alias (www.domain.tld) or no alias at all',
		'show_news_feed' => [
			'title' => 'Show news-feed on admin-dashboard',
			'description' => 'Enable this to show the official Froxlor newsfeed (https://inside.froxlor.org/news/) on your dashboard and never miss important information or release-announcements.',
		],
		'cronsettings' => 'Cronjob settings',
		'integritycheck' => 'Database validation',
		'integrityname' => 'Name',
		'integrityresult' => 'Result',
		'integrityfix' => 'Fix problems automatically',
		'customer_show_news_feed' => 'Show newsfeed on customer-dashboard',
		'customer_news_feed_url' => [
			'title' => 'Use custom RSS-feed',
			'description' => 'Specify a custom RSS-feed that will be shown to your customers on their dashboard.<br /><small>Leave this empty to use the official froxlor newsfeed (https://inside.froxlor.org/news/).</small>',
		],
		'movetoadmin' => 'Move customer',
		'movecustomertoadmin' => 'Move customer to the selected admin/reseller<br /><small>Leave this empty for no change.<br />If the desired admin does not show up in the list, his customer-limit has been reached.</small>',
		'note' => 'Note',
		'mod_fcgid_umask' => [
			'title' => 'Umask (default: 022)',
		],
		'apcuinfo' => 'APCu info',
		'opcacheinfo' => 'OPcache Info',
		'letsencrypt' => [
			'title' => 'Use Let\'s Encrypt',
			'description' => 'Get a free certificate from <a href="https://letsencrypt.org">Let\'s Encrypt</a>. The certificate will be created and renewed automatically.<br><strong class="text-danger">ATTENTION:</strong> If wildcards are enabled, this option will automatically be disabled.',
		],
		'autoupdate' => 'Auto-Update',
		'server_php' => 'PHP',
		'dnsenabled' => 'Enable DNS editor',
		'froxlorvhost' => 'Froxlor VirtualHost settings',
		'hostname' => 'Hostname',
		'memory' => 'Memory usage',
		'webserversettings_ssl' => 'Webserver SSL settings',
		'domain_hsts_maxage' => [
			'title' => 'HTTP Strict Transport Security (HSTS)',
			'description' => 'Specify the max-age value for the Strict-Transport-Security header<br>The value <i>0</i> will disable HSTS for the domain. Most user set a value of <i>31536000</i> (one year).',
		],
		'domain_hsts_incsub' => [
			'title' => 'Include HSTS for any subdomain',
			'description' => 'The optional "includeSubDomains" directive, if present, signals the UA that the HSTS Policy applies to this HSTS Host as well as any subdomains of the host\'s domain name.',
		],
		'domain_hsts_preload' => [
			'title' => 'Include domain in <a href="https://hstspreload.org/" target="_blank">HSTS preload list</a>',
			'description' => 'If you would like this domain to be included in the HSTS preload list maintained by Chrome (and used by Firefox and Safari), then use activate this.<br>Sending the preload directive from your site can have PERMANENT CONSEQUENCES and prevent users from accessing your site and any of its subdomains.<br>Please read the details at <a href="https://hstspreload.org/#removal" target="_blank">https://hstspreload.org/#removal</a> before sending the header with "preload".',
		],
		'domain_ocsp_stapling' => [
			'title' => 'OCSP stapling',
			'description' => 'See <a target="_blank" href="https://en.wikipedia.org/wiki/OCSP_stapling">Wikipedia</a> for a detailed explanation of OCSP stapling',
			'nginx_version_warning' => '<br /><strong class="text-danger">WARNING:</strong> Nginx version 1.3.7 or above is required for OCSP stapling. If your version is older, the webserver will NOT start correctly while OCSP stapling is enabled!',
		],
		'domain_http2' => [
			'title' => 'HTTP2 support',
			'description' => 'See <a target="_blank" href="https://en.wikipedia.org/wiki/HTTP/2">Wikipedia</a> for a detailed explanation of HTTP2',
		],
		'testmail' => 'SMTP test',
		'phpsettingsforsubdomains' => 'Apply php-config to all subdomains:',
		'plans' => [
			'name' => 'Plan name',
			'description' => 'Description',
			'last_update' => 'Last updated',
			'plans' => 'Hosting plans',
			'plan_details' => 'Plan details',
			'add' => 'Add new plan',
			'edit' => 'Edit plan',
			'use_plan' => 'Apply plan',
		],
		'notryfiles' => [
			'title' => 'No autogenerated try_files',
			'description' => 'Say yes here if you want to specify a custom try_files directive in specialsettings (needed for some wordpress plugins for example).',
		],
		'logviewenabled' => 'Enable access to access/error-logs',
		'novhostcontainer' => '<br><br><small class="text-danger">None of the IPs and ports has the "Create vHost-Container" option enabled, many settings here will not be available</small>',
		'ownsslvhostsettings' => 'Own SSL vHost-settings',
		'domain_override_tls' => 'Override system TLS settings',
		'domain_sslenabled' => 'Enable usage of SSL',
		'domain_honorcipherorder' => 'Honor the (server) cipher order, default <strong>no</strong>',
		'domain_sessiontickets' => 'Enable TLS sessiontickets (RFC 5077), default <strong>yes</strong>',
		'domain_sessionticketsenabled' => [
			'title' => 'Enable usage of TLS sessiontickets globally',
			'description' => 'Default <strong>yes</strong><br>Requires apache-2.4.11+ or nginx-1.5.9+',
		],
		'domaindefaultalias' => 'Default ServerAlias value for new domains',
		'smtpsettings' => 'SMTP settings',
		'smtptestaddr' => 'Send test-mail to',
		'smtptestnote' => 'Note that the values below reflect your current settings and can only be adjusted there (see link in top right corner)',
		'smtptestsend' => 'Send test-mail',
		'mysqlserver' => [
			'mysqlserver' => 'MySQL Server',
			'dbserver' => 'Server #',
			'caption' => 'Description',
			'host' => 'Hostname / IP',
			'port' => 'Port',
			'user' => 'Privileged user',
			'add' => 'Add new MySQL server',
			'edit' => 'Edit MySQL server',
			'password' => 'Privileged user password',
			'password_emptynochange' => 'New password, leave empty for no change',
			'allowall' => [
				'title' => 'Allow use of this server to all currently existing customers',
				'description' => 'Set this to "true" if you want to allow use of this database-server to all currently existing customers so they can add databases on it. This setting is not permanent but can be run multiple times.',
			],
			'testconn' => 'Test connection when saving',
			'ssl' => 'Use SSL for connection to database-server',
			'ssl_cert_file' => 'The file path to the SSL certificate authority',
			'verify_ca' => 'Enable verification of the server SSL certificate',
		],
		'settings_importfile' => 'Chose import file',
		'documentation' => 'Documentation',
		'adminguide' => 'Admin guide',
		'userguide' => 'User guide',
		'apiguide' => 'API guide',
	],
	'apcuinfo' => [
		'clearcache' => 'Clear APCu cache',
		'generaltitle' => 'General Cache Information',
		'version' => 'APCu Version',
		'phpversion' => 'PHP Version',
		'host' => 'APCu Host',
		'sharedmem' => 'Shared Memory',
		'sharedmemval' => '%d Segment(s) with %s (%s memory)',
		'start' => 'Start Time',
		'uptime' => 'Uptime',
		'upload' => 'File Upload Support',
		'cachetitle' => 'Cache Information',
		'cvar' => 'Cached Variables',
		'hit' => 'Hits',
		'miss' => 'Misses',
		'reqrate' => 'Request Rate (hits, misses)',
		'creqsec' => 'cache requests/second',
		'hitrate' => 'Hit Rate',
		'missrate' => 'Miss Rate',
		'insrate' => 'Insert Rate',
		'cachefull' => 'Cache full count',
		'runtime' => 'Runtime Settings',
		'memnote' => 'Memory Usage',
		'total' => 'Total',
		'free' => 'Free',
		'used' => 'Used',
		'hitmiss' => 'Hits & Misses',
		'detailmem' => 'Detailed Memory Usage and Fragmentation',
		'fragment' => 'Fragmentation',
		'nofragment' => 'No fragmentation',
		'fragments' => 'Fragments',
	],
	'apikeys' => [
		'no_api_keys' => 'No API keys found',
		'key_add' => 'Add new key',
		'apikey_removed' => 'The api key with the id #%s has been removed successfully',
		'apikey_added' => 'A new api key has been generated successfully',
		'clicktoview' => 'Click to view',
		'allowed_from' => 'Allowed from',
		'allowed_from_help' => 'Comma separated list of ip addresses / networks.<br>Default is empty (allow from all).',
		'valid_until' => 'Valid until',
		'valid_until_help' => 'Date until valid, format YYYY-MM-DDThh:mm',
	],
	'changepassword' => [
		'old_password' => 'Old password',
		'new_password' => 'New password',
		'new_password_confirm' => 'Confirm password',
		'new_password_ifnotempty' => 'New password (empty = no change)',
		'also_change_ftp' => ' also change password of the main FTP account',
		'also_change_stats' => ' also change password for the statistics page',
	],
	'cron' => [
		'cronname' => 'cronjob-name',
		'lastrun' => 'last run',
		'interval' => 'interval',
		'isactive' => 'enabled',
		'description' => 'description',
		'changewarning' => 'Changing these values can have a negative cause to the behavior of Froxlor and its automated tasks.<br />Please only change values here, if you are sure you know what you are doing.',
	],
	'crondesc' => [
		'cron_unknown_desc' => 'no description given',
		'cron_tasks' => 'Generating of configfiles',
		'cron_legacy' => 'legacy (old) cronjob',
		'cron_traffic' => 'Traffic calculation',
		'cron_usage_report' => 'Web- and traffic-reports',
		'cron_mailboxsize' => 'Mailbox-size calculation',
		'cron_letsencrypt' => 'Let\'s Encrypt certificate updates',
		'cron_backup' => 'Process backup jobs',
	],
	'cronjob' => [
		'cronjobsettings' => 'Cronjob settings',
		'cronjobintervalv' => 'Runtime interval value',
		'cronjobinterval' => 'Runtime interval',
	],
	'cronjobs' => [
		'notyetrun' => 'Not yet run',
	],
	'cronmgmt' => [
		'minutes' => 'minutes',
		'hours' => 'hours',
		'days' => 'days',
		'weeks' => 'weeks',
		'months' => 'months',
	],
	'customer' => [
		'documentroot' => 'Home directory',
		'name' => 'Name',
		'firstname' => 'First name',
		'lastname' => 'Last name',
		'company' => 'Company',
		'nameorcompany_desc' => 'Either firstname/lastname or company is required',
		'street' => 'Street',
		'zipcode' => 'Zipcode',
		'city' => 'City',
		'phone' => 'Phone',
		'fax' => 'Fax',
		'email' => 'Email',
		'customernumber' => 'Customer ID',
		'diskspace' => 'Webspace',
		'traffic' => 'Traffic',
		'mysqls' => 'MySQL-databases',
		'emails' => 'Email-addresses',
		'accounts' => 'Email-accounts',
		'forwarders' => 'Email-forwarders',
		'ftps' => 'FTP-accounts',
		'subdomains' => 'Subdomains',
		'domains' => 'Domains',
		'mib' => 'MiB',
		'gib' => 'GiB',
		'title' => 'Title',
		'country' => 'Country',
		'email_quota' => 'E-mail quota',
		'email_imap' => 'E-mail IMAP',
		'email_pop3' => 'E-mail POP3',
		'mail_quota' => 'Mailquota',
		'sendinfomail' => 'Send data via email to me',
		'generated_pwd' => 'Password suggestion',
		'usedmax' => 'Used / Max',
		'services' => 'Services',
		'letsencrypt' => [
			'title' => 'Use Let\'s Encrypt',
			'description' => 'Get a free certificate from <a href="https://letsencrypt.org">Let\'s Encrypt</a>. The certificate will be created and renewed automatically.',
		],
		'selectserveralias_addinfo' => 'This option can be set when editing the domain. Its initial value is inherited from the parent-domain.',
		'total_diskspace' => 'Total diskspace',
		'mysqlserver' => 'Usable mysql-server',
	],
	'diskquota' => 'Quota',
	'dkim' => [
		'dkim_prefix' => [
			'title' => 'Prefix',
			'description' => 'Please specify the path to the DKIM RSA-files as well as to the configuration files for the Milter-plugin',
		],
		'dkim_domains' => [
			'title' => 'Domains filename',
			'description' => '<em>Filename</em> of the DKIM Domains parameter specified in the dkim-milter configuration',
		],
		'dkim_dkimkeys' => [
			'title' => 'KeyList filename',
			'description' => '<em>Filename</em> of the  DKIM KeyList parameter specified in the dkim-milter configuration',
		],
		'dkimrestart_command' => [
			'title' => 'Milter restart command',
			'description' => 'Please specify the restart command for the DKIM milter service',
		],
		'privkeysuffix' => [
			'title' => 'Private keys suffix',
			'description' => 'You can specify an (optional) filename extension/suffix for the generate dkim private keys. Some services like dkim-filter requires this to be empty',
		],
		'use_dkim' => [
			'title' => 'Activate DKIM support?',
			'description' => 'Would you like to use the Domain Keys (DKIM) system?<br/><em class="text-danger">Note: DKIM is only supported using dkim-filter, not opendkim (yet)</em>',
		],
		'dkim_algorithm' => [
			'title' => 'Allowed Hash Algorithms',
			'description' => 'Define allowed hash algorithms, chose "All" for all algorithms or one or more from the other available algorithms',
		],
		'dkim_servicetype' => 'Service Types',
		'dkim_keylength' => [
			'title' => 'Key-length',
			'description' => 'Attention: If you change this values, you need to delete all the private/public keys in "%s"',
		],
		'dkim_notes' => [
			'title' => 'DKIM Notes',
			'description' => 'Notes that might be of interest to a human, e.g. a URL like http://www.dnswatch.info. No interpretation is made by any program. This tag should be used sparingly due to space limitations in DNS. This is intended for use by administrators, not end users.',
		],
	],
	'dns' => [
		'destinationip' => 'Domain IP(s)',
		'standardip' => 'Server standard IP',
		'a_record' => 'A-Record (IPv6 optional)',
		'cname_record' => 'CNAME-Record',
		'mxrecords' => 'Define MX records',
		'standardmx' => 'Server standard MX record',
		'mxconfig' => 'Custom MX records',
		'priority10' => 'Priority 10',
		'priority20' => 'Priority 20',
		'txtrecords' => 'Define TXT records',
		'txtexample' => 'Example (SPF-entry):<br />v=spf1 ip4:xxx.xxx.xx.0/23 -all',
		'howitworks' => 'Here you can manage DNS entries for your domain. Note that froxlor will automatically generate NS/MX/A/AAAA records for you. The custom entries are preferred, only missing entries will be automatically generated.',
	],
	'dnseditor' => [
		'edit' => 'edit DNS',
		'records' => 'records',
		'notes' => [
			'A' => '32-bit IPv4 address, used to map hostnames to an IP address of the host.',
			'AAAA' => '128-bit IPv6 address, used to map hostnames to an IP address of the host.',
			'CAA' => 'The CAA resource record allows a DNS domain name holder to specify one or more Certification Authorities (CAs) authorized to issue certificates for that domain.<br>Structure: <code>flag tag[issue|issuewild|iodef|contactmail|contactphone] value</code><br>Example: <code>0 issue "ca.example.net"<br>0 iodef "mailto:security@example.com"</code>',
			'CNAME' => 'Alias of the domain name, the DNS lookup will continue by retrying the lookup with the new name. Only possible for subdomains!',
			'DNAME' => 'Creates an alias for an entire subtree of the domain name tree',
			'LOC' => 'Geographic location information for a domain name.<br>Structure: <code>( d1 [m1 [s1]] {"N"|"S"} d2 [m2 [s2]] {"E"|"W"} alt["m"] [siz["m"] [hp["m"] [vp["m"]]]] )</code><br>Description: <code>d1:     [0 .. 90]            (degrees latitude)
			d2:     [0 .. 180]           (degrees longitude)
			m1, m2: [0 .. 59]            (minutes latitude/longitude)
			s1, s2: [0 .. 59.999]        (seconds latitude/longitude)
			alt:    [-100000.00 .. 42849672.95] BY .01 (altitude in meters)
			siz, hp, vp: [0 .. 90000000.00] (size/precision in meters)</code><br>Example: <code>52 22 23.000 N 4 53 32.000 E -2.00m 0.00m 10000m 10m</code>',
			'MX' => 'Mail exchange record, maps a domain name to a mailserver for that domain.<br>Example: <code>10 mail.example.com</code><br>Note: For priority, use field above',
			'NS' => 'Delegates a DNS zone to use the given authoritative name servers.',
			'RP' => 'Responsible Person record<br>Structure: <code>mailbox[replace @ with a dot] txt-record-name</code><br>Example: <code>team.froxlor.org. froxlor.org.</code>',
			'SRV' => 'Service location record, used for newer protocols instead of creating protocol-specific records such as MX.<br>Structure: <code>priority weight port target</code><br>Example: <code>0 5 5060 sipserver.example.com.</code><br>Note: For priority, use field above',
			'SSHFP' => 'The SSHFP resource record is used to publish secure shell (SSH) key fingerprints in the DNS.<br>Structure: <code>algorithm type fingerprint</code><br>Algorithms: <code>0: reserved, 1: RSA, 2: DSA, 3: ECDSA, 4: Ed25519, 6: Ed448</code><br>Types: <code>0: reserved, 1: SHA-1, 2: SHA-256</code><br>Example: <code>2 1 123456789abcdef67890123456789abcdef67890</code>',
			'TXT' => 'Free definable, descriptive text.'
		]
	],
	'domain' => [
		'openbasedirpath' => 'OpenBasedir-path',
		'docroot' => 'Path from field above',
		'homedir' => 'Home directory',
		'docparent' => 'Parent-directory of path from field above',
		'ssl_certificate_placeholder' => '---- BEGIN CERTIFICATE---' . PHP_EOL . '[...]' . PHP_EOL . '----END CERTIFICATE----',
		'ssl_key_placeholder' => '---- BEGIN RSA PRIVATE KEY-----' . PHP_EOL . '[...]' . PHP_EOL . '-----END RSA PRIVATE KEY-----',
	],
	'domains' => [
		'description' => 'Here you can create (sub-)domains and change their paths.<br />The system will need some time to apply the new settings after every change.',
		'domainsettings' => 'Domain settings',
		'domainname' => 'Domain name',
		'subdomain_add' => 'Create subdomain',
		'subdomain_edit' => 'Edit (sub)domain',
		'wildcarddomain' => 'Create as wildcarddomain?',
		'aliasdomain' => 'Alias for domain',
		'noaliasdomain' => 'No alias domain',
		'hasaliasdomains' => 'Has alias domain(s)',
		'statstics' => 'Usage Statistics',
		'isassigneddomain' => 'Is assigned domain',
		'add_date' => 'Added to Froxlor',
		'registration_date' => 'Added to registry',
		'topleveldomain' => 'Top-Level-Domain',
		'associated_with_domain' => 'Associated',
		'aliasdomains' => 'Alias domains',
		'redirectifpathisurl' => 'Redirect code (default: empty)',
		'redirectifpathisurlinfo' => 'You only need to select one of these if you entered an URL as path<br/><strong class="text-danger">NOTE:</strong> Changes are only applied if the given path is an URL.',
		'issubof' => 'This domain is a subdomain of another domain',
		'issubofinfo' => 'You have to set this to the correct domain if you want to add a subdomain as full-domain (e.g. you want to add "www.domain.tld", you have to select "domain.tld" here)',
		'nosubtomaindomain' => 'No subdomain of a full domain',
		'ipandport_multi' => [
			'title' => 'IP address(es)',
			'description' => 'Specify one or more IP address for the domain.<br /><br /><div class="text-danger">NOTE: IP addresses cannot be changed when the domain is configured as <strong>alias-domain</strong> of another domain.</div>',
		],
		'ipandport_ssl_multi' => [
			'title' => 'SSL IP address(es)',
		],
		'ssl_redirect' => [
			'title' => 'SSL redirect',
			'description' => 'This option creates redirects for non-ssl vhosts so that all requests are redirected to the SSL-vhost.<br /><br />e.g. a request to <strong>http</strong>://domain.tld/ will redirect you to <strong>https</strong>://domain.tld/',
		],
		'serveraliasoption_wildcard' => 'Wildcard (*.domain.tld)',
		'serveraliasoption_www' => 'WWW (www.domain.tld)',
		'serveraliasoption_none' => 'No alias',
		'domain_import' => 'Import Domains',
		'import_separator' => 'Separator',
		'import_offset' => 'Offset',
		'import_file' => 'CSV-File',
		'import_description' => 'Detailed information about the structure of the import-file and how to import successfully, please visit <a href="https://docs.froxlor.org/latest/admin-guide/domain-import/" target="_blank" class="alert-link">https://docs.froxlor.org/latest/admin-guide/domain-import/</a>',
		'ssl_redirect_temporarilydisabled' => '<br>The SSL redirect is temporarily deactivated while a new Let\'s Encrypt certificate is generated. It will be activated again after the certificate was generated.',
		'termination_date' => 'Date of termination',
		'termination_date_overview' => 'terminated as of ',
		'ssl_certificates' => 'SSL certificates',
		'ssl_certificate_removed' => 'The certificate with the id #%s has been removed successfully',
		'ssl_certificate_error' => 'Error reading certificate for domain: %s',
		'no_ssl_certificates' => 'There are no domains with SSL certificate',
		'isaliasdomainof' => 'Is aliasdomain for %s',
		'isbinddomain' => 'Create DNS zone',
		'dkimenabled' => 'DKIM enabled',
		'openbasedirenabled' => 'Openbasedir restiction',
		'hsts' => 'HSTS enabled',
		'aliasdomainid' => 'ID of alias domain',
	],
	'emails' => [
		'description' => 'Here you can create and change your email addresses.<br />An account is like your letterbox in front of your house. If someone sends you an email, it will be dropped into the account.<br /><br />To download your emails use the following settings in your mailprogram: (The data in <i>italics</i> has to be changed to the equivalents you typed in!)<br />Hostname: <b><i>domainname</i></b><br />Username: <b><i>account name / e-mail address</i></b><br />password: <b><i>the password you\'ve chosen</i></b>',
		'emailaddress' => 'Email-address',
		'emails_add' => 'Create email-address',
		'emails_edit' => 'Edit email-address',
		'catchall' => 'Catchall',
		'iscatchall' => 'Define as catchall-address?',
		'account' => 'Account',
		'account_add' => 'Create account',
		'account_delete' => 'Delete account',
		'from' => 'Source',
		'to' => 'Destination',
		'forwarders' => 'Forwarders',
		'forwarder_add' => 'Create forwarder',
		'alternative_emailaddress' => 'Alternative e-mail-address',
		'quota' => 'Quota',
		'noquota' => 'No quota',
		'updatequota' => 'Update Quota',
		'quota_edit' => 'Change E-Mail Quota',
		'noemaildomainaddedyet' => 'You do not have a (email-)domain in your account yet.',
		'back_to_overview' => 'Back to domain overview',
	],
	'error' => [
		'error' => 'Error',
		'directorymustexist' => 'The directory %s must exist. Please create it with your FTP client.',
		'filemustexist' => 'The file %s must exist.',
		'allresourcesused' => 'You have already used all of your resources.',
		'domains_cantdeletemaindomain' => 'You cannot delete an assigned domain.',
		'domains_canteditdomain' => 'You cannot edit this domain. It has been disabled by the admin.',
		'domains_cantdeletedomainwithemail' => 'You cannot delete a domain which is used as an email-domain. Delete all email addresses first.',
		'firstdeleteallsubdomains' => 'You have to delete all subdomains first before you can create a wildcard domain.',
		'youhavealreadyacatchallforthisdomain' => 'You have already defined a catchall for this domain.',
		'ftp_cantdeletemainaccount' => 'You cannot delete your main FTP account',
		'login' => 'The username or password you typed in is wrong. Please try it again!',
		'login_blocked' => 'This account has been suspended because of too many login errors. <br />Please try again in %s seconds.',
		'notallreqfieldsorerrors' => 'You have not filled in all or filled in some fields incorrectly.',
		'oldpasswordnotcorrect' => 'The old password is not correct.',
		'youcantallocatemorethanyouhave' => 'You cannot allocate more resources than you own for yourself.',
		'mustbeurl' => 'You have not typed a valid or complete url (e.g. http://somedomain.com/error404.htm)',
		'invalidpath' => 'You have not chosen a valid URL (maybe problems with the dirlisting?)',
		'stringisempty' => 'Missing Input in Field',
		'stringiswrong' => 'Wrong Input in Field',
		'newpasswordconfirmerror' => 'New password and confirmation does not match',
		'mydomain' => '\'Domain\'',
		'mydocumentroot' => '\'Documentroot\'',
		'loginnameexists' => 'Loginname %s already exists',
		'emailiswrong' => 'Email-address %s contains invalid characters or is incomplete',
		'alternativeemailiswrong' => 'The given alternative email address %s to send the credentials to seems to be invalid',
		'loginnameiswrong' => 'Loginname "%s" contains illegal characters.',
		'loginnameiswrong2' => 'Loginname contains too many characters. Only %s characters are allowed.',
		'userpathcombinationdupe' => 'Combination of username and path already exists',
		'patherror' => 'General Error! Path cannot be empty',
		'errordocpathdupe' => 'Option for path %s already exists',
		'adduserfirst' => 'Please create a customer first',
		'domainalreadyexists' => 'The domain %s is already assigned to a customer',
		'nolanguageselect' => 'No language selected.',
		'nosubjectcreate' => 'You must define a topic for this mail template.',
		'nomailbodycreate' => 'You must define a mail-text for this mail template.',
		'templatenotfound' => 'Template was not found.',
		'alltemplatesdefined' => 'You can\'t define more templates, all languages are supported already.',
		'wwwnotallowed' => 'www is not allowed for subdomains.',
		'subdomainiswrong' => 'The subdomain %s contains invalid characters.',
		'domaincantbeempty' => 'The domain-name can not be empty.',
		'domainexistalready' => 'The domain %s already exists.',
		'domainisaliasorothercustomer' => 'The selected alias domain is either itself an alias domain, has a different ip/port combination or belongs to another customer.',
		'emailexistalready' => 'The email-address %s already exists.',
		'maindomainnonexist' => 'The main-domain %s does not exist.',
		'destinationnonexist' => 'Please create your forwarder in the field \'Destination\'.',
		'destinationalreadyexistasmail' => 'The forwarder to %s already exists as active email-address.',
		'destinationalreadyexist' => 'You have already defined a forwarder to "%s"',
		'destinationiswrong' => 'The forwarder %s contains invalid character(s) or is incomplete.',
		'backupfoldercannotbedocroot' => 'The folder for backups cannot be your homedir, please chose a folder within your homedir, e.g. /backups',
		'templatelanguagecombodefined' => 'The selected language/template combination has already been defined.',
		'templatelanguageinvalid' => 'The selected language does not exist',
		'ipstillhasdomains' => 'The IP/Port combination you want to delete still has domains assigned to it, please reassign those to other IP/Port combinations before deleting this IP/Port combination.',
		'cantdeletedefaultip' => 'You cannot delete the default IP/Port combination, please make another IP/Port combination default for before deleting this IP/Port combination.',
		'cantdeletesystemip' => 'You cannot delete the last system IP, either create a new IP/Port combination for the system IP or change the system IP.',
		'myipaddress' => '\'IP\'',
		'myport' => '\'Port\'',
		'myipdefault' => 'You need to select an IP/Port combination that should become default.',
		'myipnotdouble' => 'This IP/Port combination already exists.',
		'admin_domain_emailsystemhostname' => 'The server-hostname cannot be used as customer-domain.',
		'cantchangesystemip' => 'You cannot change the last system IP, either create another new IP/Port combination for the system IP or change the system IP.',
		'sessiontimeoutiswrong' => 'Only numerical "session timeout" is allowed.',
		'maxloginattemptsiswrong' => 'Only numerical "max login attempts" are allowed.',
		'deactivatetimiswrong' => 'Only numerical "deactivation time" is allowed.',
		'accountprefixiswrong' => 'The "customerprefix" is wrong.',
		'mysqlprefixiswrong' => 'The "SQL prefix" is wrong.',
		'ftpprefixiswrong' => 'The "FTP prefix" is wrong.',
		'ipiswrong' => 'The "IP-address" is wrong. Only a valid IP-address is allowed.',
		'vmailuidiswrong' => 'The "mails-uid" is wrong. Only a numerical UID is allowed.',
		'vmailgidiswrong' => 'The "mails-gid" is wrong. Only a numerical GID is allowed.',
		'adminmailiswrong' => 'The "sender-address" is wrong. Only a valid email-address is allowed.',
		'pagingiswrong' => 'The "entries per page"-value is wrong. Only numerical characters are allowed.',
		'phpmyadminiswrong' => 'The phpMyAdmin-link is not a valid link.',
		'webmailiswrong' => 'The webmail-link is not a valid link.',
		'webftpiswrong' => 'The WebFTP-link is not a valid link.',
		'stringformaterror' => 'The value for the field "%s" is not in the expected format.',
		'loginnameisusingprefix' => 'You cannot create accounts that begin with "%s", as this prefix is set to be used for the automatic account-naming. Please enter another account name.',
		'loginnameissystemaccount' => 'The account "%s" already exists on the system and cannot be used. Please enter another account name.',
		'youcantdeleteyourself' => 'You cannot delete yourself for security reasons.',
		'youcanteditallfieldsofyourself' => 'Note: You cannot edit all fields of your own account for security reasons.',
		'documentrootexists' => 'The directory "%s" already exists for this customer. Please remove this before adding the customer again.',
		'norepymailiswrong' => 'The "Noreply-address" is wrong. Only a valid email-address is allowed.',
		'logerror' => 'Log-Error: %s',
		'nomessagetosend' => 'You did not enter a message.',
		'norecipientsgiven' => 'You did not specify any recipient',
		'errorsendingmail' => 'The message to "%s" failed',
		'errorsendingmailpub' => 'The message to the given email-address failed',
		'cannotreaddir' => 'Unable to read directory "%s"',
		'invalidip' => 'Invalid IP address: %s',
		'invalidmysqlhost' => 'Invalid MySQL host address: %s',
		'cannotuseawstatsandwebalizeratonetime' => 'You cannot enable Webalizer and AWstats at the same time, please chose one of them',
		'cannotwritetologfile' => 'Cannot open logfile %s for writing',
		'vmailquotawrong' => 'The quotasize must be positive number.',
		'allocatetoomuchquota' => 'You tried to allocate %s MB Quota, but you do not have enough left.',
		'missingfields' => 'Not all required fields were filled out.',
		'requiredfield' => 'This field is required.',
		'accountnotexisting' => 'The given email account doesn\'t exist.',
		'nopermissionsorinvalidid' => 'You don\'t have enough permissions to change these settings or an invalid id was given.',
		'phpsettingidwrong' => 'A PHP Configuration with this id doesn\'t exist',
		'descriptioninvalid' => 'The description is too short, too long or contains illegal characters.',
		'info' => 'Info',
		'filecontentnotset' => 'The file cannot be empty!',
		'index_file_extension' => 'The file extension for the index file must be between 1 and 6 characters long. The extension can only contain characters like a-z, A-Z and 0-9',
		'customerdoesntexist' => 'The customer you have chosen doesn\'t exist.',
		'admindoesntexist' => 'The admin you have chosen doesn\'t exist.',
		'ipportdoesntexist' => 'The ip/port combination you have chosen doesn\'t exist.',
		'usernamealreadyexists' => 'The username %s already exists.',
		'plausibilitychecknotunderstood' => 'Answer of plausibility check not understood.',
		'errorwhensaving' => 'An error occurred when saving the field %s',
		'hiddenfieldvaluechanged' => 'The value for the hidden field "%s" changed while editing the settings.<br /><br />This is usually not a big problem but the settings could not be saved because of this.',
		'notrequiredpasswordlength' => 'The given password is too short. Please enter at least %s characters.',
		'overviewsettingoptionisnotavalidfield' => 'Whoops, a field that should be displayed as an option in the settings-overview is not an excepted type. You can blame the developers for this. This should not happen!',
		'pathmaynotcontaincolon' => 'The path you have entered should not contain a colon (":"). Please enter a correct path value.',
		'exception' => '%s',
		'notrequiredpasswordcomplexity' => 'The specified password-complexity was not satisfied.<br />Please contact your administrator if you have any questions about the complexity-specification',
		'stringerrordocumentnotvalidforlighty' => 'A string as ErrorDocument does not work in lighttpd, please specify a path to a file',
		'urlerrordocumentnotvalidforlighty' => 'An URL as ErrorDocument does not work in lighttpd, please specify a path to a file',
		'invaliderrordocumentvalue' => 'The value given as ErrorDocument does not seem to be a valid file, URL or string.',
		'intvaluetoolow' => 'The given number is too low (field %s)',
		'intvaluetoohigh' => 'The given number is too high (field %s)',
		'phpfpmstillenabled' => 'PHP-FPM is currently active. Please deactivate it before activating FCGID',
		'fcgidstillenabled' => 'FCGID is currently active. Please deactivate it before activating PHP-FPM',
		'domains_cantdeletedomainwithaliases' => 'You cannot delete a domain which is used for alias-domains. You have to delete the aliases first.',
		'user_banned' => 'Your account has been locked. Please contact your administrator for further information.',
		'session_timeout' => 'Value too low',
		'session_timeout_desc' => 'You should not set the session timeout lower than 1 minute.',
		'invalidhostname' => 'Hostname needs to be a valid domain. It can\'t be empty nor can it consist only of whitespaces',
		'operationnotpermitted' => 'Operation not permitted!',
		'featureisdisabled' => 'Feature %s is disabled. Please contact your service provider.',
		'usercurrentlydeactivated' => 'The user %s is currently deactivated',
		'setlessthanalreadyused' => 'You cannot set less resources of \'%s\' than this user already used<br />',
		'stringmustntbeempty' => 'The value for the field %s must not be empty',
		'sslcertificateismissingprivatekey' => 'You need to specify a private key for your certificate',
		'sslcertificatewrongdomain' => 'The given certificate does not belong to this domain',
		'sslcertificateinvalidcert' => 'The given certificate-content does not seem to be a valid certificate',
		'sslcertificateinvalidcertkeypair' => 'The given private-key does not belong to the given certificate',
		'sslcertificateinvalidca' => 'The given CA certificate data does not seem to be a valid certificate',
		'sslcertificateinvalidchain' => 'The given certificate chain data does not seem to be a valid certificate',
		'givendirnotallowed' => 'The given directory in field %s is not allowed.',
		'sslredirectonlypossiblewithsslipport' => 'Using Let\'s Encrypt is only possible when the domain has at least one ssl-enabled IP/port combination assigned.',
		'fcgidstillenableddeadlock' => 'FCGID is currently active.<br />Please deactivate it before switching to another webserver than Apache2 or lighttpd',
		'send_report_title' => 'Send error report',
		'send_report_desc' => 'Thank you for reporting this error and helping us to improve Froxlor.<br />This is the email which will be sent to the Froxlor developer team:',
		'send_report' => 'Send report',
		'send_report_error' => 'Error when sending report: <br />%s',
		'notallowedtouseaccounts' => 'Your account does not allow using IMAP/POP3. You cannot add email accounts.',
		'cannotdeletehostnamephpconfig' => 'This PHP-configuration is used by the Froxlor-vhost and cannot be deleted.',
		'cannotdeletedefaultphpconfig' => 'This PHP-configuration is set as default and cannot be deleted.',
		'passwordshouldnotbeusername' => 'The password should not be the same as the username.',
		'no_phpinfo' => 'Sorry, unable to read phpinfo()',
		'moveofcustomerfailed' => 'Moving the customer to the selected admin/reseller failed. Keep in mind that all other changes to the customer were applied successfully at this stage.<br><br>Error-message: %s',
		'domain_import_error' => 'Following error occurred while importing domains: %s',
		'fcgidandphpfpmnogoodtogether' => 'FCGID and PHP-FPM cannot be activated at the same time',
		'no_apcuinfo' => 'No cache info available. APCu does not appear to be running.',
		'no_opcacheinfo' => 'No cache info available. OPCache does not appear to be running.',
		'nowildcardwithletsencrypt' => 'Let\'s Encrypt cannot handle wildcard-domains using ACME in froxlor (requires dns-challenge), sorry. Please set the ServerAlias to WWW or disable it completely',
		'customized_version' => 'It looks like your Froxlor installation has been modified, no support sorry.',
		'autoupdate_0' => 'Unknown error',
		'autoupdate_1' => 'PHP setting allow_url_fopen is disabled. Autoupdate needs this setting to be enabled in php.ini',
		'autoupdate_2' => 'PHP zip extension not found, please ensure it is installed and activated',
		'autoupdate_4' => 'The froxlor archive could not be stored to the disk :(',
		'autoupdate_5' => 'version.froxlor.org returned inacceptable values :(',
		'autoupdate_6' => 'Whoops, there was no (valid) version given to download :(',
		'autoupdate_7' => 'The downloaded archive could not be found :(',
		'autoupdate_8' => 'The archive could not be extracted :(',
		'autoupdate_9' => 'The downloaded file did not pass the integrity check. Please try to update again.',
		'autoupdate_10' => 'Minimum supported version of PHP is 7.4.0',
		'autoupdate_11' => 'Webupdate is disabled',
		'mailaccistobedeleted' => 'Another account with the same name (%s) is currently being deleted and can therefore not be added at this moment.',
		'customerhasongoingbackupjob' => 'There is already a backup job waiting to be processed, please be patient.',
		'backupfunctionnotenabled' => 'The backup function is not enabled',
		'dns_domain_nodns' => 'DNS is not enabled for this domain',
		'dns_content_empty' => 'No content given',
		'dns_content_invalid' => 'DNS content invalid',
		'dns_arec_noipv4' => 'No valid IP address for A-record given',
		'dns_aaaarec_noipv6' => 'No valid IP address for AAAA-record given',
		'dns_mx_prioempty' => 'Invalid MX priority given',
		'dns_mx_needdom' => 'The MX content value must be a valid domain-name',
		'dns_mx_noalias' => 'The MX-content value cannot be an CNAME entry.',
		'dns_cname_invaliddom' => 'Invalid domain-name for CNAME record',
		'dns_cname_nomorerr' => 'There already exists a resource-record with the same record-name. It can not be used as CNAME.',
		'dns_other_nomorerr' => 'There already exists a CNAME record with the same record-name. It can not be used for another type.',
		'dns_ns_invaliddom' => 'Invalid domain-name for NS record',
		'dns_srv_prioempty' => 'Invalid SRV priority given',
		'dns_srv_invalidcontent' => 'Invalid SRV content, must contain of fields weight, port and target, e.g.: 5 5060 sipserver.example.com.',
		'dns_srv_needdom' => 'The SRV target value must be a valid domain-name',
		'dns_srv_noalias' => 'The SRV-target value cannot be an CNAME entry.',
		'dns_duplicate_entry' => 'Record already exists',
		'dns_notfoundorallowed' => 'Domain not found or no permission',
		'domain_nopunycode' => 'You must not specify punycode (IDNA). The domain will automatically be converted',
		'dns_record_toolong' => 'Records/labels can only be up to 63 characters',
		'noipportgiven' => 'No IP/port given',
		'jsonextensionnotfound' => 'This feature requires the php json-extension.',
		'cannotdeletesuperadmin' => 'The first admin cannot be deleted.',
		'no_wwwcnamae_ifwwwalias' => 'Cannot set CNAME record for "www" as domain is set to generate a www-alias. Please change settings to either "No alias" or "Wildcard alias"',
		'local_group_exists' => 'The given group already exists on the system.',
		'local_group_invalid' => 'The given group name is invalid',
		'invaliddnsforletsencrypt' => 'The domains DNS does not include any of the chosen IP addresses. Let\'s Encrypt certificate generation not possible.',
		'notallowedphpconfigused' => 'Trying to use php-config which is not assigned to customer',
		'pathmustberelative' => 'The user does not have the permission to specify directories outside the customers home-directory. Please specify a relative path (no leading /).',
		'mysqlserverstillhasdbs' => 'Cannot remove database server from customers allow-list as there are still databases on it.',
		'domaincannotbeedited' => 'You are not permitted to edit the domain %s',
		'invalidcronjobintervalvalue' => 'Cronjob interval must be one of: %s',
	],
	'extras' => [
		'description' => 'Here you can add some extras, for example directory protection.<br />The system will need some time to apply the new settings after every change.',
		'directoryprotection_add' => 'Add directory protection',
		'view_directory' => 'Display directory content',
		'pathoptions_add' => 'Add path options',
		'directory_browsing' => 'Directory content browsing',
		'pathoptions_edit' => 'Edit path options',
		'error404path' => '404',
		'error403path' => '403',
		'error500path' => '500',
		'error401path' => '401',
		'errordocument404path' => 'ErrorDocument 404',
		'errordocument403path' => 'ErrorDocument 403',
		'errordocument500path' => 'ErrorDocument 500',
		'errordocument401path' => 'ErrorDocument 401',
		'execute_perl' => 'Execute perl/CGI',
		'htpasswdauthname' => 'Authentication reason (AuthName)',
		'directoryprotection_edit' => 'Edit directory protection',
		'backup' => 'Create backup',
		'backup_web' => 'Backup web-data',
		'backup_mail' => 'Backup mail-data',
		'backup_dbs' => 'Backup databases',
		'path_protection_label' => '<strong class="text-danger">Important</strong>',
		'path_protection_info' => 'We strongly recommend protecting the given path, see "Extras" -> "Directory protection"',
	],
	'ftp' => [
		'description' => 'Here you can create and change your FTP-accounts.<br />The changes are made instantly and the accounts can be used immediately.',
		'account_add' => 'Create account',
		'account_edit' => 'Edit ftp account',
		'editpassdescription' => 'Set new password or leave blank for no change.',
	],
	'gender' => [
		'title' => 'Title',
		'male' => 'Mr.',
		'female' => 'Mrs.',
		'undef' => '',
	],
	'imprint' => 'Legal notes',
	'index' => [
		'customerdetails' => 'Customer details',
		'accountdetails' => 'Account details',
	],
	'integrity_check' => [
		'databaseCharset' => 'Character set of database (should be UTF-8)',
		'domainIpTable' => 'IP &lt;&dash;&gt; domain references',
		'subdomainSslRedirect' => 'False SSL-redirect flag for non-ssl domains',
		'froxlorLocalGroupMemberForFcgidPhpFpm' => 'froxlor-user in the customer groups (for FCGID/php-fpm)',
		'webserverGroupMemberForFcgidPhpFpm' => 'Webserver-user in the customer groups (for FCGID/php-fpm)',
		'subdomainLetsencrypt' => 'Main domains with no SSL-Port assigned don\'t have any subdomains with active SSL redirect',
	],
	'logger' => [
		'date' => 'Date',
		'type' => 'Type',
		'action' => 'Action',
		'user' => 'User',
		'truncate' => 'Empty log',
		'reseller' => 'Reseller',
		'admin' => 'Administrator',
		'cron' => 'Cronjob',
		'login' => 'Login',
		'intern' => 'Internal',
		'unknown' => 'Unknown',
	],
	'login' => [
		'username' => 'Username',
		'password' => 'Password',
		'language' => 'Language',
		'login' => 'Login',
		'logout' => 'Logout',
		'profile_lng' => 'Profile language',
		'welcomemsg' => 'Please log in to access your account.',
		'forgotpwd' => 'Forgot your password?',
		'presend' => 'Reset password',
		'email' => 'E-mail address',
		'remind' => 'Reset my password',
		'usernotfound' => 'User not found!',
		'backtologin' => 'Back to login',
		'combination_not_found' => 'Combination of user and email address not found.',
		'2fa' => 'Two-factor authentication (2FA)',
		'2facode' => 'Please enter 2FA code',
	],
	'mails' => [
		'pop_success' => [
			'mailbody' => 'Hello,\\n\\nyour mail account {EMAIL}\\nwas set up successfully.\\n\\nThis is an automatically created\\ne-mail, please do not answer!\\n\\nYours sincerely, your administrator',
			'subject' => 'Mail account set up successfully',
		],
		'createcustomer' => [
			'mailbody' => 'Hello {SALUTATION},\\n\\nhere is your account information:\\n\\nUsername: {USERNAME}\\nPassword: {PASSWORD}\\n\\nThank you,\\nyour administrator',
			'subject' => 'Account information',
		],
		'pop_success_alternative' => [
			'mailbody' => 'Hello {SALUTATION},\\n\\nyour Mail account {EMAIL}\\nwas set up successfully.\\nYour password is {PASSWORD}.\\n\\nThis is an automatically created\\ne-mail, please do not answer!\\n\\nYours sincerely, your administrator',
			'subject' => 'Mail account set up successfully',
		],
		'password_reset' => [
			'subject' => 'Password reset',
			'mailbody' => 'Hello {SALUTATION},\\n\\nhere is your link for setting a new password. This link is valid for the next 24 hours.\\n\\n{LINK}\\n\\nThank you,\\nyour administrator',
		],
		'new_database_by_customer' => [
			'subject' => '[Froxlor] New database created',
			'mailbody' => 'Hello {CUST_NAME},

you have just added a new database. Here is the entered information:

Databasename: {DB_NAME}
Password: {DB_PASS}
Description: {DB_DESC}
DB-Hostname: {DB_SRV}
phpMyAdmin: {PMA_URI}
Yours sincerely, your administrator',
		],
		'new_ftpaccount_by_customer' => [
			'subject' => 'New ftp-user created',
			'mailbody' => 'Hello {CUST_NAME},

you have just added a new ftp-user. Here is the entered information:

Username: {USR_NAME}
Password: {USR_PASS}
Path: {USR_PATH}

Yours sincerely, your administrator',
		],
		'trafficmaxpercent' => [
			'mailbody' => 'Dear {SALUTATION},\\n\\nyou used {TRAFFICUSED} of your available {TRAFFIC} of traffic.\\nThis is more than {MAX_PERCENT}%%.\\n\\nYours sincerely, your administrator',
			'subject' => 'Reaching your traffic limit',
		],
		'diskmaxpercent' => [
			'mailbody' => 'Dear {SALUTATION},\\n\\nyou used {DISKUSED} of your available {DISKAVAILABLE} of diskspace.\\nThis is more than {MAX_PERCENT}%%.\\n\\nYours sincerely, your administrator',
			'subject' => 'Reaching your diskspace limit',
		],
		'2fa' => [
			'mailbody' => 'Hello,\\n\\nyour 2FA login-code is: {CODE}.\\n\\nThis is an automatically created\\ne-mail, please do not answer!\\n\\nYours sincerely, your administrator',
			'subject' => 'Froxlor - 2FA Code',
		],
	],
	'menue' => [
		'main' => [
			'main' => 'Main',
			'changepassword' => 'Change password',
			'changelanguage' => 'Change language',
			'username' => 'Logged in as: ',
			'changetheme' => 'Change theme',
			'apihelp' => 'API help',
			'apikeys' => 'API keys',
		],
		'email' => [
			'email' => 'Email',
			'emails' => 'Addresses',
			'webmail' => 'Webmail',
			'emailsoverview' => 'Email domains overview',
		],
		'mysql' => [
			'mysql' => 'MySQL',
			'databases' => 'Databases',
			'phpmyadmin' => 'phpMyAdmin',
		],
		'domains' => [
			'domains' => 'Domains',
			'settings' => 'Domains overview',
		],
		'ftp' => [
			'ftp' => 'FTP',
			'accounts' => 'Accounts',
			'webftp' => 'WebFTP',
		],
		'extras' => [
			'extras' => 'Extras',
			'directoryprotection' => 'Directory protection',
			'pathoptions' => 'Path options',
			'backup' => 'Backup',
		],
		'traffic' => [
			'traffic' => 'Traffic',
			'current' => 'Current Month',
			'overview' => 'Total traffic',
		],
		'phpsettings' => [
			'maintitle' => 'PHP Configurations',
			'fpmdaemons' => 'PHP-FPM versions',
		],
		'logger' => [
			'logger' => 'System log',
		],
	],
	'message' => [
		'norecipients' => 'No e-mail has been sent because there are no recipients in the database',
	],
	'mysql' => [
		'databasename' => 'User/Database name',
		'databasedescription' => 'Database description',
		'database_create' => 'Create database',
		'description' => 'Here you can create and change your MySQL-databases.<br />The changes are made instantly and the database can be used immediately.<br />At the menu on the left side you find the tool phpMyAdmin with which you can easily administer your database.<br /><br />To use your databases in your own php-scripts use the following settings: (The data in <i>italics</i> have to be changed into the equivalents you typed in!)<br />Hostname: <b><SQL_HOST></b><br />Username: <b><i>databasename</i></b><br />Password: <b><i>the password you\'ve chosen</i></b><br />Database: <b><i>databasename</i></b>',
		'mysql_server' => 'MySQL-Server',
		'database_edit' => 'Edit database',
		'size' => 'Size',
		'privileged_user' => 'Privileged database user',
		'privileged_passwd' => 'Password for priviliged user',
		'unprivileged_passwd' => 'Password for unprivileged user',
		'mysql_ssl_ca_file' => 'SSL server certificate',
		'mysql_ssl_verify_server_certificate' => 'Verify SSL server certificate'
	],
	'opcacheinfo' => [
		'generaltitle' => 'General Information',
		'resetcache' => 'Reset OPcache',
		'version' => 'OPCache version',
		'phpversion' => 'PHP version',
		'runtimeconf' => 'Runtime Configuration',
		'start' => 'Start time',
		'lastreset' => 'Last restart',
		'oomrestarts' => 'OOM restart count',
		'hashrestarts' => 'Hash restart count',
		'manualrestarts' => 'Manual restart count',
		'hitsc' => 'Hits count',
		'missc' => 'Miss count',
		'blmissc' => 'Blacklist miss count',
		'status' => 'Status',
		'never' => 'never',
		'enabled' => 'OPcache Enabled',
		'cachefull' => 'Cache full',
		'restartpending' => 'Pending restart',
		'restartinprogress' => 'Restart in progress',
		'cachedscripts' => 'Cached scripts count',
		'memusage' => 'Memory usage',
		'totalmem' => 'Total memory',
		'usedmem' => 'Used memory',
		'freemem' => 'Free memory',
		'wastedmem' => 'Wasted memory',
		'maxkey' => 'Maximum keys',
		'usedkey' => 'Used keys',
		'wastedkey' => 'Wasted keys',
		'strinterning' => 'String interning',
		'strcount' => 'String count',
		'keystat' => 'Cached keys statistic',
		'used' => 'Used',
		'free' => 'Free',
		'blacklist' => 'Blacklist',
		'novalue' => '<i>no value</i>',
		'true' => '<i>true</i>',
		'false' => '<i>false</i>',
		'funcsavail' => 'Available functions',
	],
	'panel' => [
		'edit' => 'Edit',
		'delete' => 'Delete',
		'create' => 'Create',
		'save' => 'Save',
		'yes' => 'Yes',
		'no' => 'No',
		'emptyfornochanges' => 'empty for no changes',
		'emptyfordefault' => 'empty for defaults',
		'path' => 'Path',
		'toggle' => 'Toggle',
		'next' => 'Next',
		'dirsmissing' => 'Can not find or read the directory!',
		'unlimited' => '∞',
		'urloverridespath' => 'URL (overrides path)',
		'pathorurl' => 'Path or URL',
		'ascending' => 'ascending',
		'descending' => 'descending',
		'search' => 'Search',
		'used' => 'used',
		'translator' => 'Translator',
		'reset' => 'Discard changes',
		'pathDescription' => 'If the directory doesn\'t exist, it will be created automatically.',
		'pathDescriptionEx' => '<br /><br /><span class="text-danger">Please note:</span> The path <code>/</code> is not allowed due to administrative settings, it will automatically be set to <code>/chosen.subdomain.tld/</code> if not set to another directory.',
		'pathDescriptionSubdomain' => 'If the directory doesn\'t exist, it will be created automatically.<br /><br />If you want a redirect to another domain than this entry has to start with http:// or https://.<br /><br />If the URL ends with / it is considered a folder, if not, it is treated as file.',
		'back' => 'Back',
		'reseller' => 'reseller',
		'admin' => 'admin',
		'customer' => 'customer/s',
		'send' => 'send',
		'nosslipsavailable' => 'There are currently no ssl ip/port combinations for this server',
		'backtooverview' => 'Back to overview',
		'dateformat' => 'YYYY-MM-DD',
		'dateformat_function' => 'Y-m-d',
		'timeformat_function' => 'H:i:s',
		'default' => 'Default',
		'never' => 'Never',
		'active' => 'Active',
		'please_choose' => 'Please choose',
		'allow_modifications' => 'Allow modifications',
		'megabyte' => 'MegaByte',
		'not_supported' => 'Not supported in: ',
		'view' => 'view',
		'toomanydirs' => 'Too many subdirectories. Falling back to manual path-select.',
		'abort' => 'Abort',
		'not_activated' => 'not activated',
		'off' => 'off',
		'options' => 'Options',
		'neverloggedin' => 'No login yet',
		'descriptionerrordocument' => 'Can be an URL, path to a file or just a string wrapped around " "<br />Leave empty to use server default value.',
		'unlock' => 'Unlock',
		'theme' => 'Theme',
		'variable' => 'Variable',
		'description' => 'Description',
		'cancel' => 'Cancel',
		'ssleditor' => 'SSL settings for this domain',
		'ssleditor_infoshared' => 'Currently using certificate of parentdomain',
		'ssleditor_infoglobal' => 'Currently using global certificate',
		'dashboard' => 'Dashboard',
		'assigned' => 'Assigned',
		'available' => 'Available',
		'news' => 'News',
		'newsfeed_disabled' => 'The newsfeed is disabled. Click the edit icon to go to the settings.',
		'ftpdesc' => 'FTP description',
		'letsencrypt' => 'Using Let\'s encrypt',
		'set' => 'Apply',
		'shell' => 'Shell',
		'backuppath' => [
			'title' => 'Destination path for the backup',
			'description' => 'This is the path where the backups will be stored. If backup of web-data is selected, all files from the homedir are stored excluding the backup-folder specified here.',
		],
		'none_value' => 'None',
		'viewlogs' => 'View logfiles',
		'not_configured' => 'System not configured yet. Click here to go to configurations.',
		'ihave_configured' => 'I have configured the services',
		'system_is_configured' => '<i class="fa-solid fa-circle-exclamation me-1"></i>System is already set as configured',
		'settings_before_configuration' => 'Please be sure you adjusted the settings prior to configuring the services here',
		'image_field_delete' => 'Delete the existing current image',
		'usage_statistics' => 'Resource usage',
		'security_question' => 'Security question',
		'listing_empty' => 'No entries found',
		'unspecified' => 'unspecified',
		'settingsmode' => 'Mode',
		'settingsmodebasic' => 'Basic',
		'settingsmodeadvanced' => 'Advanced',
		'settingsmodetoggle' => 'Click to toggle mode',
		'modalclose' => 'Close',
		'managetablecolumnsmodal' => [
			'title' => 'Manage table columns',
			'description' => 'Here you can customize the visible columns',
		],
		'mandatoryfield' => 'Field is mandatory',
		'select_all' => 'Select all',
		'unselect_all' => 'Unselect all',
		'searchtablecolumnsmodal' => [
			'title' => 'Search in fields',
			'description' => 'Select the field you want to search in'
		],
		'upload_import' => 'Upload and import',
	],
	'phpfpm' => [
		'vhost_httpuser' => 'Local user to use for PHP-FPM (Froxlor vHost)',
		'vhost_httpgroup' => 'Local group to use for PHP-FPM (Froxlor vHost)',
		'ownvhost' => [
			'title' => 'Enable PHP-FPM for the Froxlor vHost',
			'description' => 'If enabled, Froxlor will also be running under a local user',
		],
		'use_mod_proxy' => [
			'title' => 'Use mod_proxy / mod_proxy_fcgi',
			'description' => '<strong class="text-danger">Must be enabled when using Debian 9.x (Stretch) or newer</strong>. Activate to use php-fpm via mod_proxy_fcgi. Requires at least apache-2.4.9',
		],
		'ini_flags' => 'Enter possible <strong>php_flag</strong>s for php.ini. One entry per line',
		'ini_values' => 'Enter possible <strong>php_value</strong>s for php.ini. One entry per line',
		'ini_admin_flags' => 'Enter possible <strong>php_admin_flag</strong>s for php.ini. One entry per line',
		'ini_admin_values' => 'Enter possible <strong>php_admin_value</strong>s for php.ini. One entry per line',
	],
	'privacy' => 'Privacy policy',
	'pwdreminder' => [
		'success' => 'Password reset successfully requested. Please follow the instructions in the email you received.',
		'notallowed' => 'Unknown user or password reset is disabled',
		'changed' => 'Your password has been updated successfully. You can now login with your new password.',
		'wrongcode' => 'Sorry, your activation-code does not exist or has already expired.',
		'choosenew' => 'Set new password',
	],
	'question' => [
		'question' => 'Security question',
		'admin_customer_reallydelete' => 'Do you really want to delete the customer %s? This cannot be undone!',
		'admin_domain_reallydelete' => 'Do you really want to delete the domain %s?',
		'admin_domain_reallydisablesecuritysetting' => 'Do you really want to disable this security setting OpenBasedir?',
		'admin_admin_reallydelete' => 'Do you really want to delete the admin %s? Every customer and domain will be reassigned to your account.',
		'admin_template_reallydelete' => 'Do you really want to delete the template \'%s\'?',
		'domains_reallydelete' => 'Do you really want to delete the domain %s?',
		'email_reallydelete' => 'Do you really want to delete the email-address %s?',
		'email_reallydelete_account' => 'Do you really want to delete the email-account of %s?',
		'email_reallydelete_forwarder' => 'Do you really want to delete the forwarder %s?',
		'extras_reallydelete' => 'Do you really want to delete the directory protection for %s?',
		'extras_reallydelete_pathoptions' => 'Do you really want to delete the path options for %s?',
		'extras_reallydelete_backup' => 'Do you really want to abort the planned backup job?',
		'ftp_reallydelete' => 'Do you really want to delete the FTP-account %s?',
		'mysql_reallydelete' => 'Do you really want to delete the database %s? This cannot be undone!',
		'admin_configs_reallyrebuild' => 'Do you really want to rebuild all config files?',
		'admin_customer_alsoremovefiles' => 'Remove user files too?',
		'admin_customer_alsoremovemail' => 'Completely remove email data from filesystem?',
		'admin_customer_alsoremoveftphomedir' => 'Also remove FTP-user homedir?',
		'admin_ip_reallydelete' => 'Do you really want to delete the IP address %s?',
		'admin_domain_reallydocrootoutofcustomerroot' => 'Are you sure, you want the document root for this domain, not being within the customer root of the customer?',
		'admin_counters_reallyupdate' => 'Do you really want to recalculate resource usage?',
		'admin_cleartextmailpws_reallywipe' => 'Do you really want to wipe all unencrypted mail account passwords from the table mail_users? This cannot be reverted! The setting to store email passwords unencrypted will also be set to OFF',
		'logger_reallytruncate' => 'Do you really want to truncate the table "%s"?',
		'admin_quotas_reallywipe' => 'Do you really want to wipe all quotas on table mail_users? This cannot be reverted!',
		'admin_quotas_reallyenforce' => 'Do you really want to enforce the default quota to all Users? This cannot be reverted!',
		'phpsetting_reallydelete' => 'Do you really want to delete these settings? All domains which use these settings currently will be changed to the default config.',
		'fpmsetting_reallydelete' => 'Do you really want to delete these php-fpm settings? All php configurations which use these settings currently will be changed to the default config.',
		'remove_subbutmain_domains' => 'Also remove domains which are added as full domains but which are subdomains of this domain?',
		'customer_reallyunlock' => 'Do you really want to unlock customer %s?',
		'admin_integritycheck_reallyfix' => 'Do you really want to try fixing all database integrity problems automatically?',
		'plan_reallydelete' => 'Do you really want to delete the hosting plan %s?',
		'apikey_reallydelete' => 'Do you really want to delete this api-key?',
		'apikey_reallyadd' => 'Do you really want to create a new api-key?',
		'dnsentry_reallydelete' => 'Do you really want to delete this zone entry?',
		'certificate_reallydelete' => 'Do you really want to delete this certificate?',
		'cache_reallydelete' => 'Do you really want to clear the cache?',
	],
	'redirect_desc' => [
		'rc_default' => 'default',
		'rc_movedperm' => 'moved permanently',
		'rc_found' => 'found',
		'rc_seeother' => 'see other',
		'rc_tempred' => 'temporary redirect',
	],
	'serversettings' => [
		'session_timeout' => [
			'title' => 'Session Timeout',
			'description' => 'How long does a user have to be inactive before a session gets invalid (seconds)?',
		],
		'accountprefix' => [
			'title' => 'Customer prefix',
			'description' => 'Which prefix should customer accounts have?',
		],
		'mysqlprefix' => [
			'title' => 'SQL Prefix',
			'description' => 'Which prefix should MySQL accounts have?</br>Use "RANDOM" as value to get a 3-digit random prefix</br>Use "DBNAME" as the value, a database name field is used together with the customer name as a prefix.',
		],
		'ftpprefix' => [
			'title' => 'FTP Prefix',
			'description' => 'Which prefix should ftp accounts have?<br/><b>If you change this you also have to change the Quota SQL Query in your FTP Server config file in case you use it!</b> ',
		],
		'documentroot_prefix' => [
			'title' => 'Home directory',
			'description' => 'Where should all home directories be stored?',
		],
		'logfiles_directory' => [
			'title' => 'Logfiles directory',
			'description' => 'Where should all log files be stored?',
		],
		'logfiles_script' => [
			'title' => 'Custom script to pipe log-files to',
			'description' => 'You can specify a script here and use the placeholders <strong>{LOGFILE}, {DOMAIN} and {CUSTOMER}</strong> if needed. In case you want to use it you will need to activate the <strong>Pipe webserver logfiles</strong> option too. No prefixed pipe-character is needed.',
		],
		'logfiles_format' => [
			'title' => 'Access-log format',
			'description' => 'Enter a custom log-format here according to your webservers specifications, leave empty for default. Depending on your format the string must be quoted.<br/>If used with nginx, it will look like <i>log_format frx_custom {CONFIGURED_VALUE}</i>.<br/>If used with Apache, it will look like <i>LogFormat {CONFIGURED_VALUE} frx_custom</i>.<br/><strong>Attention</strong>: The code won\'t be checked for any errors. If it contains errors, webserver might not start again!',
		],
		'logfiles_type' => [
			'title' => 'Access-log type',
			'description' => 'Choose between <strong>combined</strong> or <strong>vhost_combined</strong> here.',
		],
		'logfiles_piped' => [
			'title' => 'Pipe webserver logfiles to specified script (see above)',
			'description' => 'When using a custom script for the logfiles you need to activate this in order for it to be executed',
		],
		'ipaddress' => [
			'title' => 'IP-address',
			'description' => 'What\'s the main IP-address of this server?',
		],
		'hostname' => [
			'title' => 'Hostname',
			'description' => 'What\'s the Hostname of this server?',
		],
		'apachereload_command' => [
			'title' => 'Webserver reload command',
			'description' => 'What\'s the webserver command to reload configfiles?',
		],
		'bindenable' => [
			'title' => 'Enable Nameserver',
			'description' => 'Here the Nameserver can be enabled and disabled globally.',
		],
		'bindconf_directory' => [
			'title' => 'Dns server config directory',
			'description' => 'Where should dns-server config files be saved?',
		],
		'bindreload_command' => [
			'title' => 'DNS server reload command',
			'description' => 'What\'s the command to reload the dns server daemon?',
		],
		'vmail_uid' => [
			'title' => 'Mails-UID',
			'description' => 'Which UserID should mails have?',
		],
		'vmail_gid' => [
			'title' => 'Mails-GID',
			'description' => 'Which GroupID should mails have?',
		],
		'vmail_homedir' => [
			'title' => 'Mails-homedir',
			'description' => 'Where should all mails be stored?',
		],
		'adminmail' => [
			'title' => 'Sender',
			'description' => 'What\'s the sender address for emails sent from the Panel?',
		],
		'phpmyadmin_url' => [
			'title' => 'phpMyAdmin URL',
			'description' => 'What\'s the URL to phpMyAdmin? (has to start with http(s)://)',
		],
		'webmail_url' => [
			'title' => 'Webmail URL',
			'description' => 'What\'s the URL to webmail? (has to start with http(s)://)',
		],
		'webftp_url' => [
			'title' => 'WebFTP URL',
			'description' => 'What\'s the URL to  WebFTP? (has to start with http(s)://)',
		],
		'language' => [
			'description' => 'What\'s your standard server language?',
		],
		'maxloginattempts' => [
			'title' => 'Max Login Attempts',
			'description' => 'Maximum login attempts after which the account gets disabled.',
		],
		'deactivatetime' => [
			'title' => 'Deactivation Time',
			'description' => 'Time (sec.) an account gets disabled after too many login tries.',
		],
		'pathedit' => [
			'title' => 'Type of path input',
			'description' => 'Should a path be selected by a dropdown menu or by an input field?',
		],
		'nameservers' => [
			'title' => 'Nameservers',
			'description' => 'A comma separated list containing the hostnames of all nameservers. The first one will be the primary one.',
		],
		'mxservers' => [
			'title' => 'MX servers',
			'description' => 'A comma separated list containing a pair of a number and a hostname separated by whitespace (e.g. \'10 mx.example.com\') containing the mx servers.',
		],
		'paging' => [
			'title' => 'Entries per page',
			'description' => 'How many entries shall be shown on one page? (0 = disable paging)',
		],
		'defaultip' => [
			'title' => 'Default IP/Port',
			'description' => 'Select all IP-addresses you want to use as default for new domains',
		],
		'defaultsslip' => [
			'title' => 'Default SSL IP/Port',
			'description' => 'Select all ssl-enabled IP-addresses you want to use as default for new domains',
		],
		'phpappendopenbasedir' => [
			'title' => 'Paths to append to OpenBasedir',
			'description' => 'These paths (separated by colons) will be added to the OpenBasedir-statement in every vHost-container.',
		],
		'natsorting' => [
			'title' => 'Use natural human sorting in list view',
			'description' => 'Sorts lists as web1 -> web2 -> web11 instead of web1 -> web11 -> web2.',
		],
		'deactivateddocroot' => [
			'title' => 'Docroot for deactivated users',
			'description' => 'When a user is deactivated this path is used as his docroot. Leave empty for not creating a vHost at all.',
		],
		'mailpwcleartext' => [
			'title' => 'Also save passwords of mail accounts unencrypted in database',
			'description' => 'If this is set to yes, all passwords will also be saved unencrypted (clear text, plain readable for everyone with database access) in the mail_users-table. Only activate this if you intend to use SASL!',
		],
		'ftpdomain' => [
			'title' => 'FTP accounts @domain',
			'description' => 'Customers can create FTP accounts user@customerdomain?',
		],
		'mod_fcgid' => [
			'title' => 'Enable FCGID',
			'description' => 'Use this to run PHP with the corresponding user account.<br /><br /><b>This needs a special webserver configuration for Apache, see <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/fcgid/">FCGID - handbook</a></b>',
			'configdir' => [
				'title' => 'Configuration directory',
				'description' => 'Where should all fcgid-configuration files be stored? If you don\'t use a self compiled suexec binary, which is the normal situation, this path must be under /var/www/<br /><br /><div class="text-danger">NOTE: This folder\'s content gets deleted regularly so avoid storing data in there manually.</div>',
			],
			'tmpdir' => [
				'title' => 'Temp directory',
				'description' => 'Where should the temp directories be stored',
			],
			'starter' => [
				'title' => 'Processes per domain',
				'description' => 'How many processes should be started/allowed per domain? The value 0 is recommended cause PHP will then manage the amount of processes itself very efficiently.',
			],
			'wrapper' => [
				'title' => 'Wrapper in Vhosts',
				'description' => 'How should the wrapper be included in the Vhosts',
			],
			'peardir' => [
				'title' => 'Global PEAR directories',
				'description' => 'Which global PEAR directories should be replaced in every php.ini config? Different directories must be separated by a colon.',
			],
			'maxrequests' => [
				'title' => 'Maximum Requests per domain',
				'description' => 'How many requests should be allowed per domain?',
			],
			'defaultini' => 'Default PHP configuration for new domains',
			'defaultini_ownvhost' => 'Default PHP configuration for Froxlor-vHost',
			'idle_timeout' => [
				'title' => 'Idle Timeout',
				'description' => 'Timeout setting for Mod FastCGI.',
			],
		],
		'sendalternativemail' => [
			'title' => 'Use alternative email-address',
			'description' => 'Send the password-email to a different address during email-account-creation',
		],
		'apacheconf_vhost' => [
			'title' => 'Webserver vHost configuration file/dirname',
			'description' => 'Where should the vHost configuration be stored? You could either specify a file (all vHosts in one file) or directory (each vHost in his own file) here.',
		],
		'apacheconf_diroptions' => [
			'title' => 'Webserver diroptions configuration file/dirname',
			'description' => 'Where should the diroptions configuration be stored? You could either specify a file (all diroptions in one file) or directory (each diroption in his own file) here.',
		],
		'apacheconf_htpasswddir' => [
			'title' => 'Webserver htpasswd dirname',
			'description' => 'Where should the htpasswd files for directory protection be stored?',
		],
		'mysql_access_host' => [
			'title' => 'MySQL-Access-Hosts',
			'description' => 'A comma separated list of hosts from which users should be allowed to connect to the MySQL-Server. To allow a subnet the netmask or cidr syntax is valid.',
		],
		'webalizer_quiet' => [
			'title' => 'Webalizer output',
			'description' => 'Verbosity of the webalizer-program',
		],
		'logger' => [
			'enable' => 'Logging enabled/disabled',
			'severity' => 'Logging level',
			'types' => [
				'title' => 'Log-type(s)',
				'description' => 'Specify logtypes. To select multiple types, hold down CTRL while selecting.<br />Available logtypes are: syslog, file, mysql',
			],
			'logfile' => [
				'title' => 'Filename for log',
				'description' => 'Only used if log-type includes "file". This file will be created in froxlor/logs/. This folder is protected against public access.',
			],
			'logcron' => 'Log cronjobs',
			'logcronoption' => [
				'never' => 'Never',
				'once' => 'Once',
				'always' => 'Always',
			],
		],
		'ssl' => [
			'use_ssl' => [
				'title' => 'Enable SSL usage',
				'description' => 'Check this if you want to use SSL for your webserver',
			],
			'ssl_cert_file' => [
				'title' => 'Path to the SSL certificate',
				'description' => 'Specify the path including the filename of the .crt or .pem file (main certificate)',
			],
			'openssl_cnf' => 'Defaults for creating the Cert file',
			'ssl_key_file' => [
				'title' => 'Path to the SSL Keyfile',
				'description' => 'Specify the path including the filename for the private-key file (.key mostly)',
			],
			'ssl_ca_file' => [
				'title' => 'Path to the SSL CA certificate (optional)',
				'description' => 'Client authentication, set this only if you know what it is.',
			],
			'ssl_cipher_list' => [
				'title' => 'Configure the allowed SSL ciphers',
				'description' => 'This is a list of ciphers that you want (or don\'t want) to use when talking SSL. For a list of ciphers and how to include/exclude them, see sections "CIPHER LIST FORMAT" and "CIPHER STRINGS" on <a href="https://www.openssl.org/docs/manmaster/man1/openssl-ciphers.html">the man-page for ciphers</a>.<br /><br /><b>Default value is:</b><pre>ECDH+AESGCM:ECDH+AES256:!aNULL:!MD5:!DSS:!DH:!AES128</pre>',
			],
			'apache24_ocsp_cache_path' => [
				'title' => 'Apache 2.4: path to the OCSP stapling cache',
				'description' => 'Configures the cache used to store OCSP responses which get included in TLS handshakes.',
			],
			'ssl_protocols' => [
				'title' => 'Configure the TLS protocol version',
				'description' => 'This is a list of ssl protocols that you want (or don\'t want) to use when using SSL. <b>Notice:</b> Some older browsers may not support the newest protocol versions.<br /><br /><b>Default value is:</b><pre>TLSv1.2</pre>',
			],
			'tlsv13_cipher_list' => [
				'title' => 'Configure explicit TLSv1.3 ciphers if used',
				'description' => 'This is a list of ciphers that you want (or don\'t want) to use when talking TLSv1.3. For a list of ciphers and how to include/exclude them, see <a href="https://wiki.openssl.org/index.php/TLS1.3">the docs for TLSv1.3</a>.<br /><br /><b>Default value is empty</b>',
			],
		],
		'default_vhostconf' => [
			'title' => 'Default vHost-settings',
			'description' => 'The content of this field will be included into this ip/port vHost container directly. You can use the following variables:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (if applicable)<br/> Attention: The code won\'t be checked for any errors. If it contains errors, webserver might not start again!',
		],
		'apache_globaldiropt' => [
			'title' => 'Directory options for customer-prefix',
			'description' => 'The content of this field will be included into the 05_froxlor_dirfix_nofcgid.conf apache config. If empty, the default value is used:<br><br>apache >=2.4<br><code>Require all granted<br>AllowOverride All</code><br><br>apache <=2.2<br><code>Order allow,deny<br>allow from all</code>',
		],
		'default_vhostconf_domain' => [
			'description' => 'The content of this field will be included into the domain vHost container directly. You can use the following variables:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (if applicable)<br/> Attention: The code won\'t be checked for any errors. If it contains errors, webserver might not start again!',
		],
		'decimal_places' => 'Number of decimal places in traffic/webspace output',
		'selfdns' => [
			'title' => 'Customer domain dns settings',
		],
		'selfdnscustomer' => [
			'title' => 'Allow customers to edit domain dns settings',
		],
		'unix_names' => [
			'title' => 'Use UNIX compatible usernames',
			'description' => 'Allows you to use <strong>-</strong> and <strong>_</strong> in usernames if <strong>No</strong>',
		],
		'allow_password_reset' => [
			'title' => 'Allow password reset by customers',
			'description' => 'Customers can reset their password and an activation link will be sent to their e-mail address',
		],
		'allow_password_reset_admin' => [
			'title' => 'Allow password reset by admins',
			'description' => 'Admins/reseller can reset their password and an activation link will be sent to their e-mail address',
		],
		'mail_quota' => [
			'title' => 'Mailbox-quota',
			'description' => 'The default quota for a new created mailboxes (MegaByte).',
		],
		'mail_quota_enabled' => [
			'title' => 'Use mailbox-quota for customers',
			'description' => 'Activate to use quotas on mailboxes. Default is <b>No</b> since this requires a special setup.',
			'removelink' => 'Click here to wipe all quotas for mail accounts.',
			'enforcelink' => 'Click here to enforce default quota to all User mail accounts.',
		],
		'index_file_extension' => [
			'description' => 'Which file extension should be used for the index file in newly created customer directories? This file extension will be used, if you or one of your admins has created its own index file template.',
			'title' => 'File extension for index file in newly created customer directories',
		],
		'session_allow_multiple_login' => [
			'title' => 'Allow multiple login',
			'description' => 'If activated a user could login multiple times.',
		],
		'panel_allow_domain_change_admin' => [
			'title' => 'Allow moving domains between admins',
			'description' => 'If activated you can change the admin of a domain at domainsettings.<br /><b>Attention:</b> If a customer isn\'t assigned to the same admin as the domain, the admin can see every other domain of that customer!',
		],
		'panel_allow_domain_change_customer' => [
			'title' => 'Allow moving domains between customers',
			'description' => 'If activated you can change the customer of a domain at domainsettings.<br /><b>Attention:</b> Froxlor changes the documentroot to the new customer\'s default homedir (+ domain-folder if activated)',
		],
		'specialsettingsforsubdomains' => [
			'description' => 'If yes these custom vHost-settings will be added to all subdomains; if no subdomain-specialsettings are being removed.',
		],
		'panel_password_min_length' => [
			'title' => 'Minimum password length',
			'description' => 'Here you can set a minimum length for passwords. \'0\' means: no minimum length required.',
		],
		'system_store_index_file_subs' => [
			'title' => 'Store default index file also to new subfolders',
			'description' => 'If enabled, the default index-file is being stored to every subdomain-path newly created (not if the folder already exists!)',
		],
		'adminmail_return' => [
			'title' => 'Reply-To address',
			'description' => 'Define an e-mail address as reply-to-address for mails sent by the panel.',
		],
		'adminmail_defname' => 'Panel e-mail sender name',
		'stdsubdomainhost' => [
			'title' => 'Customer standard subdomain',
			'description' => 'What hostname should be used to create standard subdomains for customer. If empty, the system-hostname is used.',
		],
		'awstats_path' => 'Path to AWStats \'awstats_buildstaticpages.pl\'',
		'awstats_conf' => 'AWStats configuration path',
		'defaultttl' => 'Domain TTL for bind in seconds (default \'604800\' = 1 week)',
		'defaultwebsrverrhandler_enabled' => 'Enable default errordocuments for all customers',
		'defaultwebsrverrhandler_err401' => [
			'title' => 'File/URL for error 401',
			'description' => '<div class="text-danger">Not supported in: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err403' => [
			'title' => 'File/URL for error 403',
			'description' => '<div class="text-danger">Not supported in: lighttpd</div>',
		],
		'defaultwebsrverrhandler_err404' => 'File/URL for error 404',
		'defaultwebsrverrhandler_err500' => [
			'title' => 'File/URL for error 500',
			'description' => '<div class="text-danger">Not supported in: lighttpd</div>',
		],
		'ftpserver' => [
			'desc' => 'If pureftpd is selected the .ftpquota files for user quotas are created and updated daily',
		],
		'customredirect_enabled' => [
			'title' => 'Allow customer redirects',
			'description' => 'Allow customers to choose the http-status code for redirects which will be used',
		],
		'customredirect_default' => [
			'title' => 'Default redirect',
			'description' => 'Set the default redirect-code which should be used if the customer does not set it himself',
		],
		'mail_also_with_mxservers' => 'Create mail-, imap-, pop3- and smtp-"A record" also with MX-Servers set',
		'froxlordirectlyviahostname' => 'Access Froxlor directly via the hostname',
		'panel_password_regex' => [
			'title' => 'Regular expression for passwords',
			'description' => 'Here you can set a regular expression for passwords-complexity.<br />Empty = no specific requirement',
		],
		'perl_path' => [
			'title' => 'Path to perl',
			'description' => 'Default is /usr/bin/perl',
		],
		'mod_fcgid_ownvhost' => [
			'title' => 'Enable FCGID for the Froxlor vHost',
			'description' => 'If enabled, Froxlor will also be running under a local user',
		],
		'perl' => [
			'suexecworkaround' => [
				'title' => 'Enable SuExec workaround',
				'description' => 'Enable only if customer docroots are not within the apache suexec path.<br />If enabled, Froxlor will generate a symlink from the customers perl-enabled directory + /cgi-bin/ to the given path.<br />Note that perl will then only work in the folders subdirectory /cgi-bin/ and not in the folder itself (as it does without this fix!)',
			],
			'suexeccgipath' => [
				'title' => 'Path for customer perl-enabled directory symlinks',
				'description' => 'You only need to set this if the SuExec-workaround is enabled.<br />ATTENTION: Be sure this path is within the suexec path or else this workaround is useless',
			],
		],
		'awstats_awstatspath' => 'Path to AWStats \'awstats.pl\'',
		'awstats_icons' => [
			'title' => 'Path to AWstats icons folder',
			'description' => 'e.g. /usr/share/awstats/htdocs/icon/',
		],
		'login_domain_login' => 'Allow login with domains',
		'perl_server' => [
			'title' => 'Perl server socket location',
			'description' => 'A simple guide can be found at: <a target="blank" href="https://www.nginx.com/resources/wiki/start/topics/examples/fcgiwrap/">nginx.com</a>',
		],
		'nginx_php_backend' => [
			'title' => 'Nginx PHP backend',
			'description' => 'this is where the PHP process is listening for requests from nginx, can be a unix socket of ip:port combination<br />*NOT used with php-fpm',
		],
		'phpreload_command' => [
			'title' => 'PHP reload command',
			'description' => 'this is used to reload the PHP backend if any is used<br />Default: blank<br />*NOT used with php-fpm',
		],
		'phpfpm' => [
			'title' => 'Enable php-fpm',
			'description' => '<b>This needs a special webserver configuration see <a target="_blank" href="https://docs.froxlor.org/latest/admin-guide/configuration/php-fpm/">PHP-FPM handbook</a></b>',
		],
		'phpfpm_settings' => [
			'configdir' => 'Configuration directory of php-fpm',
			'aliasconfigdir' => 'Configuration Alias-directory of php-fpm',
			'reload' => 'php-fpm restart command',
			'pm' => 'Process manager control (pm)',
			'max_children' => [
				'title' => 'The number of child processes',
				'description' => 'The number of child processes to be created when pm is set to \'static\' and the maximum number of child processes to be created when pm is set to \'dynamic/ondemand\'<br />Equivalent to the PHP_FCGI_CHILDREN',
			],
			'start_servers' => [
				'title' => 'The number of child processes created on startup',
				'description' => 'Note: Used only when pm is set to \'dynamic\'',
			],
			'min_spare_servers' => [
				'title' => 'The desired minimum number of idle server processes',
				'description' => 'Note: Used only when pm is set to \'dynamic\'<br />Note: Mandatory when pm is set to \'dynamic\'',
			],
			'max_spare_servers' => [
				'title' => 'The desired maximum number of idle server processes',
				'description' => 'Note: Used only when pm is set to \'dynamic\'<br />Note: Mandatory when pm is set to \'dynamic\'',
			],
			'max_requests' => [
				'title' => 'Requests per child before respawning',
				'description' => 'For endless request processing specify \'0\'. Equivalent to PHP_FCGI_MAX_REQUESTS.',
			],
			'idle_timeout' => [
				'title' => 'Idle Timeout',
				'description' => 'Timeout setting for PHP FPM FastCGI.',
			],
			'ipcdir' => [
				'title' => 'FastCGI IPC directory',
				'description' => 'The directory where the php-fpm sockets will be stored by the webserver.<br />This directory has to be readable for the webserver',
			],
			'limit_extensions' => [
				'title' => 'Allowed extensions',
				'description' => 'Limits the extensions of the main script FPM will allow to parse. This can prevent configuration mistakes on the web server side. You should only limit FPM to .php extensions to prevent malicious users to use other extensions to execute php code. Default value: .php',
			],
			'envpath' => 'Paths to add to the PATH environment. Leave empty for no PATH environment variable',
			'override_fpmconfig' => 'Override FPM-daemon settings (pm, max_children, etc.)',
			'override_fpmconfig_addinfo' => '<br /><span class="text-danger">Only used if "Override FPM-daemon settings" is set to "Yes"</span>',
			'restart_note' => 'Attention: The config won\'t be checked for any errors. If it contains errors, PHP-FPM might not start again!',
			'custom_config' => [
				'title' => 'Custom configuration',
				'description' => 'Add custom configuration to each PHP-FPM version instance, for example <i>pm.status_path = /status</i> for monitoring. Variables below can be used here.  <strong>Attention: The config won\'t be checked for any errors. If it contains errors, PHP-FPM might not start again!</strong>',
			],
			'allow_all_customers' => [
				'title' => 'Assign this configuration to all currently existing customers',
				'description' => 'Set this to "true" if you want to assign this configuration to all currently existing customers so it can be used by them. This setting is not permanent but can be run multiple times.',
			],
		],
		'report' => [
			'report' => 'Enable sending of reports about web- and traffic-usage',
			'webmax' => [
				'title' => 'Warning-level in percent for webspace',
				'description' => 'Valid values are 0 up to 150. Setting this value to 0 disables this report.',
			],
			'trafficmax' => [
				'title' => 'Warning-level in percent for traffic',
				'description' => 'Valid values are 0 up to 150. Setting this value to 0 disables this report.',
			],
		],
		'dropdown' => 'Dropdown',
		'manual' => 'Manual',
		'default_theme' => 'Default theme',
		'validate_domain' => 'Validate domain names',
		'diskquota_enabled' => 'Quota activated?',
		'diskquota_repquota_path' => [
			'description' => 'Path to repquota',
		],
		'diskquota_quotatool_path' => [
			'description' => 'Path to quotatool',
		],
		'diskquota_customer_partition' => [
			'description' => 'Partition, on which the customer files are stored',
		],
		'vmail_maildirname' => [
			'title' => 'Maildir name',
			'description' => 'Maildir directory into user\'s account. Normally \'Maildir\', in some implementations \'.maildir\', and directly into user\'s directory if left blank.',
		],
		'catchall_enabled' => [
			'title' => 'Use Catchall',
			'description' => 'Do you want to provide your customers the catchall-feature?',
		],
		'apache_24' => [
			'title' => 'Use modifications for Apache 2.4',
			'description' => '<strong class="text-danger">ATTENTION:</strong> use only if you actually have apache version 2.4 or higher installed<br />otherwise your webserver will not be able to start',
		],
		'nginx_fastcgiparams' => [
			'title' => 'Path to fastcgi_params file',
			'description' => 'Specify the path to nginx\'s fastcgi_params file including filename',
		],
		'documentroot_use_default_value' => [
			'title' => 'Use domain name as default value for DocumentRoot path',
			'description' => 'If enabled and DocumentRoot path is empty, default value will be the (sub)domain name.<br /><br />Examples: <br />/var/customers/customer_name/example.com/<br />/var/customers/customer_name/subdomain.example.com/',
		],
		'panel_phpconfigs_hidesubdomains' => [
			'title' => 'Hide subdomains in PHP-configuration overview',
			'description' => 'If activated the subdomains of customers will not be listed in the php-configurations overview, only the number of subdomains is shown.<br /><br />Note: This is only visible if you have enabled FCGID or PHP-FPM',
		],
		'panel_phpconfigs_hidestdsubdomain' => [
			'title' => 'Hide standard-subdomains in PHP-configuration overview',
			'description' => 'If activated the standard-subdomains for customers will not be displayed in the php-configurations overview<br /><br />Note: This is only visible if you have enabled FCGID or PHP-FPM',
		],
		'passwordcryptfunc' => [
			'title' => 'Choose which password-crypt method is to be used',
		],
		'systemdefault' => 'System default',
		'panel_allow_theme_change_admin' => 'Allow admins to change the theme',
		'panel_allow_theme_change_customer' => 'Allow customers to change the theme',
		'axfrservers' => [
			'title' => 'AXFR servers',
			'description' => 'A comma separated list of IP addresses allowed to transfer (AXFR) dns zones.',
		],
		'powerdns_mode' => [
			'title' => 'PowerDNS Operation Mode',
			'description' => 'Select the PoweDNS mode: Native for no replication (Default) / Master if DNS replication is needed.',
		],
		'customerssl_directory' => [
			'title' => 'Webserver customer-ssl certificates-directory',
			'description' => 'Where should customer-specified ssl-certificates be created?<br /><br /><div class="text-danger">NOTE: This folder\'s content gets deleted regularly so avoid storing data in there manually.</div>',
		],
		'allow_error_report_admin' => [
			'title' => 'Allow administrators/resellers to report database-errors to Froxlor',
			'description' => 'Please note: Never send any personal (customer-)data to us!',
		],
		'allow_error_report_customer' => [
			'title' => 'Allow customers to report database-errors to Froxlor',
			'description' => 'Please note: Never send any personal (customer-)data to us!',
		],
		'mailtraffic_enabled' => [
			'title' => 'Analyse mail traffic',
			'description' => 'Enable analysing of mailserver logs to calculate the traffic',
		],
		'mdaserver' => [
			'title' => 'MDA type',
			'description' => 'Type of the Mail Delivery Server',
		],
		'mdalog' => [
			'title' => 'MDA log',
			'description' => 'Logfile of the Mail Delivery Server',
		],
		'mtaserver' => [
			'title' => 'MTA type',
			'description' => 'Type of the Mail Transfer Agent',
		],
		'mtalog' => [
			'title' => 'MTA log',
			'description' => 'Logfile of the Mail Transfer Agent',
		],
		'system_cronconfig' => [
			'title' => 'Cron configuration file',
			'description' => 'Path to the cron-service configuration-file. This file will be updated regularly and automatically by froxlor.<br />Note: Please <b>be sure</b> to use the same filename as for the main froxlor cronjob (default: /etc/cron.d/froxlor)!<br><br>If you are using <b>FreeBSD</b>, please specify <i>/etc/crontab</i> here!',
		],
		'system_crondreload' => [
			'title' => 'Cron-daemon reload command',
			'description' => 'Specify the command to execute in order to reload your systems cron-daemon',
		],
		'system_croncmdline' => [
			'title' => 'Cron execution command (php-binary)',
			'description' => 'Command to execute our cronjobs. Change this only if you know what you are doing (default: "/usr/bin/nice -n 5 /usr/bin/php -q")!',
		],
		'system_cron_allowautoupdate' => [
			'title' => 'Allow automatic database updates',
			'description' => '<div class="text-danger"><b>ATTENTION:</b></div> This settings allows the cronjob to bypass the version-check of froxlors files and database and runs the database-updates in case a version-mismatch occurs.<br><br><div class="text-danger">Auto-update will always set default values for new settings or changes. This might not always suite your system. Please think twice before activating this option</div>',
		],
		'dns_createhostnameentry' => 'Create bind-zone/config for system hostname',
		'panel_password_alpha_lower' => [
			'title' => 'Lowercase character',
			'description' => 'Password must contain at least one lowercase letter (a-z).',
		],
		'panel_password_alpha_upper' => [
			'title' => 'Uppercase character',
			'description' => 'Password must contain at least one  uppercase letter (A-Z).',
		],
		'panel_password_numeric' => [
			'title' => 'Numbers',
			'description' => 'Password must contain at least one number (0-9).',
		],
		'panel_password_special_char_required' => [
			'title' => 'Special character',
			'description' => 'Password must contain at least one of the characters defined below.',
		],
		'panel_password_special_char' => [
			'title' => 'Special characters list',
			'description' => 'One of these characters is required if the above option is set.',
		],
		'apache_itksupport' => [
			'title' => 'Use modifications for Apache ITK-MPM',
			'description' => '<strong class="text-danger">ATTENTION:</strong> use only if you actually have apache itk-mpm enabled<br />otherwise your webserver will not be able to start',
		],
		'letsencryptca' => [
			'title' => 'ACME environment',
			'description' => 'Environment to be used for Let\'s Encrypt / ZeroSSL certificates.',
		],
		'letsencryptchallengepath' => [
			'title' => 'Path for Let\'s Encrypt challenges',
			'description' => 'Directory where the Let\'s Encrypt challenges should be offered from via a global alias.',
		],
		'letsencryptkeysize' => [
			'title' => 'Key size for new Let\'s Encrypt certificates',
			'description' => 'Size of the key in Bits for new Let\'s Encrypt certificates.',
		],
		'letsencryptreuseold' => [
			'title' => 'Re-use Let\'s Encrypt key',
			'description' => 'If activated, the same key will be used for every renew, otherwise a new key will be generated every time.',
		],
		'leenabled' => [
			'title' => 'Enable Let\'s Encrypt',
			'description' => 'If activated, customers are able to let froxlor automatically generate and renew Let\'s Encrypt ssl-certificates for domains with a ssl IP/port.<br /><br />Please remember that you need to go through the webserver-configuration when enabled because this feature needs a special configuration.',
		],
		'caa_entry' => [
			'title' => 'Generate CAA DNS records',
			'description' => 'Automatically generates CAA records for SSL-enabled domains that are using Let\'s Encrypt',
		],
		'caa_entry_custom' => [
			'title' => 'Additional CAA DNS records',
			'description' => 'DNS Certification Authority Authorization (CAA) is an Internet security policy mechanism which allows domain name holders to indicate to certificate authorities<br>whether they are authorized to issue digital certificates for a particular domain name. It does this by means of a new "CAA" Domain Name System (DNS) resource record.<br><br>The content of this field will be included into the DNS zone directly (each line results in a CAA record).<br>If Let\'s Encrypt is enabled for this domain, this entry will always be added automatically and does not need to be added manually:<br><code>0 issue "letsencrypt.org"</code> (If domain is a wildcard domain, issuewild will be used instead).<br>To enable Incident Reporting, you can add an <code>iodef</code> record. An example for sending such report to <code>me@example.com</code> would be:<br><code>0 iodef "mailto:me@example.com"</code><br><br><strong>Attention:</strong> The code won\'t be checked for any errors. If it contains errors, your CAA records might not work!',
		],
		'backupenabled' => [
			'title' => 'Enable backup for customers',
			'description' => 'If activated, the customer will be able to schedule backup jobs (cron-backup) which generates an archive within his docroot (subdirectory chosable by customer)',
		],
		'dnseditorenable' => [
			'title' => 'Enable DNS editor',
			'description' => 'Allows admins and customer to manage domain dns entries',
		],
		'dns_server' => [
			'title' => 'DNS server daemon',
			'description' => 'Remember that daemons have to be configured using froxlors configuration templates',
		],
		'panel_customer_hide_options' => [
			'title' => 'Hide menu items and traffic charts in customer panel',
			'description' => 'Select items to hide in customer panel. To select multiple options, hold down CTRL while selecting.',
		],
		'allow_allow_customer_shell' => [
			'title' => 'Allow customers to enable shell access for ftp-users',
			'description' => '<strong class="text-danger">Please note: Shell access allows the user to execute various binaries on your system. Use with extrem caution. Please only activate this if you REALLY know what you are doing!!!</strong>',
		],
		'available_shells' => [
			'title' => 'List of available shells',
			'description' => 'Comma separated list of shells that are available for the customer to chose from for their ftp-users.<br><br>Note that the default shell <strong>/bin/false</strong> will always be a choice (if enabled), even if this setting is empty. It is the default value for ftp-users in any case',
		],
		'le_froxlor_enabled' => [
			'title' => 'Enable Let\'s Encrypt for the froxlor vhost',
			'description' => 'If activated, the froxlor vhost will automatically be secured using a Let\'s Encrypt certificate.',
		],
		'le_froxlor_redirect' => [
			'title' => 'Enable SSL-redirect for the froxlor vhost',
			'description' => 'If activated, all http requests to your froxlor will be redirected to the corresponding SSL site.',
		],
		'option_unavailable_websrv' => '<br><em class="text-danger">Available only for: %s</em>',
		'option_unavailable' => '<br><em class="text-danger">Option not available due to other settings.</em>',
		'letsencryptacmeconf' => [
			'title' => 'Path to the acme.conf snippet',
			'description' => 'File name of the config snippet which allows the web server to serve the acme challenge.',
		],
		'mail_use_smtp' => 'Set mailer to use SMTP',
		'mail_smtp_host' => 'Specify SMTP server',
		'mail_smtp_usetls' => 'Enable TLS encryption',
		'mail_smtp_auth' => 'Enable SMTP authentication',
		'mail_smtp_port' => 'TCP port to connect to',
		'mail_smtp_user' => 'SMTP username',
		'mail_smtp_passwd' => 'SMTP password',
		'http2_support' => [
			'title' => 'HTTP2 Support',
			'description' => 'enable HTTP2 support for ssl.<br><em class="text-danger">ENABLE ONLY IF YOUR WEBSERVER SUPPORTS THIS FEATURE (nginx version 1.9.5+, apache2 version 2.4.17+)</em>',
		],
		'nssextrausers' => [
			'title' => 'Use libnss-extrausers instead of libnss-mysql',
			'description' => 'Do not read users from the database but from files. Please only activate if you have already gone through the required configuration steps (system -> libnss-extrausers).<br><strong class="text-danger">For Debian/Ubuntu only (or if you have compiled libnss-extrausers yourself!)</strong>',
		],
		'le_domain_dnscheck' => [
			'title' => 'Validate DNS of domains when using Let\'s Encrypt',
			'description' => 'If activated, froxlor will validate whether the domain which requests a Let\'s Encrypt certificate resolves to at least one of the system ip addresses.',
		],
		'le_domain_dnscheck_resolver' => [
			'title' => 'Use a external nameserver for DNS validation',
			'description' => 'If set, froxlor will use this DNS to validate the DNS of domains when using Let\'s Encrypt. If empty, the system\'s default DNS resolver will be used.',
		],
		'phpsettingsforsubdomains' => [
			'description' => 'If yes the chosen php-config will be updated to all subdomains',
		],
		'leapiversion' => [
			'title' => 'Choose Let\'s Encrypt ACME implementation',
			'description' => 'Currently only ACME v2 implementation for Let\'s Encrypt is supported.',
		],
		'enable_api' => [
			'title' => 'Enable external API usage',
			'description' => 'In order to use the froxlor API you need to activate this option. For more detailed information see <a href="https://docs.froxlor.org/latest/api-guide/" target="_new">https://docs.froxlor.org/</a>',
		],
		'api_customer_default' => '"Allow API access" default value for new customers',
		'dhparams_file' => [
			'title' => 'DHParams file (Diffie–Hellman key exchange)',
			'description' => 'If a dhparams.pem file is specified here it will be included in the webserver configuration. Leave empty to disable.<br>Example: /etc/ssl/webserver/dhparams.pem<br><br>If the file does not exist, it will be created automatically with the following command: <code>openssl dhparam -out /etc/ssl/webserver/dhparams.pem 4096</code>. It is recommended to create the file prior to specifying it here as the creation takes quite a while and blocks the cronjob.',
		],
		'errorlog_level' => [
			'title' => 'Error log-level',
			'description' => 'Specify the error log level. Default is "warn" for apache-users and "error" for nginx-users.',
		],
		'letsencryptecc' => [
			'title' => 'Issue ECC / ECDSA certificate',
			'description' => 'If set to a valid key-size the certificate issued will use ECC / ECDSA',
		],
		'froxloraliases' => [
			'title' => 'Domain aliases for froxlor vhost',
			'description' => 'Comma separated list of domains to add as server alias to the froxlor vhost',
		],
		'default_sslvhostconf' => [
			'title' => 'Default SSL vHost-settings',
			'description' => 'The content of this field will be included into this ip/port vHost container directly. You can use the following variables:<br/><code>{DOMAIN}</code>, <code>{DOCROOT}</code>, <code>{CUSTOMER}</code>, <code>{IP}</code>, <code>{PORT}</code>, <code>{SCHEME}</code>, <code>{FPMSOCKET}</code> (if applicable)<br/> Attention: The code won\'t be checked for any errors. If it contains errors, webserver might not start again!',
		],
		'includedefault_sslvhostconf' => 'Include non-SSL vHost-settings in SSL-vHost',
		'apply_specialsettings_default' => [
			'title' => 'Default value for "Apply specialsettings to all subdomains (*.example.com)\' setting when editing a domain',
		],
		'apply_phpconfigs_default' => [
			'title' => 'Default value for "Apply php-config to all subdomains:\' setting when editing a domain',
		],
		'awstats' => [
			'logformat' => [
				'title' => 'LogFormat setting',
				'description' => 'If you use customized logformat for your webserver, you need change the awstats LogFormat too.<br/>Default is 1. For more information check documentation <a target="_blank" href="https://awstats.sourceforge.io/docs/awstats_config.html#LogFormat">here</a>.',
			],
		],
		'hide_incompatible_settings' => 'Hide incompatible settings',
		'soaemail' => 'Mail address to use in SOA records (defaults to sender address from panel settings if empty)',
		'imprint_url' => [
			'title' => 'URL to legal notes / imprint',
			'description' => 'Specify an URL to your legal notes / imprint site. The link will be visible on the login screen and on the footer when logged in.',
		],
		'terms_url' => [
			'title' => 'URL to terms of use',
			'description' => 'Specify an URL to your terms of use site. The link will be visible on the login screen and on the footer when logged in.',
		],
		'privacy_url' => [
			'title' => 'URL to privacy policy',
			'description' => 'Specify an URL to your privacy policy site / imprint site. The link will be visible on the login screen and on the footer when logged in.',
		],
		'logo_image_header' => [
			'title' => 'Logo Image (Header)',
			'description' => 'Upload your own logo image to be shown in the header after login (recommended height 30px)',
		],
		'logo_image_login' => [
			'title' => 'Logo Image (Login)',
			'description' => 'Upload your own logo image to be shown during login',
		],
		'logo_overridetheme' => [
			'title' => 'Overwrites logo defined in theme by "Logo Image" (Header and Login, see below)',
			'description' => 'This needs to be set to "true" if you intend to use your uploaded logo; alternatively you can still use the theme-based "logo_custom.png" and "logo_custom_login.png" possibility.',
		],
		'logo_overridecustom' => [
			'title' => 'Overwrite custom logo (logo_custom.png and logo_custom_login.png) defined in theme by "Logo Image" (Header and Login, see below)',
			'description' => 'Set this to "true" if you want to ignore theme-specific custom logos for header and login and use "Logo Image"',
		],
		'createstdsubdom_default' => [
			'title' => 'Preselected value for "Create standard subdomain" when creating a customer',
			'description' => '',
		],
		'froxlorusergroup' => [
			'title' => 'Custom system group for all customer users',
			'description' => 'Usage of libnss-extrausers (system-settings) is required for this to take effect. An empty value skips creation or removes existing group.',
		],
		'acmeshpath' => [
			'title' => 'Path to acme.sh',
			'description' => 'Set this to where acme.sh is installed to, including the acme.sh script<br>Default is <b>/root/.acme.sh/acme.sh</b>',
		],
		'update_channel' => [
			'title' => 'froxlor update-channel',
			'description' => 'Select the update channel of froxlor. Default is "stable"',
		],
		'uc_stable' => 'stable',
		'uc_testing' => 'testing',
		'traffictool' => [
			'toolselect' => 'Traffic analyzer',
			'webalizer' => 'Webalizer',
			'awstats' => 'AWStats',
			'goaccess' => 'goacccess'
		],
		'requires_reconfiguration' => 'Changing this settings might require a reconfiguration of the following services:<br><strong>%s</strong>',
	],
	'spf' => [
		'use_spf' => 'Activate SPF for domains?',
		'spf_entry' => 'SPF entry for all domains',
	],
	'ssl_certificates' => [
		'certificate_for' => 'Certificate for',
		'valid_from' => 'Valid from',
		'valid_until' => 'Valid until',
		'issuer' => 'Issuer',
	],
	'success' => [
		'messages_success' => 'Successfully sent message to %s recipients',
		'success' => 'Information',
		'clickheretocontinue' => 'Click here to continue',
		'settingssaved' => 'The settings have been successfully saved.',
		'rebuildingconfigs' => 'Successfully inserted tasks for rebuild configfiles',
		'domain_import_successfully' => 'Successfully imported %s domains.',
		'backupscheduled' => 'Your backup job has been scheduled. Please wait for it to be processed',
		'backupaborted' => 'Your scheduled backup has been cancelled',
		'dns_record_added' => 'Record added successfully',
		'dns_record_deleted' => 'Record deleted successfully',
		'testmailsent' => 'Test mail sent successfully',
		'settingsimported' => 'Settings imported successfully',
		'sent_error_report' => 'Succesfully sent error report. Thank you for your contribution.',
	],
	'tasks' => [
		'outstanding_tasks' => 'Pending cron-tasks',
		'REBUILD_VHOST' => 'Rebuilding webserver-configuration',
		'CREATE_HOME' => 'Adding new customer %s',
		'REBUILD_DNS' => 'Rebuilding bind-configuration',
		'CREATE_FTP' => 'Creating directory for new ftp-user',
		'DELETE_CUSTOMER_FILES' => 'Deleting customer-files %s',
		'noneoutstanding' => 'There are currently no outstanding tasks for Froxlor',
		'CREATE_QUOTA' => 'Set quota on filesystem',
		'DELETE_EMAIL_DATA' => 'Delete customer e-mail data.',
		'DELETE_FTP_DATA' => 'Delete customer ftp-account data.',
		'REBUILD_CRON' => 'Rebuilding the cron.d-file',
		'CREATE_CUSTOMER_BACKUP' => 'Backup job for customer %s',
		'DELETE_DOMAIN_PDNS' => 'Delete domain %s from PowerDNS database',
		'DELETE_DOMAIN_SSL' => 'Delete ssl files of domain %s',
	],
	'terms' => 'Terms of use',
	'traffic' => [
		'month' => 'Month',
		'day' => 'Day',
		'months' => [
			1 => 'January',
			2 => 'February',
			3 => 'March',
			4 => 'April',
			5 => 'May',
			6 => 'June',
			7 => 'July',
			8 => 'August',
			9 => 'September',
			10 => 'October',
			11 => 'November',
			12 => 'December',
			'jan' => 'Jan',
			'feb' => 'Feb',
			'mar' => 'Mar',
			'apr' => 'Apr',
			'may' => 'May',
			'jun' => 'Jun',
			'jul' => 'Jul',
			'aug' => 'Aug',
			'sep' => 'Sep',
			'oct' => 'Oct',
			'nov' => 'Nov',
			'dec' => 'Dec',
			'total' => 'Total',
		],
		'mb' => 'Traffic',
		'sumtotal' => 'Total traffic',
		'sumhttp' => 'HTTP traffic',
		'sumftp' => 'FTP traffic',
		'summail' => 'Mail traffic',
		'customer' => 'Customer',
		'domain' => 'Domain',
		'trafficoverview' => 'Traffic summary',
		'bycustomers' => 'Traffic by customers',
		'details' => 'Details',
		'http' => 'HTTP',
		'ftp' => 'FTP',
		'mail' => 'Mail',
		'nocustomers' => 'You need at least one customer to view the traffic reports.',
		'top5customers' => 'Top 5 customers',
		'nodata' => 'No data for given range found.',
		'ranges' => [
			'last24h' => 'last 24 hours',
			'last7d' => 'last 7 days',
			'last30d' => 'last 30 days',
			'cm' => 'Current month',
			'last3m' => 'last 3 months',
			'last6m' => 'last 6 months',
			'last12m' => 'last 12 months',
			'cy' => 'Current year',
		],
		'byrange' => 'Specified by range',
	],
	'translator' => '',
	'update' => [
		'updateinprogress_onlyadmincanlogin' => 'A newer version of Froxlor has been installed but not yet set up.<br />Only the administrator can log in and finish the update.',
		'update' => 'Froxlor update',
		'proceed' => 'Proceed',
		'update_information' => [
			'part_a' => 'The Froxlor files have been updated to version <strong>%s</strong>. The installed version is <strong>%s</strong>.',
			'part_b' => '<br /><br />Customers will not be able to log in until the update has been finished.<br /><strong>Proceed?</strong>',
		],
		'noupdatesavail' => 'You already have the latest %sversion of Froxlor installed.',
		'description' => 'Running database updates for your froxlor installation',
		'uc_newinfo' => 'There is a newer %sversion available: "%s" (Your current version is: %s)',
		'notify_subject' => 'New update available',
	],
	'usersettings' => [
		'custom_notes' => [
			'title' => 'Custom notes',
			'description' => 'Feel free to put any notes you want/need in here. They will show up in the admin/customer overview for the corresponding user.',
			'show' => 'Show your notes on the dashboard of the user',
		],
		'api_allowed' => [
			'title' => 'Allow API access',
			'description' => 'When enabled in the settings, this user can create API keys and access the froxlor API',
			'notice' => 'API access is not allowed for your account.',
		],
	],
	'install' => [
		'slogal' => 'froxlor Server Management Panel',
		'preflight' => 'System check',
		'critical_error' => 'Critical error',
		'suggestions' => 'Not required but recommended',
		'phpinfosuccess' => 'Your system is running with PHP %s',
		'phpinfowarn' => 'Your system is running a lower version than PHP %s',
		'phpinfoupdate' => 'Update your current PHP version from %s to %s or higher',
		'start_installation' => 'Start installation',
		'check_again' => 'Reload to check again',
		'switchmode_advanced' => 'Show advanced options',
		'switchmode_basic' => 'Hide advanced options',
		'dependency_check' => [
			'title' => 'Welcome to froxlor',
			'description' => 'We check the system for dependencies to ensure that all required php extensions and modules are enabled so that froxlor runs properly.',
		],
		'database' => [
			'top' => 'Database',
			'title' => 'Create database and user',
			'description' => 'Froxlor requires a database and additionally a privileged user to be able to create users and databases (GRANT option). The given database and unprivileged database-user will be created in this process. The privileged user must exist.',
			'user' => 'Unprivileged database user',
			'dbname' => 'Database name',
			'force_create' => 'Backup and overwrite database if exists?',
		],
		'admin' => [
			'top' => 'Admin user',
			'title' => 'Let\'s create the main administrator user.',
			'description' => 'This user will be granted all privileges to adjust settings and add/update/delete resources like customers, domains, etc.',
		],
		'system' => [
			'top' => 'System setup',
			'title' => 'Details about your server',
			'description' => 'Set your environment as well as server relevant data and options here to let froxlor know about your system. These values are crucial for the system configuration and operating.',
			'ipv4' => 'Primary IPv4 address (if applicable)',
			'ipv6' => 'Primary IPv6 address (if applicable)',
			'servername' => 'Server name (FQDN, no ip-address)',
			'phpbackend' => 'PHP backend',
			'activate_newsfeed' => 'Enable the official newsfeed<br><small>(external source: https://inside.froxlor.org/news/)</small>',
		],
		'install' => [
			'top' => 'Finish setup',
			'title' => 'One last step...',
			'description' => 'The command below will download, install and configure required services on your system according to the data you have given in this installation process.',
			'runcmd' => 'Run the following command as root-user in your shell on this server:',
			'manual_config' => 'I will manually configure the services, just take me to the login',
			'waitforconfig' => 'Waiting for services to be configured...',
		],
		'errors' => [
			'wrong_ownership' => 'Make sure the froxlor files are owned by %s:%s',
			'missing_extensions' => 'The following php extensions are required and not installed',
			'suggestedextensions' => 'The following php extensions could not be found but are recommended',
			'databaseexists' => 'Database already exist, please set override option to rebuild or chose another name',
			'unabletocreatedb' => 'Test database could not be created',
			'unabletodropdb' => 'Test database could not be dropped',
			'mysqlusernameexists' => 'The user specified for unprivileged user already exist. Please use another username or delete it first.',
			'unabletocreateuser' => 'Test user could not be created',
			'unabletodropuser' => 'Test user could not be dropped',
			'unabletoflushprivs' => 'Given privileged user is unable to flush privileges',
			'nov4andnov6ip' => 'Either IPv4- or IPv6-address must be given',
			'servernameneedstobevalid' => 'Given servername does not seem to be a FQDN or hostname',
			'websrvuserdoesnotexist' => 'Given webserver-user does not seem to exist on the system',
			'websrvgrpdoesnotexist' => 'Given webserver-group does not seem to exist on the system',
			'notyetconfigured' => 'It seems that the services were not yet configured (successfully). Please either run the command shown below or check the box to do it later.',
			'mandatory_field_not_set' => 'Mandatory field "%s" is not set!',
			'unexpected_database_error' => 'Unexpected database exception occurred. %s',
			'sql_import_failed' => 'Failed to import SQL data!',
			'unprivileged_sql_connection_failed' => 'Failed to initialize unprivileged SQL connection!',
			'privileged_sql_connection_failed' => 'Failed to initialize privileged SQL connection!',
			'mysqldump_backup_failed' => 'Cannot create a database backup, we got an error from mysqldump.',
			'sql_backup_file_missing' => 'Cannot create a database backup, the backup file does not exist.',
			'backup_binary_missing' => 'Cannot create a database backup, make sure you installed mysqldump.',
			'creating_configfile_failed' => 'Cannot create config files, unable to write file.',
			'database_already_exiting' => 'We found a database and were not allow to override it!'
		]
	],
	'welcome' => [
		'title' => 'Welcome to froxlor!',
		'config_note' => 'In order for froxlor to be able to communicate properly with the backend, you have to configure it.',
		'config_now' => 'Configure now'
	],
];
