<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can also view it online at
 * https://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  the authors
 * @author     Froxlor team <team@froxlor.org>
 * @author     Ricardo Luiz Costa <ricardo@winger.com.br>
 * @author     Thiago Goncalves de Castro <thiago@davoi.com.br>
 * @author     Rafael Andrade <slyppp@gmail.com>
 * @license    https://files.froxlor.org/misc/COPYING.txt GPLv2
 */

return [
	'admin' => [
		'overview' => 'Visão geral',
		'ressourcedetails' => 'Recursos usados',
		'systemdetails' => 'Detalhes do sistema',
		'froxlordetails' => 'Detalhes do Froxlor',
		'installedversion' => 'Versão instalada',
		'latestversion' => 'Ultima Versão',
		'lookfornewversion' => [
			'clickhere' => 'procurar pela internet',
			'error' => 'Erro de leitura',
		],
		'resources' => 'Recursos',
		'customer' => 'Cliente',
		'customers' => 'Clientes',
		'customer_add' => 'Criar cliente',
		'customer_edit' => 'Editar cliente',
		'domains' => 'Domínios',
		'domain_add' => 'Criar domínio',
		'domain_edit' => 'Editar domínio',
		'subdomainforemail' => 'Subdomínio como "emaildomains"',
		'admin' => 'Administrador',
		'admins' => 'Administradores',
		'admin_add' => 'Criar administrador',
		'admin_edit' => 'Editar administrador',
		'customers_see_all' => 'Mostrar todos os clientes',
		'change_serversettings' => 'Alterar configuraççes do servidor?',
		'server' => 'Sistema',
		'serversettings' => 'Configurações',
		'rebuildconf' => 'Escrever de novo os configs',
		'stdsubdomain' => 'Subdomínio padrão',
		'stdsubdomain_add' => 'Criar Subdomínio padrão',
		'phpenabled' => 'PHP Habilitado',
		'deactivated' => 'Desativado',
		'deactivated_user' => 'Desativar usuário',
		'sendpassword' => 'Enviar senha',
		'ownvhostsettings' => 'Own vHost-Settings',
		'configfiles' => [
			'serverconfiguration' => 'Configurações',
			'overview' => 'Visão Geral',
			'wizard' => 'Assistente',
			'distribution' => 'Distribuição',
			'service' => 'Serviço',
			'daemon' => 'Daemon',
			'http' => 'Servidor Web (HTTP)',
			'dns' => 'Servidor de Nomes (DNS)',
			'mail' => 'Servidor de Emails (POP3/IMAP)',
			'smtp' => 'Servidor de Emails (SMTP)',
			'ftp' => 'Servidor FTP',
			'etc' => 'Outros (Sistema)',
			'choosedistribution' => 'Escolha uma distribuição',
			'chooseservice' => 'Escolha um serviço',
			'choosedaemon' => 'Escolha um daemon',
			'statistics' => 'Estatísticas',
		],
		'templates' => [
			'templates' => 'Templates',
			'template_add' => 'Adicionar template',
			'template_edit' => 'Editar template',
			'action' => 'Ação',
			'email' => 'E-Mail',
			'subject' => 'Assunto',
			'mailbody' => 'Mensagem',
			'createcustomer' => 'E-mail de boas-vindas para novos clientes',
			'pop_success' => 'E-mail de boas-vindas para nova conta de e-mail',
			'template_replace_vars' => 'Variaveis para serem substituidas no template:',
			'FIRSTNAME' => 'Altere para o primeiro nome do cliente.',
			'NAME' => 'Altere para o nome do cliente.',
			'USERNAME' => 'Altere para nome da conta do cliente.',
			'PASSWORD' => 'Altere com a senha da conta do cliente.',
			'EMAIL' => 'Altere com os dados do servidor POP3/IMAP.',
			'TRAFFIC' => 'Substituído com o tráfego, o que foi atribuído ao cliente.',
			'TRAFFICUSED' => 'Substituído com o tráfego, que foi esgotado pela cliente.',
			'pop_success_alternative' => 'Bem-vindo para novas contas e-mail enviado ao endereço alternativo',
			'EMAIL_PASSWORD' => 'Substituído a senha da conta POP3/IMAP.',
			'index_html' => 'Indice de arquivo recém-criado no diretório de cliente',
			'SERVERNAME' => 'Substitua pelo nome do servidor.',
			'CUSTOMER' => 'Substitua pelo login do cliente.',
			'ADMIN' => 'Substitua pelo login do admin.',
			'CUSTOMER_EMAIL' => 'Substitua pelo endereço de email do cliente.',
			'ADMIN_EMAIL' => 'Substitua pelo endereço de email do administrador.',
			'filetemplates' => 'Modelo de Arquivo',
			'filecontent' => 'Conteúdo do Arquivo',
		],
		'ipsandports' => [
			'ipsandports' => 'IPs e Portas',
			'add' => 'Adicionar IP/Porta',
			'edit' => 'Editar IP/Porta',
			'ipandport' => 'IP/Porta',
			'ip' => 'IP',
			'port' => 'Porta',
			'create_listen_statement' => 'Criar instrução de escuta',
			'create_namevirtualhost_statement' => 'Criar instrução de NameVirtualHost',
			'create_vhostcontainer' => 'Criar vHost-Container',
			'create_vhostcontainer_servername_statement' => 'Criar instrução de ServerName  no vHost-Container',
			'enable_ssl' => 'Esta é uma porta SSL?',
			'ssl_cert_file' => 'Caminho para o certificado SSL',
		],
		'valuemandatory' => 'Este valor é imperativo.',
		'valuemandatorycompany' => 'Qualquer um "nome" e "nome" o "companhia" deve ser enchido.',
		'webserver' => 'Servidor Web',
		'memorylimitdisabled' => 'Desabilitado',
		'serversoftware' => 'Servidor de Software',
		'phpversion' => 'Versão do PHP',
		'phpmemorylimit' => 'Memória Limite do PHP',
		'mysqlserverversion' => 'Versão do MySQL Server',
		'mysqlclientversion' => 'Versão do MySQL Client',
		'webserverinterface' => 'Interface do Servidor Web',
		'accountsettings' => 'Configurações de Conta',
		'panelsettings' => 'Painel de Controle',
		'systemsettings' => 'Configurações do Sistema',
		'webserversettings' => 'Configurações do WebServer',
		'mailserversettings' => 'Configurações do Servidor de Email',
		'nameserversettings' => 'Configurações dos Servidores de Nomes',
		'updatecounters' => 'Recalcular utilização de recursos',
		'subcanemaildomain' => [
			'never' => 'Nunca',
			'choosableno' => 'Escolhe, default não',
			'choosableyes' => 'Escolher, default sim',
			'always' => 'Sempre',
		],
		'webalizersettings' => 'Configurações do Webalizer',
		'webalizer' => [
			'normal' => 'Normal',
			'quiet' => 'Quieto',
			'veryquiet' => 'Sem Saída',
		],
		'domain_nocustomeraddingavailable' => 'Não adicionar um domínio corretamente. Você primeiro precisa adicionar um cliente.',
		'loggersettings' => 'Configurações de Logs',
		'logger' => [
			'normal' => 'normal',
			'paranoid' => 'paranóico',
		],
		'emaildomain' => 'Domínio de Email',
		'email_only' => 'Somente Email?',
		'wwwserveralias' => 'Adicionar um "www." ServerAlias',
		'subject' => 'Assunto',
		'recipient' => 'Destinatário',
		'message' => 'Escrever uma mensagem',
		'text' => 'Mensagem',
		'sslsettings' => 'Configuração de SSL',
		'dkimsettings' => 'Configurações de Chave de Domínios',
		'caneditphpsettings' => 'Pode alterar as configurações PHP relacionadas com o domínio?',
		'allips' => 'Todos os IPs',
		'awstatssettings' => 'Configurações Awtats',
		'domain_dns_settings' => 'Configurações de DNS',
		'activated' => 'Ativado',
		'statisticsettings' => 'Configurações de Estatísticas',
		'or' => 'ou',
		'sysload' => 'Carga do Sistema',
		'noloadavailable' => 'Não disponível',
		'nouptimeavailable' => 'Não disponível',
		'nosubject' => '(Sem Assunto)',
		'accountdata' => 'Data da Conta',
		'contactdata' => 'Data de Contato',
		'servicedata' => 'Data de Serviço',
		'security_settings' => 'Opções de Segurança',
		'know_what_youre_doing' => 'Somente altere, se você sabe o que está fazendo',
		'show_version_login' => [
			'title' => 'Mostrar versão do Froxlor no login',
			'description' => 'Mostar a versão do Froxlor no rodapé da página de login',
		],
		'show_version_footer' => [
			'title' => 'Mostar versão do Froxlor no rodapé',
			'description' => 'Mostar a versão do Froxlor no rodapé do resto das páginas',
		],
		'froxlor_graphic' => [
			'title' => 'Cabeçalho gráfico do Froxlor',
			'description' => 'Quais gráficos devem aparece no topor',
		],
		'phpsettings' => [
			'title' => 'Configurações do PHP',
			'description' => 'Descrição',
			'actions' => 'Ações',
			'activedomains' => 'Em uso pelo(s) domínio(s)',
			'notused' => 'Configuração não está em uso',
			'editsettings' => 'Alterar Configuração do PHP',
			'addsettings' => 'Criar novas configurações do PHP',
			'viewsettings' => 'Visualizar Configuração do PHP',
			'phpinisettings' => 'Configurações do php.ini',
			'addnew' => 'Criar novas configurações',
			'binary' => 'Binário do PHP',
			'file_extensions' => 'Extensões de arquivos',
			'file_extensions_note' => '(Sem pontos, separados por espaços)',
		],
		'misc' => 'Variados',
		'phpconfig' => [
			'template_replace_vars' => 'As variáveis que serão substituídas nas Configurações',
			'pear_dir' => 'Serão substituídos com a definição global para o diretório pear.',
			'open_basedir' => 'Serão substituídos com a definição do domínio open_basedir.',
			'tmp_dir' => 'Substituído com o diretório temporário do domínio.',
			'open_basedir_global' => 'Serão substituídos com o valor global do caminho que será anexado ao open_basedir.',
			'customer_email' => 'Serão substituídos com o endereço de e-mail do cliente que é dono desse domínio.',
			'admin_email' => 'Serão substituídos por e-mail do administrador quem possui esse domínio.',
			'domain' => 'Serão substituídos com o domínio.',
			'customer' => 'Será substituída pelo nome do login do cliente que é dono desse domínio.',
			'admin' => 'Será substituída pelo nome de login do administrador que possui esse domínio.',
		],
		'expert_settings' => 'Configurações Avançadas',
		'mod_fcgid_starter' => [
			'title' => 'Processos PHP para este domínio (vazio para usar valor padrão)',
		],
		'phpserversettings' => 'Configuração do PHP',
		'mod_fcgid_maxrequests' => [
			'title' => 'Máximo de requisições php para este domínio (vazio para valor default)',
		],
	],
	'changepassword' => [
		'old_password' => 'Senha atual',
		'new_password' => 'Nova senha',
		'new_password_confirm' => 'Repita a nova senha',
		'new_password_ifnotempty' => 'Nova senha (em branco = não alterar)',
		'also_change_ftp' => ' trocar tambem a senha da conta principal de FTP',
		'also_change_stats' => 'Troca a senha das estatísticas',
	],
	'cronjobs' => [
		'notyetrun' => 'Ainda não está rodando',
	],
	'customer' => [
		'documentroot' => 'Diretório home',
		'name' => 'Sobrenome',
		'firstname' => 'Primeiro nome',
		'company' => 'Empresa',
		'street' => 'Endereço',
		'zipcode' => 'CEP',
		'city' => 'Cidade',
		'phone' => 'Telefone',
		'fax' => 'Fax',
		'email' => 'E-mail',
		'customernumber' => 'Cliente ID',
		'diskspace' => 'Espaço de disco (MB)',
		'traffic' => 'Tráfego (GB)',
		'mysqls' => 'Bancos de dados-MySQL',
		'emails' => 'Endereços de e-mail',
		'accounts' => 'Contas de e-mail',
		'forwarders' => 'Redirecionamentos de e-mail',
		'ftps' => 'Contas de FTP',
		'subdomains' => 'Sub-Domínio(s)',
		'domains' => 'Domínio(s)',
		'email_quota' => 'E-mail Quota',
		'email_imap' => 'E-mail IMAP',
		'email_pop3' => 'E-mail POP3',
		'mail_quota' => 'Quota de Email',
		'title' => 'Título',
		'country' => 'País',
	],
	'dkim' => [
		'dkim_prefix' => [
			'title' => 'Prefixo',
			'description' => 'Por favor, especifique o caminho para o os arquivos DKIM RSA, bem como para os arquivos de configuração para o plugin Milter',
		],
		'dkim_domains' => [
			'title' => 'Nome de arquivo de domínios',
			'description' => '<em>Nome do Arquivo</em> dos Domínios do DKIM, parâmetro especificado na configuração do dkim-Milter',
		],
		'dkim_dkimkeys' => [
			'title' => 'Nome de arquivo de chaves',
			'description' => '<em>Nome do Arquivo</em>DKIM KeyList do parâmetro especificado na configuração dkim-Milter',
		],
		'dkimrestart_command' => [
			'title' => 'Comando para reiniciar o Milter',
			'description' => 'Por favor especifique um comando para reiniciar o DKIM Milter',
		],
		'use_dkim' => [
			'title' => 'Ativar suporte para DKIM?',
			'description' => 'Você deseja usar o sistema de chaves de domínio (DKIM) ?',
		],
	],
	'dns' => [
		'destinationip' => 'Domínio IP',
		'standardip' => 'IP padrão do servidor',
		'a_record' => 'Gravar-A(Opcional IPV6)',
		'cname_record' => 'Gravar-CNAME',
		'mxrecords' => 'Definir entradas MX',
		'standardmx' => 'Servidor MX padrão',
		'mxconfig' => 'Registros MX personalizados',
		'priority10' => 'Prioridade 10',
		'priority20' => 'Prioridade 20',
		'txtrecords' => 'Difinir entradas TXT',
		'txtexample' => 'Exemplo (Entrada-SPF):<br />v=spf1 ip4:xxx.xxx.xx.0/23 -all',
	],
	'domain' => [
		'docroot' => 'trajeto da linha acima de',
		'homedir' => 'diretório da casa',
		'openbasedirpath' => 'Caminho do OpenBaseDir',
	],
	'domains' => [
		'description' => 'Aqui você pode criar (sub-)domínios e alterar seu destino.<br />O sistema irá levar algum tempo para aplicar as novas configurações depois de salvas.',
		'domainsettings' => 'Configurar Domínio',
		'domainname' => 'Nome do domínio',
		'subdomain_add' => 'Criar Sub-domínio',
		'subdomain_edit' => 'Editar (sub)domínio',
		'wildcarddomain' => 'Criar um wildcarddomain?',
		'aliasdomain' => 'Aliás para o domínio',
		'noaliasdomain' => 'Não domínio do aliás',
		'hasaliasdomains' => 'Possui alinhas de domínio(s)',
		'statstics' => 'Estatísticas de Uso',
		'isassigneddomain' => 'É um domínio assinado',
		'add_date' => 'Adicionado no Froxlor',
		'registration_date' => 'Adicionado no Registro',
		'topleveldomain' => 'Top-Level-Domain',
		'associated_with_domain' => 'Associado',
		'aliasdomains' => 'Encaminhamento de domínios',
	],
	'emails' => [
		'description' => 'Aqui você pode criar e alterer seus e-mails.<br />Uma conta é como uma caixa de correio na frente de sua casa. Quando alguem envia para você um e-mail, ele é colocado nesta conta.<br /><br />Para baixar seus e-mails use as seguintes configurações no seu propraga de e-mails favorito: (Os dados em <i>italico</i> devem ser substituidos pelo equivalente da conta que você criou!)<br />Hostname: <b><i>Nome de seu domínio</i></b><br />Usuário: <b><i>Nome da conta / Endereço de e-mail</i></b><br />Senha: <b><i>a senha que você escolheu</i></b>',
		'emailaddress' => 'Endereços de e-mail',
		'emails_add' => 'Criar e-mail',
		'emails_edit' => 'Editar e-mail',
		'catchall' => 'Pega tudo',
		'iscatchall' => 'Definir como endereço pega tudo?',
		'account' => 'Conta',
		'account_add' => 'Criar conta',
		'account_delete' => 'Excluir conta',
		'from' => 'Origem',
		'to' => 'Destino',
		'forwarders' => 'Redirecionamentos',
		'forwarder_add' => 'Criar redirecionamento',
		'alternative_emailaddress' => 'Endereço de E-mail alternativo',
		'quota' => 'Quota',
		'noquota' => 'Sem quota',
		'updatequota' => 'Atualizar',
	],
	'error' => [
		'error' => 'Erro',
		'directorymustexist' => 'O diretório %s deve existir. Por favor crie ele primeiro com seu programa de FTP.',
		'filemustexist' => 'O arquivo %s deve existir.',
		'allresourcesused' => 'Você já usou todos os seus recursos.',
		'domains_cantdeletemaindomain' => 'Você não pode deletar um domínio que esta sendo usado como email-domain.',
		'domains_canteditdomain' => 'Você não pode editar este domínio. Ele foi desabilitado pelo administrador.',
		'domains_cantdeletedomainwithemail' => 'Você não pode deletar um domínio que é usado como email-domain. Delete todos as contas de e-mail primeiro.',
		'firstdeleteallsubdomains' => 'Você deve deletar todos subdomínios antes de poder criar um wildcard domain.',
		'youhavealreadyacatchallforthisdomain' => 'Você já definiu uma conta pega tudo para este domínio.',
		'ftp_cantdeletemainaccount' => 'Você não pode deletar a conta principal de FTP',
		'login' => 'O usuário ou senha digitados, não estão corretos. Por favor tente novamente!',
		'login_blocked' => 'Esta conta está suspensa por exceder as tentativas de login permitidas. <br />Por favor tente novamente em %s segundos.',
		'notallreqfieldsorerrors' => 'Você não preencheu todos os campos ou preencheu algum campo incorretamente.',
		'oldpasswordnotcorrect' => 'A senha antiga não confere.',
		'youcantallocatemorethanyouhave' => 'Você não pode alocar mais recursos do que você mesmo possui.',
		'mustbeurl' => 'Você não digitou uma URL válida (ex. http://seudominio.com/erro404.htm)',
		'invalidpath' => 'Optou por um URL não válido (eventuais problemas na lista do directório)',
		'stringisempty' => 'Faltando informação no campo',
		'stringiswrong' => 'Erro na informação do campo',
		'newpasswordconfirmerror' => 'A nova senha e a confirmação não conferem',
		'mydomain' => '\'Domínio\'',
		'mydocumentroot' => '\'Documento principal\'',
		'loginnameexists' => 'Login %s já existe',
		'emailiswrong' => 'E-mail %s contém caracteres inválidos ou está incompleto',
		'loginnameiswrong' => 'Login %s contém caracteres inválidos',
		'loginnameiswrong2' => 'Login contém muitos caracteres. Somente %s caracteres são aceitos.',
		'userpathcombinationdupe' => 'Usuario e caminho já existem',
		'patherror' => 'Erro geral! o caminho não pode ficar em branco',
		'errordocpathdupe' => 'Opção de caminho %s já existe',
		'adduserfirst' => 'Por favor crie um cliente primeiro',
		'domainalreadyexists' => 'O domínio %s já está apontado para outro cliente',
		'nolanguageselect' => 'Nenhum idioma selecionado.',
		'nosubjectcreate' => 'Você deve definir um nome para este e-mail template.',
		'nomailbodycreate' => 'Você deve definir o texto para este e-mail template.',
		'templatenotfound' => 'Template não encontrado.',
		'alltemplatesdefined' => 'Você não pode definir mais templates, todos idiomas já suportados.',
		'wwwnotallowed' => 'www não é permitido como nome de subdomínio.',
		'subdomainiswrong' => 'O subdomínio %s contém caracteres inválidos.',
		'domaincantbeempty' => 'O nome do domínio não pode estar vazio.',
		'domainexistalready' => 'O domínio %s já existe.',
		'domainisaliasorothercustomer' => 'O domínio-alias escolhido é ele próprio um domínio-alias ou este pertence a um outro cliente.',
		'emailexistalready' => 'O E-mail %s já existe.',
		'maindomainnonexist' => 'O domínio principal %s não existe.',
		'destinationnonexist' => 'Por favor crie seu redirecionamento no campo \'Destino\'.',
		'destinationalreadyexistasmail' => 'O redirecionamento %s já existe como uma conta de e-mail.',
		'destinationalreadyexist' => 'Você já definiu um redirecionamento para %s .',
		'destinationiswrong' => 'O redirecionamento %s contém caracteres inválidos ou incompletos.',
		'ipstillhasdomains' => 'O IP/Porta que você quer deletar ainda possui domínios associados e eles, por favor altere o IP/Porta destes domínios antes de deletá-los.',
		'cantdeletedefaultip' => 'Você não pode deletar o IP/Porta padrão do revendedor, por favor defina outro IP/Porta como padrão antes deletar o IP/Porta desejado',
		'cantdeletesystemip' => 'Você não pode deletar o IP do sistema, nem criar uma nova combinação IP/Porta para o sistema ou trocar o IP do sistema.',
		'myipaddress' => '\'IP\'',
		'myport' => '\'Porta\'',
		'myipdefault' => 'Você precisa selecionar o IP/Porta que será padrão.',
		'myipnotdouble' => 'Esta combinação  IP/Porta já existe.',
		'cantchangesystemip' => 'Você não pode mudar o último sistema IP, para criar uma outra combinação nova de IP/Port para o sistema IP ou para mudar o sistema IP',
		'loginnameissystemaccount' => 'Você não pode criar os clientes que são similares aos systemaccounts. Incorpore por favor um outro accountname.',
		'admin_domain_emailsystemhostname' => 'Desculpe. Você não pode usar o hostname do servidor como domínio de email',
		'sessiontimeoutiswrong' => 'Apenas numeros "Timeout da sessão" permitido.',
		'maxloginattemptsiswrong' => 'Apenas numero "Tentativa maxima de Login" permitido.',
		'deactivatetimiswrong' => 'Apenas numero "Desativar Tempo" permitido.',
		'accountprefixiswrong' => 'O "Prefixo" está errado.',
		'mysqlprefixiswrong' => 'O "Prefixo SQL" está errado.',
		'ftpprefixiswrong' => 'O "Prefixo FTP" está errado.',
		'ipiswrong' => 'O "Endereço-IP" está errado. Apenas um Endereço-IP válido é permitido.',
		'vmailuidiswrong' => 'O "UID do E-mail" Está errado. Só é permitido um número de ID.',
		'vmailgidiswrong' => 'O "GID do E-mail" Está errado. Só é permitido um número de ID.',
		'adminmailiswrong' => 'O "Endereço de Envio" está errado. Apenas um endereço de e-mail válido é permitido.',
		'pagingiswrong' => 'O "Entradas por páginas"-value está errado. Somente caracteres númericos são permitidos.',
		'phpmyadminiswrong' => 'O caminho para o phpMyAmin não é válido',
		'webmailiswrong' => 'O caminho para o Webmail não é válido',
		'webftpiswrong' => 'O caminho para o WebFTP não é válido',
		'stringformaterror' => 'O valor par ao campo "%s" não esta no formato correto.',
		'youcantdeleteyourself' => 'Você não pode apagar você mesmo por motivos de segurança',
		'youcanteditallfieldsofyourself' => 'Nota: Você não pode editar todos os campos de sua própria conta por motivos de segurança',
		'documentrootexists' => 'O Diretório "%s" já existe para este usuario. Por favor remova-o e depois tente novamente.',
		'formtokencompromised' => 'O Pedido parece estar correto. Por motivos de segurança você está desconectado.',
		'logerror' => 'Log-Erro: %s',
		'nomessagetosend' => 'Você não entrou com uma mensagem',
		'norecipientsgiven' => 'Você não especificou um destinatário',
		'errorsendingmail' => 'A mensagem para "%s" falhou',
		'cannotreaddir' => 'Não é possível ler o diretório "%s"',
		'vmailquotawrong' => 'A tamanho da quota deve ser entre 1 e 999',
		'invalidip' => 'Endereço de IP Inválido: %s',
		'invalidmysqlhost' => 'Endereço de servidor MySQL inválido: %s',
		'cannotuseawstatsandwebalizeratonetime' => 'Você não pode ativar Webalizer e Awstats  ao mesmo tempo, por favor, escolha uma delas',
		'cannotwritetologfile' => 'Não pode abrir arquivo de log %s para escrita',
		'missingfields' => 'Nem todos os campos necessários estavam no campo.',
		'accountnotexisting' => 'Esta conta não existe.',
		'nopermissionsorinvalidid' => 'Você não tem permissões suficientes para alterar essa configuração ou um ID inválido foi dado.',
		'phpsettingidwrong' => 'Não existe uma configuração de PHP para este ID',
		'descriptioninvalid' => 'A descrição é muito curta, muito longa ou contém caracteres ilegais',
		'info' => 'Informações',
		'filecontentnotset' => 'O arquivo não pode ser vazio',
		'index_file_extension' => 'A extensão do índice do arquivo deve ficar entre 1 e 6 caracteres. A prorrogação só pode conter caracteres como az, AZ e 0-9',
		'customerdoesntexist' => 'O cliente que você escolheu não existe',
		'admindoesntexist' => 'O administrador que você escolheu não existe',
		'ipportdoesntexist' => 'A combinação de IP/Porta que você escolheu não existe',
	],
	'extras' => [
		'description' => 'Aqui você pode adicoionar alguns recursos extras, como por exemplo um diretório protegido.<br />O sistema ira precisar de algum tempo para aplicar suas alterações depois de salvas.',
		'directoryprotection_add' => 'Adicionar diretório pretogido',
		'view_directory' => 'Mostrar conteúdo do diretório',
		'pathoptions_add' => 'Adicionar opções de caminho',
		'directory_browsing' => 'Pesquizar conteúdo de diretório',
		'pathoptions_edit' => 'Esitar opções de caminhos',
		'errordocument404path' => 'URL para página de erro 404',
		'errordocument403path' => 'URL para página de erro 403',
		'errordocument500path' => 'URL para página de erro 500',
		'errordocument401path' => 'URL para página de erro 401',
	],
	'ftp' => [
		'description' => 'Aqui você pode criar e alterar suas contas de FTP.<br />As alterações são instantâneas e podem ser utilizadas imediatamente depois de salvas.',
		'account_add' => 'Criar conta',
	],
	'index' => [
		'customerdetails' => 'Detalhes dos Clientes',
		'accountdetails' => 'Detalhes das Contas',
	],
	'logger' => [
		'date' => 'Data',
		'type' => 'Tipo',
		'action' => 'Ação',
		'user' => 'Usuário',
		'truncate' => 'Log Vazio',
	],
	'login' => [
		'username' => 'Usuário',
		'password' => 'Senha',
		'language' => 'Idioma',
		'login' => 'Login',
		'logout' => 'Sair',
		'profile_lng' => 'Idioma padrão',
		'forgotpwd' => 'Perdeu sua senha?',
		'presend' => 'Resetar senha',
		'email' => 'Endereço de E-mail',
		'remind' => 'Resetar minha senha',
		'usernotfound' => 'Úsuario não encontrado',
		'backtologin' => 'Voltar ao Login',
	],
	'mails' => [
		'pop_success' => [
			'mailbody' => 'Olá,\\n\\n sua conta de e-mail {EMAIL}\\n foi criada com sucesso.\\n\\nEsta é uma mensagem automática\\neMail, por favor não responda!\\n\\nAtenciosamente, Equipe de desenvolvimento do Froxlor',
			'subject' => 'Conta de e-mail criada com sucesso!',
		],
		'createcustomer' => [
			'mailbody' => 'Olá {FIRSTNAME} {NAME},\\n\\nseguem os detalhes de sua nova conta de e-mail:\\n\\nUsuario: {USERNAME}\\nSenha: {PASSWORD}\\n\\nObrigado,\\nEquipe de desenvolvimento do Froxlor',
			'subject' => 'Informações da conta',
		],
		'pop_success_alternative' => [
			'mailbody' => 'Oi,\\n\\nSua conta de email {EMAIL}\\nfoi configurada corretamente.\\nSua senha é{PASSWORD}.\\n\\nEmail criado automaticamente\\n, Por favor não responda!\\n\\nCumprimentos, Equipe Froxlor.',
			'subject' => 'Conta de email criada com sucesso',
		],
		'password_reset' => [
			'subject' => 'Reset de Senha',
			'mailbody' => 'Oi {USERNAME},\\n\\nsua senha do Froxlor foi resetada!\\nA nova senha é: {LINK}\\n\\nObrigado,\\nequipe Froxlor',
		],
	],
	'menu' => [
		'message' => 'Mensagens',
	],
	'menue' => [
		'main' => [
			'main' => 'Principal',
			'changepassword' => 'Trocar senha',
			'changelanguage' => 'Trocar idioma',
			'username' => 'Logado como',
		],
		'email' => [
			'email' => 'E-mail',
			'emails' => 'Endereços',
			'webmail' => 'WebMail',
		],
		'mysql' => [
			'mysql' => 'MySQL',
			'databases' => 'Banco de dados',
			'phpmyadmin' => 'phpMyAdmin',
		],
		'domains' => [
			'domains' => 'Domínios',
			'settings' => 'Configurações',
		],
		'ftp' => [
			'ftp' => 'FTP',
			'accounts' => 'Contas',
			'webftp' => 'WebFTP',
		],
		'extras' => [
			'extras' => 'Extras',
			'directoryprotection' => 'Diretório protegido',
			'pathoptions' => 'Opções de caminhos',
		],
		'traffic' => [
			'traffic' => 'Tráfego',
			'current' => 'Mês corrente',
		],
		'phpsettings' => [
			'maintitle' => 'Configurações do PHP',
		],
		'logger' > [
			'logger' => 'Sistema-Log',
		],
	],
	'message' => [
		'norecipients' => 'Email não enviado porque não tem destinatário no banco de dados',
	],
	'mysql' => [
		'description' => 'Aqui você pode criar e alterar seus bancos de dados MySQL.<br />As alterações são instantâneas e podem ser utilizadas imediatamente depois de salvas.<br />No menu do lado esquerdo você pode encontrar a ferramenta phpMyAdmin e com ela facilmente administrar seus bancos de dados.<br /><br />Para usar seu banco de dados com scripts em PHP use as seguintes configurações: (Os dados em <i>italico</i> devem ser substituidos pelo equivalente do banco de dados que você criou!)<br />Hostname: <b><SQL_HOST></b><br />Usuario: <b><i>Nome do banco de dadose</i></b><br />Senha: <b><i>a senha que você escolheu</i></b><br />Banco de dados: <b><i>Nome do banco de dados',
		'databasename' => 'Usuario / Nome do banco de dados',
		'databasedescription' => 'Descrição do banco de dados',
		'database_create' => 'Criar banco de dados',
	],
	'panel' => [
		'edit' => 'Editar',
		'delete' => 'Deletar',
		'create' => 'Criar',
		'save' => 'Salvar',
		'yes' => 'Sim',
		'no' => 'Não',
		'emptyfornochanges' => 'Sair sem salvar',
		'emptyfordefault' => 'Restaurar padrão',
		'path' => 'Caminho',
		'toggle' => 'Toggle',
		'next' => 'Próximo',
		'dirsmissing' => 'Directório não disponível ou ilegível',
		'urloverridespath' => 'URL (Caminho Completo)',
		'pathorurl' => 'Caminho ou URL',
		'ascending' => 'Crescente',
		'descending' => 'Decrescente',
		'search' => 'Procurar',
		'used' => 'Usado',
		'translator' => 'Tradutor',
		'reset' => 'Descartar Mudanças',
		'pathDescription' => 'Se o diretório não existir, será criado automaticamente',
		'back' => 'Volta',
		'reseller' => 'Revenda',
		'admin' => 'Administrador',
		'customer' => 'Cliente(s)',
		'send' => 'Enviar',
		'nosslipsavailable' => 'Não existem atualmente IP SSL / Porta para este servidor.',
		'backtooverview' => 'Voltar para Visão Geral',
		'dateformat' => 'AAAA-MM-DD',
		'dateformat_function' => 'A-m-d',
		'timeformat_function' => 'H:i:S',
		'default' => 'Padrão',
		'never' => 'Nunca',
		'active' => 'Ativo',
		'please_choose' => 'Por favor escolha',
		'allow_modifications' => 'Aceita alteraçoes',
		'not_supported' => 'Não suportado em:',
		'view' => 'Visualizar',
	],
	'pwdreminder' => [
		'success' => 'Redefinição de senha com sucesso. <br /> Você agora deve receber um e-mail com sua nova senha.',
		'notallowed' => 'Reset de senhas está desativado',
	],
	'question' => [
		'question' => 'Pergunta de segurança',
		'admin_customer_reallydelete' => 'Você realmente deseja deletar o cliente %s? Este comando não poderá ser cancelado!',
		'admin_domain_reallydelete' => 'Você realmente deseja deletar o domínio %s?',
		'admin_domain_reallydisablesecuritysetting' => 'Você realmente deseja desativar estas configurações de segurança (OpenBasedir)?',
		'admin_admin_reallydelete' => 'Você realmente deseja deletar o administrador %s? Todos clientes e domínios serão realocados para o administrador principal.',
		'admin_template_reallydelete' => 'Você realmente deseja deletar o template \'%s\'?',
		'domains_reallydelete' => 'Você realmente deseja deletar o domínio %s?',
		'email_reallydelete' => 'Você realmente deseja deletar o e-mail %s?',
		'email_reallydelete_account' => 'Você realmente deseja deletar a conta de e-mail %s?',
		'email_reallydelete_forwarder' => 'Você realmente deseja deletar o redirecionamento %s?',
		'extras_reallydelete' => 'Você realmente deseja deletar a proteção do diretório %s?',
		'extras_reallydelete_pathoptions' => 'Você realmente deseja deletar o caminho %s?',
		'ftp_reallydelete' => 'Você realmente deseja deletar a conta de FTP %s?',
		'mysql_reallydelete' => 'Você realmente deseja deletar o banco de dados %s? Este comando não poderá ser cancelado!',
		'admin_configs_reallyrebuild' => 'Está certo que quer deixar reconfigurar os ficheiros de configuração de Apache e Bind?',
		'admin_customer_alsoremovefiles' => 'Remover arquivos do usuário também?',
		'admin_customer_alsoremovemail' => 'Remover todos os dados de e-mail do sistema de arquivos?',
		'admin_customer_alsoremoveftphomedir' => 'Remover o diretório home do usuário FTP?',
		'admin_ip_reallydelete' => 'Você realmente deseja deletar este endereço IP?',
		'admin_domain_reallydocrootoutofcustomerroot' => 'É você certo, você quer a raiz do original para este domínio, não estando dentro do customerroot do cliente?',
		'admin_counters_reallyupdate' => 'Você deseja recalcular os recursos utilizados?',
		'logger_reallytruncate' => 'Você realmente deseja dividir a tabela "%s"?',
		'admin_quotas_reallywipe' => 'Você realmente deseja limpar todas as quotas na tabela  mail_users? Isto não pode ser revertido',
		'phpsetting_reallydelete' => 'Você realmente deseja apagar esta configuração? Todos os domínios que atualmente utilizam esta configuração serão alterada para a configuração padrão.',
	],
	'serversettings' => [
		'session_timeout' => [
			'title' => 'Tempo esgotado',
			'description' => 'Quanto tempo o usuario deve estar inativo para ser desconectado (segundos)?',
		],
		'accountprefix' => [
			'title' => 'Prefixo do cliente',
			'description' => 'Qual o prefixo "customeraccounts" deve ter?',
		],
		'mysqlprefix' => [
			'title' => 'SQL Prefixo',
			'description' => 'Qual prefixo as contas mysql devem ter?',
		],
		'ftpprefix' => [
			'title' => 'FTP Prefixo',
			'description' => 'Qual prefixo as contas de FTP devem ter?',
		],
		'documentroot_prefix' => [
			'title' => 'Diretório de documentação',
			'description' => 'Aonde os documentos dever ser gravados?',
		],
		'logfiles_directory' => [
			'title' => 'Diretório de LOG',
			'description' => 'Aonde os arquivos de log dever ser gravados?',
		],
		'ipaddress' => [
			'title' => 'Endereços de IP',
			'description' => 'Quais os Endereços IP deste servidor?',
		],
		'hostname' => [
			'title' => 'Hostname',
			'description' => 'Qual o Hostname deste servidor?',
		],
		'apachereload_command' => [
			'title' => 'Comando de reiniciar o Apache',
			'description' => 'Qual o comando para reiniciar o apache?',
		],
		'bindenable' => [
			'title' => 'Habilitar Servidor de Nomes',
			'description' => 'Aqui o servidor de nomes pode ser habilitado ou desabilitado globalmente.',
		],
		'bindconf_directory' => [
			'title' => 'Diretório de configuração do Bind',
			'description' => 'Aonde estão os arquivos de configuração do bind?',
		],
		'bindreload_command' => [
			'title' => 'Comando de reiniciar o Bind',
			'description' => 'Qual o comando para reiniciar o bind?',
		],
		'vmail_uid' => [
			'title' => 'Mails-Uid',
			'description' => 'Qual UserID os e-mails devem ter?',
		],
		'vmail_gid' => [
			'title' => 'Mails-Gid',
			'description' => 'Qual GroupID os e-mails devem ter?',
		],
		'vmail_homedir' => [
			'title' => 'Mails-Homedir',
			'description' => 'Aonde os e-mails devem ser gravados?',
		],
		'adminmail' => [
			'title' => 'Remetente',
			'description' => 'Qual o remetente dos e-mails enviados pelo painel?',
		],
		'phpmyadmin_url' => [
			'title' => 'phpMyAdmin URL',
			'description' => 'Qual a URL do phpMyAdmin? (deve iniciar com http://)',
		],
		'webmail_url' => [
			'title' => 'WebMail URL',
			'description' => 'Qual a URL do WebMail? (deve iniciar com http://)',
		],
		'webftp_url' => [
			'title' => 'WebFTP URL',
			'description' => 'Qual a URL do WebFTP? (deve iniciar com http://)',
		],
		'language' => [
			'description' => 'Qual o idioma padrão do servidor?',
		],
		'maxloginattempts' => [
			'title' => 'Tentativas maximas de Login',
			'description' => 'Tentativas maximas de Login para a conta ser desativada.',
		],
		'deactivatetime' => [
			'title' => 'Tempo que a conta deve permanecer desativada',
			'description' => 'Tempo (sec.) qua a conta permanece desativada depois de muitas tentativas de login.',
		],
		'pathedit' => [
			'title' => 'File-Método de entrada',
			'description' => 'A escolha do file tem que ser feita através do Dropdown-Menu ou pode ser feita manualmente?',
		],
		'paging' => [
			'title' => 'Entradas por pagina',
			'description' => 'Quantas entradas devem ser mostradas por pagina? (0 = desabilitar paginas)',
		],
		'nameservers' => [
			'title' => 'Servidores DNS',
		],
		'mxservers' => [
			'title' => 'Servidores de Email',
			'description' => 'Uma lista separada por vírgulas que contém o numero de prioridade e o hostname separados por um espaço (por exemplo: \'mx.example.com 10 \'), contendo os servidores mx.',
		],
		'defaultip' => [
			'title' => 'IP/Porta Padrão',
			'description' => 'Qual é a IP/Porta Padrão?',
		],
		'phpappendopenbasedir' => [
			'title' => 'Caminho para adicionar OpenBasedir',
			'description' => 'Estes caminhos (separados por dois pontos) serão acrescentados ao OpenBasedir em cada vhost.',
		],
		'natsorting' => [
			'title' => 'Usar classificação natural na visualização',
			'description' => 'Ordenar listas como: web1 -> web2 -> web11 ao invéz de web1 -> web11 -> web2.',
		],
		'deactivateddocroot' => [
			'title' => 'Docroots desativado para usuários',
			'description' => 'Quando um usuário estiver desativado, esse caminho é usado como seu docroot. Deixe em branco para não criar um vhost a todos.',
		],
		'mailpwcleartext' => [
			'title' => 'Salva as senhas de usuários sempre criptografia no banco de dados',
			'description' => 'Se você selecionar sim, todas as senhas serão guardadas descriptografadas (Poderá ser lido por todos com acesso ao banco de dados ) na tabela mail_users-table. Somente ative essa opção se você realmente precise!',
			'removelink' => 'Clique aqui para limpar todas as senhas não criptografadas da tabela<br />Você realmente deseja limpar todas as senhas não encriptadas a partir da tabela mail_users? Isto não pode ser revertido!',
		],
		'ftpdomain' => [
			'title' => 'Contas FTP @domínio',
			'description' => 'Clientes podem criar contas de FTP user@domíniodocliente?',
		],
		'mod_fcgid' => [
			'title' => 'Incluir PHP via mod_fcgid/suexec',
			'description' => 'Use mod_fcgid/suexec/libnss_mysql to run PHP with the corresponding useraccount.<br/><b>This needs a special Apache configuration. All following options are only valid if the module is enabled.</b>',
			'configdir' => [
				'title' => 'Diretório de configuração',
				'description' => 'Aonde todos os arquivos de configuração do fcgid vão ser guardados? Se você não utiliza um binário compilado, está é uma situação normal, deve estar dentro de /var/www/',
			],
			'tmpdir' => [
				'title' => 'Diretório Temporário',
				'description' => 'Aonde os arquivos temporários devem ser guardados',
			],
			'starter' => [
				'title' => 'Processos por domínio',
				'description' => 'Quantos processos devem ser iniciadas / permitidas por domínio? O valor 0 é recomendado. O PHP irá então gerir a quantidade de processos.',
			],
			'wrapper' => [
				'title' => 'Wrapper in Vhosts',
				'description' => 'Como os  wrapper vão ser incluídos nos vhosts',
			],
			'peardir' => [
				'title' => 'Diretórios globais do PEAR',
				'description' => 'Diretórios globais do PEAR que deverão ser substituídos em cada configuração php.ini? Diferentes diretórios devem ser separados por dois pontos.',
			],
			'maxrequests' => [
				'title' => 'Máximo de solicitações por Domínio',
				'description' => 'Quantas solicitações serão aceitas por domínio?',
			],
		],
		'sendalternativemail' => [
			'title' => 'Utilize endereço de e-mail alternativo',
			'description' => 'Enviar e-mail a senha para um endereço diferente durante uma criação de conta de e-mail',
		],
		'apacheconf_vhost' => [
			'title' => 'Arquivo/Diretório de configurações do Apache Vhost',
			'description' => 'Onde as configuração de Vhost devem ser guardadas? Você pode especificar um arquivo (todos os vhosts em um arquivo) ou diretório (cada vhost com seu próprio arquivo) aqui.',
		],
		'apacheconf_diroptions' => [
			'title' => 'Configuração de diretório do Apache Arquivo/Nome do Diretório.',
			'description' => 'Quando as opções de configuração de diretório deve ser armazenada? Você poderia especificar um arquivo (todas as opções em um arquivo) ou diretório ( cada opção no seu próprio arquivo).',
		],
		'apacheconf_htpasswddir' => [
			'title' => 'Apache htpasswd dirname',
			'description' => 'Onde deve ser o diretório de arquivos htpasswd?',
		],
		'mysql_access_host' => [
			'title' => 'Hosts de Acesso MySQL',
			'description' => 'Uma lista separada por vírgulas de hosts a partir do qual os utilizadores devem ter a possibilidade de conectar-se ao MySQL-Server.',
		],
		'webalizer_quiet' => [
			'title' => 'Saida do Webalizer',
			'description' => 'Modo verbose do webalizer',
		],
		'logger' => [
			'enable' => 'Habilitar/Desabilitar Logs',
			'severity' => 'Nível de Logs',
			'types' => [
				'title' => 'Tipos de Log(s)',
				'description' => 'Especificar tipos de logs separados por vírgula.<br />Tipos de lógs disponíveis: syslog, file, mysql',
			],
			'logfile' => 'Caminho do Arquivo de Log incluindo nome de arquivo',
			'logcron' => 'Logar tarefas do cron',
			'logcronoption' => [
				'never' => 'Nunca',
				'once' => 'Uma vez',
				'always' => 'Sempre',
			],
		],
		'ssl' => [
			'openssl_cnf' => 'Padrão para criar o arquivo de certificado',
		],
		'default_vhostconf' => [
			'title' => 'Configuração de Vhost padrão',
			'description' => 'O conteúdo deste campo será incluído a cada novo vhost criado. Atenção: O código será checado para algum erro. Se contiver erros, o apache pode não iniciar mais',
		],
		'mail_quota' => [
			'title' => 'Quota de Email',
			'description' => 'Quota default para novas caixas criadas',
		],
		'mail_quota_enabled' => [
			'title' => 'Usar quota para clientes',
			'description' => 'Ative para usar cotas em caixas de email. Padrão é <b>Não</b> visto que requer uma configuração especial.',
			'removelink' => 'Clique aqui para limpar todas as quotas para as contas de email.',
		],
		'decimal_places' => 'Número de casas decimais no tráfego / espaço de paginas web',
		'webalizer_enabled' => 'Ativar estatísticas webalizer',
		'awstats_enabled' => 'Ativar estatísticas awstats',
		'selfdns' => [
			'title' => 'Configurações DNS-Domiio personalizadas',
		],
		'selfdnscustomer' => [
			'title' => 'Aceita clientes para editar configurações de DNS',
		],
		'unix_names' => [
			'title' => 'Usar nomes compatíveis com UNIX',
			'description' => 'Aceita você usar <strong>-</strong> and <strong>_</strong> em nomes de usuários se <strong>No</strong>estiver marcado',
		],
		'allow_password_reset' => [
			'title' => 'Aceita reset de senha por clientes',
			'description' => 'Os clientes podem redefinir sua senha e  serão enviadas para seu endereço de e-mail',
		],
		'allow_password_reset_admin' => [
			'title' => 'Ativa reset de senhas pelos administradores',
			'description' => 'Admins / Revendedor pode redefinir sua senha e a nova senha será enviada para seu endereço de e-mail',
		],
		'index_file_extension' => [
			'description' => 'Qual extensão deve ser utilizada para o índice no arquivo recém-criado no diretório do cliente? Esta extensão será utilizado, se você ou um de seus administradores criou o seu próprio índice no arquivo modelo.',
			'title' => 'Extensão do arquivo recém-criado no Ãndice do diretório do cliente.',
		],
		'session_allow_multiple_login' => [
			'title' => 'Ativa login múltiplo',
			'description' => 'Se ativado um usuário pode ter múltiplos logins',
		],
		'panel_allow_domain_change_admin' => [
			'title' => 'Ativa mover domínios entre admins',
			'description' => 'If activated you can change the admin of a domain at domainsettings.<br /><b>Attention:</b> If a customer isn\'t assigned to the same admin as the domain, the admin can see every other domain of that customer!',
		],
		'panel_allow_domain_change_customer' => [
			'title' => 'Ativa mover domínios entre clientes',
			'description' => 'Se ativado você pode trocar o cliente de um domínio para administração de outro.<br /><b>Attention:</b> Froxlor não troca nenhum caminho. Isto pode fazer com que domínios parem de funcionar',
		],
	],
	'success' => [
		'messages_success' => 'Mensagens enviadas para %s destinatários com sucesso',
	],
	'traffic' => [
		'month' => 'Mês',
		'day' => 'Diariamente',
		'months' => [
			1 => 'Janeiro',
			2 => 'Fevereiro',
			3 => 'Março',
			4 => 'Abril',
			5 => 'Maio',
			6 => 'Junho',
			7 => 'Julho',
			8 => 'Agosto',
			9 => 'Setembro',
			10 => 'Outubro',
			11 => 'Novembro',
			12 => 'Dezembro',
		],
		'mb' => 'Tráfego (MB)',
		'distribution' => '<font color="#019522">FTP</font> | <font color="#0000FF">HTTP</font> | <font color="#800000">E-Mail</font>',
		'sumhttp' => 'Resumo Tráfego de HTTP em',
		'sumftp' => 'Resumo Tráfego de FTP em',
		'summail' => 'Resumo Tráfego de HTTP em',
	],
	'translator' => 'Ricardo Luiz Costa, Rafael Andrade, Thiago Goncalves de Castro',
];
