<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2003-2009 the SysCP Team (see authors).
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * For the full copyright and license information, please view the COPYING
 * file that was distributed with this source code. You can also view the
 * COPYING file online at http://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  (c) the authors
 * @author     Konstantin Samofejew <samofejew@gmx.net>
 * @license    GPLv2 http://files.froxlor.org/misc/COPYING.txt
 * @package    Language
 *
 */

/**
 * Global
 */

$lng['translator'] = 'Konstantin Samofejew (Константин Самофеев)';
$lng['panel']['edit'] = 'редактировать';

// bearbeiten

$lng['panel']['delete'] = 'удалить';

// loeschen

$lng['panel']['create'] = 'создать';

// anlegen

$lng['panel']['save'] = 'Сохранить';

// Speichern

$lng['panel']['yes'] = 'Да';

// Ja

$lng['panel']['no'] = 'Нет';

// Nein

$lng['panel']['emptyfornochanges'] = 'оставить пустым, если без изменений';

// leer fuer keine Aenderung

$lng['panel']['emptyfordefault'] = 'оставить пустым для стандартного значения';

// leer fuer Standardeinstellung

$lng['panel']['path'] = 'Путь';

// Pfad

$lng['panel']['toggle'] = 'Переключить';

// Umschalten

$lng['panel']['next'] = 'дальше';

// weiter

$lng['panel']['dirsmissing'] = 'Каталоги (директории) не существуют или не читаемы';

// Verzeichnisse nicht verfuegbar oder lesbar

/**
 * Login
 */

$lng['login']['username'] = 'Пользователь';

// Benutzername

$lng['login']['password'] = 'Пароль';

// Passwort

$lng['login']['language'] = 'Язык';

// Sprache

$lng['login']['login'] = 'Войти';

// Anmelden

$lng['login']['logout'] = 'Выйти';

// Abmelden

$lng['login']['profile_lng'] = 'Язык профиля';

// Profilsprache

/**
 * Customer
 */

$lng['customer']['documentroot'] = 'Домашний каталог (директория)';

// Heimverzeichnis

$lng['customer']['name'] = 'Фамилия';

// Name

$lng['customer']['firstname'] = 'Имя';

// Vorname

$lng['customer']['company'] = 'Фирма';

// Firma

$lng['customer']['street'] = 'Улица, дом, квартира';

// Strasse, Haus, App.

$lng['customer']['zipcode'] = 'Почтовый индекс';

// PLZ

$lng['customer']['city'] = 'Город';

// Ort

$lng['customer']['phone'] = 'Телефон';

// Telephon

$lng['customer']['fax'] = 'Факс';

// Fax

$lng['customer']['email'] = 'eMail';

// eMail

$lng['customer']['customernumber'] = 'Номер клиента';

// KundenNummer

$lng['customer']['diskspace'] = 'Объём под Web (MB)';

// Webspace (MB)

$lng['customer']['traffic'] = 'Трафик (GB)';

// Traffic (GB)

$lng['customer']['mysqls'] = 'Базы данных MySQL';

// MySQL-Datenbanken

$lng['customer']['emails'] = 'Адреса eMail';

// eMail-Adressen

$lng['customer']['accounts'] = 'Аккаунты eMail';

// eMail-Konten

$lng['customer']['forwarders'] = 'Пересылки eMail (forwarder)';

// eMail-Weiterleitungen

$lng['customer']['ftps'] = 'Аккаунты FTP';

// FTP-Accounts

$lng['customer']['subdomains'] = 'Поддомены';

// Sub-Domain(s)

$lng['customer']['domains'] = 'Домены';

// Domain(s)

$lng['customer']['unlimited'] = 'без ограничений';

// unendlich

/**
 * Customermenue
 */

$lng['menue']['main']['main'] = 'Общие настройки';

// Allgemein

$lng['menue']['main']['changepassword'] = 'Изменить пароль';

// Passwort aendern

$lng['menue']['main']['changelanguage'] = 'Изменить язык';

// Sprache aendern

$lng['menue']['email']['email'] = 'eMail';

// eMail

$lng['menue']['email']['emails'] = 'Адреса';

// Adressen

$lng['menue']['email']['webmail'] = 'WebMail';

// WebMail

$lng['menue']['mysql']['mysql'] = 'MySQL';

// MySQL

$lng['menue']['mysql']['databases'] = 'Базы данных';

// Datenbanken

$lng['menue']['mysql']['phpmyadmin'] = 'phpMyAdmin';

// phpMyAdmin

$lng['menue']['domains']['domains'] = 'Домены';

// Domains

$lng['menue']['domains']['settings'] = 'Настройки';

// Einstellungen

$lng['menue']['ftp']['ftp'] = 'FTP';

// FTP

$lng['menue']['ftp']['accounts'] = 'Аккаунты';

// Accounts

$lng['menue']['ftp']['webftp'] = 'WebFTP';

// WebFTP

$lng['menue']['extras']['extras'] = 'Разное';

// Extras

$lng['menue']['extras']['directoryprotection'] = 'Защита каталогов (директорий)';

// Verzeichnisschutz

$lng['menue']['extras']['pathoptions'] = 'Настройки путей';

// Pfadoptionen

/**
 * Index
 */

$lng['index']['customerdetails'] = 'Данные клиентов';

// Kundendaten

$lng['index']['accountdetails'] = 'Данные аккаунтов';

// Accountdaten

/**
 * Change Password
 */

$lng['changepassword']['old_password'] = 'Старый пароль';

// Altes Passwort

$lng['changepassword']['new_password'] = 'Новый пароль';

// Neues Passwort

$lng['changepassword']['new_password_confirm'] = 'Новый пароль (повторить)';

// Neues Passwort (bestaetigen)

$lng['changepassword']['new_password_ifnotempty'] = 'Новый пароль (оставить пустым, чтобы не менять)';

// Neues Passwort (leer = nicht aendern)

$lng['changepassword']['also_change_ftp'] = ' Также изменить пароль и для основного аккаунта FTP';

//  Auch Passwort vom Haupt-FTP-Zugang aendern

/**
 * Domains
 */

$lng['domains']['description'] = 'Здесь Вы можете создавать поддомены и менять пути к ним.<br />После каждого изменения системе необходимо немного времени, чтобы загрузить обновлённые настройки.';

// Hier koennen Sie (Sub-)Domains erstellen und deren Pfade aendern.<br />Nach jeder Aenderung braucht das System etwas Zeit um die Konfiguration neu einzulesen.

$lng['domains']['domainsettings'] = 'Настройки домена';

// Domaineinstellungen

$lng['domains']['domainname'] = 'Имя домена';

// Domainname

$lng['domains']['subdomain_add'] = 'Создать поддомен';

// Subdomain anlegen

$lng['domains']['subdomain_edit'] = 'Обработать (под)домен';

// (Sub-)Domain bearbeiten

$lng['domains']['wildcarddomain'] = 'Занести как уайлдкард-домен? (Wildcard)';

// Als Wildcarddomain eintragen?

$lng['domains']['aliasdomain'] = 'Алиас для домена';

// Alias fuer Domain

$lng['domains']['noaliasdomain'] = 'Не алиас-домен';

// Keine Aliasdomain

/**
 * eMails
 */

$lng['emails']['description'] = 'Здесь Вы можете настроить Ваши email-адреса.<br />Аккаунт - это как обычный почтовый ящик. Если Вам кто-то напишет электронное письмо (email), оно попадёт в этот ящик.<br /><br />Данные для Вашей почтовй программы: (Текст <i>с наклоном</i> замените на Ваши данные!)<br />Сервер: <b><i>имя домена</i></b><br />Имя пользователя: <b><i>имя аккаунта или email-адрес</i></b><br />Пароль: <b><i>выбранный Вами пароль</i></b>';

// Hier koennen Sie Ihre eMail Adressen einrichten.<br />Ein Konto ist wie Ihr Briefkasten vor der Haustuere. Wenn jemand eine email an Sie schreibt, dann wird diese in dieses Konto gelegt.<br /><br />Die Zugangsdaten von Ihrem Mailprogramm sind wie folgt: (Die Angaben in <i>kursiver</i> Schrift sind durch die jeweiligen Eintraege zu ersetzen!)<br />Hostname: <b><i>Domainname</i></b><br />Benutzername: <b><i>Kontoname / eMail-Adresse</i></b><br />Passwort: <b><i>das gewaehlte Passwort</i></b>

$lng['emails']['emailaddress'] = 'eMail-адрес';

// eMail-Adresse

$lng['emails']['emails_add'] = 'создать eMail-адрес';

// eMail-Adresse anlegen

$lng['emails']['emails_edit'] = 'изменить eMail-адрес';

//eMail-Adresse aendern

$lng['emails']['catchall'] = 'С функцией "лови всё" (catchall)';

// Catchall

$lng['emails']['iscatchall'] = 'Сделать catchall-адресом?';

// Als catchall-Adresse definieren?

$lng['emails']['account'] = 'Аккаунт';

// Konto

$lng['emails']['account_add'] = 'Создать аккаунт';

// Konto anlegen

$lng['emails']['account_delete'] = 'Удалить аккаунт';

// Konto loeschen

$lng['emails']['from'] = 'От';

// Von

$lng['emails']['to'] = 'Куда';

// Nach

$lng['emails']['forwarders'] = 'Пересылка';

// Weiterleitungen

$lng['emails']['forwarder_add'] = 'Добавить пересылку';

// Weiterleitung hinzufuegen

/**
 * FTP
 */

$lng['ftp']['description'] = 'Здесь Вы можете создать дополнительные FTP-аккаунты.<br />FTP-аккаунты активны сразу после сохранения изменений.';

// Hier koennen Sie zusaetzliche FTP-Accounts einrichten.<br />Die Aenderungen sind sofort wirksam und die FTP-Accounts sofort benutzbar.

$lng['ftp']['account_add'] = 'Создать аккаунт';

// Account anlegen

/**
 * MySQL
 */

$lng['mysql']['databasename'] = 'Имя пользователя / базы данных';

// Benutzer-/Datenbankname

$lng['mysql']['databasedescription'] = 'Описание базы данных';

// Datenbankbezeichnung

$lng['mysql']['database_create'] = 'Создать базу данных';

// Datenbank anlegen

/**
 * Extras
 */

$lng['extras']['description'] = 'Здесь Вы можете сделать дополнительные настройки, например защиту каталога (директории).<br />После каждого изменения системе необходимо немного времени, чтобы загрузить обновлённые настройки.';

// Hier koennen Sie zusaetzliche Extras einrichten, wie zum Beispiel Verzeichnisschutz.<br />Die Aenderungen sind erst nach einer bestimmten Zeit wirksam.

$lng['extras']['directoryprotection_add'] = 'Создать защиту каталога';

// Verzeichnisschutz anlegen

$lng['extras']['view_directory'] = 'Показать каталог';

// Verzeichnis anzeigen

$lng['extras']['pathoptions_add'] = 'Добавить настройки пути';

// Pfadoptionen hinzufuegen

$lng['extras']['directory_browsing'] = 'Показать содержимое каталога';

// Verzeichnisinhalt anzeigen

$lng['extras']['pathoptions_edit'] = 'Изменить настройки пути';
$lng['extras']['error404path'] = '404';

// 404

$lng['extras']['error403path'] = '403';

// 403

$lng['extras']['error500path'] = '500';

// 500

$lng['extras']['error401path'] = '401';

// 401

$lng['extras']['errordocument404path'] = 'URL к документу ошибки 404';

// URL zum Fehlerdokument 404

$lng['extras']['errordocument403path'] = 'URL к документу ошибки 403';

// URL zum Fehlerdokument 403

$lng['extras']['errordocument500path'] = 'URL к документу ошибки 500';

// URL zum Fehlerdokument 500

$lng['extras']['errordocument401path'] = 'URL к документу ошибки 401';

// URL zum Fehlerdokument 401

/**
 * Errors
 */

$lng['error']['error'] = 'Сообщение о ошибке';

// Fehlermeldung

$lng['error']['directorymustexist'] = 'Файл %s должен существовать.';

// Das Verzeichnis %s muss existieren. Legen Sie es bitte mit Ihrem FTP-Programm an.

$lng['error']['filemustexist'] = 'Файл %s должен существовать.';

// Die Datei %s muss existieren.

$lng['error']['allresourcesused'] = 'Вы уже израсходовали все ресурсы, находящиеся в Вашем распоряжении.';

// Sie haben bereits alle Ihnen zur Verfuegung stehenden Ressourcen verbraucht.

$lng['error']['domains_cantdeletemaindomain'] = 'Вы не можете удалить домен, занесённый как eMail-домен.';

// Sie koennen keine Domain, die als eMail-Domain verwendet wird loeschen.

$lng['error']['domains_canteditdomain'] = 'Обработка этого домена запрещена админом.';

// Sie koennen diese Domain nicht bearbeiten. Dies wurde durch den Admin verweigert

$lng['error']['domains_cantdeletedomainwithemail'] = 'Вы не можете удалить домен, который ещё используется как eMail-домен. Удалите сначала все eMail-адреса этого домена.';

// Sie koennen keine Domain loeschen die noch als eMail-Domain verwendet wird. Loeschen Sie zuerst alle eMail-Adressen dieser Domain.

$lng['error']['firstdeleteallsubdomains'] = 'Прежде чем создать уайлдкард-домен (wildcard), Вам необходимо удалить все поддомены.';

// Sie muessen erst alle Subdomains loeschen, bevor Sie eine Wildcarddomain anlegen koennen.

$lng['error']['youhavealreadyacatchallforthisdomain'] = 'Вы уже прописали один адрес как "лови всё" (catchall) для этого домена.';

// Sie haben bereits eine Adresse als Catchall fuer diese Domain definiert.

$lng['error']['ftp_cantdeletemainaccount'] = 'Вы не можете удалить Ваш основной аккаунт.';

// Sie koennen Ihren Hauptaccount nicht loeschen.

$lng['error']['login'] = 'Указанные имя пользователя или пароль не верны.';

// Der angegebene Benutzername/Passwort ist falsch.

$lng['error']['login_blocked'] = 'Из-за многочисленных ошибочных попыток логина аккаунт временно закрыт. <br />Пожалуйста попробуйте через ' . $settings['login']['deactivatetime'] . ' секунд ещё раз.';

// Dieser Account wurde aufgrund zu vieler Fehlversuche vorruebergehend geschlossen. <br />Bitte versuchen Sie es in '.$settings['login']['deactivatetime'].' Sekunden erneut.

$lng['error']['notallreqfieldsorerrors'] = 'Вы заполнили не все поля или минимум одно поле неправильно.';

// Sie haben nicht alle Felder oder ein Feld mit fehlerhaften Angaben ausgefuellt.

$lng['error']['oldpasswordnotcorrect'] = 'Старый пароль не верен.';

// Das alte Passwort ist nicht korrekt.

$lng['error']['youcantallocatemorethanyouhave'] = 'Вы не можете раздавать больше ресурсов, чем у Вас ещё есть.';

// Sie koennen nicht mehr Ressourcen verteilen als Sie noch frei haben.

$lng['error']['mustbeurl'] = 'Вы должны указать полный адрес URL (например http://something.com/error404.htm)';

// Sie muessen eine vollstaendige URL angeben (z.B. http://irgendwas.de/error404.htm)

$lng['error']['invalidpath'] = 'Вы указали не действительный адрес URL.';

// Sie haben keine gueltige URL ausgewaehlt (Evtl. Probleme beim Verzeichnislisting?)

$lng['error']['stringisempty'] = 'Отсутствующие данные в поле';

// Fehlende Eingabe im Feld

$lng['error']['stringiswrong'] = 'Неправильные данные в поле';

// Falsche Eingabe im Feld

$lng['error']['myloginname'] = '\'' . $lng['login']['username'] . '\'';
$lng['error']['mypassword'] = '\'' . $lng['login']['password'] . '\'';
$lng['error']['oldpassword'] = '\'' . $lng['changepassword']['old_password'] . '\'';
$lng['error']['newpassword'] = '\'' . $lng['changepassword']['new_password'] . '\'';
$lng['error']['newpasswordconfirm'] = '\'' . $lng['changepassword']['new_password_confirm'] . '\'';
$lng['error']['newpasswordconfirmerror'] = 'Новый пароль и повторённый новый пароль отличаются.';

// Das neue Passwort und die Bestaetigung sind nicht identisch.

$lng['error']['myname'] = '\'' . $lng['customer']['name'] . '\'';
$lng['error']['myfirstname'] = '\'' . $lng['customer']['firstname'] . '\'';
$lng['error']['emailadd'] = '\'' . $lng['customer']['email'] . '\'';
$lng['error']['mydomain'] = '\'Домен\'';

// \'Domain\'

$lng['error']['mydocumentroot'] = '\'Корень документа\'';

// \'Documentroot\'

$lng['error']['loginnameexists'] = 'Имя %s уже существует.';

// Login-Name %s existiert bereits.

$lng['error']['emailiswrong'] = 'eMail-адрес %s содержит запрещённые символы или является не полным.';

// eMail-Adresse %s beinhaltet ungueltige Zeichen oder ist nicht vollstaendig.

$lng['error']['loginnameiswrong'] = 'Имя %s содержит запрещённые символы.';

// Login-Name %s beinhaltet ungueltige Zeichen.

$lng['error']['userpathcombinationdupe'] = 'Комбинация из имени пользователя и пути уже существует.';

// Kombination aus Benutzername und Pfad existiert bereits.

$lng['error']['patherror'] = 'Общая ошибка! Путь не может быть пустым.';

// allgemeiner Fehler! Pfad darf nicht leer sein.

$lng['error']['errordocpathdupe'] = 'Настройка для пути %s уже существует.';

// Option fuer Pfad %s existiert bereits.

$lng['error']['adduserfirst'] = 'Сначала необходимо создать клиента.';

// Sie muessen zuerst einen Kunden anlegen.

$lng['error']['domainalreadyexists'] = 'Домен %s уже в распоряжении другого клиента.';

// Die Domain %s wurde bereits einem Kunden zugeordnet.

$lng['error']['nolanguageselect'] = 'Язык не выбран.';

// Keine Sprache ausgewaehlt.

$lng['error']['nosubjectcreate'] = 'Вам нужно указать тему.';

// Sie muessen einen Betreff angeben.

$lng['error']['nomailbodycreate'] = 'Вам нужно набрать текст сообщения.';

// Sie muessen einen Mail-Text eingeben.

$lng['error']['templatenotfound'] = 'Шаблон не найден.';

// Template wurde nicht gefunden.

$lng['error']['alltemplatesdefined'] = 'Вы не можете создавать шаблоны, потому-что во всех языках шаблоны уже существуют.';

// Sie koennen keine weiteren Templates anlegen, da bereits alle Sprachen mit Templates versorgt sind.

$lng['error']['wwwnotallowed'] = 'Ваш поддомен не может носить имя www.';

// Ihre Subdomain darf nicht www heissen.

$lng['error']['subdomainiswrong'] = 'Поддомен %s содержит недействительные символы.';

// Die Subdomain %s beinhaltet ungueltige Zeichen.

$lng['error']['domaincantbeempty'] = 'Имя домена не может быть пустым.';

// Der Domain-Name darf nicht leer sein.

$lng['error']['domainexistalready'] = 'Домен %s уже существует.';

// Die Domain %s existiert bereits.

$lng['error']['domainisaliasorothercustomer'] = 'Выбранный алиас-домен или сам является алиас-доменом, или принадлежит другому клиенту.';

// Die ausgewaehlte Aliasdomain ist entweder selber eine Aliasdomain oder gehoet zu einem anderen Kunden.

$lng['error']['emailexistalready'] = 'eMail-адрес %s уже существует.';

// Die eMail-Adresse %s existiert bereits.

$lng['error']['maindomainnonexist'] = 'Основной домен %s не существует.';

// Die Haupt-Domain %s existiert nicht.

$lng['error']['destinationnonexist'] = 'Занесите адрес для пересылки в поле \'Куда\'.';

// Bitte geben Sie Ihre Weiterleitungsadresse im Feld \'Nach\' ein.

$lng['error']['destinationalreadyexistasmail'] = 'Пересылка на %s уже существует как активный eMail-адрес.';

// Die Weiterleitung zu %s exisitiert bereits als aktive eMail-Adresse.

$lng['error']['destinationalreadyexist'] = 'Пересылка на %s уже существует.';

// Es gibt bereits eine Weiterleitung nach %s .

$lng['error']['destinationiswrong'] = 'Адрес для пересылки %s содержит недействительные символы или является неполным.';

// Die Weiterleitungsadresse-Adresse %s beinhaltet ungueltige Zeichen oder ist nicht vollstaendig.

$lng['error']['domainname'] = $lng['domains']['domainname'];

/**
 * Questions
 */

$lng['question']['question'] = 'Вопрос о выполнении';

// Sicherheitsabfrage

$lng['question']['admin_customer_reallydelete'] = 'Вы уверены, что хотите удалить клиента %s?<br />ВНИМАНИЕ! Удалённые данные не смогут быть позже восстановлены! После этого шага Вам ещё будет необходимо от руки удалить данные из файловой системы.';

// Wollen Sie den Kunden %s wirklich loeschen?<br />ACHTUNG! Alle Daten gehen unwiederruflich verloren! Nach dem Vorgang muessen Sie die Daten aus dem Dateisystem noch manuell entfernen.

$lng['question']['admin_domain_reallydelete'] = 'Вы уверены, что хотите удалить домен %s?';

// Wollen Sie die Domain %s wirklich loeschen?

$lng['question']['admin_domain_reallydisablesecuritysetting'] = 'Вы уверены, что хотите отключить эти важные для безопасности настройки (OpenBasedir)?';

// ollen Sie diese wichtigen Sicherheitseinstellungen (OpenBasedir und/oder SafeMode) wirklich deaktivieren?

$lng['question']['admin_admin_reallydelete'] = 'Вы уверены, что хотите удалить админа %s?<br />Все клиенты и домены будут переданы главному админу.';

// Wollen Sie den Admin %s wirklich loeschen?<br />Alle Kunden und Domains werden dem Hauptadmin zugeteilt.

$lng['question']['admin_template_reallydelete'] = 'Вы уверены, что хотите удалить шаблон %s?';

// Wollen Sie die Vorlage \'%s\' wirklich loeschen?

$lng['question']['domains_reallydelete'] = 'Вы уверены, что хотите удалить домен %s?';

// Wollen Sie die Domain %s wirklich loeschen?

$lng['question']['email_reallydelete'] = 'Вы уверены, что хотите удалить eMail-адрес %s?';

// Wollen Sie die eMail-Adresse %s wirklich loeschen?

$lng['question']['email_reallydelete_account'] = 'Вы уверены, что хотите удалить аккаунт %s?';

// Wollen Sie das Konto von %s wirklich loeschen?

$lng['question']['email_reallydelete_forwarder'] = 'Вы уверены, что хотите удалить пересылку %s?';

// Wollen Sie die Weiterleitung %s wirklich loeschen?

$lng['question']['extras_reallydelete'] = 'Вы уверены, что хотите удалить защиту каталога (директории) для %s?';

// Wollen Sie den Verzeichnisschutz fuer %s wirklich loeschen?

$lng['question']['extras_reallydelete_pathoptions'] = 'Вы уверены, что хотите удалить настройки для пути %s?';

// Wollen Sie die Optionen fuer den Pfad %s wirklich loeschen?

$lng['question']['ftp_reallydelete'] = 'Вы уверены, что хотите удалить FTP-аккаунт %s?';

// Wollen Sie den FTP-Account %s wirklich loeschen?

$lng['question']['mysql_reallydelete'] = 'Вы уверены, что хотите удалить базу данных %s?<br />ВНИМАНИЕ! Все данные будут безвозвратно потеряны!';

// Wollen Sie die Datenbank %s wirklich loeschen?<br />ACHTUNG! Alle Daten gehen unwiederruflich verloren!

$lng['question']['admin_configs_reallyrebuild'] = 'Вы уверены, что хотите заново создать Ваши файлы настройки для Apache и Bind?';

// Wollen Sie wirklich Ihre Apache und Bind Konfigurationsdateien neu erstellen lassen?

/**
 * Mails
 */

$lng['mails']['pop_success']['mailbody'] = 'Здравствуйте!\n\nВаш eMail-аккаунт {USERNAME}\nготов к пользованию.\n\nЭто автоматически созданное сообщение,\nпожалуйста не отвечайте на него.\n\nАдминистрация';

// Hallo,\n\nihr eMail-Konto {USERNAME}\nwurde erfolgreich eingerichtet.\n\nDies ist eine automatisch generierte\neMail, bitte antworten Sie nicht auf\ndiese Mitteilung.\n\nIhr Froxlor-Team

$lng['mails']['pop_success']['subject'] = 'eMail-аккаунт готов к пользованию';

// eMail-Konto erfolgreich eingerichtet

$lng['mails']['createcustomer']['mailbody'] = 'Здравствуйте, {FIRSTNAME} {NAME}!\n\nДанные Вашего аккаунта:\n\nИмя пользователя: {USERNAME}\nПароль: {PASSWORD}\n\nЭто автоматически созданное сообщение,\nпожалуйста не отвечайте на него.\n\nС уважением,\nАдминистрация';

// Hallo {FIRSTNAME} {NAME},\n\nhier ihre Accountinformationen:\n\nBenutzername: {USERNAME}\nPassword: {PASSWORD}\n\nVielen Dank,\nIhr Froxlor-Team

$lng['mails']['createcustomer']['subject'] = 'Данные к аккаунту';

// Accountinformationen

/**
 * Admin
 */

$lng['admin']['overview'] = 'Обзор';

// uebersicht

$lng['admin']['ressourcedetails'] = 'Использованные ресурсы';

// Verbrauchte Ressourcen

$lng['admin']['systemdetails'] = 'Подробности системы';

// Systemdetails

$lng['admin']['froxlordetails'] = 'Подробности Froxlor';

// Froxlor-Details

$lng['admin']['installedversion'] = 'Установленная версия';

// Installierte Version

$lng['admin']['latestversion'] = 'Последняя версия';

// Neueste Version

$lng['admin']['lookfornewversion']['clickhere'] = 'Запросить через веб-сервис';

// per Webservice abfragen

$lng['admin']['lookfornewversion']['error'] = 'Ошибка при запросе';

// Fehler beim Auslesen

$lng['admin']['resources'] = 'Ресурсы';

// Ressourcen

$lng['admin']['customer'] = 'Клиент';

// Kunde

$lng['admin']['customers'] = 'Клиенты';

// Kunden

$lng['admin']['customer_add'] = 'Добавить клиента';

// Kunden anlegen

$lng['admin']['customer_edit'] = 'Изменить данные клиента';

// Kunden bearbeiten

$lng['admin']['domains'] = 'Домены';

// Domains

$lng['admin']['domain_add'] = 'Добавить домен';

// Domain anlegen

$lng['admin']['domain_edit'] = 'Изменить домен';

// Domain bearbeiten

$lng['admin']['subdomainforemail'] = 'Поддомены в качестве eMail-доменов';

// Subdomains als E-Mail-Domains

$lng['admin']['admin'] = 'Админ';

// Admin

$lng['admin']['admins'] = 'Админы';

// Admins

$lng['admin']['admin_add'] = 'Добавить админа';

// Admin anlegen

$lng['admin']['admin_edit'] = 'Изменить данные админа';

// Admin bearbeiten

$lng['admin']['customers_see_all'] = 'Может видеть всех клиентов?';

// Kann alle Kunden sehen?

$lng['admin']['domains_see_all'] = 'Может видеть все домены?';

// Kann alle Domains sehen?

$lng['admin']['change_serversettings'] = 'Может менять настройки сервера?';

// Kann Servereinstellungen bearbeiten?

$lng['admin']['server'] = 'Сервер';

// Server

$lng['admin']['serversettings'] = 'Настройки сервера';

// Einstellungen

$lng['admin']['rebuildconf'] = 'Заново создать настройки';

// Configs neuschreiben

$lng['admin']['stdsubdomain'] = 'Поддомен по умолчанию';

// Standardsubdomain

$lng['admin']['stdsubdomain_add'] = 'Добавить поддомен по умолчанию';

// Standardsubdomain anlegen

$lng['admin']['deactivated'] = 'Доступ закрыт';

// Gesperrt

$lng['admin']['deactivated_user'] = 'Закрыть доступ пользователю';

// Benutzer sperren

$lng['admin']['sendpassword'] = 'Послать пароль';

// Passwort zusenden

$lng['admin']['ownvhostsettings'] = 'Собственные vHost-настройки';

// Eigene vHost-Einstellungen

$lng['admin']['configfiles']['serverconfiguration'] = 'Настройки служб';

// Konfiguration

$lng['admin']['configfiles']['files'] = '<b>Файлы настроек:</b> Пожалуйста измените соответствующие файлы настроек<br />или добавьте новые, если они не существуют, со следующим содержимым.<br /><b>Обратите внимание:</b> MySQL-пароль не был заменён из соображений безопасности.<br />Пожалуйста замените вручную "MYSQL_PASSWORD" на соответствующий пароль.<br />Если Вы его не помните, посмотрите в файле "lib/userdata.inc.php".';

// <b>Konfigurationsdateien:</b> Bitte aendern Sie die entsprechenden Konfigurationsdateien<br />oder legen sie mit dem folgenden Inhalt neu an, falls sie nicht existieren.<br /><b>Bitte beachten Sie:</b> Das MySQL-Passwort wurde aus Sicherheitsgruenden nicht ersetzt.<br />Bitte ersetzen Sie "MYSQL_PASSWORD" manuell durch das entsprechende Passwort.<br />Falls Sie es vergessen haben sollten, finden Sie es in der Datei "lib/userdata.inc.php".

$lng['admin']['configfiles']['commands'] = '<b>Команды:</b> Пожалуйста выполните следующие команды в shell.';

// <b>Kommandos:</b> Bitte fuehren Sie die folgenden Kommandos in einer Shell aus.

$lng['admin']['configfiles']['restart'] = '<b>Перезагрузка:</b> Пожалуйста выполните следующие команды в shell для<br />перезагрузки файлов настроек.';

// <b>Neustart:</b> Bitte fuehren Sie die folgenden Kommandos zum Neuladen<br />der Konfigurationsdateuen in einer Shell aus.

$lng['admin']['templates']['templates'] = 'Шаблоны';

// Vorlagen

$lng['admin']['templates']['template_add'] = 'Добавить шаблон';

// Vorlage hinzufuegen

$lng['admin']['templates']['template_edit'] = 'Изменить шаблон';

// Vorlage bearbeiten

$lng['admin']['templates']['action'] = 'Операция';

// Aktion

$lng['admin']['templates']['email'] = 'E-Mail';

// E-Mail

$lng['admin']['templates']['subject'] = 'Тема';

// Betreff

$lng['admin']['templates']['mailbody'] = 'Текст сообщения';

// Mailtext

$lng['admin']['templates']['createcustomer'] = 'Приветствие нового клиента';

// Willkommensmail fuer neue Kunden

$lng['admin']['templates']['pop_success'] = 'Приветствие для новых eMail-аккаунтов';

// Willkommensmail fuer neue E-Mail Konten

$lng['admin']['templates']['template_replace_vars'] = 'Переменные, которые будут заменены в шаблонах:';

// Variablen die in den Vorlagen ersetzt werden:

$lng['admin']['templates']['FIRSTNAME'] = 'Будет заменено именем клиента.';

// Wird mit dem Vornamen des Kunden ersetzt.

$lng['admin']['templates']['NAME'] = 'Будет заменено фамилией клиента.';

// Wird mit dem Namen des Kunden ersetzt.

$lng['admin']['templates']['USERNAME'] = 'Будет заменено именем пользователя нового аккаунта.';

// Wird mit dem Benutzernamen des neuen Kundenaccounts ersetzt.

$lng['admin']['templates']['PASSWORD'] = 'Будет заменено паролем нового аккаунта.';

// Wird mit dem Passwort des neuen Kundenaccounts ersetzt.

$lng['admin']['templates']['EMAIL'] = 'Будет заменено адресом нового POP3/IMAP-аккаунта.';

// Wird mit der Adresse des neuen POP3/IMAP Kontos ersetzt.

/**
 * Serversettings
 */

$lng['serversettings']['session_timeout']['title'] = 'Срок действия сессии';

// Session Timeout

$lng['serversettings']['session_timeout']['description'] = 'Как долго пользовать должен быть не активен, чтобы сессия стала недействительной? (в секундах)';

// Wie lange muss ein Benutzer inaktiv sein, damit die Session ungueltig wird? (Sekunden)

$lng['serversettings']['accountprefix']['title'] = 'Приставка клиента';

// Kundenprefix

$lng['serversettings']['accountprefix']['description'] = 'Какая приставка должна быть у аккаунтов клиентов?';

// Welchen Prefix sollen die Kundenaccounts haben?

$lng['serversettings']['mysqlprefix']['title'] = 'Приставка для SQL';

// SQL-Prefix

$lng['serversettings']['mysqlprefix']['description'] = 'Какая приставка должна быть у MySQL-аккаунтов?';

// Welchen Prefix sollen die MySQL-Accounts haben?

$lng['serversettings']['ftpprefix']['title'] = 'Приставка для FTP';

// FTP-Prefix

$lng['serversettings']['ftpprefix']['description'] = 'Какая приставка должна быть у FTP-аккаунтов?';

// Welchen Prefix sollen die FTP-Accounts haben?

$lng['serversettings']['documentroot_prefix']['title'] = 'Каталог (директория) для документов';

// Documentdirectory

$lng['serversettings']['documentroot_prefix']['description'] = 'Куда помещать данные клиентов?';

// Wo sollen alle Kunden liegen?

$lng['serversettings']['logfiles_directory']['title'] = 'Каталог (директория) для протоколов';

//Logfilesdirectory

$lng['serversettings']['logfiles_directory']['description'] = 'Куда помещать все протоколы (лог-файлы)?';

// Wo sollen alle Logfiles liegen?

$lng['serversettings']['ipaddress']['title'] = 'IP-адрес';

// IP-Adresse

$lng['serversettings']['ipaddress']['description'] = 'Какой у сервера адрес IP?';

// Welche IP-Adresse hat der Server?

$lng['serversettings']['hostname']['title'] = 'Имя хоста';

// Hostname

$lng['serversettings']['hostname']['description'] = 'Какое у сервера имя хоста (hostname)?';

// Welchen Hostname hat der Server?

$lng['serversettings']['apachereload_command']['title'] = 'Команда для перезагрузки Apache';

// Apache-Reload-Command

$lng['serversettings']['apachereload_command']['description'] = 'Как называется скрипт для перезагрузки Apache?';

// Wie heisst das Skript zum reloaden des Apache?

$lng['serversettings']['bindconf_directory']['title'] = 'Каталог (директория) для настрек Bind';

// Bind-Config-Directory

$lng['serversettings']['bindconf_directory']['description'] = 'Где находятся файлы настроек Bind?';

// Wo liegen die Bind-Konfigdateien?

$lng['serversettings']['bindreload_command']['title'] = 'Команда для перезагрузки Bind';

// Bind-Reload-Command

$lng['serversettings']['bindreload_command']['description'] = 'Как называется скрипт для перезагрузки Bind?';

// Wie heisst das Skript zum reloaden des Bind?

$lng['serversettings']['binddefaultzone']['title'] = 'Зона по умолчанию для Bind';

// Bind-Default-Zone

$lng['serversettings']['binddefaultzone']['description'] = 'Как называется стандартная зона для всех доменов?';

// Wie heisst die Default-Zone fuer alle Domains?

$lng['serversettings']['vmail_uid']['title'] = 'Mail-Uid';

// Mails-Uid

$lng['serversettings']['vmail_uid']['description'] = 'Какую UID должна использовать почтовая служба?';

// Welche UID sollen die Mails haben?

$lng['serversettings']['vmail_gid']['title'] = 'Mail-Gid';

// Mails-Gid

$lng['serversettings']['vmail_gid']['description'] = 'Какую GID должна использовать почтовая служба?';

// Welche GID sollen die Mails haben?

$lng['serversettings']['vmail_homedir']['title'] = 'Каталог почтовой службы';

// Mails-Homedir

$lng['serversettings']['vmail_homedir']['description'] = 'Где должна храниться электронная почта (eMail)?';

// Wo sollen die Mails liegen?

$lng['serversettings']['adminmail']['title'] = 'Адрес отправителя';

// Absenderadresse

$lng['serversettings']['adminmail']['description'] = 'Каким должен быть адрес отправителя для писем от системы?';

// Wie ist die Absenderadresse fuer eMails aus dem Panel?

$lng['serversettings']['phpmyadmin_url']['title'] = 'phpMyAdmin-URL';

// phpMyAdmin-URL

$lng['serversettings']['phpmyadmin_url']['description'] = 'Где находится phpMyAdmin? (начинается с http://)';

// Wo liegt der phpMyAdmin? (muss mit http:// beginnen)

$lng['serversettings']['webmail_url']['title'] = 'WebMail-URL';

// WebMail-URL

$lng['serversettings']['webmail_url']['description'] = 'Где находится WebMail? (начинается с http://)';

// Wo liegt das WebMail? (muss mit http:// beginnen)

$lng['serversettings']['webftp_url']['title'] = 'WebFTP-URL';

// WebFTP-URL

$lng['serversettings']['webftp_url']['description'] = 'Где находится WebFTP? (начинается с http://)';

// Wo liegt das WebFTP? (muss mit http:// beginnen)

$lng['serversettings']['language']['description'] = 'Какой язык является языком по умолчанию?';

// Welche Sprache ist ihre Standardsprache?

$lng['serversettings']['maxloginattempts']['title'] = 'Макс. попыток входа';

// Max Loginversuche

$lng['serversettings']['maxloginattempts']['description'] = 'Максимальное количество попыток входа до отключения аккаунта.';

// Maximale Anzahl an Loginversuchen bis der Account deaktiviert wird.

$lng['serversettings']['deactivatetime']['title'] = 'Время отключения';

// Laenge der Deaktivierung

$lng['serversettings']['deactivatetime']['description'] = 'Время (в сек.), на которое отключается аккаунт.';

// Zeitraum (in sek.) fuer den der Account deaktiviert ist.

$lng['serversettings']['pathedit']['title'] = 'Способ ввода пути';

// Pfad-Eingabemethode

$lng['serversettings']['pathedit']['description'] = 'Выбирать путь в меню, или набирать вручную?';

// Soll ein Pfad via Dropdown-Menue ausgewaehlt oder manuell eingegeben werden koennen.

/**
 * CHANGED BETWEEN 1.2.12 and 1.2.13
 */

$lng['mysql']['description'] = 'Здесь вы можете создавать и удалять базы данных MySQL.<br />Базы данных готовы к пользованию сразу после сохранения изменений.<br />В меню Вы найдёте ссылку на phpMyAdmin, которым вы можете обрабатывать базы данных.<br /><br />Данные для доступа из скриптов PHP: (Текст <i>с наклоном</i> замените соответствующими записями!)<br />Имя хоста: <b><SQL_HOST></b><br />Имя пользователя: <b><i>имя базы данных</i></b><br />Пароль: <b><i>выбранный пароль</i></b><br />База данных: <b><i>Имя базы данных</i></b>';

// Hier koennen Sie MySQL-Datenbanken anlegen und loeschen.<br />Die aenderungen werden sofort wirksam und die Datenbanken sofort benutzbar.<br />Im Menue finden Sie einen Link zum phpMyAdmin, mit dem Sie Ihre Datenbankeninhalte einfach bearbeiten koennen.<br /><br />Die Zugangsdaten von php-Skripten sind wie folgt: (Die Angaben in <i>kursiver</i> Schrift sind durch die jeweiligen Eintraege zu ersetzen!)<br />Hostname: <b><SQL_HOST></b><br />Benutzername: <b><i>Datenbankname</i></b><br />Passwort: <b><i>das gewaehlte Passwort</i></b><br />Datenbank: <b><i>Datenbankname</i></b>

/**
 * ADDED BETWEEN 1.2.12 and 1.2.13
 */

// Last Cron

$lng['serversettings']['paging']['title'] = 'Кол-во записей на страницу';

// Eintraege pro Seite

$lng['serversettings']['paging']['description'] = 'Сколько записей показывать на одной странице? (0 = отключить разбивание на страницы)';

// Wieviele Eintraege sollen auf einer Seite gezeigt werden? (0 = Paging deaktivieren)

$lng['error']['ipstillhasdomains'] = 'Комбинация IP и порта, которую вы хотите удалить, ещё прописана для минимум одного домена. Пожалуйста измените у доменов комбинацию IP и порта на другую, чтобы можно было удалить эту.';

// Die IP/Port Kombination, die Sie loeschen wollen ist noch bei einer oder mehreren Domains eingetragen. Bitte aendern sie die Domains vorher auf eine andere IP/Port Kombination um diese loeschen zu koennen.

$lng['error']['cantdeletedefaultip'] = 'Вы не можете удалить стандартную для посредников комбинацию IP и порта. Пожулуйста установите другую комбинацию IP и порта как "по умолчанию", чтобы можно было удалить эту..';

// Sie koennen die Standard IP/Port Kombination fuer Reseller nicht loeschen. Bitte setzen Sie eine andere IP/Port Kombination als Standard um diese loeschen zu koennen.

$lng['error']['cantdeletesystemip'] = 'Вы не можете удалить последний адрес IP в системе. Создайте новую комбинацию IP и порта для системного IP или измените IP системы.';

// Sie koennen die letzte System IP nicht loeschen. Entweder legen Sie eine neue IP/Port Kombination als Systemeinstellung an oder aendern die System IP.

$lng['error']['myipaddress'] = '\'IP\'';
$lng['error']['myport'] = '\'порт\'';

// \'Port\'

$lng['error']['myipdefault'] = 'Вам необходимо быврать комбинацию IP и порта, которая станет стандартной комбинацией по умолчанию.';

// Sie muessen eine IP/Port Kombination auswaehlen, die den Standard defninieren soll.

$lng['error']['myipnotdouble'] = 'Эта комбинация IP и порта уже существует.';

// Diese Kombination aus IP und Post existiert bereits.

$lng['question']['admin_ip_reallydelete'] = 'Вы уверены, что хотите удалить IP %s?';

// Wollen Sie wirklich die IP %s loeschen?

$lng['admin']['ipsandports']['ipsandports'] = 'IP-адреса и порты';

// IPs und Ports

$lng['admin']['ipsandports']['add'] = 'Добавить комбинацию IP/порт';

// IP/Port hinzufuegen

$lng['admin']['ipsandports']['edit'] = 'Редактировать комбинацию IP/порт';

// IP/Port bearbeiten

$lng['admin']['ipsandports']['ipandport'] = 'IP/порт';

// IP/Port

$lng['admin']['ipsandports']['ip'] = 'IP';

// IP

$lng['admin']['ipsandports']['port'] = 'Порт';

// Port

/**
 * ADDED BETWEEN 1.2.13 and 1.2.14
 */

$lng['panel']['translator'] = 'Переводчик';

// Uebersetzer

$lng['error']['cantchangesystemip'] = 'Вы не можете удалить последний системный адрес IP. Создайте новую комбинацию IP/порт в качестве системного адреса IP или измените существующий системный адрес IP.';

// Sie koennen die letzte System IP nicht loeschen. Entweder legen Sie noch eine neue IP/Port Kombination als Systemeinstellung an oder aendern die System IP.

$lng['question']['admin_domain_reallydocrootoutofcustomerroot'] = 'Вы уверены, что DocumentRoot этого домена должен находиться вне домашнего каталога (директории) клиента?';

// Sind Sie sicher, dass der DocumentRoot dieser Domain ausserhalb des Heimatverzeichnisses des Kunden liegen soll?

$lng['admin']['memorylimitdisabled'] = 'Отключено';

// Deaktiviert

$lng['error']['loginnameissystemaccount'] = 'Вы не можете создать аккаунт, похожий на системный. Выберите пожалуйста другое имя для аккаунта.';

// Sie können keinen Account anlegen, welcher wie ein Systemaccount aussieht. Bitte wählen Sie einen anderen Accountnamen.

$lng['domain']['openbasedirpath'] = 'Путь OpenBasedir';

// OpenBasedir-Pfad

$lng['domain']['docroot'] = 'Выше указанный путь';

// Oben eingegebener Pfad

$lng['domain']['homedir'] = 'Домашний каталог';

// Heimverzeichnis

$lng['admin']['valuemandatory'] = 'Это поле обязательно для заполнения';

// Dieses Feld muss ausgefuellt werden

$lng['admin']['valuemandatorycompany'] = 'Необходимо заполнить поля "Фамилия" и "Имя" или "Фирма"';

// Entweder "Name" und "Vorname" oder "Firma" muss ausgefuellt werden

$lng['menue']['main']['username'] = 'В системе как: ';

// Angemeldet als:

$lng['panel']['urloverridespath'] = 'URL (переписывет путь)';

// URL (ueberschreibt Pfad)

$lng['panel']['pathorurl'] = 'Путь или URL';

// Pfad oder URL

$lng['error']['sessiontimeoutiswrong'] = '"Срок действия сессии" должно являться числовым значением.';

// "Session-Timeout" muss ein numerischer Wert sein.

$lng['error']['maxloginattemptsiswrong'] = '"Макс. попыток входа" должно являться числовым значением.';

// "Maximale Loginversuche" muss ein numerischer Wert sein.

$lng['error']['deactivatetimiswrong'] = '"Время отключения" должно являться числовым значением.';

// "Laenge der Deaktivierung" muss numerisch sein.

$lng['error']['accountprefixiswrong'] = 'Неправильная "приставка клиента".';

// Das "Kundenprefix" ist falsch.

$lng['error']['mysqlprefixiswrong'] = 'Неправильная "Приставка для SQL".';

// Das "SQL-Prefix" ist falsch.

$lng['error']['ftpprefixiswrong'] = 'Неправильная "Приставка для FTP".';

// Das "FTP-Prefix" ist falsch.

$lng['error']['ipiswrong'] = 'Неправильный "IP-адрес". Разрешён только действительный адрес IP.';

// Die "IP-Adresse" ist falsch. Es ist nur eine gueltige IP-Adresse erlaubt.

$lng['error']['vmailuidiswrong'] = '"Mails-UID" должно являться числовым значением.';

// Die "Mails-UID" ist falsch. Nur eine numerische UID ist erlaubt.

$lng['error']['vmailgidiswrong'] = 'Die "Mails-GID" должно являться числовым значением.';

// Die "Mails-GID" ist falsch. Nur eine numerische GID ist erlaubt.

$lng['error']['adminmailiswrong'] = 'Неправильный "Адрес отправителя". Разрешён только действительный E-Mail-адрес';

// Die "Absenderadresse" ist fehlerhaft. Es ist nur eine gueltige E-Mail-Adresse erlaubt

$lng['error']['pagingiswrong'] = 'Настройка "Кол-во записей на страницу" должна иметь числовое значение.';

// Die "Eintraege pro Seite"-Einstellung ist falsch. Nur numerische Zeichen sind erlaubt.

$lng['error']['phpmyadminiswrong'] = '"phpMyAdmin-URL" не является действительным URL.';

// Die "phpMyAdmin-URL" ist keine gültige URL.

$lng['error']['webmailiswrong'] = '"WebMail-URL" не является действительным URL.';

// Die "WebMail-URL" ist keine gueltige URL.

$lng['error']['webftpiswrong'] = '"WebFTP-URL" не является действительным URL.';

// Die "WebFTP-URL" ist keine gueltige URL.

$lng['domains']['hasaliasdomains'] = 'Имеет alias-домен(ы)';

// Hat Aliasdomain(s)

$lng['serversettings']['defaultip']['title'] = 'IP/порт по умолчанию';

// Standard IP/Port

$lng['serversettings']['defaultip']['description'] = 'Какая комбинация IP/порт должна быть использована по умолчанию?';

// Welche IP/Port-Kombination soll standardmaessig verwendet werden?

$lng['domains']['statstics'] = 'Статистика';

// Statistiken

$lng['panel']['ascending'] = 'по возрастанию';

// aufsteigend

$lng['panel']['decending'] = 'по убыванию';

// absteigend

$lng['panel']['search'] = 'Поиск';

// Suche

$lng['panel']['used'] = 'в пользовании';

// benutzt

$lng['error']['stringformaterror'] = 'Значение поля "%s" не соответствует ожидаемому формату.';

// Der Wert des Feldes "%s" ist nicht im erwarteten Format.

/**
 * ADDED BETWEEN 1.2.14 and 1.2.15
 */

$lng['admin']['serversoftware'] = 'Программное обеспечение сервера';

// Serversoftware

$lng['admin']['phpversion'] = 'Версия PHP';

// PHP-Version

$lng['admin']['phpmemorylimit'] = 'Ограничение памяти для PHP';

// PHP-Memory-Limit

$lng['admin']['mysqlserverversion'] = 'Версия сервера MySQL';

// MySQL Server Version

$lng['admin']['mysqlclientversion'] = 'Версия клиента MySQL';

// MySQL Client Version

$lng['admin']['webserverinterface'] = 'Интерфейс вебсервера';

// Webserver Interface



?>
