<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2003-2007 the SysCP Team (see authors).
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * For the full copyright and license information, please view the COPYING
 * file that was distributed with this source code. You can also view the
 * COPYING file online at http://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  (c) the authors
 * @author     Florian Lippert <flo@syscp.org> (2003-2007)
 * @author     Froxlor Team <team@froxlor.org> (2010-)
 * @license    GPLv2 http://files.froxlor.org/misc/COPYING.txt
 * @package    Language
 * @version    $Id: czech.lng.php 105 2010-01-25 09:11:52Z EleRas $
 */

/**
 * Global
 */

$lng['translator'] = '';
$lng['panel']['edit'] = 'upravit';
$lng['panel']['delete'] = 'smazat';
$lng['panel']['create'] = 'vytvoit';
$lng['panel']['save'] = 'uloit';
$lng['panel']['yes'] = 'ano';
$lng['panel']['no'] = 'ne';
$lng['panel']['emptyfornochanges'] = 'przdn - dn zmny';
$lng['panel']['emptyfordefault'] = 'przdn - pro vchoz';
$lng['panel']['path'] = 'Cesta';
$lng['panel']['toggle'] = 'Pepnout';
$lng['panel']['next'] = 'dal';
$lng['panel']['dirsmissing'] = 'Nemohu nejt/st adres!';

/**
 * Login
 */

$lng['login']['username'] = 'Uivatel';
$lng['login']['password'] = 'Heslo';
$lng['login']['language'] = 'Jazyk';
$lng['login']['login'] = 'Pihlsit';
$lng['login']['logout'] = 'Odhlsit';
$lng['login']['profile_lng'] = 'Jazyk profilu';

/**
 * Customer
 */

$lng['customer']['documentroot'] = 'Domc adres';
$lng['customer']['name'] = 'Jmno';
$lng['customer']['firstname'] = 'Kestn jmno';
$lng['customer']['company'] = 'Spolenost';
$lng['customer']['street'] = 'Ulice';
$lng['customer']['zipcode'] = 'PS';
$lng['customer']['city'] = 'Msto';
$lng['customer']['phone'] = 'Telefon';
$lng['customer']['fax'] = 'Fax';
$lng['customer']['email'] = 'Email';
$lng['customer']['customernumber'] = 'Zkaznkovo ID';
$lng['customer']['diskspace'] = 'Webov prostor (MB)';
$lng['customer']['traffic'] = 'Penosy (GB)';
$lng['customer']['mysqls'] = 'MySQL-Databze';
$lng['customer']['emails'] = 'E-mailov-adresy';
$lng['customer']['accounts'] = 'E-mailv-ty';
$lng['customer']['forwarders'] = 'E-mailov-Peposlae';
$lng['customer']['ftps'] = 'FTP-ty';
$lng['customer']['subdomains'] = 'Sub-Domny';
$lng['customer']['domains'] = 'Domna';
$lng['customer']['unlimited'] = 'neomezeno';

/**
 * Customermenue
 */

$lng['menue']['main']['main'] = 'Hlavn';
$lng['menue']['main']['changepassword'] = 'Zmnit heslo';
$lng['menue']['main']['changelanguage'] = 'Zmnit jazyl';
$lng['menue']['email']['email'] = 'E-mail';
$lng['menue']['email']['emails'] = 'Adresy';
$lng['menue']['email']['webmail'] = 'WebMail';
$lng['menue']['mysql']['mysql'] = 'MySQL';
$lng['menue']['mysql']['databases'] = 'Databze';
$lng['menue']['mysql']['phpmyadmin'] = 'phpMyAdmin';
$lng['menue']['domains']['domains'] = 'Domny';
$lng['menue']['domains']['settings'] = 'Nastaven';
$lng['menue']['ftp']['ftp'] = 'FTP';
$lng['menue']['ftp']['accounts'] = 'ty';
$lng['menue']['ftp']['webftp'] = 'WebFTP';
$lng['menue']['extras']['extras'] = 'Extra';
$lng['menue']['extras']['directoryprotection'] = 'Ochrana adrese';
$lng['menue']['extras']['pathoptions'] = 'nastaven cesty';

/**
 * Index
 */

$lng['index']['customerdetails'] = 'Detaily zkaznka';
$lng['index']['accountdetails'] = 'Detaily tu';

/**
 * Change Password
 */

$lng['changepassword']['old_password'] = 'Star heslo';
$lng['changepassword']['new_password'] = 'Nov heslo';
$lng['changepassword']['new_password_confirm'] = 'Nov heslo (potvrzen)';
$lng['changepassword']['new_password_ifnotempty'] = 'Nov heslo (przdn = beze zmn)';
$lng['changepassword']['also_change_ftp'] = ' tak zmnit heslo k hlavnmu FTP tu';

/**
 * Domains
 */

$lng['domains']['description'] = 'Zde mete vytvoit (sub-)domny a mnit jejich cesty.<br />Systm potebuje njak as, ne se po prav nov nastaven projev.';
$lng['domains']['domainsettings'] = 'Nastaven domny';
$lng['domains']['domainname'] = 'Jmno domny';
$lng['domains']['subdomain_add'] = 'Vytvoit subdomnu';
$lng['domains']['subdomain_edit'] = 'Upravit (sub)domnu';
$lng['domains']['wildcarddomain'] = 'Vytvoit jako wildcard domnu?';
$lng['domains']['aliasdomain'] = 'Alias pro domnu';
$lng['domains']['noaliasdomain'] = 'dn alias pro domnu';

/**
 * E-mails
 */

$lng['emails']['description'] = 'Zde mete tak vytvoit a mnit e-mailov adresy.<br />et je jako Vae potovn schrnka ped Vam domem. Pokud Vm nkdo pole e-mail, pijde na tento et.<br /><br />Pro staen e-mail pouijte nsledujc nastaven ve svm potovnm klientu: (Data <i>kurzvou</i> mus bt zmnna podle toho, co jste zadali!)<br />Host: <b><i>Jmno domny</i></b><br />Uivatelsk jmno: <b><i>Jmno tu / e-mailov adresy</i></b><br />Heslo: <b><i>heslo kter jste zadali</i></b>';
$lng['emails']['emailaddress'] = 'E-mail-adresa';
$lng['emails']['emails_add'] = 'Vytvoit e-mailovou-adresu';
$lng['emails']['emails_edit'] = 'Editovat e-mailovou-addresu';
$lng['emails']['catchall'] = 'Catchall';
$lng['emails']['iscatchall'] = 'Definovat jako catchall-adresu?';
$lng['emails']['account'] = 'et';
$lng['emails']['account_add'] = 'Vytvoit et';
$lng['emails']['account_delete'] = 'Smazat et';
$lng['emails']['from'] = 'Zdroj';
$lng['emails']['to'] = 'Cl';
$lng['emails']['forwarders'] = 'Peposlatel';
$lng['emails']['forwarder_add'] = 'Vytvoit peposlatele';

/**
 * FTP
 */

$lng['ftp']['description'] = 'Zde mete vytvet a mnit FTP ty.<br />Zmny jsou provedeny okamit a ty mohou bt okamit pouity.';
$lng['ftp']['account_add'] = 'Vytvoit et';

/**
 * MySQL
 */

$lng['mysql']['databasename'] = 'jmno uivatele/databze';
$lng['mysql']['databasedescription'] = 'popis databze';
$lng['mysql']['database_create'] = 'Vytvoit databzi';

/**
 * Extras
 */

$lng['extras']['description'] = 'Zde mete vkldat extra vci, napklad ochranu adres.<br />Systm potebuje njak as, ne se zmny projev.';
$lng['extras']['directoryprotection_add'] = 'Pidat ochranu adrese';
$lng['extras']['view_directory'] = 'zobrazit obsah adrese';
$lng['extras']['pathoptions_add'] = 'pidat nastaven cesty';
$lng['extras']['directory_browsing'] = 'prohlen obsahu adrese';
$lng['extras']['pathoptions_edit'] = 'upravit nastaven cesty';
$lng['extras']['error404path'] = '404';
$lng['extras']['error403path'] = '403';
$lng['extras']['error500path'] = '500';
$lng['extras']['error401path'] = '401';
$lng['extras']['errordocument404path'] = 'URL k Chybov strnce 404';
$lng['extras']['errordocument403path'] = 'URL k Chybov strnce 403';
$lng['extras']['errordocument500path'] = 'URL k Chybov strnce 500';
$lng['extras']['errordocument401path'] = 'URL k Chybov strnce 401';

/**
 * Errors
 */

$lng['error']['error'] = 'Chyba';
$lng['error']['directorymustexist'] = 'Adres %s mus existovat. Prosm vytvote jej s pomoc Vaeho FTP klienta.';
$lng['error']['filemustexist'] = 'Soubor %s mus existovat.';
$lng['error']['allresourcesused'] = 'U jste pouili vechny sv zdroje.';
$lng['error']['domains_cantdeletemaindomain'] = 'Nemete smazat domnu, kter se pouv jako e-mailov domna.';
$lng['error']['domains_canteditdomain'] = 'Nemete upravovat tuto domnu. Byla zakzna adminem.';
$lng['error']['domains_cantdeletedomainwithemail'] = 'Nemete smazat domnu, kter se pouv jako e-mailov domna. Nejdve smate vechny emailov adresy.';
$lng['error']['firstdeleteallsubdomains'] = 'Muste smazat vechny subdomny ne budete moci vytvoit "wildcard" domnu.';
$lng['error']['youhavealreadyacatchallforthisdomain'] = 'U jste definovali "catchall" pro tuto domnu.';
$lng['error']['ftp_cantdeletemainaccount'] = 'Nemete smazat svj hlavn FTP et';
$lng['error']['login'] = 'Uivatelsk jmno nebo heslo, kter jste zadali, je patn. Prosm zkuste to znovu!';
$lng['error']['login_blocked'] = 'Tento et byl zablokovn z dvodu pli velkho mnostv chyb pi pihlen. <br />Prosm zkuste to znovu za ' . $settings['login']['deactivatetime'] . ' sekund.';
$lng['error']['notallreqfieldsorerrors'] = 'Nevyplnili jste vechna polka nebo jsou nkter vyplnna patn.';
$lng['error']['oldpasswordnotcorrect'] = 'Star heslo nen sprvn.';
$lng['error']['youcantallocatemorethanyouhave'] = 'Nemete alokovat vce zdroj ne sami vlastnte';
$lng['error']['mustbeurl'] = 'Vloili jste nesprvnou nebo nekompletn url (nap. http://somedomain.com/error404.htm)';
$lng['error']['invalidpath'] = 'Nevybrali jste sprvnou url (mon problm s "dirlistingem"?)';
$lng['error']['stringisempty'] = 'Chybjc vstup v poli';
$lng['error']['stringiswrong'] = 'patn vstup v poli';
$lng['error']['myloginname'] = '\'' . $lng['login']['username'] . '\'';
$lng['error']['mypassword'] = '\'' . $lng['login']['password'] . '\'';
$lng['error']['oldpassword'] = '\'' . $lng['changepassword']['old_password'] . '\'';
$lng['error']['newpassword'] = '\'' . $lng['changepassword']['new_password'] . '\'';
$lng['error']['newpasswordconfirm'] = '\'' . $lng['changepassword']['new_password_confirm'] . '\'';
$lng['error']['newpasswordconfirmerror'] = 'Nov heslo se neshoduje s tm pro potvrzen';
$lng['error']['myname'] = '\'' . $lng['customer']['name'] . '\'';
$lng['error']['myfirstname'] = '\'' . $lng['customer']['firstname'] . '\'';
$lng['error']['emailadd'] = '\'' . $lng['customer']['email'] . '\'';
$lng['error']['mydomain'] = '\'Domain\'';
$lng['error']['mydocumentroot'] = '\'Documentroot\'';
$lng['error']['loginnameexists'] = 'Pihlaovac jmno %s ji existuje';
$lng['error']['emailiswrong'] = 'Emailov adresa %s obsahuje nepovolen znaky nebo je nekompletn';
$lng['error']['loginnameiswrong'] = 'Pihlaovac jmno %s obsahuje nepovolen znaky';
$lng['error']['userpathcombinationdupe'] = 'Kombinace Uivatelskho jmna a cesty ji existuje';
$lng['error']['patherror'] = 'Obecn chyba! Cesta neme bt przdn';
$lng['error']['errordocpathdupe'] = 'Monost pro cestu %s ji existuje';
$lng['error']['adduserfirst'] = 'Vytvote prosm nejdve zkaznka';
$lng['error']['domainalreadyexists'] = 'Domna %s je ji piazena k zkaznkovi';
$lng['error']['nolanguageselect'] = 'Nebyl vybrn dn jazyk.';
$lng['error']['nosubjectcreate'] = 'Muste definovat tma pro tuto e-mailovou ablonu.';
$lng['error']['nomailbodycreate'] = 'Muste definovat text e-mailu pro tuto e-mailovou ablonu.';
$lng['error']['templatenotfound'] = 'ablona nebyla nalezena.';
$lng['error']['alltemplatesdefined'] = 'Nemete definovat vce ablon, vechny jazyky jsou ji podporovny.';
$lng['error']['wwwnotallowed'] = 'www nen povoleno pro subdomny.';
$lng['error']['subdomainiswrong'] = 'Subdomna %s obsahuje neplatn znaky.';
$lng['error']['domaincantbeempty'] = 'Jmno domny nesm bt przdn.';
$lng['error']['domainexistalready'] = 'Domna %s ji existuje.';
$lng['error']['domainisaliasorothercustomer'] = 'Vybran alias pro domnu je bu sama aliasem domny nebo pat jinmu zkaznkovi.';
$lng['error']['emailexistalready'] = 'E-mailov adresa %s ji existuje.';
$lng['error']['maindomainnonexist'] = 'Hlavn domna %s neexistuje.';
$lng['error']['destinationnonexist'] = 'Prosm vytvote peposlatele v poli \'Cl\'.';
$lng['error']['destinationalreadyexistasmail'] = 'Peposla na %s ji existuje jako aktivn emailov adresa.';
$lng['error']['destinationalreadyexist'] = 'U jste nastavili peposla na %s .';
$lng['error']['destinationiswrong'] = 'Peposla %s obsahuje nesprvn znaky nebo nen kompletn.';
$lng['error']['domainname'] = $lng['domains']['domainname'];

/**
 * Questions
 */

$lng['question']['question'] = 'Bezpenostn otzka';
$lng['question']['admin_customer_reallydelete'] = 'Chcete opravdu smazat uivatele %s? Akci nelze vzt zpt!';
$lng['question']['admin_domain_reallydelete'] = 'Chcete opravdu smazat domnu %s?';
$lng['question']['admin_domain_reallydisablesecuritysetting'] = 'Chcete opravdu deaktivovat tato Bezpenostn nastaven (OpenBasedir a/nebo SafeMode)?';
$lng['question']['admin_admin_reallydelete'] = 'Chcete opravdu smazat administrtory %s? Kad zkaznk a domna bude nastavena k Vaemu tu.';
$lng['question']['admin_template_reallydelete'] = 'Chcete opravdu smazat ablonu \'%s\'?';
$lng['question']['domains_reallydelete'] = 'Chcete opravdu smazat domnu %s?';
$lng['question']['email_reallydelete'] = 'Opravdu chcete smazat e-mailovou adresu %s?';
$lng['question']['email_reallydelete_account'] = 'Chcete opravdu smazat e-mailov et %s?';
$lng['question']['email_reallydelete_forwarder'] = 'Chcete opravdu smazat peposla %s?';
$lng['question']['extras_reallydelete'] = 'Chcete opravdu odstranit ochranu adrese %s?';
$lng['question']['extras_reallydelete_pathoptions'] = 'Opravdu chcete smazat nastaven cesty pro %s?';
$lng['question']['ftp_reallydelete'] = 'Opravdu chcete smazat FTP et %s?';
$lng['question']['mysql_reallydelete'] = 'Opravdu chcete smazat databzi %s? Tato akce neme bt vzata zpt!';
$lng['question']['admin_configs_reallyrebuild'] = 'Opravdu chcete rebuildovat apache a nabindovat konfiguran soubory?';

/**
 * Mails
 */

$lng['mails']['pop_success']['mailbody'] = 'Dobr den,\n\nV e-mailov et {EMAIL}\nbyl v podku nastaven.\n\nToto je automaticky vytvoen\ne-mail, prosm neodpovdejte na nj!\n\nPejeme hezk den, Froxlor-Team';
$lng['mails']['pop_success']['subject'] = 'Potovn et byl spn nastaven';
$lng['mails']['createcustomer']['mailbody'] = 'Dobr den, {FIRSTNAME} {NAME},\n\nzde jsou informace o Vaem tu:\n\nUivatel: {USERNAME}\nHeslo: {PASSWORD}\n\nDkujeme,\nFroxlor-Team';
$lng['mails']['createcustomer']['subject'] = 'Informace o tu';

/**
 * Admin
 */

$lng['admin']['overview'] = 'Pehled';
$lng['admin']['ressourcedetails'] = 'Pouit zdroje';
$lng['admin']['systemdetails'] = 'Detaily systmu';
$lng['admin']['froxlordetails'] = 'Froxlor Detaily';
$lng['admin']['installedversion'] = 'Nainstalovan verze';
$lng['admin']['latestversion'] = 'Posledn verze';
$lng['admin']['lookfornewversion']['clickhere'] = 'hledat pes webservice';
$lng['admin']['lookfornewversion']['error'] = 'Chyba pi ten';
$lng['admin']['resources'] = 'Zdroje';
$lng['admin']['customer'] = 'Zkaznk';
$lng['admin']['customers'] = 'Zkaznci';
$lng['admin']['customer_add'] = 'Vytvoit zkaznka';
$lng['admin']['customer_edit'] = 'Upravit zkaznka';
$lng['admin']['domains'] = 'Domny';
$lng['admin']['domain_add'] = 'Vytvoit domnu';
$lng['admin']['domain_edit'] = 'Upravit domnu';
$lng['admin']['subdomainforemail'] = 'Subdomny jako emailov domny';
$lng['admin']['admin'] = 'Administrtor';
$lng['admin']['admins'] = 'Administrtoi';
$lng['admin']['admin_add'] = 'Vytvoit administrtora';
$lng['admin']['admin_edit'] = 'Upravit administrtora';
$lng['admin']['customers_see_all'] = 'Me vidt vechy zkaznky?';
$lng['admin']['domains_see_all'] = 'Me vidt vechny domny?';
$lng['admin']['change_serversettings'] = 'Me mnit nastaven serveru?';
$lng['admin']['server'] = 'Server';
$lng['admin']['serversettings'] = 'Nastaven';
$lng['admin']['rebuildconf'] = 'Pebudovat konfiguran soubory';
$lng['admin']['stdsubdomain'] = 'Standardn subdomna';
$lng['admin']['stdsubdomain_add'] = 'Vytvoit standardn subdomnu';
$lng['admin']['phpenabled'] = 'PHP zapnuto';
$lng['admin']['deactivated'] = 'Deaktivovno';
$lng['admin']['deactivated_user'] = 'Deaktivovat uivatele';
$lng['admin']['sendpassword'] = 'Zaslat heslo';
$lng['admin']['ownvhostsettings'] = 'Vlastn vHost-nastaven';
$lng['admin']['configfiles']['serverconfiguration'] = 'Konfigurace';
$lng['admin']['configfiles']['files'] = '<b>Konfiguran soubory:</b> Prosm zmte nsledujc soubory nabo je vytvote s<br /> nsledujcm obsahem, pokud neexistuj.<br /><b>Poznmka:</b> MySQL heslo nebylo nahrazeno z bezpenostnch dvod.<br />Prosm nahrate &quot;MYSQL_PASSWORD&quot; svm vlastnm. Pokud jste zapomnli sv mysql heslo<br />najdete jej v &quot;lib/userdata.inc.php&quot;.';
$lng['admin']['configfiles']['commands'] = '<b>Pkazy:</b> Prosm spuste nsledujc pkazy v pkazovm dku.';
$lng['admin']['configfiles']['restart'] = '<b>Restart:</b> Prosm spuste nsledujc pkazy v pkazovm dku, aby jste nahrli novou konfiguraci.';
$lng['admin']['templates']['templates'] = 'ablony';
$lng['admin']['templates']['template_add'] = 'Pidat ablonu';
$lng['admin']['templates']['template_edit'] = 'Upravit ablonu';
$lng['admin']['templates']['action'] = 'Akce';
$lng['admin']['templates']['email'] = 'E-Mail';
$lng['admin']['templates']['subject'] = 'Pedmt';
$lng['admin']['templates']['mailbody'] = 'Tlo mailu';
$lng['admin']['templates']['createcustomer'] = 'Uvtac mail pro nov zkaznky';
$lng['admin']['templates']['pop_success'] = 'Uvtac mail pro nov emailov ty';
$lng['admin']['templates']['template_replace_vars'] = 'Promnn k nahrazen v ablon:';
$lng['admin']['templates']['FIRSTNAME'] = 'Nahrazeno kestnm jmnem zkaznka.';
$lng['admin']['templates']['NAME'] = 'Nahrazeno jmnem zkaznka.';
$lng['admin']['templates']['USERNAME'] = 'Nahrazeno uivatelskm jmnem zkaznka.';
$lng['admin']['templates']['PASSWORD'] = 'Nahrazeno zkaznkovm heslem.';
$lng['admin']['templates']['EMAIL'] = 'Nahrazeno adresou POP3/IMAP tu.';

/**
 * Serversettings
 */

$lng['serversettings']['session_timeout']['title'] = 'Session Timeout';
$lng['serversettings']['session_timeout']['description'] = 'Jak dlouho mus bt uivatel neaktivn, ne session vypr (sekundy)?';
$lng['serversettings']['accountprefix']['title'] = 'Zkaznkova pedpona';
$lng['serversettings']['accountprefix']['description'] = 'Jk pedpony by mly mt ty zkaznk?';
$lng['serversettings']['mysqlprefix']['title'] = 'SQL pedpona';
$lng['serversettings']['mysqlprefix']['description'] = 'Jak pedpony by mly mt ty mysql?';
$lng['serversettings']['ftpprefix']['title'] = 'FTP pedpona';
$lng['serversettings']['ftpprefix']['description'] = 'Jakou pedponu by mly mt ftp ty?';
$lng['serversettings']['documentroot_prefix']['title'] = 'Domc adres';
$lng['serversettings']['documentroot_prefix']['description'] = 'Kde by mly bt uloeny vechny domc adrese?';
$lng['serversettings']['logfiles_directory']['title'] = 'Adres pro log soubory';
$lng['serversettings']['logfiles_directory']['description'] = 'Kde by mly bt vechny log soubory uloeny?';
$lng['serversettings']['ipaddress']['title'] = 'IP-Adresa';
$lng['serversettings']['ipaddress']['description'] = 'Jak je IP adresa tohoto serveru?';
$lng['serversettings']['hostname']['title'] = 'Jmno hosta';
$lng['serversettings']['hostname']['description'] = 'Jak je jmno hosta tohoto serveru?';
$lng['serversettings']['apachereload_command']['title'] = 'Pkaz pro reload apache';
$lng['serversettings']['apachereload_command']['description'] = 'Jak je pkaz, kterm apache znovunahraje sv konfiguran soubory?';
$lng['serversettings']['bindconf_directory']['title'] = 'Bindujte konfiguran adres';
$lng['serversettings']['bindconf_directory']['description'] = 'Kde by mly bt uloeny "bind configfiles"?';
$lng['serversettings']['bindreload_command']['title'] = 'Bind reload pkaz';
$lng['serversettings']['bindreload_command']['description'] = 'Jak je pkaz pro znovunahrn "bind configfiles"?';
$lng['serversettings']['binddefaultzone']['title'] = 'Bind vchoz zna';
$lng['serversettings']['binddefaultzone']['description'] = 'Jak je nzev vchoz zny?';
$lng['serversettings']['vmail_uid']['title'] = 'UID-mail';
$lng['serversettings']['vmail_uid']['description'] = 'Jak UserID by mly e-maily mt?';
$lng['serversettings']['vmail_gid']['title'] = 'GID-mail';
$lng['serversettings']['vmail_gid']['description'] = 'Jak GroupID by mly maily mt?';
$lng['serversettings']['vmail_homedir']['title'] = 'Mails-Home adres';
$lng['serversettings']['vmail_homedir']['description'] = 'Kam by se mly vechny maily ukldat?';
$lng['serversettings']['adminmail']['title'] = 'Odeslatel';
$lng['serversettings']['adminmail']['description'] = 'Jak je odeslatelova adresa pro emaily odeslan z Panelu?';
$lng['serversettings']['phpmyadmin_url']['title'] = 'phpMyAdminova URL';
$lng['serversettings']['phpmyadmin_url']['description'] = 'Jak je URL adresa phpMyAdmin? (mus zanat http(s)://)';
$lng['serversettings']['webmail_url']['title'] = 'WebMailov URL';
$lng['serversettings']['webmail_url']['description'] = 'Jak je URL adresa k WebMailu? (mus zanat with http(s)://)';
$lng['serversettings']['webftp_url']['title'] = 'WebFTP URL';
$lng['serversettings']['webftp_url']['description'] = 'Jak je URL k WebFTP? (mus zanat with http(s)://)';
$lng['serversettings']['language']['description'] = 'Jak je vchoz jazyk Vaeho serveru?';
$lng['serversettings']['maxloginattempts']['title'] = 'Maximln poet pokus o pihlen';
$lng['serversettings']['maxloginattempts']['description'] = 'Maximln poet pokus o pihlen k tu, ne se et zablokuje.';
$lng['serversettings']['deactivatetime']['title'] = 'Deaktivovan po dobu';
$lng['serversettings']['deactivatetime']['description'] = 'as (sek.) po kter bude et deaktivovn pro pli mnoho pokus o pihlen.';
$lng['serversettings']['pathedit']['title'] = 'Typ vstupu cesty';
$lng['serversettings']['pathedit']['description'] = 'Mla by bt cesta vybrna pomoc vyskakovacho menu nebo vstupnm polem?';
$lng['serversettings']['nameservers']['title'] = 'Nameservery';
$lng['serversettings']['nameservers']['description'] = 'Stednkem oddlen seznam obsahujc hostname vech nameserver. Prvn bude primrn.';
$lng['serversettings']['mxservers']['title'] = 'MX servery';
$lng['serversettings']['mxservers']['description'] = 'Stednkem oddlen seznam obsahujc pry sel a hostname oddlench mezerou (nap. \'10 mx.example.com\') obsahujc mx servery.';

/**
 * CHANGED BETWEEN 1.2.12 and 1.2.13
 */

$lng['mysql']['description'] = 'Zde mete vytvet a mnit sv MySQL-Databze.<br />Zmny jsou provedeny okamit a databze me bt okamit pouvna.<br />V menu vlevo mete najt nstroj phpMyAdmin se kterm mete jednodue upravovat svou databzi.<br /><br />Pro pouit databze ve svch php skriptech pouijte nsledujc nastaven: (Data <i>kurzvou</i> mus bt zmnna na Vmi vloen hodnoty!)<br />Host: <b><SQL_HOST></b><br />Uivatelsk jmno: <b><i>Databasename</i></b><br />Heslo: <b><i>heslo kter jste zvolili</i></b><br />Databze: <b><i>Databasename</i></b>';

/**
 * ADDED BETWEEN 1.2.12 and 1.2.13
 */

$lng['admin']['cronlastrun'] = 'Posledn generovn konfiguranch soubor';
$lng['serversettings']['paging']['title'] = 'Zznam na strnku';
$lng['serversettings']['paging']['description'] = 'Kolik zznam by mlo bt zobrazeno na strnce? (0 = zruit strnkovn)';
$lng['error']['ipstillhasdomains'] = 'IP/Port kombinace, kterou chcete smazat m stle piazen domny, prosm peate je k jin IP/Port kombinaci ne smaete tuto IP/Port kombinaci.';
$lng['error']['cantdeletedefaultip'] = 'Nemete smazat IP/Port kombinaci vchozho peprodejce, prosm vytvote jinou IP/Port kombinaci vchoz pro peprodejce ne smaete tuto IP/Port kombinaci.';
$lng['error']['cantdeletesystemip'] = 'Nemete smazat posledn systmovou IP, bu vytvote novou IP/Port kombinaci pro systmovou IP nebo zmte IP systmu.';
$lng['error']['myipaddress'] = '\'IP\'';
$lng['error']['myport'] = '\'Port\'';
$lng['error']['myipdefault'] = 'Muste vybrat IP/Port kombinaci kter by se mla stt vchoz.';
$lng['error']['myipnotdouble'] = 'Tato kombinace IP/Portu ji existuje.';
$lng['question']['admin_ip_reallydelete'] = 'Chcete opravdu smayat IP adresu %s?';
$lng['admin']['ipsandports']['ipsandports'] = 'IP a Porty';
$lng['admin']['ipsandports']['add'] = 'Pidat IP/Port';
$lng['admin']['ipsandports']['edit'] = 'Upravit IP/Port';
$lng['admin']['ipsandports']['ipandport'] = 'IP/Port';
$lng['admin']['ipsandports']['ip'] = 'IP';
$lng['admin']['ipsandports']['port'] = 'Port';

// ADDED IN 1.2.13-rc3

$lng['error']['cantchangesystemip'] = 'Nemete zmnit posledn systmovou IP, bu vytvote novou IP/Port kombinaci pro systmovou IP nebo zmte IP systmu.';
$lng['question']['admin_domain_reallydocrootoutofcustomerroot'] = 'Jste si jisti, e chcete aby root dokument pro tuto domnu nebyl v "customerroot" zkaznka?';

// ADDED IN 1.2.14-rc1

$lng['admin']['memorylimitdisabled'] = 'Zakzno';
$lng['domain']['openbasedirpath'] = 'OpenBasedir-cesta';
$lng['domain']['docroot'] = 'Cesta z polka nahoe';
$lng['domain']['homedir'] = 'Domovn adres';
$lng['admin']['valuemandatory'] = 'Tato hodnota je povinn';
$lng['admin']['valuemandatorycompany'] = 'Bu &quot;jmno&quot; a &quot;kestn jmno&quot; nebo &quot;spolenost&quot; mus bt vyplnna';
$lng['menue']['main']['username'] = 'Pihlen(a) jako: ';
$lng['panel']['urloverridespath'] = 'URL (pepe cestu)';
$lng['panel']['pathorurl'] = 'Cesta nebo URL';
$lng['error']['sessiontimeoutiswrong'] = 'Pouze seln &quot;Session Timeout&quot; je povoleno.';
$lng['error']['maxloginattemptsiswrong'] = 'ouze seln &quot;Maximln poet pokus o pihlen&quot; je povoleno.';
$lng['error']['deactivatetimiswrong'] = 'ouze seln &quot;as deaktivace&quot; je povoleno.';
$lng['error']['accountprefixiswrong'] = '&quot;Pedpona uivatele&quot; je patn.';
$lng['error']['mysqlprefixiswrong'] = '&quot;SQL pedpona&quot; je patn.';
$lng['error']['ftpprefixiswrong'] = '&quot;FTP pedpona&quot; je patn.';
$lng['error']['ipiswrong'] = '&quot;IP-Adresa&quot; je patn. Pouze validn IP adresa je povolena.';
$lng['error']['vmailuidiswrong'] = '&quot;Mails-uid&quot; je patn. Je povoleno pouze seln UID.';
$lng['error']['vmailgidiswrong'] = '&quot;Mails-gid&quot; je patn. Je povoleno pouze seln GID.';
$lng['error']['adminmailiswrong'] = '&quot;Sender-address&quot; je patn. Je povolena pouze validn emailov adresa.';
$lng['error']['pagingiswrong'] = '&quot;Entries per Page&quot;-value je patn. Jsou povolena pouze sla.';
$lng['error']['phpmyadminiswrong'] = 'phpMyAdmin-url nan sprvn url.';
$lng['error']['webmailiswrong'] = 'WebMail-odkaz nen sprvn odkaz.';
$lng['error']['webftpiswrong'] = 'WebFTP-odkaz nen sprvn odkaz.';
$lng['domains']['hasaliasdomains'] = 'M aliasov domny';
$lng['serversettings']['defaultip']['title'] = 'Vchoz IP/Port';
$lng['serversettings']['defaultip']['description'] = 'Jak je vchoz IP/Port kombinace?';
$lng['domains']['statstics'] = 'Statistika pouit';
$lng['panel']['ascending'] = 'sestupn';
$lng['panel']['decending'] = 'vzestupn';
$lng['panel']['search'] = 'Vyhledvn';
$lng['panel']['used'] = 'pouito';

// ADDED IN 1.2.14-rc3

$lng['panel']['translator'] = 'Pekladatel';

// ADDED IN 1.2.14-rc4

$lng['error']['stringformaterror'] = 'Hodnota pole &quot;%s&quot; nen v oekvanm formtu.';

// ADDED IN 1.2.15-rc1

$lng['admin']['serversoftware'] = 'Software serveru';
$lng['admin']['phpversion'] = 'PHP-Verze';
$lng['admin']['phpmemorylimit'] = 'PHP-Limit-Pamti';
$lng['admin']['mysqlserverversion'] = 'MySQL verze serveru';
$lng['admin']['mysqlclientversion'] = 'MySQL verze klienta';
$lng['admin']['webserverinterface'] = 'Webserver rozhran';
$lng['domains']['isassigneddomain'] = 'Je piazen domna';
$lng['serversettings']['phpappendopenbasedir']['title'] = 'Cesty k pidn k OpenBasedir';
$lng['serversettings']['phpappendopenbasedir']['description'] = 'Tyto cesty (oddleny pomoc "colons") budou vloeny  do OpenBasedir-statementu v kadm vhost-containeru.';

// CHANGED IN 1.2.15-rc1

$lng['error']['loginnameissystemaccount'] = 'Nemete vytvoit ty, kter jsou podobn systmovm tm (napklad zanaj &quot;%s&quot;). Prosm vlote jin jmno tu.';
$lng['error']['youcantdeleteyourself'] = 'Z bezpenostnch dvod se nemete smazat.';
$lng['error']['youcanteditallfieldsofyourself'] = 'Poznmka: Z bezpenostnch dvod nemete upravovat vechna pole svho tu.';

// ADDED IN 1.2.16-svn1

$lng['serversettings']['natsorting']['title'] = 'Pout "lidsk" tdn v seznamech';
$lng['serversettings']['natsorting']['description'] = 'adit seznamy jako web1 -> web2 -> web11 msto web1 -> web11 -> web2.';

// ADDED IN 1.2.16-svn2

$lng['serversettings']['deactivateddocroot']['title'] = 'Docroot pro deaktivovan uivatele';
$lng['serversettings']['deactivateddocroot']['description'] = 'Kdy bude uivatel deaktivovn, tato cesta bude pouita jako jeho docroot. Ponechte przdn, pokud nechcete vytvet.';

// ADDED IN 1.2.16-svn4

$lng['panel']['reset'] = 'zruit zmny';
$lng['admin']['accountsettings'] = 'Nastaven tu';
$lng['admin']['panelsettings'] = 'Nastaven panelu';
$lng['admin']['systemsettings'] = 'Nastaven systmu';
$lng['admin']['webserversettings'] = 'Nastaven webserveru';
$lng['admin']['mailserversettings'] = 'Nastaven mailserveru';
$lng['admin']['nameserversettings'] = 'Nastaven nameserveru';
$lng['admin']['updatecounters'] = 'Pepotat vyuit zdroj';
$lng['question']['admin_counters_reallyupdate'] = 'Opravdu chcete pepotat vyuit zdroj?';
$lng['panel']['pathDescription'] = 'Pokud adres neexistuje, bude vytvoen automaticky.';

// ADDED IN 1.2.16-svn6

$lng['mails']['trafficninetypercent']['mailbody'] = 'Ven uivateli {NAME},\n\nPouil jste {TRAFFICUSED} MB z Vmi dostupnch {TRAFFIC} MB penos.\nTo je vce jak 90%.\n\nPejeme hezk den, Froxlor-Team';
$lng['mails']['trafficninetypercent']['subject'] = 'Dosahujc vaeho limitu penos';
$lng['admin']['templates']['trafficninetypercent'] = 'Upozorovac mail pro zkaznky, pokud vyerpaj 90% z penos';
$lng['admin']['templates']['TRAFFIC'] = 'Nahrazeno penosy, kter byly pidleny uivateli.';
$lng['admin']['templates']['TRAFFICUSED'] = 'Nahrazeno penosy, kter byly vyerpny zkaznkem.';

// ADDED IN 1.2.16-svn7

$lng['admin']['subcanemaildomain']['never'] = 'Nikdy';
$lng['admin']['subcanemaildomain']['choosableno'] = 'Vbr, vchoz ne';
$lng['admin']['subcanemaildomain']['choosableyes'] = 'Vbr, vchoz ano';
$lng['admin']['subcanemaildomain']['always'] = 'Vdy';
$lng['changepassword']['also_change_webalizer'] = ' tak zmte heslo pro webalizer statistics';

// ADDED IN 1.2.16-svn8

$lng['serversettings']['mailpwcleartext']['title'] = 'Tak ulote hesla mailovch t neifrovan v databzi';
$lng['serversettings']['mailpwcleartext']['description'] = 'Pokud je toto nastaveno na "ano", vechna hesla budou ukldna bez ifrovn (st text, iteln pro kohokoliv s pstupem k databzi) v tabulce mail_users. Toto aktivujte jen pokud to opravdu potebujete!';
$lng['serversettings']['mailpwcleartext']['removelink'] = 'Kliknutm zde vymaete vechna nezaifrovan hesla z tabulky.';
$lng['question']['admin_cleartextmailpws_reallywipe'] = 'Opravdu chcete vymazat vechna nezaifrovan hesla pro e-mailov ty z tabulky mail_users? Tento krok nelze vrtit zpt!';
$lng['admin']['configfiles']['overview'] = 'Pehled';
$lng['admin']['configfiles']['wizard'] = 'Prvodce';
$lng['admin']['configfiles']['distribution'] = 'Distribuce';
$lng['admin']['configfiles']['service'] = 'Sluba';
$lng['admin']['configfiles']['daemon'] = 'Daemon';
$lng['admin']['configfiles']['http'] = 'Webserver (HTTP)';
$lng['admin']['configfiles']['dns'] = 'Nameserver (DNS)';
$lng['admin']['configfiles']['mail'] = 'Mailserver (IMAP/POP3)';
$lng['admin']['configfiles']['smtp'] = 'Mailserver (SMTP)';
$lng['admin']['configfiles']['ftp'] = 'FTP-Server';
$lng['admin']['configfiles']['etc'] = 'Ostatn (System)';
$lng['admin']['configfiles']['choosedistribution'] = '-- Vyberte distribuci --';
$lng['admin']['configfiles']['chooseservice'] = '-- Vyberte slubu --';
$lng['admin']['configfiles']['choosedaemon'] = '-- Vyberte daemona --';
$lng['admin']['trafficlastrun'] = 'Posledn kalkulace penos';

// ADDED IN 1.2.16-svn10

$lng['serversettings']['ftpdomain']['title'] = 'FTP ty na domn';
$lng['serversettings']['ftpdomain']['description'] = 'Zkaznci mohou vytvet FTP ty user@customerdomain?';
$lng['panel']['back'] = 'Back';

// ADDED IN 1.2.16-svn12

$lng['serversettings']['mod_log_sql']['title'] = 'Doasn ukldat logy do databze';
$lng['serversettings']['mod_log_sql']['description'] = 'Pout <a href="http://www.outoforder.cc/projects/apache/mod_log_sql/" title="mod_log_sql">mod_log_sql</a> pro doasn uloen webrequest<br /><b>Toto vyaduje speciln <a href="http://files.syscp.org/docs/mod_log_sql/" title="mod_log_sql - documentation">konfiguraci apache</a>!</b>';
$lng['serversettings']['mod_fcgid']['title'] = 'Includuj PHP pes mod_fcgid/suexec';
$lng['serversettings']['mod_fcgid']['description'] = 'Pouij mod_fcgid/suexec/libnss_mysql pro bh PHP s odpovdajcm ivatelskm tem.<br/><b>toto vyaduje speciln konfiguraci apache!</b>';
$lng['serversettings']['sendalternativemail']['title'] = 'Pouij alternativn e-mailovou adresu';
$lng['serversettings']['sendalternativemail']['description'] = 'Poli email s heslem na jinou adresu pi vytven emailovho tu';
$lng['emails']['alternative_emailaddress'] = 'Alternativn e-mailov adresa';
$lng['mails']['pop_success_alternative']['mailbody'] = 'Ven uivateli,\n\nV emailov et {EMAIL}\nbyl spn nastaven.\nVae heslo je {PASSWORD}.\n\nTento e-mail byl automaticky vygenerovn,\nprosm neodpovdejte na nj!\n\nPejeme Vm hezk den, Froxlor-Team';
$lng['mails']['pop_success_alternative']['subject'] = 'E-mailov et byl spn vytvoen';
$lng['admin']['templates']['pop_success_alternative'] = 'Uvtac e-mail pro nov ty byl odesln na alternativn adresu';
$lng['admin']['templates']['EMAIL_PASSWORD'] = 'Nahrazeno heslem tu POP3/IMAP.';

// ADDED IN 1.2.16-svn13

$lng['error']['documentrootexists'] = 'Adres &quot;%s&quot; ji existuje pro tohoto zkaznka. Prosm odstrate jej, ne budete znovu zkaznka vkldat.';

// ADDED IN 1.2.16-svn14

$lng['serversettings']['apacheconf_vhost']['title'] = 'Apache vhost konfiguran soubor/dirname';
$lng['serversettings']['apacheconf_vhost']['description'] = 'Kde by mla bt uloena konfigurace vhosta? Mete zde bu specifikovat soubor (vichni vhosti v jednom souboru) nebo adres (kad vhost m vlastn soubor).';
$lng['serversettings']['apacheconf_diroptions']['title'] = 'Apache diroptions konfiguran soubor/dirname';
$lng['serversettings']['apacheconf_diroptions']['description'] = 'Kde by mla bt uloena konfigurace diroptions?  Mete zde bu specifikovat soubor (vichni diroptions v jednom souboru) nebo adres (kad diroption m vlastn soubor).';
$lng['serversettings']['apacheconf_htpasswddir']['title'] = 'Apache htpasswd dirname';
$lng['serversettings']['apacheconf_htpasswddir']['description'] = 'Kde by mly bt uloeny htpasswd soubory pro ochranu adres?';

// ADDED IN 1.2.16-svn15

$lng['error']['formtokencompromised'] = 'The request seems to be compromised. Z bezpenostnch dvod jste byli odhleni.';
$lng['serversettings']['mysql_access_host']['title'] = 'MySQL-Access-Hosts';
$lng['serversettings']['mysql_access_host']['description'] = 'Stednkem oddlen seznam host, ze kterch bude dovoleno uivatelm se pipojit k MySQL-Serveru.';

// ADDED IN 1.2.18-svn1

$lng['admin']['ipsandports']['create_listen_statement'] = 'Vytvoit Listen statement';
$lng['admin']['ipsandports']['create_namevirtualhost_statement'] = 'Vytvoit NameVirtualHost statement';
$lng['admin']['ipsandports']['create_vhostcontainer'] = 'Vytvoit vHost-Container';
$lng['admin']['ipsandports']['create_vhostcontainer_servername_statement'] = 'Vytvoit ServerName statement v vHost-Container';

// ADDED IN 1.2.18-svn2

$lng['admin']['webalizersettings'] = 'Nastaven Webalizeru';
$lng['admin']['webalizer']['normal'] = 'Normln';
$lng['admin']['webalizer']['quiet'] = 'Tich';
$lng['admin']['webalizer']['veryquiet'] = 'dn vstup';
$lng['serversettings']['webalizer_quiet']['title'] = 'Vstup Webalizeru';
$lng['serversettings']['webalizer_quiet']['description'] = 'Povdavost webalizer-programu';

// ADDED IN 1.2.18-svn3

$lng['ticket']['admin_email'] = 'root@localhost';
$lng['ticket']['noreply_email'] = 'tikety@froxlor';
$lng['admin']['ticketsystem'] = 'Support-tikety';
$lng['menue']['ticket']['ticket'] = 'Support tikety';
$lng['menue']['ticket']['categories'] = 'Kategorie podpory';
$lng['menue']['ticket']['archive'] = 'Archiv-tiket';
$lng['ticket']['description'] = 'Nastavit popis zde!';
$lng['ticket']['ticket_new'] = 'Otevt nov tiket';
$lng['ticket']['ticket_reply'] = 'zodpovdt tiket';
$lng['ticket']['ticket_reopen'] = 'Znovuotevt tiket';
$lng['ticket']['ticket_newcateory'] = 'Vytvoit novou kategorii';
$lng['ticket']['ticket_editcateory'] = 'Upravit kategorii';
$lng['ticket']['ticket_view'] = 'Zobrazit ticketcourse';
$lng['ticket']['ticketcount'] = 'Tikety';
$lng['ticket']['ticket_answers'] = 'Odpovdi';
$lng['ticket']['lastchange'] = 'Posledn akce';
$lng['ticket']['subject'] = 'Pedmt';
$lng['ticket']['status'] = 'Status';
$lng['ticket']['lastreplier'] = 'Posledn odpovdajc';
$lng['ticket']['priority'] = 'Priorita';
$lng['ticket']['low'] = '<span class="ticket_low">Nzk</span>';
$lng['ticket']['normal'] = '<span class="ticket_normal">Normln</span>';
$lng['ticket']['high'] = '<span class="ticket_high">Vysok</span>';
$lng['ticket']['unf_low'] = 'Nzk';
$lng['ticket']['unf_normal'] = 'Normln';
$lng['ticket']['unf_high'] = 'Vysok';
$lng['ticket']['lastchange'] = 'Posledn zmna';
$lng['ticket']['lastchange_from'] = 'Od data (dd.mm.yyyy)';
$lng['ticket']['lastchange_to'] = 'Do data (dd.mm.yyyy)';
$lng['ticket']['category'] = 'Kategorie';
$lng['ticket']['no_cat'] = 'dn';
$lng['ticket']['message'] = 'Zprva';
$lng['ticket']['show'] = 'Zobraz';
$lng['ticket']['answer'] = 'Odpov';
$lng['ticket']['close'] = 'Zavt';
$lng['ticket']['reopen'] = 'Znovuotevt';
$lng['ticket']['archive'] = 'Archiv';
$lng['ticket']['ticket_delete'] = 'Smazat tiket';
$lng['ticket']['lastarchived'] = 'Nedvno archivovan tikety';
$lng['ticket']['archivedtime'] = 'Archivovno';
$lng['ticket']['open'] = 'Otevt';
$lng['ticket']['wait_reply'] = 'ek na odpov';
$lng['ticket']['replied'] = 'Odpovzeno';
$lng['ticket']['closed'] = 'Zaven';
$lng['ticket']['staff'] = 'Personl';
$lng['ticket']['customer'] = 'Zkaznk';
$lng['ticket']['old_tickets'] = 'Tiket zprvy';
$lng['ticket']['search'] = 'Prohledat archiv';
$lng['ticket']['nocustomer'] = 'dn vbr';
$lng['ticket']['archivesearch'] = 'Vsledky prohledvn archivu';
$lng['ticket']['noresults'] = 'Nenalezeny dn tikety';
$lng['ticket']['notmorethanxopentickets'] = 'Kvli ochran proti SPAMu nemete mt oteveno vc jak %s tiket';
$lng['ticket']['supportstatus'] = 'Status-podpory';
$lng['ticket']['supportavailable'] = '<span class="ticket_low">Nae podpora jsou k dispozici a pipraveni pomoci.</span>';
$lng['ticket']['supportnotavailable'] = '<span class="ticket_high">Nae podpora nen momentln dostupn</span>';
$lng['admin']['templates']['ticket'] = 'Upozorovac e-maily pro tikety podpory';
$lng['admin']['templates']['SUBJECT'] = 'Nahrazeno pedmtem tiketu podpory';
$lng['admin']['templates']['new_ticket_for_customer'] = 'Zkaznick upozornn, e byl tiket odesln';
$lng['admin']['templates']['new_ticket_by_customer'] = 'Administrtorsk upozornn, e byl tiket oteven zkaznkem';
$lng['admin']['templates']['new_reply_ticket_by_customer'] = 'Administrtorsk upozornn, e pila odpov na tiket od zkaznka';
$lng['admin']['templates']['new_ticket_by_staff'] = 'Zkaznick upozornn, e byl tiket oteven personlem';
$lng['admin']['templates']['new_reply_ticket_by_staff'] = 'Zkaznick upozornn na odpov na tiket od personlu';
$lng['mails']['new_ticket_for_customer']['mailbody'] = 'Ven uivateli {FIRSTNAME} {NAME},\n\nV tiket podpory s pedmtem "{SUBJECT}" byl odesln.\n\nA pijde odpov na V tiket, budete upozornni.\n\nDkujeme,\n Froxlor-Team';
$lng['mails']['new_ticket_for_customer']['subject'] = 'V tiket na podporu byl odesln';
$lng['mails']['new_ticket_by_customer']['mailbody'] = 'Mil administrtore,\n\nbyl odesln nov tiket s pedmtem "{SUBJECT}".\n\nProsm pihlate se pro oteven tiketu.\n\nDkujeme,\n Froxlor-Team';
$lng['mails']['new_ticket_by_customer']['subject'] = 'Nov tiket podpory byl odesln';
$lng['mails']['new_reply_ticket_by_customer']['mailbody'] = 'Mil administrtore,\n\ntiket podpory "{SUBJECT}" byl zodpovzen zkaznkem.\n\nProsm pihlate se pro oteven tiketu.\n\nDkujeme,\n Froxlor-Team';
$lng['mails']['new_reply_ticket_by_customer']['subject'] = 'Nov odpov na tiket podpory';
$lng['mails']['new_ticket_by_staff']['mailbody'] = 'Ven uivateli {FIRSTNAME} {NAME},\n\nbyl pro Vs oteven tiket podpory s pedmtem "{SUBJECT}".\n\nProsm pihlate se pro oteven tiketu.\n\nDkujeme,\n Froxlor-Team';
$lng['mails']['new_ticket_by_staff']['subject'] = 'Nov tiket podpory byl odesln';
$lng['mails']['new_reply_ticket_by_staff']['mailbody'] = 'Ven uivateli {FIRSTNAME} {NAME},\n\ntiket podpory s pedmtem "{SUBJECT}" byl zodpovzen nam personlem.\n\nPro peten tiketu se prosm pihlate.\n\nDkujem,\n Froxlor-Team';
$lng['mails']['new_reply_ticket_by_staff']['subject'] = 'Nov odpov na tiket podpory';
$lng['question']['ticket_reallyclose'] = 'Opravdu chcete zavt tiket "%s"?';
$lng['question']['ticket_reallydelete'] = 'Opravdu chcete smazat tiket "%s"?';
$lng['question']['ticket_reallydeletecat'] = 'Opravdu chcete smazat kategorii "%s"?';
$lng['question']['ticket_reallyarchive'] = 'Opravdu chcete pesunout tiket "%s" do archivu?';
$lng['error']['mysubject'] = '\'' . $lng['ticket']['subject'] . '\'';
$lng['error']['mymessage'] = '\'' . $lng['ticket']['message'] . '\'';
$lng['error']['mycategory'] = '\'' . $lng['ticket']['category'] . '\'';
$lng['error']['nomoreticketsavailable'] = 'Pouili jste vechny dostupn tikety. Prosm kontaktujte svho administrtora.';
$lng['error']['nocustomerforticket'] = 'Nemohu vytvet tikety bez zkaznk';
$lng['error']['categoryhastickets'] = 'Kategorie stle obsahuje tikety.<br />Prosm smate tikety aby jste mohli smazat kategorii';
$lng['error']['notmorethanxopentickets'] = $lng['ticket']['notmorethanxopentickets'];
$lng['admin']['ticketsettings'] = 'Tikety-podpory nastaven';
$lng['admin']['archivelastrun'] = 'Posledn archivace tiket';
$lng['serversettings']['ticket']['noreply_email']['title'] = 'Bez odpovdn e-mailov adresa';
$lng['serversettings']['ticket']['noreply_email']['description'] = 'Odeslatelova adresa pro tikety podpory, vtinou nco jako no-reply@domain.tld';
$lng['serversettings']['ticket']['worktime_begin']['title'] = 'Zatek prce podpory (hh:mm)';
$lng['serversettings']['ticket']['worktime_begin']['description'] = 'Start-time pokud je podpora k dispozici';
$lng['serversettings']['ticket']['worktime_end']['title'] = 'Konec prce podpory (hh:mm)';
$lng['serversettings']['ticket']['worktime_end']['description'] = 'End-time pokud je podpora k dispozici';
$lng['serversettings']['ticket']['worktime_sat'] = 'Je podpora k dispozici o sobotch?';
$lng['serversettings']['ticket']['worktime_sun'] = 'Je podpora k dispozici o nedlch?';
$lng['serversettings']['ticket']['worktime_all']['title'] = 'Podpora bez asovho omezen';
$lng['serversettings']['ticket']['worktime_all']['description'] = 'Pokud "Ano" monosti zatku a konce prce podpory bude pepsna';
$lng['serversettings']['ticket']['archiving_days'] = 'Po kolika dnech by mly bt uzaven tikety archivovny?';
$lng['customer']['tickets'] = 'Tikety podpory';

// ADDED IN 1.2.18-svn4

$lng['admin']['domain_nocustomeraddingavailable'] = 'Momentln nen mon pidat domnu. Nejdve muste pidat aspo jednoho zkaznka.';
$lng['serversettings']['ticket']['enable'] = 'Zapnout systm tiket';
$lng['serversettings']['ticket']['concurrentlyopen'] = 'Kolik tiket by mlo bt k dispozici najednou?';
$lng['error']['norepymailiswrong'] = '&quot;Bezodpovdn adresa&quot; je patn. Je povolena pouze validn e-mailov adresa.';
$lng['error']['tadminmailiswrong'] = '&quot;Ticketadmin-adresa&quot; je patn. Je povolena pouze validn e-mailov adresa.';
$lng['ticket']['awaitingticketreply'] = 'Mte %s nezodpovzench tiket podpory';

// ADDED IN 1.2.18-svn5

$lng['serversettings']['ticket']['noreply_name'] = 'Jmno odeslatele tiket v emailu';

?>
